#include <exec/types.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/graphics_protos.h>
#include <clib/dos_protos.h>

#include <intuition/gadgetclass.h>
//#include <pragma/all_lib.h>

#include </WaveTracer/WTIncl.h>

#define Project0_CNT 2

extern struct WTStdMsg *MyWTStdMsg;

extern Window *DWindow;
extern Gadget *DGadget[2];

struct Screen         *Scr = NULL;
APTR                   VisualInfo = NULL;
struct Gadget         *Project0GList = NULL;
struct Gadget         *Project0Gadgets[Project0_CNT];
struct TextAttr       *Font;
UWORD                  FontX, FontY;
UWORD                  OffX, OffY;

UWORD Project0GTypes[] = {
	CHECKBOX_KIND,
	CHECKBOX_KIND};

struct NewGadget Project0NGad[] = {
	7, 60, 21, 12, (UBYTE *)"Move Y", NULL, 9, PLACETEXT_RIGHT, NULL, NULL,
	7, 75, 21, 12, (UBYTE *)"Rotate Z", NULL, 10, PLACETEXT_RIGHT, NULL, NULL};

ULONG Project0GTags[] = {
	(GTCB_Scaled),TRUE, (GTCB_Checked),TRUE, (GA_Disabled),TRUE, (TAG_DONE),
	(GTCB_Scaled),TRUE, (TAG_DONE)};



static UWORD ComputeX( UWORD value )
{
return((UWORD)(((FontX*value)+3)/6));
}



static UWORD ComputeY(UWORD value)
{
return((UWORD)(((FontY*value)+6)/13));
}



static void ComputeFont(void)

{
Font=Scr->Font;
Font->ta_Name=(STRPTR)Scr->RastPort.Font->tf_Message.mn_Node.ln_Name;
Font->ta_YSize=FontY=Scr->RastPort.Font->tf_YSize;
FontX=Scr->RastPort.Font->tf_XSize;
OffX=Scr->WBorLeft;
OffY=Scr->RastPort.TxHeight+Scr->WBorTop+1;
}



int SetupScreen( void )
{
Scr=MyWTStdMsg->WTScreen;
ComputeFont();
if (!(VisualInfo=GetVisualInfo(Scr,TAG_DONE))) return 2;
return 0;
}



void CloseDownScreen( void )
{
if (VisualInfo)
   {
   FreeVisualInfo( VisualInfo );
   VisualInfo = NULL;
   }
}



int OpenProject0Window( void )

{
struct NewGadget	ng;
struct Gadget    *g;
UWORD             lc, tc;
UWORD             offx,offy;


offx=Scr->WBorLeft;
offy=Scr->WBorTop+Scr->RastPort.TxHeight+1;
if ( ! ( g = CreateContext( &Project0GList ))) return( 1L );
for( lc = 0, tc = 0; lc < Project0_CNT; lc++ ) 
   {
   CopyMem((char * )&Project0NGad[ lc ], (char * )&ng, (long)sizeof( struct NewGadget ));
   ng.ng_VisualInfo = VisualInfo;
   ng.ng_TextAttr   = Scr->Font;
   ng.ng_LeftEdge  += offx;
   ng.ng_TopEdge   += offy;
   Project0Gadgets[ lc ] = g = CreateGadgetA((ULONG)Project0GTypes[ lc ], g, &ng, ( struct TagItem * )&Project0GTags[ tc ] );
   while( Project0GTags[ tc ] ) tc += 2;
   tc++;
   if ( NOT g ) return( 2L );
	}
AddGList(DWindow,Project0GList,NULL,0,NULL);
return( 0L );
}



void CloseProject0Window( void )
{
RemoveGList(DWindow,DWindow->FirstGadget,NULL);
if (Project0GList)
   {
   FreeGadgets( Project0GList );
   Project0GList = NULL;
   }
}



BOOL OpenGUI(void)

{
BYTE i;


if (SetupScreen()==0) 
   {
   if (OpenProject0Window()==0) 
      {
      for (i=0; i<Project0_CNT; i++) DGadget[i]=Project0Gadgets[i];
      return TRUE;
      }
   else return FALSE;
   }
else return FALSE;
}



void CloseGUI(void)

{
CloseProject0Window();
CloseDownScreen();
};

