Program Effectmod;

USES ExecIO,Intuition,Graphics;

type BPTR=long;

var Addr1       :long;
var Data1       :^long;

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var DKnopf                              :Gadget;
var Schieber,Textgad                    :array [1..2] of Gadget;
var SImage                              :array [1..2] of Image;
var SchieberInfo                        :array [1..2] of PropInfo;
var TextInfo                            :array [1..2] of StringInfo;
var Buffer,UndoBuffer                   :array [1..2] of string[20];

var IMsg                                :^IntuiMessage;
var RawCode,GadCode,ChBit,ChID          :byte;
var i                                   :integer;
var l,BeginOffset,EndOffset             :long;
var Valid                               :boolean;


{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod","Schieber.mod"}


procedure DEFINECOMP;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do if Operator[1]=-1 then begin
         OpType:=0;
         Operator[1]:=20;
         ActWaveOp^.Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition DYNAMIC-COMPRESSOR',
                        '','','','',100,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      CREATEPROPGAD(10,76,pred(ActWaveOp^.Operator[1])*661,661,1,8,DWindow^);
      Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
      WRITE(410,77,2,0,DWindow^,'Compressionfactor');
      DKnopf:=Gadget(NIL,200,46,21,12,GADGIMAGE+GADGHIMAGE,RELVERIFY+TOGGLESELECT,
                     BOOLGADGET,WTImg^.ButtonImg1,WTImg^.ButtonImg2,NIL,0,NIL,11,0);
      if (ActWaveOp^.OpType and $80<>0) then DKnopf.Flags:=DKnopf.Flags or SELECTED;
      if (MemAAlpha[1] or MemAAlpha[3])=0 then DKnopf.Flags:=DKnopf.Flags or GADGDISABLED;
      WRITE(225,46,2,0,DWindow^,'use Alpha-Channel');
      AddGadget(DWindow,^DKnopf,NIL);
      AddGadget(DWindow,^TextGad[1],NIL);
      AddGadget(DWindow,^Schieber[1],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (Gadcode=9) or not (Schieber[1].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=succ(SchieberInfo[1].HorizPot div 661);
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
         end;
         if Gadcode=10 then begin
            val(Buffer[1],ActWaveOp^.Operator[1],i);
            if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>100 then ActWaveOp^.Operator[1]:=100;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo[1].HorizPot:=pred(ActWaveOp^.Operator[1])*661;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      if not (DKnopf.Flags and SELECTED=0) then ActWaveOp^.OpType:=$80 else ActWaveOp^.OpType:=0;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



procedure DOCOMP(SAddr,AlphaSAddr :long);

var DataA               :^byte;
var AmpFactor,MaxDelta  :real;
var MaxAmp              :long;

begin
   with MyWTStdMsg^ do begin
      if SAddr=0 then exit;
      if (ActWaveOp^.OpType and $80<>0) and (AlphaSAddr<>0) then begin
         Addr1:=AlphaSAddr+round(BeginOffset/80+0.5);
         repeat
            DataA:=ptr(Addr1); Addr1:=Addr1+1;
            DataA^:=255;
         until Addr1>=AlphaSAddr+round(EndOffset/80+0.5);
      end else begin
         MaxDelta:=ActWaveOp^.Operator[1]/5000;
         AmpFactor:=0;
         Addr1:=SAddr+BeginOffset;
         MaxAmp:=0;
         i:=0;
         Flags:=0;
         WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
         repeat
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               l:=abs(round(Data1^*AmpFactor));
               if l<=3000000 then AmpFactor:=AmpFactor+MaxDelta;
               if l> 3500000 then AmpFactor:=AmpFactor-MaxDelta;
               if l> 3000000 then AmpFactor:=AmpFactor-MaxDelta;
               Data1^:=round(Data1^*AmpFactor);
               if abs(Data1^)>MaxAmp then MaxAmp:=abs(Data1^);
               i:=i+1;
            until (Addr1>=SAddr+EndOffset) or (i>2000);
            i:=0;
            MESSAGEHANDLE;
            if WTMsgPrc^.PRC_Long1=-1 then begin
               Valid:=false;
               exit;
            end;
         until Addr1>=SAddr+EndOffset;

         if not (MaxAmp in [MAX24-100..MAX24]) then begin
            AmpFactor:=MAX24/MaxAmp;
            Addr1:=SAddr+BeginOffset;
            repeat
               repeat
                  Data1:=ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=round(Data1^*AmpFactor);
                  i:=i+1;
               until (Addr1>=SAddr+EndOffset) or (i>2000);
               i:=0;
               MESSAGEHANDLE;
               if WTMsgPrc^.PRC_Long1=-1 then begin
                  Valid:=false;
                  exit;
               end;
            until Addr1>=SAddr+BeginOffset;
         end;
      end;
   end;
end;




begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINECOMP
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Dynamic-Compressor by QXC','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Valid:=true;
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if Valid and not (ActWaveOp^.Channels and ChBit=0) then
                DOCOMP(MemA24[ChID],MemAAlpha[ChID]);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
