#include <exec/types.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTIncl.h>

#include <stdlib.h>

extern void MESSAGEHANDLE(void);

extern WTStdMsg *MyWTStdMsg;
extern LONG BeginOffset,EndOffset;
extern BOOL Valid;



void DOCOMP(LONG SAddr, LONG AlphaSAddr)

{
UBYTE *DataA;
FLOAT  AmpFactor,MaxDelta;
LONG   l,MaxAmp,Addr1;
LONG  *Data1;
WORD   i;


if (!SAddr) return;
if (((MyWTStdMsg->ActWaveOp->OpType & 0x80)==0x80) && (AlphaSAddr))
   {
   Addr1=AlphaSAddr+(LONG)(BeginOffset/80.0+0.5);
   do
      {
      DataA=(UBYTE*)Addr1; Addr1++;
      *DataA=255;
      }
   while (Addr1<AlphaSAddr+(LONG)(EndOffset/80.0+0.5));
   }
else
   {
   MaxDelta=MyWTStdMsg->ActWaveOp->Operator[0]/5000.0;
   AmpFactor=MaxDelta;
   Addr1=SAddr+BeginOffset;
   MaxAmp=0;
   i=0;
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
   do
      {
      do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         if (MaxAmp>0)
            {
            l=labs((LONG)(*Data1*AmpFactor));
            if (l<5600000) AmpFactor=AmpFactor+MaxDelta;
            if (l<5200000) AmpFactor=AmpFactor+MaxDelta;

            if (l> 7400000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 7200000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 7000000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 6800000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 6600000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 6400000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 6200000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 6000000) AmpFactor=AmpFactor-MaxDelta;
            if (l> 5800000) AmpFactor=AmpFactor-MaxDelta;
            }
         if (AmpFactor>0) *Data1=(LONG)(*Data1*AmpFactor) else AmpFactor=0;
         if (labs(*Data1)>MaxAmp) MaxAmp=labs(*Data1);
         i++
         }
      #ifdef __PPC__
         while ((Addr1<SAddr+EndOffset) && (i<20000));
      #else
         while ((Addr1<SAddr+EndOffset) && (i<2000));
      #endif      
      i=0;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
         {
         Valid=FALSE;
         return;
         }
      }
   while (Addr1<SAddr+EndOffset);

   if ((MaxAmp>MAX24) || (MaxAmp<MAX24-100))
      {
      AmpFactor=(FLOAT)MAX24/MaxAmp;
      Addr1=SAddr+BeginOffset;
      do
         {
         do
            {
            Data1=(LONG*)Addr1; Addr1=Addr1+4;
            *Data1=(LONG)(*Data1*AmpFactor);
            i++;
            }
      #ifdef __PPC__
         while ((Addr1<SAddr+EndOffset) && (i<40000));
      #else
         while ((Addr1<SAddr+EndOffset) && (i<4000));
      #endif
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
           }
         }
      while (Addr1<SAddr+EndOffset);
      }
   }
}
