Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;


var DWindow                             :^Window;
var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..3] of Gadget;
var SchieberInfo                        :array [1..3] of PropInfo;
var SImage                              :array [1..3] of Image;
var TextInfo                            :array [1..3] of StringInfo;
var Buffer,UndoBuffer                   :array [1..3] of string[20];

var IMsg                                :^IntuiMessage;
var Addr0,BeginOffset,EndOffset         :long;
var Data0                               :^long;
var RawCode,GadCode,ChBit,ChID          :byte;
var i,j                                 :integer;
var l                                   :long;
var Valid                               :boolean;

{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
"EffIncl.mod","Schieber.mod"}



procedure DOCHORUS(SAddr :long);

var Factor,Addr         :array[1..100] of real;
var Data                :array[1..100] of ^long;
var Last,j              :integer;

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      Addr0:=SAddr+BeginOffset;
      Last:=ActWaveOp^.Operator[1];
      i:=0;
      repeat
        i:=i+1;
        Addr[i]:=pred(i)*ActWaveOp^.Operator[2];
        Factor[i]:=((PlayL24-BeginOffset)/((PlayL24-BeginOffset)-(Addr[i]*4)));
      until (i=Last) or (Addr[i]*4+BeginOffset>=PlayL24);
      if Addr[i]*4>=PlayL24 then Last:=pred(i) else Last:=i;
      j:=2000;
      if ActWaveOp^.Operator[3]<1 then ActWaveOp^.Operator[3]:=1;
      if ActWaveOp^.Operator[3]>500 then ActWaveOp^.Operator[3]:=500;
      if Last>0 then repeat
         repeat
            Data0:=ptr(Addr0); Addr0:=Addr0+4;
            Data0^:=round(Data0^/100*ActWaveOp^.Operator[3]);
            for i:=1 to Last do if Addr[i]*4+BeginOffset<PlayL24 then begin
               Data[i]:=ptr((round(Addr[i])*4)+SAddr+BeginOffset);
               Addr[i]:=Addr[i]+Factor[i];
               Data0^:=Data0^-Data[i]^;
            end;
            while (Last>1) and (Addr[Last]*4+BeginOffset>=PlayL24) do Last:=Last-1;
            j:=j+1;
         until (Addr0>=SAddr+EndOffset) or (Last=0) or (j>2000);
         j:=0;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
      until (Addr0>=SAddr+EndOffset) or (Last=0);
   end;
end;



procedure DEFINECHORUS;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do begin
         if Operator[1]=-1 then Operator[1]:=17;
         if Operator[2]=-1 then Operator[2]:=21;
         if not (Operator[3] in [1..500]) then Operator[3]:=100;
         Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition CHORUS','','','','',132,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      for i:=1 to 3 do begin
         CREATEPROPGAD(10,61+i*17,pred(ActWaveOp^.Operator[i])*661,655,i,8,DWindow^);
         Buffer[i]:=intstr(ActWaveOp^.Operator[i]);
      end;
      SchieberInfo[3].HorizPot:=pred(ActWaveOp^.Operator[3])*131;
      SchieberInfo[3].HorizBody:=131;
      WRITE(410,79,2,0,DWindow^,'Voices');
      WRITE(410,95,2,0,DWindow^,'Voice-Distance');
      WRITE(410,112,2,0,DWindow^,'Level Sourcesample');

      for i:=1 to 3 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 3 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (GadCode=9) or not (Schieber[1].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=succ(SchieberInfo[1].HorizPot div 661);
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
          end;
          if GadCode=10 then begin
            val(Buffer[1],ActWaveOp^.Operator[1],j);
            if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>100 then ActWaveOp^.Operator[1]:=100;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo[1].HorizPot:=pred(ActWaveOp^.Operator[1])*661;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

         if (GadCode=11) or not (Schieber[2].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[2]:=succ(SchieberInfo[2].HorizPot div 661);
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            RefreshGadgets(^TextGad[2],DWindow,NIL);
          end;
          if GadCode=12 then begin
            val(Buffer[2],ActWaveOp^.Operator[2],j);
            if ActWaveOp^.Operator[2]<1 then ActWaveOp^.Operator[2]:=1;
            if ActWaveOp^.Operator[2]>100 then ActWaveOp^.Operator[2]:=100;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            SchieberInfo[2].HorizPot:=pred(ActWaveOp^.Operator[2])*661;
            RefreshGadgets(^Schieber[2],DWindow,NIL);
         end;

         if (GadCode=13) or not (Schieber[3].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[3]:=succ(SchieberInfo[3].HorizPot div 131);
            if ActWaveOp^.Operator[3]>500 then ActWaveOp^.Operator[3]:=500;
            Buffer[3]:=intstr(ActWaveOp^.Operator[3]);
            RefreshGadgets(^TextGad[3],DWindow,NIL);
          end;
          if GadCode=14 then begin
            val(Buffer[3],ActWaveOp^.Operator[3],j);
            if ActWaveOp^.Operator[3]<1 then ActWaveOp^.Operator[3]:=1;
            if ActWaveOp^.Operator[3]>500 then ActWaveOp^.Operator[3]:=500;
            Buffer[3]:=intstr(ActWaveOp^.Operator[3]);
            SchieberInfo[3].HorizPot:=pred(ActWaveOp^.Operator[3])*131;
            RefreshGadgets(^Schieber[3],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOP^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINECHORUS
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Chorus, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Valid:=true;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) and Valid then
                DOCHORUS(MemA24[ChID]);
               ChBit:=ChBit*2;
            end;
            PlayL24:=MemL24;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
