#include <exec/types.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/graphics_protos.h>
#include <clib/dos_protos.h>

#include <intuition/gadgetclass.h>
#include <pragma/all_lib.h>

#include </WaveTracer/WTIncl.h>

#define Project0_CNT 6
#define Project0_OldCNT 6
#define Project0_TNUM 6

extern struct WTStdMsg *MyWTStdMsg;

extern Window *DWindow;
extern Gadget *DGadget[12];
extern char  InfoTxt[12][10];

struct Screen         *Scr = NULL;
APTR                   VisualInfo = NULL;
struct Gadget         *Project0GList = NULL;
struct Gadget         *Project0Gadgets[Project0_CNT];
struct TextAttr       *Font;
UWORD                  FontX, FontY;
UWORD                  OffX, OffY;

Gadget OldGad[]={NULL,300,31,21,12,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,NULL,0,NULL,15,0,
                 NULL,300,49,21,12,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,NULL,0,NULL,16,0,
                 NULL,300,67,21,12,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,NULL,0,NULL,17,0,
                 NULL,300,85,21,12,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,NULL,0,NULL,18,0,
                 NULL,300,103,21,12,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,NULL,0,NULL,19,0,
                 NULL,300,121,21,12,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,NULL,0,NULL,20,0
                 };

struct IntuiText Project0IText[] = {
	2, 0, JAM1,0, 0, NULL, (UBYTE *)"Hz", NULL };

UWORD Project0GTypes[] = {
	CHECKBOX_KIND,
	CHECKBOX_KIND,
	CHECKBOX_KIND,
	CHECKBOX_KIND,
	CHECKBOX_KIND,
	CHECKBOX_KIND,
};

struct NewGadget Project0NGad[] = {
	275, 31, 21, 12, (UBYTE *)"Basenote", NULL, 9, PLACETEXT_LEFT, NULL, NULL,
	275, 49, 21, 12, (UBYTE *)"1st chordnote", NULL, 10, PLACETEXT_LEFT, NULL, NULL,
	275, 67, 21, 12, (UBYTE *)"2nd chordnote", NULL, 11, PLACETEXT_LEFT, NULL, NULL,
	275, 85, 21, 12, (UBYTE *)"3rd chordnote", NULL, 12, PLACETEXT_LEFT, NULL, NULL,
	275, 103, 21, 12, (UBYTE *)"4th chordnote", NULL, 13, PLACETEXT_LEFT, NULL, NULL,
	275, 121, 21, 12, (UBYTE *)"5th chordnote", NULL, 14, PLACETEXT_LEFT, NULL, NULL,
};

ULONG Project0GTags[] = {
	(GTCB_Scaled),TRUE, (GTCB_Checked),TRUE, (GA_Disabled),TRUE, (TAG_DONE),
	(GTCB_Scaled),TRUE, (TAG_DONE),
	(GTCB_Scaled),TRUE, (TAG_DONE),
	(GTCB_Scaled),TRUE, (TAG_DONE),
	(GTCB_Scaled),TRUE, (TAG_DONE),
	(GTCB_Scaled),TRUE, (TAG_DONE),
};



static UWORD ComputeX( UWORD value )
{
return((UWORD)(((FontX*value)+3)/6));
}



static UWORD ComputeY(UWORD value)
{
return((UWORD)(((FontY*value)+6)/13));
}



static void ComputeFont(void)

{
Font=Scr->Font;
Font->ta_Name=(STRPTR)Scr->RastPort.Font->tf_Message.mn_Node.ln_Name;
Font->ta_YSize=FontY=Scr->RastPort.Font->tf_YSize;
FontX=Scr->RastPort.Font->tf_XSize;
OffX=Scr->WBorLeft;
OffY=Scr->RastPort.TxHeight+Scr->WBorTop+1;
}



int SetupScreen( void )
{
Scr=MyWTStdMsg->WTScreen;
ComputeFont();
if (!(VisualInfo=GetVisualInfo(Scr,TAG_DONE))) return 2;
return 0;
}



void CloseDownScreen( void )
{
if (VisualInfo)
   {
   FreeVisualInfo( VisualInfo );
   VisualInfo = NULL;
   }
}



void Project0Render(void)

{
UBYTE      i;
IntuiText  BoxText={1,0,JAM1,0,0,NULL,NULL,NULL};


ComputeFont();
SetAPen(DWindow->RPort,0);
for (i=0; i<6; i++)
   {
   RectFill(DWindow->RPort,OffX+ComputeX(332),OffY+ComputeY(i*18+31),OffX+ComputeX(378),OffY+ComputeY(i*18+42));
   DrawBevelBox(DWindow->RPort,OffX+ComputeX(330),OffY+ComputeY(i*18+29),
                               ComputeX(50),ComputeY(15),
                               GT_VisualInfo,VisualInfo,
                               GTBB_Recessed,TRUE,
                               TAG_DONE);
   BoxText.TopEdge=OffY+ComputeY(i*18+30);
   BoxText.IText=InfoTxt[i];
   Project0IText->ITextFont=Font;
   BoxText.LeftEdge=OffX+ComputeX(355)-(IntuiTextLength(&BoxText)/2);
   PrintIText(DWindow->RPort,&BoxText,0,0);

   RectFill(DWindow->RPort,OffX+ComputeX(407),OffY+ComputeY(i*18+31),OffX+ComputeX(433),OffY+ComputeY(i*18+43));
   DrawBevelBox(DWindow->RPort,OffX+ComputeX(405),OffY+ComputeY(i*18+29),
                               ComputeX(30),ComputeY(15),
                               GT_VisualInfo,VisualInfo,
                               GTBB_Recessed,TRUE,
                               TAG_DONE);
   BoxText.TopEdge=OffY+ComputeY(i*18+30);
   BoxText.IText=InfoTxt[i+6];
   Project0IText->ITextFont=Font;
   BoxText.LeftEdge=OffX+ComputeX(419)-(IntuiTextLength(&BoxText)/2);
   PrintIText(DWindow->RPort,&BoxText,0,0);
   }
for (i=0; i<Project0_TNUM; i++)
   {
   Project0IText->ITextFont=Font;
   Project0IText->TopEdge=OffY+ComputeY(i*18+37)-(Font->ta_YSize>>1);
   Project0IText->LeftEdge=OffX+ComputeX(392)-(IntuiTextLength(Project0IText)>>1);
   PrintIText(DWindow->RPort,Project0IText,0,0);
   }
}



int OpenProject0Window( void )

{
struct NewGadget	ng;
struct Gadget    *g;
UWORD             lc, tc;
UWORD             offx,offy;


offx=Scr->WBorLeft;
offy=Scr->WBorTop+Scr->RastPort.TxHeight+1;
if ( ! ( g = CreateContext( &Project0GList ))) return( 1L );
for( lc = 0, tc = 0; lc < Project0_CNT; lc++ ) 
   {
   CopyMem((char * )&Project0NGad[ lc ], (char * )&ng, (long)sizeof( struct NewGadget ));
   ng.ng_VisualInfo = VisualInfo;
   ng.ng_TextAttr   = Scr->Font;
   ng.ng_LeftEdge  += offx;
   ng.ng_TopEdge   += offy;
   Project0Gadgets[ lc ] = g = CreateGadgetA((ULONG)Project0GTypes[ lc ], g, &ng, ( struct TagItem * )&Project0GTags[ tc ] );
   while( Project0GTags[ tc ] ) tc += 2;
   tc++;
   if ( NOT g ) return( 2L );
	}
AddGList(DWindow,Project0GList,NULL,0,NULL);

offx=Scr->WBorLeft;
offy=Scr->WBorTop+Scr->RastPort.TxHeight+1;
for (lc=0; lc<Project0_OldCNT; lc++)
   {
   OldGad[lc].GadgetRender=MyWTStdMsg->WTImg->ButtonImg3;
   OldGad[lc].LeftEdge+=offx;
   OldGad[lc].TopEdge+=offy;
   AddGadget(DWindow,&OldGad[lc],NULL);
   }
RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
//RefreshGadgets(&OldGad[Project0_OldCNT-1],DWindow,NULL);
Project0Render();
return( 0L );
}



void CloseProject0Window( void )
{
RemoveGList(DWindow,DWindow->FirstGadget,NULL);
if (Project0GList)
   {
   FreeGadgets( Project0GList );
   Project0GList = NULL;
   }
}



BOOL OpenGUI(void)

{
BYTE i;


if (SetupScreen()==0) 
   {
   if (OpenProject0Window()==0) 
      {
      for (i=0; i<Project0_CNT; i++) DGadget[i]=Project0Gadgets[i];
      for (i=0; i<Project0_OldCNT; i++) DGadget[i+Project0_CNT]=&OldGad[i];
      return TRUE;
      }
   else return FALSE;
   }
else return FALSE;
}



void CloseGUI(void)

{
CloseProject0Window();
CloseDownScreen();
};

