#include <exec/types.h>

#include <intuition/IntuitionBase.h>
#include <libraries/dos.h>

#ifdef __PPC__
   #include <clib/powerpc_protos.h>
   extern Library *PowerPCBase;
#endif

#include </WaveTracer/WTincl.h>
#include </WaveTracer/Modincl.h>

extern LONG BeginOffset,EndOffset;
extern BOOL Valid;

APTR MemAHelp;



void DOCHORD(LONG SAddr)

{
FLOAT  FreqOperator[6],ScaleStep,ScaleFactor;
UBYTE  i;
LONG   Addr1,Addr2;
LONG   *Data1,*Data2;


if ((SAddr) && (MemAHelp))
   {
   #ifdef __PPC__
      CopyMemPPC((APTR)(SAddr+BeginOffset),MemAHelp,EndOffset-BeginOffset);
   #else
      CopyMem((APTR)(SAddr+BeginOffset),MemAHelp,EndOffset-BeginOffset);
   #endif
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;

   for (i=0; i<6; i++) if (MyWTStdMsg->ActWaveOp->Operator[i]>0)
    FreqOperator[i]=10000000.0/(MyWTStdMsg->ActWaveOp->Operator[i]*2.79365);

   for (i=1; i<6; i++) if (MyWTStdMsg->ActWaveOp->Operator[i]>0)
      {
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
         {
         MyWTStdMsg->Flags=MDE_ERROR;
         Valid=FALSE;
         return;
         }
      ScaleFactor=FreqOperator[i]/FreqOperator[0];
      ScaleStep=ScaleFactor;
      Addr1=(LONG)MemAHelp; Addr2=SAddr+BeginOffset;
      do
         {
         Data1=(LONG*)(Addr1+(LONG)(ScaleStep)*4);
         Data2=(LONG*)Addr2;     Addr2=Addr2+4;
         *Data2=*Data1+*Data2;   ScaleStep=ScaleStep+ScaleFactor;
         }
      while ((Addr2<SAddr+EndOffset) && ((LONG)(ScaleStep*4)<EndOffset-BeginOffset));
      }
   }
}



void SUBDOCHORD()

{
UBYTE ChBit,ChID;


Valid=TRUE;
#ifdef __PPC__
   MemAHelp=AllocVecPPC(EndOffset-BeginOffset,0,0);
#else
   MemAHelp=AllocVec(EndOffset-BeginOffset,0);
#endif
if (!MemAHelp)
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return
   }
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_RESTOREALPHA;
MyWTStdMsg->WTMsgPrc->PRC_Long1=MyWTStdMsg->ActWaveOp->Channels;
MyWTStdMsg->WTMsgPrc->PRC_Long2=BeginOffset;
MyWTStdMsg->WTMsgPrc->PRC_Long3=EndOffset;
MESSAGEHANDLE();
ChBit=1;
for (ChID=0; ChID<6; ChID++)
   {
   if (((MyWTStdMsg->ActWaveOp->Channels & ChBit)==ChBit) && (Valid))
    DOCHORD(MyWTStdMsg->MemA24[ChID]);
   ChBit=ChBit*2;
   }
#ifdef __PPC__
  FreeVecPPC(MemAHelp);
#else
  FreeVec(MemAHelp);
#endif
MyWTStdMsg->Flags=MDE_READY;
}


