MyEWTStdMsg->Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;


var DWindow                             :^Window;
var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..3] of Gadget;
var SchieberInfo                        :array [1..3] of PropInfo;
var SImage                              :array [1..3] of Image;
var TextInfo                            :array [1..3] of StringInfo;
var Buffer,UndoBuffer                   :array [1..3] of string[20];

var IMsg                                :^IntuiMessage;
var RawCode,GadCode                     :byte;
var i,j                                 :integer;
var l                                   :long;
var Valid                               :boolean;

{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
"EffIncl.mod","Schieber.mod"}



procedure DOSTRETCH(StartOffset,EndOffset :long);

var l1,l2,Schall                :real;
var Addr11,Addr12,Addr21,Addr22 :long;
var Data11,Data12,Data21,Data22 :^long;

begin
   with MyWTStdMsg^ do begin
      Flags:=MDE_READY;
      with ActWaveOp^ do begin
         l1:=SQRT(SQR((Operator[1]/2)-10)+SQR(Operator[2]));
         l2:=SQRT(SQR((Operator[1]/2)+10)+SQR(Operator[2]));
         l1:=l2-l1;
         l2:=10000000/(SRate*2.79365);
         Schall:=(331.3*SQRT(1.004))*100;
         l1:=(l1/Schall)*l2;

         l2:=(100-Operator[3])/100;
         if (MemA24[1]=0) or (MemA24[2]=0) or (l2=1) then exit;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      j:=0;
      Addr12:=MemA24[1]+EndOffset; Addr11:=Addr12-round(l1)*4;
      Addr22:=MemA24[2]+EndOffset; Addr21:=Addr22-round(l1)*4;
      if (EndOffset<MemL24) and (EndOffset+round(l)*4<MemL24) then begin
         Addr11:=Addr11+round(l1)*4; Addr12:=Addr12+round(l1)*4;
         Addr21:=Addr21+round(l1)*4; Addr22:=Addr22+round(l1)*4;
      end;
      repeat
         repeat
            Data11:=ptr(Addr11); Addr11:=Addr11-4;
            Data12:=ptr(Addr12); Addr12:=Addr12-4;
            Data21:=ptr(Addr22); Addr21:=Addr21-4;
            Data22:=ptr(Addr22); Addr22:=Addr22-4;
            Data12^:=round(Data12^+(Data21^*l1));
            Data22^:=round(Data22^+(Data11^*l1));
            j:=j+1;
         until (j>2000) or (Addr11<=MemA24[1]) or (Addr21<=MemA24[2]);
         j:=0;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
      until (Addr11<=MemA24[1]) or (Addr21<=MemA24[2]);
      PlayL24:=MemL24;
      exchange(MemA24[1],MemA24[2]);
   end;
end;



procedure DEFINESTRETCH;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do begin
         if Operator[1]=-1 then Operator[1]:=250;
         if Operator[2]=-1 then Operator[2]:=300;
         if Operator[3]=-1 then Operator[3]:=200;
         Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition BASE STRETCH','','','','',132,0,1,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      for i:=1 to 3 do begin
         CREATEPROPGAD(10,61+i*17,pred(ActWaveOp^.Operator[i])*131,131,i,8,DWindow^);
         Buffer[i]:=intstr(ActWaveOp^.Operator[i]);
      end;
      SchieberInfo[3].HorizPot:=pred(ActWaveOp^.Operator[3])*329;
      SchieberInfo[3].HorizBody:=327;
      WRITE(410,79,2,0,DWindow^,'cm Width Stereobase');
      WRITE(410,95,2,0,DWindow^,'cm Position (Height)');
      WRITE(410,112,2,0,DWindow^,'% Stereo-Stretch');

      for i:=1 to 3 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 3 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (GadCode=9) or not (Schieber[1].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=succ(SchieberInfo[1].HorizPot div 131);
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>500 then ActWaveOp^.Operator[1]:=500;
            RefreshGadgets(^TextGad[1],DWindow,NIL);
          end;
          if GadCode=10 then begin
            val(Buffer[1],ActWaveOp^.Operator[1],j);
            if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>500 then ActWaveOp^.Operator[1]:=500;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo[1].HorizPot:=pred(ActWaveOp^.Operator[1])*131;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

         if (GadCode=11) or not (Schieber[2].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[2]:=succ(SchieberInfo[2].HorizPot div 131);
            if ActWaveOp^.Operator[2]<1 then ActWaveOp^.Operator[2]:=1;
            if ActWaveOp^.Operator[2]>500 then ActWaveOp^.Operator[2]:=500;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            RefreshGadgets(^TextGad[2],DWindow,NIL);
          end;
          if GadCode=12 then begin
            val(Buffer[2],ActWaveOp^.Operator[2],j);
            if ActWaveOp^.Operator[2]<1 then ActWaveOp^.Operator[2]:=1;
            if ActWaveOp^.Operator[2]>500 then ActWaveOp^.Operator[2]:=500;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            SchieberInfo[2].HorizPot:=pred(ActWaveOp^.Operator[2])*131;
            RefreshGadgets(^Schieber[2],DWindow,NIL);
         end;

         if (GadCode=13) or not (Schieber[3].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[3]:=succ(SchieberInfo[3].HorizPot div 329);
            if ActWaveOp^.Operator[3]>200 then ActWaveOp^.Operator[3]:=200;
            Buffer[3]:=intstr(ActWaveOp^.Operator[3]);
            RefreshGadgets(^TextGad[3],DWindow,NIL);
          end;
          if GadCode=14 then begin
            val(Buffer[3],ActWaveOp^.Operator[3],j);
            if ActWaveOp^.Operator[3]<1 then ActWaveOp^.Operator[3]:=1;
            if ActWaveOp^.Operator[3]>200 then ActWaveOp^.Operator[3]:=200;
            Buffer[3]:=intstr(ActWaveOp^.Operator[3]);
            SchieberInfo[3].HorizPot:=pred(ActWaveOp^.Operator[3])*329;
            RefreshGadgets(^Schieber[3],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags in [MDC_DEFINEIT,MDC_DOIT]) and (ActiveMode=MD_MONO) then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'BaseStretch needs at least',
                              '2.0 Stereo to stretch stereo-base!','','OK','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Flags:=MDE_ERROR;
         end else if Flags=MDC_DEFINEIT then DEFINESTRETCH
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'BaseStretch, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Valid:=true;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            DOSTRETCH(WTMsgPrc^.PRC_Long1,WTMsgPrc^.PRC_Long2);
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
