// Program Effectmod;

#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>

#include <pragma/all_lib.h>

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <inttostr.h>

#include </WaveTracer/ModIncl.h>

#define NEGATIVE 3
#define POSITIVE 0

extern void DOSTRETCH(LONG StartOffset, LONG);
extern void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt);
extern void MAKEBORDER(Window *Wind, UWORD LEdge, UWORD TEdge, UWORD REdge, UWORD BEdge, UBYTE Color);

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;


PropInfo   SchieberInfo[3]={FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0};
Image      SImage[3];
char       Buffer[3][20],UndoBuffer[3][20];
StringInfo TextInfo[3]={(UBYTE*)Buffer[0],(UBYTE*)UndoBuffer[0],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[1],(UBYTE*)UndoBuffer[1],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[2],(UBYTE*)UndoBuffer[2],0,9,0,0,0,0,0,0,NULL,0,NULL};
Gadget     Schieber[3]={NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[0],
                        NULL,NULL,0,&SchieberInfo[0],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[1],
                        NULL,NULL,0,&SchieberInfo[1],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[2],
                        NULL,NULL,0,&SchieberInfo[2],0,0};
Gadget     TextGad[3]={NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                       NULL,NULL,NULL,0,&TextInfo[0],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                       NULL,NULL,NULL,0,&TextInfo[1],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                       NULL,NULL,NULL,0,&TextInfo[2],0,0};



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void CREATEPROPGAD(WORD LEdge, WORD TEdge, WORD XSet, WORD XJump, WORD GadNum,
                   WORD IDOffset, Window *XWindow)

{
SImage[GadNum]=*MyWTStdMsg->WTImg->KnobImg;
Schieber[GadNum].LeftEdge=LEdge;
Schieber[GadNum].TopEdge=TEdge;
Schieber[GadNum].GadgetID=IDOffset+(GadNum+1)*2-1,0;
SchieberInfo[GadNum].HorizPot=XSet;
SchieberInfo[GadNum].HorizBody=XJump;
TextGad[GadNum].LeftEdge=LEdge+332;
TextGad[GadNum].TopEdge=TEdge+1;
TextGad[GadNum].GadgetID=IDOffset+(GadNum+1)*2,0;
strcpy(UndoBuffer[GadNum],"");
MAKEBORDER(XWindow,LEdge+330,TEdge,LEdge+394,TEdge+14,NEGATIVE);
}



void DEFINESTRETCH(void)

{
Window       *DWindow;
WORD          i;
IntuiMessage *IMsg;
Gadget       *XGadget;
UBYTE         GadCode,RawCode;

if (MyWTStdMsg->ActWaveOp->Operator[0]==-1)
   {
   MyWTStdMsg->ActWaveOp->Operator[0]=200;
   MyWTStdMsg->ActWaveOp->Operator[1]=150;
   MyWTStdMsg->ActWaveOp->Operator[2]=180;
   MyWTStdMsg->ActWaveOp->Channels=MyWTStdMsg->UsedChannels;
   }
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition BASE STRETCH");
MyWTStdMsg->WTMsgPrc->PRC_Long1=132;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldn't open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
for (i=0; i<3; i++)
   {
   CREATEPROPGAD(10,78+i*17,((MyWTStdMsg->ActWaveOp->Operator[i])-1)*131,131,i,8,DWindow);
   inttostr(MyWTStdMsg->ActWaveOp->Operator[i],Buffer[i]);
   AddGadget(DWindow,&TextGad[i],NULL);
   AddGadget(DWindow,&Schieber[i],NULL);
   }
SchieberInfo[2].HorizPot=((MyWTStdMsg->ActWaveOp->Operator[2])-1)*329;
SchieberInfo[2].HorizBody=327;
WRITE(410,79,2,0,DWindow,"cm width stereobase");
WRITE(410,95,2,0,DWindow,"cm position (base height)");
WRITE(410,112,2,0,DWindow,"% Stereo-stretch");
RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   if ((GadCode==9) || ((Schieber[0].Flags & SELECTED)==SELECTED))
      {
      MyWTStdMsg->ActWaveOp->Operator[0]=(SchieberInfo[0].HorizPot/131)+1;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[0],Buffer[0]);
      if (MyWTStdMsg->ActWaveOp->Operator[0]<1) MyWTStdMsg->ActWaveOp->Operator[0]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[0]>500) MyWTStdMsg->ActWaveOp->Operator[0]=500;
      RefreshGadgets(&TextGad[0],DWindow,NULL);
      }
   if (GadCode==10)
      {
      MyWTStdMsg->ActWaveOp->Operator[0]=strtol(Buffer[0],NULL,0);
      if (MyWTStdMsg->ActWaveOp->Operator[0]<1) MyWTStdMsg->ActWaveOp->Operator[0]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[0]>500) MyWTStdMsg->ActWaveOp->Operator[0]=500;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[0],Buffer[0]);
      SchieberInfo[0].HorizPot=(MyWTStdMsg->ActWaveOp->Operator[0]-1)*131;
      RefreshGadgets(&Schieber[0],DWindow,NULL);
      }

   if ((GadCode==11) || ((Schieber[1].Flags & SELECTED)==SELECTED))
      {
      MyWTStdMsg->ActWaveOp->Operator[1]=(SchieberInfo[1].HorizPot/131)+1;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[1],Buffer[1]);
      if (MyWTStdMsg->ActWaveOp->Operator[1]<1) MyWTStdMsg->ActWaveOp->Operator[1]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[1]>500) MyWTStdMsg->ActWaveOp->Operator[1]=500;
      RefreshGadgets(&TextGad[1],DWindow,NULL);
      }
   if (GadCode==12)
      {
      MyWTStdMsg->ActWaveOp->Operator[1]=strtol(Buffer[1],NULL,0);
      if (MyWTStdMsg->ActWaveOp->Operator[1]<1) MyWTStdMsg->ActWaveOp->Operator[1]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[1]>500) MyWTStdMsg->ActWaveOp->Operator[1]=500;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[1],Buffer[1]);
      SchieberInfo[1].HorizPot=(MyWTStdMsg->ActWaveOp->Operator[1]-1)*131;
      RefreshGadgets(&Schieber[1],DWindow,NULL);
      }

   if ((GadCode==13) || ((Schieber[2].Flags & SELECTED)==SELECTED))
      {
      MyWTStdMsg->ActWaveOp->Operator[2]=(SchieberInfo[2].HorizPot/329)+1;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[2],Buffer[2]);
      if (MyWTStdMsg->ActWaveOp->Operator[2]<1) MyWTStdMsg->ActWaveOp->Operator[2]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[2]>200) MyWTStdMsg->ActWaveOp->Operator[2]=200;
      RefreshGadgets(&TextGad[2],DWindow,NULL);
      }
   if (GadCode==14)
      {
      MyWTStdMsg->ActWaveOp->Operator[2]=strtol(Buffer[2],NULL,0);
      if (MyWTStdMsg->ActWaveOp->Operator[2]<1) MyWTStdMsg->ActWaveOp->Operator[2]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[2]>200) MyWTStdMsg->ActWaveOp->Operator[2]=200;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[2],Buffer[2]);
      SchieberInfo[2].HorizPot=(MyWTStdMsg->ActWaveOp->Operator[2]-1)*329;
      RefreshGadgets(&Schieber[2],DWindow,NULL);
      }

   }
while (!((GadCode==1) || (GadCode==2) || (RawCode==68) || (RawCode==69)));
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_LEAVEWIN;
MyWTStdMsg->WTMsgPrc->PRC_Long1=RawCode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=GadCode;
MyWTStdMsg->WTMsgPrc->PRC_NewPtr=DWindow;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==1) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_CANCELLED;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (GfxBase) && (IntuitionBase))
   {
   if (CREATEPORTS(PORT_EFFECTMOD))
      {
      if (MyWTStdMsg->Version==VERSION_EFFECTMOD)
         {
         if (MyWTStdMsg->ActiveMode==MD_MONO)
            {
            SENDERROR("At least 2.0 Stereo soundmode is required");
            MyWTStdMsg->Flags=MDE_ERROR;
            }
         else if (MyWTStdMsg->Flags==MDC_DEFINEIT) DEFINESTRETCH()
         else if (MyWTStdMsg->Flags==MDC_DOIT)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"BaseStretch, ");
            strcat(MyWTStdMsg->WTMsgPrc->PRC_Str1,COPYRIGHT);
            MESSAGEHANDLE();
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETMARKOFFSET;
            MESSAGEHANDLE();
            DOSTRETCH(MyWTStdMsg->WTMsgPrc->PRC_Long1,MyWTStdMsg->WTMsgPrc->PRC_Long2);
            }
         else MyWTStdMsg->Flags=MDE_NO_MEMORY;
         MESSAGEHANDLE();
         }
      else
         {
         MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
         MESSAGEHANDLE();
         }
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   if (DOSBase) CloseLibrary((Library*)DOSBase);
   if (GfxBase) CloseLibrary((Library*)GfxBase);
   if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);   
   }
}

