Program Effectmod;

USES Intuition,Graphics,ExecIO;

{$incl "libraries/dos.h","exec/memory.h"}

const FLAG_DIFFUS=1;
const FLAG_REVERSELOOP=2;

type r_Field_2D=record
   SName        :string[250];
   LoadFlags    :byte;
   LoadChannel  :byte;
   Level        :integer;
end;

var DWindow                             :^Window;
var Field_2D                            :^r_Field_2D;

var XGadget                             :^Gadget;
var DKnopf                              :array [9..11] of Gadget;
var TextGad,Schieber                    :array [1..2] of Gadget;
var SImage                              :array [1..2] of Image;
var SchieberInfo                        :array [1..2] of PropInfo;
var TextInfo                            :array [1..2] of StringInfo;
var Buffer,UndoBuffer                   :array [1..2] of string[10];
var PathFR                              :string[150];
var FHandle                             :BPTR;

var IMsg                        :^IntuiMessage;
var RawCode,GadCode             :byte;
var i                           :integer;
var l                           :long;
var MsgGone                     :boolean;

{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod","Schieber.mod"}

var LoaderWTStdMsg              :WTStdMsg;


procedure DOBG;

var XFactor                             :real;
var Addr1,AddrX,SSize                   :long;
var Data,DataX                          :^long;
var reverse,ChBit,ChID,MyChannels       :byte;
var Mem24,BeginOffset,EndOffset         :long;

begin
   with MyWTStdMsg^ do begin
LoaderWTStdMsg:=MyWTStdMsg^;
      if ActWaveOp^.MemAData=0 then begin
         Flags:=MDE_ERROR; exit;
      end;
      Field_2D:=ptr(ActWaveOp^.MemAData);
      FHandle:=DosOpen(Field_2D^.SName,MODE_OLDFILE);
      if FHandle=0 then begin
         Flags:=MDE_FILEERROR; exit;
      end;
      Flags:=0;
      LoaderWTStdMsg.Version:=VERSION_LOADER;
      LoaderWTStdMsg.Flags:=MDC_DEFINEIT;
      LoaderWTStdMsg.ActFhandle:=FHandle;
      LoaderWTStdMsg.ActiveMode:=MD_MONO;
      WTMsgPrc^:=MsgPrc(WTM_HANDLEMOD,PORT_LOADER,'LOADER/UNIVERSAL_IFF','','','',
                        addr(LoaderWTStdMsg),0,0,0,0,NIL);
      MESSAGEHANDLE;
      if LoaderWTStdMsg.Flags<>MDE_READY then begin
         Flags:=MDE_ERROR;
         DosClose(FHandle);
         exit;
      end;;
      if (Field_2D^.LoadChannel and LoaderWTStdMsg.ActiveChannels)=0 then begin
         Flags:=MDE_CHANNELERROR;
         DosClose(FHandle);
         exit;
      end;
      SSize:=LoaderWTStdMsg.ActWaveOp^.Operator[1]*4;
      Mem24:=AllocMem(SSize,MEMF_CLEAR);
      if Mem24=0 then begin
         Flags:=MDE_NO_MEMORY;
         DosClose(FHandle);
         exit;
      end;
      Field_2D^.LoadChannel:=LoaderWTStdMsg.ActiveChannels and Field_2D^.LoadChannel;
      case Field_2D^.LoadChannel of
         CH_LEFT:   ChID:=1;
         CH_RIGHT:  ChID:=2;
         CH_CENTER: ChID:=3;
         CH_SLEFT:  ChID:=4;
         CH_SRIGHT: ChID:=5;
         CH_SUB:    ChID:=6;
         otherwise begin
            Flags:=MDE_ERROR;
            DosClose(FHandle);
            exit;
         end;
      end;
      repeat
      until FindPort(PORT_LOADER)=NIL;
      LoaderWTStdMsg.MemA24[ChID]:=Mem24;
      LoaderWTStdMsg.PlayL24:=SSize;
      LoaderWTStdMsg.MemL24:=SSize;
      LoaderWTStdMsg.ActiveChannels:=Field_2D^.LoadChannel;
      LoaderWTStdMsg.Flags:=MDC_DOIT;
      LoaderWTStdMsg.ActFhandle:=FHandle;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_HANDLEMOD,PORT_LOADER,'LOADER/UNIVERSAL_IFF','','','',
                        addr(LoaderWTStdMsg),0,0,0,0,NIL);
      MESSAGEHANDLE;
      DosClose(FHandle);
      if LoaderWTStdMsg.Flags<>MDE_READY then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      XFactor:=Field_2D^.Level/100;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      BeginOffset:=WTMsgPrc^.PRC_Long1;
      EndOffset:=WTMsgPrc^.PRC_Long2;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_RESTOREALPHA,'','','','','',
                        ActWaveOp^.Channels,BeginOffset,EndOffset,0,0,NIL);
      MESSAGEHANDLE;
      ChBit:=1;
      for ChID:=1 to 6 do begin
         Reverse:=0;
         if (MemA24[ChID]>0) and (ActWaveOp^.Channels and ChBit=ChBit) then begin
            Addr1:=MemA24[ChID]+BeginOffset;
            AddrX:=Mem24;
            if not (Field_2D^.LoadFlags and FLAG_DIFFUS=0) then AddrX:=AddrX+(ChID*16);
            while AddrX>Mem24+SSize do AddrX:=AddrX-12;
            repeat
               Data:=ptr(Addr1);   Addr1:=Addr1+4;
               DataX:=ptr(AddrX);
               if Reverse=0 then AddrX:=AddrX+4 else AddrX:=AddrX-4;
               if Reverse=0 then Data^:=Data^+round(DataX^*XFactor)
                            else Data^:=Data^-round(DataX^*XFactor);
               if (AddrX>=Mem24+SSize-4) or (AddrX>=Mem24+LoaderWTStdMsg.Release-4)
               or (AddrX<=Mem24) or
               ((Reverse=1) and (AddrX<=Mem24+LoaderWTStdMsg.Sustain)) then begin
                  if not (Field_2D^.LoadFlags and FLAG_REVERSELOOP=0) then Reverse:=1-Reverse
                  else AddrX:=Mem24+LoaderWTStdMsg.Sustain
               end;
            until Addr1>=MemA24[ChID]+EndOffset;
         end;
         ChBit:=ChBit*2;
      end;
      FreeMem(Mem24,SSize);
      Flags:=MDE_READY;
   end;
end;



procedure DEFINEBG;

function SAMPLEREQ:Boolean;

var RealIFF     :boolean;

begin
   SAMPLEREQ:=false;
   with Field_2D^ do with MyWTStdMsg^ do begin
      repeat
         Flags:=0;
         WTMsgPrc^:=MsgPrc(WTM_FILEREQ,'',Field_2D^.SName,'','','LOAD IFF-sample',
                           0,0,0,0,0,NIL);
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1<>-1 then Field_2D^.SName:=WTMsgPrc^.PRC_Str1 else begin
            Flags:=MDE_CANCELLED;
            exit;
         end;
         FHandle:=DosOpen(SName,MODE_OLDFILE);
         if FHandle<>0 then begin
            Flags:=0;
            LoaderWTStdMsg.Flags:=MDC_DEFINEIT;
            LoaderWTStdMsg.ActFhandle:=FHandle;
            MyWTStdMsg^.WTMsgPrc^:=MsgPrc(WTM_HANDLEMOD,PORT_LOADER,'LOADER/UNIVERSAL_IFF','','','',
                                          addr(LoaderWTStdMsg),0,0,0,0,NIL);
            MESSAGEHANDLE;
            DosClose(FHandle);
            if LoaderWTStdMsg.Flags<>MDE_READY then RealIFF:=false else RealIFF:=true;
            LoadChannel:=LoaderWTStdMsg.ActiveChannels;
            if not (LoadChannel in [CH_LEFT,CH_RIGHT,CH_CENTER,CH_SLEFT,
                    CH_SRIGHT,CH_SUB]) and (LoaderWTStdMsg.ActiveChannels>0) then repeat
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_CHANNELREQ,'Please select a channel!','','','','',
                                 LoaderWTStdMsg.ActiveChannels,CH_LEFT+CH_CENTER,0,0,0,NIL);
               MESSAGEHANDLE;
               LoadChannel:=WTMsgPrc^.PRC_Long1;
            until (LoadChannel in [CH_LEFT,CH_RIGHT,CH_CENTER,CH_SLEFT,
                   CH_SRIGHT,CH_SUB]) or (WTMsgPrc^.PRC_Long1=-1);
            if WTMsgPrc^.PRC_Long1=-1 then exit;
         end else RealIFF:=false;
      until RealIFF;
   end;
   SAMPLEREQ:=true;
end;



begin
   with MyWTStdMsg^ do begin
      if ActWaveOp^.MemAData=0 then with ActWaveOp^ do begin
         MemAData:=AllocMem(sizeof(r_Field_2D),MEMF_CLEAR);
         if MemAData=0 then begin
            Flags:=MDE_NO_MEMORY;
            exit;
         end;
         ChunkSize:=WOP_BIG;
         MemLData:=sizeof(r_Field_2D);
         Field_2D:=ptr(ActWaveOp^.MemAData);
         Field_2D^:=r_Field_2D('',FLAG_DIFFUS,CH_LEFT,100);
         ActWaveOp^.Channels:=UsedChannels;
         if not SAMPLEREQ then begin
            Flags:=MDE_ERROR;
            exit;
         end;
      end;
      Field_2D:=ptr(ActWaveOp^.MemAData);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition BACKGROUND','','','','',105,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      for i:=1 to 2 do DKnopf[i+8]:=Gadget(NIL,160,i*16+24,21,12,GADGHIMAGE+GADGIMAGE,
                                           TOGGLESELECT+RELVERIFY,BOOLGADGET,WTImg^.ButtonImg1,
                                           WTImg^.ButtonImg2,NIL,0,Nil,i+8,0);

      if not (Field_2D^.LoadFlags and FLAG_DIFFUS=0) then DKnopf[9].Flags:=DKnopf[9].Flags+SELECTED;
      if not (Field_2D^.LoadFlags and FLAG_REVERSELOOP=0) then DKnopf[10].Flags:=DKnopf[10].Flags+SELECTED;
      DKnopf[11]:=Gadget(NIL,350,40,43,44,GADGHIMAGE+GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg3,
                        WTImg^.GImg4,NIL,0,NIL,11,0);
      CREATEPROPGAD(10,80,pred(Field_2D^.Level*131),131,1,11,DWindow^);
      Buffer[1]:=intstr(Field_2D^.Level);
      WRITE(185,40,2,0,DWindow^,'Diffuse-Sound');
      WRITE(185,56,2,0,DWindow^,'Reverse-Loop');
      WRITE(377,63,2,3,DWindow^,'IFF-Sample');
      WRITE(410,82,2,0,DWindow^,'Background-Level');
      for i:=9 to 11 do AddGadget(DWindow,^DKnopf[i],NIL);
      AddGadget(DWindow,^TextGad[1],NIL);
      AddGadget(DWindow,^Schieber[1],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; MsgGone:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               MsgGone:=true;
            End else delay(1);
         until MsgGone;

         if GadCode=11 then if SAMPLEREQ then begin end;

         if (GadCode=12)  or not (Schieber[1].Flags and SELECTED=0) then
         with Field_2D^ do begin
            Level:=succ(SchieberInfo[1].HorizPot div 131);
            if Level<1 then Level:=1;
            if Level>500 then Level:=500;
            Buffer[1]:=intstr(Level);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
         end;
         if GadCode=13 then with Field_2D^ do begin
            val(Buffer[1],Level,i);
            if Level<1 then Level:=1;
            if Level>500 then Level:=500;
            Buffer[1]:=intstr(Level);
            SchieberInfo[1].HorizPot:=pred(Level)*131;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode in [68..69]);
      Field_2D^.LoadFlags:=0;
      if not (DKnopf[9].Flags and SELECTED=0) then Field_2D^.LoadFlags:=FLAG_DIFFUS;
      if not (DKnopf[10].Flags and SELECTED=0) then Field_2D^.LoadFlags:=Field_2D^.LoadFlags+FLAG_REVERSELOOP;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   OpenLib(DosBase,'dos.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags in [MDC_DEFINEIT,MDC_DOIT] then begin
            LoaderWTStdMsg:=MyWTStdMsg^;
            with LoaderWTStdMsg do begin
               Version:=VERSION_LOADER;
               for i:=1 to 6 do begin
                  MemA16[i]:=0;    MemA24[i]:=0;
                  MemAUNDO[i]:=0;  MemAAlpha[i]:=0;
                  AlphaUNDO[i]:=0;
               end;
            end;
            if Flags=MDC_DEFINEIT then DEFINEBG
            else if Flags=MDC_DOIT then begin
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Background, '+COPYRIGHT,'','','','',
                                 0,0,0,0,0,NIL);
               MESSAGEHANDLE;
               DOBG;
            end;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(DosBase);
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
