Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod"}


var IMsg                :^IntuiMessage;
var XGadget             :^Gadget;
var MsgGone             :boolean;
var TextGad             :array [1..2] of Gadget;
var TextInfo            :array [1..2] of StringInfo;
var Buffer              :array [1..2] of string[10];
var FrameNum            :array [1..2] of long;
var GadCode,Rawcode     :byte;
var i                   :integer;
var MyWindow            :^Window;
var l                   :long;



procedure DEFINESCENE;

var MySDHeader          :^SDHeader;
var MySDBodyScene       :^SDBodyScene;


begin
   with MyWTStdMsg^ do begin
      MySDHeader:=SpecialData;
      FrameNum[1]:=1; FrameNum[2]:=2000000000;
      if MySDHeader<>NIL then repeat
         if MySDHeader^.sdh_Type=SD_SCENE then begin
            MySDBodyScene:=r_SDBodyScene(MySDHeader);
            FrameNum[1]:=MySDBodyScene^.sdb_StartFrame;
            FrameNum[2]:=MySDBodyScene^.sdb_EndFrame;
         end;
         MySDHeader:=MySDHeader^.NextSpecialData;
      until MySDHeader=NIL;
      if (FrameNum[1]=1) and (FrameNum[2]=2000000000) then begin         
         Flags:=0;
         WTMsgPrc^:=MsgPrc(WTM_ALLOC_SPECIAL_DATA,'','','','','',SD_SCENE,0,0,0,0,NIL);
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_NewPtr=NIL then begin
            Flags:=MDE_NO_MEMORY;
            exit;
         end;
         MySDBodyScene:=WTMsgPrc^.PRC_NewPtr;                 
         MySDBodyScene^:=SDBodyScene(SDHeader(NIL,sizeof(SDBodyScene),SD_SCENE),
                                     '',FrameNum[1],FrameNum[2]);
         WTMsgPrc^:=MsgPrc(WTM_SPECIAL_DATA_FOUND,'','','','','',SD_SCENE,0,0,0,0,MySDBodyScene);
         MESSAGEHANDLE;
         WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Cant find any scene-data!','Please set the correct values now!','','Ill do that!','',0,0,0,0,0,NIL);
         MESSAGEHANDLE;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'DEFINITION AnimScene','','','','',85,0,1,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Couldnt open window!','Operation cancelled!','','OK','',0,0,0,0,0,NIL);
         MESSAGEHANDLE;
         Flags:=MDE_ERROR;
         exit;
      end;
      MyWindow:=WTMsgPrc^.PRC_NewPtr;
      Buffer[1]:=intstr(FrameNum[1]); Buffer[2]:=intstr(FrameNum[2]);
      WRITE(76,41,2,0,MyWindow^,'-'); WRITE(160,41,2,0,MyWindow^,'Selected anim-scene');

      WRITE(40,60,1,3,MyWindow^,Buffer[1]); WRITE(120,60,1,3,MyWindow^,Buffer[2]);
      WRITE(76,60,2,0,MyWindow^,'-'); WRITE(160,60,2,0,MyWindow^,'Default anim-scene');

      for i:=1 to 2 do begin
         TextGad[i]:=Gadget(NIL,10+pred(i)*80,40,60,15,GADGHCOMP,_LONGINT+STRINGCENTER+$1,
                         STRGADGET,NIL,NIL,NIL,0,^TextInfo[i],i+2,0);
         TextInfo[i]:=StringInfo(^Buffer[i],^Buffer[i],0,7,0,0,0,0,0,0,NIL,0,NIL);
         MAKEBORDER(MyWindow^,9+pred(i)*80,39,70+pred(i)*80,53,NEGATIVE);
         Buffer[i]:=intstr(FrameNum[i]);
         AddGadget(MyWindow,^TextGad[i],NIL);
      end;
      RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
      repeat
         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(MyWindow^.UserPort);
         If IMsg<>Nil Then begin
            if (IMsg^.class in [GADGETDOWN,GADGETUP]) then begin
               XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg);
            MsgGone:=true;
         End else MsgGone:=false;

         for i:=1 to 2 do begin
            if GadCode=3 then begin
               val(Buffer[1],FrameNum[1],i);
               if FrameNum[1]>FrameNum[2] then FrameNum[1]:=FrameNum[2]-1;
               if FrameNum[1]<1 then FrameNum[1]:=1;
               Buffer[1]:=intstr(FrameNum[1]);
               RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
               GadCode:=4;
            end;
            if GadCode=4 then begin
               val(Buffer[2],FrameNum[2],i);
               if FrameNum[2]<FrameNum[1] then FrameNum[2]:=FrameNum[1]+1;
               Buffer[2]:=intstr(FrameNum[2]);
               RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
               GadCode:=3;
            end;
         end;

      Until (GadCode in [1,2]) or (RawCode in [68,69]);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,MyWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then begin
         MySDHeader:=SpecialData;
         if MySDHeader<>NIL then repeat
            if MySDHeader^.sdh_Type=SD_SCENE then begin
               MySDBodyScene:=r_SDBodyScene(MySDHeader);
               MySDBodyScene^.sdb_Name:='';
               MySDBodyScene^.sdb_StartFrame:=FrameNum[1];
               MySDBodyScene^.sdb_EndFrame:=FrameNum[2];
            end;
            MySDHeader:=MySDHeader^.NextSpecialData;
         until MySDHeader=NIL;
         Flags:=MDE_READY;
      end else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(DosBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINESCENE
         else if Flags=MDC_DOIT then begin
            OPos:=OPos-1;
            OEnd:=OEnd-1;
            Flags:=MDE_READY;
         end else Flags:=MDE_WRONG_MODULEVERSION;
      end;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
