// Program Effectmod;

#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>

#include <pragma/all_lib.h>

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <inttostr.h>

#include </WaveTracer/ModIncl.h>

#define NEGATIVE 3
#define POSITIVE 0

extern void DOLOOPSPEED(void);
extern void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt);
extern void MAKEBORDER(Window *Wind, UWORD LEdge, UWORD TEdge, UWORD REdge, UWORD BEdge, UBYTE Color);

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

struct DPANHeader
   {
   UWORD Version,Frames;
   UBYTE FPS,pad1,pad2,pad3;
   };
struct ANHDHeader
   {
   UBYTE Operation,Mask;
   UWORD w,h,x,y;
   LONG  AbsTime,RelTime;
   UBYTE Interleave,pad0;
   LONG  Bits;
   UBYTE pad[16];
   };

DPANHeader      DPAN={0,0,0,0,0,0};
ANHDHeader      ANHD;

BPTR  FHandle;
char  ChunkName[5]="";
LONG  BeginOffset,ChunkLength,StartFrame,EndFrame;
WORD  LoopNum;
char  s[100];
LONG  AnimSize,LastPosition[2];



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



BOOL READCHUNK(void)

{
LONG             l;


l=Read(FHandle,&ChunkName,4);
l=l+Read(FHandle,&ChunkLength,4);
if (l==8) return TRUE else return FALSE;
}



BOOL CHECKSIZE(void)

{
char s1[20];
if (MyWTStdMsg->ActWaveOp->Operator[1]*4>MyWTStdMsg->MemL24)
   {
   inttostr(MyWTStdMsg->ActWaveOp->Operator[1],s1);
   strcpy(s,"Sample is too short - please reload it with a size of ");
   strcat(s,s1);
   strcat(s1,".");
   SENDERROR(s);
   MyWTStdMsg->Flags=MDE_ERROR;
   return FALSE;
   }
else return TRUE;
};



void CALCSAMPLESIZE(LONG FrameMode)

{
MyWTStdMsg->Flags=0;
if (FrameMode==0)
   {
   MyWTStdMsg->ActWaveOp->Operator[0]=(LONG)((20000000.0/(MyWTStdMsg->SRate*2.79365))/DPAN.FPS);
   MyWTStdMsg->ActWaveOp->Operator[1]=(LONG)((((DPAN.Frames+2)*10000000.0)/(MyWTStdMsg->SRate*2.79365))/DPAN.FPS);
   }
else if (FrameMode>0)
   {
   LastPosition[0]=LastPosition[1];
   LastPosition[1]=(LONG)((ANHD.RelTime/60.0)*((10000000.0/(MyWTStdMsg->SRate*2.79365))));
   AnimSize=AnimSize+(LONG)((ANHD.RelTime/60.0)*((10000000.0/(MyWTStdMsg->SRate*2.79365))));
   }
}



BOOL SCANANIM(void)

{
LastPosition[0]=0;
LastPosition[1]=0;
AnimSize=0;
if (!MyWTStdMsg->AnimPath) return FALSE;
FHandle=Open(MyWTStdMsg->AnimPath,MODE_OLDFILE);
if (!FHandle) return FALSE;
Seek(FHandle,0,OFFSET_BEGINNING);
ChunkName[5]=(char)0;
DPAN.Frames=0;
DPAN.FPS=0;
READCHUNK();
if (!strncmp(ChunkName,"FORM",4))
   {
   Read(FHandle,&ChunkName,4);
   if (!strncmp(ChunkName,"ANIM",4))
      {
      while ((READCHUNK()) && (ChunkLength>0))
         {
         if ((ChunkLength % 2)==1) ChunkLength++;
         if (!strncmp(ChunkName,"FORM",4))
            {
            DPAN.Frames++;
            Seek(FHandle,4,OFFSET_CURRENT);
            }
         else
            {
            if (!strncmp(ChunkName,"DPAN",4))
               {
               Read(FHandle,&DPAN,sizeof(DPANHeader));
               CALCSAMPLESIZE(0);
               MyWTStdMsg->Flags=MDE_READY;
               Close(FHandle);
               return TRUE;
               }
            else if (!strncmp(ChunkName,"ANHD",4))
               {
               ChunkLength=ChunkLength-Read(FHandle,&ANHD,sizeof(ANHDHeader));
               CALCSAMPLESIZE(DPAN.Frames)
               }
            Seek(FHandle,ChunkLength,OFFSET_CURRENT);
            }   
         }
      MyWTStdMsg->Flags=MDE_READY;
      }
   else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   }
else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
MyWTStdMsg->ActWaveOp->Operator[0]=LastPosition[0]+LastPosition[1];
MyWTStdMsg->ActWaveOp->Operator[1]=AnimSize;
Close(FHandle);
return TRUE;
}



void DOLOOP(void)

{
if (!SCANANIM)
   {
   SENDERROR("No valid ANIM found - define it using AddAnim.eff!");
   MyWTStdMsg->Flags=MDE_ERROR;
   }
else
   {
   if (!CHECKSIZE()) return;
   DOLOOPSPEED();
   }
}



void DEFINELOOP(void)

{

IntuiMessage *IMsg;
Gadget       *XGadget;
BOOL          SDFound;
char          Buffer[10],UndoBuffer[10];
StringInfo    TextInfo={Buffer,UndoBuffer,0,7,0,0,0,0,0,0,NULL,0,NULL};
Gadget        TextGad={NULL,10,40,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                       NULL,NULL,NULL,0,&TextInfo,3,0};
UBYTE         GadCode,RawCode;
Window       *MyWindow;
SDHeader     *MySDHeader;
SDBodyLoop   *MySDBodyLoop;


if (!SCANANIM())
   {
   SENDERROR("No valid ANIM found - define it using AddAnim.eff!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
if (!CHECKSIZE())
   {
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
MySDHeader=MyWTStdMsg->SpecialData;
LoopNum=5;
SDFound=FALSE;
while (MySDHeader)
   {
   if (MySDHeader->sdh_Type==SD_LOOP)
      {
      MySDBodyLoop=(SDBodyLoop*)MySDHeader;
      LoopNum=MySDBodyLoop->sdb_Loop;
      SDFound=TRUE;
      }
   MySDHeader=MySDHeader->NextSpecialData;
   }
if (!SDFound)
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
   MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_LOOP;
   MESSAGEHANDLE();
   if (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
      {
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return;
      }
   MySDBodyLoop=(SDBodyLoop*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
   MySDBodyLoop->sdb_SDHeader.NextSpecialData=NULL;
   MySDBodyLoop->sdb_SDHeader.sdh_Size=sizeof(SDBodyLoop);
   MySDBodyLoop->sdb_SDHeader.sdh_Type=SD_LOOP;
   MySDBodyLoop->sdb_Loop=LoopNum;
   MySDBodyLoop->sdb_pad=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
   MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_LOOP;
   MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyLoop;
   MESSAGEHANDLE();
   }
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"DEFINITION AnimLoop");
MyWTStdMsg->WTMsgPrc->PRC_Long1=85;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldn't open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
MyWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
inttostr(LoopNum,Buffer);
WRITE(80,41,2,0,MyWindow,"Number of loops");
MAKEBORDER(MyWindow,9,39,70,53,NEGATIVE);
AddGadget(MyWindow,&TextGad,NULL);
RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(MyWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   if (GadCode==3)
      {
      LoopNum=strtol(Buffer,NULL,0);
      if (LoopNum<1) LoopNum=1;
      else if (LoopNum>30000) LoopNum=30000;
      inttostr(LoopNum,Buffer);
      RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
      }
   }
while (!((GadCode==1) || (GadCode==2) || (RawCode==68) || (RawCode==69)));
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_LEAVEWIN;
MyWTStdMsg->WTMsgPrc->PRC_Long1=RawCode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=GadCode;
MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MyWindow;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==1)
   {
   MySDHeader=MyWTStdMsg->SpecialData;
   while (MySDHeader)
      {
      if (MySDHeader->sdh_Type==SD_LOOP)
         {
         MySDBodyLoop=(SDBodyLoop*)MySDHeader;
         MySDBodyLoop->sdb_Loop=LoopNum;
         }
      MySDHeader=MySDHeader->NextSpecialData;
      }
   MyWTStdMsg->Flags=MDE_READY;
   }
else MyWTStdMsg->Flags=MDE_CANCELLED;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (GfxBase) && (IntuitionBase))
   {
   if (CREATEPORTS(PORT_EFFECTMOD))
      {
      if (MyWTStdMsg->Version==VERSION_EFFECTMOD)
         {
         if (MyWTStdMsg->Flags==MDC_DEFINEIT) DEFINELOOP();
         else if (MyWTStdMsg->Flags==MDC_DOIT)
            {
            DOLOOP();
            MyWTStdMsg->Flags=MDE_READY;
            }
         else MyWTStdMsg->Flags=MDE_NO_MEMORY;
         MESSAGEHANDLE();
         }
      else
         {
         MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
         MESSAGEHANDLE();
         }
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   if (DOSBase) CloseLibrary((Library*)DOSBase);
   if (GfxBase) CloseLibrary((Library*)GfxBase);
   if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
   }
}

