Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod","Internal.mod","schieber.mod"}


procedure GETGAD(GadID :byte; Factor,Max :word);

var GadNum      :byte;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      GadNum:=GadID*2-1;
      if (GadCode=GadNum+2) or not (Schieber[GadID].flags and SELECTED=0) then begin
         Operator[GadID]:=succ(SchieberInfo[GadID].HorizPot div Factor);
         if Operator[GadID]>Max then Operator[GadID]:=Max;
         if Operator[GadID]<1 then Operator[GadID]:=1;
         Buffer[GadID]:=intstr(Operator[GadID]);
         RefreshGadgets(^Schieber[GadID],DWindow,NIL);
      end;
      if (GadCode=GadNum+3) then begin
         val(Buffer[GadID],Operator[GadID],i);
         if Operator[GadID]>Max then Operator[GadID]:=Max;
         if Operator[GadID]<1 then Operator[GadID]:=1;
         Buffer[GadID]:=intstr(Operator[GadID]);
         SchieberInfo[GadID].HorizPot:=pred(Operator[GadID])*Factor;
         RefreshGadgets(^Schieber[GadID],DWindow,NIL);
      end;
   end;
end;



procedure CREATEBOARDGADS(Factor1,Factor2,TextNum :word);

var ChBit,i     :byte;
var s           :string[20];

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      ChBit:=1;
      for i:=1 to 7 do begin
         if i<7 then begin
            if Operator[i]<1 then Operator[i]:=1;
            l:=Operator[i]
         end else l:=Operator[1];
         Buffer[i]:=intstr(l);
         CREATEPROPGAD(10,23+17*i,pred(l)*Factor1,Factor2,i,2,DWindow^);
         if (i<7) and (MyWTStdMsg^.ActiveChannels and ChBit=0) then begin
            Schieber[i].Flags:=Schieber[i].Flags or GADGDISABLED;
            TextGad[i].Flags:=TextGad[i].Flags or GADGDISABLED;
         end;
         case i of
            1: s:='L'
            2: s:='R'
            3: s:='C'
            4: s:='SL'
            5: s:='SR'
            6: s:='Sub'
            7: s:=MyWTStdMsg^.PText[TextNum];
         end;
         WRITE(414,i*17+24,2,0,DWindow^,s);
         ChBit:=ChBit*2;
      end;
      for i:=1 to 7 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 7 do AddGadget(DWindow,^Schieber[i],NIL);
   end;
end;




procedure DOVOLUME(SAddr,AlphaSAddr,StartOffset,EndOffset :long; ChID :byte);

var Addr1,AddrA1,Check  :long;
var Data1               :^long;
var DataA1              :^byte;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      if Operator[ChID]=100 then exit;
      if ((MyWTStdMsg^.MemAAlpha[1] or MyWTStdMsg^.MemAAlpha[3])=0) or (OpType=0) then begin
         Addr1:=SAddr+StartOffset;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data1^:=Data1^ div 100 * Operator[ChID];
            if Data1^>MAX24 then Data1^:=MAX24 else if Data1^<-MAX24 then Data1^:=-MAX24
         until Addr1>=SAddr+EndOffset;
      end else begin
         AddrA1:=AlphaSAddr+StartOffset div 80;
         repeat
            DataA1:=ptr(AddrA1); AddrA1:=AddrA1+1;
            Check:=DataA1^ * Operator[ChID] div 100;
            if Check>255 then Check:=255;
            DataA1^:=Check;
         until AddrA1>=AlphaSAddr+round((EndOffset/80+0.5));
      end;
   end;
end;



procedure DEFINEVOLUME;

var s           :string;
var l           :long;
var ChBit       :byte;

begin
   if not OPENDWIN(162,0,DWindow,MyWTStdMsg^.PText[61],1,0) then exit;
   with MyWTStdMsg^.ActWaveOp^ do begin
      Operation:=9;
      if (Operator[1]=-1) then for i:=1 to 6 do Operator[i]:=100;
      CREATEBOARDGADS(131,131,62);
      DKnopf[9]:=Gadget(NIL,520,90,21,12,GADGHIMAGE+GADGIMAGE,TOGGLESELECT+RELVERIFY,
                        BOOLGADGET,MyWTStdMsg^.WTImg^.ButtonImg1,MyWTStdMsg^.WTImg^.ButtonImg2,
                        NIL,0,Nil,20,0);
      WRITE(530,106,2,3,DWindow^,MyWTStdMsg^.PText[23]);
      if (MyWTStdMsg^.MemAAlpha[1] or MyWTStdMsg^.MemAAlpha[3])=0 then DKnopf[9].Flags:=DKnopf[9].Flags or GADGDISABLED;
      if (OpType and $80=$80) then DKnopf[9].Flags:=DKnopf[9].Flags or SELECTED;
      AddGadget(DWindow,^DKnopf[9],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat

         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress;
               GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg)
         End else delay(1);

         for i:=1 to 6 do GETGAD(i,131,500);

         if (GadCode=15) or not (Schieber[7].flags and SELECTED=0) then begin
            l:=succ(SchieberInfo[7].HorizPot div 131);
            if l>500 then l:=500;
            if l<1 then l:=1;
            for i:=1 to 7 do begin
               if i<7 then Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=pred(l)*131;
            end;
            RefreshGadgets(^Schieber[7],DWindow,NIL);
         end;
         if (GadCode=16) then begin
            val(Buffer[7],l,i);
            if l>500 then l:=500;
            if l<1 then l:=1;
            for i:=1 to 7 do begin
               if i<7 then Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=pred(l)*131;
            end;
            RefreshGadgets(^Schieber[7],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      if not (DKnopf[9].Flags and SELECTED=0) then OpType:=$80 else OpType:=0;
      LEAVEDEF(RawCode,GadCode);
      Channels:=MyWTStdMsg^.ActiveChannels;
      SoundMode:=MyWTStdMsg^.ActiveMode;
      WAreaA:=MyWTStdMsg^.AreaA;
      WAreaE:=MyWTStdMsg^.AreaE;
   end;
end;


begin {*** MAIN ***}
   OpenLib(DOSBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINEVOLUME
         else if (Flags=MDC_DOIT) then begin
            Flags:=0;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) then
                DOVOLUME(MyWTStdMsg^.MemA24[ChID],MyWTStdMsg^.MemAAlpha[ChID],BeginOffset,EndOffset,ChID);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   Closelib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
