Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod","Internal.mod","schieber.mod"}


var KnopfTx :array [1..5] of IntuiText;


procedure DOECHO;

var SPos,TPos,ChBit,ChID,ACtr                   :byte;
var Steps,l,Offset,Volume,Length24,Addr1,Addr2,
    StartOffset,EndOffset,m,j                   :long;
var SAddr24                                     :array[1..8] of long;
var EStep                                       :real;


procedure RESTOREALPHA(Channels :BYTE; BeginOffset,EndOffset :LONG);

begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_RESTOREALPHA,'','','','','',Channels,BeginOffset,EndOffset,0,0,NIL);
      MESSAGEHANDLE;
   end;
end;



procedure MAKEECHO(SAddr,TAddr,ESAddr,ETAddr :long; Volume :byte);

var Addr1,Addr2         :long;
var Data1,Data2         :^long;
var EFactor,GFactor     :real;
var i                   :byte;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      if (ESAddr=0) or (ETAddr=0) then exit;
      EFactor:=(Operator[5]/100);
      EFactor:=EFactor+  (EStep* (TAddr-ETAddr-Operator[2]*4)/4);
      Addr1:=SAddr; Addr2:=TAddr;
      if (Operator[5]<>100) or (Operator[6]<>100) then begin
         while (Addr2<ETAddr+MyWTStdMsg^.MemL24) and (Addr1<ESAddr+Length24) do begin
            Data1:=ptr(Addr1);  Addr1:=Addr1+4;
            Data2:=ptr(Addr2);  Addr2:=Addr2+4;
            GFactor:=EFactor+Volume;
            Data2^:=round(((Data2^*Volume)-(Data1^*EFactor))/GFactor);
            EFactor:=EFactor+EStep;
         end;
      end else begin
         while (Addr2<ETAddr+MyWTStdMsg^.MemL24) and (Addr1<ESAddr+Length24) do begin
            Data1:=ptr(Addr1);  Addr1:=Addr1+4;
            Data2:=ptr(Addr2);  Addr2:=Addr2+4;
            Data2^:=(Data2^*Volume-Data1^) div succ(Volume);
         end;
      end;
   end;
end;



begin
{   WORKINFO(PText[109],1);}
   MyWTStdMsg^.PlayL24:=MyWTStdMsg^.MemL24;
   GETMARKOFFSET(StartOffset,EndOffset);
   Length24:=EndOffset-StartOffset;
   if MyWTStdMsg^.ActWaveOp^.Operator[2]<Length24 div 4 then with MyWTStdMsg^.ActWaveOp^ do begin
      EStep:=(Operator[6]-Operator[5])/((MyWTStdMsg^.MemL24/4-StartOffset)-Operator[2])/100;
      RESTOREALPHA(CH_LEFT+CH_RIGHT+CH_CENTER+CH_SLEFT+CH_SRIGHT,StartOffset,EndOffset);
      if OpType=1 then begin
         m:=Operator[3];
         for i:=1 to 8 do begin
            if i=5 then m:=Operator[4];
            l:=m and $7F;
            case l of
               CH_LEFT:   SAddr24[i]:=MyWTStdMsg^.MemA24[1];
               CH_RIGHT:  SAddr24[i]:=MyWTStdMsg^.MemA24[2];
               CH_CENTER: SAddr24[i]:=MyWTStdMsg^.MemA24[3];
               CH_SLEFT:  SAddr24[i]:=MyWTStdMsg^.MemA24[4];
               CH_SRIGHT: SAddr24[i]:=MyWTStdMsg^.MemA24[5];
               otherwise  SAddr24[i]:=0;
            end;
            if SAddr24[i]<>0 then SAddr24[i]:=SAddr24[i]+StartOffset;
            m:=(m-l) div 128;
         end;

         for i:=1 to 8 do if SAddr24[i]=0 then begin
            for j:=i to 7 do SAddr24[j]:=SAddr24[j+1];
            SAddr24[8]:=0;
         end;
         if SAddr24[1]=0 then exit;
         i:=1; SPos:=1; TPos:=2;
         repeat
            if SPos>8 then SPos:=1;          if TPos>8 then TPos:=1;
            if SAddr24[SPos]=0 then SPos:=1; if SAddr24[TPos]=0 then TPos:=1;
            Addr1:=SAddr24[SPos];            Addr2:=SAddr24[TPos]+(Operator[2]*4*i);
            MAKEECHO(Addr1,Addr2,SAddr24[SPos],SAddr24[TPos],2);
            SPos:=SPos+1; TPos:=TPos+1; i:=i+1;
         until i>Operator[1];
      end else begin
         ChBit:=1; ChID:=0;
         for i:=1 to 6 do begin
            if not (Channels and ChBit=0) then ChID:=i;
            SAddr24[i]:=MyWTStdMsg^.MemA24[i]+StartOffset;
            if MyWTStdMsg^.MemA24[i]=0 then SAddr24[i]:=0;
            ChBit:=ChBit*2;
         end;
         Steps:=1;
         if ChID=0 then exit;
         repeat
            Offset:=(Operator[2]*Steps)*4;
            MAKEECHO(SAddr24[ChID],SAddr24[ChID]+Offset,SAddr24[ChID],SAddr24[ChID],2);
            Steps:=Steps+1;
         until (Steps>=Operator[1]) or (Steps*Operator[2]*4>Length24);
         if MyWTStdMsg^.ActiveMode=MD_MONO then exit;
         if MyWTStdMsg^.ActiveMode in [MD_MONO,MD_STEREO,MD_3CH,MD_SURROUND] then begin
            for i:=1 to 4 do if (i<>ChID) and (MyWTStdMsg^.MemA24[i]<>0) then with MyWTStdMsg^.PosSurround^ do begin
               Volume:=round(SQRT(SQR(ChX[i]-ChX[ChID])+SQR(ChY[i]-ChY[ChID]))/10);
               Offset:=Volume*Operator[2]*4;
               MAKEECHO(SAddr24[ChID],SAddr24[i]+Offset,SAddr24[ChID],SAddr24[i],Volume);
            end;
         end else if MyWTStdMsg^.ActiveMode=MD_QUADRO then begin
            for i:=1 to 5 do if not (i in [ChID,3]) and (MyWTStdMsg^.MemA24[i]<>0) then with MyWTStdMsg^.PosQuadro^ do begin
               Volume:=round(SQRT(SQR(ChX[i]-ChX[ChID])+SQR(ChY[i]-ChY[ChID]))/10);
               Offset:=Volume*Operator[2]*4;
               MAKEECHO(SAddr24[ChID],SAddr24[i]+Offset,SAddr24[ChID],SAddr24[i],Volume);
            end;
         end else for i:=1 to 5 do if (i<>ChID) and (MyWTStdMsg^.MemA24[i]<>0) then with MyWTStdMsg^.PosAC3^ do begin
            Volume:=round(SQRT(SQR(ChX[i]-ChX[ChID])+SQR(ChY[i]-ChY[ChID]))/10);
            Offset:=Volume*Operator[2]*4;
            MAKEECHO(SAddr24[ChID],SAddr24[i]+Offset,SAddr24[ChID],SAddr24[i],Volume);
         end
      end;
   end;
end;



procedure DEFINEECHO;

var Order       :array[1..8] of byte;
var MySList     :SelectListGad;

begin
   if not OPENDWIN(182,0,DWindow,MyWTStdMsg^.PText[51],3,1) then exit;
   with MyWTStdMsg^.ActWaveOp^ do begin
      Operation:=8;
      if (Operator[1]=-1) then begin
         ChunkSize:=WOP_SMALL;
         Operator[1]:=14; Operator[2]:=900;  Operator[3]:=CH_CENTER;
         Operator[4]:=0;  Operator[5]:=130;  Operator[6]:=50;
         OpType:=1;       Channels:=CH_LEFT;
      end;
      for i:=1 to 4 do begin
         Order[i]:=Operator[3] and $7F;
         if (Order[i] and MyWTStdMsg^.ActiveChannels=0) then Order[i]:=0;
         Operator[3]:=(Operator[3]-Order[i]) div 128;
      end;
      for i:=5 to 8 do begin
         Order[i]:=Operator[4] and $7F;
         if (Order[i] and MyWTStdMsg^.ActiveChannels=0) then Order[i]:=0;
         Operator[4]:=(Operator[3]-Order[i]) div 128;
      end;
      CREATEGADS(1,1,0);
      DKnopf[9].GadgetText:=^DKnopfTx[OpType];
      for i:=1 to 2 do DKnopfTx[i]:=IntuiText(2,0,0,4,2,MyWTStdMsg^.WTScreen^.Font,MyWTStdMsg^.PText[i+51],NIL);
      MySList:=SelectListGad(DWindow,^DKnopf[9],OpType,0,0,0,ITTArr(^DKnopfTx[1],
                             ^DKnopfTx[2],NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL));
      KnopfTx[1]:=IntuiText(2,0,0,7,1,MyWTStdMsg^.WTScreen^.Font,'L',NIL);
      KnopfTx[2]:=IntuiText(2,0,0,7,1,MyWTStdMsg^.WTScreen^.Font,'R',NIL);
      KnopfTx[3]:=IntuiText(2,0,0,7,1,MyWTStdMsg^.WTScreen^.Font,'C',NIL);
      KnopfTx[4]:=IntuiText(2,0,0,4,1,MyWTStdMsg^.WTScreen^.Font,'SL',NIL);
      KnopfTx[5]:=IntuiText(2,0,0,3,1,MyWTStdMsg^.WTScreen^.Font,'SR',NIL);
      for i:=10 to 17 do begin
         DKnopf[i]:=Gadget(NIL,i*28-269,85,21,12,GADGHCOMP+GADGIMAGE,$1,
                           BOOLGADGET,MyWTStdMsg^.WTImg^.ButtonImg1,NIL,NIL,0,Nil,i,0);
         case Order[i-9] of
            CH_LEFT:   DKnopf[i].GadgetText:=^KnopfTx[1];
            CH_RIGHT:  DKnopf[i].GadgetText:=^KnopfTx[2];
            CH_CENTER: DKnopf[i].GadgetText:=^KnopfTx[3];
            CH_SLEFT:  DKnopf[i].GadgetText:=^KnopfTx[4];
            CH_SRIGHT: DKnopf[i].GadgetText:=^KnopfTx[5];
            otherwise  DKnopf[i].GadgetText:=^DKnopfTx[3];
         end;
      end;
      DKnopfTx[3]:=IntuiText(2,0,0,6,1,MyWTStdMsg^.WTScreen^.Font,'-',NIL);
      WRITE(141,60,2,0,DWindow^,MyWTStdMsg^.PText[54]);
      WRITE(232,85,2,0,DWindow^,MyWTStdMsg^.PText[55]);
      WRITE(17,97,2,0,DWindow^,'1 -> 2 -> 3 -> 4 -> 5 -> 6 -> 7 -> 8');
      ACTIVECHANNELGADS(MyWTStdMsg^.ActiveMode,Channels);
      MyWTStdMsg^.g3^.Activation:=$1; MyWTStdMsg^.g4^.Activation:=$1;
      MyWTStdMsg^.g5^.Activation:=$1; MyWTStdMsg^.g6^.Activation:=$1;
      MyWTStdMsg^.g7^.Activation:=$1; MyWTStdMsg^.g8^.Activation:=$1;
      MyWTStdMsg^.g3^.SelectRender:=MyWTStdMsg^.WTImg^.ButtonImg4;
      MyWTStdMsg^.g4^.SelectRender:=MyWTStdMsg^.WTImg^.ButtonImg4;
      MyWTStdMsg^.g5^.SelectRender:=MyWTStdMsg^.WTImg^.ButtonImg4;
      MyWTStdMsg^.g6^.SelectRender:=MyWTStdMsg^.WTImg^.ButtonImg4;
      MyWTStdMsg^.g7^.SelectRender:=MyWTStdMsg^.WTImg^.ButtonImg4;
      MyWTStdMsg^.g8^.SelectRender:=MyWTStdMsg^.WTImg^.ButtonImg4;
      if OpType=1 then begin
         MyWTStdMsg^.g3^.Flags:=MyWTStdMsg^.g3^.Flags or GADGDISABLED;
         MyWTStdMsg^.g4^.Flags:=MyWTStdMsg^.g4^.Flags or GADGDISABLED;
         MyWTStdMsg^.g5^.Flags:=MyWTStdMsg^.g5^.Flags or GADGDISABLED;
         MyWTStdMsg^.g6^.Flags:=MyWTStdMsg^.g6^.Flags or GADGDISABLED;
         MyWTStdMsg^.g7^.Flags:=MyWTStdMsg^.g7^.Flags or GADGDISABLED
      end else for i:=10 to 17 do DKnopf[i].Flags:=DKnopf[i].Flags or GADGDISABLED;
      MyWTStdMsg^.g8^.Flags:=(MyWTStdMsg^.g8^.Flags and not SELECTED) or GADGDISABLED;
      for i:=1 to 4 do begin
         DKnopf[16+i*2]:=Gadget(NIL,412,95+i*17,16,13,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,MyWTStdMsg^.WTImg^.CalcImg,NIL,NIL,0,Nil,16+i*2,0);
         DKnopf[17+i*2]:=Gadget(NIL,428,95+i*17,16,13,GADGHCOMP,$1,BOOLGADGET,NIL,NIL,NIL,0,Nil,17+i*2,0);
      end;
      for i:=1 to 4 do CREATEPROPGAD(10,94+17*i,1,1,i,25,DWindow^);
      SchieberInfo[1]:=Propinfo(FREEHORIZ,pred(Operator[1])*1680,0,1638,0,0,0,0,0,0,0);
      SchieberInfo[2]:=Propinfo(FREEHORIZ,pred(Operator[2])*8,0,8,0,0,0,0,0,0,0);
      SchieberInfo[3]:=Propinfo(FREEHORIZ,pred(Operator[5])*131,0,131,0,0,0,0,0,0,0);
      SchieberInfo[4]:=Propinfo(FREEHORIZ,pred(Operator[6])*131,0,131,0,0,0,0,0,0,0);
      WRITE(454,112,2,0,DWindow^,MyWTStdMsg^.PText[56]);   Buffer[1]:=intstr(Operator[1]);
      WRITE(454,129,2,0,DWindow^,MyWTStdMsg^.PText[57]);   Buffer[2]:=intstr(Operator[2]);
      WRITE(454,146,2,0,DWindow^,MyWTStdMsg^.PText[58]);   Buffer[3]:=intstr(Operator[5]);
      WRITE(454,163,2,0,DWindow^,MyWTStdMsg^.PText[59]);   Buffer[4]:=intstr(Operator[6]);
      for i:=1 to 4 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 4 do AddGadget(DWindow,^Schieber[i],NIL);
      for i:=9 to 25 do AddGadget(DWindow,^DKnopf[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat

         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress;
               GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg)
         End else delay(1);

         if GadCode in [3..8] then begin
            MyWTStdMsg^.g3^.Flags:=MyWTStdMsg^.g3^.Flags and not SELECTED;
            MyWTStdMsg^.g4^.Flags:=MyWTStdMsg^.g4^.Flags and not SELECTED;
            MyWTStdMsg^.g5^.Flags:=MyWTStdMsg^.g5^.Flags and not SELECTED;
            MyWTStdMsg^.g6^.Flags:=MyWTStdMsg^.g6^.Flags and not SELECTED;
            MyWTStdMsg^.g7^.Flags:=MyWTStdMsg^.g7^.Flags and not SELECTED;
            MyWTStdMsg^.g8^.Flags:=MyWTStdMsg^.g8^.Flags and not SELECTED;
            case GadCode of
               3: MyWTStdMsg^.g3^.Flags:=MyWTStdMsg^.g3^.Flags or SELECTED
               4: MyWTStdMsg^.g4^.Flags:=MyWTStdMsg^.g4^.Flags or SELECTED
               5: MyWTStdMsg^.g5^.Flags:=MyWTStdMsg^.g5^.Flags or SELECTED
               6: MyWTStdMsg^.g6^.Flags:=MyWTStdMsg^.g6^.Flags or SELECTED
               7: MyWTStdMsg^.g7^.Flags:=MyWTStdMsg^.g7^.Flags or SELECTED
               otherwise MyWTStdMsg^.g8^.Flags:=MyWTStdMsg^.g8^.Flags or SELECTED
            end;
            RefreshGadgets(^MyWTStdMsg^.g7^,DWindow,NIL);
         end;

         if GadCode=9 then begin
            Channels:=GETACTIVECHANNELS; {MD_AC3}
            OpType:=DOSELECTLIST(^MySList);
            if OpType=1 then begin
               MyWTStdMsg^.g3^.Flags:=MyWTStdMsg^.g3^.Flags or GADGDISABLED;
               MyWTStdMsg^.g4^.Flags:=MyWTStdMsg^.g4^.Flags or GADGDISABLED;
               MyWTStdMsg^.g5^.Flags:=MyWTStdMsg^.g5^.Flags or GADGDISABLED;
               MyWTStdMsg^.g6^.Flags:=MyWTStdMsg^.g6^.Flags or GADGDISABLED;
               MyWTStdMsg^.g7^.Flags:=MyWTStdMsg^.g7^.Flags or GADGDISABLED;
               for i:=10 to 17 do DKnopf[i].Flags:=DKnopf[i].Flags and not GADGDISABLED;
            end else begin
               ACTIVECHANNELGADS(MyWTStdMsg^.ActiveMode,Channels);
               MyWTStdMsg^.g8^.Flags:=(MyWTStdMsg^.g8^.Flags and not SELECTED) or GADGDISABLED;
               for i:=10 to 17 do DKnopf[i].Flags:=DKnopf[i].Flags or GADGDISABLED;
            end;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         end;

         if GadCode in [10..17] then begin
            i:=GadCode-9;
            repeat
               Order[i]:=Order[i]*2;
               if Order[i]=0 then Order[i]:=CH_LEFT;
               if Order[i]>CH_SRIGHT then Order[i]:=0;
            until not (Order[i] and MyWTStdMsg^.ActiveChannels=0) or (Order[i]=0);
            case Order[i] of
               CH_LEFT:   DKnopf[GadCode].GadgetText:=^KnopfTx[1];
               CH_RIGHT:  DKnopf[GadCode].GadgetText:=^KnopfTx[2];
               CH_CENTER: DKnopf[GadCode].GadgetText:=^KnopfTx[3];
               CH_SLEFT:  DKnopf[GadCode].GadgetText:=^KnopfTx[4];
               CH_SRIGHT: DKnopf[GadCode].GadgetText:=^KnopfTx[5];
               otherwise  DKnopf[GadCode].GadgetText:=^DKnopfTx[3];
            end;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         end;
         if GadCode=18 then if Operator[1]>1 then Buffer[1]:=intstr(Operator[1] div 2);
         if GadCode=19 then if Operator[1]<20 then Buffer[1]:=intstr(Operator[1] * 2) else Buffer[1]:='40';
         if GadCode=20 then if Operator[2]>1 then Buffer[2]:=intstr(Operator[2] div 2);
         if GadCode=21 then if Operator[2]<4001 then Buffer[2]:=intstr(Operator[2] * 2) else Buffer[2]:='8000';
         if GadCode=22 then if Operator[5]>1 then Buffer[3]:=intstr(Operator[5] div 2);
         if GadCode=23 then if Operator[5]<250 then Buffer[3]:=intstr(Operator[5] * 2) else Buffer[3]:='500';
         if GadCode=24 then if Operator[6]>1 then Buffer[4]:=intstr(Operator[6] div 2);
         if GadCode=25 then if Operator[6]<250 then Buffer[4]:=intstr(Operator[6] * 2) else Buffer[4]:='500';
         if GadCode in [18..19] then GadCode:=27;
         if GadCode in [20..21] then GadCode:=29;
         if GadCode in [22..23] then GadCode:=32;
         if GadCode in [24..25] then GadCode:=33;

         if (GadCode=26) or not (Schieber[1].flags and SELECTED=0) then begin
            Operator[1]:=succ(SchieberInfo[1].HorizPot div 1680);
            if Operator[1]<1 then Operator[1]:=1;
            if Operator[1]>40 then Operator[1]:=40;
            Buffer[1]:=intstr(Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
         end;
         if GadCode=27 then begin
            val(Buffer[1],Operator[1],i);
            if Operator[1]<1 then Operator[1]:=1;
            if Operator[1]>40 then Operator[1]:=40;
            Buffer[1]:=intstr(Operator[1]);
            SchieberInfo[1].HorizPot:=pred(Operator[1])*1680;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

         if (GadCode=28) or not (Schieber[2].flags and SELECTED=0) then begin
            Operator[2]:=succ(SchieberInfo[2].HorizPot div 8);
            if Operator[2]<1 then Operator[2]:=1;
            if Operator[2]>8000 then Operator[2]:=8000;
            Buffer[2]:=intstr(Operator[2]);
            RefreshGadgets(^TextGad[2],DWindow,NIL);
         end;
         if GadCode=29 then begin
            val(Buffer[2],Operator[2],i);
            if Operator[2]<1 then Operator[2]:=1;
            if Operator[2]>8000 then Operator[2]:=8000;
            Buffer[2]:=intstr(Operator[2]);
            SchieberInfo[2].HorizPot:=pred(Operator[2])*8;
            RefreshGadgets(^Schieber[2],DWindow,NIL);
         end;

         if (GadCode=30) or not (Schieber[3].flags and SELECTED=0) then begin
            Operator[5]:=succ(SchieberInfo[3].HorizPot div 131);
            if Operator[5]<1 then Operator[5]:=1;
            if Operator[5]>500 then Operator[5]:=500;
            Buffer[3]:=intstr(Operator[5]);
            RefreshGadgets(^TextGad[3],DWindow,NIL);
         end;
         if GadCode=31 then begin
            val(Buffer[3],Operator[5],i);
            if Operator[5]<1 then Operator[5]:=1;
            if Operator[5]>500 then Operator[5]:=500;
            Buffer[3]:=intstr(Operator[5]);
            SchieberInfo[3].HorizPot:=pred(Operator[5])*131;
            RefreshGadgets(^Schieber[3],DWindow,NIL);
         end;

         if (GadCode=32) or not (Schieber[4].flags and SELECTED=0) then begin
            Operator[6]:=succ(SchieberInfo[4].HorizPot div 131);
            if Operator[6]<1 then Operator[6]:=1;
            if Operator[6]>500 then Operator[6]:=500;
            Buffer[4]:=intstr(Operator[6]);
            RefreshGadgets(^TextGad[4],DWindow,NIL);
         end;
         if GadCode=33 then begin
            val(Buffer[4],Operator[6],i);
            if Operator[6]<1 then Operator[6]:=1;
            if Operator[6]>500 then Operator[6]:=500;
            Buffer[4]:=intstr(Operator[6]);
            SchieberInfo[4].HorizPot:=pred(Operator[6])*131;
            RefreshGadgets(^Schieber[4],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Operator[3]:=0;
      Operator[4]:=0;
      for i:=8 downto 5 do begin
         Operator[4]:=Operator[4]+Order[i];
         if i<>5 then Operator[4]:=Operator[4]*128;
      end;
      for i:=5 downto 1 do begin
         Operator[3]:=Operator[3]+Order[i];
         if i<>1 then Operator[3]:=Operator[3]*128;
      end;
      Channels:=GETACTIVECHANNELS;
      SoundMode:=MyWTStdMsg^.ActiveMode;
      WAreaA:=MyWTStdMsg^.AreaA;
      WAreaE:=MyWTStdMsg^.AreaE;
      LEAVEDEF(RawCode,GadCode);
   end;
end;



begin {*** MAIN ***}
   OpenLib(DOSBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINEECHO
         else if (Flags=MDC_DOIT) then begin
            DOECHO;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   Closelib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
