#include <exec/types.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/WTIncl.h>

#define Project0_CNT 26

extern struct WTStdMsg *MyWTStdMsg;

extern Window *DWindow;
extern Gadget *DGadget[30];
extern WORD    DspX1,DspY1,DspX2,DspY2;

struct Screen         *Scr = NULL;
APTR                   VisualInfo = NULL;
struct Gadget         *Project0GList = NULL;
struct Gadget         *Project0Gadgets[Project0_CNT];
struct TextAttr       *Font, Attr;
UWORD                  FontX, FontY;
UWORD                  OffX, OffY;

IntuiText IText1={2,0,0,60,5,NULL,"Load",NULL};
IntuiText IText2={2,0,0,60,5,NULL,"Save",NULL};
Gadget DiskGad1={NULL,496,213,43,22,GADGHIMAGE+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,&IText1,0,NULL,35,0};
Gadget DiskGad2={NULL,496,236,43,22,GADGHIMAGE+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,&IText2,0,NULL,36,0};

UWORD Project0GTypes[] = {
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	INTEGER_KIND,
	INTEGER_KIND,
	INTEGER_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND};

struct NewGadget Project0NGad[] = {
	496, 67, 22, 15, (UBYTE *)"1", NULL, 9, PLACETEXT_IN, NULL, NULL,
	531, 67, 22, 15, (UBYTE *)"2", NULL,10, PLACETEXT_IN, NULL, NULL,
	566, 67, 22, 15, (UBYTE *)"3", NULL,11, PLACETEXT_IN, NULL, NULL,
	601, 67, 22, 15, (UBYTE *)"4", NULL,12, PLACETEXT_IN, NULL, NULL,
	496, 87, 22, 15, (UBYTE *)"5", NULL,13, PLACETEXT_IN, NULL, NULL,
	531, 87, 22, 15, (UBYTE *)"6", NULL,14, PLACETEXT_IN, NULL, NULL,
	566, 87, 22, 15, (UBYTE *)"7", NULL,15, PLACETEXT_IN, NULL, NULL,
	601, 87, 22, 15, (UBYTE *)"8", NULL,16, PLACETEXT_IN, NULL, NULL,
	496, 107, 22, 15, (UBYTE *)"9", NULL,17, PLACETEXT_IN, NULL, NULL,
	531, 107, 22, 15, (UBYTE *)"10", NULL,18, PLACETEXT_IN, NULL, NULL,
	566, 107, 22, 15, (UBYTE *)"11", NULL,19, PLACETEXT_IN, NULL, NULL,
	601, 107, 22, 15, (UBYTE *)"12", NULL,20, PLACETEXT_IN, NULL, NULL,
	496, 127, 22, 15, (UBYTE *)"13", NULL,21, PLACETEXT_IN, NULL, NULL,
	531, 127, 22, 15, (UBYTE *)"14", NULL,22, PLACETEXT_IN, NULL, NULL,
	566, 127, 22, 15, (UBYTE *)"15", NULL,23, PLACETEXT_IN, NULL, NULL,
	601, 127, 22, 15, (UBYTE *)"16", NULL,24, PLACETEXT_IN, NULL, NULL,
	496, 148, 50, 18, (UBYTE *)"Pos X", NULL,25, PLACETEXT_RIGHT, NULL, NULL,
	496, 168, 50, 18, (UBYTE *)"Pos Y", NULL,26, PLACETEXT_RIGHT, NULL, NULL,
	496, 188, 50, 18, (UBYTE *)"Pos t", NULL,27, PLACETEXT_RIGHT, NULL, NULL,
	496, 264, 128, 16, (UBYTE *)"t -> linear", NULL,28, PLACETEXT_IN, NULL, NULL,
	496, 282, 128, 16, (UBYTE *)"t -> slowed down", NULL,29, PLACETEXT_IN, NULL, NULL,
	496, 300, 128, 16, (UBYTE *)"t -> accelerated", NULL,30, PLACETEXT_IN, NULL, NULL,
	496, 318, 128, 16, (UBYTE *)"t -> absolute", NULL,31, PLACETEXT_IN, NULL, NULL,
	496, 341, 128, 16, (UBYTE *)"X <-> X", NULL,32, PLACETEXT_IN, NULL, NULL,
	496, 359, 128, 16, (UBYTE *)"Y <-> Y", NULL,33, PLACETEXT_IN, NULL, NULL,
	496, 377, 128, 16, (UBYTE *)"Pos ... -> Pos 1", NULL,34, PLACETEXT_IN, NULL, NULL,};

ULONG Project0GTags[] = {
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(GTIN_Number), 0, (GTIN_MaxChars), 6, (TAG_DONE),
	(GTIN_Number), 0, (GTIN_MaxChars), 6, (TAG_DONE),
	(GTIN_Number), 0, (GTIN_MaxChars), 12, (TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE)};



static UWORD ComputeX( UWORD value )
{
return((UWORD)(((FontX*value)+3)/6));
}



static UWORD ComputeY(UWORD value)
{
return((UWORD)(((FontY*value)+6)/13));
}



static void ComputeFont( UWORD width, UWORD height )

{
Font = &Attr;
Font->ta_Name = (STRPTR)Scr->RastPort.Font->tf_Message.mn_Node.ln_Name;
Font->ta_YSize = FontY = Scr->RastPort.Font->tf_YSize;
FontX = Scr->RastPort.Font->tf_XSize;
OffX = Scr->WBorLeft;
OffY = Scr->RastPort.TxHeight + Scr->WBorTop + 1;
if (width && height)
   {
   if ((ComputeX(width)+OffX+Scr->WBorRight)>Scr->Width) goto UseTopaz;
   if ((ComputeY(height)+OffY+Scr->WBorBottom)>Scr->Height ) goto UseTopaz;
   }
return;

UseTopaz:
   Font->ta_Name = (STRPTR)"topaz.font";
   FontX = FontY = Font->ta_YSize = 8;
}



int SetupScreen( void )
{
Scr=MyWTStdMsg->WTScreen;
ComputeFont(0,0);
if (!(VisualInfo=GetVisualInfo(Scr,TAG_DONE ))) return( 2L );
return( 0L );
}



void CloseDownScreen( void )
{
if (VisualInfo)
   {
   FreeVisualInfo( VisualInfo );
   VisualInfo = NULL;
   }
}



void Project0Render( void )
{
DrawBevelBox(DWindow->RPort,DspX2+30,DspY1-5,40,DspY2-DspY1+11,
             GT_VisualInfo, VisualInfo,
             GTBB_Recessed, TRUE,
             TAG_DONE );
DrawBevelBox(DWindow->RPort,DspX1-6,DspY1-5,DspX2-DspX1+13,DspY2-DspY1+11,
             GT_VisualInfo, VisualInfo,
             GTBB_Recessed, TRUE,
             TAG_DONE );
}



int OpenProject0Window( void )

{
struct NewGadget	ng;
struct Gadget    *g;
UWORD             lc, tc;
UWORD             offx=Scr->WBorLeft,offy=Scr->WBorTop+Scr->RastPort.TxHeight+1;

if ( ! ( g = CreateContext( &Project0GList ))) return( 1L );
for( lc = 0, tc = 0; lc < Project0_CNT; lc++ ) 
   {
   CopyMem((char * )&Project0NGad[ lc ], (char * )&ng, (long)sizeof( struct NewGadget ));
   ng.ng_VisualInfo = VisualInfo;
   ng.ng_TextAttr   = Scr->Font;
   ng.ng_LeftEdge  += offx;
   ng.ng_TopEdge   += offy;
   Project0Gadgets[ lc ] = g = CreateGadgetA((ULONG)Project0GTypes[ lc ], g, &ng, ( struct TagItem * )&Project0GTags[ tc ] );
   while( Project0GTags[ tc ] ) tc += 2;
   tc++;
   if ( NOT g ) return( 2L );
	}
AddGList(DWindow,Project0GList,NULL,0,NULL);
RefreshGList(DWindow->FirstGadget,DWindow,NULL,NULL);

DiskGad1.GadgetRender=MyWTStdMsg->WTImg->GImg3;
DiskGad1.SelectRender=MyWTStdMsg->WTImg->GImg4;
DiskGad1.LeftEdge+=offx;
DiskGad1.TopEdge+=offy;
AddGadget(DWindow,&DiskGad1,NULL);
RefreshGadgets(&DiskGad1,DWindow,NULL);

DiskGad2.GadgetRender=MyWTStdMsg->WTImg->GImg3;
DiskGad2.SelectRender=MyWTStdMsg->WTImg->GImg4;
DiskGad2.LeftEdge+=offx;
DiskGad2.TopEdge+=offy;
AddGadget(DWindow,&DiskGad2,NULL);
RefreshGadgets(&DiskGad2,DWindow,NULL);

Project0Render();
return( 0L );
}



void CloseProject0Window( void )
{
RemoveGList(DWindow,DWindow->FirstGadget,NULL);
if (Project0GList)
   {
   FreeGadgets( Project0GList );
   Project0GList = NULL;
   }
}



BOOL OpenGUI(void)

{
BYTE i;


if (SetupScreen()==0) 
   {
   if (OpenProject0Window()==0) 
      {
      for (i=0; i<Project0_CNT; i++) DGadget[i]=Project0Gadgets[i];
      DGadget[Project0_CNT+1]=&DiskGad1;
      DGadget[Project0_CNT+2]=&DiskGad2;
      return TRUE;
      }
   else return FALSE;
   }
else return FALSE;
}



void CloseGUI(void)

{
CloseProject0Window();
CloseDownScreen();
};

