#include <exec/types.h>

#include <intuition/IntuitionBase.h>
#include <libraries/dos.h>

#include <stdlib.h>
#include <math.h>

#include </WaveTracer/WTincl.h>

#define DSP_YOFFSET 41

struct r_Field_3D
   {
   WORD XPos[16],YPos[16];
   LONG tPos[16],ID;
   };

extern void MESSAGEHANDLE(void);

extern WTStdMsg *MyWTStdMsg;
extern r_Field_3D *Field_3D;
extern ChCoords   *MyChCoords;
extern LONG EndOffset,BeginOffset;
extern BOOL Valid;

LONG ChCoordsX[5],ChCoordsY[5];
extern WORD DspX1,DspY1,DspX2,DspY2;



void INIT3D(void)

{
FLOAT  Factor;
BYTE   i;


if (!(MyWTStdMsg->ActWaveOp->MemAData))
   {
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   };
Field_3D=(r_Field_3D*)MyWTStdMsg->ActWaveOp->MemAData;
if (!(EndOffset-BeginOffset==Field_3D->tPos[15]*4))
   {
   Factor=(EndOffset-BeginOffset)/4.0/Field_3D->tPos[15];
   for (i=1; i<16; i++)
      {
      Field_3D->tPos[i]=(LONG)(Field_3D->tPos[i]*Factor);
      if (Field_3D->tPos[i]<=Field_3D->tPos[i-1]) Field_3D->tPos[i]=Field_3D->tPos[i-1]+1;
      }
   }
if ((MyWTStdMsg->ActiveMode<=MD_3CH) || (MyWTStdMsg->ActiveMode==MD_SURROUND)) MyChCoords=MyWTStdMsg->PosSurround
else if (MyWTStdMsg->ActiveMode==MD_QUADRO) MyChCoords=MyWTStdMsg->PosQuadro
else MyChCoords=MyWTStdMsg->PosAC3;
for (i=0; i<5; i++)
   {
   ChCoordsX[i]=MyChCoords->ChX[i]*15+190;
   ChCoordsY[i]=MyChCoords->ChY[i]*15+DSP_YOFFSET;
   }
DspX1=0; DspY1=0;
DspX2=0; DspY2=0;
for (i=0; i<5; i++)
   {
   if (ChCoordsX[i]<DspX1) DspX1=ChCoordsX[i];
   if (ChCoordsY[i]<DspY1) DspY1=ChCoordsY[i];
   if (ChCoordsX[i]>DspX2) DspX2=ChCoordsX[i];
   if (ChCoordsY[i]>DspY2) DspY2=ChCoordsY[i];
   }
DspX1=DspX1*15+190;         DspX2=DspX2*15+190;
DspY1=DspY1*15+DSP_YOFFSET; DspY2=DspY2*15+DSP_YOFFSET;
}



void DO3D(LONG SAddr, LONG AlphaSAddr, BYTE ChID)

{
LONG   Addr1,AddrA1;
LONG   RoomFactor,X,Y;
LONG  *Data1;
UBYTE *DataA1;
FLOAT  TFactor,SFactor,Step;
BYTE   ACtr,i;


Addr1=SAddr+BeginOffset;
AddrA1=AlphaSAddr+(BeginOffset/80);
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
RoomFactor=MyChCoords->ChY[3]*18;  // Grerer RoomFactor gleicht logarithmische Lautstrkeabweichungen aus
X=Field_3D->XPos[0];
Y=Field_3D->YPos[0];
TFactor=(1.0*RoomFactor-sqrt(pow(labs(X-ChCoordsX[ChID]),2)+pow(labs(Y-ChCoordsY[ChID]),2)));
ACtr=20;
for (i=0; i<15; i++) if (Addr1<SAddr+EndOffset)
   {
   MESSAGEHANDLE();
   if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
      {
      MyWTStdMsg->Flags=MDE_ERROR;
      Valid=FALSE;
      return;
      };
   SFactor=TFactor;
   X=Field_3D->XPos[i+1];
   Y=Field_3D->YPos[i+1];
   TFactor=(1.0*RoomFactor-sqrt(pow(labs(X-ChCoordsX[ChID]),2)+pow(labs(Y-ChCoordsY[ChID]),2)));
   Step=(TFactor-SFactor)/(Field_3D->tPos[i+1]-Field_3D->tPos[i]);
   Field_3D->tPos[i+1]=Field_3D->tPos[i+1]*4;
   if (!(AlphaSAddr))
      {
      do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         if (SFactor<=0) *Data1=0 else *Data1=(LONG)((*Data1*1.0/RoomFactor*SFactor)/RoomFactor*SFactor);
         SFactor=SFactor+Step;
         }
      while ((Addr1<SAddr+BeginOffset+Field_3D->tPos[i+1]) && (Addr1<SAddr+EndOffset))
      }
   else do
      {
      DataA1=(UBYTE*)AddrA1; AddrA1=AddrA1+1;  Addr1=Addr1+80;
      if (SFactor<=0) *DataA1=1 else *DataA1=(UBYTE)((*DataA1*1.0*SFactor/RoomFactor)*SFactor/RoomFactor);
      if (*DataA1==0) *DataA1=1;
      SFactor=SFactor+Step*20;
      }
   while ((Addr1<SAddr+BeginOffset+Field_3D->tPos[i+1]) && (Addr1<SAddr+EndOffset));
   Field_3D->tPos[i+1]=Field_3D->tPos[i+1]/4;
   }
MyWTStdMsg->Flags=MDE_READY;
}

