#include <exec/types.h>
#include <exec/memory.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>
#include <clib/dos_protos.h>
#include <clib/gadtools_protos.h>

#include <pragma/all_lib.h>

#define DSP_YOFFSET 41

#include <math.h>
#include <string.h>

#include </WaveTracer/ModIncl.h>

extern void INIT3D(void);
extern void DO3D(LONG SAddr, LONG AlphaSAddr, BYTE ChID);
extern BOOL OpenGUI(void);
extern void CloseGUI(void); 

struct r_Field_3D
   {
   WORD XPos[16],YPos[16];
   LONG tPos[16],ID;
   };

struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;
extern struct DOSBase *DOSBase;
struct GadToolsBase   *GadToolsBase;

Gadget     *DGadget[30];
Window     *DWindow;
LONG        BeginOffset,EndOffset,l;
BYTE        ChID,PointCode;
BOOL        Valid;
ChCoords   *MyChCoords;
r_Field_3D *Field_3D;
WORD        DspX1,DspY1,DspX2,DspY2;




void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt)

{
IntuiText IT1={StPen,0,0,LEdge,TEdge,MyWTStdMsg->WTScreen->Font,txt,NULL};

if (DMode==3) IT1.LeftEdge=LEdge-(IntuiTextLength(&IT1) / 2);
PrintIText(Wind->RPort,&IT1,0,0);
};



void CHECKDATA(void)

{
FLOAT Factor;
BYTE  i,j;

for (i=0; i<16; i++)
   {
   if (Field_3D->XPos[i]<DspX1) Field_3D->XPos[i]=DspX1;
   if (Field_3D->XPos[i]>DspX2) Field_3D->XPos[i]=DspX2;
   if (Field_3D->YPos[i]>DspY2)
      {
      Factor=1.0*Field_3D->YPos[i]/DspY2;
      for (j=0; j<16; j++) Field_3D->YPos[j]=(WORD)(((Field_3D->YPos[j]-DspY1)/Factor)+DspY1);
      }
   if (Field_3D->YPos[i]>DspY2) Field_3D->YPos[i]=DspY2;
   if (Field_3D->YPos[i]<DspY1) Field_3D->YPos[i]=DspY1; // DspY1-Field_3D->YPos[i];
   };
};



void DRAWDISPLAY(BOOL all)


{
BYTE  i;
FLOAT Factor;

if(all)
   {
   SetAPen(DWindow->RPort,1);
   RectFill(DWindow->RPort,DspX1-2,DspY1-2,DspX2+2,DspY2+2);
   RectFill(DWindow->RPort,DspX2+34,DspY1,DspX2+65,DspY2);
   
   if (MyWTStdMsg->ActiveMode>=MD_STEREO)
      {
      WRITE(190+MyChCoords->ChX[0]*15-15,35+MyChCoords->ChY[0]*15,2,0,DWindow,"L");
      WRITE(190+MyChCoords->ChX[1]*15+10,35+MyChCoords->ChY[1]*15,2,0,DWindow,"R");
      }
   if ((!(MyWTStdMsg->ActiveMode==MD_STEREO)) && (!(MyWTStdMsg->ActiveMode==MD_QUADRO)))
    WRITE(187+MyChCoords->ChX[2]*15,22+MyChCoords->ChY[2]*15,2,0,DWindow,"C");
   if (MyWTStdMsg->ActiveMode>=MD_QUADRO) WRITE(168+MyChCoords->ChX[3]*15,45+MyChCoords->ChY[3]*15,2,0,DWindow,"SL");
   if ((MyWTStdMsg->ActiveMode==MD_QUADRO) || (MyWTStdMsg->ActiveMode>=MD_AC3_Sub))
    WRITE(200+MyChCoords->ChX[4]*15,45+MyChCoords->ChY[4]*15,2,0,DWindow,"SR");
   Factor=(Field_3D->tPos[15]*1.0)/(DspY2-DspY1);
   for (i=1; i<16; i++)
      {
      SetAPen(DWindow->RPort,(i%2+2)*2);
      RectFill(DWindow->RPort,DspX2+34,DspY1+(WORD)(Field_3D->tPos[i-1]*1.0/Factor),DspX2+65,DspY1+(WORD)((Field_3D->tPos[i]*1.0)/Factor-2));
      };
   };
Move(DWindow->RPort,Field_3D->XPos[0],Field_3D->YPos[0]);
for (i=1; i<16; i++)
   {
   if (i==1) SetAPen(DWindow->RPort,3);
   if (i==2) SetAPen(DWindow->RPort,2);
   Draw(DWindow->RPort,Field_3D->XPos[i],Field_3D->YPos[i]);
   }
for (i=0; i<16; i++) RectFill(DWindow->RPort,Field_3D->XPos[i]-2,Field_3D->YPos[i]-2,Field_3D->XPos[i]+2,Field_3D->YPos[i]+2);
}



void CALCTIME(BYTE GadCode)

{
LONG  Way,X,Y;
LONG  tDiff[16];
FLOAT Divider;
BYTE  i;


if (GadCode==4)
   {
   Way=MyWTStdMsg->PlayL24/4/15;
   for (i=1; i<16; i++) Field_3D->tPos[i]=Field_3D->tPos[i-1]+Way;
   GT_SetGadgetAttrs(DGadget[18],DWindow,NULL,(GTIN_Number),Field_3D->tPos[PointCode],(TAG_DONE));
   RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
   return;
   }
Way=0;
for (i=0; i<15; i++)
   {
   X=Field_3D->XPos[i]-Field_3D->XPos[i+1];
   Y=Field_3D->YPos[i]-Field_3D->YPos[i+1];
   Way=Way+(LONG)sqrt(X*X+Y*Y);
   }
Way=Way*4;
Field_3D->tPos[1]=0;
if (Way>0) for (i=1; i<16; i++)
   {
   X=Field_3D->XPos[i-1]-Field_3D->XPos[i];
   Y=Field_3D->YPos[i-1]-Field_3D->YPos[i];
   Field_3D->tPos[i]=MyWTStdMsg->PlayL24*(LONG)sqrt(X*X+Y*Y)/Way+Field_3D->tPos[i-1];
   }
else for (i=1; i<15; i++) Field_3D->tPos[i]=Field_3D->tPos[i-1]+(Field_3D->tPos[15]/15);
if (GadCode==3)
   {
   for (i=1; i<16; i++) tDiff[i]=(LONG)((Field_3D->tPos[i]-Field_3D->tPos[i-1])/(i+1.0));
   for (i=1; i<16; i++) Field_3D->tPos[i]=Field_3D->tPos[i-1]+tDiff[i];
   Divider=Field_3D->tPos[15]/(MyWTStdMsg->PlayL24/4.0);
   for (i=1; i<16; i++) Field_3D->tPos[i]=(LONG)(Field_3D->tPos[i]/Divider);
   }
else if (GadCode==2)
   {
   for (i=1; i<16; i++) tDiff[i]=(LONG)((Field_3D->tPos[i]-Field_3D->tPos[i-1])/(17.0-i));
   for (i=1; i<16; i++) Field_3D->tPos[i]=Field_3D->tPos[i-1]+tDiff[i];
   Divider=Field_3D->tPos[15]/(MyWTStdMsg->PlayL24/4.0);
   for (i=1; i<16; i++) Field_3D->tPos[i]=(LONG)(Field_3D->tPos[i]/Divider);      
   }
Field_3D->tPos[0]=0;
Field_3D->tPos[15]=MyWTStdMsg->PlayL24/4;
for (i=1; i<16; i++) if (Field_3D->tPos[i]<=Field_3D->tPos[i-1]) Field_3D->tPos[i]=Field_3D->tPos[i-1]+1;
for (i=14; i>=0; i--) if (Field_3D->tPos[i]>=Field_3D->tPos[i+1]) Field_3D->tPos[i]=Field_3D->tPos[i+1]-1;
GT_SetGadgetAttrs(DGadget[18],DWindow,NULL,(GTIN_Number),Field_3D->tPos[PointCode],(TAG_DONE));
RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
};



void DEFINE3D(void)

{
BYTE  RawCode,GadCode;
WORD  i,OldVHPos,OldLRPos,x,y;
FLOAT Factor;
BOOL  MsgGone,Klick;
char  PathFR[250];
LONG  UnSelFlags;

BPTR  FHandle;

IntuiMessage *IMsg;
Gadget       *XGadget;



MyWTStdMsg->Flags=0;
if (MyWTStdMsg->ActWaveOp->MemAData==0)
   {
   MyWTStdMsg->ActWaveOp->MemLData=sizeof(r_Field_3D);
   MyWTStdMsg->ActWaveOp->MemAData=AllocMem(MyWTStdMsg->ActWaveOp->MemLData,MEMF_CLEAR);
   if (!(MyWTStdMsg->ActWaveOp->MemAData))
      {
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return
      }
   else MyWTStdMsg->ActWaveOp->ChunkSize=WOP_BIG;
   if ((MyWTStdMsg->ActiveMode==MD_MONO) ||
       (MyWTStdMsg->ActiveMode==MD_STEREO) ||
       (MyWTStdMsg->ActiveMode==MD_3CH) ||
       (MyWTStdMsg->ActiveMode==MD_SURROUND)) MyChCoords=MyWTStdMsg->PosSurround
   else if (MyWTStdMsg->ActiveMode==MD_QUADRO) MyChCoords=MyWTStdMsg->PosQuadro
   else MyChCoords=MyWTStdMsg->PosAC3;
   DspX1=0; DspY1=0; DspX2=0; DspY2=0;
   for (i=0; i<5; i++)
      {
      if (MyChCoords->ChX[i]<DspX1) DspX1=MyChCoords->ChX[i];
      if (MyChCoords->ChY[i]<DspY1) DspY1=MyChCoords->ChY[i];
      if (MyChCoords->ChX[i]>DspX2) DspX2=MyChCoords->ChX[i];
      if (MyChCoords->ChY[i]>DspY2) DspY2=MyChCoords->ChY[i];
      }
   DspX1=DspX1*15+190; DspX2=DspX2*15+190; DspY1=DspY1*15+25; DspY2=DspY2*15+35;
   }
DspY1+=MyWTStdMsg->WTScreen->WBorTop+MyWTStdMsg->WTScreen->RastPort.TxHeight+1;
DspY2+=MyWTStdMsg->WTScreen->WBorTop+MyWTStdMsg->WTScreen->RastPort.TxHeight+1;
l=DspY2+15;
if (l<405+MyWTStdMsg->WTScreen->WBorTop+MyWTStdMsg->WTScreen->RastPort.TxHeight+1)
 l=405+MyWTStdMsg->WTScreen->WBorTop+MyWTStdMsg->WTScreen->RastPort.TxHeight+1;

MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"");
MyWTStdMsg->WTMsgPrc->PRC_Long1=l;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!(MyWTStdMsg->WTMsgPrc->PRC_NewPtr)))
   {
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
if (OpenGUI())
   {
   UnSelFlags=DGadget[0]->Flags;
   DGadget[0]->Flags=DGadget[0]->Flags|SELECTED;
   PointCode=0;
   RefreshGList(DWindow->FirstGadget,DWindow,NULL,NULL);
   
   Field_3D=(r_Field_3D*)MyWTStdMsg->ActWaveOp->MemAData;
   if (MyWTStdMsg->ActWaveOp->Operator[1]==-1)
      {
      MyWTStdMsg->ActWaveOp->Operator[1]=0;
      for (i=0; i<16; i++)
         {
         Field_3D->XPos[i]=190;
         Field_3D->YPos[i]=DSP_YOFFSET+(i*20);
         Field_3D->tPos[i]=(MyWTStdMsg->PlayL24/60)*i;
         }
      Field_3D->tPos[15]=MyWTStdMsg->PlayL24/4;
      Field_3D->ID=1;
      }
   else if (MyWTStdMsg->PlayL24>(Field_3D->tPos[15]*4))
      {
      Factor=(MyWTStdMsg->PlayL24)/4.0/Field_3D->tPos[15];
      for (i=0; i<16; i++) Field_3D->tPos[i]=(LONG)(Field_3D->tPos[i]*Factor);
      }
   CHECKDATA();
   DRAWDISPLAY(TRUE);
   strcpy(PathFR,"EFFECTS/EFFECT-DATA/");

   do
      {
      do
         {
         RawCode=0; GadCode=0; MsgGone=FALSE; Klick=FALSE;
         IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
         if (IMsg)
            {
            if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
               {
               XGadget=(Gadget*)IMsg->IAddress;
               GadCode=XGadget->GadgetID;
               }
            if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
            if ((IMsg->Class=MOUSEBUTTONS) && (IMsg->Code==SELECTDOWN)) Klick=TRUE;
            ReplyMsg((Message*)IMsg);
            MsgGone=TRUE;
            }
         else Delay(1);
         }
      while (!MsgGone);
      
      if ((GadCode>8) && (GadCode<25))
         {
         for (i=0; i<16; i++) DGadget[i]->Flags=UnSelFlags;
         DGadget[GadCode-9]->Flags=DGadget[GadCode-9]->Flags|SELECTED;
         GT_SetGadgetAttrs(DGadget[16],DWindow,NULL,(GTIN_Number),Field_3D->XPos[GadCode-9]-190,        (TAG_DONE));
         GT_SetGadgetAttrs(DGadget[17],DWindow,NULL,(GTIN_Number),Field_3D->YPos[GadCode-9]-DSP_YOFFSET,(TAG_DONE));
         GT_SetGadgetAttrs(DGadget[18],DWindow,NULL,(GTIN_Number),Field_3D->tPos[GadCode-9],            (TAG_DONE));
         RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
         PointCode=GadCode-9;
         DRAWDISPLAY(FALSE);
         };

      if (GadCode==25)
         {
         Field_3D->XPos[PointCode]=(((struct StringInfo*)DGadget[16]->SpecialInfo)->LongInt);
         Field_3D->XPos[PointCode]=Field_3D->XPos[PointCode]+190;
         if (Field_3D->XPos[PointCode]<DspX1) Field_3D->XPos[PointCode]=DspX1;
         if (Field_3D->XPos[PointCode]>DspX2) Field_3D->XPos[PointCode]=DspX2;
         GT_SetGadgetAttrs(DGadget[16],DWindow,NULL,(GTIN_Number),Field_3D->XPos[PointCode]-190,(TAG_DONE));
         RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
         DRAWDISPLAY(TRUE);
         }

      if (GadCode==26)
         {
         Field_3D->YPos[PointCode]=(((struct StringInfo*)DGadget[17]->SpecialInfo)->LongInt);
         Field_3D->YPos[PointCode]=Field_3D->YPos[PointCode]+DSP_YOFFSET;
         if (Field_3D->YPos[PointCode]<DspY1) Field_3D->YPos[PointCode]=DspY1;
         if (Field_3D->YPos[PointCode]>DspY2) Field_3D->YPos[PointCode]=DspY2;
         GT_SetGadgetAttrs(DGadget[17],DWindow,NULL,(GTIN_Number),Field_3D->YPos[PointCode]-DSP_YOFFSET,(TAG_DONE));
         RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
         DRAWDISPLAY(TRUE);
         }

      if (GadCode==27)
         {
         Field_3D->tPos[PointCode]=(((struct StringInfo*)DGadget[18]->SpecialInfo)->LongInt);       
         Field_3D->tPos[0]=0;
         Field_3D->tPos[15]=MyWTStdMsg->PlayL24/4;
         if ((PointCode>0) && (PointCode<15))
            {
            if (Field_3D->tPos[PointCode]<=Field_3D->tPos[PointCode-1])
             Field_3D->tPos[PointCode]=Field_3D->tPos[PointCode-1]+1;
            if (Field_3D->tPos[PointCode]>=Field_3D->tPos[PointCode+1])
             Field_3D->tPos[PointCode]=Field_3D->tPos[PointCode+1]-1;
            }
         GT_SetGadgetAttrs(DGadget[18],DWindow,NULL,(GTIN_Number),Field_3D->tPos[PointCode],(TAG_DONE));
         RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
         DRAWDISPLAY(TRUE);
         }

      if ((GadCode>27) && (GadCode<32))
         {
         CALCTIME(GadCode-27);
         DRAWDISPLAY(TRUE);
         };

      if (GadCode==32)
         {
         for (i=0; i<16; i++) Field_3D->XPos[i]=380-Field_3D->XPos[i];
         DRAWDISPLAY(TRUE);
         }

      if (GadCode==33)
         {
         for (i=0; i<16; i++) Field_3D->YPos[i]=DSP_YOFFSET+DspY2-Field_3D->YPos[i];
         DRAWDISPLAY(TRUE);
         }

      if (GadCode==34)
         {
         for (i=1; i<16; i++)
            {
            Field_3D->YPos[i]=Field_3D->YPos[0];
            Field_3D->XPos[i]=Field_3D->XPos[0];
            }
         DRAWDISPLAY(TRUE);
         }

      if (GadCode==35)
         {
         MyWTStdMsg->Flags=0;
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_FILEREQ;
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,PathFR);
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"#?.3D");
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"LOAD 3D-Surround-data");
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1>-1)
            {
            strcpy(PathFR,MyWTStdMsg->WTMsgPrc->PRC_Str1);
            FHandle=Open(PathFR,MODE_OLDFILE);
            if (FHandle)
               {
               l=Read(FHandle,Field_3D,sizeof(r_Field_3D));
               Close(FHandle);
               if (l==128)
                  {
                  for (i=0; i<16; i++)
                     {
                     Field_3D->XPos[i]=Field_3D->XPos[i]*6+190;
                     Field_3D->YPos[i]=(Field_3D->YPos[i]*6+(DspY2-DspY1)*3)+DSP_YOFFSET;
                     }
                  }
               else if (!(Field_3D->ID==1)) for (i=0; i<16; i++) Field_3D->YPos[i]=Field_3D->YPos[i]-35+DSP_YOFFSET;
               CHECKDATA();
               DRAWDISPLAY(TRUE);
               }
            else
               {
               MyWTStdMsg->Flags=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,PathFR);
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Can't find file!");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
               MESSAGEHANDLE();
               }
            }
         }

      if (GadCode==36)
         {
         MyWTStdMsg->Flags=0;
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_FILEREQ;
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,PathFR);
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"#?.3D");
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"SAVE 3D-Surround-data");
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1>-1)
            {
            strcpy(PathFR,MyWTStdMsg->WTMsgPrc->PRC_Str1);
            if (strstr(PathFR,".3D")==0) strncat(PathFR,".3D",4);
            FHandle=Open(PathFR,MODE_NEWFILE);
            if (FHandle)
               {
               Write(FHandle,Field_3D,sizeof(r_Field_3D));
               Close(FHandle);
               }
            else
               {
               MyWTStdMsg->Flags=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,PathFR);
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Can't create file!");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
               MESSAGEHANDLE();
               }
            }
         }

      if (Klick)
         {
         GadCode=-1;
         for (i=0; i<16; i++) 
          if ((DWindow->MouseX>=Field_3D->XPos[i]-3) && (DWindow->MouseX<=Field_3D->XPos[i]+3) &&
              (DWindow->MouseY>=Field_3D->YPos[i]-3) && (DWindow->MouseY<=Field_3D->YPos[i]+3))
          GadCode=i;
         if ((!(PointCode==GadCode)) && (GadCode>=0))
            {
            for (i=0; i<16; i++) DGadget[i]->Flags=UnSelFlags;
            DGadget[GadCode-9]->Flags=DGadget[GadCode-9]->Flags|SELECTED;
            GT_SetGadgetAttrs(DGadget[16],DWindow,NULL,(GTIN_Number),Field_3D->XPos[GadCode]-190,        (TAG_DONE));
            GT_SetGadgetAttrs(DGadget[17],DWindow,NULL,(GTIN_Number),Field_3D->YPos[GadCode]-DSP_YOFFSET,(TAG_DONE));
            GT_SetGadgetAttrs(DGadget[18],DWindow,NULL,(GTIN_Number),Field_3D->tPos[GadCode],            (TAG_DONE));
            RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
            PointCode=GadCode;
            DRAWDISPLAY(FALSE);
            }
         GadCode=0;
         do
            {
            x=DWindow->MouseX; 
            y=DWindow->MouseY;
            if ((x>=DspX1-20) && (x<=DspX2+20) && (y>=DspY1-20) && (y<=DspY2+20))
               {
               if (x<DspX1) x=DspX1; if (x>DspX2) x=DspX2;
               if (y<DspY1) y=DspY1; if (y>DspY2) y=DspY2;
               OldLRPos=Field_3D->XPos[PointCode];
               OldVHPos=Field_3D->YPos[PointCode];
               Field_3D->XPos[PointCode]=x;
               Field_3D->YPos[PointCode]=y;
               if ((!(OldVHPos==Field_3D->YPos[PointCode])) || (!(OldLRPos==Field_3D->XPos[PointCode])))
                  {
                  SetAPen(DWindow->RPort,1);
                  if (PointCode==0)
                     {
                     Move(DWindow->RPort,OldLRPos,OldVHPos);
                     Draw(DWindow->RPort,Field_3D->XPos[1],Field_3D->YPos[1]);
                     }
                  else if (PointCode==15)
                     {
                     Move(DWindow->RPort,OldLRPos,OldVHPos);
                     Draw(DWindow->RPort,Field_3D->XPos[14],Field_3D->YPos[14]);
                     }
                  else
                     {
                     Move(DWindow->RPort,Field_3D->XPos[PointCode-1],Field_3D->YPos[PointCode-1]);
                     Draw(DWindow->RPort,OldLRPos,OldVHPos);
                     Draw(DWindow->RPort,Field_3D->XPos[PointCode+1],Field_3D->YPos[PointCode+1]);
                     }
                  RectFill(DWindow->RPort,OldLRPos-2,OldVHPos-2,OldLRPos+2,OldVHPos+2);
                  DRAWDISPLAY(FALSE);
                  }
               }
            IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
            if (IMsg)
               {
               if (IMsg->Class==MOUSEBUTTONS)
                if (IMsg->Code==SELECTUP) Klick=FALSE;
               ReplyMsg((Message*)IMsg);
               }
            if (!(Klick))
               {
               GT_SetGadgetAttrs(DGadget[16],DWindow,NULL,(GTIN_Number),Field_3D->XPos[PointCode]-190,        (TAG_DONE));
               GT_SetGadgetAttrs(DGadget[17],DWindow,NULL,(GTIN_Number),Field_3D->YPos[PointCode]-DSP_YOFFSET,(TAG_DONE));
               RefreshGList(DWindow->FirstGadget,DWindow,NULL,-1);
               DRAWDISPLAY(FALSE);
               }
            }
         while (Klick);
         }

      }
   while (!((RawCode==68) || (RawCode==69) || (GadCode==1) || (GadCode==2)))
   };
CloseGUI();
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_LEAVEWIN;
MyWTStdMsg->WTMsgPrc->PRC_Long1=RawCode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=GadCode;
MyWTStdMsg->WTMsgPrc->PRC_NewPtr=DWindow;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==1) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_CANCELLED;
}



void main(void)

{
if ((IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39)))
   {
   if ((GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39)))
      {
      if ((DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39)))
         {
         if ((GadToolsBase=(struct GadToolsBase*)OpenLibrary("gadtools.library",39)))
            {
            if (CREATEPORTS(PORT_EFFECTMOD))
               {
               if (MyWTStdMsg->Version==VERSION_EFFECTMOD)
                  {
                  if (MyWTStdMsg->Flags==MDC_DEFINEIT) DEFINE3D()
                  else if (MyWTStdMsg->Flags==MDC_DOIT)
                     {
                     MyWTStdMsg->Flags=0;
                     MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
                     strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"3D-Surround, ");
                     strcat(MyWTStdMsg->WTMsgPrc->PRC_Str1,COPYRIGHT);
                     MESSAGEHANDLE();
                     MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETMARKOFFSET;
                     MESSAGEHANDLE();
                     BeginOffset=MyWTStdMsg->WTMsgPrc->PRC_Long1;
                     EndOffset=MyWTStdMsg->WTMsgPrc->PRC_Long2;
                     INIT3D();
                     Valid=TRUE;
                     for (ChID=0; ChID<=5; ChID++) if ((Valid) && (MyWTStdMsg->MemA24[ChID]))
                      DO3D(MyWTStdMsg->MemA24[ChID],MyWTStdMsg->MemAAlpha[ChID],ChID);
                     }
                  }
               else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
               MESSAGEHANDLE();
               RemPort(MyPort);
               DeleteMsgPort(MyPort);
               }
            CloseLibrary((struct Library*)GadToolsBase);
            }
         CloseLibrary((struct Library*)DOSBase);
         }
      CloseLibrary((struct Library*)GfxBase);
      }
   CloseLibrary((struct Library*)IntuitionBase);
   }
}





