Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod","Internal.mod","schieber.mod"}


var FRTit,PathFR,FRShow :string[200];



function FILEREQ:boolean;

begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_FILEREQ,PathFR,'','',FRShow,FRTit,0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1<>-1) then begin
         PathFR:=WTMsgPrc^.PRC_Str1;
         FILEREQ:=TRUE;
      end else FILEREQ:=FALSE;
   end;
end;



procedure DOHKURVE(SAddr,AlphaSAddr,StartOffset,EndOffset :long);

var Stepsize,Factor,Constant            :real;
var Offset,Steps,Addr1,AddrA,MemAMod    :long;
var Data1                               :^long;
var FHandle                             :BPTR;
var DataA                               :^byte;
var DataW                               :^word;

begin
   Addr1:=SAddr+StartOffset;
   AddrA:=AlphaSAddr+(StartOffset div 80);
   with MyWTStdMsg^.ActWaveOp^ do begin
      Steps:=0;
      if (OpType=1) and (Operator[1]=Operator[2])
      or (OpType in [2..5]) and (Operator[2]=0) then exit;
      if OpType=1 then begin {*** LINEAR ***}
         Stepsize:=(Operator[2]-Operator[1])/(EndOffset-StartOffset)*4;
         Factor:=Operator[1];
         if AlphaSAddr=0 then repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data1^:=round(Data1^*Factor / 101);
            Factor:=Factor+Stepsize;
         until Addr1>SAddr+EndOffset
         else repeat
            DataA:=ptr(AddrA); AddrA:=AddrA+1; Addr1:=Addr1+80;
            DataA^:=round(DataA^*Factor/100);
            Factor:=Factor+(Stepsize*20);
         until Addr1>SAddr+EndOffset;

      end else if OpType=2 then begin {*** SINUS-MODULATION ***}
         Stepsize:=6.2831852/Operator[3]; Steps:=1;
         repeat
            if AlphaSAddr=0 then begin
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data1^:=round(Data1^*(100+(Operator[2]*sin(Stepsize*Steps)))/201);
               Steps:=Steps+1;
            end else begin
               DataA:=ptr(AddrA); AddrA:=AddrA+1; Addr1:=Addr1+80;
               DataA^:=round(DataA^*(100+(Operator[2]*sin(Stepsize*Steps)))/201);
               Steps:=Steps+20;
            end;
         until Addr1>SAddr+EndOffset;

      end else if OpType=3 then begin {*** DREIECK-MODULATION ***}
         Stepsize:=(Operator[2])/Operator[3]*2;
         repeat
            Factor:=100-Operator[2];
            if AlphaSAddr=0 then begin
               while (Factor<100) and (Addr1<=SAddr+EndOffset) do begin
                  Data1:=Ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=round(Data1^*Factor/101); Factor:=Factor+Stepsize;
               end;
               while (Factor>100-Operator[2]) and (Addr1<=SAddr+EndOffset) do begin
                  if Factor>101 then Factor:=101;
                  Data1:=Ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=round(Data1^*Factor/101); Factor:=Factor-Stepsize;
               end;
            end else begin
               while (Factor<100) and (Addr1<=SAddr+EndOffset) do begin
                  DataA:=Ptr(AddrA); AddrA:=AddrA+1; Addr1:=Addr1+80;
                  DataA^:=round(DataA^*Factor/101); Factor:=Factor+Stepsize*20;
               end;
               while (Factor>100-Operator[2]) and (Addr1<=SAddr+EndOffset) do begin
                  if Factor>101 then Factor:=101;
                  DataA:=Ptr(AddrA); AddrA:=AddrA+1; Addr1:=Addr1+80;
                  DataA^:=round(DataA^*Factor/101); Factor:=Factor-Stepsize*20;
               end;
            end;
         until Addr1>SAddr+EndOffset;

      end else if OpType=4 then begin {*** RAMPE-AUF-MODULATION ***}
         Stepsize:=(Operator[2])/Operator[3];
         repeat
            Factor:=100-Operator[2];
            if AlphaSAddr=0 then begin
               while (Factor<100) and (Addr1<=SAddr+EndOffset) do begin
                  Data1:=Ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=round(Data1^*Factor/101); Factor:=Factor+Stepsize;
               end;
            end else begin
               while (Factor<100) and (Addr1<=SAddr+EndOffset) do begin
                  DataA:=Ptr(AddrA); AddrA:=AddrA+1; Addr1:=Addr1+80;
                  DataA^:=round(DataA^*Factor/101); Factor:=Factor+Stepsize*20;
               end;
            end;
         until Addr1>SAddr+EndOffset;

      end else if OpType=5 then begin {*** RAMPE-AB-MODULATION ***}
         Stepsize:=(Operator[2])/Operator[3];
         repeat
            Factor:=100;
            if AlphaSAddr=0 then begin
               while (Factor>100-Operator[2]) and (Addr1<=SAddr+EndOffset) do begin
                  Data1:=Ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=round(Data1^*Factor/101); Factor:=Factor-Stepsize;
               end;
            end else begin
               while (Factor>100-Operator[2]) and (Addr1<=SAddr+EndOffset) do begin
                  DataA:=Ptr(AddrA); AddrA:=AddrA+1; Addr1:=Addr1+80;
                  DataA^:=round(DataA^*Factor/101); Factor:=Factor-Stepsize*20;
               end;
            end;
         until Addr1>SAddr+EndOffset;

      end else if OpType=6 then begin {*** HLKV-MODUL ***}
         MemAMod:=AllocVec(5000,0);
         if MemAMod=0 then exit;
         FHandle:=DosOpen(OpString,MODE_OLDFILE);
         if FHandle=0 then begin
            l:=TASKREQUEST(OpString,MyWTStdMsg^.PText[184],NIL,MyWTStdMsg^.PText[220],NIL);
            exit;
         end;
         l:=DosRead(FHandle,ptr(MemAMod),5000);
         DosClose(FHandle);
         Stepsize:=(10000.0/(EndOffset-StartOffset));
         Factor:=Stepsize;
         if AlphaSAddr=0 then begin
            repeat
               Data1:=Ptr(Addr1);  Addr1:=Addr1+4;
               DataW:=ptr(MemAMod+round(Factor)*2);
               Factor:=Factor+Stepsize;
               Data1^:=round(Data1^*(DataW^/65535));
            until (Addr1>SAddr+EndOffset) or (Factor>=2500);
         end else begin
            repeat
               DataA:=Ptr(AddrA); AddrA:=AddrA+1; Addr1:=Addr1+80;
               DataW:=ptr(MemAMod+round(Factor)*2);
               Factor:=Factor+Stepsize*20;
               DataA^:=round(DataA^*(DataW^/65535));
            until (Addr1>SAddr+EndOffset) or (Factor>=2500);
         end;
         FreeVec(MemAMod);
      end else DisplayBeep(NIL);
   end;
end;



procedure DEFINEHKURVE;

var s           :string[5];
var MySList     :SelectListGad;

procedure DRAWGRAPH;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      SetAPen(DWindow^.RPort,0); RectFill(DWindow^.RPort,270,41,430,73);
      if OpType=1 then DRAWLINE(DWindow^,270,round(69-Operator[1]/3.8),430,round(69-Operator[2]/3.8),3)
      else if OpType in [2..5] then begin
         DrawImage(DWindow^.RPort,MyWTStdMsg^.WTImg^.GImg6,320,42);
         s:=intstr(Operator[2])+"%";
         WRITE(350,63,2,3,DWindow^,s);
      end else if OpType=6 then DrawImage(DWindow^.RPort,MyWTStdMsg^.WTImg^.GImg3,328,46);
   end;
end;



begin
   if not OPENDWIN(147,0,DWindow,MyWTStdMsg^.PText[38],3,1) then exit;
   MyWTStdMsg^.ActWaveOp^.Operation:=3;
   with MyWTStdMsg^.ActWaveOp^ do begin
      if (Operator[1]=-1) then begin
         Operator[1]:=1;
         Operator[2]:=100;
         Operator[3]:=200;
         OpType:=1;
      end;
      MAKEBORDER(DWindow^,268,40,432,74,NEGATIVE);
      CREATEGADS(1,1,1);
      ACTIVECHANNELGADS(MyWTStdMsg^.ActiveMode,Channels);
      DKnopf[9].GadgetText:=^DKnopfTx[OpType];
      for i:=1 to 6 do DKnopfTx[i]:=IntuiText(2,0,0,4,2,MyWTStdMsg^.WTScreen^.Font,MyWTStdMsg^.PText[i+38],NIL);
      MySList:=SelectListGad(DWindow,^DKnopf[9],OpType,0,0,0,ITTArr(^DKnopfTx[1],
                             ^DKnopfTx[2],^DKnopfTx[3],^DKnopfTx[4],^DKnopfTx[5],
                             NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL));

      for i:=1 to 2 do CREATEPROPGAD(10,77+(17*i),pred(Operator[i])*661,655,i,10,DWindow^);
      CREATEPROPGAD(10,128,Operator[3] div 2,1,3,10,DWindow^);
      Buffer[1]:=intstr(Operator[1]); Buffer[2]:=intstr(Operator[2]); Buffer[3]:=intstr(Operator[3]);

      DKnopfTx[2].IText:=MyWTStdMsg^.PText[2];
      DKnopfTx[3].IText:=MyWTStdMsg^.PText[4];
      DKnopfTx[4].IText:=MyWTStdMsg^.PText[7];
      DKnopfTx[5].IText:=MyWTStdMsg^.PText[8];
      DKnopfTx[6].IText:=MyWTStdMsg^.PText[40];

      WRITE(206,63,2,3,DWindow^,MyWTStdMsg^.PText[40]);
      WRITE(414,96,2,0,DWindow^,MyWTStdMsg^.PText[41]);
      WRITE(414,114,2,0,DWindow^,MyWTStdMsg^.PText[42]);
      WRITE(414,132,2,0,DWindow^,MyWTStdMsg^.PText[34]);
      if OpType in [2..5] then begin
         Schieber[1].flags:=Schieber[1].Flags or GADGDISABLED;
         TextGad[1].flags:=TextGad[1].Flags or GADGDISABLED;
      end else begin
         Schieber[3].flags:=Schieber[3].Flags or GADGDISABLED;
         TextGad[3].flags:=TextGad[3].Flags or GADGDISABLED;
      end;
      for i:=1 to 3 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 3 do AddGadget(DWindow,^Schieber[i],NIL);
      for i:=9 to 10 do AddGadget(DWindow,^DKnopf[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      DRAWGRAPH;
      repeat

         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress;
               GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg)
         End else delay(1);

         if GadCode=9 then begin
            OpType:=DOSELECTLIST(^MySList);
            if OpType in [2..5] then begin
               Schieber[1].flags:=Schieber[1].Flags or GADGDISABLED;
               TextGad[1].flags:=TextGad[1].Flags or GADGDISABLED;
               Schieber[3].flags:=Schieber[3].Flags and not GADGDISABLED;
               TextGad[3].flags:=TextGad[3].Flags and not GADGDISABLED;
            end else begin
               Schieber[1].flags:=Schieber[1].Flags and not GADGDISABLED;
               TextGad[1].flags:=TextGad[1].Flags and not GADGDISABLED;
               Schieber[3].flags:=Schieber[3].Flags or GADGDISABLED;
               TextGad[3].flags:=TextGad[3].Flags or GADGDISABLED;
            end;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
            DRAWGRAPH;
         end;

         if GadCode=10 then begin
            FRTit:=MyWTStdMsg^.PText[238]; PathFR:='HLKV'; FRShow:='';
            if FILEREQ then begin
               ChunkSize:=WOP_NORM;
               OpString:=PathFR;
               OpType:=6;
               DKnopf[9].GadgetText:=^DKnopfTx[6];
            end;
            Schieber[1].flags:=Schieber[1].Flags and not GADGDISABLED;
            TextGad[1].flags:=TextGad[1].Flags and not GADGDISABLED;
            Schieber[3].flags:=Schieber[3].Flags or GADGDISABLED;
            TextGad[3].flags:=TextGad[3].Flags or GADGDISABLED;
            RefreshGadgets(Dwindow^.FirstGadget,DWindow,NIL);
            DRAWGRAPH;
         end;

         if (Gadcode=11) or not (Schieber[1].flags and SELECTED=0) then begin
            Operator[1]:=SchieberInfo[1].HorizPot div 655;
            if Operator[1]>100 then Operator[1]:=100;
            if Operator[1]<1 then Operator[1]:=1;
            Buffer[1]:=intstr(Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
            DRAWGRAPH;
         end;
         if GadCode=12 then begin
            val(Buffer[1],Operator[1],i);
            if Operator[1]>100 then Operator[1]:=100;
            if Operator[1]<1 then Operator[1]:=1;
            Buffer[1]:=intstr(Operator[1]);
            SchieberInfo[1].HorizPot:=Operator[1]*655;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
            DRAWGRAPH;
         end;

         if (GadCode=13) or not (Schieber[2].flags and SELECTED=0) then begin
            Operator[2]:=succ(SchieberInfo[2].HorizPot div 661);
            if Operator[2]>100 then Operator[2]:=100;
            if Operator[2]<1 then Operator[2]:=1;
            Buffer[2]:=intstr(Operator[2]);
            RefreshGadgets(^TextGad[2],DWindow,NIL);
            DRAWGRAPH;
         end;
         if GadCode=14 then begin
            val(Buffer[2],Operator[2],i);
            if Operator[2]>100 then Operator[2]:=100;
            if Operator[2]<1 then Operator[2]:=1;
            Buffer[2]:=intstr(Operator[2]);
            SchieberInfo[2].HorizPot:=pred(Operator[2])*661;
            RefreshGadgets(^Schieber[2],DWindow,NIL);
            DRAWGRAPH;
         end;

         if (GadCode=15) or not (Schieber[3].flags and SELECTED=0) then begin
            Operator[3]:=SchieberInfo[3].HorizPot*2;
            if Operator[3]<1 then Operator[3]:=1; if Operator[3]>131068 then Operator[3]:=131068;
            Buffer[3]:=intstr(Operator[3]);
            RefreshGadgets(^TextGad[3],DWindow,NIL);
         end;
         if GadCode=16 then begin
            val(Buffer[3],Operator[3],i);
            if Operator[3]<1 then Operator[3]:=1; if Operator[3]>131068 then Operator[3]:=131068;
            Buffer[3]:=intstr(Operator[3]);
            SchieberInfo[3].HorizPot:=Operator[3] div 2;
            RefreshGadgets(^Schieber[3],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Channels:=GETACTIVECHANNELS;
      LEAVEDEF(RawCode,GadCode);
      SoundMode:=MyWTStdMsg^.ActiveMode;
      WAreaA:=MyWTStdMsg^.AreaA;
      WAreaE:=MyWTStdMsg^.AreaE;
   end;
end;



begin {*** MAIN ***}
   OpenLib(DOSBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINEHKURVE
         else if (Flags=MDC_DOIT) then begin
            Flags:=0;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) then
                DOHKURVE(MyWTStdMsg^.MemA24[ChID],MyWTStdMsg^.MemAAlpha[ChID],BeginOffset,EndOffset);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   Closelib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
