Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod","Internal.mod","schieber.mod"}



procedure DOCHANNELC;

var Addr1,Addr2,Addr3,IntData,WaveMaxAmp,Check  :long;
var Data1,Data2,Data3                           :^long;
var DataA1,DataA2,DataA3                        :^byte;
var i,Div1,Div2,AlphaMaxAmp                     :byte;
var Divider                                     :real;


function GETDIVIDER(ChNum,ChID :byte):real;

var DivD :real;

begin
   DivD:=1;
   if MyWTStdMsg^.ActiveMode in [MD_MONO,MD_STEREO,MD_3CH,MD_SURROUND] then with MyWTStdMsg^.PosSurround^ do begin
      if ChNum<5 then DivD:=SQRT(SQR(ChX[ChNum]-ChX[ChID])+SQR(ChY[ChNum]-ChY[ChID]))/10;
   end else if MyWTStdMsg^.ActiveMode=MD_QUADRO then with MyWTStdMsg^.PosQuadro^ do begin
      if not ChNum in [3,5..6] then DivD:=SQRT(SQR(ChX[ChNum]-ChX[ChID])+SQR(ChY[ChNum]-ChY[ChID]))/10;
   end else with MyWTStdMsg^.PosAC3^ do DivD:=SQRT(SQR(ChX[ChNum]-ChX[ChID])+SQR(ChY[ChNum]-ChY[ChID]))/10;
   if abs(DivD)=0 then DivD:=1;
   GETDIVIDER:=DivD;
end;



procedure ADDCHANNELS(ChID :byte);

var i           :byte;

begin
   for i:=1 to 5 do if (i<>ChID) and (MyWTStdMsg^.MemA24[i]<>0) then begin
      Divider:=GETDIVIDER(i,ChID);
      Addr1:=MyWTStdMsg^.MemA24[ChID]+MyWTStdMsg^.PlayL24;
      Addr2:=MyWTStdMsg^.MemA24[i]+MyWTStdMsg^.PlayL24;
      repeat
         Addr1:=Addr1-4; Data1:=ptr(Addr1);
         Addr2:=Addr2-4; Data2:=ptr(Addr2);
         Data1^:=round(Data1^+(Data2^/Divider));
      until Addr1<=MyWTStdMsg^.MemA24[ChID];

      if (MyWTStdMsg^.MemAAlpha[ChID]<>0) and (MyWTStdMsg^.MemAAlpha[i]<>0) then begin
         Addr1:=MyWTStdMsg^.MemAAlpha[ChID]+round(MyWTStdMsg^.MemL24/80+0.5);
         Addr2:=MyWTStdMsg^.MemAAlpha[i]+round(MyWTStdMsg^.MemL24/80+0.5);
         repeat
            Addr1:=Addr1-1; DataA1:=ptr(Addr1);
            Addr2:=Addr2-1; DataA2:=ptr(Addr2);
            Check:=round(DataA1^+(DataA2^/Divider));
            if Check>255 then Check:=255; DataA1^:=Check;
         until Addr1<=MyWTStdMsg^.MemAAlpha[ChID];
      end;
   end;
end;



procedure REMCHANNELS(ChID :byte);

var i           :byte;

begin
   for i:=1 to 5 do if (i<>ChID) and (MyWTStdMsg^.MemA24[i]<>0) then begin
      Divider:=GETDIVIDER(i,ChID);
      Addr1:=MyWTStdMsg^.MemA24[ChID]+MyWTStdMsg^.PlayL24;
      Addr2:=MyWTStdMsg^.MemA24[i]+MyWTStdMsg^.PlayL24;
      repeat
         Addr1:=Addr1-4; Data1:=ptr(Addr1);
         Addr2:=Addr2-4; Data2:=ptr(Addr2);
         Data2^:=round(Data2^+(Data1^/Divider));
      until Addr1<=MyWTStdMsg^.MemA24[ChID];
      if (MyWTStdMsg^.MemAAlpha[ChID]<>0) and (MyWTStdMsg^.MemAAlpha[i]<>0) then begin
         Addr1:=MyWTStdMsg^.MemAAlpha[ChID]+round(MyWTStdMsg^.MemL24/80+0.5);
         Addr2:=MyWTStdMsg^.MemAAlpha[i]+round(MyWTStdMsg^.MemL24/80+0.5);
         repeat
            Addr1:=Addr1-1; DataA1:=ptr(Addr1);
            Addr2:=Addr2-1; DataA2:=ptr(Addr2);
            Check:=round(DataA2^+(DataA1^/Divider));
            if Check>255 then Check:=255; DataA2^:=Check;
         until Addr1<=MyWTStdMsg^.MemAAlpha[ChID];
      end;
   end;
   Addr1:=MyWTStdMsg^.MemA24[ChID]+MyWTStdMsg^.PlayL24;
   repeat
      Addr1:=Addr1-4; Data1:=ptr(Addr1);
      Data1^:=0;
   until Addr1<=MyWTStdMsg^.MemA24[ChID];
end;



begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      case OpType of
         1: begin
               if (MyWTStdMsg^.PlayL24>MyWTStdMsg^.MemL24) then MyWTStdMsg^.PlayL24:=MyWTStdMsg^.MemL24;
               if (MyWTStdMsg^.MemA24[Operator[1]]>0) and (MyWTStdMsg^.MemA24[Operator[2]]>0) then CopyMemQuick(MyWTStdMsg^.MemA24[Operator[1]],MyWTStdMsg^.MemA24[Operator[2]],MyWTStdMsg^.PlayL24);
               if (MyWTStdMsg^.MemAAlpha[Operator[1]]>0) and (MyWTStdMsg^.MemAAlpha[Operator[2]]>0) then CopyMem(MyWTStdMsg^.MemAAlpha[Operator[1]],MyWTStdMsg^.MemAAlpha[Operator[2]],round(MyWTStdMsg^.PlayL24/80+0.5));
            end;
         2: begin
               if (MyWTStdMsg^.MemA24[Operator[1]]<>0) and (MyWTStdMsg^.MemA24[Operator[2]]<>0) then exchange(MyWTStdMsg^.MemA24[Operator[1]],MyWTStdMsg^.MemA24[Operator[2]]);
               if (MyWTStdMsg^.MemAAlpha[Operator[1]]<>0) and (MyWTStdMsg^.MemAAlpha[Operator[2]]<>0) then exchange(MyWTStdMsg^.MemAAlpha[Operator[1]],MyWTStdMsg^.MemAAlpha[Operator[2]])
            end;
         3: begin
               if (MyWTStdMsg^.MemA24[Operator[1]]<>0) and (MyWTStdMsg^.MemA24[Operator[2]]<>0) then begin
                  CopyMemQuick(MyWTStdMsg^.MemA24[Operator[1]],MyWTStdMsg^.MemA24[Operator[2]],MyWTStdMsg^.PlayL24);
                  Addr1:=MyWTStdMsg^.MemA24[Operator[1]]+MyWTStdMsg^.MemL24;
                  repeat
                     Addr1:=Addr1-4; Data1:=ptr(Addr1);
                     Data1^:=0;
                  until Addr1<=MyWTStdMsg^.MemA24[Operator[1]];
               end;
               if (MyWTStdMsg^.MemAAlpha[Operator[1]]<>0) and (MyWTStdMsg^.MemAAlpha[Operator[2]]<>0) then begin
                  CopyMem(MyWTStdMsg^.MemAAlpha[Operator[1]],MyWTStdMsg^.MemAAlpha[Operator[2]],round(MyWTStdMsg^.MemL24/80+0.5));
                  Addr1:=MyWTStdMsg^.MemAAlpha[Operator[1]]+round(MyWTStdMsg^.MemL24/80+0.5);
                  repeat
                     Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                     DataA1^:=255;
                  until Addr1<=MyWTStdMsg^.MemAAlpha[Operator[1]];
               end;
            end;
         4: begin
               if (MyWTStdMsg^.MemA24[Operator[1]]<>0) and (MyWTStdMsg^.MemA24[Operator[2]]<>0) then begin
                  Addr1:=MyWTStdMsg^.MemA24[Operator[1]]+MyWTStdMsg^.PlayL24;
                  Addr2:=MyWTStdMsg^.MemA24[Operator[2]]+MyWTStdMsg^.PlayL24;
                  repeat
                     Addr1:=Addr1-4; Data1:=ptr(Addr1);
                     Addr2:=Addr2-4; Data2:=ptr(Addr2);
                     Data1^:=Data1^+Data2^;
                     Data2^:=Data1^;
                  until Addr1<=MyWTStdMsg^.MemA24[Operator[1]];
               end;
               if (MyWTStdMsg^.MemAAlpha[Operator[1]]<>0) and (MyWTStdMsg^.MemAAlpha[Operator[2]]<>0) then begin
                  Addr1:=MyWTStdMsg^.MemAAlpha[Operator[1]]+round(MyWTStdMsg^.MemL24/80+0.5);
                  Addr2:=MyWTStdMsg^.MemAAlpha[Operator[2]]+round(MyWTStdMsg^.MemL24/80+0.5);
                  repeat
                     Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                     Addr2:=Addr2-1; DataA2:=ptr(Addr2);
                     DataA1^:=(DataA1^+DataA2^) div 2;
                     DataA2^:=DataA1^;
                  until Addr1<=MyWTStdMsg^.MemAAlpha[Operator[1]];
               end;
            end;
         5: begin
               if MyWTStdMsg^.MemA24[Operator[1]]<>0 then begin
                  Addr1:=MyWTStdMsg^.MemA24[Operator[1]]+MyWTStdMsg^.PlayL24;
                  repeat
                     Addr1:=Addr1-4; Data1:=ptr(Addr1);
                     Data1^:=0;
                  until Addr1<=MyWTStdMsg^.MemA24[Operator[1]];
               end;
               if MyWTStdMsg^.MemAAlpha[Operator[1]]<>0 then begin
                  Addr1:=MyWTStdMsg^.MemAAlpha[Operator[1]]+round(MyWTStdMsg^.MemL24/80+0.5);
                  repeat
                     Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                     DataA1^:=255;
                  until Addr1<=MyWTStdMsg^.MemAAlpha[Operator[1]];
               end;
            end;
         6: if MyWTStdMsg^.MemA24[Operator[1]]<>0 then begin
               if Operator[1]=3 then begin
                  if (MyWTStdMsg^.MemA24[1]<>0) and (MyWTStdMsg^.MemA24[2]<>0) then begin
                     {CENTER}
                     Addr1:=MyWTStdMsg^.MemA24[1]+MyWTStdMsg^.PlayL24;
                     Addr2:=MyWTStdMsg^.MemA24[2]+MyWTStdMsg^.PlayL24;
                     Addr3:=MyWTStdMsg^.MemA24[3]+MyWTStdMsg^.PlayL24;
                     repeat
                        Addr1:=Addr1-4; Data1:=ptr(Addr1);
                        Addr2:=Addr2-4; Data2:=ptr(Addr2);
                        Addr3:=Addr3-4; Data3:=ptr(Addr3);
                        Data3^:=(Data1^+Data2^) div 2;
                        Data1^:=Data1^-Data3^;
                        Data2^:=Data2^-Data3^;
                     until Addr1<=MyWTStdMsg^.MemA24[1];
                  end;
                  if (MyWTStdMsg^.MemAAlpha[1]<>0) and (MyWTStdMsg^.MemAAlpha[2]<>0)
                  and (MyWTStdMsg^.MemAAlpha[3]<>0) then begin
                     Addr1:=MyWTStdMsg^.MemAAlpha[1]+round(MyWTStdMsg^.MemL24/80+0.5);
                     Addr2:=MyWTStdMsg^.MemAAlpha[2]+round(MyWTStdMsg^.MemL24/80+0.5);
                     Addr3:=MyWTStdMsg^.MemAAlpha[3]+round(MyWTStdMsg^.MemL24/80+0.5);
                     repeat
                        Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                        Addr2:=Addr2-1; DataA2:=ptr(Addr2);
                        Addr3:=Addr3-1; DataA3:=ptr(Addr3);
                        DataA3^:=DataA1^ div 2 + DataA2^ div 2;
                     until Addr1<=MyWTStdMsg^.MemAAlpha[1];
                  end;
               end else if Operator[1] in [4,5] then begin
                  {SURROUND}
                  Addr1:=MyWTStdMsg^.MemA24[1]+MyWTStdMsg^.PlayL24;
                  Addr2:=MyWTStdMsg^.MemA24[2]+MyWTStdMsg^.PlayL24;
                  Addr3:=MyWTStdMsg^.MemA24[Operator[1]]+MyWTStdMsg^.MemL24;
                  repeat
                     Addr1:=Addr1-4; Data1:=ptr(Addr1);
                     Addr2:=Addr2-4; Data2:=ptr(Addr2);
                     Addr3:=Addr3-4; Data3:=ptr(Addr3);
                     Data3^:=(Data1^-Data2^) div 2;
                     Data1^:=Data1^-Data3^;
                     Data2^:=Data2^-Data3^;
                  until Addr1<=MyWTStdMsg^.MemA24[1];
                  if (MyWTStdMsg^.MemAAlpha[1]<>0) and (MyWTStdMsg^.MemAAlpha[2]<>0)
                  and (MyWTStdMsg^.MemAAlpha[Operator[1]]<>0) then begin
                     Addr1:=MyWTStdMsg^.MemAAlpha[1]+round(MyWTStdMsg^.MemL24/80+0.5);
                     Addr2:=MyWTStdMsg^.MemAAlpha[2]+round(MyWTStdMsg^.MemL24/80+0.5);
                     Addr3:=MyWTStdMsg^.MemAAlpha[Operator[1]]+round(MyWTStdMsg^.MemL24/80+0.5);
                     repeat
                        Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                        Addr2:=Addr2-1; DataA2:=ptr(Addr2);
                        Addr3:=Addr3-1; DataA3:=ptr(Addr3);
                        DataA3^:=DataA1^ div 2 + DataA2^ div 2;
                     until Addr1<=MyWTStdMsg^.MemAAlpha[1];
                  end;
                  if MyWTStdMsg^.ActiveMode in [MD_AC3,MD_AC3_Sub] then ADDCHANNELS(Operator[1]);
               end else if Operator[1]=6 then begin
                  {SUBWOOFER}
                  Addr1:=MyWTStdMsg^.MemA24[1]+MyWTStdMsg^.PlayL24;
                  Addr2:=MyWTStdMsg^.MemA24[6]+MyWTStdMsg^.PlayL24;
                  IntData:=0;
                  repeat
                     Addr1:=Addr1-4; Data1:=ptr(Addr1);
                     Addr2:=Addr2-4; Data2:=ptr(Addr2);
                     IntData:=(Data1^+IntData) div 2;
                     Data2^:=IntData div 5;
                  until Addr1<=MyWTStdMsg^.MemA24[1];
                  for i:=2 to 5 do begin
                     Addr1:=MyWTStdMsg^.MemA24[i]+MyWTStdMsg^.PlayL24;
                     Addr2:=MyWTStdMsg^.MemA24[6]+MyWTStdMsg^.PlayL24;
                     IntData:=0;
                     repeat
                        Addr1:=Addr1-4; Data1:=ptr(Addr1);
                        Addr2:=Addr2-4; Data2:=ptr(Addr2);
                        IntData:=(Data1^ + IntData) div 2;
                        Data2^:=Data2^+(IntData div 5);
                     until Addr1<=MyWTStdMsg^.MemA24[i];
                  end;
                  Addr1:=MyWTStdMsg^.MemA24[6];
                  IntData:=0;
                  repeat
                     Data1:=ptr(Addr1); Addr1:=Addr1+4;
                     Data1^:=(IntData+Data1^) div 2;
                     IntData:=Data1^;
                  until Addr1>=MyWTStdMsg^.MemA24[6]+MyWTStdMsg^.PlayL24;
                  if MyWTStdMsg^.MemAAlpha[6]<>0 then begin
                     Addr1:=MyWTStdMsg^.MemAAlpha[6]+round(MyWTStdMsg^.MemL24/80+0.5);
                     repeat
                        Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                        DataA1^:=255;
                     until Addr1<=MyWTStdMsg^.MemAAlpha[6];
                  end;
               end else ADDCHANNELS(Operator[1]);
            end;
         7: if MyWTStdMsg^.MemA24[Operator[1]]<>0 then begin
               if (Operator[1]=3) and (MyWTStdMsg^.MemA24[1]<>0) and (MyWTStdMsg^.MemA24[2]<>0) then begin
                  {CENTER}
                  Addr1:=MyWTStdMsg^.MemA24[1]+MyWTStdMsg^.PlayL24;
                  Addr2:=MyWTStdMsg^.MemA24[2]+MyWTStdMsg^.PlayL24;
                  Addr3:=MyWTStdMsg^.MemA24[3]+MyWTStdMsg^.PlayL24;
                  repeat
                     Addr1:=Addr1-4; Data1:=ptr(Addr1);
                     Addr2:=Addr2-4; Data2:=ptr(Addr2);
                     Addr3:=Addr3-4; Data3:=ptr(Addr3);
                     Data1^:=Data1^+Data3^ div 2;
                     Data2^:=Data2^+Data3^ div 2;
                     Data3^:=0;
                  until Addr1<=MyWTStdMsg^.MemA24[1];
                  if (MyWTStdMsg^.MemAAlpha[1]<>0) and (MyWTStdMsg^.MemAAlpha[2]<>0) and (MyWTStdMsg^.MemAAlpha[3]<>0) then begin
                     Addr1:=MyWTStdMsg^.MemAAlpha[1]+round(MyWTStdMsg^.MemL24/80+0.5);
                     Addr2:=MyWTStdMsg^.MemAAlpha[2]+round(MyWTStdMsg^.MemL24/80+0.5);
                     Addr3:=MyWTStdMsg^.MemAAlpha[3]+round(MyWTStdMsg^.MemL24/80+0.5);
                     repeat
                        Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                        Addr2:=Addr2-1; DataA2:=ptr(Addr2);
                        Addr3:=Addr3-1; DataA3:=ptr(Addr3);
                        Check:=DataA1^+DataA3^ div 2;
                        if Check>255 then Check:=255; DataA1^:=Check;
                        Check:=DataA2^+DataA3^ div 2;
                        if Check>255 then Check:=255; DataA2^:=Check;
                     until Addr1<=MyWTStdMsg^.MemAAlpha[1];
                  end;

               end else if Operator[1] in [4,5] then begin
                  {SURROUND}
                  MyWTStdMsg^.PlayL24:=MyWTStdMsg^.MemL24;
                  case MyWTStdMsg^.ActiveMode of
                     MD_SURROUND: begin
                                     Addr1:=MyWTStdMsg^.MemA24[1]+MyWTStdMsg^.PlayL24;
                                     Addr2:=MyWTStdMsg^.MemA24[2]+MyWTStdMsg^.PlayL24;
                                     Addr3:=MyWTStdMsg^.MemA24[4]+MyWTStdMsg^.PlayL24;
                                     repeat
                                        Addr1:=Addr1-4; Data1:=ptr(Addr1);
                                        Addr2:=Addr2-4; Data2:=ptr(Addr2);
                                        Addr3:=Addr3-4; Data3:=ptr(Addr3);
                                        Data1^:=Data1^+Data3^ div 2;
                                        Data2^:=Data2^-Data3^ div 2;
                                        Data3^:=0;
                                     until Addr1<=MyWTStdMsg^.MemA24[1];
                                     if (MyWTStdMsg^.MemAAlpha[1]<>0) and (MyWTStdMsg^.MemAAlpha[2]<>0)
                                     and (MyWTStdMsg^.MemAAlpha[4]<>0) then begin
                                        Addr1:=MyWTStdMsg^.MemAAlpha[1]+round(MyWTStdMsg^.MemL24/80+0.5);
                                        Addr2:=MyWTStdMsg^.MemAAlpha[2]+round(MyWTStdMsg^.MemL24/80+0.5);
                                        Addr3:=MyWTStdMsg^.MemAAlpha[4]+round(MyWTStdMsg^.MemL24/80+0.5);
                                        repeat
                                           Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                                           Addr2:=Addr2-1; DataA2:=ptr(Addr2);
                                           Addr3:=Addr3-1; DataA3:=ptr(Addr3);
                                           Check:=DataA1^+DataA3^ div 2;
                                           if Check>255 then Check:=255; DataA1^:=Check;
                                           Check:=DataA2^+DataA3^ div 2;
                                           if Check>255 then Check:=255; DataA2^:=Check;
                                        until Addr1<=MyWTStdMsg^.MemAAlpha[1];
                                     end;
                                  end;
                     otherwise begin
                        Addr1:=MyWTStdMsg^.MemA24[1]+MyWTStdMsg^.PlayL24;
                        Addr2:=MyWTStdMsg^.MemA24[2]+MyWTStdMsg^.PlayL24;
                        Addr3:=MyWTStdMsg^.MemA24[Operator[1]]+MyWTStdMsg^.PlayL24;
                        Div1:=3; Div2:=3;
                        if Operator[1]=4 then Div1:=2 else Div2:=3;
                        repeat
                           Addr1:=Addr1-4; Data1:=ptr(Addr1);
                           Addr2:=Addr2-4; Data2:=ptr(Addr2);
                           Addr3:=Addr3-4; Data3:=ptr(Addr3);
                           Data1^:=Data1^+Data3^ div Div1;
                           Data2^:=Data2^-Data3^ div Div2;
                           Data3^:=0;
                        until Addr1<=MyWTStdMsg^.MemA24[1];

                        if (MyWTStdMsg^.MemAAlpha[1]<>0) and (MyWTStdMsg^.MemAAlpha[2]<>0)
                        and (MyWTStdMsg^.MemAAlpha[Operator[1]]<>0) then begin
                           Addr1:=MyWTStdMsg^.MemAAlpha[1]+round(MyWTStdMsg^.MemL24/80+0.5);
                           Addr2:=MyWTStdMsg^.MemAAlpha[2]+round(MyWTStdMsg^.MemL24/80+0.5);
                           Addr3:=MyWTStdMsg^.MemAAlpha[Operator[1]]+round(MyWTStdMsg^.MemL24/80+0.5);
                           repeat
                              Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                              Addr2:=Addr2-1; DataA2:=ptr(Addr2);
                              Addr3:=Addr3-1; DataA3:=ptr(Addr3);
                              Check:=DataA1^+DataA3^ div Div1;
                              if Check>255 then Check:=255; DataA1^:=Check;
                              Check:=DataA2^+DataA3^ div Div2;
                              if Check>255 then Check:=255; DataA2^:=Check;
                           until Addr1<=MyWTStdMsg^.MemAAlpha[1];
                        end;
                     end;
                  end;
               end else if Operator[1]=6 then begin
                  {SUBWOOFER}
                  for i:=1 to 5 do begin
                     Addr1:=MyWTStdMsg^.MemA24[i]+MyWTStdMsg^.MemL24;
                     Addr2:=MyWTStdMsg^.MemA24[6]+MyWTStdMsg^.MemL24;
                     repeat
                        Addr1:=Addr1-4; Data1:=ptr(Addr1);
                        Addr2:=Addr2-4; Data2:=ptr(Addr2);
                        Data1^:=Data1^+Data2^ div 5
                     until Addr1<=MyWTStdMsg^.MemA24[i];
                  end;
                  Addr1:=MyWTStdMsg^.MemA24[6];
                  repeat
                     Data1:=ptr(Addr1); Addr1:=Addr1+4;
                     Data1^:=0;
                  until Addr1>=MyWTStdMsg^.MemA24[6]+MyWTStdMsg^.PlayL24;
               end else REMCHANNELS(Operator[1]);
               if MyWTStdMsg^.MemAAlpha[Operator[1]]<>0 then begin
                  Addr1:=MyWTStdMsg^.MemAAlpha[Operator[1]]+round(MyWTStdMsg^.MemL24/80+0.5);
                  repeat
                     Addr1:=Addr1-1; DataA1:=ptr(Addr1);
                     DataA1^:=255;
                  until Addr1<=MyWTStdMsg^.MemAAlpha[Operator[1]];
               end;
            end;
         otherwise DisplayBeep(NIL);
      end;
   end;
end;



procedure DEFINECHANNELC;

var ChBit,i     :byte;
var MySList     :SelectListGad;
var KnopfTx     :array [1..6] of IntuiText;


procedure DRAWLINES;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      SetAPen(DWindow^.RPort,0); RectFill(DWindow^.RPort,223,45,418,120);
      SetAPen(Dwindow^.RPort,1);
      if OpType in [1..4] then begin
         Move(DWindow^.RPort,223,Operator[1]*15+30);
         Draw(DWindow^.RPort,418,Operator[2]*15+30);
      end else begin
         Move(DWindow^.RPort,223,Operator[1]*15+30);
         Draw(DWindow^.RPort,320,Operator[1]*15+30);
      end;
   end;
end;


begin
   if not OPENDWIN(131,0,DWindow,MyWTStdMsg^.PText[91],1,0) then exit;
   with MyWTStdMsg^.ActWaveOp^ do begin
      Operation:=17;
      if (Operator[1]=-1) then begin
         Operator[1]:=1;
         Operator[2]:=2;
         OpType:=1;
      end;
      CREATEGADS(0,1,0);
      for i:=1 to 7 do DKnopfTx[i]:=IntuiText(2,0,0,4,2,MyWTStdMsg^.WTScreen^.Font,
                                              MyWTStdMsg^.PText[i+91],NIL);
      DKnopf[9].GadgetText:=^DKnopfTx[OpType];
      MySList:=SelectListGad(DWindow,^DKnopf[9],OpType,0,0,0,ITTArr(^DKnopfTx[1],
                             ^DKnopfTx[2],^DKnopfTx[3],^DKnopfTx[4],^DKnopfTx[5],
                             ^DKnopfTx[6],^DKnopfTx[7],NIL,NIL,NIL,NIL,
                             NIL,NIL,NIL,NIL));

      KnopfTx[1]:=IntuiText(2,0,0,7,1,MyWTStdMsg^.WTScreen^.Font,'L',NIL);
      KnopfTx[2]:=IntuiText(2,0,0,7,1,MyWTStdMsg^.WTScreen^.Font,'R',NIL);
      KnopfTx[3]:=IntuiText(2,0,0,7,1,MyWTStdMsg^.WTScreen^.Font,'C',NIL);
      KnopfTx[4]:=IntuiText(2,0,0,4,1,MyWTStdMsg^.WTScreen^.Font,'SL',NIL);
      KnopfTx[5]:=IntuiText(2,0,0,3,1,MyWTStdMsg^.WTScreen^.Font,'SR',NIL);
      KnopfTx[6]:=IntuiText(2,0,0,2,1,MyWTStdMsg^.WTScreen^.Font,'Sub',NIL);

      for i:=3 to 8 do begin
         DKnopf[i]:=  Gadget(NIL,200,i*15-5,21,12,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,
                             MyWTStdMsg^.WTImg^.ButtonImg1,NIL,^KnopfTx[i-2],0,Nil,i,0);
         DKnopf[i+7]:=Gadget(NIL,420,i*15-5,21,12,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,
                             MyWTStdMsg^.WTImg^.ButtonImg1,NIL,^KnopfTx[i-2],0,Nil,i+7,0);
      end;

      if MyWTStdMsg^.ActiveMode<7 then DKnopf[8].Flags:=DKnopf[8].Flags or GADGDISABLED;
      if MyWTStdMsg^.ActiveMode<6 then DKnopf[7].Flags:=DKnopf[7].Flags or GADGDISABLED;
      if MyWTStdMsg^.ActiveMode<4 then DKnopf[6].Flags:=DKnopf[6].Flags or GADGDISABLED;
      if MyWTStdMsg^.ActiveMode<3 then DKnopf[5].Flags:=DKnopf[5].Flags or GADGDISABLED;
      if MyWTStdMsg^.ActiveMode<2 then begin
         DKnopf[4].Flags:=DKnopf[4].Flags or GADGDISABLED;
         DKnopf[3].Flags:=DKnopf[3].Flags or GADGDISABLED;
         DKnopf[5].Flags:=DKnopf[5].Flags and not GADGDISABLED;
      end;
      if MyWTStdMsg^.ActiveMode=4 then begin
         DKnopf[5].Flags:=DKnopf[5].Flags or GADGDISABLED;
         DKnopf[7].Flags:=DKnopf[7].Flags and not GADGDISABLED;
      end;
      for i:=8 downto 3 do if not (DKnopf[i].Flags and GADGDISABLED=0) then
       DKnopf[i+7].Flags:=DKnopf[i+7].Flags or GADGDISABLED;

      if not (DKnopf[Operator[1]+2].Flags and GADGDISABLED=0) then
       for i:=8 downto 3 do if (DKnopf[i].Flags and GADGDISABLED=0) then Operator[1]:=i-2;

      if not (DKnopf[Operator[2]+9].Flags and GADGDISABLED=0) then
       for i:=15 downto 10 do if (DKnopf[i].Flags and GADGDISABLED=0) then Operator[2]:=i-9;

      if OpType>4 then for i:=10 to 15 do DKnopf[i].Flags:=DKnopf[i].Flags or GADGDISABLED;

      for i:=3 to 15 do AddGadget(DWindow,^DKnopf[i],NIL);
      DRAWLINES;
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat

         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress;
               GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg)
         End else delay(1);


         if GadCode=9 then begin
            OpType:=DOSELECTLIST(^MySList);
            if OpType in [1..4] then begin
               ChBit:=1;
               for i:=3 to 8 do begin
                  if (DKnopf[i].Flags and GADGDISABLED=0)
                  and not (MyWTStdMsg^.ActiveChannels and ChBit=0) then DKnopf[i+7].Flags:=DKnopf[i+7].Flags and not GADGDISABLED;
                  ChBit:=ChBit*2;
               end;
            end else for i:=10 to 15 do DKnopf[i].Flags:=DKnopf[i].Flags or GADGDISABLED;
            DRAWLINES;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         end;

         if GadCode in [3..8,10..15] then begin
            if GadCode in [3..8] then Operator[1]:=GadCode-2;
            if GadCode in [10..15] then Operator[2]:=GadCode-9;
            DRAWLINES;
         end;

      Until (GadCode in [1,2]) or (RawCode in [68,69]);
      LEAVEDEF(RawCode,GadCode);
   end;
end;



begin {*** MAIN ***}
   OpenLib(DOSBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINECHANNELC
         else if (Flags=MDC_DOIT) then begin
            DOCHANNELC;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   Closelib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
