Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod","Internal.mod","schieber.mod"}



procedure DOTRIAC(SAddr,StartOffset,EndOffset :long);

var NowKill,DataBefore,Addr1    :long;
var Data1                       :^long;
var Kill                        :boolean;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      Kill:=false;
      NowKill:=round(Operator[1]*MAX24/90);
      if OpType=1 then begin
         Addr1:=SAddr+StartOffset+4;
         Data1:=ptr(SAddr); DataBefore:=Data1^;
         if abs(Data1^)<NowKill then Kill:=true;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            if abs(Data1^)>NowKill then Kill:=false;
            if (Data1^>0) and (DataBefore<0) or
               (Data1^<0) and (DataBefore>0) or
               (Data1^=0) or (DataBefore=0) then Kill:=true;
            DataBefore:=Data1^;
            if Kill then Data1^:=0;
         until Addr1>=SAddr+EndOffset;
      end else if OpType=2 then begin
         Addr1:=SAddr+StartOffset+4;
         Data1:=ptr(SAddr); DataBefore:=Data1^;
         if abs(Data1^)>NowKill then Kill:=true;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            if (abs(Data1^)<NowKill) and (DataBefore>NowKill) or
               (abs(Data1^)<NowKill) and (abs(DataBefore)>abs(Data1^))
               then Kill:=true;
            if (Data1^>0) and (DataBefore<0) or
               (Data1^<0) and (DataBefore>0) or
               (Data1^=0) then Kill:=false;
            DataBefore:=Data1^;
            if Kill then Data1^:=0;
         until Addr1>=SAddr+EndOffset;
      end;
   end;
end;



procedure DEFINETRIAC;

var MySList     :SelectListGad;

begin
   if not OPENDWIN(106,0,DWindow,MyWTStdMsg^.PText[86],3,1) then exit;
   with MyWTStdMsg^.ActWaveOp^ do begin
      Operation:=16;
      if (Operator[1]=-1) then begin
         Operator[1]:=30;
         OpType:=1;
      end;
      CREATEGADS(1,1,0);
      ACTIVECHANNELGADS(MyWTStdMsg^.ActiveMode,Channels);
      DKnopf[9].GadgetText:=^DKnopfTx[OpType];
      for i:=1 to 2 do DKnopfTx[i]:=IntuiText(2,0,0,4,2,MyWTStdMsg^.WTScreen^.Font,
                                              MyWTStdMsg^.PText[i+86],NIL);
      MySList:=SelectListGad(DWindow,^DKnopf[9],OpType,0,0,0,ITTArr(^DKnopfTx[1],
                              ^DKnopfTx[2],NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL));
      CREATEPROPGAD(10,86,pred(Operator[1])*744,736,1,9,DWindow^);
      Buffer[1]:=intstr(Operator[1]);

      WRITE(414,87,2,0,DWindow^,MyWTStdMsg^.PText[89]);
      AddGadget(DWindow,^TextGad[1],NIL);
      AddGadget(DWindow,^Schieber[1],NIL);
      AddGadget(DWindow,^DKnopf[9],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat

         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress;
               GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg)
         End else delay(1);

         if GadCode=9 then OpType:=DOSELECTLIST(^MySList);

         if (GadCode=10) or not (Schieber[1].flags and SELECTED=0) then begin
            Operator[1]:=succ(SchieberInfo[1].HorizPot div 744);
            if Operator[1]<1 then Operator[1]:=1;
            if Operator[1]>89 then Operator[1]:=89;
            Buffer[1]:=intstr(Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
         end;
         if Gadcode=11 then begin
            val(Buffer[1],Operator[1],i);
            if Operator[1]<1 then Operator[1]:=1;
            if Operator[1]>89 then Operator[1]:=89;
            Buffer[1]:=intstr(Operator[1]);
            SchieberInfo[1].HorizPot:=pred(Operator[1])*744;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode in [68,69]);
      Channels:=GETACTIVECHANNELS;
      LEAVEDEF(RawCode,GadCode);
      SoundMode:=MyWTStdMsg^.ActiveMode;
      WAreaA:=MyWTStdMsg^.AreaA;
      WAreaE:=MyWTStdMsg^.AreaE;
   end;
end;




begin {*** MAIN ***}
   OpenLib(DOSBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINETRIAC
         else if (Flags=MDC_DOIT) then begin
            Flags:=0;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) then
                DOTRIAC(MyWTStdMsg^.MemA24[ChID],BeginOffset,EndOffset);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   Closelib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
