Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Internal.mod"}


procedure DOMIXAROUND(SAddr,AlphaSAddr,StartOffset,EndOffset :long);

var Addr1,Addr2         :long;
var Data1,Data2         :^long;
var DataA1,DataA2       :^byte;

begin
   if SAddr<>0 then begin
      Addr1:=SAddr+StartOffset; Addr2:=SAddr+EndOffset;
      while Addr1<Addr2 do begin
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data2:=ptr(Addr2); Addr2:=Addr2-4;
         Data1^:=(Data1^+Data2^) div 2;
         Data2^:=Data1^;
      end;
   end;
   if AlphaSAddr<>0 then begin
      Addr1:=AlphaSAddr+StartOffset div 80;
      Addr2:=AlphaSAddr+round(EndOffset/80+0.5);
      while Addr1<Addr2 do begin
         DataA1:=ptr(Addr1); Addr1:=Addr1+1;
         DataA2:=ptr(Addr2); Addr2:=Addr2-1;
         DataA1^:=DataA1^ div 2 + DataA2^ div 2;
         DataA2^:=DataA1^;
      end;
   end;
end;



procedure DEFINEMIXAROUND;

begin
   MyWTStdMsg^.ActWaveOp^.Operation:=15;
   MyWTStdMsg^.ActWaveOp^.Channels:=$3F;
   MyWTStdMsg^.ActWaveOp^.WAreaA:=MyWTStdMsg^.AreaA;
   MyWTStdMsg^.ActWaveOp^.WAreaE:=MyWTStdMsg^.AreaE;
   MyWTStdMsg^.Flags:=MDE_READY;
end;




begin {*** MAIN ***}
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINEMIXAROUND
         else if (Flags=MDC_DOIT) then begin
            Flags:=0;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) then
                DOMIXAROUND(MyWTStdMsg^.MemA24[ChID],MyWTStdMsg^.MemAAlpha[ChID],BeginOffset,EndOffset);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
end.



