Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod","Internal.mod","schieber.mod"}


procedure DOHEAVY(SAddr,AlphaSAddr,StartOffset,EndOffset :long);

var Stepsize,Factor             :real;
var Addr1,Steps,Ti,Op1,Op2      :long;
var Data1                       :^long;
var DataA                       :^byte;

begin
   Steps:=0;
   with MyWTStdMsg^.ActWaveOp^ do begin
      if (AlphaSAddr<>0) and (OpType and $80<>0) then begin
         Op1:=round(Operator[1]/20);  Op2:=round(Operator[2]/20);
         Stepsize:=(Operator[4]-Operator[3])/(EndOffset-StartOffset)*80;
         Factor:=Operator[3];  Ti:=0;
         Ti:=Op1;
         Addr1:=AlphaSAddr+StartOffset div 80;
         repeat
            DataA:=ptr(Addr1); Addr1:=Addr1+1; Ti:=Ti+1;
            if Ti>=Op1 then begin
               Addr1:=Addr1+Op2;
               Factor:=Factor+(Stepsize*Op2);
               Ti:=0;
            end;
            DataA^:=round(DataA^/100*Factor);
            Factor:=Factor+Stepsize;
         until Addr1>=AlphaSAddr+round(EndOffset/80+0.5);
      end else begin
         Op1:=Operator[1]*4;  Op2:=Operator[2]*4;
         Stepsize:=(Operator[4]-Operator[3])/(EndOffset-StartOffset)*4;
         Factor:=Operator[3];  Ti:=0;
         Ti:=Op1;
         Addr1:=SAddr+StartOffset;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4; Ti:=Ti+1;
            if Ti>=Operator[1] then begin
               Addr1:=Addr1+Op2;
               Factor:=Factor+(Stepsize*Op2)/4;
               Ti:=0;
            end;
            Data1^:=round(Data1^/100*Factor);
            Factor:=Factor+Stepsize;
         until Addr1>=SAddr+EndOffset;
      end;
   end;
end;



procedure DEFINEHEAVY;


procedure DRAWGRAPH;

var Middle      :integer;
var s           :string[10];

const x=240;
const y=68;

begin
   RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
   with MyWTStdMsg^.ActWaveOp^ do begin
      SetAPen(DWindow^.RPort,0);
      RectFill(DWindow^.RPort,x,y-26,x+160,y);
      RectFill(DWindow^.RPort,x,y+8,x+160,y+20);
      s:=MyWTStdMsg^.PText[81]+' Ti+Tp='+intstr(Operator[1]+Operator[2])+' Bytes';
      WRITE(x+2,y+7,2,0,DWindow^,s);
      Middle:=round((160*Operator[1]) div (Operator[1]+Operator[2]))+x;
      SetAPen(DWindow^.RPort,6);
      Move(DWindow^.RPort,x,y-26);   Draw(DWindow^.RPort,Middle,y-26);
      Draw(DWindow^.RPort,Middle,y); Draw(DWindow^.RPort,x+160,y);
      DRAWLINE(DWindow^,x,round(y-Operator[3]/3.8),x+160,round(y-Operator[4]/3.8),3)
   end;
end;


begin
   if not OPENDWIN(165,0,DWindow,MyWTStdMsg^.PText[76],3,0) then exit;
   with MyWTStdMsg^.ActWaveOp^ do begin
      if (Operator[1]=-1) then begin
         Operator[1]:=50;  Operator[2]:=50;
         Operator[3]:=100; Operator[4]:=1;
      end;
      Operation:=14;
      MAKEBORDER(DWindow^,238,40,402,70,NEGATIVE);
      MAKEBORDER(DWindow^,238,73,402,89,NEGATIVE);
      CREATEGADS(1,0,0);
      ACTIVECHANNELGADS(MyWTStdMsg^.ActiveMode,Channels);
      for i:=1 to 4 do begin
         CREATEPROPGAD(10,77+17*i,pred(Operator[i])*65,65,i,8,DWindow^);
         Buffer[i]:=intstr(Operator[i]);
      end;
      SchieberInfo[3]:=Propinfo(FREEHORIZ,pred(Operator[3])*661,0,655,0,0,0,0,0,0,0);
      SchieberInfo[4]:=Propinfo(FREEHORIZ,pred(Operator[4])*661,0,655,0,0,0,0,0,0,0);

      WRITE(414,95,2,0,DWindow^,MyWTStdMsg^.PText[77]);
      WRITE(414,112,2,0,DWindow^,MyWTStdMsg^.PText[78]);
      WRITE(414,129,2,0,DWindow^,MyWTStdMsg^.PText[79]);
      WRITE(414,146,2,0,DWindow^,MyWTStdMsg^.PText[80]);

      DKnopf[9]:=Gadget(NIL,540,90,
                        21,12,GADGHIMAGE+GADGIMAGE,TOGGLESELECT+RELVERIFY,
                        BOOLGADGET,MyWTStdMsg^.WTImg^.ButtonImg1,
                        MyWTStdMsg^.WtImg^.ButtonImg2,NIL,0,Nil,20,0);
      WRITE(550,106,2,3,DWindow^,MyWTStdMsg^.PText[23]);
      if ((MyWTStdMsg^.MemAAlpha[1] or MyWTStdMsg^.MemAAlpha[3])=0) or (Operator[1]<20)
      or (Operator[2]<20) then DKnopf[9].Flags:=DKnopf[9].Flags or GADGDISABLED;
      if (OpType and $80=$80) then DKnopf[9].Flags:=DKnopf[9].Flags or SELECTED;
      AddGadget(DWindow,^DKnopf[9],NIL);
      for i:=1 to 4 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 4 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      DRAWGRAPH;
      repeat

         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress;
               GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg)
         End else delay(1);
         if (GadCode=9) or not (Schieber[1].flags and SELECTED=0) then begin
            Operator[1]:=succ(SchieberInfo[1].HorizPot div 65);
            if Operator[1]>1000 then Operator[1]:=1000;
            if Operator[1]<1 then Operator[1]:=1;
            Buffer[1]:=intstr(Operator[1]);
            DRAWGRAPH;
         end;
         if Gadcode=10 then begin
            val(Buffer[1],Operator[1],i);
            if Operator[1]>1000 then Operator[1]:=1000;
            if Operator[1]<1 then Operator[1]:=1;
            Buffer[1]:=intstr(Operator[1]);
            SchieberInfo[1].HorizPot:=pred(Operator[1])*65;
            DRAWGRAPH;
         end;

         if (GadCode=11) or not (Schieber[2].flags and SELECTED=0) then begin
            Operator[2]:=succ(SchieberInfo[2].HorizPot div 65);
            if Operator[2]>1000 then Operator[2]:=1000;
            if Operator[2]<1 then Operator[2]:=1;
            Buffer[2]:=intstr(Operator[2]);
            DRAWGRAPH;
         end;
         if GadCode=12 then begin
            val(Buffer[2],Operator[2],i);
            if Operator[2]>1000 then Operator[2]:=1000;
            if Operator[2]<1 then Operator[2]:=1;
            Buffer[2]:=intstr(Operator[2]);
            SchieberInfo[2].HorizPot:=pred(Operator[2])*65;
            DRAWGRAPH;
         end;

         if GadCode in [9..12] then begin
            if ((MyWTStdMsg^.MemAAlpha[1] or MyWTStdMsg^.MemAAlpha[3])<>0) and (Operator[1]>=20)
            and (Operator[2]>=20) then DKnopf[9].Flags:=DKnopf[9].Flags and not GADGDISABLED;
            if (Operator[1]<20) or (Operator[2]<20) then DKnopf[9].Flags:=DKnopf[9].Flags or GADGDISABLED;
         end;

         if (GadCode=13) or not (Schieber[3].flags and SELECTED=0) then begin
            Operator[3]:=succ(SchieberInfo[3].HorizPot div 661);
            if Operator[3]>100 then Operator[3]:=100;
            if Operator[3]<1 then Operator[3]:=1;
            Buffer[3]:=intstr(Operator[3]);
            DRAWGRAPH;
         end;
         if GadCode=14 then begin
            val(Buffer[3],Operator[3],i);
            if Operator[3]>100 then Operator[3]:=100;
            if Operator[3]<1 then Operator[3]:=1;
            Buffer[3]:=intstr(Operator[3]);
            SchieberInfo[3].HorizPot:=pred(Operator[3])*661;
            DRAWGRAPH;
         end;

         if (GadCode=15) or not (Schieber[4].flags and SELECTED=0) then begin
            Operator[4]:=succ(SchieberInfo[4].HorizPot div 661);
            if Operator[4]>100 then Operator[4]:=100;
            if Operator[4]<1 then Operator[4]:=1;
            Buffer[4]:=intstr(Operator[4]);
            DRAWGRAPH;
         end;
         if GadCode=16 then begin
            val(Buffer[4],Operator[4],i);
            if Operator[4]>100 then Operator[4]:=100;
            if Operator[4]<1 then Operator[4]:=1;
            Buffer[4]:=intstr(Operator[4]);
            SchieberInfo[4].HorizPot:=pred(Operator[4])*661;
            DRAWGRAPH;
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      if not (DKnopf[9].Flags and SELECTED=0) and (DKnopf[9].Flags and GADGDISABLED=0)
      then MyWTStdMsg^.ActWaveOp^.OpType:=$80
      else MyWTStdMsg^.ActWaveOp^.OpType:=0;
      Channels:=GETACTIVECHANNELS;
      LEAVEDEF(RawCode,GadCode);
      SoundMode:=MyWTStdMsg^.ActiveMode;
      WAreaA:=MyWTStdMsg^.AreaA;
      WAreaE:=MyWTStdMsg^.AreaE;
   end;
end;

begin {*** MAIN ***}
   OpenLib(DOSBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINEHEAVY
         else if (Flags=MDC_DOIT) then begin
            Flags:=0;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) then
                DOHEAVY(MyWTStdMsg^.MemA24[ChID],MyWTStdMsg^.MemAAlpha[ChID],BeginOffset,EndOffset);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   Closelib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
