Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Internal.mod"}




procedure DOCUTZERO(SAddr,AlphaSAddr,StartOffset,EndOffset :long);

var Addr1,Addr2,AddrA1,AddrA2   :long;
var Data1,Data2                 :^long;
var DataA1,DataA2               :^byte;
var ACtr1,ACtr2                 :byte;


procedure NORMALALPHA;

begin
   if ACtr1>=20 then begin
      ACtr1:=0;
      DataA1:=ptr(AddrA1); AddrA1:=AddrA1+1;
      DataA2:=ptr(AddrA2);
      DataA1^:=DataA2^;
   end;
   if ACtr2>=20 then begin
      ACtr2:=0;
      DataA2:=ptr(AddrA2); AddrA2:=AddrA2+1;
      DataA1^:=DataA2^;
   end;
end;



begin
   if SAddr=0 then exit;
   Addr1:=SAddr+StartOffset;              Addr2:=Addr1;
   AddrA1:=AlphaSAddr+StartOffset div 80; AddrA2:=AddrA1;
   ACtr1:=20;                             ACtr2:=ACtr1;
   repeat
      Data2:=ptr(Addr2); Addr2:=Addr2+4;
      Data1:=ptr(Addr1); Addr1:=Addr1+4;
      if AlphaSAddr<>0 then NORMALALPHA;
      ACtr1:=ACtr1+1; ACtr2:=ACtr2+1;
      while (abs(Data2^) in [0..200]) and (Addr2<SAddr+EndOffset) do begin
         Data2:=ptr(Addr2); Addr2:=Addr2+4;
         if AlphaSAddr<>0 then NORMALALPHA;
         ACtr2:=ACtr2+1;
      end;
      Data1^:=Data2^;
   until Addr2>=SAddr+EndOffset;
   if Addr2<SAddr+MyWTstdMsg^.PlayL24 then begin
      CopyMemQuick(Addr2,Addr1,SAddr+MyWTStdMsg^.PlayL24-Addr2);
      if AlphaSAddr<>0 then CopyMem(AddrA2,AddrA1,AlphaSAddr+round(MyWTstdMsg^.PlayL24/80+0.5)-AddrA2);
      Addr1:=Addr1+(SAddr+MyWTstdMsg^.PlayL24-Addr2);
      AddrA1:=AddrA1+(AlphaSAddr+MyWTstdMsg^.PlayL24 div 80-AddrA2);
   end;
   while Addr1<SAddr+MyWTstdMsg^.PlayL24 do begin
      Data1:=ptr(Addr1); Addr1:=Addr1+4;
      Data1^:=0;
   end;
   while (AddrA1<AlphaSAddr+round(MyWTstdMsg^.PlayL24/80+0.5)) and (AlphaSAddr<>0) do begin
      DataA1:=ptr(AddrA1); AddrA1:=AddrA1+1;
      DataA1^:=1;
   end;
end;



procedure DEFINECUTZERO;

begin
   MyWTstdMsg^.ActWaveOp^.Operation:=13;
   MyWTstdMsg^.ActWaveOp^.Channels:=$3F;
   MyWTstdMsg^.ActWaveOp^.WAreaA:=MyWTstdMsg^.AreaA;
   MyWTstdMsg^.ActWaveOp^.WAreaE:=MyWTstdMsg^.AreaE;
   MyWTStdMsg^.Flags:=MDE_READY;
end;



begin {*** MAIN ***}
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINECUTZERO
         else if (Flags=MDC_DOIT) then begin
            Flags:=0;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) then
                DOCUTZERO(MyWTStdMsg^.MemA24[ChID],MyWTStdMsg^.MemAAlpha[ChID],BeginOffset,EndOffset);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
end.



