Program Effect;

USES ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/"; incl "WTIncl.mod","ModIncl.mod",
       "Effincl.mod","Internal.mod","schieber.mod"}



procedure GETGAD(GadID :byte; Factor,Max :word);

var GadNum      :byte;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      GadNum:=GadID*2-1;
      if (GadCode=GadNum+2) or not (Schieber[GadID].flags and SELECTED=0) then begin
         Operator[GadID]:=succ(SchieberInfo[GadID].HorizPot div Factor);
         if Operator[GadID]>Max then Operator[GadID]:=Max;
         if Operator[GadID]<1 then Operator[GadID]:=1;
         Buffer[GadID]:=intstr(Operator[GadID]);
         RefreshGadgets(^Schieber[GadID],DWindow,NIL);
      end;
      if (GadCode=GadNum+3) then begin
         val(Buffer[GadID],Operator[GadID],i);
         if Operator[GadID]>Max then Operator[GadID]:=Max;
         if Operator[GadID]<1 then Operator[GadID]:=1;
         Buffer[GadID]:=intstr(Operator[GadID]);
         SchieberInfo[GadID].HorizPot:=pred(Operator[GadID])*Factor;
         RefreshGadgets(^Schieber[GadID],DWindow,NIL);
      end;
   end;
end;



procedure CREATEBOARDGADS(Factor1,Factor2,TextNum :word);

var ChBit,i     :byte;
var s           :string[20];

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      ChBit:=1;
      for i:=1 to 7 do begin
         if i<7 then begin
            if Operator[i]<1 then Operator[i]:=1;
            l:=Operator[i]
         end else l:=Operator[1];
         Buffer[i]:=intstr(l);
         CREATEPROPGAD(10,23+17*i,pred(l)*Factor1,Factor2,i,2,DWindow^);
         if (i<7) and (MyWTStdMsg^.ActiveChannels and ChBit=0) then begin
            Schieber[i].Flags:=Schieber[i].Flags or GADGDISABLED;
            TextGad[i].Flags:=TextGad[i].Flags or GADGDISABLED;
         end;
         case i of
            1: s:='L'
            2: s:='R'
            3: s:='C'
            4: s:='SL'
            5: s:='SR'
            6: s:='Sub'
            7: s:=MyWTStdMsg^.PText[TextNum];
         end;
         WRITE(414,i*17+24,2,0,DWindow^,s);
         ChBit:=ChBit*2;
      end;
      for i:=1 to 7 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 7 do AddGadget(DWindow,^Schieber[i],NIL);
   end;
end;



procedure DODIGITIZER(SAddr,StartOffset,EndOffset :long; ChID :byte);

var Divider,Bits,j,Addr1        :long;
var Data1                       :^long;
var s                           :string[50];

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      if Operator[ChID]>=24 then exit;
      l:=Operator[ChID]+6; if l>24 then l:=24;
      for i:=l downto Operator[ChID] do begin
         s:='   '+MyWTStdMsg^.PText[113]+' '+intstr(i)+' Bit ';
         MyWTStdMsg^.Flags:=0;
         MyWTStdMsg^.WTMsgPrc^:=MsgPrc(WTM_WORKINFO,s,'','','','',1,0,0,0,0,NIL);
         MESSAGEHANDLE;
         Bits:=24-i;
         Divider:=1;
         for j:=1 to Bits do Divider:=Divider*2;
         Addr1:=SAddr+StartOffset;
         repeat
            Data1:=Ptr(Addr1); Addr1:=Addr1+4;
            Data1^:=round(Data1^ / Divider)*Divider;
         until Addr1>=SAddr+EndOffset;
      end;
   end;
end;



procedure DEFINEDIGITIZER;

var s           :string;
var l           :long;
var ChBit       :byte;

begin
   if not OPENDWIN(162,0,DWindow,MyWTStdMsg^.PText[71],1,0) then exit;
   with MyWTStdMsg^.ActWaveOp^ do begin
      if (Operator[1]=-1) then for i:=1 to 6 do Operator[i]:=8;
      Operation:=12;
      CREATEBOARDGADS(2849,2730,72);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat

         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress;
               GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg)
         End else delay(1);

         for i:=1 to 6 do GETGAD(i,2849,24);

         if (GadCode=15) or not (Schieber[7].flags and SELECTED=0) then begin
            l:=succ(SchieberInfo[7].HorizPot div 2849);
            if l>24 then l:=24;
            if l<1 then l:=1;
            for i:=1 to 7 do begin
               if i<7 then Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=pred(l)*2849;
            end;
            RefreshGadgets(^Schieber[7],DWindow,NIL);
         end;
         if (GadCode=16) then begin
            val(Buffer[7],l,i);
            if l>24 then l:=24;
            if l<1 then l:=1;
            for i:=1 to 7 do begin
               if i<7 then Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=pred(l)*2849;
            end;
            RefreshGadgets(^Schieber[7],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      LEAVEDEF(RawCode,GadCode);
      Channels:=MyWTStdMsg^.ActiveChannels;
      SoundMode:=MyWTStdMsg^.ActiveMode;
      WAreaA:=MyWTStdMsg^.AreaA;
      WAreaE:=MyWTStdMsg^.AreaE;
   end;
end;



begin {*** MAIN ***}
   OpenLib(DOSBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if (Flags=MDC_DEFINEIT) then DEFINEDIGITIZER
         else if (Flags=MDC_DOIT) then begin
            Flags:=0;
            WTMsgPrc^:=msgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) then
                DODIGITIZER(MyWTStdMsg^.MemA24[ChID],BeginOffset,EndOffset,ChID);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end else Flags:=MDE_ERROR;
      end else MyWTStdMsg^.Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   Closelib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
