{$if not def WTINCL_MOD}
CONST WTINCL_MOD=0;

CONST             {*** MDC_ MoDuleCommands ***}
 MDC_ASKREADY  =1;
 MDC_DEFINEIT  =2;
 MDC_CONFIG    =3;
 MDC_DOIT      =8;

CONST             {*** MDE_ MoDuleErrors ***}
 MDE_READY=1;
 MDE_CANCELLED=2;
 MDE_FILEERROR=3;
 MDE_ERROR=4;
 MDE_NOTMYFORMAT=8;
 MDE_WRONG_MODULEVERSION=16;
 MDE_NO_MEMORY=32;
 MDE_BREAK=64;
 MDE_CHANNELERROR=128;
 MDE_NICE_SOFTMOD=512;

CONST             {*** WTM_ WaveTracerMessage ***}
 WTM_TASKREQ            =$0001;
 WTM_FILEREQ            =$0002;
 WTM_GETABORTINFO       =$0003;
 WTM_TASKMSG            =$0004;
 WTM_WORKINFO           =$0005;
 WTM_HANDLEMOD          =$0006;
 WTM_AUTODWIN           =$0007;
 WTM_OPENDWIN           =$0008;
 WTM_GETMARKADDR        =$0009;
 WTM_LEAVEWIN           =$000A;
 WTM_SETCHANNELGADS     =$000B;
 WTM_GETCHANNELGADS     =$000C;
 WTM_ALLOCALPHA         =$000D;
 WTM_GETMARKOFFSET      =$000E;
 WTM_RESTOREALPHA       =$000F;
 WTM_PREFSPROCESS       =$0010;
 WTM_ALLOCUNDO          =$0011;
 WTM_FREEUNDO           =$0012;
 WTM_FREEPLAYLIST       =$0013;
 WTM_ADDPATTERN         =$0014;
 WTM_ADDENTRY           =$0015;
 WTM_GETCHANNELBITS     =$0016;
 WTM_GETSOUNDMODE       =$0017;
 WTM_DOSELECTLIST       =$0018;
 WTM_LONGREQ            =$0019;
 WTM_DRAWTIMEPATTERNLIST=$001A;
 WTM_ADDANIMPATH        =$001B;
 WTM_ALLOCCHANNEL       =$001C;
 WTM_FREECHANNEL        =$001D;
 WTM_ALLOC_SPECIAL_DATA =$001E;
 WTM_PLAYKEYS           =$0020;
 WTM_SPECIAL_DATA_FOUND =$0040;
 WTM_PLAY               =$0080;
 WTM_STOPPLAY           =$0100;
 WTM_CHANNELREQ         =$0200;
 WTM_GETNOTEFREQ        =$0800;
 WTM_CALCWAVE           =$1000;
 WTM_WORK_BACKGROUND=$80000000;

CONST             {*** CH_ CHannel ***}
 CH_LEFT=1;
 CH_RIGHT=2;
 CH_CENTER=4;
 CH_SLEFT=8;
 CH_SRIGHT=16;
 CH_SUB=32;

CONST             {*** MD_ MoDe ***}
 MD_MONO=1;
 MD_STEREO=2;
 MD_3CH=3;
 MD_QUADRO=4;
 MD_SURROUND=5;
 MD_AC3_Sub=6;
 MD_AC3=7;

CONST             {*** Portnames ***}
 PORT_WT='WaveTracerPort';
 PORT_EFFECTMOD='WTEffectModPort';
 PORT_LOADER='WTLoaderPort';
 PORT_SAVER='WTSaverPort';

CONST             {*** Portversions ***}
 VERSION_WT=1;
 VERSION_EFFECTMOD=4;
 VERSION_LOADER=2;
 VERSION_SAVER=3;

CONST             {*** Samplekompressions ***}
 COMPRESSION_FIBONACCI_DELTA=$1;
 COMPRESSION_3BYTE          =$2;
 COMPRESSION_DELTA          =$4;
 COMPRESSION_DELTA_2        =$8;

CONST
 EFF_DEFWIN=$1;
 EFF_NOCALC=$2;

Const
 MAX24=8388600;
 MAXSIZE=50000000;

CONST             {*** SpecialData-Typen ***}
 SD_SHORT_TEXT=$1;
 SD_TEXT=$2;
 SD_ANIMINFO=$3;
 SD_IMAGE=$4;
 SD_LOOP=$5;
 SD_MARKER_ARRAY=$8;
 SD_PLAYLIST=$10;
 SD_ALPHA_CHANNEL=$20;
 SD_SCENE=$40;


type r_SDHeader=^SDHeader;
type SDHeader=record;
        NextSpecialData         :r_SDHeader;
        sdh_Size,sdh_Type       :long;
     end;

type r_SDBodyShortText=^SDBodyShortText;
type SDBodyShortText=record
        sdb_SDHeader            :SDHeader;
        sdb_TextString          :string[100];
     end;

type r_SDBodyANIM=^SDBodyAnim
type SDBodyANIM=record
        sdb_SDHeader            :SDHeader;
        sdb_Frames              :long;
        sdb_FPS,sdb_Flags       :byte;
        sdb_pad                 :word;
     end;

type r_SDBodyScene=^SDBodyScene
type SDBodyScene=record
        sdb_SDHeader            :SDHeader;
        sdb_Name                :string[200];
        sdb_StartFrame          :long;
        sdb_EndFrame            :long;
     end;
     
type r_SDBodyLoop=^SDBodyLoop
type SDBodyLoop=record
        sdb_SDHeader            :SDHeader;
        sdb_Loop,sdb_pad        :word;    
     end;

type BlueNote=record
        bn_NoteName                         :array[0..6,1..12] of String[4];
        bn_SampleFreq                       :array[0..6,1..12] of real;
        bn_PlayRate                         :array[0..6,1..12] of word;
        bn_PosX,bn_PosY                     :short;
     end;

type r_WaveOp=^WaveOp;
type WaveOp=Record
        ChunkSize,SoundMode                 :byte;
        Operation,OpType,Channels,Flags     :integer;
        Operator                            :array[1..6] of long;
        WAreaA,WAreaE                       :long;                   { -  42 }
        OpString                            :string[81];             { - 123 }
        MemLData,MemAData                   :long;                   { - 131 }
     end;

type ITTArr=array [1..15] of ^IntuiText
type r_SelectListGad=^SelectListGad;
type SelectListGad=record
        GadWindow                       :^Window;
        SGad                            :^Gadget;
        SelectedGad,pad1,pad2,pad3      :byte;
        ITextTag                        :ITTArr;
     end;

const
   WOP_SMALL=42;
   WOP_NORM=123;
   WOP_BIG=131;

type p_WTImages=^WTImages;
type WTImages=Record
        HiSys,Share                             :boolean;
        XXX,KnobImg,CalcImg                     :^Image;
        GImg1,GImg2,GImg3,GImg4,GImg5,GImg6     :^Image;
        ButtonImg1,ButtonImg2,ButtonImg3        :^Image;
        None1,None2,None3                       :^Image;
        Notes                                   :^BlueNote;
        OKIText,CIText                          :^IntuiText;
        ButtonImg4,ButtonImg5,ButtonImg6        :^Image;
     end;
type p_MsgPrc=^MsgPrc;
type MsgPrc=record
        PRC_Flags                                           :long;
        PRC_Str1, PRC_Str2, PRC_Str3, PRC_Str4, PRC_Str5    :string[200]
        PRC_Long1,PRC_Long2,PRC_Long3,PRC_Long4,PRC_Long5   :long;
        PRC_NewPtr                      :ptr;
     end;
type p_ChCoords=^ChCoords
type ChCoords=record
        ChX     :array [1..6] of short;
        ChY     :array [1..6] of short;
     end;
type PlayListEntry=^r_PlayListEntry;
type r_PlayListEntry=record
        BeginOffset,EndOffset           :long;
        Rate,Delay,Time                 :long;
        Loop,VolumeL,VolumeR            :integer;
        Name                            :string[30];
        BeforeEntry,NextEntry           :PlayListEntry;
     end;
type PlayListPattern=^r_PlayListPattern;
type r_PlayListPattern=record
        BeginOffset,EndOffset           :long;
        Name                            :string[30];
        BeforePattern,NextPattern       :PlayListPattern;
     end;
type p_WTStdMsg=^WTStdMsg;
type WTStdMsg=Record
        wt_Node                         :Message;
        UNDOPossible                    :boolean;
        Flags,Version                   :long;
        WTScreen                        :^Screen;
        WTWindow                        :^Window;
        ActiveChannels,ActiveMode       :long;
        MemA16,MemA24,MemAUndo          :array [1..6] of long;
        MemL24,PlayL24,SRate            :long;
        Attack,Decay,Sustain,Release    :long;
        ActWaveOp                       :^WaveOp;
        OPos,OEnd,AreaA,AreaE           :long;
        ActFHandle                      :BPTR;
        WTImg                           :^WTImages
        WTMsgPrc                        :^MsgPrc;
        PosSurround,PosQuadro,PosAC3    :^ChCoords;
        UsedChannels                    :long;
        MemAAlpha,AlphaUNDO             :array [1..6] of long;
        DataValid                       :long;
        FirstPlayListPattern            :PlayListPattern;
        FirstPlayListEntry              :PlayListEntry;
        SpecialData                     :^SDHeader;
        AnimPath                        :str;
        Free1,Free2,Free3,Free4,
        Free5,Free6                     :ptr;
     end;

{$endif}
