program SAVER;

{  by QXC & VWP! All Rights Reserved! Siehe "Programmierung.Guide" und
  "Grammophon.eff.p" fr weitere Copyright-Infos }

Uses ExecIO;

type Image=ptr;
type Window=ptr;
type Screen=ptr;
type IntuiText=ptr;

{$incl "libraries/dos.h","exec/memory.h"};
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod"}

{ WTIncl.mod  - Alle wichtigen Strukturen und Konstanten
  ModIncl.mod - Alle fr das Modulehandling erforderlichen Proceduren,
                Strukturen und variablendefinitionen }


procedure SAVERAW;

var SMemA,SMemL,Addr1,Addr8,l,m :long;
var Data8                       :^byte;
var Data1                       :^long;
var ChBit,ChID                  :byte;

begin
   with MyWTstdMsg^ do begin
      Flags:=0;
      SMemL:=PlayL24 div 4;
      SMemA:=AllocFastFirst(SMemL,MEMF_CLEAR);
      if SMemA=0 then begin
         SMemL:=AvailMem(MEMF_LARGEST);
         if SMemL>PlayL24 div 4 then SMemL:=PlayL24 div 4;
         SMemA:=AllocFastFirst(SMemL,MEMF_CLEAR);
         if SMemA=0 then begin
            Flags:=MDE_NO_MEMORY;        { Nicht genug Speicher vorhanden,
                                           Fehlermeldung gibt der WaveTracer
                                           aus }
            exit;
         end;
      end;
      ChBit:=1;
      for ChID:=1 to 6 do begin
         if not (ActiveChannels and ChBit=0) then begin
            if MemA24[ChID]<>0 then begin
               l:=0; Addr1:=MemA24[ChID];
               repeat
                  Addr8:=SMemA;
                  repeat
                     Data1:=ptr(Addr1); Addr1:=Addr1+4;
                     Data8:=ptr(Addr8); Addr8:=Addr8+1;
                     Data8^:=(Data1^ div 65536) + 127;
                  until (Addr8>=SMemA+SMemL) or (Addr1>=MemA24[ChID]+PlayL24);
                  m:=DosWrite(ActFHandle,ptr(SMemA),Addr8-SMemA);
                  if m<Addr8-SMemA then begin
                     FreeMem(SMemA,SMemL);
                     Flags:=MDE_FILEERROR; { Datei-Fehler, Fehlermeldung wird
                                             vom WaveTracer abgegeben }
                     exit;
                  end;
                  l:=l+m;
               until l>=PlayL24 div 4
            end;
         end;
         ChBit:=ChBit*2;
      end;
      FreeMem(SMemA,SMemL);
      Flags:=MDE_READY;                  { Alles OK }
   end;
end;


begin
   OpenLib(DosBase,'dos.library',0);
   if CREATEPORTS(PORT_SAVER) then begin { eigenen Port anlegen }
      with MyWTStdMsg^ do if Version=VERSION_SAVER then begin
         if (ActFHandle<>0) and (Flags=MDC_DOIT) then begin
            { einziges Kommando: Daten sollen gespeichert werden. Das FileHandle
              der bereits geffneten Datei Findet sich in MyWTStdMsg^.ActFHandle;
              die Datei darf nicht mit DosClose() geschlossen werden! }
            SAVERAW;
            if Flags=MDE_READY then begin
                                         { Copyright-Infos ausgeben, wenn
                                           erfolgreich gespeichert wurde }
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'PC-/MacIntosh-RAW 8 Bit Sample-Saver',COPYRIGHT,
                                 '','OK','',0,0,0,0,0,NIL);
               MESSAGEHANDLE;
               Flags:=MDE_READY;
            end;
         end else Flags:=MDE_ERROR;      { unbekanntes Kommando vom
                                           WaveTracer }
      end else Flags:=MDE_WRONG_MODULEVERSION;
                                         { unbekannte Modulversion }
      MESSAGEHANDLE;
      RemPort(MyPort);                   { Erfolgsflag (MDE_..) abgeben und
                                           eigenen Port entfernen }
   end;
   CloseLib(DosBase);
end.

