program LOADER;

{  by QXC & VWP! All Rights Reserved! Siehe "Programmierung.Guide" und
  "Grammophon.eff.p" fr ausfhrliche Copyright-Infos }

Uses ExecIO;

type Image=ptr;
type Window=ptr;
type Screen=ptr;
type IntuiText=ptr;

{$incl "libraries/dos.h","exec/memory.h"};
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod"}

{ WTIncl.mod  - Alle wichtigen Strukturen und Konstanten
  ModIncl.mod - Alle fr das Modulehandling wichtigen Proceduren, Strukturen
                und Variablendefinitionen }

var Addr1,Addr8,l,m                             :long;
var Data8                                       :^byte;
var Data1                                       :^long;
var i                                           :integer;
var MemLS                                       :long;
var ChCnt                                       :byte;



procedure CHECKSIZE;

begin
   with MyWTStdMsg^ do begin
      l:=DosSeek(ActFHandle,0,OFFSET_END);
      MemLS:=DosSeek(ActFHandle,0,OFFSET_BEGINNING);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_CHANNELREQ,'Welche Kanle enthlt das RAW-Sample?',
                        '','','','',$3F,ActiveChannels,0,0,0,NIL);
      MESSAGEHANDLE;
                                         { WaveTracer interne Funktion fr einen
                                           Kanal-Requester, das Ergebnis steht bei
                                           Erfolg in PRC_Long1 }
      if WTMsgPrc^.PRC_Long1=-1 then ActiveChannels:=1 else ActiveChannels:=WTMsgPrc^.PRC_Long1;
      ChCnt:=0;
      l:=1;   for i:=1 to 6 do begin
         if not (ActiveChannels and l=0) then ChCnt:=ChCnt+1;
      l:=l*2; end;
      if ActiveChannels in [CH_CENTER,CH_LEFT,CH_RIGHT] then ActiveMode:=MD_MONO
      else if ActiveChannels<=CH_LEFT+CH_RIGHT then ActiveMode:=MD_STEREO
      else if ActiveChannels<=CH_LEFT+CH_RIGHT+CH_CENTER then ActiveMode:=MD_3CH;
      if not (ActiveChannels and CH_SLEFT=0) then ActiveMode:=MD_SURROUND;
      if not (ActiveChannels and CH_SRIGHT=0) then ActiveMode:=MD_AC3_SUB;
      if not (ActiveChannels and CH_SUB=0) then Activemode:=MD_AC3;
      MemLS:=MemLS div ChCnt;
                                         { Anhand der vom User angegebenen
                                           Kanle feststellen, welcher Sound-
                                           mode vorliegt }
      Flags:=MDE_READY;
   end;
end;



procedure LOADRAW;

begin
   with MyWTstdMsg^ do begin
      m:=1;
      for i:=1 to 6 do begin
         if not (ActiveChannels and m=0) and (MemA24[i]<>0) then begin
            l:=DosRead(ActFHandle,ptr(MemA24[i]+MemL24-MemLS),MemLS);
            if l<MemLS then begin
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Kann Daten nicht laden!','Operation abgebrochen!',
                                 '','OK','',0,0,0,0,0,NIL);
               MESSAGEHANDLE;            { Fehler aufgetreten: Fehlermeldung ab-
                                           geben und mit MDE_ERROR beenden }
               Flags:=MDE_ERROR;
               exit;
            end;
            Addr1:=MemA24[i];
            Addr8:=MemA24[i]+MemL24-MemLS;
            repeat
               Data8:=ptr(Addr8); Addr8:=Addr8+1;
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data1^:=(Data8^-127)*65535;
            until Addr8>=MemA24[i]+MemL24;
            PlayL24:=Addr1-MemA24[i];    { Geladene 8Bit-Daten werden in das
                                           24Bit Longword-Format des
                                           WaveTracer umgewandelt }
         end;
         m:=m*2;
      end;
      Flags:=MDE_READY;
   end;
end;


begin
   OpenLib(DosBase,'dos.library',0);
   if CREATEPORTS(PORT_LOADER) then begin  { Eigenen Port anlegen }
      with MyWTStdMsg^ do if Version=VERSION_LOADER then begin
         if Flags=MDC_ASKREADY then begin  { Lademodul wurde neu selektiert }
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'8 Bit AC3 PC-/MacIntosh-RAW Lademodul',
                              COPYRIGHT,'','OK','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;                 { Copyright-Info ausgeben }
            Flags:=MDE_READY;
         end else if ActFHandle<>0 then begin
            { FileHandle auf die bereits geffnete Datei findet sich in
              MyWTStdMsg^.ActFHandle; sie darf nicht mit DosClose geschlossen
              werden, das erledigt der WaveTracer }
            if Flags=MDC_DEFINEIT then begin
                                           { Sample wurde selektiert: der
                                             WaveTracer erwartet jetzt die An-
                                             gaben ber Lnge, Kanle und Sound-
                                             mode }
               CHECKSIZE;
               ActWaveOp^.Operator[1]:=MemLS;
            end else if Flags=MDC_DOIT then begin
                                           { Funktionsgenerator wurde mit "OK" ver-
                                             lassen, das Sample soll mit den ange-
                                             gebenen Werten fr Lnge, Kanlke und
                                             Soundmode geladen werden }
               MemLS:=ActWaveOp^.Operator[1];
               LOADRAW;
            end;
         end else Flags:=MDE_ERROR;        { Unbekanntes Kommando vom WaveTracer }
      end else Flags:=MDE_WRONG_MODULEVERSION;
                                           { Unbekannte Schnittstellen-Version }
      MESSAGEHANDLE;
      RemPort(MyPort);                     { Erfolgs-Flag (MDE_...) absenden
                                             und eigenen Port entfernen }
   end;
   CloseLib(DosBase);
end.
