#include <exec/types.h>
#include <exec/memory.h>

#include <libraries/dos.h>

#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>
#include <stdlib.h>


extern struct DOSBase *DOSBase;

UBYTE     i,ChCnt;
LONG      MemLS;
UBYTE     MyChannels,MyMode;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



BOOL READSAMPLE(void)

{
// Read the file and find out following:

MyWTStdMsg->SRate=(LONG)(10000000.0/(File.SampleFrequency*2.79365));
   // Samplefrequency, converted into Amiga-Playrate
MemLS=File.SampleLength;
   // Samplelength in sampleframes
MyMode=File.Soundmode;
   // Soundmode MD_MONO, MD_STEREO, MD_3CHANNEL,...
MyChannels=File.Channels
   // Kind of channels wich are saved (L, R, C,...)
return TRUE;
};




void LOADSAMPLE(void)

{
// Nowload the sampledata into MyWTStdMsg->MemA24[x] and convert it into 24 bits
MyWTStdMsg->Flags=MDE_READY; // Sample loaded without errors
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Demo-Loader, x Bit");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"copyrighted");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               if (READSAMPLE())
                  {
                  MyWTStdMsg->ActWaveOp->Operator[0]=MemLS;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->ActiveMode=MyMode;
                  MyWTStdMsg->ActiveChannels=MyChannels;
                     // Put all found informations into the WTStdMsg-sructure to send them to the WaveTracer
                  MyWTStdMsg->Flags=MDE_READY;
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (READSAMPLE())
                  {
                  MyChannels=(MyChannels & MyWTStdMsg->ActiveChannels);
                  if (MyChannels==0) MyWTStdMsg->Flags=MDE_CHANNELERROR
                     // Check if selected channels and channels in samplefile fit together
                  else
                     {
                     if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS) MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                        // Check and modify the selected samplesize
                     LOADSAMPLE();
                     }
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;  // Error while reading sampledata
               }
            else MyWTStdMsg->Flags=MDE_ERROR;     // Strange error - a unknown MDC_-command
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);  // Also very strange - the WT hasn't opened the file
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
                                                  // Not so strange, the versions of the WT and the loader doesn't fit together
      MESSAGEHANDLE(); // Send back an answer and quit
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   }
}
