PROGRAM CINETRACER;

USES Intuition,ExecIO,Graphics;

{$incl "libraries/dosextens.h","libraries/dos.h","exec/memory.h",
       "libraries/diskfont.h","soundplay.mod","reqtools.h","AGA.lib"}

{$path "WaveTracer/"; incl "WTIncl.mod"}


{Fehlende TrackAlignment-Werte: Initial y-Rotation und EndFrame-Y-Rotation
 in y und z verstecken, x enthlt im unteren Byte die Nummer des Objectheaders,
 der als Tracked Objekt verwendet wird}

const PREFFILE='ENVARC:CineTracerI.config';
const CTVersion='CineTracer Mark I';
const NEGATIVE=3;
const POSITIVE=0;
const OPENBORDER=1;
const TEXTS=200;

type r_IFFCh=record
        Name    :string[4];
        Length  :long;
     end;
type r_ObjectChunk=record;
        Typ,StartFrame,EndFrame :word;
        x,x2,y,y2,z,z2          :integer;
        v2                      :string[8];
     end;

const OFLAG_TIMEPATTERN=1;
const OFLAG_SOUND=2;
const OFLAG_TRACKED=4;
const OFLAG_SOUNDEND=8;
const OFLAG_TIMEPATTERNONLY=16;
const OFLAG_HIDEOBJECT=32;
const OTYP_OBJECT=4;
const OTYP_AXIS=5;
const OTYP_LIGHT=6;

const FILETYP_Imagine      =1;  {ISTG}
const FILETYP_CineData     =2;  {CINM}
const FILETYP_MaxonCinema4D=3;  {MC4D}
const FILETYP_FastRay      =4;  {FRAY}
const FILETYP_Real3D       =5;  {REAL}
const FILETYP_Reflections  =6;  {REFL}
const FILETYP_AVB          =7;  {#?.trk}

type r_CineData=record;
        x,y,z                   :integer;
        Steps                   :word;
        Res2                    :integer;
        Volume,res1             :byte;
        RelTime                 :long;
     end;
type r_TimeData=record
        StartTime,EndTime       :long;
        Res1                    :long;
     end;
type r_CineDataFileHeader=record;
        c1,c2,c3,c4             :char;
        length                  :long;
        Frames                  :long;
        FPS,pad                 :byte;
        Threshold               :integer;
        AnimJiffies             :long
        reserved                :long;
     end;
type r_ObjectHeader=record
        Flags                           :word
        ObjectTyp,ObjectVolume          :byte;
        EchoVolume,pad1,pad2,pad3       :byte;
        Name                            :string[20];
        Sample                          :string[200];
        StartFrame,EndFrame             :word;
        CineAddr,CineLength             :long;
        StartAddr,EndAddr               :long;
        TimeAddr,TimeLength             :long;
     end;
type ObjectData=^r_ObjectData;
type r_ObjectData=record
        StartFrame,EndFrame     :word;
        x,y,z                   :integer;
     end;
type r_Prefs=record
        ScrID                   :long;
        ScrWidth,ScrHeight      :word;
        LocaleString            :string[70];
        SampleStr               :string[200];
     end;

type Plane =Array[1..128] of long;
type Plane2=Array[1..84] of long;
type ButtonPlane=Array[1..24] of long;
type CalcPlane=Array[1..26] of long;
type KnobPlane=Array[1..22] of long;
type TagArr=array [1..12] of long;
type FTagArr=array [1..6] of long;
type PenArr=array [1..13] of word;

var IFFCh,IFFCh2                        :r_IFFCh;
var CameraSize,MyObjChunk               :r_ObjectChunk;
var MaxFrames,MaxObjects,MaxPositions,
    MaxAlignments                       :long;
var ActObjectHeader                     :^r_ObjectHeader;
var PText                               :array [1..TEXTS] of str;

var CameraYOffset                       :integer;
var Tags                                :TagArr;
var FTags                               :FTagArr;
var Pens                                :PenArr;
var MyFReq                              :^rtFileRequester;
var NeuWindow                           :NewWindow;
var MyWindow                            :^Window;
var NeuScreen                           :NewScreen;
var MyScreen                            :^Screen;
var CustomTA                            :TextAttr;
var CustomFont                          :^TextFont;
var OKKnopfTx,CKnopfTx                  :IntuiText;
var DKnopf,DTextGad                     :array [1..3] of Gadget;
var DKnopfTx                            :array [1..14] of IntuiText;
var DTextInfo                           :array [1..3] of StringInfo;
var DBuffer,DUndoBuffer                 :array [1..3] of string[200];
var Knopf                               :array [1..14] of Gadget;
var TextGad                             :array [1..5] of Gadget;
var TextInfo                            :array [1..5] of StringInfo;
var Buffer,UndoBuffer                   :array [1..8] of string[10];
var SBuffer,SUndoBuffer                 :string[200];
var KnopfTx                             :array [1..5] of IntuiText;
var STextGad                            :array [1..2] of Gadget;
var FPSTextGad,FTextGad                 :Gadget;
var STextInfo                           :array [1..2] of StringInfo;
var FPSTextInfo,FTextInfo               :StringInfo;
var XGadget                             :^Gadget;
var IMsg                                :^IntuiMessage;
var Prefs                               :r_Prefs;
var Process_Ptr                         :p_Process;
var OldWindow_Ptr                       :ptr;

var MenuX               :Menu;
var Mi1                 :array [1..5] of MenuItem;
var MiT                 :array [1..5] of IntuiText;

var InfoPos                                     :word;
var GadCode,Rawcode,Men,MenItem,Filetyp         :byte;
var KnobImg,CalcImg                             :Image;
var GImg                                        :array[1..6] of Image;
var ButtonImg                                   :array[1..6] of Image;
var KnobMem,CalcMem                             :long;
var GMem                                        :array[1..6] of long;
var ButtonMem                                   :array[1..6] of long;
var IDt                                         :^Plane;
var ButtonIDt                                   :^ButtonPlane;
var CalcIDt                                     :^CalcPlane;
var KnobIDt                                     :^KnobPlane;
var Notes                                       :BlueNote;

var GUI                                         :boolean;
var FRTit,PathFR,FRShow,DirFR,FileFR            :string[200];
var i                                           :integer;
var s,CTDFPath                                  :string;
var ObjMemA,ObjMemL,ObjMemPos,ActFramePos,l     :long;
var SyncMemA,SyncMemL,ObjHeaderSize             :long;
var CineMemL,TimeMemL,TextMemA,TextMemL         :long;
var FHandle,FHandle2                            :BPTR;

var ChunkCNHD                                   :r_CineDataFileHeader;



procedure ERRORMSG(Tx1,Tx2 :str);

var f   :Text;

begin
   DisplayBeep(NIL);
   reset(f,'CON:0/20/640/100/CineTracer');
   if IOResult<>0 then exit;
   writeln(f,Tx1);
   writeln(f,Tx2);
   delay(300);
   close(f);
end;



function INITIMG:boolean;

begin;
   INITIMG:=false;
   for i:=1 to 6 do begin
      GMem[i]:=AllocVec(sizeof(Plane),MEMF_CHIP+MEMF_CLEAR);
      if GMem[i]=0 then exit;
   end;

   IDt:=ptr(GMem[1]);
   IDt^:=Plane(%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %01111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,

               %11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %10000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[1]:=Image(0,0,128,16,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[2]);
   IDt^:=Plane(%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000011111111111110011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000001100000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000110000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000011000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000001100000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000110000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000010000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000011111111111100011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000010000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %01111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,

               %11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000001100000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000110000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000001100000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000001000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000010000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000001111111111110000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %10000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[2]:=Image(0,0,128,16,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[3]);
   IDt^:=Plane2(%00000000000000000000000000000000,%00000000000000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000011111111111111111111111111,%11100000011000000000000000000000,
                %00000011111111111111111111111111,%11110000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011110000000000000000000000,%01111000011000000000000000000000,
                %00000011110000000000000111100000,%01111000011000000000000000000000,
                %00000011110000000000011000011000,%01111000011000000000000000000000,
                %00000011110000111111100000011000,%01111000011000000000000000000000,
                %00000011110000111000011111111000,%01111000011000000000000000000000,
                %00000011110000111000000000011000,%01111000011000000000000000000000,
                %00000011110000111111111111111000,%01111000011000000000000000000000,
                %00000011110000000000000000000000,%01111000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %01111111111111111111111111111111,%11111111111000000000000000000000,

                %11111111111111111111111111111111,%11111111111000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000011111111000000000000000001,%11100000000000000000000000000000,
                %11000011111111000000000001111001,%11110000000000000000000000000000,
                %11000011111111000000000001111001,%11111000000000000000000000000000,
                %11000011111111000000000001111001,%11111000000000000000000000000000,
                %11000011111111000000000001111001,%11111000000000000000000000000000,
                %11000011111111000000000000000001,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111000011111,%11111000000000000000000000000000,
                %11000011111111111111100111100111,%11111000000000000000000000000000,
                %11000011111111000000011111100111,%11111000000000000000000000000000,
                %11000011111111000111100000000111,%11111000000000000000000000000000,
                %11000010011111000111111111100111,%11001000000000000000000000000000,
                %11000010011111000000000000000111,%11001000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %10000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[3]:=Image(0,0,64,21,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[4]);
   IDt^:=Plane2(%11111111111111111111111111111111,%11111111111000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000011111111111111111111111111,%11100000000000000000000000000000,
                %11000011111111111111111111111111,%11110000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011110000000000000000000000,%01111000000000000000000000000000,
                %11000011110000000000000111100000,%01111000000000000000000000000000,
                %11000011110000000000011000011000,%01111000000000000000000000000000,
                %11000011110000111111100000011000,%01111000000000000000000000000000,
                %11000011110000111000011111111000,%01111000000000000000000000000000,
                %11000011110000111000000000011000,%01111000000000000000000000000000,
                %11000011110000111111111111111000,%01111000000000000000000000000000,
                %11000011110000000000000000000000,%01111000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %10000000000000000000000000000000,%00000000000000000000000000000000,

                %00000000000000000000000000000000,%00000000000000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000011110000000000000000011111,%11100000011000000000000000000000,
                %00000011110000000000011110011111,%11110000011000000000000000000000,
                %00000011110000000000011110011111,%11111000011000000000000000000000,
                %00000011110000000000011110011111,%11111000011000000000000000000000,
                %00000011110000000000011110011111,%11111000011000000000000000000000,
                %00000011110000000000000000011111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111000011111,%11111000011000000000000000000000,
                %00000011111111111111100111100111,%11111000011000000000000000000000,
                %00000011111111000000011111100111,%11111000011000000000000000000000,
                %00000011111111000111100000000111,%11111000011000000000000000000000,
                %00000010011111000111111111100111,%11001000011000000000000000000000,
                %00000010011111000000000000000111,%11001000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %01111111111111111111111111111111,%11111111111000000000000000000000);
   GImg[4]:=Image(0,0,64,21,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[5]);
   IDt^:=Plane(%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000001100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011111111111110000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000110000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000001100000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000110000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000001100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %01111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,

               %11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000001000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000111111111111000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %10000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[5]:=Image(0,0,128,16,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[6]);
   IDt^:=Plane2(%00000000000000000000000000000000,%00000000000000000000000000000000,
                %00110000000000000000000000000000,%00000000000000000000000000000000,
                %00110000000001010100000000000000,%00000000000000000000000000000000,
                %00110000000101010101000000000000,%00000000000000000000000000000000,
                %00110000010101010101010000000000,%00000000000000000000000000000000,
                %00110000010101010101010000000000,%00000000000000000000000000000000,
                %00110001010101010101010100000000,%00000000000000000101010000000000,
                %00110001010101010101010100000000,%00000000000000010101010100000000,
                %00110101010101010101010101000000,%00000000000000010101010100000000,
                %00110101010101010101010101000000,%00000000000001010101010101000000,
                %00111111111111111111111111111111,%11111111111111111111111111111111,
                %00110000000000000000000000010101,%01010101010100000000000000000000,
                %00110000000000000000000000010101,%01010101010100000000000000000000,
                %00110000000000000000000000010101,%01010101010100000000000000000000,
                %00110000000000000000000000000101,%01010101010000000000000000000000,
                %00110000000000000000000000000101,%01010101010000000000000000000000,
                %00110000000000000000000000000001,%01010101000000000000000000000000,
                %00110000000000000000000000000000,%01010100000000000000000000000000,
                %00110000000000000000000000000000,%00000000000000000000000000000000,
                %00110000000000000000000000000000,%00000000000000000000000000000000,
                %11110000000000000000000000000000,%00000000000000000000000000000000,

                %11110000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000001010100000000000000,%00000000000000000000000000000000,
                %11000000000101010101000000000000,%00000000000000000000000000000000,
                %11000000010101010101010000000000,%00000000000000000000000000000000,
                %11000000010101010101010000000000,%00000000000000000000000000000000,
                %11000001010101010101010100000000,%00000000000000000101010000000000,
                %11000001010101010101010100000000,%00000000000000010101010100000000,
                %11000101010101010101010101000000,%00000000000000010101010100000000,
                %11000101010101010101010101000000,%00000000000001010101010101000000,
                %11000101010101010101010101000000,%00000000000001010101010101000000,
                %11001111111111111111111111111111,%11111111111111111111111111111111,
                %11000000000000000000000000010101,%01010101010100000000000000000000,
                %11000000000000000000000000010101,%01010101010100000000000000000000,
                %11000000000000000000000000000101,%01010101010000000000000000000000,
                %11000000000000000000000000000101,%01010101010000000000000000000000,
                %11000000000000000000000000000001,%01010101000000000000000000000000,
                %11000000000000000000000000000000,%01010100000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[6]:=Image(0,0,64,21,2,IDt,3,1,NIL);
   for i:=1 to 6 do begin
      ButtonMem[i]:=AllocVec(sizeof(ButtonPlane),MEMF_CHIP+MEMF_CLEAR);
      if ButtonMem[i]=0 then exit;
   end;
   ButtonIDt:=ptr(ButtonMem[1]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[1]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[2]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000010001100000000000,
                           %00000000000000100001100000000000,
                           %00000000000001000001100000000000,
                           %00000001000010000001100000000000,
                           %00000000100100000001100000000000,
                           %00000000001000000001100000000000,
                           %00000000010000000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000110000000000000000,
                           %11000000000001100000000000000000,
                           %11000000000011000000000000000000,
                           %11000000000110000000000000000000,
                           %11001100001100000000000000000000,
                           %11000110011000000000000000000000,
                           %11000011110000000000000000000000,
                           %11000001100000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[2]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[3]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000100000001100000000000,
                           %00000000000111000001100000000000,
                           %00000000000110110001100000000000,
                           %00000000000110011001100000000000,
                           %00000000000110001101100000000000,
                           %00000011111110001101100000000000,
                           %00000111111110000001100000000000,
                           %00000011111100000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11011000000001100000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[3]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[4]);
   ButtonIDt^:=ButtonPlane(%11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000001111111000000000000000000,
                           %11000111111111000000000000000000,
                           %11001111111111110000000000000000,
                           %11001111111111110000000000000000,
                           %11001111111111110000000000000000,
                           %11001111111111110000000000000000,
                           %11000111111111000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000,

                           %00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000001111111110001100000000000,
                           %00000011111111111001100000000000,
                           %00000011111111111001100000000000,
                           %00000011111111111001100000000000,
                           %00000011111111111001100000000000,
                           %00000001111111110001100000000000,
                           %00000001111111000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000);
   ButtonImg[4]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[5]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000001000000001100000000000,
                           %00000000011100000001100000000000,
                           %00000000111110000001100000000000,
                           %00000001110111000001100000000000,
                           %00000011100011100001100000000000,
                           %00000111000001110001100000000000,
                           %00001110000000111001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[5]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[6]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00001110000000111001100000000000,
                           %00000111000001110001100000000000,
                           %00000011100011100001100000000000,
                           %00000001110111000001100000000000,
                           %00000000111110000001100000000000,
                           %00000000011100000001100000000000,
                           %00000000001000000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[6]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);

   KnobMem:=AllocVec(sizeof(KnobPlane),MEMF_CHIP+MEMF_CLEAR);
   if KnobMem=0 then exit;
   KnobIDt:=ptr(KnobMem);
   KnobIDt^:=KnobPlane(%00000000000000000000000000000001,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %01111111111111111111111111111111,

                       %11111111111111111111111111111111,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11000000000000010000000000000000);
   KnobImg:=Image(0,0,32,11,2,KnobIDt,3,0,NIL);
   CalcMem:=AllocVec(sizeof(CalcPlane),MEMF_CHIP+MEMF_CLEAR);
   if CalcMem=0 then exit;
   CalcIDt:=ptr(CalcMem);
   CalcIDt^:=CalcPlane(%00000000000000000000000000000000,
                       %00000000000000000000000000000011,
                       %00000000001110001000000001110011,
                       %00000000000001001000000000001011,
                       %00000100000001001010001000001011,
                       %00000000000001001001010000001011,
                       %00011111001110001000100001110011,
                       %00000000010000001001010010000011,
                       %00000100010000001010001010000011,
                       %00000000010000001000000010000011,
                       %00000000001110001000000001110011,
                       %00000000000000000000000000000011,
                       %01111111111111111111111111111111,

                       %11111111111111111111111111111111,
                       %11000000000000000000000000000000,
                       %11000000001110010000000001110000,
                       %11000000000001010000000000001000,
                       %11000100000001010010001000001000,
                       %11000000000001010001010000001000,
                       %11011111001110010000100001110000,
                       %11000000010000010001010010000000,
                       %11000100010000010010001010000000,
                       %11000000010000010000000010000000,
                       %11000000001110010000000001110000,
                       %11000000000000000000000000000000,
                       %10000000000000000000000000000000);
   CalcImg:=Image(0,0,32,13,2,CalcIDt,3,0,NIL);
   INITIMG:=true;
end;



procedure WRITE(LEdge,TEdge :word; StPen :byte; DMode :word; Wind :Window; tx :str);

var IT1,IT2     :IntuiText;
var txt         :string[200];
var w           :word;

begin
   txt:=tx;
   IT1:=IntuiText(StPen  ,0,0,LEdge  ,TEdge  ,^CustomTA,txt,NIL);
   if DMode>5 then begin
      while IntuiTextLength(^IT1)>DMode do txt:=copy(txt,2,length(txt)-1);
      DMode:=3;
   end;
   if DMode in [2,3] then begin
      IT1.LeftEdge:=LEdge-IntuiTextLength(^IT1) div 2;
   end else if DMode=4 then begin
      IT1.LeftEdge:=LEdge-IntuiTextLength(^IT1);
   end;
   if DMode=2 then begin
      IT2:=IntuiText(1,0,0,IT1.LeftEdge+1,IT1.TopEdge+1,^CustomTA,txt,NIL);
      exchange(IT1,IT2);
      IT1.NextText:=^IT2;
      w:=IntuiTextLength(^IT1) div 2;
      SetAPen(Wind.RPort,15); RectFill(Wind.RPort,LEdge-w,TEdge+7,LEdge+w,TEdge+8);
   end;
   if DMode=5 then IT1.DrawMode:=1;
   PrintIText(Wind.RPort,^IT1,0,0);
end;



procedure MAKEBORDER(Wind :Window; LEdge,TEdge,REdge,BEdge :word; Color :byte);

begin
   if Color=OPENBORDER then begin
      SetAPen(Wind.RPort,0);            RectFill(Wind.RPort,LEdge,TEdge,REdge,BEdge);
      SetAPen(Wind.RPort,1);            Move(Wind.RPort,LEdge+1,TEdge+1);
      Draw(Wind.RPort,REdge+1,TEdge+1); Draw(Wind.RPort,REdge+1,BEdge+1);
      Draw(Wind.RPort,LEdge+1,BEdge+1); Draw(Wind.RPort,LEdge+1,TEdge+1);
      SetAPen(Wind.RPort,2);            Move(Wind.RPort,LEdge,TEdge);
      Draw(Wind.RPort,REdge,TEdge);     Draw(Wind.RPort,REdge,BEdge);
      Draw(Wind.RPort,LEdge,BEdge);     Draw(Wind.RPort,LEdge,TEdge);
   end else begin
      SetAPen(Wind.RPort,abs(Color-2));
      Move(Wind.RPort,REdge,TEdge);     Draw(Wind.RPort,LEdge,TEdge);
      Draw(Wind.RPort,LEdge,BEdge);     Draw(Wind.RPort,LEdge+1,BEdge);
      Draw(Wind.RPort,LEdge+1,TEdge+1); Draw(Wind.RPort,REdge,TEdge+1);
      SetAPen(Wind.RPort,abs(Color-1));
      Move(Wind.RPort,LEdge+1,BEdge);   Draw(Wind.RPort,REdge,BEdge);
      Draw(Wind.RPort,REdge,TEdge);     Draw(Wind.RPort,REdge-1,TEdge+1);
      Draw(Wind.RPort,REdge-1,BEdge-1); Draw(Wind.RPort,LEdge+2,BEdge-1);
   end;
end;



function TASKREQUEST(Text1,Text2 :str; Gad1,Gad2,Gad3 :str):byte;

{var TRWindow                    :^Window;
var GadCode,RawCode,i           :byte;
var TRKnopf                     :array[1..3] of Gadget;
var TRKnopfTx                   :array[1..3] of IntuiText;
var Gad                         :array[1..3] of str;
var TEdge                       :integer;
var l                           :long;}

type TagArr=array [1..4] of long;

var ReqText                     :string[300];
var GadText                     :string[100];
var ReqTags                     :TagArr;

begin
   TASKREQUEST:=3;
   ReqText:=Text1+chr(10)+Text2;
   GadText:=Gad1;
   if (GadText<>'') and (Gad2<>'') then GadText:=GadText+'|'+Gad2;
   if GadText='' then GadText:=Gad2;
   if (GadText<>'') and (Gad3<>'') then GadText:=GadText+'|'+Gad3;
   if GadText='' then GadText:=Gad3;
   ReqTags:=TagArr(RTEZ_Flags,EZREQF_LAMIGAQUAL+EZREQF_CENTERTEXT,
                   0,0);
   l:=rtEZRequestA(ReqText,GadText,NIL,NIL,^ReqTags);
   if (Gad1='') and (Gad2='') then TASKREQUEST:=2
   else if l=0 then TASKREQUEST:=3 else TASKREQUEST:=l;

{   TEdge:=MyScreen^.MouseY-80;
   if TEdge+100>MyScreen^.Height then TEdge:=MyScreen^.Height-100;
   if TEdge<20 then TEdge:=20;
   NeuWindow:=NewWindow(100,TEdge,440,87,1,0,RAWKEY or GADGETUP,ACTIVATE or WINDOWDRAG
                        or WINDOWDEPTH or SIMPLE_REFRESH,NIL,NIL,CTVersion,MyScreen,Nil,440,87,
                        440,87,CUSTOMSCREEN);
   TRWindow:=OpenWindow(^Neuwindow);
   If TRWindow=Nil Then begin
      DisplayBeep(NIL);
      exit;
   end;
   SetAPen(TRWindow^.RPort,3);
   RectFill(TRWindow^.RPort,10,20,430,60);
   MAKEBORDER(TRWindow^,10,20,430,60,POSITIVE);
   WRITE(220,26,1,415,TRWindow^,Text1);
   WRITE(220,43,1,3,TRWindow^,Text2);
   Gad[1]:=Gad1; Gad[2]:=Gad2; Gad[3]:=Gad3;
   for i:=1 to 3 do begin
      TRKnopf[i]:=Gadget(NIL,i*145-134,65,128,17,GADGHCOMP+GADGIMAGE,
                         $1,BOOLGADGET,^GImg[1],NIL,^TRKnopfTx[i],0,Nil,i,0);
      TRKnopfTx[i]:=IntuiText(3,0,0,2,2,^CustomTA,Gad[i],NIL);
      l:=64-(IntuiTextLength(^TRKnopfTx[i]) div 2);
      TRKnopfTX[i].LeftEdge:=l;
      if Gad[i]<>'' then AddGadget(TRWindow,^TRKnopf[i],NIL);
   end;
   RefreshGadgets(TRWindow^.FirstGadget,TRWindow,NIL);
   RefreshWindowFrame(TRWindow);
   ScreenToFront(MyScreen);
   repeat
      GadCode:=0; RawCode:=0;
      IMsg:=Wait_Port(TRWindow^.UserPort);
      If IMsg<>Nil Then begin
         IMsg:=Get_Msg(TRWindow^.UserPort);
         if IMsg^.class=GADGETUP then begin
            XGadget:=IMsg^.IAddress;
            GadCode:=XGadget^.GadgetID;
         end;
         if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
         Reply_Msg(IMsg)
      End;

      case RawCode of
         69: if Gad[1]='' then RawCode:=0;
         64: if Gad[2]='' then RawCode:=0;
         68: if Gad[3]='' then RawCode:=0;
         otherwise RawCode:=0;
      end;

   until (GadCode in [1..3]) or (RawCode>0);
   if RawCode>0 then begin
      case RawCode of
         69: begin
                TRKnopf[1].Flags:=TRKnopf[1].Flags+SELECTED;
                TASKREQUEST:=1;
             end;
         64: begin
                TRKnopf[2].Flags:=TRKnopf[2].Flags+SELECTED;
                TASKREQUEST:=2;
             end;
         68: TRKnopf[3].Flags:=TRKnopf[3].Flags+SELECTED;
      end;
      RefreshGadgets(TRWindow^.FirstGadget,TRWindow,NIL);
      delay(5);
   end else TASKREQUEST:=GadCode;
   CloseWindow(TRWindow);}
   GadCode:=0;
end;



function FILEREQ:boolean;

var l   :long;
var i   :byte;

begin
   if FRShow='' then FRShow:='~(#?.p|#?.backup|#?.data|#?.s|#?.o)';
   if PathFR<>'' then begin
      DirFR:=PathFR; FileFR:='';
      for i:=1 to length(PathFR) do if PathFR[i] in ['/',':'] then begin
         FileFR:=copy(PathFR,succ(i),length(PathFR)-i);
         DirFR:=copy(PathFR,1,i);
      end;
   end;
   FTags:=FTagArr(RTFI_MatchPat,addr(FRShow),
                  RTFI_Dir,addr(DirFR),
                  0,0);
   l:=rtChangeReqAttrA(MyFReq,^FTags);
   l:=rtFileRequestA(MyFReq,FileFR,FRTit,^FTags);
   if l=1 then FILEREQ:=true else begin
      FILEREQ:=false;
      PathFR:='';
      exit;
   end;
   DirFR:=MyFReq^.Dir;
   if length(DirFR)>0 then begin
      if not (DirFR[length(DirFR)] in ['/',':']) then PathFR:=DirFR+'/'+FileFR else PathFR:=DirFR+FileFR;
   end else PathFR:=FileFR;
end;



function INITLANG:boolean;

var WordSet     :boolean;
var c           :^char;
var Addr1       :long;

begin
   INITLANG:=false;
   s:='CTLocale/'+Prefs.LocaleString;
   FHandle:=DosOpen(s,MODE_OLDFILE);
   if FHandle=0 then begin
      FHandle:=DosOpen('CTLocale/deutsch',MODE_OLDFILE);
      if FHandle=0 then begin
         ERRORMSG('Kann WTLocale-Dateien nicht finden!','Can`t find WTLocale-Files!');
         exit;
      end;
   end;
   TextMemL:=DosSeek(FHandle,0,OFFSET_END);
   TextMemL:=DosSeek(FHandle,0,OFFSET_BEGINNING);
   TextMemA:=AllocVec(TextMemL,MEMF_CLEAR);
   if TextMemA=0 then begin
      ERRORMSG('Nicht genug Speicher vorhanden!','Not enough Memory!');
      DosClose(FHandle);
      exit;
   end;
   l:=DosRead(FHandle,ptr(TextMemA),TextMemL);
   DosClose(FHandle);
   Addr1:=TextMemA; i:=1; WordSet:=false;
   repeat
      c:=ptr(Addr1); Addr1:=Addr1+1;
      if (ord(c^) in [33..58,60..255]) and not WordSet then begin
         PText[i]:=ptr(Addr1-1);
         i:=i+1;
         WordSet:=true;
      end else if ord(c^)=59 then WordSet:=true
      else if (ord(c^)=10) and WordSet then begin
         c^:=chr(0);
         WordSet:=false;
      end;
   until (Addr1>=TextMemA+TextMemL) or (i>TEXTS);
   OKKnopfTx:=IntuiText(3,0,0,8,2,^CustomTA,PText[1],NIL);
   CKnopfTx:= IntuiText(3,0,0,8,2,^CustomTA,PText[2],NIL);
   OKKnopfTx.LeftEdge:=56-IntuiTextLength(^OKKnopfTx) div 2;
   CKnopfTx.LeftEdge:= 56-IntuiTextLength(^CKnopfTx)  div 2;
   INITLANG:=true;
end;



function OPENDWIN(Height,TopEdge :integer; var DWindow :p_Window; WTitle :str; WinMode,ChGadOffset :byte):boolean;

var i   :byte;

begin
   if TopEdge=0 then TopEdge:=MyScreen^.Height-Height;
   NeuWindow:=NewWindow(MyScreen^.Width div 2-320,TopEdge,640,Height,3,1,RAWKEY or GADGETDOWN or GADGETUP
                        or MOUSEMOVE or MOUSEBUTTONS,SMART_REFRESH or ACTIVATE or WINDOWDRAG
                        or _REPORTMOUSE or WINDOWDEPTH,
                        Nil,NIL,CTVersion,MyScreen,Nil,640,Height,640,Height,CUSTOMSCREEN);
   DWindow:=OpenWindow(^NeuWindow);
   If DWindow=Nil Then begin
      OPENDWIN:=false;
      DisplayBeep(NIL);
      exit;
   end else OPENDWIN:=true;
   WRITE(320,19,2,3,DWindow^,WTitle);
   RefreshWindowFrame(DWindow);
end;



function DOSELECTLIST(MySList :r_SelectListGad):byte;

var i,Gads,TEdge,LEdge  :integer;
var CWindow             :^Window;
var CKnopf              :array [1..15] of Gadget;

begin
   with MySList^ do begin
      Gads:=0; i:=0;
      repeat
         Gads:=Gads+1; i:=i+1;
      until ITextTag[i]=NIL;
      Gads:=Gads-1;
      DOSELECTLIST:=SelectedGad;

      TEdge:=GadWindow^.TopEdge+SGad^.TopEdge;
      LEdge:=GadWindow^.LeftEdge+SGad^.LeftEdge+SGad^.Width;
      if TEdge+(SGad^.Height*Gads)>MyScreen^.Height then TEdge:=MyScreen^.Height-(SGad^.Height*Gads)-1;
      if LEdge+SGad^.Width>MyScreen^.Width then LEdge:=MyScreen^.Width-SGad^.Width-1;
      NeuWindow:=NewWindow(LEdge,TEdge,SGad^.Width,SGad^.Height*Gads,3,1,GADGETDOWN or GADGETUP,
                           SMART_REFRESH or ACTIVATE or BORDERLESS,Nil,Nil,'',MyScreen,Nil,
                           SGad^.Width,SGad^.Height*Gads,SGad^.Width,SGad^.Height*Gads,CUSTOMSCREEN);
      CWindow:=OpenWindow(^Neuwindow);
      If CWindow=Nil Then begin
         DisplayBeep(NIL);
         exit;
      end;
      for i:=1 to Gads do begin
         if i<>SelectedGad then ITextTag[i]^.FrontPen:=2 else ITextTag[i]^.FrontPen:=3;
         CKnopf[i]:=Gadget(NIL,0,pred(i)*16,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,
                           ^GImg[1],NIL,ITextTag[i],0,Nil,i,0);
         AddGadget(CWindow,^CKnopf[i],NIL);
      end;
      RefreshGadgets(CWindow^.FirstGadget,CWindow,NIL);
      IMsg:=Wait_Port(CWindow^.UserPort);
      If IMsg<>Nil Then begin
         IMsg:=Get_Msg(CWindow^.UserPort);
         if IMsg^.class=GADGETUP then begin
            XGadget:=IMsg^.IAddress;
            DOSELECTLIST:=XGadget^.GadgetID;
            SelectedGad:=XGadget^.GadgetID;
            ITextTag[XGadget^.GadgetID]^.FrontPen:=2;
            SGad^.GadgetText:=ITextTag[XGadget^.GadgetID];
            RefreshGadgets(GadWindow^.FirstGadget,GadWindow,NIL);
         end;
         Reply_Msg(IMsg)
      End;
      CloseWindow(CWindow);
   end;
end;



procedure DRAWFIELD;

begin
   SetAPen(MyWindow^.RPort,0);
   RectFill(MyWindow^.RPort,6,22,351,367); {*** TOP ***}
   RectFill(MyWindow^.RPort,6,378,131,503);   {*** FRONT ***}
   RectFill(MyWindow^.RPort,142,378,267,503); {*** REAR ***}
   if CameraYOffset in [-161..-1,1..165] then begin
      SetAPen(MyWindow^.RPort,1);
      DrawEllipse(MyWindow^.RPort,179,195+CameraYOffset,7,7);
      Move(MyWindow^.RPort,172,195+CameraYOffset); Draw(MyWindow^.RPort,186,195+CameraYOffset);
      Move(MyWindow^.RPort,179,195+CameraYOffset); Draw(MyWindow^.RPort,179,183+CameraYOffset);
   end;
   SetAPen(MyWindow^.RPort,2);    Move(MyWindow^.RPort,121,137);
   Draw(MyWindow^.RPort,236,137); Draw(MyWindow^.RPort,236,252);
   Draw(MyWindow^.RPort,121,252); Draw(MyWindow^.RPort,121,137);
   DrawEllipse(MyWindow^.RPort,179,195,7,7);
   DrawEllipse(MyWindow^.RPort,68,440,4,4);
   DrawEllipse(MyWindow^.RPort,204,440,4,4);
   Move(MyWindow^.RPort,172,195); Draw(MyWindow^.RPort,186,195);
   Move(MyWindow^.RPort,179,195); Draw(MyWindow^.RPort,179,183);
end;



procedure WRITEOBJNAME;

begin
   SetAPen(Mywindow^.RPort,0); RectFill(Mywindow^.RPort,419,266,628,278);
   if ObjMemA<>0 then begin
      ActObjectHeader:=ptr(ObjMemA+(pred(ObjMemPos)*ObjHeaderSize));
      WRITE(523,267,2,3,MyWindow^,ActObjectHeader^.Name);
      SBuffer:=ActObjectHeader^.Sample;
      Buffer[5]:=intstr(ActObjectHeader^.ObjectVolume);
      Buffer[8]:=intstr(ActObjectHeader^.EchoVolume);
      Buffer[7]:=intstr(ChunkCNHD.FPS);
   end;
end;



procedure CREATEGUI;

begin
   MAKEBORDER(MyWindow^,365,194,634,243,OPENBORDER);
   WRITE(500,187,3,2,MyWindow^,PText[43]);
   for i:=1 to 3 do begin
      TextGad[i]:=Gadget(NIL,333+i*45,204,40,13,GADGHCOMP,_LONGINT+STRINGCENTER+$1,
                         STRGADGET,NIL,Nil,Nil,0,^TextInfo[i],i+10,0);
      TextInfo[i]:=StringInfo(^Buffer[i],^UndoBuffer[i],0,7,0,0,7,0,0,0,Nil,0,Nil);
      UndoBuffer[i]:='';
      MAKEBORDER(MyWindow^,332+i*45,203,373+i*45,217,NEGATIVE);
   end;
   TextGad[4]:=Gadget(NIL,378,224,40,15,GADGHCOMP,_LONGINT+STRINGCENTER+$1,
                      STRGADGET,NIL,Nil,Nil,0,^TextInfo[4],14,0);
   TextInfo[4]:=StringInfo(^Buffer[4],^UndoBuffer[4],0,7,0,0,7,0,0,0,Nil,0,Nil);
   UndoBuffer[4]:='';
   MAKEBORDER(MyWindow^,377,223,418,237,NEGATIVE);
   WRITE(514,205,2,0,MyWindow^,PText[44]);
   WRITE(424,225,2,0,MyWindow^,PText[45]);

   MAKEBORDER(Mywindow^,365,256,634,408,OPENBORDER);
   WRITE(500,249,3,2,MyWindow^,PText[51]);
   Knopf[1]:=Gadget(NIL,372,266,21,12,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,^ButtonImg[5],
                    NIL,NIL,0,NIL,21,0);
   Knopf[2]:=Gadget(NIL,395,266,21,12,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,^ButtonImg[6],
                    NIL,NIL,0,NIL,22,0);
   MAKEBORDER(Mywindow^,418,265,629,279,POSITIVE);
   WRITEOBJNAME;
   Knopf[3]:=Gadget(NIL,372,283,21,12,GADGHIMAGE+GADGIMAGE,$1+TOGGLESELECT,BOOLGADGET,
                    ^ButtonImg[1],^ButtonImg[2],NIL,0,NIL,23,0);
   WRITE(398,284,2,0,Mywindow^,PText[52]);
   Knopf[4]:=Gadget(NIL,372,300,21,12,GADGHIMAGE+GADGIMAGE,$1+TOGGLESELECT,BOOLGADGET,
                    ^ButtonImg[1],^ButtonImg[2],NIL,0,NIL,24,0);
   WRITE(398,301,2,0,Mywindow^,PText[53]);

   TextGad[5]:=Gadget(NIL,373,318,255,13,GADGHCOMP,STRINGCENTER+$1,STRGADGET,
                    NIL,Nil,Nil,0,^TextInfo[5],15,0);
   TextInfo[5]:=StringInfo(^SBuffer,^SUndoBuffer,0,200,0,0,200,0,0,0,Nil,0,Nil);
   SUndoBuffer:='';
   MAKEBORDER(MyWindow^,372,317,628,331,NEGATIVE);
   Knopf[5]:=Gadget(NIL,372,337,43,21,GADGHIMAGE+GADGIMAGE+GADGDISABLED,$1,BOOLGADGET,
                    ^GImg[3],^GImg[4],^KnopfTx[1],0,NIL,25,0);
   KnopfTx[1]:=IntuiText(2,0,0,48,5,^CustomTA,PText[54],NIL);

   SetAPen(MyWindow^.RPort,2);
   Move(MyWindow^.RPort,372,363); Draw(MyWindow^.RPort,628,363);
   SetAPen(MyWindow^.RPort,1);
   Move(MyWindow^.RPort,373,364); Draw(MyWindow^.RPort,629,364);
   STextGad[1]:=Gadget(NIL,373,369,40,13,GADGHCOMP or GADGDISABLED,_LONGINT or STRINGCENTER or $1,
                   STRGADGET,NIL,NIL,NIL,0,^STextInfo[1],26,0);
   STextInfo[1]:=StringInfo(^Buffer[5],^UndoBuffer[5],0,9,0,0,0,0,0,0,NIL,0,NIL);
 UndoBuffer[5]:=Buffer[5];
   MAKEBORDER(MyWindow^,372,368,413,382,NEGATIVE);
   WRITE(417,369,2,0,Mywindow^,PText[55]);

   STextGad[2]:=Gadget(NIL,501,369,40,13,GADGHCOMP or GADGDISABLED,_LONGINT or STRINGCENTER or $1,
                   STRGADGET,NIL,NIL,NIL,0,^STextInfo[2],27,0);
   STextInfo[2]:=StringInfo(^Buffer[8],^UndoBuffer[8],0,9,0,0,0,0,0,0,NIL,0,NIL);
   UndoBuffer[8]:=Buffer[8];
   MAKEBORDER(MyWindow^,500,368,541,382,NEGATIVE);
   WRITE(544,369,2,0,Mywindow^,PText[56]);


   Knopf[8]:=Gadget(NIL,372,389,21,12,GADGHIMAGE or GADGIMAGE or GADGDISABLED,
                    $1+TOGGLESELECT,BOOLGADGET,^ButtonImg[1],^ButtonImg[2],NIL,
                    0,NIL,28,0);
   WRITE(398,389,2,0,Mywindow^,PText[57]);

   MAKEBORDER(Mywindow^,365,422,634,482,OPENBORDER);
   WRITE(500,415,3,2,MyWindow^,PText[63]);
   for i:=1 to 6 do Knopf[8+i]:=Gadget(NIL,372+pred(i)*27,432,21,12,GADGHCOMP or GADGIMAGE,
                                       $1,BOOLGADGET,^ButtonImg[1],NIL,^DKnopfTx[i+8],
                                       0,NIL,40+pred(i),0);
   DKnopfTx[9]:=IntuiText(3,0,0,5,0,^CustomTA,'I<',NIL);
   DKnopfTx[10]:=IntuiText(3,0,0,3,0,^CustomTA,'<<',NIL);
   DKnopfTx[11]:=IntuiText(3,0,0,6,0,^CustomTA,'<',NIL);
   DKnopfTx[12]:=IntuiText(3,0,0,6,0,^CustomTA,'>',NIL);
   DKnopfTx[13]:=IntuiText(3,0,0,3,0,^CustomTA,'>>',NIL);
   DKnopfTx[14]:=IntuiText(3,0,0,5,0,^CustomTA,'>I',NIL);

   FTextGad:=Gadget(NIL,535,431,40,13,GADGHCOMP,_LONGINT or STRINGCENTER or $1,
                   STRGADGET,NIL,NIL,NIL,0,^FTextInfo,46,0);
   FTextInfo:=StringInfo(^Buffer[6],^UndoBuffer[6],0,9,0,0,0,0,0,0,NIL,0,NIL);
   Buffer[6]:=intstr(ActFramePos); UndoBuffer[6]:=Buffer[6];
   MAKEBORDER(MyWindow^,534,430,575,444,NEGATIVE);
   WRITE(582,432,2,0,Mywindow^,PText[64]);
   SetAPen(MyWindow^.RPort,2);
   Move(MyWindow^.RPort,372,449); Draw(MyWindow^.RPort,628,449);
   SetAPen(MyWindow^.RPort,1);
   Move(MyWindow^.RPort,373,450); Draw(MyWindow^.RPort,629,450);
   FPSTextGad:=Gadget(NIL,373,457,40,13,GADGHCOMP,_LONGINT or STRINGCENTER or $1,
                   STRGADGET,NIL,NIL,NIL,0,^FPSTextInfo,47,0);
   FPSTextInfo:=StringInfo(^Buffer[7],^UndoBuffer[7],0,9,0,0,0,0,0,0,NIL,0,NIL);
   Buffer[7]:=intstr(ChunkCNHD.FPS); UndoBuffer[7]:=Buffer[7];
   MAKEBORDER(MyWindow^,372,456,413,470,NEGATIVE);
   WRITE(418,458,2,0,Mywindow^,PText[65]);

   Knopf[6]:=Gadget(NIL,365,492,128,16,GADGHCOMP+GADGIMAGE,$1+TOGGLESELECT,BOOLGADGET,^GImg[5],
                    NIL,^KnopfTx[2],0,Nil,36,0);
   KnopfTx[2]:=IntuiText(2,0,0,5,2,^CustomTA,PText[71],NIL);
   Knopf[7]:=Gadget(NIL,507,492,128,16,GADGHCOMP+GADGIMAGE+GADGDISABLED,$1,BOOLGADGET,^GImg[5],
                    NIL,^KnopfTx[3],0,Nil,37,0);
   KnopfTx[3]:=IntuiText(3,0,0,5,2,^CustomTA,PText[72],NIL);

   for i:=1 to 5 do AddGadget(MyWindow,^TextGad[i],NIL);
   for i:=1 to 14 do AddGadget(MyWindow,^Knopf[i],NIL);
   for I:=1 to 2 do AddGadget(MyWindow,^STextGad[i],NIL);
   AddGadget(MyWindow,^FTextGad,NIL);
   AddGadget(MyWindow,^FPSTextGad,NIL);
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
   GUI:=true;
end;



function OPENCTSCREEN:boolean;

type ColArr=array [1..48] of byte;

var inf         :p_FileInfoBlock;
var MyLock      :BPTR;
var Color       :ColArr;
var l           :long;
var i           :integer;

begin
   OPENCTSCREEN:=false;
   NeuScreen:=NewScreen(0,0,Prefs.ScrWidth,Prefs.ScrHeight,4,1,2,HIRES+GENLOCK_VIDEO,CUSTOMSCREEN,
                        ^CustomTA,CTVersion,NIL,NIL);
   Pens:=PenArr(0,0,2,
                2,1,      {Window Light,Shadow}
                3,1,      {Active, WindowColor and -Text}
                0,        {Inactive, Windocolor}
                3,
                1,2,1,    {Screen Text, Block, Shadow}
                0);
   i:=0;
   repeat
      i:=i+1;
      Tags:=TagArr(SA_DisplayID,   Prefs.ScrID,
                   SA_Interleaved, _TRUE,
                   SA_Draggable,   _TRUE,
                   SA_AutoScroll,  _TRUE,
                   SA_PENS,        addr(Pens),
                   TAG_DONE,       0);
      MyScreen:=OpenScreenTagList(^NeuScreen,^Tags);
      if (i=1) and (MyScreen=NIL) then Prefs.ScrID:=$A9004; { DblPAL }
      if (i=2) and (MyScreen=NIL) then Prefs.ScrID:=$29004; { PAL }
   until (MyScreen<>NIL) or (i=3);
   if MyScreen=NIL then begin
      ERRORMSG('Kann Screen nicht ffnen!','Cant open screen!');
      exit;
   end;
   Color:=ColArr(100,100,190,     0,  0,  0,
                 255,255,255,     0,200,255,
                 255,  0,  0,   200,200,200,
                 255,255,  0,         0,0,0,
                       0,0,0,         0,0,0,
                       0,0,0,         0,0,0,
                   0,150,200,    10, 10, 10,
                 200,200,200,    70, 70,145);
   for i:=0 to 15 do SetRGB4(^MyScreen^.ViewPort,i,Color[i*3+1] div 16 ,Color[i*3+2] div 16,Color[i*3+3] div 16);
   NeuWindow:=NewWindow(0,0,640,512,2,1,RAWKEY or GADGETDOWN or GADGETUP or MENUPICK,
                        SMART_REFRESH or BORDERLESS or BACKDROP,NIL,NIL,'',MyScreen,NIL,640,512,640,512,CUSTOMSCREEN);
   MyWindow:=OpenWindow(^Neuwindow);
   If MyWindow=Nil Then begin
      ERRORMSG('Kann Fenster nicht ffnen!','Cant open window!');
      exit;
   end;
   MenuX:=Menu(NIL,10,0,150,10,MENUENABLED,PText[13],^Mi1[1],0,0,0,0);
   Mi1[1]:=MenuItem(^Mi1[2],0, 0,150,15,ITEMTEXT+ITEMENABLED+HIGHCOMP+COMMSEQ,0,^MiT[1],NIL,'L',   NIL,0);
   Mi1[2]:=MenuItem(^Mi1[3],0,15,150,15,ITEMTEXT+ITEMENABLED+HIGHCOMP+COMMSEQ,0,^MiT[2],NIL,'S',   NIL,0);
   Mi1[3]:=MenuItem(^Mi1[4],0,30,150,15,ITEMTEXT+ITEMENABLED+HIGHCOMP,        0,^MiT[3],NIL,chr(0),NIL,0);
   Mi1[4]:=MenuItem(^Mi1[5],0,45,150,15,ITEMTEXT+ITEMENABLED+HIGHCOMP+COMMSEQ,0,^MiT[4],NIL,'?',   NIL,0);
   Mi1[5]:=MenuItem(NIL,    0,60,150,15,ITEMTEXT+ITEMENABLED+HIGHCOMP+COMMSEQ,0,^MiT[5],NIL,'Q',   NIL,0);
   MiT[1]:=IntuiText(2,0,0,1,1,^CustomTA,PText[14],NIL);
   MiT[2]:=IntuiText(2,0,0,1,1,^CustomTA,PText[15],NIL);
   MiT[3]:=IntuiText(2,0,0,1,1,^CustomTA,PText[16],NIL);
   MiT[4]:=IntuiText(2,0,0,1,1,^CustomTA,PText[17],NIL);
   MiT[5]:=IntuiText(2,0,0,1,1,^CustomTA,PText[18],NIL);
   SetMenuStrip(MyWindow,^MenuX);
   process_ptr:=p_Process(FindTask(NIL));
   oldwindow_ptr:=process_ptr^.pr_WindowPtr;
   Process_ptr^.pr_WindowPtr:=MyWindow;
   SetAPen(MyWindow^.RPort,15);   RectFill(MyWindow^.RPort,0,16,639,511);
   MAKEBORDER(MyWindow^,3,19,355,371,NEGATIVE);    {*** TOP ***}
   MAKEBORDER(MyWindow^,3,375,135,507,NEGATIVE);   {*** FRONT ***}
   MAKEBORDER(MyWindow^,139,375,271,507,NEGATIVE); {*** REAR ***}
   DRAWFIELD;
   WRITE(180,25,3,3,MyWindow^,PText[73]);
   WRITE(68,380,3,3,MyWindow^,PText[74]);
   WRITE(204,380,3,3,MyWindow^,PText[75]);

   MAKEBORDER(MyWindow^,365,26,634,181,OPENBORDER);
   WRITE(500,19,3,2,MyWindow^,PText[29]);
   DKnopfTx[1]:=IntuiText(2,0,0,48,5,^CustomTA,PText[30],NIL);
   DKnopfTx[2]:=IntuiText(2,0,0,48,5,^CustomTA,PText[31],NIL);
   DKnopfTx[3]:=IntuiText(3,0,0,48,5,^CustomTA,PText[32],NIL);
   for i:=1 to 3 do begin
      DKnopf[i]:=Gadget(NIL,372,i*50+5,43,21,GADGHIMAGE+GADGIMAGE,$1,BOOLGADGET,
                        ^GImg[3],^GImg[4],^DKnopfTx[i],0,NIL,i,0);
      DTextGad[i]:=Gadget(NIL,373,i*50-14,255,15,GADGHCOMP,STRINGCENTER+$1,STRGADGET,
                        NIL,Nil,Nil,0,^DTextInfo[i],100+i,0);
      DTextInfo[i]:=StringInfo(^DBuffer[i],^DUndoBuffer[i],0,200,0,0,200,0,0,0,Nil,0,Nil);

      MAKEBORDER(MyWindow^,372,i*50-15,628,i*50-1,NEGATIVE);
      AddGadget(MyWindow,^DKnopf[i],NIL);
      AddGadget(MyWindow,^DTextGad[i],NIL);
   end;
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
   OPENCTSCREEN:=true;
   if GUI then CREATEGUI;
end;



function SETPREFS:boolean;

type STagArr=array [1..4] of long;

var STags                       :STagArr;
var Langs,ActLang,ChBit         :byte;
var LanguageNames               :array[1..15] of string[70];
var MySReq                      :^rtScreenModeRequester;
var OldTextMemA,OldTextMemL     :long;
var MySList                     :SelectListGad;
var DWindow                     :^Window;
var PKnopf                      :array [1..3] of Gadget;
var PKnopfTx                    :array [1..20] of IntuiText;


function READLANGS:boolean;

var j           :integer;
var inf         :p_FileInfoBlock;
var MyLock      :BPTR;

Begin
   READLANGS:=true;

   Langs:=0;
   inf:=ptr(AllocMem(sizeof(FileInfoBlock),0));
   if long(inf)=0 then begin
      READLANGS:=false;
      exit;
   end;
   MyLock:=Lock('CTLocale',-2);
   If MyLock=0 Then READLANGS:=false Else Begin
      j:=Examine(MyLock,inf);
      If inf^.fib_DirEntryType<=0 Then READLANGS:=false Else Begin
         j:=ExNext(MyLock,Inf);
         While (j<>0) and (Langs<15) do begin
            Langs:=Langs+1;
            LanguageNames[Langs]:=inf^.fib_filename;
            j:=ExNext(MyLock,Inf)
         End;
      End
   End;
   FreeMem(Long(inf),SizeOf(FileInfoBlock));
   if Langs=0 then READLANGS:=false;
End;



begin
   SETPREFS:=false;
   if not READLANGS then exit;
   if not OPENDWIN(100,20,DWindow,PText[81],0,0) then exit;

   PKnopf[1]:=Gadget(NIL,500,40,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,^GImg[5],NIL,^OKKnopfTx,0,Nil,1,0);
   ActLang:=0;
   repeat
      ActLang:=ActLang+1;
   until (ActLang>=Langs) or (LanguageNames[ActLang]=Prefs.LocaleString);
   PKnopf[2]:=Gadget(NIL,18,40,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,^GImg[2],NIL,^PKnopfTx[ActLang+1],0,NIL,2,0);
   MySList:=SelectListGad(DWindow,^PKnopf[2],ActLang,0,0,0,ITTArr(NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL));
   for i:=2 to Langs+1 do begin
      PKnopfTx[i]:=IntuiText(2,0,0,4,2,^CustomTA,LanguageNames[i-1],NIL);
      MySList.ITextTag[pred(i)]:=^PKnopfTx[i];
   end;
   MySList.ITextTag[15]:=NIL;

   PKnopf[3]:=Gadget(NIL,18,65,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,^GImg[1],NIL,^PKnopfTx[Langs+2],0,NIL,3,0);
   PKnopfTx[Langs+2]:=IntuiText(2,0,0,4,2,^CustomTA,PText[82],NIL);
   PKnopfTx[Langs+2].LeftEdge:=64-IntuiTextLength(^PKnopfTx[Langs+2]) div 2;
   MAKEBORDER(DWindow^,150,65,406,80,NEGATIVE);
   SetAPen(DWindow^.RPort,0); RectFill(DWindow^.RPort,151,66,405,79);
   s:=intstr(Prefs.ScrWidth)+' x '+intstr(Prefs.ScrHeight);
   WRITE(278,67,2,3,DWindow^,s);

   for i:=1 to 3 do  AddGadget(DWindow,^PKnopf[i],NIL);
   RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
   repeat

      RawCode:=0; GadCode:=0;
      IMsg:=Wait_Port(DWindow^.UserPort);
      If IMsg<>Nil Then begin
         IMsg:=Get_Msg(DWindow^.UserPort);
         if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
            XGadget:=IMsg^.IAddress;
            GadCode:=XGadget^.GadgetID;
         end;
         if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
         Reply_Msg(IMsg)
      end;

      if GadCode=3 then begin
         MySReq:=rtAllocRequestA(RT_SCREENMODEREQ,NIL);
         if MySReq<>NIL then begin
            STags:=STagArr(RTSC_Flags,SCREQF_GUIMODES or SCREQF_SIZEGADS or SCREQF_NONSTDMODES,
                           0,0);
            if rtScreenModeRequestA(MySReq,PText[1],^STags) then begin
               Prefs.ScrID:=MySReq^.DisplayID;
               Prefs.ScrWidth:=MySReq^.DisplayWidth;
               if Prefs.ScrWidth<640 then Prefs.ScrWidth:=640;
               Prefs.ScrHeight:=MySReq^.DisplayHeight;
               if Prefs.ScrHeight<512 then Prefs.ScrHeight:=512;
               SETPREFS:=true;
            end;
            rtFreeRequest(MySReq);
            GadCode:=4;
         end else GadCode:=0;
      end;

      if GadCode=2 then begin
         ActLang:=DOSELECTLIST(^MySList);
         Prefs.LocaleString:=LanguageNames[ActLang];
         OldTextMemA:=TextMemA; TextMemA:=0;
         OldTextMemL:=TextMemL;
         if not INITLANG then begin
            TextMemA:=OldTextMemA;
            TextMemL:=OldTextMemL;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
            DisplayBeep(NIL);
         end else begin
            FreeMem(OldTextMemA,OldTextMemL);
            SETPREFS:=true;
            GadCode:=4;
         end;
      end;

   Until (GadCode in [1,4]) or (RawCode=68);
   if RawCode=68 then begin
      PKnopf[1].flags:=PKnopf[1].flags+SELECTED;
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      delay(5);
   end;

   CloseWindow(DWindow);
   if GadCode=4 then begin
      process_ptr^.pr_WindowPtr:=OldWindow_Ptr;
      while MyScreen^.FirstWindow<>NIL do begin
         while MyScreen^.FirstWindow^.FirstGadget<>NIL do
         RemoveGadgets(MyScreen^.FirstWindow,MyScreen^.FirstWindow^.FirstGadget);
         CloseWindow(MyScreen^.FirstWindow);
      end;
      CloseScreen(MyScreen);
      if not OPENCTSCREEN then SETPREFS:=false
   end;
   GadCode:=0; RawCode:=0;
end;




procedure GAMEEXIT;

begin
   if MyScreen<>NIL then begin
      while MyScreen^.FirstWindow<>NIL do CloseWindow(MyScreen^.Firstwindow);
      CloseScreen(MyScreen);
   end;
   if ObjMemA<>0 then FreeVec(ObjMemA);
   if KnobMem<>0 then FreeVec(KnobMem);
   if CalcMem<>0 then FreeVec(CalcMem);
   if SyncMemA<>0 then FreeVec(SyncMemA);
   if TextMemA<>0 then FreeVec(TextMemA);
   for i:=1 to 6 do begin
      if GMem[i]<>0 then FreeVec(GMem[i]);
      if ButtonMem[i]<>0 then FreeVec(ButtonMem[i]);
   end;
end;




function SCANANIM:boolean;

type DPANHeader=record
        Version,Frames          :word;
        FPS,pad1,pad2,pad3      :byte;
     end;
type ANHDHeader=record
        Operation,Mask          :byte;
        w,h,x,y                 :word;
        AbsTime,RelTime         :long;
        Interleave,pad0         :byte;
        Bits                    :long;
        Pad                     :array [1..16] of byte;
     end;

var ChunkName                   :string[5];
var ChunkLength                 :long;
var ANHD                        :ANHDHeader;
var DPAN                        :DPANHeader;
var FHandle                     :BPTR;
var l,Frames,Addr1              :long;
var Data1                       :^long;
var DynamicAnim                 :boolean;


function READCHUNK:boolean;

begin
   l:=DosRead(FHandle,^ChunkName,4);
   l:=l +DosRead(FHandle,^ChunkLength,4);
   if odd(ChunkLength) then ChunkLength:=ChunkLength+1;
   if l<8 then READCHUNK:=false else READCHUNK:=true;
end;


begin
   SCANANIM:=false;
   if SyncMemA<>0 then FreeVec(SyncMemA); SyncMemA:=0;
   FPSTextGad.Flags:=FPSTextGad.Flags and not GADGDISABLED;
   if PathFR='' then exit;
   DPAN:=DPANHeader(0,0,0,0,0,0);
   ChunkName[5]:=chr(0);
   Frames:=0;
   DynamicAnim:=false;
   FHandle:=DosOpen(PathFR,MODE_OLDFILE);
   if FHandle=0 then begin
      l:=TASKREQUEST(PathFR,PText[93],'',PText[1],'');
      exit;
   end;
   if not READCHUNK then begin
      DosClose(FHandle);
      l:=TASKREQUEST(PathFR,PText[94],'',PText[1],'');
      exit;
   end;
   l:=DosRead(FHandle,^ChunkName,4);
   if ChunkName='ANIM' then begin
      while READCHUNK do begin
         if ChunkName='FORM' then begin
            Frames:=Frames+1;
            l:=DosSeek(FHandle,4,OFFSET_CURRENT);
         end else begin
            if ChunkName='DPAN' then begin
               ChunkLength:=ChunkLength-DosRead(FHandle,^DPAN,sizeof(DPANHeader));
               if DPAN.FPS=0 then DPAN.FPS:=30;
               Buffer[7]:=intstr(DPAN.FPS);
               ChunkCNHD.FPS:=DPAN.FPS;
            end else if ChunkName='ANHD' then begin
               ChunkLength:=ChunkLength-DosRead(FHandle,^ANHD,sizeof(ANHDHeader));
               if ANHD.RelTime>1 then DynamicAnim:=true;
            end;
            l:=DosSeek(FHandle,ChunkLength,OFFSET_CURRENT);
         end;
      end;
   end else begin
      s:=PText[95]+' ('+ChunkName+')!';
      l:=TASKREQUEST(PathFR,s,'',PText[1],'');
      DosClose(FHandle);
      exit;
   end;
   if DynamicAnim then begin
      l:=DosSeek(FHandle,12,OFFSET_BEGINNING);
      SyncMemL:=Frames*4;
      if Frames<MaxFrames then SyncMemL:=MaxFrames*4;
      SyncMemA:=AllocVec(SyncMemL,MEMF_CLEAR);
      if SyncMemA=0 then begin
         l:=TASKREQUEST(PathFR,PText[96],'',PText[1],'');
         DosClose(FHandle);
         exit;
      end;
      Addr1:=SyncMemA;
      while READCHUNK do begin
         if ChunkName='FORM' then begin
            Frames:=Frames+1;
            l:=DosSeek(FHandle,4,OFFSET_CURRENT);
         end else begin
            if ChunkName='ANHD' then begin
               ChunkLength:=ChunkLength-DosRead(FHandle,^ANHD,sizeof(ANHDHeader));
               if ANHD.RelTime=0 then ANHD.RelTime:=1;
               if Addr1<SyncMemA+SyncMemL then begin
                  Data1:=ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=ANHD.RelTime;
               end;
            end;
            l:=DosSeek(FHandle,ChunkLength,OFFSET_CURRENT);
         end;
      end;
      FPSTextGad.Flags:=FPSTextGad.Flags or GADGDISABLED;
   end else if DPAN.FPS=0 then l:=TASKREQUEST(PText[97],PText[98],'',PText[1],'');
   DosClose(FHandle);
   SCANANIM:=true;
end;



procedure SETVALUES;

var l,i         :integer;

begin
   with CameraSize do begin
      val(Buffer[1],l,i); if l<10 then l:=10; if l>32000 then l:=32000; x:=l;
      val(Buffer[2],l,i); if l<10 then l:=10; if l>32000 then l:=32000; y:=l;
      val(Buffer[3],l,i); if l<10 then l:=10; if l>32000 then l:=32000; z:=l;
      val(Buffer[4],l,i);       if l<-32000 then l:=-32000;
      if l>32000 then l:=32000; CameraYOffset:=l;
   end;
   Buffer[1]:=intstr(CameraSize.x);
   Buffer[2]:=intstr(CameraSize.y);
   Buffer[3]:=intstr(CameraSize.z);
   Buffer[4]:=intstr(CameraYOffset);
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
end;



procedure ROTATE(MyObjData :ObjectData; rz,ry,rx :integer);

var FactorSin,FactorCos :real;
var x,y,z               :real;
var i                   :integer;

begin
   x:=MyObjData^.x; y:=MyObjData^.y; z:=MyObjData^.z;
   if rz<>0 then begin
      if rz<0 then begin
         FactorSin:=sin(0.0175);   FactorCos:=cos(0.0175);
      end else begin
         FactorSin:=sin(-0.0175);    FactorCos:=cos(-0.0175);
      end;
      for i:=1 to abs(rz) do begin
         x:=(x*FactorCos-y*FactorSin)*1.0003;
         y:=x*FactorSin+y*FactorCos;
      end;
   end;
   if ry<>0 then begin
      if ry<0 then begin
         FactorSin:=sin(0.0175);   FactorCos:=cos(0.0175);
      end else begin
         FactorSin:=sin(-0.0175);    FactorCos:=cos(-0.0175);
      end;
      for i:=1 to abs(ry) do begin
         x:=x*FactorCos+z*FactorSin;
         z:=(z*FactorCos-x*FactorSin)*1.0003;
      end;
   end;
   if rx<>0 then begin
      if rx<0 then begin
         FactorSin:=sin(0.0175);   FactorCos:=cos(0.0175);
      end else begin
         FactorSin:=sin(-0.0175);    FactorCos:=cos(-0.0175);
      end;
      for i:=1 to abs(rx) do begin
         y:=y*FactorCos-z*FactorSin;
         z:=(y*FactorSin+z*FactorCos)*1.0003;
      end;
   end;
   MyObjData^.x:=round(x); MyObjData^.y:=round(y); MyObjData^.z:=round(z);
end;



procedure ROTATEZ(MyObjData :ObjectData; rz :integer);

var FactorSin,FactorCos :real;
var x,y                 :real;
var i                   :integer;

begin
   x:=MyObjData^.x; y:=MyObjData^.y;
   if rz<>0 then begin
      if rz<0 then begin
         FactorSin:=sin(0.0175);   FactorCos:=cos(0.0175);
      end else begin
         FactorSin:=sin(-0.0175);    FactorCos:=cos(-0.0175);
      end;
      for i:=1 to abs(rz) do begin
         x:=(x*FactorCos-y*FactorSin)*1.0003;
         y:=x*FactorSin+y*FactorCos;
      end;
   end;
   MyObjData^.x:=round(x); MyObjData^.y:=round(y);
end;



procedure CALCFILE(Trace :boolean; StartFrame,EndFrame :long;);

var MyObjMemPos         :long;
var MyObjectHeader      :^r_ObjectHeader;
var DrawDisplay         :boolean;
var DataS               :^long;


procedure SAVECINEDATA;

var EchoFrames          :byte;
var SaveCineData        :r_CineData;
var Addr1               :long;
var MyCineData          :^r_CineData;
var SaveCD              :r_CineData;


procedure CONVERTDYNAMIC(MyObjectHeader :r_ObjectHeader);

var JiffieCtr,FrameCtr,AddrS,AddrT      :long;
var DataS,DataT                         :^long;

begin
   with MyObjectHeader do begin
      if TimeAddr=0 then exit;
      AddrS:=SyncMemA; AddrT:=TimeAddr;
      JiffieCtr:=0;
      FrameCtr:=0;
      repeat
         DataT:=ptr(AddrT);
         FrameCtr:=FrameCtr+1;
         if DataT^=FrameCtr then begin
            AddrT:=AddrT+4;
            DataT^:=JiffieCtr;
         end else if DataT^=0 then AddrT:=AddrT+4;
         DataS:=ptr(AddrS); AddrS:=AddrS+4;
         JiffieCtr:=JiffieCtr+DataS^;
      until (AddrS>=SyncMemA+SyncMemL) or (AddrT>=TimeAddr+TimeLength);
      DataT:=ptr(AddrT);
      if AddrT<TimeAddr+TimeMemL then DataT^:=JiffieCtr;
   end;
end;


procedure CONVERTSTATIC(MyObjectHeader :r_ObjectHeader);

var FrameCtr,AddrT      :long;
var DataT               :^long;

begin
   with MyObjectHeader do begin
      if TimeAddr=0 then exit;
      AddrT:=TimeAddr;
      FrameCtr:=0;
      repeat
         DataT:=ptr(AddrT);
         FrameCtr:=FrameCtr+1;
         if DataT^=FrameCtr then begin
            AddrT:=AddrT+4;
            DataT^:=round((60/ChunkCNHD.FPS)*pred(FrameCtr));
         end else if DataT^=0 then AddrT:=AddrT+4;
       until AddrT>=TimeAddr+TimeLength;
      DataT:=ptr(AddrT);
      if AddrT<TimeAddr+TimeMemL then DataT^:=round(FrameCtr*(1/ChunkCNHD.FPS)*60);
   end;
end;



function GETJIFFIES:long;

var JiffieCtr,AddrS     :long;
var DataS               :^long;

begin
   AddrS:=SyncMemA;
   JiffieCtr:=0;
   repeat
      DataS:=ptr(AddrS); AddrS:=AddrS+4;
      JiffieCtr:=JiffieCtr+DataS^;
   until AddrS>SyncMemA+SyncMemL;
   GETJIFFIES:=JiffieCtr;
end;



begin
   FHandle:=DosOpen(DBuffer[3],MODE_NEWFILE);
   if FHandle<>0 then begin
      EchoFrames:=0;
      s:='FORM....CINM';
      l:=DosWrite(FHandle,^s,12);
      ChunkCNHD.Frames:=MaxFrames;
      if SyncMemA<>0 then begin
         ChunkCNHD.FPS:=0;
         ChunkCNHD.AnimJiffies:=GETJIFFIES;
      end else ChunkCNHD.AnimJiffies:=0;
      l:=DosWrite(FHandle,^ChunkCNHD,sizeof(r_CineDataFileHeader));
      for MyObjMemPos:=1 to MaxObjects do begin
         MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
         with MyObjectHeader^ do if not (Flags and OFLAG_SOUND=0) then begin
            s:='FRDT';
            l:=DosWrite(FHandle,^s,4);
            l:=CineLength+222;
            l:=DosWrite(FHandle,^l,4);
            l:=DosWrite(FHandle,^Flags,2);
            l:=DosWrite(FHandle,^Name,20);
            l:=DosWrite(FHandle,^Sample,200);
            l:=DosWrite(FHandle,ptr(CineAddr),CineLength);
            if MyObjectHeader^.EchoVolume>0 then begin {*** Echo-Objekt ***}
               EchoFrames:=ChunkCNHD.FPS div 2; if EchoFrames<1 then EchoFrames:=1;
               if ChunkCNHD.FPS=0 then EchoFrames:=5;
               s:='FRDT';
               l:=DosWrite(FHandle,^s,4);
               l:=CineLength+222+sizeof(r_CineData);
               l:=DosWrite(FHandle,^l,4);
               i:=MyObjectHeader^.Flags or OFLAG_SOUNDEND;
               l:=DosWrite(FHandle,^i,2);
               s:='Echo-'+Name; s[20]:=chr(0);
               l:=DosWrite(FHandle,^s,20);
               l:=DosWrite(FHandle,^Sample,200);
               SaveCineData:=r_CineData(-32000,-32000,-32000,EchoFrames,0,
                                        EchoVolume,0,0);
               l:=DosWrite(FHandle,^SaveCineData,sizeof(r_CineData));
               Addr1:=CineAddr;
               repeat
                  MyCineData:=ptr(Addr1); Addr1:=Addr1+sizeof(r_CineData);
                  SaveCD:=MyCineData^;
                  if SaveCD.x>-32000 then begin
                     SaveCD.x:=0;
                     SaveCD.y:=-ChunkCNHD.Threshold;
                     SaveCD.z:=0;
                  end;
                  SaveCD.Volume:=EchoVolume;
                  l:=DosWrite(FHandle,^SaveCD,sizeof(r_CineData));
               until Addr1>=CineAddr+CineLength;
            end;
         end;
         with MyObjectHeader^ do if not (Flags and OFLAG_TIMEPATTERN=0) then begin
            if Flags and OFLAG_TIMEPATTERNONLY=0 then begin
               if SyncMemA=0 then CONVERTSTATIC(MyObjectHeader^)
                else CONVERTDYNAMIC(MyObjectHeader^);
            end;
            s:='TIME';
            l:=DosWrite(FHandle,^s,4);
            l:=TimeLength+22;
            l:=DosWrite(FHandle,^l,4);
            l:=DosWrite(FHandle,^Flags,2);
            l:=DosWrite(FHandle,^Name,20);
            l:=DosWrite(FHandle,ptr(TimeAddr),TimeLength);
         end;
      end;

      if DBuffer[2]<>'' then begin
         s:='ANIM';
         l:=DosWrite(FHandle,^s,4);
         l:=200;
         l:=DosWrite(FHandle,^l,4);
         l:=DosWrite(FHandle,^DBuffer[2],200);
      end;

      l:=DosSeek(FHandle,4,OFFSET_BEGINNING);
      l:=l-8;
      l:=DosWrite(FHandle,^l,4);
      if EchoFrames>0 then begin {*** Bei nderungen an der Anzahl Frames Header neu abspeichern ***}
         ChunkCNHD.Frames:=ChunkCNHD.Frames+EchoFrames;
         l:=DosSeek(FHandle,12,OFFSET_BEGINNING);
         l:=DosWrite(FHandle,^ChunkCNHD,sizeof(r_CineDataFileHeader));
      end;
      DosClose(FHandle);
   end else l:=TASKREQUEST(DBuffer[3],PText[99],'',PText[1],'');
end;




procedure CALCAVB(Trace :boolean; StartFrame,EndFrame :long;);

type r_FrameDataHeader=record
        Flags                   :word;
        Name                    :string[20];
        Sample                  :string[200];
     end;
type W2Arr=array [1..2] of word;

var MyFRDTHeader                                :r_FrameDataHeader;
var MyFRDT                                      :r_CineData;
var TrackData                                   :^W2Arr;
var TrackMemA,TrackMemL,TextMemA,TextMemL,
    Addr8,TrackCtr,MaxTracks                    :long;
var i                                           :integer;
var Data8                                       :^byte;
var MyObjectHeader                              :^r_ObjectHeader;
var MyFramePos                                  :long;
var MyCineData                                  :^r_CineData;
var ActCineData                                 :r_CineData;
var MyStr                                       :str;
var MyTimeData,OldTimeData                      :^r_TimeData;


procedure FREEMYMEM;

begin
   for MyObjMemPos:=1 to MaxObjects do begin
      MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
      with MyObjectHeader^ do if CineAddr<>0 then begin
         FreeVec(CineAddr);
         CineAddr:=0;
      end;
      with MyObjectHeader^ do if TimeAddr<>0 then begin
         FreeVec(TimeAddr);
         TimeAddr:=0;
      end;
   end;
   if TrackMemA<>0 then FreeVec(TrackMemA);
   if TextMemA<>0 then FreeVec(TextMemA);
   Knopf[6].Flags:=Knopf[6].Flags and not SELECTED;
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
end;



begin
   SETVALUES;
   TrackMemA:=0; TextMemA:=0; DrawDisplay:=true;
   CineMemL:=MaxFrames*sizeof(r_CineData);
   TimeMemL:=MaxFrames*sizeof(r_TimeData)+4;
   if Trace then for MyObjMemPos:=1 to MaxObjects do begin
      MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
      with MyObjectHeader^ do if Flags and OFLAG_SOUND=OFLAG_SOUND then begin
         CineAddr:=AllocVec(CineMemL,0);
         CineLength:=0;
         if CineAddr=0 then begin
            l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
      end;
      with MyObjectHeader^ do if Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN then begin
         TimeAddr:=AllocVec(TimeMemL,0);
         TimeLength:=0;
         if TimeAddr=0 then begin
            l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
      end;
   end;

   FHandle:=DosOpen(DBuffer[1],MODE_OLDFILE);
   if FHandle=0 then begin
      l:=TASKREQUEST(DBuffer[1],PText[93],'',PText[1],'');
      FREEMYMEM;
      exit;
   end;
   l:=DosSeek(FHandle,0,OFFSET_END);
   TextMemL:=DosSeek(FHandle,0,OFFSET_BEGINNING);
   TextMemA:=AllocVec(TextMemL,0);
   if TextMemA=0 then begin
      l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
      DosClose(FHandle);
      FREEMYMEM;
      exit;
   end;
   l:=DosRead(FHandle,ptr(TextMemA),TextMemL);
   DosClose(FHandle);
   Addr8:=TextMemA;
   TrackCtr:=0;
   repeat
      Data8:=ptr(Addr8); Addr8:=Addr8+1;
      if Data8^=10 then begin
         Data8^:=0;
         TrackCtr:=TrackCtr+1;
      end;
   until Addr8>=TextMemA+TextMemL;
   MaxTracks:=TrackCtr;
   TrackMemL:=TrackCtr*4;
   TrackMemA:=AllocVec(TrackMemL,0);
   if TrackMemA=0 then begin
      l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
      FREEMYMEM;
      exit;
   end;
   Addr8:=TextMemA; Data8:=ptr(Addr8);
   TrackCtr:=0;
   repeat
      if (Addr8=TextMemA) or (Data8^=0) then begin
         if Addr8+1<TextMemA+TextMemL then begin
            if Data8^=0 then MyStr:=ptr(Addr8+1) else MyStr:=ptr(Addr8);
            TrackData:=ptr(TrackMemA+TrackCtr*4);  TrackCtr:=TrackCtr+1;
            val(MyStr,l,i);
            TrackData^[1]:=l div 1000;
            TrackData^[2]:=l-(TrackData^[1]*1000);
         end;
      end;
      Addr8:=Addr8+1; Data8:=ptr(Addr8);
   until Addr8>=TextMemA+TextMemL;
   FreeVec(TextMemA); TextMemA:=0;

   MyFramePos:=pred(StartFrame);
   repeat
      if DrawDisplay then DRAWFIELD;
      DrawDisplay:=false;
      MyFramePos:=MyFramePos+1;
      MyObjMemPos:=0;
      for MyObjMemPos:=1 to MaxObjects do begin
         MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
         TrackCtr:=0;
         repeat
            TrackData:=ptr(TrackMemA+TrackCtr*4);
            TrackCtr:=TrackCtr+1;
         until (TrackCtr>=MaxTracks) or (TrackData^[1]=MyFramePos)
         and (TrackData^[2]=MyObjMemPos);
         if MyObjectHeader^.Flags and OFLAG_SOUND=OFLAG_SOUND then begin
            ActCineData:=r_CineData(-32000,-32000,-32000,1,0,MyObjectHeader^.ObjectVolume,0,0);
            if (TrackData^[1]=MyFramePos) and (TrackData^[2]=MyObjMemPos) then begin
               with ActCineData do begin
                  x:=0;
                  l:=round((70/CameraSize.y)*1150);
                  l:=l-(CameraYOffset*10);
                  if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                  y:=l;
                  l:=round((2/CameraSize.z)*1150);
                  if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                  z:=l;
                  if (x in [-1700..1700]) and (y in [-1700..1700])
                  and (z in [-1700..1700]) and not Trace then begin
                     DrawDisplay:=true;
                     SetAPen(MyWindow^.RPort,MyObjectHeader^.ObjectTyp);
                     RectFill(MyWindow^.RPort,round(177-x/10),round(193-y/10),round(180-x/10),round(196-y/10)); {*** TOP ***}
                     if MyObjectHeader^.EchoVolume>0 then begin
                        Move(MyWindow^.RPort,round(180-x/10),round(196-y/10));
                        Draw(MyWindow^.RPort,236,252);
                        Move(MyWindow^.RPort,round(177-x/10),round(196-y/10));
                        Draw(MyWindow^.RPort,121,252);
                     end;
                     if y>=0 then RectFill(MyWindow^.RPort,round(68-x/27.7),round(440-z/27.7),round(69-x/27.7),round(441-z/27.7))
                     else RectFill(MyWindow^.RPort,round(204-x/27.7),round(440-z/27.7),round(205-x/27.7),round(441-z/27.7))  {*** FRONT / REAR ***}
                  end;
               end;
            end;
            if Trace then with MyObjectHeader^ do begin
               MyCineData:=ptr(CineAddr+CineLength);
               CineLength:=CineLength+sizeof(r_CineData);
               if SyncMemA<>0 then begin
                  if MyFramePos*4<SyncMemL then begin
                     DataS:=ptr(SyncMemA+MyFramePos*4);
                     l:=DataS^;
                  end else l:=1;
               end else l:=0;
               MyCineData^:=ActCineData;
               MyCineData^.RelTime:=l;
               if MyFramePos>1 then begin
                  {*** KOMPRESSION mittels Steps ***}
                  MyCineData:=ptr(CineAddr+CineLength-2*sizeof(r_CineData));
                  if (MyCineData^.x=ActCineData.x) and
                     (MyCineData^.y=ActCineData.y) and
                     (MyCineData^.z=ActCineData.z) and
                     (MyCineData^.RelTime=l) then begin
                     MyCineData^.Steps:=MyCineData^.Steps+1;
                     CineLength:=CineLength-sizeof(r_CineData);
                  end;
               end;
            end;
         end;
         if (MyObjectHeader^.Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN) then begin
            if Trace then with MyObjectHeader^ do
            if (TrackData^[1]=MyFramePos) and (TrackData^[2]=MyObjMemPos) then begin
               if (TimeAddr<>0) and (TimeLength<TimeMemL) then begin
                  MyTimeData:=ptr(TimeAddr+TimeLength);
                  TimeLength:=TimeLength+sizeof(r_TimeData);
                  MyTimeData^:=r_TimeData(MyFramePos,MyFramePos+1,0);
                  if TimeLength>sizeof(r_TimeData) then begin
                  {*** schrittweise Ermittlung des Timepatterns ***}
                     OldTimeData:=ptr(TimeAddr+TimeLength-2*sizeof(r_TimeData));
                     if OldTimeData^.EndTime=MyFramePos then begin
                        OldTimeData^.EndTime:=OldTimeData^.EndTime+1;
                        TimeLength:=TimeLength-sizeof(r_TimeData);
                     end;
                  end;
               end else exit;
            end;
         end;
         s:=intstr(MyFramePos); Buffer[6]:=s; WRITE(10,25,3,5,MyWindow^,s);
         if not Trace then begin
            WaitBlit; delay(1); WaitTOF;
         end;
      end;
   until (MyFramePos>=EndFrame) or ((Knopf[6].Flags and SELECTED=0) and not Trace);
   ActFramePos:=MyFramePos;

   if Trace then SAVECINEDATA;
   FREEMYMEM;
end; {*** CALCAVB ***}




procedure CALCIMAGINE(Trace :boolean; StartFrame,EndFrame :long;);

var PosMemA,PosMemL,PosAddr,AlgnMemA,AlgnMemL,
    AlgnAddr,MyFramePos,FrameSteps,
    l,Addr1                                     :long;
var LoadObject,LoadCamera                       :boolean;
var MyObjData                                   :ObjectData;
var ActCameraData,ActCameraAlignment,ActObjData,
    LastObjData                                 :r_ObjectData;
var TrackedObjData                              :r_ObjectData;
var MyCineData                                  :^r_CineData;
var MyTimeData,OldTimeData                      :^r_TimeData;
var Factor1,Factor2                             :real;
var i                                           :integer;
var dx,dy,dz                                    :long;

var FHandle,FHandle2                            :BPTR;
var MyObjectHeader                              :^r_ObjectHeader;




function FINDTRACKEDOBJECT(OName :str):long;

var MyObjMemPos         :integer;


begin
   for MyObjMemPos:=1 to MaxObjects do begin
      MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
      with MyObjectHeader^ do if OName=Name then begin
         FINDTRACKEDOBJECT:=MyObjMemPos;
         exit;
      end;
   end;
end;



procedure FINDTRACKOBJPOS(ObjNum :long);

var ActObjData,LastObjData      :r_ObjectData;
var MyObjData                   :ObjectData;
var MyObjectHeader              :^r_ObjectHeader;
var PosAddr                     :long;


begin
   MyObjectHeader:=ptr(ObjMemA+(pred(ObjNum)*ObjHeaderSize));
   PosAddr:=MyObjectHeader^.StartAddr;
   ActObjData:=r_ObjectData(0,0,0,0,0); LastObjData:=ActObjData;
   repeat
      MyObjData:=ptr(PosAddr); PosAddr:=PosAddr+sizeof(r_ObjectData);
      if MyObjData^.EndFrame<=MyFramePos then LastObjData:=MyObjData^;
      if MyFramePos in [MyObjData^.StartFrame..MyObjData^.EndFrame]
       then ActObjData:=MyObjData^;
   until (PosAddr>=MyObjectHeader^.EndAddr) or (MyObjData^.StartFrame>MyFramePos);
   with ActObjData do begin
      if StartFrame=0 then ActObjData:=LastObjData;
      if (MyFramePos in [StartFrame..EndFrame]) and (StartFrame<>EndFrame) then begin
         FrameSteps:=1+EndFrame-StartFrame;
         Factor1:=(EndFrame-MyFramePos)/FrameSteps;
         Factor2:=1-Factor1;
         x:=round(LastObjData.x*Factor1+x*Factor2);
         y:=round(LastObjData.y*Factor1+y*Factor2);
         z:=round(LastObjData.z*Factor1+z*Factor2);
      end;
   end;
   TrackedObjData:=ActObjData;
end;



procedure FREEMYMEM;

begin
   for MyObjMemPos:=1 to MaxObjects do begin
      MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
      with MyObjectHeader^ do if CineAddr<>0 then begin
         FreeVec(CineAddr);
         CineAddr:=0;
      end;
      with MyObjectHeader^ do if TimeAddr<>0 then begin
         FreeVec(TimeAddr);
         TimeAddr:=0;
      end;
   end;
   if PosMemA<>0 then FreeVec(PosMemA);
   if AlgnMemA<>0 then FreeVec(AlgnMemA);
   Knopf[6].Flags:=Knopf[6].Flags and not SELECTED;
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
end;



begin
   PosMemA:=0; AlgnMemA:=0; DrawDisplay:=true;
   SETVALUES;
   CineMemL:=MaxFrames*sizeof(r_CineData);
   TimeMemL:=MaxFrames*sizeof(r_TimeData)+4;
   if Trace then for MyObjMemPos:=1 to MaxObjects do begin
      MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
      with MyObjectHeader^ do if Flags and OFLAG_SOUND=OFLAG_SOUND then begin
         CineAddr:=AllocVec(CineMemL,0);
         CineLength:=0;
         if CineAddr=0 then begin
            l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
      end;
      with MyObjectHeader^ do if Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN then begin
         TimeAddr:=AllocVec(TimeMemL,0);
         TimeLength:=0;
         if TimeAddr=0 then begin
            l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
      end;
   end;
   PosMemL:=MaxPositions*sizeof(r_ObjectData);   PosMemA:=AllocVec(PosMemL,0);
   AlgnMemL:=MaxAlignments*sizeof(r_ObjectData); AlgnMemA:=AllocVec(AlgnMemL,0);
   MyObjMemPos:=0;
   if (PosMemA<>0) and (AlgnMemA<>0) then begin
      PosAddr:=PosMemA; AlgnAddr:=AlgnMemA;
      FHandle:=DosOpen(DBuffer[1],MODE_OLDFILE);
      if FHandle<>0 then begin
         l:=DosSeek(FHandle,8,OFFSET_BEGINNING);
         l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
         if s='ISTG' then begin
            repeat
               l:=DosRead(FHandle,^IFFCh,sizeof(r_IFFCh));
               if l>0 then begin
                  if IFFCh.Name='SOBJ' then repeat
                     IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^IFFCh2,sizeof(r_IFFCh));
                     if IFFCh2.Name='NAME' then begin
                        IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^s,IFFCh2.Length);
                        IFFCh2.Length:=0;
                        LoadObject:=true; LoadCamera:=false;
                        if s='GLOBALS' then LoadObject:=false else begin
                           MyObjMemPos:=MyObjMemPos+1;
                           MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
                           if (MyObjectHeader^.Flags=0) and (s<>'CAMERA') then LoadObject:=false
                           else MyObjectHeader^.StartAddr:=PosAddr;
                           if s='CAMERA' then LoadCamera:=true;
                        end;
                     end else if ((IFFCh2.Name='POSN') or (IFFCh2.Name='POS2'))
                     and LoadObject then begin
                        l:=IFFCh2.Length;
                        if l>sizeof(r_ObjectChunk) then l:=sizeof(r_ObjectChunk);
                        l:=DosRead(FHandle,^MyObjChunk,l);
                        IFFCh.Length:=IFFCh.Length-l;
                        IFFCh2.Length:=IFFCh2.Length-l;
                        MyObjData:=ptr(PosAddr); PosAddr:=PosAddr+sizeof(r_ObjectData);
                        MyObjData^.StartFrame:=MyObjChunk.StartFrame;
                        MyObjData^.EndFrame:=MyObjChunk.EndFrame;
                        MyObjData^.x:=MyObjChunk.x;
                        MyObjData^.y:=MyObjChunk.y;
                        MyObjData^.z:=MyObjChunk.z;
                     end else if ((IFFCh2.Name='ALGN') or (IFFCh2.Name='ALN2'))
                     and LoadObject and LoadCamera then begin
                        l:=IFFCh2.Length;
                        if l>sizeof(r_ObjectChunk) then l:=sizeof(r_ObjectChunk);
                        l:=DosRead(FHandle,^MyObjChunk,l);
                        IFFCh.Length:=IFFCh.Length-l;
                        IFFCh2.Length:=IFFCh2.Length-l;
                        MyObjData:=ptr(AlgnAddr); AlgnAddr:=AlgnAddr+sizeof(r_ObjectData);
                        MyObjData^.StartFrame:=MyObjChunk.StartFrame;
                        MyObjData^.EndFrame:=MyObjChunk.EndFrame;
                        MyObjData^.x:=MyObjChunk.x;
                        MyObjData^.y:=MyObjChunk.y;
                        MyObjData^.z:=MyObjChunk.z;
                     end else if (IFFCh2.Name='TALN') and LoadObject and LoadCamera then begin
                        MyObjChunk:=r_ObjectChunk(0,0,0,0,0,0,0,0,0,'');
                        l:=DosRead(FHandle,^MyObjChunk,6);
                        l:=DosSeek(FHandle,9,OFFSET_CURRENT);
                        l:=15+DosRead(FHandle,^s,IFFCh2.Length-15);
                        s[IFFCh2.Length-14]:=chr(0);
                        IFFCh2.Length:=0;
                        IFFCh.Length:=IffCh.Length-l;
                        MyObjData:=ptr(AlgnAddr); AlgnAddr:=AlgnAddr+sizeof(r_ObjectData);
                        MyObjData^.StartFrame:=MyObjChunk.StartFrame;
                        MyObjData^.EndFrame:=MyObjChunk.EndFrame;
                        MyObjData^.x:=-(30000+FINDTRACKEDOBJECT(s));
                     end;
                     if IFFCh2.Length>0 then begin
                        l:=DosSeek(FHandle,IFFCh2.Length,OFFSET_CURRENT);
                        IFFCh.Length:=IFFCh.Length-IFFCh2.Length;
                        if IFFCh.Length<=0 then MyObjectHeader^.EndAddr:=PosAddr;
                     end;
                     if not LoadObject then begin
                        l:=DosSeek(FHandle,IFFCh.Length,OFFSET_CURRENT);
                        IFFCh.Length:=0;
                     end;
                  until IFFCh.Length<=0;
                  if IFFCh.Length>0 then l:=DosSeek(FHandle,IFFCh.Length,OFFSET_CURRENT);
               end;
            until l=0;
         end else begin
            l:=TASKREQUEST(DBuffer[1],PText[102],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
         DosClose(FHandle);
      end else begin
         l:=TASKREQUEST(DBuffer[1],PText[93],'',PText[1],'');
         FREEMYMEM;
         exit;
      end;
      MyFramePos:=pred(StartFrame);
      repeat
         if DrawDisplay then DRAWFIELD;
         DrawDisplay:=false;
         MyFramePos:=MyFramePos+1;
         for MyObjMemPos:=1 to MaxObjects do begin
            MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
            PosAddr:=MyObjectHeader^.StartAddr;
            if PosAddr<>0 then begin
               ActObjData:=r_ObjectData(0,0,0,0,0); LastObjData:=ActObjData;
               repeat
                  MyObjData:=ptr(PosAddr); PosAddr:=PosAddr+sizeof(r_ObjectData);
                  if MyObjData^.EndFrame<=MyFramePos then LastObjData:=MyObjData^;
                  if MyFramePos in [MyObjData^.StartFrame..MyObjData^.EndFrame]
                   then ActObjData:=MyObjData^;
               until (PosAddr>=MyObjectHeader^.EndAddr) or (MyObjData^.StartFrame>MyFramePos);
               if MyObjMemPos=1 then with ActCameraData do begin
                  {*** CAMERA-POSITION ***}
                  x:=LastObjData.x; y:=LastObjData.y; z:=LastObjData.z;
                  if ActObjData.StartFrame=0 then ActObjData:=LastObjData;
                  if (MyFramePos in [ActObjData.StartFrame..ActObjData.EndFrame])
                  then begin
                     FrameSteps:=ActObjData.EndFrame-ActObjData.StartFrame+1;
                     Factor1:=(ActObjData.EndFrame-MyFramePos)/FrameSteps;
                     Factor2:=1-Factor1;
                     x:=round(x*Factor1+ActObjData.x*Factor2);
                     y:=round(y*Factor1+ActObjData.y*Factor2);
                     z:=round(z*Factor1+ActObjData.z*Factor2);
                  end;
                  {*** CAMERA-ALIGNMENT ***}
                  AlgnAddr:=AlgnMemA;
                  ActObjData:=r_ObjectData(0,0,0,0,0); LastObjData:=ActObjData;
                  repeat
                     MyObjData:=ptr(AlgnAddr); AlgnAddr:=AlgnAddr+sizeof(r_ObjectData);
                     if MyObjData^.EndFrame<=MyFramePos then LastObjData:=MyObjData^;
                     if (MyFramePos in [MyObjData^.StartFrame..MyObjData^.EndFrame])
                      then ActObjData:=MyObjData^;
                  until (AlgnAddr>=AlgnMemA+AlgnMemL) or (MyObjData^.StartFrame>MyFramePos);
                  with ActCameraAlignment do begin
                     x:=LastObjData.x; y:=LastObjData.y; z:=LastObjData.z;
                     if ActObjData.x<-30000 then begin
                        x:=ActObjData.x; y:=ActObjData.y; z:=ActObjData.z;
                     end;
                     if x<=-30000 then begin
                        FINDTRACKOBJPOS(abs(x)-30000);

                        dx:=round((TrackedObjData.x-ActCameraData.x)*1150);
                        dy:=round((TrackedObjData.y-ActCameraData.y)*1150);

                        if (dx=0) and (dy>0) then z:=0
                        else if (dx>0) and (dy=0) then z:=-90
                        else if (dx=0) and (dy<0) then z:=-180
                        else if (dx<0) and (dy=0) then z:=90
                        else if (dy>0) and (dx>0) then z:=-round((90/(dx+dy))*dx)
                        else if (dy<0) and (dx>0) then z:=-180+round((90/(dx-dy))*dx)
                        else if (dy<0) and (dx<0) then z:=-180+round((90/(-dx-dy))*dx)
                        else if (dy>0) and (dx<0) then z:=-round((90/(-dx+dy))*dx)
                        else z:=0;
                        while z>180 do z:=z-360; while z<-180 do z:=z+360;
                        ROTATEZ(^TrackedObjData,z);

                        dy:=round((TrackedObjData.y-ActCameraData.y)*1150);
                        dz:=round((TrackedObjData.z-ActCameraData.z)*1150);
                        if (dz=0) then x:=0
                        else if (dz>0) and (dy=0) then x:=90
                        else if (dz<0) and (dy=0) then x:=-90
                        else x:=round((90/(abs(dz)+dy))*dz);
                        while x>180 do x:=x-360; while x<-180 do x:=x+360;

                     end else begin
                        if ActObjData.StartFrame=0 then ActObjData:=LastObjData;
                        if (MyFramePos in [ActObjData.StartFrame..ActObjData.EndFrame])
                        and (ActObjData.StartFrame<>ActObjData.EndFrame) then begin
                           FrameSteps:=1+ActObjData.EndFrame-ActObjData.StartFrame;
                           Factor1:=(ActObjData.EndFrame-MyFramePos)/FrameSteps;
                           Factor2:=1-Factor1;
                           if abs(z-ActObjData.z)>180 then ActObjData.z:=360+ActObjData.z;
                           if abs(y-ActObjData.y)>180 then ActObjData.y:=360+ActObjData.y;
                           if abs(x-ActObjData.x)>180 then ActObjData.x:=360+ActObjData.x;
                           x:=round(x*Factor1+ActObjData.x*Factor2);
                           y:=round(y*Factor1+ActObjData.y*Factor2);
                           z:=round(z*Factor1+ActObjData.z*Factor2);
                        end;
                     end;
                  end;
               end else if (MyObjectHeader^.Flags and OFLAG_SOUND=OFLAG_SOUND) then with ActObjData do begin
                  if StartFrame=0 then ActObjData:=LastObjData;
                  if (MyFramePos<MyObjectHeader^.StartFrame)
                  or (MyFramePos>MyObjectHeader^.EndFrame) then begin
                     x:=-32000; y:=-32000; z:=-32000;
                  end else begin
                     if (MyFramePos in [StartFrame..EndFrame])
                     and (StartFrame<>EndFrame) then begin
                        FrameSteps:=1+EndFrame-StartFrame;
                        Factor1:=(EndFrame-MyFramePos)/FrameSteps;
                        Factor2:=1-Factor1;
                        x:=round(LastObjData.x*Factor1+x*Factor2);
                        y:=round(LastObjData.y*Factor1+y*Factor2);
                        z:=round(LastObjData.z*Factor1+z*Factor2);
                     end else begin
                        x:=LastObjData.x;
                        y:=LastObjData.y;
                        z:=LastObjData.z;
                     end;

                     l:=round(((x-ActCameraData.x)/CameraSize.x)*1150);
                     if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                     x:=l;
                     l:=round(((y-ActCameraData.y)/CameraSize.y)*1150);
                     l:=l-(CameraYOffset*10);
                     if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                     y:=l;
                     l:=round(((z-ActCameraData.z)/CameraSize.z)*1150);
                     if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                     z:=l;
                     if (ActCameraAlignment.x<>0) or (ActCameraAlignment.y<>0)
                     or (ActCameraAlignment.z<>0) then ROTATE(^ActObjData,ActCameraAlignment.z,ActCameraAlignment.y,ActCameraAlignment.x);

                     x:=-x;
                     if (x in [-1700..1700]) and (y in [-1700..1700])
                     and (z in [-1700..1700]) and not Trace then begin
                        DrawDisplay:=true;
                        SetAPen(MyWindow^.RPort,MyObjectHeader^.ObjectTyp);
                        RectFill(MyWindow^.RPort,round(177-x/10),round(193-y/10),round(180-x/10),round(196-y/10)); {*** TOP ***}
                        if MyObjectHeader^.EchoVolume>0 then begin
                           Move(MyWindow^.RPort,round(180-x/10),round(196-y/10));
                           Draw(MyWindow^.RPort,236,252);
                           Move(MyWindow^.RPort,round(177-x/10),round(196-y/10));
                           Draw(MyWindow^.RPort,121,252);
                        end;
                        if y>=0 then RectFill(MyWindow^.RPort,round(68-x/27.7),round(440-z/27.7),round(69-x/27.7),round(441-z/27.7))
                        else RectFill(MyWindow^.RPort,round(204-x/27.7),round(440-z/27.7),round(205-x/27.7),round(441-z/27.7))  {*** FRONT / REAR ***}
                     end;
                  end;
                  if Trace then with MyObjectHeader^ do
                  if (CineAddr<>0) and (CineLength<CineMemL) then begin
                     MyCineData:=ptr(CineAddr+CineLength);
                     CineLength:=CineLength+sizeof(r_CineData);
                     if SyncMemA<>0 then begin
                        if MyFramePos*4<SyncMemL then begin
                           DataS:=ptr(SyncMemA+MyFramePos*4);
                           l:=DataS^;
                        end else l:=1;
                     end else l:=0;
                     MyCineData^:=r_CineData(x,y,z,1,0,MyObjectHeader^.ObjectVolume,0,l);
                     if MyFramePos>1 then begin
                        {*** KOMPRESSION mittels Steps ***}
                        MyCineData:=ptr(CineAddr+CineLength-2*sizeof(r_CineData));
                        if (MyCineData^.x=ActObjData.x) and
                           (MyCineData^.y=ActObjData.y) and
                           (MyCineData^.z=ActObjData.z) and
                           (MyCineData^.RelTime=l) then begin
                           MyCineData^.Steps:=MyCineData^.Steps+1;
                           CineLength:=CineLength-sizeof(r_CineData);
                        end;
                     end;
                  end else exit;
               end;
               if (MyObjectHeader^.Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN) then begin
                  if StartFrame=0 then ActObjData:=LastObjData;
                  if Trace then with MyObjectHeader^ do
                  if (MyFramePos in [ActObjData.StartFrame..ActObjData.EndFrame]) then begin
                     if (TimeAddr<>0) and (TimeLength<TimeMemL) then begin
                        MyTimeData:=ptr(TimeAddr+TimeLength);
                        TimeLength:=TimeLength+sizeof(r_TimeData);
                        MyTimeData^:=r_TimeData(MyFramePos,MyFramePos+1,0);
                        if TimeLength>sizeof(r_TimeData) then begin
                           {*** schrittweise Ermittlung des Timepatterns ***}
                           OldTimeData:=ptr(TimeAddr+TimeLength-2*sizeof(r_TimeData));
                           if OldTimeData^.EndTime=MyFramePos then begin
                              OldTimeData^.EndTime:=OldTimeData^.EndTime+1;
                              TimeLength:=TimeLength-sizeof(r_TimeData);
                           end;
                        end;
                     end else exit;
                  end;
               end;
            end;
         end;
         s:=intstr(MyFramePos); Buffer[6]:=s; WRITE(10,25,3,5,MyWindow^,s);
         if not Trace then begin
            WaitBlit; delay(2); WaitTOF;
         end;
      until (MyFramePos>=EndFrame) or ((Knopf[6].Flags and SELECTED=0) and not Trace);
      ActFramePos:=MyFramePos;
   end else begin
      l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
      FREEMYMEM;
      exit;
   end;
   if Trace then SAVECINEDATA;
   FREEMYMEM;
end; {*** CALCIMAGINE ***}




procedure CALCCINEDATA(Trace :boolean; StartFrame,EndFrame :long;);

type r_FrameDataHeader=record
        Flags                   :word;
        Name                    :string[20];
        Sample                  :string[200];
     end;

var MyFRDTHeader        :r_FrameDataHeader;
var MyFRDT              :r_CineData;

var PosAddr,TargetAddr,ActLength                :long;
var MyObjectHeader                              :^r_ObjectHeader;
var CineDataMemA,CineDataMemL,MyFramePos,
    FrameCtr                                    :long;
var MyCineData                                  :r_CineData;
var SourceCineData,TargetCineData               :^r_CineData;
var MyTimeData,OldTimeData                      :^r_TimeData;


procedure FREEMYMEM;

begin
   for MyObjMemPos:=1 to MaxObjects do begin
      MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
      with MyObjectHeader^ do if CineAddr<>0 then begin
         FreeVec(CineAddr);
         CineAddr:=0;
      end;
      with MyObjectHeader^ do if TimeAddr<>0 then begin
         FreeVec(TimeAddr);
         TimeAddr:=0;
      end;
   end;
   if CineDataMemA<>0 then FreeVec(CineDataMemA);
   Knopf[6].Flags:=Knopf[6].Flags and not SELECTED;
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
end;



begin
   SETVALUES;
   CineDataMemA:=0; DrawDisplay:=true;
   CineMemL:=MaxFrames*sizeof(r_CineData);
   TimeMemL:=MaxFrames*sizeof(r_TimeData)+4;
   if Trace then for MyObjMemPos:=1 to MaxObjects do begin
      MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
      with MyObjectHeader^ do if (Flags and OFLAG_SOUND=OFLAG_SOUND)
      or (Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN) then begin
         CineAddr:=AllocVec(CineMemL,0);
         CineLength:=0;
         if CineAddr=0 then begin
            l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
      end;
      with MyObjectHeader^ do if Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN then begin
         TimeAddr:=AllocVec(TimeMemL,0);
         TimeLength:=0;
         if TimeAddr=0 then begin
            l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
      end;
   end;
   CineDataMemL:=MaxFrames*MaxObjects*sizeof(r_CineData);
   CineDataMemA:=AllocVec(CineDataMemL,0);
   MyObjMemPos:=0; PosAddr:=CineDataMemA;
   if CineDataMemA<>0 then begin
      FHandle:=DosOpen(DBuffer[1],MODE_OLDFILE);
      if FHandle<>0 then begin
         l:=DosSeek(FHandle,8,OFFSET_BEGINNING);
         l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
         if s='CINM' then begin
            l:=DosSeek(FHandle,12,OFFSET_BEGINNING);
            repeat
               l:=DosRead(FHandle,^IFFCh,sizeof(r_IFFCh));
               if l>0 then begin
                  if IFFCh.Name='FRDT' then begin
                     MyObjMemPos:=MyObjMemPos+1;
                     MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
                     IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^MyFRDTHeader,sizeof(r_FrameDataHeader));
                     MyObjectHeader^.StartAddr:=PosAddr;
                     ActLength:=(IFFCh.Length div sizeof(r_CineData)) * sizeof(r_CineData);
                     l:=DosRead(FHandle,ptr(PosAddr),ActLength);
                     if Trace then begin
                        CopyMemQuick(PosAddr,MyObjectHeader^.CineAddr,ActLength);
                        MyObjectHeader^.CineLength:=ActLength;
                     end;
                     PosAddr:=PosAddr+ActLength;
                     MyObjectHeader^.EndAddr:=PosAddr;
                     IFFCh.Length:=IFFCh.Length-ActLength;
                  end else if IFFCh.Name='TIME' then begin
                     MyObjMemPos:=MyObjMemPos+1;
                     MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
                     IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^MyFRDTHeader,22);
                     if (MyObjectHeader^.TimeAddr<>0) and
                     (MyObjectHeader^.Flags and OFLAG_TIMEPATTERNONLY=OFLAG_TIMEPATTERNONLY) then begin
                        MyObjectHeader^.TimeLength:=(IFFCh.Length div sizeof(r_TimeData)) * sizeof(r_TimeData);
                        IFFCh.Length:=IFFCh.Length-DosRead(FHandle,ptr(MyObjectHeader^.TimeAddr),MyObjectHeader^.TimeLength);
                     end;
                     {*** bereits existierende und wieder zu verwendende Timepattern-Chunks
                          werden direkt in den "Time"-Speicherbereich geladen ***}
                  end;
                  if IFFCh.Length>0 then l:=DosSeek(FHandle,IFFCh.Length,OFFSET_CURRENT);
               end;
            until l=0;
         end else begin
            l:=TASKREQUEST(DBuffer[1],PText[103],'',PText[1],'');
            FREEMYMEM;
            exit;
         end;
         DosClose(FHandle);
      end else begin
         l:=TASKREQUEST(DBuffer[1],PText[93],'',PText[1],'');
         FREEMYMEM;
         exit;
      end;

      MyFramePos:=pred(StartFrame);
      repeat
         if DrawDisplay then DRAWFIELD;
         DrawDisplay:=false;
         MyFramePos:=MyFramePos+1;
         MyObjMemPos:=0;
         for MyObjMemPos:=1 to MaxObjects do begin
            MyObjectHeader:=ptr(ObjMemA+(pred(MyObjMemPos)*ObjHeaderSize));
            PosAddr:=MyObjectHeader^.StartAddr;
            TargetAddr:=MyObjectHeader^.CineAddr;
            if (PosAddr<>0) and
            ((MyObjectHeader^.Flags and OFLAG_SOUND=OFLAG_SOUND) or
             (MyObjectHeader^.Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN))
             and (MyObjectHeader^.Flags and OFLAG_TIMEPATTERNONLY=0) then begin
               FrameCtr:=0;
               repeat
                  SourceCineData:=ptr(PosAddr); PosAddr:=PosAddr+sizeof(r_CineData);
                  TargetAddr:=TargetAddr+sizeof(r_CineData);
                  FrameCtr:=FrameCtr+SourceCineData^.Steps;
               until (FrameCtr>=MyFramePos) or (PosAddr>=MyObjectHeader^.EndAddr);
               if FrameCtr>=MyFramePos then begin
                  TargetAddr:=TargetAddr-sizeof(r_CineData);
                  MyCineData:=SourceCineData^;
                  if MyCineData.x in [-31999..31999] then begin
                     with MyCineData do begin
                        l:=round(x*100/CameraSize.x);
                        if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                        x:=l;
                        l:=round(y*100/CameraSize.y);
                        l:=l-(CameraYOffset*10);
                        if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                        y:=l;
                        l:=round(z*100/CameraSize.z);
                        if l>31999 then l:=31999; if l<-31999 then l:=-31999;
                        z:=l;

                        y:=y-(CameraYOffset*10);
                        if (x in [-1700..1700]) and (y in [-1700..1700])
                        and (z in [-1700..1700]) and not Trace then begin
                           DrawDisplay:=true;
                           SetAPen(MyWindow^.RPort,MyObjectHeader^.ObjectTyp);
                           RectFill(MyWindow^.RPort,round(177-x/10),round(193-y/10),round(180-x/10),round(196-y/10)); {*** TOP ***}
                           if MyObjectHeader^.EchoVolume>0 then begin
                              Move(MyWindow^.RPort,round(180-x/10),round(196-y/10));
                              Draw(MyWindow^.RPort,236,252);
                              Move(MyWindow^.RPort,round(177-x/10),round(196-y/10));
                              Draw(MyWindow^.RPort,121,252);
                           end;
                           if y>=0 then RectFill(MyWindow^.RPort,round(68-x/27.7),round(440-z/27.7),round(69-x/27.7),round(441-z/27.7))
                           else RectFill(MyWindow^.RPort,round(204-x/27.7),round(440-z/27.7),round(205-x/27.7),round(441-z/27.7))  {*** FRONT / REAR ***}
                        end;
                     end;

                     if Trace and (MyObjectHeader^.Flags and OFLAG_SOUND=OFLAG_SOUND) then begin
                        TargetCineData:=ptr(TargetAddr);
                        TargetCineData^:=MyCineData;
                     end;
                     if Trace and (MyObjectHeader^.Flags and OFLAG_TIMEPATTERN=OFLAG_TIMEPATTERN) then
                     with MyObjectHeader^ do begin
                        if (TimeAddr<>0) and (TimeLength<TimeMemL) then begin
                           MyTimeData:=ptr(TimeAddr+TimeLength);
                           TimeLength:=TimeLength+sizeof(r_TimeData);
                           MyTimeData^:=r_TimeData(MyFramePos,MyFramePos+1,0);
                           if TimeLength>sizeof(r_TimeData) then begin
                              {*** schrittweise Ermittlung des Timepatterns ***}
                              OldTimeData:=ptr(TimeAddr+TimeLength-2*sizeof(r_TimeData));
                              if OldTimeData^.EndTime=MyFramePos then begin
                                 OldTimeData^.EndTime:=OldTimeData^.EndTime+1;
                                 TimeLength:=TimeLength-sizeof(r_TimeData);
                              end;
                           end;
                        end else exit;
                     end;
                  end;
               end;
            end;
         end;
         s:=intstr(MyFramePos); Buffer[6]:=s; WRITE(10,25,3,5,MyWindow^,s);
         if not Trace then begin
            WaitBlit; delay(2); WaitTOF;
         end;
      until (MyFramePos>=EndFrame) or ((Knopf[6].Flags and SELECTED=0) and not Trace);
      ActFramePos:=MyFramePos;
   end else begin
      l:=TASKREQUEST(PText[100],PText[101],'',PText[1],'');
      FREEMYMEM;
      exit;
   end;

{*** CineData's scannen und komprimieren!! ***}

   if Trace then SAVECINEDATA;
   FREEMYMEM;
end; {*** CALCCINEDATA ***}



begin
   case Filetyp of
      FILETYP_Imagine:  CALCIMAGINE(Trace,StartFrame,EndFrame);
      FILETYP_CineData: CALCCINEDATA(Trace,StartFrame,EndFrame);
      FILETYP_AVB:      CALCAVB(Trace,StartFrame,EndFrame);
      otherwise DisplayBeep(NIL);
   end;
end;



procedure HANDLEKNOPF;

begin
   if (Filetyp=Filetyp_IMAGINE) and (ObjMemPos=1) then begin
      Knopf[3].Flags:=Knopf[3].Flags or GADGDISABLED;
      Knopf[4].Flags:=Knopf[4].Flags or GADGDISABLED;
   end else begin
      Knopf[3].Flags:=Knopf[3].Flags and not GADGDISABLED;
      Knopf[4].Flags:=Knopf[4].Flags and not GADGDISABLED;
   end;
   if not (ActObjectHeader^.Flags and OFLAG_SOUND=0) then begin
      Knopf[4].Flags:=Knopf[4].Flags or SELECTED;
      Knopf[5].Flags:=Knopf[5].Flags and not GADGDISABLED;
      STextGad[1].Flags:=STextGad[1].Flags and not GADGDISABLED;
      STextGad[2].Flags:=STextGad[2].Flags and not GADGDISABLED;
      Knopf[8].Flags:=Knopf[8].Flags and not GADGDISABLED;
   end else begin
      Knopf[4].Flags:=Knopf[4].Flags and not SELECTED;
      Knopf[5].Flags:=Knopf[5].Flags or GADGDISABLED;
      STextGad[1].Flags:=STextGad[1].Flags or GADGDISABLED;
      STextGad[2].Flags:=STextGad[2].Flags or GADGDISABLED;
      Knopf[8].Flags:=Knopf[8].Flags or GADGDISABLED;
   end;
   if not (ActObjectHeader^.Flags and OFLAG_TIMEPATTERNONLY=0) then
    Knopf[4].Flags:=(Knopf[4].Flags or GADGDISABLED) and not SELECTED;
   if not (ActObjectHeader^.Flags and OFLAG_TIMEPATTERN=0)
    then Knopf[3].Flags:=Knopf[3].Flags or SELECTED
   else Knopf[3].Flags:=Knopf[3].Flags and not SELECTED;
   if not (ActObjectHeader^.Flags and OFLAG_SOUNDEND=0) then
    Knopf[8].Flags:=Knopf[8].Flags or SELECTED else
    Knopf[8].Flags:=Knopf[8].Flags and not SELECTED;
   if not (ActObjectHeader^.Flags and OFLAG_TIMEPATTERN=0) then
    Knopf[3].Flags:=Knopf[3].Flags or SELECTED
   else Knopf[3].Flags:=Knopf[3].Flags and not SELECTED;
   if not (ActObjectHeader^.Flags and OFLAG_HIDEOBJECT=0) then begin
      Knopf[3].Flags:=Knopf[3].Flags or GADGDISABLED;
      Knopf[4].Flags:=Knopf[4].Flags or GADGDISABLED;
   end;
   with ActObjectHeader^ do begin
      MAKEBORDER(MyWindow^,585,337,628,357,NEGATIVE);
      SetAPen(Mywindow^.RPort,ObjectTyp);
      RectFill(Mywindow^.RPort,586,338,627,356);
      if not (Flags and OFLAG_TRACKED=0) then WRITE(606,341,1,3,MyWindow^,'T');
   end;
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
end;



function CHECKSAMPLE:boolean;

var FHandle     :BPTR;

begin
   CHECKSAMPLE:=false;
   SBuffer:='';
   ActObjectHeader^.Sample:='';
   FHandle:=DosOpen(PathFR,MODE_OLDFILE);
   if FHandle<>0 then begin
      Prefs.SampleStr:=DirFR;
      l:=DosRead(FHandle,^s,8); s[5]:=chr(0);
      if s='FORM' then begin
         l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
         if (s='8SVX') or (s='16SX') or (s='24SX') or (s='HISX') then begin
            ActObjectHeader^.Sample:=PathFR;
            SBuffer:=PathFR;
            CHECKSAMPLE:=true;
         end else begin
            s:=PText[104]+' ('+s+')!';
            l:=TASKREQUEST(PathFR,s,'',PText[1],'');
         end;
      end else l:=TASKREQUEST(PathFR,PText[105],'',PText[1],'');
      DosClose(FHandle);
   end else l:=TASKREQUEST(PathFR,PText[106],'',PText[1],'');
end;



function SCANFILE(IgnoreCamera :boolean):boolean;

var CameraObj           :boolean;
var MyObjChunk          :r_ObjectChunk;
var TrackAlignments     :byte;
var TAlgnObjects        :array [1..100] of string[20];
var i                   :integer;
var FHandle             :BPTR;



function SCANAVB(IgnoreCamera :boolean):boolean;

var TextMemA,TextMemL,Addr8     :long;
var Data8                       :^byte;
var MyStr                       :str;
var ChunkName                   :string[5];
var ChunkLength                 :long;

begin
   SCANAVB:=false;
   DBuffer[1]:=PathFR;
   s:=PathFR;
   s[length(s)-3]:=chr(0);
   DBuffer[2]:=s;

   FHandle:=DosOpen(s,MODE_OLDFILE);
   if FHandle=0 then begin
      l:=TASKREQUEST(s,PText[93],'',PText[1],'');
      exit;
   end;
   l:=DosSeek(FHandle,8,OFFSET_BEGINNING);
   l:=DosRead(FHandle,^ChunkName,4);
   ChunkName[5]:=chr(0);
   if ChunkName<>'ANIM' then begin
      l:=TASKREQUEST(s,PText[95],'',PText[1],'');
      DosClose(FHandle);
      exit;
   end;
   MaxFrames:=0;
   repeat
      l:=DosRead(FHandle,^ChunkName,4);
      l:=l+DosRead(FHandle,^ChunkLength,4);
      if l=8 then begin
         MaxFrames:=MaxFrames+1;
         l:=DosSeek(FHandle,ChunkLength,OFFSET_CURRENT);
      end;
   until (l=0) or (ChunkName<>'FORM');
   DosClose(FHandle);

   s:=PathFR;
   s[length(s)-3]:=chr(0);
   s:=s+'.snd';
   FHandle:=DosOpen(s,MODE_OLDFILE);
   if FHandle=0 then begin
      l:=TASKREQUEST(s,PText[93],'',PText[1],'');
      exit;
   end;
   l:=DosSeek(FHandle,0,OFFSET_END);
   TextMemL:=DosSeek(FHandle,0,OFFSET_BEGINNING);
   TextMemA:=AllocVec(TextMemL,0);
   if TextMemA=0 then begin
      l:=TASKREQUEST(PText[100],'','',PText[1],'');
      DosClose(FHandle);
      exit;
   end;
   l:=DosRead(FHandle,ptr(TextMemA),TextMemL);
   DosClose(FHandle);

   Addr8:=TextMemA;
   MaxObjects:=0;
   repeat
      Data8:=ptr(Addr8); Addr8:=Addr8+1;
      if Data8^=10 then begin
         Data8^:=0;
         MaxObjects:=MaxObjects+1;
      end;
   until Addr8>=TextMemA+TextMemL;
   if ObjMemA=0 then CREATEGUI else FreeVec(ObjMemA);
   ObjMemL:=MaxObjects*ObjHeaderSize;
   ObjMemA:=AllocVec(ObjMemL,MEMF_CLEAR);
   if ObjMemA=0 then begin
      l:=TASKREQUEST(PText[100],'','',PText[1],'');
      exit;
   end;
   Addr8:=TextMemA;
   Data8:=ptr(Addr8);
   ObjMemPos:=0;
   repeat
      if (Data8^=0) or (Addr8=TextMemA) then begin
         if Addr8+1<TextMemA+TextMemL then begin
            ObjMemPos:=ObjMemPos+1;
            ActObjectHeader:=ptr(ObjMemA+(pred(ObjMemPos)*ObjHeaderSize));
            if Data8^=0 then MyStr:=ptr(Addr8+1) else MyStr:=ptr(Addr8);
            s:=MyStr;
            MyStr:=ptr(addr(s));
            for i:=1 to length(s) do if s[i] in [':','/'] then MyStr:=ptr(addr(s)+i);
            ActObjectHeader^:=r_ObjectHeader(OFLAG_SOUND+OFLAG_SOUNDEND,OTYP_OBJECT,
                                             100,0,0,0,0,'','',0,0,0,0,0,0,0,0);
            ActObjectHeader^.Name:=MyStr;
            if length(DirFR)>0 then
             if not (DirFR[length(DirFR)] in ['/',':']) then s:=DirFR+'/'+s else s:=DirFR+s;
            ActObjectHeader^.Sample:=s;
            WRITEOBJNAME;
         end;
      end;
      Addr8:=Addr8+1; Data8:=ptr(Addr8);
   until Addr8>=TextMemA+TextMemL;
   if not IgnoreCamera then begin
      CameraSize:=r_ObjectChunk(0,0,0,100,0,100,0,100,0,'');
      CameraYOffset:=0;
   end;
   Buffer[1]:=intstr(CameraSize.x); Buffer[2]:=intstr(CameraSize.y);
   Buffer[3]:=intstr(CameraSize.z); Buffer[4]:=intstr(CameraYOffset);
   SETVALUES;
   FreeVec(TextMemA);
   ActFramePos:=1;
   MaxObjects:=ObjMemPos;
   ObjMemPos:=1;
   WRITEOBJNAME;

   PathFR:=DBuffer[2];
   if SCANANIM then begin end;
   SCANAVB:=true;
end;



function SCANIMAGINE(IgnoreCamera :boolean):boolean;

begin
   SCANIMAGINE:=false;
   FHandle:=DosOpen(PathFR,MODE_OLDFILE);
   if FHandle=0 then exit;
   l:=DosSeek(FHandle,8,OFFSET_BEGINNING);
   l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
   if s<>'ISTG' then begin
      l:=TASKREQUEST(PathFR,PText[102],'',PText[1],'');
      DosClose(FHandle);
      exit;
   end;
   if ObjMemA=0 then CREATEGUI else FreeVec(ObjMemA);
   ObjMemA:=0; ObjMemL:=0;
   repeat
      l:=DosRead(FHandle,^IFFCh,sizeof(r_IFFCh));
      if l>0 then begin
         if IFFCh.Name='MAXF' then begin
            IFFCh.Length:=IFFCh.length-DosRead(FHandle,^MaxFrames,2);
            MaxFrames:=MaxFrames div $10000;
         end else if IFFCh.Name='SOBJ' then begin
            ObjMemL:=ObjMemL+1;
            CameraObj:=false;
            repeat
               IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^IFFCh2,sizeof(r_IFFCh));
               if IFFCh2.Name='NAME' then begin
                  IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^s,IFFCh2.Length);
                  IFFCh2.Length:=0;
                  if s='CAMERA' then CameraObj:=true;
               end else if ((IFFCh2.Name='OSIZ') or (IFFCh2.Name='OSZ2')) and CameraObj then begin
                  if not IgnoreCamera then begin
                     CameraObj:=false;
                     l:=IFFCh2.Length;
                     if l>sizeof(r_ObjectChunk) then l:=sizeof(r_ObjectChunk);
                     l:=DosRead(FHandle,^CameraSize,l);
                     CameraYOffset:=0;
                     IFFCh.Length:=IFFCh.Length-l;
                     IFFCh2.Length:=IFFCh2.Length-l;
                  end;
                  Buffer[1]:=intstr(CameraSize.x); Buffer[2]:=intstr(CameraSize.y);
                  Buffer[3]:=intstr(CameraSize.z); Buffer[4]:=intstr(CameraYOffset);
                  SETVALUES;
               end;
               if IFFCh2.Length>0 then begin
                  l:=DosSeek(FHandle,IFFCh2.Length,OFFSET_CURRENT);
                  IFFCh.Length:=IFFCh.Length-IFFCh2.Length
               end;
            until IFFCh.Length<=0;
         end;
         if IFFCh.Length>0 then l:=DosSeek(FHandle,IFFCh.Length,OFFSET_CURRENT);
      end;
   until l=0;
   DBuffer[1]:=PathFR;
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
   ObjMemL:=ObjMemL*ObjHeaderSize;
   ObjMemA:=AllocVec(ObjMemL,MEMF_CLEAR);
   if ObjMemA=0 then begin
      l:=TASKREQUEST(PText[100],'','',PText[1],'');
      exit;
   end;
   ObjMemPos:=0; MaxPositions:=0; MaxAlignments:=0; TrackAlignments:=0;
   l:=DosSeek(FHandle,12,OFFSET_BEGINNING);
   repeat
      l:=DosRead(FHandle,^IFFCh,sizeof(r_IFFCh));
      if l>0 then begin
         if IFFCh.Name='SOBJ' then begin
            repeat
               IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^IFFCh2,sizeof(r_IFFCh));
               if IFFCh2.Name='NAME' then begin
                  IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^s,IFFCh2.Length);
                  IFFCh2.Length:=0;
                  if s<>'GLOBALS' then begin
                     ObjMemPos:=ObjMemPos+1;
                     ActObjectHeader:=ptr(ObjMemA+(pred(ObjMemPos)*ObjHeaderSize));
                     ActObjectHeader^:=r_ObjectHeader(0,0,100,0,0,0,0,s,'',0,0,0,0,0,0,0,0);
                     if TrackAlignments>0 then for i:=1 to TrackAlignments do
                      if s=TAlgnObjects[i] then ActObjectHeader^.Flags:=ActObjectHeader^.Flags or OFLAG_TRACKED;
                     WRITEOBJNAME;
                  end;
               end else if (IFFCh2.Name='FILE') or (IFFCh2.Name='FIL2')
               or (IFFCh2.Name='FIL3') or (IFFCh2.Name='AXIS')
               or (IFFCh2.Name='LITE') or (IFFCh2.Name='LIT2') then begin
                  if (IFFCh2.Name='FILE') or (IFFCh2.Name='FIL2')
                   or (IFFCh2.Name='FIL3') then ActObjectHeader^.ObjectTyp:=OTYP_OBJECT;
                  if IFFCh2.Name='AXIS' then ActObjectHeader^.ObjectTyp:=OTYP_AXIS;
                  if (IFFCh2.Name='LITE') or (IFFCh2.Name='LIT2') then ActObjectHeader^.ObjectTyp:=OTYP_LIGHT;
                  l:=DosRead(FHandle,^MyObjChunk,6);
                  IFFCh.Length:=IFFCh.Length-6;
                  IFFCh2.Length:=IFFCh2.Length-6;
                  ActObjectHeader^.StartFrame:=MyObjChunk.StartFrame;
                  ActObjectHeader^.EndFrame:=MyObjChunk.EndFrame;
               end else if (IFFCh2.Name='POSN') or (IFFCh2.Name='POS2')
               then MaxPositions:=MaxPositions+1
               else if ((IFFCh2.Name='ALGN') or (IFFCh2.Name='ALN2')) and (s='CAMERA') then MaxAlignments:=MaxAlignments+1
               else if (IFFCh2.Name='TALN') and (s='CAMERA') then begin
                  MaxAlignments:=MaxAlignments+1;
                  TrackAlignments:=TrackAlignments+1;
                  l:=DosSeek(FHandle,15,OFFSET_CURRENT);
                  l:=15+DosRead(FHandle,^TAlgnObjects[TrackAlignments],IFFCh2.Length-15);
                  IFFCh2.Length:=0;
                  IFFCh.Length:=IffCh.Length-l;
               end;
               if IFFCh2.Length>0 then begin
                  l:=DosSeek(FHandle,IFFCh2.Length,OFFSET_CURRENT);
                  IFFCh.Length:=IFFCh.Length-IFFCh2.Length
               end;
            until IFFCh.Length<=0;
         end;
         if IFFCh.Length>0 then l:=DosSeek(FHandle,IFFCh.Length,OFFSET_CURRENT);
      end;
   until l=0;
   ActFramePos:=1;
   MaxObjects:=ObjMemPos;
   ObjMemPos:=1;
   WRITEOBJNAME;
   DosClose(FHandle);
   SCANIMAGINE:=true;
end;



function SCANCINEDATA(IgnoreCamera :boolean):boolean;

type r_CineDataFileHeader=record;
        Frames                  :long;
        FPS,pad                 :byte;
        Threshold               :integer;
        Reserved1,reserved2     :long;
     end;
type r_FrameDataHeader=record
        Flags                   :word;
        Name                    :string[20];
        Sample                  :string[200];
     end;

var MyCNHD                                      :r_CineDataFileHeader;
var MyFRDTHeader                                :r_FrameDataHeader;
var MyFRDT                                      :r_CineData;


procedure SCANOBJECTS;

var i,j                 :long;
var MyObjectHeader      :^r_ObjectHeader;

begin
   for i:=1 to MaxObjects do begin
      ActObjectHeader:=ptr(ObjMemA+(pred(i)*ObjHeaderSize));
      for j:=1 to MaxObjects do if i<>j then begin
         MyObjectHeader:=ptr(ObjMemA+(pred(j)*ObjHeaderSize));
         if (ActObjectHeader^.Name=MyObjectHeader^.Name) and
         (MyObjectHeader^.Flags and OFLAG_TIMEPATTERNONLY=OFLAG_TIMEPATTERNONLY) and
         (ActObjectHeader^.Flags and OFLAG_SOUND=OFLAG_SOUND) then begin
            ActObjectHeader^.Flags:=ActObjectHeader^.Flags or OFLAG_TIMEPATTERN;
            MyObjectHeader^.Flags:=OFLAG_HIDEOBJECT;
         end;
      end;
   end;
end;


begin
   SCANCINEDATA:=false;
   FHandle:=DosOpen(PathFR,MODE_OLDFILE);
   if FHandle=0 then exit;
   l:=DosSeek(FHandle,8,OFFSET_BEGINNING);
   l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
   if s<>'CINM' then begin
      l:=TASKREQUEST(PathFR,PText[103],'',PText[1],'');
      DosClose(FHandle);
      exit;
   end;
   if ObjMemA=0 then CREATEGUI else FreeVec(ObjMemA);
   ObjMemL:=0;
   repeat
      l:=DosRead(FHandle,^IFFCh,sizeof(r_IFFCh));
      if l>0 then begin
         if IFFCh.Name='CNHD' then begin
            IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^MyCNHD,sizeof(r_CineDataFileHeader));
            ChunkCNHD.Frames:=MyCNHD.Frames;
            ChunkCNHD.FPS:=MyCNHD.FPS;
            MaxFrames:=MyCNHD.Frames;
            ActFramePos:=1;
            if not IgnoreCamera then begin
               l:=round(MyCNHD.Threshold/11.5);
               CameraSize.x:=l; CameraSize.y:=l;
               CameraSize.z:=l; CameraYOffset:=0;
            end;
            Buffer[1]:=intstr(CameraSize.x); Buffer[2]:=intstr(CameraSize.y);
            Buffer[3]:=intstr(CameraSize.z); Buffer[4]:=intstr(CameraYOffset);
            SETVALUES;
         end else if (IFFCh.Name='FRDT') or (IFFCh.Name='TIME') then ObjMemL:=ObjMemL+1;
         if IFFCh.Length>0 then l:=DosSeek(FHandle,IFFCh.Length,OFFSET_CURRENT);
      end;
   until l=0;
   DBuffer[1]:=PathFR;
   RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
   ObjMemL:=ObjMemL*ObjHeaderSize;
   ObjMemA:=AllocVec(ObjMemL,MEMF_CLEAR);
   if ObjMemA=0 then begin
      l:=TASKREQUEST(PText[100],'','',PText[1],'');
      exit;
   end;
   ObjMemPos:=0; MaxPositions:=0; MaxAlignments:=0; TrackAlignments:=0;
   l:=DosSeek(FHandle,12,OFFSET_BEGINNING);
   repeat
      l:=DosRead(FHandle,^IFFCh,sizeof(r_IFFCh));
      if l>0 then begin
         if IFFCh.Name='FRDT' then begin
            IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^MyFRDTHeader,sizeof(r_FrameDataHeader));
            l:=DosRead(FHandle,^MyFRDT,sizeof(r_CineData));
            l:=DosSeek(FHandle,-l,OFFSET_CURRENT);
            ObjMemPos:=ObjMemPos+1;
            ActObjectHeader:=ptr(ObjMemA+(pred(ObjMemPos)*ObjHeaderSize));
            ActObjectHeader^:=r_ObjectHeader(MyFRDTHeader.Flags and (OFLAG_SOUND or OFLAG_SOUNDEND),
                              OTYP_OBJECT,MyFRDT.Volume,0,0,0,0,MyFRDTHeader.Name,
                              MyFRDTHeader.Sample,0,MyCNHD.Frames,0,0,0,0,0,0);
         end else if IFFCh.Name='TIME' then begin
            IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^MyFRDTHeader,22);
            ObjMemPos:=ObjMemPos+1;
            ActObjectHeader:=ptr(ObjMemA+(pred(ObjMemPos)*ObjHeaderSize));
            ActObjectHeader^:=r_ObjectHeader(OFLAG_TIMEPATTERNONLY or OFLAG_TIMEPATTERN,
                              OTYP_OBJECT,0,0,0,0,0,MyFRDTHeader.Name,'',0,
                              MyCNHD.Frames,0,0,0,0,0,0);
         end;
         if IFFCh.Length>0 then l:=DosSeek(FHandle,IFFCh.Length,OFFSET_CURRENT);
      end;
   until l=0;
   MaxObjects:=ObjMemPos;
   SCANOBJECTS;
   ObjMemPos:=1;
   WRITEOBJNAME;
   DosClose(FHandle);
   SCANCINEDATA:=true;
end;



begin
   SCANFILE:=false;
   FHandle:=DosOpen(PathFR,MODE_OLDFILE);
   if FHandle=0 then begin
      l:=TASKREQUEST(PathFR,PText[93],'',PText[1],'');
      exit;
   end;
   l:=DosSeek(FHandle,8,OFFSET_BEGINNING);
   l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
   DosClose(FHandle);
   FileTyp:=0;
   if s='ISTG' then FileTyp:=FILETYP_Imagine
   else if s='CINM' then FileTyp:=FILETYP_CineData
   else if s='MC4D' then FileTyp:=FILETYP_MaxonCinema4d
   else if s='FRAY' then FileTyp:=FILETYP_FastRay
   else if s='REAL' then FileTyp:=FILETYP_Real3D
   else if s='REFL' then FileTyp:=FILETYP_Reflections
   else begin
      s:=copy(PathFR,length(PathFR)-3,4);
      if s='.trk' then begin
         if not IgnoreCamera then l:=TASKREQUEST(PText[107],PText[108],PText[1],'',PText[2]);
         if IgnoreCamera or (l=1) then FileTyp:=FILETYP_AVB else FileTyp:=0;
      end;
   end;
   if FileTyp=0 then begin
      l:=TASKREQUEST(PathFR,PText[109],'',PText[1],'');
      exit;
   end;
   case FileTyp of
      FILETYP_Imagine:       SCANFILE:=SCANIMAGINE(IgnoreCamera);
      FILETYP_CineData:      SCANFILE:=SCANCINEDATA(IgnoreCamera);
      FILETYP_MaxonCinema4D: l:=TASKREQUEST('Maxon Cinema4D',PText[110],'',PText[1],'');
      FILETYP_FastRay:       l:=TASKREQUEST('FastRay',PText[110],'',PText[1],'');
      FILETYP_Real3D:        l:=TASKREQUEST('Real 3D',PText[110],'',PText[1],'');
      FILETYP_Reflections:   l:=TASKREQUEST('Reflections',PText[110],'',PText[1],'');
      FILETYP_AVB:           SCANFILE:=SCANAVB(IgnoreCamera);
      otherwise DisplayBeep(NIL);
   end;
end;



function LOADCTDF:boolean;

var FHandle,FHandle2            :BPTR;
var CheckObjMemA,CheckObjMemL   :long;
var CTDFObjHeader,DataObjHeader :^r_ObjectHeader;
var i,Addr1                     :long;

begin
   LOADCTDF:=false;
   CheckObjMemA:=0;
   FHandle:=DosOpen(CTDFPath,MODE_OLDFILE);
   if FHandle<>0 then begin
      l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
      if s='CTDF' then begin
         l:=DosRead(FHandle,^s,200);
         FHandle2:=DosOpen(s,MODE_OLDFILE);
         if FHandle2<>0 then begin
            DosClose(FHandle2);
            DBuffer[1]:=s;
            for i:=2 to 3 do l:=DosRead(FHandle,^DBuffer[i],200);
            l:=DosRead(FHandle,^ChunkCNHD.FPS,1);
            l:=DosRead(FHandle,^MaxObjects,4);
            l:=DosRead(FHandle,^MaxFrames,4);
            l:=DosRead(FHandle,^MaxPositions,4);
            l:=DosRead(FHandle,^MaxAlignments,4);
            l:=DosRead(FHandle,^CameraSize,sizeof(r_ObjectChunk));
            l:=DosRead(FHandle,^CameraYOffset,2);
            CheckObjMemL:=MaxObjects*ObjHeaderSize;
            CheckObjMemA:=AllocVec(CheckObjMemL,0);
            if CheckObjMemA<>0 then begin
               l:=DosRead(FHandle,ptr(CheckObjMemA),CheckObjMemL);
               ObjMemPos:=1;
            end else l:=TASKREQUEST(PText[100],'','',PText[1],'');
         end else l:=TASKREQUEST(s,PText[93],'',PText[1],'');
      end else l:=TASKREQUEST(PText[111],PText[94],'',PText[1],'');
      PathFR:=DBuffer[1];
      if not SCANFILE(true) then begin
         DosClose(FHandle);
         exit;
      end;
      for i:=1 to MaxObjects do begin
         DataObjHeader:=ptr(ObjMemA+pred(i)*ObjHeaderSize);
         Addr1:=CheckObjMemA;
         repeat
            CTDFObjHeader:=ptr(Addr1); Addr1:=Addr1+ObjHeaderSize;
            if (CTDFObjHeader^.Name=DataObjHeader^.Name)
            and (CTDFObjHeader^.Flags<>OFLAG_HIDEOBJECT)
            and (DataObjHeader^.Flags<>OFLAG_HIDEOBJECT) then
             DataObjHeader^:=CTDFObjHeader^;
         until Addr1>=CheckObjMemA+CheckObjMemL;
      end;
      l:=DosSeek(FHandle,4,OFFSET_BEGINNING);
      for i:=1 to 3 do l:=DosRead(FHandle,^DBuffer[i],200);
      l:=DosRead(FHandle,^ChunkCNHD.FPS,1);
      l:=DosSeek(FHandle,16,OFFSET_CURRENT);
      l:=DosSeek(FHandle,sizeof(r_ObjectChunk),OFFSET_CURRENT);
      l:=DosRead(FHandle,^CameraYOffset,2);
      DosClose(FHandle);
      WRITEOBJNAME;
      Buffer[1]:=intstr(CameraSize.x); Buffer[2]:=intstr(CameraSize.y);
      Buffer[3]:=intstr(CameraSize.z); Buffer[4]:=intstr(CameraYOffset);
      PathFR:=DBuffer[2];
      if SCANANIM then begin end;
   end else l:=TASKREQUEST(CTDFPath,PText[93],'',PText[1],'');
   if CheckObjMemA<>0 then FreeVec(CheckObjMemA);
   LOADCTDF:=true;
end;



procedure INITVARS;

var l           :long;
var FHandle     :BPTR;

begin   {*** INITVARS ***}
   MyScreen:=NIL;
   FRShow:=''; PathFR:='';    DirFR:=''; FileFR:='';
   CTDFPath:='DATA/';
   ObjMemA:=0; SyncMemA:=0; MyScreen:=NIL; ActFramePos:=1;
   KnobMem:=0; CalcMem:=0;  Filetyp:=0;    CameraYOffset:=0;
   TextMemA:=0;
   GUI:=false;
   for i:=1 to 6 do begin
      GMem[i]:=0;   ButtonMem[i]:=0;
   end;
   ChunkCNHD:=r_CineDataFileHeader('C','N','H','D',sizeof(r_CineDataFileHeader)-8,
                                 1,20,0,1150,0,0);
   Prefs:=r_Prefs($A9004,640,512,'deutsch','SAMPLES');
   FHandle:=DosOpen(PREFFILE,MODE_OLDFILE);
   if FHandle<>0 then begin
      l:=DosRead(FHandle,^Prefs,sizeof(r_Prefs));
      DosClose(FHandle);
   end;

   for i:=1 to 3 do begin
      DBuffer[i]:='';   DUndoBuffer[i]:='';
   end;
   Buffer[1]:='320'; Buffer[2]:='640'; Buffer[3]:='233'; Buffer[4]:='0';
   Buffer[5]:='100'; Buffer[8]:='0';
   SBuffer:='';
end;



procedure CINETRACER;   {****** MAIN ******}
begin
   ObjHeaderSize:=sizeof(r_ObjectHeader);
   INITVARS;
   if not INITLANG then exit;
   if not INITIMG then exit;
   if not OPENCTSCREEN then exit;
   repeat
      GadCode:=0; RawCode:=0; Men:=0; MenItem:=0;
      IMsg:=Wait_Port(MyWindow^.UserPort);
      if IMsg<>NIL then begin
         IMsg:=Get_Msg(MyWindow^.UserPort);
         if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
            XGadget:=IMsg^.IAddress;
            GadCode:=XGadget^.GadgetID;
         end else if IMsg^.class=MENUPICK then begin
            Men:=(IMsg^.Code and $1F)+1;
            MenItem:=((IMsg^.Code and $7E0) div 32)+1;
         end else if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
         Reply_Msg(IMsg)
      end;

      if GadCode=1 then begin
         PathFR:=DBuffer[1]; DirFR:=''; FileFR:=''; FRShow:='';
         FRTit:=PText[123];
         if FILEREQ then if SCANFILE(false) then begin
            WRITEOBJNAME;
            HANDLEKNOPF;
            CALCFILE(false,ActFramePos,ActFramePos);
            if DBuffer[2]<>'' then begin
               PathFR:=DBuffer[2];
               if SCANANIM then begin end;
            end;
         end;
      end;
      if GadCode=101 then begin
         PathFR:=DBuffer[1];
         if SCANFILE(false) then begin
            WRITEOBJNAME;
            HANDLEKNOPF;
            CALCFILE(false,ActFramePos,ActFramePos);
            if DBuffer[2]<>'' then begin
               PathFR:=DBuffer[2];
               if SCANANIM then begin end;
            end;
         end;
      end;
      if GadCode=2 then begin
         PathFR:=DBuffer[2]; DirFR:=''; FileFR:=''; FRShow:='';
         FRTit:=PText[124];
         if FILEREQ then if SCANANIM then DBuffer[2]:=PathFR;
         RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
      end;
      if GadCode=102 then begin
         PathFR:=DBuffer[2];
         if not SCANANIM then DBuffer[2]:='';
         RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
      end;
      if GadCode=3 then begin
         PathFR:=DBuffer[3]; DirFR:='SAMPLES'; FileFR:=''; FRShow:='';
         FRTit:=PText[125];
         if FILEREQ then Knopf[7].Flags:=Knopf[7].Flags and not GADGDISABLED;
         DBuffer[3]:=PathFR;
         RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
      end;
      if Gadcode=103 then begin
         Knopf[7].Flags:=Knopf[7].Flags and not GADGDISABLED;
         RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
      end;

      if ObjMemA<>0 then begin
         if GadCode in [11..14] then begin
            SETVALUES;
            CALCFILE(false,ActFramePos,ActFramePos);
         end else if GadCode=15 then begin
            PathFR:=SBuffer;
            if not CHECKSAMPLE then ActObjectHeader^.Flags:=ActObjectHeader^.Flags and not OFLAG_SOUND;
            HANDLEKNOPF;
            CALCFILE(false,ActFramePos,ActFramePos);
         end else if (Gadcode=21) and (ObjMemPos>1) then begin
            ObjMemPos:=ObjMemPos-1;
            WRITEOBJNAME;
            HANDLEKNOPF
         end else if (GadCode=22) and (ObjMemPos<MaxObjects) then begin
            ObjMemPos:=ObjMemPos+1;
            WRITEOBJNAME;
            HANDLEKNOPF;
         end else if GadCode=23 then begin
            ActObjectHeader^.Flags:=ActObjectHeader^.Flags xor OFLAG_TIMEPATTERN;
            HANDLEKNOPF;
         end else if GadCode=24 then begin
            ActObjectHeader^.Flags:=ActObjectHeader^.Flags xor OFLAG_SOUND;
            if (ActObjectHeader^.Flags and OFLAG_SOUND=0) then HANDLEKNOPF else GadCode:=25;
         end;
         if GadCode=25 then begin
            PathFR:=SBuffer; DirFR:=Prefs.SampleStr; FRShow:=''; FileFR:='';
            FRTit:=PText[126];
            if FILEREQ then if not CHECKSAMPLE
             then ActObjectHeader^.Flags:=ActObjectHeader^.Flags and not OFLAG_SOUND;
            HANDLEKNOPF;
            CALCFILE(false,ActFramePos,ActFramePos);
         end;
         if GadCode=26 then begin
            val(Buffer[5],l,i);
            if l<0 then l:=0; if l>200 then l:=200;
            ActObjectHeader^.ObjectVolume:=l;
            Buffer[5]:=intstr(ActObjectHeader^.ObjectVolume);
            RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
         end;
         if GadCode=27 then begin
            val(Buffer[8],l,i);
            if l<0 then l:=0; if l>200 then l:=200;
            ActObjectHeader^.EchoVolume:=l;
            Buffer[8]:=intstr(ActObjectHeader^.EchoVolume);
            RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
         end;
         if GadCode=28 then ActObjectHeader^.Flags:=(ActObjectHeader^.Flags xor OFLAG_SOUNDEND);

         if (GadCode=36) and not (Knopf[6].Flags and SELECTED=0)
          then CALCFILE(false,1,MaxFrames);
         if GadCode=37 then CALCFILE(true,1,MaxFrames);

         if Gadcode in [40..46] then begin
            if GadCode=40 then ActFramePos:=1
            else if GadCode=41 then ActFramePos:=ActFramePos-10
            else if GadCode=42 then ActFramePos:=ActFramePos-1
            else if GadCode=43 then ActFramePos:=ActFramePos+1
            else if GadCode=44 then ActFramePos:=ActFramePos+10
            else if GadCode=45 then ActFramePos:=MaxFrames
            else if GadCode=46 then val(Buffer[6],ActFramePos,i);
            if ActFramePos<1 then ActFramePos:=1;
            if ActFramePos>MaxFrames then ActFramePos:=MaxFrames;
            CALCFILE(false,ActFramePos,ActFramePos);
         end;
         if GadCode=47 then begin
            val(Buffer[7],l,i);
            if l<1 then l:=1 else if l>100 then l:=100;
            Buffer[7]:=intstr(l); ChunkCNHD.FPS:=l;
            RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
         end;
      end;
      if Men=1 then begin
         if MenItem=1 then begin
            PathFR:=CTDFPath; FRShow:='#?.ct'; FileFR:='';
            FRTit:=PText[127];
            if FILEREQ then begin
               CTDFPath:=PathFR;
               if LOADCTDF then begin
                  if DBuffer[3]<>'' then Knopf[7].Flags:=Knopf[7].Flags and not GADGDISABLED
                  else Knopf[7].Flags:=Knopf[7].Flags or GADGDISABLED;
                  HANDLEKNOPF;
                  CALCFILE(false,ActFramePos,ActFramePos);
                  SETVALUES;
               end;
            end;
         end else if MenItem=2 then begin
            if ObjMemA<>0 then begin
               PathFR:=CTDFPath; FRShow:='#?.ct'; FileFR:='';
               FRTit:=PText[128];
               if FILEREQ then begin
                  CTDFPath:=PathFR;
                  with CameraSize do begin
                     val(Buffer[1],l,i); if l<10 then l:=10; if l>32000 then l:=32000; x:=l;
                     val(Buffer[2],l,i); if l<10 then l:=10; if l>32000 then l:=32000; y:=l;
                     val(Buffer[3],l,i); if l<10 then l:=10; if l>32000 then l:=32000; z:=l;
                     val(Buffer[4],l,i);       if l<-32000 then l:=-32000;
                     if l>32000 then l:=32000; CameraYOffset:=l;
                     SETVALUES;
                  end;
                  if copy(PathFR,length(PathFR)-2,3)<>'.ct' then PathFR:=PathFR+'.ct';
                  FHandle:=DosOpen(PathFR,MODE_NEWFILE);
                  if FHandle<>0 then begin
                     s:='CTDF';   l:=DosWrite(FHandle,^s,4);
                     for i:=1 to 3 do l:=DosWrite(FHandle,^DBuffer[i],200);
                     l:=DosWrite(FHandle,^ChunkCNHD.FPS,1);
                     l:=DosWrite(FHandle,^MaxObjects,4);
                     l:=DosWrite(FHandle,^MaxFrames,4);
                     l:=DosWrite(FHandle,^MaxPositions,4);
                     l:=DosWrite(FHandle,^MaxAlignments,4);
                     l:=DosWrite(FHandle,^CameraSize,sizeof(r_ObjectChunk));
                     l:=DosWrite(FHandle,^CameraYOffset,2);
                     l:=DosWrite(FHandle,ptr(ObjMemA),ObjMemL);
                     DosClose(FHandle);
                  end else l:=TASKREQUEST(PathFR,PText[99],'',PText[1],'');
               end;
            end else l:=TASKREQUEST(PText[112],'','',PText[1],'');
         end else if MenItem=3 then begin
            s:=CTVersion+', Version 1.2';
            l:=TASKREQUEST(s,' 1997-1999 by Virtual Worlds Productions & OXYGENIC',PText[129],'',PText[2]);
            if l=1 then l:=TASKREQUEST('Imagine-Stages(V1.1-V4.0), AVB-Trackfiles and CineData-Files',
                                       'are supported by this version','',PText[1],'');
         end else if MenItem=4 then repeat until not SETPREFS;
      end;

   until (Men=1) and (MenItem=5);
   FHandle:=DosOpen(PREFFILE,MODE_NEWFILE);
   if FHandle<>0 then begin
      l:=DosWrite(FHandle,^Prefs,sizeof(r_Prefs));
      DosClose(FHandle);
   end;
   process_ptr^.pr_WindowPtr:=OldWindow_Ptr;
End;



begin
   OpenLib(DiskfontBase,'diskfont.library',0);
   CustomTA:=TextAttr('times.font',13,0,0);
   CustomFont:=OpenDiskFont(^CustomTA);
   if CustomFont=NIL then begin
      ERRORMSG('times.font 13 wird bentigt!','times.font 13 is needed!');
      error('');
   end;
   CloseLib(DiskfontBase);

   OpenLib(IntBase,'intuition.library',36);
   OpenLib(GfxBase,'graphics.library',36);
   OpenLib(DosBase,'dos.library',36);
   OpenLib(RTBase,'reqtools.library',0);
   MyFReq:=rtAllocRequestA(RT_FILEREQ,NIL);
   if MyFReq<>NIL then begin
      CINETRACER;
      GAMEEXIT;
      rtFreeRequest(MyFReq)
   end;
   CloseLib(RTBase);
   CloseLib(DosBase);
   CloseLib(IntBase);
   CloseLib(GfxBase);
end.


