program CD_Audio;

{ FX:
  $1 - Pitch Shift up      $2 - Pitch Shift down
  $9 - Set Secondary Tempo $C - Set Instr-Volume }

const PREFIX='dh3:';

{$incl "libraries/dos.h","exec/memory.h"}

type MMDHeader=^r_MMDHeader;
type r_MMDHeader=record;
        mmd_id                  :string[4];   { 0 - MMD0 }
        mmd_modlen              :long;        { Gesamtlnge }
        mmd_songinfo            :long;        { Offset Instr-Data & msng_Songinfo }
        mmd_songlen             :long;        { --- }
        mmd_blockarr            :long;        { Offset Blockadressen }
        mmd_blockarrlen         :long;        { --- }
        mmd_smplarr             :long;        { Offset Sampleadressen }
        mmd_smplarrlen          :long;        { --- }
        mmd_expdata             :long;        { Offset ExpAdressen}
        mmd_expsize             :long         { --- }
        mmd_pstate              :long;
        mmd_pblock              :word;
        mmd_pline               :word;
        mmd_pseqnum             :word;
        mmd_actplayline         :word;
        mmd_counter             :word;
        mmd_songsleft           :byte;        { 52 }
     end;
type ExpAddr=^r_ExpAddr;
type r_ExpAddr=record
        pad,pad1,pad2           :long;
        TitleAddr               :long;
        pad3,TStrSize           :word;
        InstrNames              :long;
        StrNum,IStrSize         :word;
     end;
type InstrData=^r_InstrData;                  { 63x Instrumenten-Daten }
type r_InstrData=record;
        inst_repeat             :word;
        inst_replen             :word;
        inst_midich             :byte;
        inst_midipreset         :byte;
        inst_svol               :byte;
        inst_strans             :byte;
     end;
type MSNGHeader=^r_MSNGHeader;
type r_MSNGHeader=record;
        msng_numblocks          :word;       { 504 Anzahl untersch. Blocks }
        msng_songlen            :word;       { Anzahl Blocks fr Song }
        msng_playseq            :array [1..256] of byte;
        msng_deftempo           :word;       { Tempo / Tempo2 }
        msng_playtransp         :byte;
        msng_flags              :byte;
        msng_reserved           :byte;
        msng_tempo2             :byte;       { Tempo / Tempo2 }
        msng_trkvol             :array [1..16] of byte; { Volume Tracks }
        msng_mastervol          :byte;       { Master-Volume }
        msng_numsamples         :byte;       { 788 }
   end;
type BlockSize=^r_BlockSize;
type r_BlockSize=record;
        bs_Channels,bs_Steps    :byte;
     end;

type WArr48=array[1..48] of long;
type StrArr48=array[1..48] of string[4];
type NoteArr=record;
        na_Freq                 :WArr48;
        na_Name                 :StrArr48;
     end;


var FHandle                                     :BPTR;
var ChHandle                                    :array [0..8] of BPTR;
var ChMemA,Addr,ChannelFreq                     :array [0..8] of long;
var Data                                        :array [0..8] of ^long;
var ChannelPitch                                :array [0..8] of integer;
var ChannelVolume                               :array [0..8] of integer;
var Stepsize,ChMemL,SongEnd                     :long;
var Steps,StepSteps,AddrOffset,Factor1,Factor2  :real;
var l,i,j,LastPos,Step,Chn,LoadSize             :long;
var ModMemA,ModMemL,SMemA,SMemL                 :long;
var MyMMDHeader                                 :MMDHeader;
var MyInstrData                                 :array [1..63] of InstrData;
var MyMSNGHeader                                :MSNGHeader;
var MyBlockSize                                 :BlockSize;
var SampleAddr,SampleLength                     :array [1..63] of long;
var SampleName                                  :array [1..63] of string;
var BlockAddr                                   :array [0..256] of long;
var MyExpAddr                                   :ExpAddr;
var TitleStr                                    :str;
var InstrStr                                    :array [1..63] of str;
var Data81,Data82                               :^short;
var Addr1,Addr2,CalcSize                        :long;
var Data1,Data2                                 :^long;
var Note,SmpNum,FXType,FXValue                  :long;
var MyNoteArr                                   :NoteArr;
var s,s1                                        :string;
var fast                                        :boolean;



function SWAPUNITS(Unit1 :real):real;

begin
   Unit1:=10000000/(Unit1*2.79365);
   if Unit1<1 then Unit1:=1;
   if Unit1>65535 then Unit1:=65535;
   SWAPUNITS:=Unit1;
end;



procedure WRITEZERO(Chn,StepSize :long);

var l   :long;

{*** Optimieren, wenn zuvor schon 0 geschrieben wurde !!! ***}

begin
   Addr1:=SMemA;
   repeat
      Data1:=ptr(Addr1); Addr1:=Addr1+4;
      Data1^:=0;
   until (Addr1>=SMemA+StepSize) or (Addr1>SMemA+SMemL);
   l:=DosWrite(ChHandle[Chn],ptr(SMemA),Addr1-SMemA);
end;



procedure DONOTE(SongPos,MyStep,MyChn,CalcSize :long);

var i,Step,Chn                  :word;
var MyStepsize,l,m              :long;
var Note,SmpNum,FXType,FXValue  :long;
var SavePos,SaveSize,MyRealPos,
    DataLength                  :long;
var DoZero                      :boolean;
var StepMemA,StepMemL,MyTempo2  :long;
var MySteps                     :real;


begin
   MyStepSize:=StepSize;
   SavePos:=0;
   StepMemA:=0;
   MyTempo2:=MyMsngHeader^.msng_tempo2;
   with MyMSNGHeader^ do for i:=SongPos to SongEnd do begin
      MyBlockSize:=ptr(ModMemA+BlockAddr[msng_playseq[i]]);
      with MyBlockSize^ do for Step:=MyStep to bs_Steps do begin
         for Chn:=1 to bs_Channels do begin
            Data1:=ptr(ModMemA+BlockAddr[msng_playseq[i]]+1+pred(Chn)*3+Step*bs_Channels*3);
{*** Tempo- und Sprung-FX von allen Kanlen berwachen !!! ***}
            FXType:=(Data1^ and $F00) div $100;
            FXValue:=(Data1^ and $7F);
            if FXType=$9 then begin {*** SET SECONDARY TEMPO ***}
               MyTempo2:=FXValue;
               MyStepSize:=round(MyMsngHeader^.msng_deftempo*0.00075*44100*MyTempo2)*4;
            end;
            if Chn=MyChn then begin
               l:=(Data1^ and $C00000) div $80000;
               l:=l+(Data1^ and $00F000) div $1000;
               if l<>0 then begin
                  SmpNum:=l;
                  if (Step<>MyStep) or (i<>SongPos) then exit;
               end;
               Note:=3+((Data1^ and $3F0000) div $10000);
               if ((l=0) or not (Note in [4..48])) and (Step=MyStep) and (i=SongPos) then exit;
               if (Note in [4..48]) and (SmpNum>0) and (SampleAddr[SmpNum]>0) then begin
                  if Fast then repeat
                     Data1:=ptr(Addr1);                    Addr1:=Addr1+4;
                     Data81:=ptr(Addr2+round(AddrOffset)); AddrOffset:=AddrOffset+Steps;
                     if MyInstrData[SmpNum]^.inst_svol<>64 then
                     Data1^:=round((Data81^*65535)/64*MyInstrData[SmpNum]^.inst_svol)
                     else Data1^:=Data81^*65535;
                  until (Addr1>=SMemA+SMemL) or (AddrOffset>=SampleLength[SmpNum])
                  or (Addr1>SMemA+CalcSize)
                  else repeat
                     Data1:=ptr(Addr1);   Addr1:=Addr1+4;
                     Data81:=ptr(Addr2+round(AddrOffset-0.5));
                     Data82:=ptr(Addr2+round(AddrOffset+0.5));
                     Factor2:=AddrOffset-round(AddrOffset-0.5);
                     AddrOffset:=AddrOffset+Steps;
                     Factor1:=1-Factor2;
                     Data1^:=round(Data81^*65535*Factor1)+round(Data82^*65535*Factor2);
                     if MyInstrData[SmpNum]^.inst_svol<>64 then
                     Data1^:=round(Data1^/64*MyInstrData[SmpNum]^.inst_svol)
                  until (Addr1>=SMemA+SMemL) or (AddrOffset>=SampleLength[SmpNum])
                  or (Addr1>SMemA+CalcSize);
                  DataLength:=Addr1-SMemA;
               end;
               if FXType=$C then begin    {*** SET NEW INSTR-VOLUME ***}
                  ChannelVolume[Chn]:=FXValue;
                  if ChannelVolume[Chn]>64 then ChannelVolume[Chn]:=64;
                  FXType:=0; FXValue:=0;
               end;
               if CalcSize>0 then begin
                  if (FXType=0) and (FXValue=0) then begin
                     if (ChannelPitch[Chn]=0) and (ChannelVolume[Chn]=MyInstrData[SmpNum]^.inst_svol) then begin
                        l:=DataLength-SavePos;
                        if MyInstrData[SmpNum]^.inst_replen=0 then begin
                           DoZero:=true;
                           if l>0 then begin
                              if l>MyStepSize then l:=MyStepSize;
                              if l=MyStepSize then DoZero:=false;
                              SaveSize:=DosWrite(ChHandle[Chn],ptr(SMemA+SavePos),l);
                              CalcSize:=CalcSize-SaveSize;
                              SavePos:=SavePos+SaveSize;
                              l:=SaveSize;
                           end;
                           if DoZero and (l<=MyStepSize) then begin
                              WRITEZERO(Chn,MyStepSize-l);
                              CalcSize:=CalcSize-(MyStepSize-l);
                           end;
                        end else begin
                           SaveSize:=0;
                           if SavePos<round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4 then begin
                              if l>MyStepSize then l:=MyStepSize;
                              SaveSize:=DosWrite(ChHandle[Chn],ptr(SMemA+SavePos),l);
                              CalcSize:=CalcSize-SaveSize;
                              SavePos:=SavePos+SaveSize;
                           end;
                           if SavePos>=round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4
                           then while SaveSize<MyStepSize do begin
                              if SavePos>=DataLength then SavePos:=round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4;
                              l:=MyStepSize-SaveSize;
                              if l+SavePos>DataLength then l:=DataLength-SavePos;
                              SaveSize:=SaveSize+DosWrite(ChHandle[Chn],ptr(SMemA+SavePos),l);
                              CalcSize:=CalcSize-l;
                              SavePos:=SavePos+l;
                           end;
                        end;
                     end else if ChannelPitch[Chn]>0 then begin
                        {*** HOLD PITCH UP ***}
                        StepMemL:=MyStepSize;
                        StepMemA:=AllocMem(StepMemL,0);
                        if StepMemA=0 then begin
                           writeln('Kein STEp-Speicher');
                           exit;
                        end;
                        Factor1:=SWAPUNITS(SWAPUNITS(ChannelFreq[Chn])-(MyTempo2*ChannelPitch[Chn]));
                        MySteps:=(Factor1/ChannelFreq[Chn]);
                        Addr1:=StepMemA; Addr2:=SMemA+SavePos;
                        AddrOffset:=MySteps;
                        repeat
                           if SavePos<DataLength then repeat
                              Data1:=ptr(Addr1);   Addr1:=Addr1+4;
                              Data2:=ptr(Addr2+round(AddrOffset)*4);
                              AddrOffset:=AddrOffset+MySteps;
                              Data1^:=Data2^;
                           until (Addr1>=StepMemA+StepMemL) or ((AddrOffset*4+SavePos)>DataLength);
                           if ((AddrOffset*4+SavePos)>DataLength) and (Addr1<StepMemA+StepMemL) then begin
                              if MyInstrData[SmpNum]^.inst_replen=0 then repeat
                                 Data1:=ptr(Addr1); Addr1:=Addr1+4;
                                 Data1^:=0;
                              until Addr1>StepMemA+StepMemL else begin
                                 SavePos:=round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4;
                                 AddrOffset:=MySteps;
                              end;
                           end;
                        until (Addr1>=StepMemA+StepMemL);
                        SavePos:=SavePos+(round(AddrOffset)*4);
                        if MyInstrData[SmpNum]^.inst_replen>0 then while SavePos>DataLength do
                         SavePos:=SavePos-(round((MyInstrData[SmpNum]^.inst_replen*2)/Steps)*4);
                     end else if ChannelPitch[Chn]<0 then begin
                        {*** HOLD PITCH DOWN ***}
                        StepMemL:=MyStepSize;
                        StepMemA:=AllocMem(StepMemL,0);
                        if StepMemA=0 then begin
                           writeln('Kein STEp-Speicher');
                           exit;
                        end;
                        Factor1:=SWAPUNITS(SWAPUNITS(ChannelFreq[Chn])+abs(MyTempo2*ChannelPitch[Chn]));
                        MySteps:=(Factor1/ChannelFreq[Chn]);
                        Addr2:=StepMemA; Addr1:=SMemA+SavePos;
                        AddrOffset:=MySteps;
                        repeat
                           if SavePos<DataLength then repeat
                              Data2:=ptr(Addr2);   Addr2:=Addr2+4;
                              Data1:=ptr(Addr1+round(AddrOffset)*4);
                              AddrOffset:=AddrOffset+MySteps;
                              Data2^:=Data1^;
                           until (Addr2>=StepMemA+StepMemL) or (AddrOffset*4+SavePos>DataLength);
                           if (AddrOffset*4+SavePos>DataLength) and (Addr2<StepMemA+StepMemL) then begin
                              if MyInstrData[SmpNum]^.inst_replen=0 then repeat
                                 Data2:=ptr(Addr2); Addr2:=Addr2+4;
                                 Data2^:=0;
                              until Addr2>=StepMemA+StepMemL else begin
                                 SavePos:=round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4;
                                 AddrOffset:=MySteps;
                              end;
                           end;
                        until (Addr2>=StepMemA+StepMemL);
                        SavePos:=SavePos+round(AddrOffset)*4;
                        if MyInstrData[SmpNum]^.inst_replen>0 then while SavePos>DataLength do
                         SavePos:=SavePos-round((MyInstrData[SmpNum]^.inst_replen*2)/Steps)*4;
                     end;
                  end else begin
                     if FXType=1 then begin {*** PITCH SHIFT UP ***}
                        ChannelPitch[Chn]:=ChannelPitch[Chn]+FXValue;
                        StepMemL:=MyStepSize;
                        StepMemA:=AllocMem(StepMemL,0);
                        if StepMemA=0 then begin
                           writeln('Kein STEp-Speicher');
                           exit;
                        end;
                        Factor1:=SWAPUNITS(SWAPUNITS(ChannelFreq[Chn])-(MyTempo2*ChannelPitch[Chn]));
                        Factor2:=SWAPUNITS(SWAPUNITS(ChannelFreq[Chn])-(MyTempo2*(ChannelPitch[Chn]-FXValue)));
                        MySteps:=(Factor2/ChannelFreq[Chn]);
                        StepSteps:=((Factor1/ChannelFreq[Chn])-(Factor2/ChannelFreq[Chn]))/(MyStepSize/4);
                        Addr1:=StepMemA; Addr2:=SMemA+SavePos;
                        AddrOffset:=MySteps;
                        repeat
                           if SavePos<DataLength then repeat
                              Data1:=ptr(Addr1);   Addr1:=Addr1+4;
                              Data2:=ptr(Addr2+round(AddrOffset)*4);
                              AddrOffset:=AddrOffset+MySteps;
                              MySteps:=MySteps+StepSteps;
                              Data1^:=Data2^;
                           until (Addr1>=StepMemA+StepMemL) or (AddrOffset*4+SavePos>DataLength);
                           if (AddrOffset*4+SavePos>DataLength) and (Addr1<StepMemA+StepMemL) then begin
                              if MyInstrData[SmpNum]^.inst_replen=0 then repeat
                                 Data1:=ptr(Addr1); Addr1:=Addr1+4;
                                 Data1^:=0;
                              until Addr1>=StepMemA+StepMemL else begin
                                 SavePos:=round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4;
                                 AddrOffset:=MySteps;
                              end;
                           end;
                        until (Addr1>=StepMemA+StepMemL);
                        SavePos:=SavePos+round(AddrOffset)*4;
                        if MyInstrData[SmpNum]^.inst_replen>0 then while SavePos>DataLength do
                         SavePos:=SavePos-round((MyInstrData[SmpNum]^.inst_replen*2)/Steps)*4;
                     end else if FXType=2 then begin {*** PITCH SHIFT DOWN ***}
                        ChannelPitch[Chn]:=ChannelPitch[Chn]-FXValue;
                        StepMemL:=MyStepSize;
                        StepMemA:=AllocMem(StepMemL,0);
                        if StepMemA=0 then begin
                           writeln('Kein STEp-Speicher');
                           exit;
                        end;
                        Factor1:=SWAPUNITS(SWAPUNITS(ChannelFreq[Chn])+abs(MyTempo2*ChannelPitch[Chn]));
                        Factor2:=SWAPUNITS(SWAPUNITS(ChannelFreq[Chn])+abs(MyTempo2*(ChannelPitch[Chn]+FXValue)));
                        MySteps:=(Factor2/ChannelFreq[Chn]);
                        StepSteps:=((Factor1/ChannelFreq[Chn])-(Factor2/ChannelFreq[Chn]))/(MyStepSize/4);
                        Addr2:=StepMemA; Addr1:=SMemA+SavePos;
                        AddrOffset:=MySteps;
                        repeat
                           if SavePos<DataLength then repeat
                              Data2:=ptr(Addr2);   Addr2:=Addr2+4;
                              Data1:=ptr(Addr1+round(AddrOffset)*4);
                              AddrOffset:=AddrOffset+MySteps;
                              MySteps:=MySteps+StepSteps;
                              Data2^:=Data1^;
                           until (Addr2>=StepMemA+StepMemL) or (AddrOffset*4+SavePos>DataLength);
                           if (AddrOffset*4+SavePos>DataLength) and (Addr2<StepMemA+StepMemL) then begin
                              if MyInstrData[SmpNum]^.inst_replen=0 then repeat
                                 Data2:=ptr(Addr2); Addr2:=Addr2+4;
                                 Data2^:=0;
                              until Addr2>=StepMemA+StepMemL else begin
                                 SavePos:=round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4;
                                 AddrOffset:=MySteps;
                              end;
                           end;
                        until (Addr2>=StepMemA+StepMemL);
                        SavePos:=SavePos+round(AddrOffset)*4;
                        if MyInstrData[SmpNum]^.inst_replen>0 then while SavePos>DataLength do
                         SavePos:=SavePos-round((MyInstrData[SmpNum]^.inst_replen*2)/Steps)*4;
                     end;
                  end;
                  if ChannelVolume[Chn]<>MyInstrData[SmpNum]^.inst_svol then begin
                     {*** DO NEW INSTR-VOLUME ***}
                     if StepMemA=0 then begin
                        StepMemL:=MyStepSize;
                        StepMemA:=AllocMem(StepMemL,0);
                        if StepMemA=0 then begin
                           writeln('Kein STEp-Speicher');
                           exit;
                        end;
                        Addr2:=StepMemA; Addr1:=SMemA+SavePos;
                        repeat
                           if SavePos<DataLength then repeat
                              Data2:=ptr(Addr2);   Addr2:=Addr2+4;
                              Data1:=ptr(Addr1);   Addr1:=Addr1+4;
                              Data2^:=Data1^;
                           until (Addr2>=StepMemA+StepMemL) or (Addr1>=SMemA+DataLength);
                           if (Addr1>=SMemA+DataLength) and (Addr2<StepMemA+StepMemL) then begin
                              if MyInstrData[SmpNum]^.inst_replen=0 then repeat
                                 Data2:=ptr(Addr2); Addr2:=Addr2+4;
                                 Data2^:=0;
                              until Addr2>=StepMemA+StepMemL else begin
                                 SavePos:=round((MyInstrData[SmpNum]^.inst_repeat*2)/Steps)*4;

                                 Addr1:=SMemA+SavePos;
                              end;
                           end;
                        until (Addr2>=StepMemA+StepMemL);
                        SavePos:=SavePos+MyStepSize;
                        if MyInstrData[SmpNum]^.inst_replen>0 then while SavePos>DataLength do
                         SavePos:=SavePos-round((MyInstrData[SmpNum]^.inst_replen*2)/Steps)*4;
                     end;
                     Addr1:=StepMemA;
                     repeat
                        Data1:=ptr(Addr1);    Addr1:=Addr1+4;
                        Data1^:=round((Data1^*ChannelVolume[Chn])/MyInstrData[SmpNum]^.inst_svol);
                     until Addr1>=StepMemA+StepMemL;
                  end;
               end;
            end;
            if StepMemA<>0 then begin
               SaveSize:=DosWrite(ChHandle[Chn],ptr(StepMemA),StepMemL);
               CalcSize:=CalcSize-SaveSize;
               FreeMem(StepMemA,StepMemL);
               StepMemA:=0;
            end;
         end;
      end;
      MyStep:=1;
   end;
end;



function GETSIZE(SongPos,MyStep,MyChn :long):long;

var i,Step,Chn                  :word;
var SmplSize,MyStepsize         :long;
var Note,SmpNum,FXType,FXValue  :long;
var MyBlockSize                 :BlockSize;

begin
   MyStepSize:=StepSize;
   SmplSize:=StepSize;
   with MyMSNGHeader^ do for i:=SongPos to SongEnd do begin
      MyBlockSize:=ptr(ModMemA+BlockAddr[msng_playseq[i]]);
      with MyBlockSize^ do for Step:=MyStep to bs_Steps do begin
         for Chn:=1 to bs_Channels do begin
            if (i<>SongPos) or (Step<>MyStep) or (Chn<>MyChn) then begin
               Data1:=ptr(ModMemA+BlockAddr[msng_playseq[i]]+1+pred(Chn)*3+Step*bs_Channels*3);
               SmpNum:=(Data1^ and $C00000) div $80000;
               SmpNum:=SmpNum+(Data1^ and $00F000) div $1000;
               Note:=3+((Data1^ and $3F0000) div $10000);
               FXType:=(Data1^ and $F00) div $100;
               FXValue:=(Data1^ and $7F);
               if FXType=$9 then {*** SET SECONDARY TEMPO ***}
                MyStepSize:=round(MyMsngHeader^.msng_deftempo*0.00075*44100*FXValue)*4;
               if (Chn=MyChn) and (Note in [4..48]) then begin
                  GETSIZE:=SmplSize;
                  exit
               end else if Chn=MyChn then SmplSize:=SmplSize+MyStepSize;
            end;
         end;
      end;
      MyStep:=1;
   end;
   GETSIZE:=SmplSize;
end;



begin
   Fast:=true; ModMemA:=0; SMemL:=1000000;
   for i:=0 to 8 do begin
      ChHandle[i]:=0;
      ChannelPitch[i]:=0; ChannelFreq[i]:=0;
      ChMemA[i]:=0;
   end;
   SMemA:=AllocMem(SMemL,MEMF_CLEAR);
   if SMemA=0 then error('Kein Speicher');
   OpenLib(DosBase,'dos.library',0);
   MyNoteArr:=NoteArr(WArr48(0,0,0,0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,0,0,0,0,0,
                             28160,29829,31677,33453,35441,37679,
                             39772,42112,44744,47727,50416,53260),
                      StrArr48('','','','','','','','','','','','',
                               '','','','','','','','','','','','',
                               '','','','','','','','','','','','',
                               'A-','Bb','B-','C-','C#','D-',
                               'Eb','E-','F-','F#','G-','G#'));
   for i:=1 to 4 do for j:=12 downto 1 do
    with MyNoteArr do na_Name[pred(i)*12+j]:=na_Name[j+36]+intstr(i);
   for i:=3 downto 1 do for j:=1 to 12 do
    with MyNoteArr do na_Freq[pred(i)*12+j]:=na_Freq[i*12+j] div 2;
   FHandle:=DosOpen('Data:Modules_8/ThePatternsOfDestruction2',MODE_OLDFILE);
   if FHandle<>0 then begin
      l:=DosSeek(FHandle,0,OFFSET_END);
      ModMemL:=DosSeek(FHandle,0,OFFSET_BEGINNING);
      ModMemA:=AllocMem(ModMemL,MEMF_CLEAR);
      if ModMemA<>0 then begin
         l:=DosRead(FHandle,ptr(ModMemA),ModMemL);
         DosClose(FHandle);
         MyMMDHeader:=ptr(ModMemA);
         with MyMMDHeader^ do begin
            writeln(mmd_id,':        ',mmd_modlen,' Bytes');
            writeln('PState:      ',mmd_pstate);
            writeln('PBlock:      ',mmd_pblock);
            writeln('PLine:       ',mmd_pline);
            writeln('PSeqNum:     ',mmd_pseqnum);
            writeln('ActPlayLine: ',mmd_actplayline);
            writeln('Counter:     ',mmd_counter);
            writeln('Songs left:  ',mmd_songsleft);
         end;
         for i:=1 to 63 do begin
            MyInstrData[i]:=ptr(ModMemA+MyMMDHeader^.mmd_SongInfo+pred(i)*sizeof(r_InstrData));
            if i<=3 then with MyInstrData[i]^ do begin
               writeln('Repeat: ',inst_repeat);
               writeln('RepLen: ',inst_replen);
               writeln('Volume: ',inst_svol);
               writeln('Trans:  ',inst_strans);
            end;
         end;
         MyMSNGHeader:=ptr(ModMemA+MyMMDHeader^.mmd_SongInfo+63*sizeof(r_InstrData));
         with MyMSNGHeader^ do begin
            writeln('Blocks:  ',msng_numblocks);
            writeln('SongLen: ',msng_songlen);
            SongEnd:=msng_songlen;
            writeln('Tempo:   ',msng_deftempo);
            writeln('Flags:   ',msng_flags);
            writeln('Tempo2:  ',msng_tempo2);
            writeln('Samples: ',msng_numsamples);
            StepSize:= round(msng_deftempo*0.00075*44100*msng_tempo2)*4;
         end;

         { *** Blockadressen ***}
         for i:=0 to 256 do BlockAddr[i]:=0;
         for i:=0 to MyMSNGHeader^.msng_numblocks do begin
            Data1:=ptr(ModMemA+MyMMDHeader^.mmd_BlockArr+i*4);
            BlockAddr[i]:=Data1^;
         end;

         { *** Sampleadressen / -lngen ***}
         for i:=1 to 63 do SampleAddr[i]:=0;
         for i:=1 to MyMSNGHeader^.msng_numsamples do begin
            Data1:=ptr(ModMemA+MyMMDHeader^.mmd_SmplArr+pred(i)*4);
            SampleAddr[i]:=Data1^;
            if SampleAddr[i]>0 then begin
               Data1:=ptr(ModMemA+SampleAddr[i]);
               SampleLength[i]:=Data1^;
               SampleAddr[i]:=SampleAddr[i]+6;
            end else SampleLength[i]:=0;
         end;

         { *** ExpData-Adressen ***}
         MyExpAddr:=ptr(ModMemA+MyMMDHeader^.mmd_ExpData);
         with MyExpAddr^ do begin
            TitleStr:=ptr(ModMemA+TitleAddr);
            writeln(TitleStr);
            for i:=1 to StrNum do InstrStr[i]:=ptr(ModMemA+InstrNames+pred(i)*IStrSize);
         end;

         for i:=0 to 8 do begin
            s:=PREFIX+intstr(i);
            ChHandle[i]:=DosOpen(s,MODE_NEWFILE);
            if ChHandle[i]=0 then begin
               if i>0 then for j:=pred(i) downto 0 do DosClose(ChHandle[j]);
               error('Output-Fileerror');
            end;
         end;
         s:='';
SongEnd:=1;
         with MyMSNGHeader^ do for i:=1 to SongEnd do begin
            MyBlockSize:=ptr(ModMemA+BlockAddr[msng_playseq[i]]);
            with MyBlockSize^ do for Step:=0 to bs_Steps do begin
               s:='';
               for Chn:=1 to bs_Channels do if Chn=1 then begin
                  Data1:=ptr(ModMemA+BlockAddr[msng_playseq[i]]+1+pred(Chn)*3+Step*bs_Channels*3);
                  SmpNum:=(Data1^ and $C00000) div $80000;
                  SmpNum:=SmpNum+(Data1^ and $00F000) div $1000;
                  Note:=3+((Data1^ and $3F0000) div $10000);
                  if (Note in [4..48]) and (SmpNum>0) and (SampleAddr[SmpNum]>0) then begin
                     s:=s+'  '+MyNoteArr.na_Name[Note];
                     ChannelPitch[Chn]:=0;
                     ChannelVolume[Chn]:=MyInstrData[SmpNum]^.inst_svol;
                     ChannelFreq[Chn]:=MyNoteArr.na_Freq[Note];
                     Steps:=MyNoteArr.na_Freq[Note]/44100;
                     Addr1:=SMemA;
                     Addr2:=ModMemA+SampleAddr[SmpNum];
                     AddrOffset:=Steps;
                     CalcSize:=GETSIZE(i,Step,Chn);
                     DONOTE(i,Step,Chn,Calcsize);
                  end else s:=s+'  ---';
               end;
               writeln('#',pred(i),'  #',Step,s);
            end;
         end;
         FreeMem(ModMemA,ModMemL);
         FreeMem(SMemA,SMemL); SMemA:=0;

         ChMemL:=(AvailMem(MEMF_LARGEST) div 36) * 4;
         if ChMemL>1000 then begin
            for i:=0 to 8 do begin
               ChMemA[i]:=AllocMem(ChMemL,MEMF_CLEAR);
               if ChMemA[i]=0 then begin
                  if i>0 then for j:=pred(i) downto 0 do begin
                     FreeMem(ChMemA[j],ChMemL);
                     ChMemA[j]:=0;
                  end;
                  writeln(ChMemL,'  ','Speichermangel');
               end;
               l:=DosSeek(ChHandle[i],0,OFFSET_BEGINNING);
            end;
            if ChMemA[8]>0 then begin
               LastPos:=0;
               repeat
                  for i:=1 to 8 do begin
                     l:=DosRead(ChHandle[i],ptr(ChMemA[i]),ChMemL);
                     Addr[i]:=ChMemA[i];
                  end;
                  Addr[0]:=ChMemA[0];
                  repeat
                     for i:=0 to 8 do begin
                        Data[i]:=ptr(Addr[i]); Addr[i]:=Addr[i]+4;
                     end;
                     Data[0]^:=(Data[1]^+Data[2]^+Data[3]^+Data[4]^+
                                Data[5]^+Data[6]^+Data[7]^+Data[8]^) div 8;
                  until (Addr[0]>=ChMemA[0]+l);
                  LastPos:=LastPos+DosWrite(ChHandle[0],ptr(ChMemA[0]),l);
writeln(LastPos);
               until l<ChMemL;
               for i:=0 to 8 do FreeMem(ChMemA[i],ChMemL);
            end;
         end else writeln('Nich genuch Speicher');
         for i:=0 to 8 do DosClose(ChHandle[i]);
      end else DosClose(FHandle);
   end;
   if SMemA<>0 then FreeMem(SMemA,SMemL);
   CloseLib(DosBase);
end.

