program AHI;

{$incl "exec/ports.h","exec/io.h","exec/memory.h","ahi.lib","libraries/dos.h"}

type LArr18=array[1..18] of long;
type LArr4=array[1..4] of long;

var AHIDevice             :byte;
var AHImp                 :^MsgPort;
var AHIio                 :^AHIRequest;
var TagList               :LArr18;
var PlayTag               :LArr4;
var actrl                 :^AHIAudioCtrl;
var mixfreq,SMemA,SmemL,l :long;
var w                     :word;


procedure CloseAHI;

begin
   if(AHIDevice=0) then CloseDevice(p_IORequest(AHIio));
   AHIDevice:=1;
   if (AHIio<>NIL) then DeleteIORequest(p_IORequest(AHIio));
   AHIio:=NIL;
   if (AHImp<>NIL) then DeleteMsgPort(AHImp);
   AHImp:=NIL;
   writeln('AHI closed');
end;



procedure FreeAudio;

begin
   AHI_FreeAudio(actrl);
   actrl:=NIL;
   writeln('Audio given free');
end;



procedure UnloadSample;

begin
   AHI_UnloadSound(SMemA, actrl);
   if (SMemA<>0) then FreeVec(SMemA);
   SMemA:=0;
   writeln('Samplemem given free');
end;



function LoadSample(FName :str; Typ :long):long;

var Sample  :AHISampleInfo;
var l,ID    :long;
var FHandle :BPTR;

begin
   FHandle:=DosOpen(FName,MODE_OLDFILE);
   if (FHandle=0) then exit;
   l:=DosRead(FHandle,ptr(SMemA),SMemL);
writeln('Data loaded: ',l);
   DosClose(FHandle);
   sample.ahisi_Type:=Typ;
   sample.ahisi_Address:=ptr(SMemA);
   sample.ahisi_Length:=SMemL; {Framesize!!!}
   ID:=1;
   if (AHI_LoadSound(id,AHIST_SAMPLE,^sample,actrl)=0) then LoadSample:=ID else LoadSample:=0;
writeln('Loaded');
end;



function AllocAudio:boolean;

var req       :^AHIAudioModeRequester;
var s         :string;
var l         :long;

begin
   AllocAudio:=FALSE;
{   s:='Select Screenmode!';
   TagList:=LArr18(AHIR_PubScreenName,0,
                   AHIR_TitleText,addr(s),
                   AHIR_DoMixFreq,1,
                   AHIR_InitialHeight,500,
                   AHIR_InitialMixFreq,44100,
                   0,0,0,0,0,0,0,0);
   req:=AHI_AllocAudioRequest(^TagList);
   if(req<>NIL) then if (AHI_AudioRequest(req,NIL)) then begin
      TagList:=LArr18(AHIA_AudioID,         req^.ahiam_AudioID,
                      AHIA_MixFreq,         req^.ahiam_MixFreq,
                      AHIA_Channels,        1,
                      AHIA_Sounds,          1,
                      AHIA_PlayerFreq,      $20000000,
                      0,0,0,0,0,0,0,0);}

      TagList:=LArr18(AHIA_AudioID,        $C0005,
                      AHIA_MixFreq,         44100,
                      AHIA_Channels,        1,
                      AHIA_Sounds,          1,
                      AHIA_PlayerFreq,      $20000000,
                      0,0,0,0,0,0,0,0);
      actrl:=AHI_AllocAudio(^TagList);
writeln("AHI_AllocAudio");
      if (actrl<>NIL) then begin
         { Get real mixing frequency}
         mixfreq:=req^.ahiam_MixFreq;
         PlayTag:=LArr4(AHIC_MixFreq_Query,addr(mixfreq),
                        0,0);
         l:=AHI_ControlAudio(actrl,^PlayTag);
writeln("AHI_ControlAudio");
         if (l=0) then AllocAudio:=TRUE;
      end;
{   end;}
{    AHI_FreeAudioRequest(req);}
writeln("audio allocated");
end;



function OpenAHI:boolean;

begin
   AHImp:=CreateMsgPort;
   if (AHImp<>NIL) then begin
      AHIio:=p_AHIRequest(CreateIORequest(AHImp,sizeof(AHIRequest)));
      if (AHIio<>NIL) then begin
         AHIio^.ahir_Version:=4;
         AHIDevice:=OpenDevice('ahi.device',0,p_IORequest(AHIio),0);
         if (AHIDevice=0) then begin
            AHIBase:=p_Library(AHIio^.ahir_Std.io_Device);
            OpenAHI:=TRUE;
            writeln('AHI opened');
            exit;
         end else writeln('No Device');
      end else writeln('No IO');
   end else writeln('No Messageport');
   FreeAudio;
   OpenAHI:=FALSE;
end;



begin
   SMemL:=35000;
   SMemA:=AllocVec(SMemL,MEMF_CLEAR);
   AHIDevice:=1;
   AHIio:=NIL;
   AHImp:=NIL;
   OpenLib(DosBase,'dos.library',0);
   if (SMemA<>0) then begin
      if ((SMemA<>0) and (OpenAHI)) then if (AllocAudio) then begin
         w:=LoadSample("DATA:Samples/Voice_GoodEvening",AHIST_M8S);
writeln('ID: ',w);
         if(w<>0) then begin
            {PlayTag:=LArr4(AHIC_Play,1,0,0);
            if (AHI_ControlAudio(actrl,^PlayTag)=0) then begin
               TagList:=LArr18(AHIP_BeginChannel,  0,
                               AHIP_Freq,          17640,
                               AHIP_Vol,           $10000,
                               AHIP_Pan,           $8000,
                               AHIP_Sound,         SMemA,
                               AHIP_EndChannel,    0,0,0,0,0,0,0);
               AHI_Play(actrl,^TagList);
               delay(50);
            end;
            PlayTag:=LArr4(AHIC_Play,0,0,0);
            l:=AHI_ControlAudio(actrl,^PlayTag);}
{            UnloadSample;}
         end;
{         FreeAudio;}
      end;
{      CloseAHI;}
   end else writeln('No memory!!!');
end;




