#include <exec/types.h>
#include <rexx/rxslib.h>
#include <exec/ports.h>

#include <clib/alib_protos.h>
#include <clib/dos_protos.h>
#include <clib/exec_protos.h>

#include <pragma/all_lib.h>

#include <wbstartup.h>
#include <iostream.h>

#define PORT_REXX "ACutSlavePort"
#define PORT_WT   "WTRexx"

extern Library *DOSBase;

MsgPort *RexxPort,*WTPort;

RexxMsg MyRxMsg={{{NULL,NULL,0,0,NULL},NULL,sizeof(RexxMsg)},NULL,NULL,0,0,0,
                 {NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL}};




void SendCommand(void)

{
Message *MyReplyMsg;

Forbid();
WTPort=FindPort(PORT_WT);
if (WTPort)
   {
   MyRxMsg.rm_Node.mn_ReplyPort=RexxPort;
   PutMsg(WTPort,&MyRxMsg.rm_Node);
   Permit();
   Delay(1);
   MyReplyMsg=WaitPort(RexxPort);
   MyReplyMsg=GetMsg(RexxPort);
   }
Permit();
}



void ReadHardware(void)

{
UWORD  *JoyA,*JoyD;
UBYTE  *Fire;
BYTE    Jog=0,Wheel=0,PortActive=0;


JoyD=(UWORD*)0xDFF00C;
JoyA=(UWORD*)0xDFF016;
Fire=(UBYTE*)0xBFE001;
do
   {
   WTPort=FindPort(PORT_WT);
   if (WTPort)
      {
      if (PortActive==0) PortActive=1;
      if (((*JoyA & 0x1000)==0x1000) && ((*JoyA & 0x4000)==0) && (Jog==0)) Jog=1
      else if (((*JoyA & 0x1000)==0) && ((*JoyA & 0x4000)==0) && (Jog==1)) Jog=2
      else if (((*JoyA & 0x1000)==0) && ((*JoyA & 0x4000)==0x4000) && (Jog==2))      
         {
         MyRxMsg.rm_Args[0]="JOGFORWARD";
         SendCommand();
         Jog=0;
         }   
      else if (((*JoyA & 0x1000)==0) && ((*JoyA & 0x4000)==0x4000) && (Jog==0)) Jog=-1
      else if (((*JoyA & 0x1000)==0) && ((*JoyA & 0x4000)==0) && (Jog==-1)) Jog=-2
      else if (((*JoyA & 0x1000)==0x1000) && ((*JoyA & 0x4000)==0) && (Jog==-2))
         {
         MyRxMsg.rm_Args[0]="JOGBACKWARD";
         SendCommand();
         Jog=0;
         }
      
      else if ((*Fire & 128)==0)
         {
         MyRxMsg.rm_Args[0]="JOGBUTTON1";
         SendCommand();
         Delay(10);
         }

      else if (((*JoyD & 0x0303)==0x0303) && (Wheel==0))
         {
         Wheel=-1;
         MyRxMsg.rm_Args[0]="JOGBEGIN";
         SendCommand();
         Delay(5);
         }
      else if (((*JoyD & 0x0303)==0x0300) && (Wheel==0))
         {
         Wheel=1;
         MyRxMsg.rm_Args[0]="JOGEND";
         SendCommand();
         Delay(5);
         }
      else if (((*JoyD & 0x0303)==0x0101) && (Wheel==0))
         {
         MyRxMsg.rm_Args[0]="JOGFORWARD";
         SendCommand();
         }
      else if (((*JoyD & 0x0303)==0x0102) && (Wheel==0))
         {
         MyRxMsg.rm_Args[0]="JOGBACKWARD";
         SendCommand();
         }
      else if (((*JoyD & 0x0303)==0x0000) && (Wheel!=0)) Wheel=0
      else 
         {
         if (((*JoyA & 0x1000)==0x1000) && ((*JoyA & 0x4000)==0x4000))
            {
            Delay(1);
            Jog=0;
            }
         }
      }
   else
      {
      Delay(20);
      if (PortActive==1) PortActive=2;
      }
   }
while (PortActive<2);
cout << "ACutSlave terminated\n" 
}



void CLEARPORT(char *PortName)

{
Message *BadMsg;
MsgPort *BadPort;


BadPort=FindPort(PortName);
Forbid();
while (BadPort)
   {
   BadMsg=GetMsg(BadPort);
   while (BadMsg)
      {
      ReplyMsg(BadMsg);
      BadMsg=GetMsg(BadPort);
      }
   RemPort(BadPort);
   DeleteMsgPort(RexxPort);
   BadPort=FindPort(PortName);
   }
Permit();
}



void main(void)

{
DOSBase=OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (!FindPort(PORT_REXX))
      {
      RexxPort=CreateMsgPort();
      RexxPort->mp_Node.ln_Pri=0;
      RexxPort->mp_Node.ln_Name=PORT_REXX;
      if (RexxPort)
         {
         AddPort(RexxPort);
         if (RexxPort)
            {
            ReadHardware();
            CLEARPORT(PORT_REXX);
            }
         }
      }
   else cout << "ACutSlave always active!\n";
   CloseLibrary(DOSBase);
   }
else cout << "Can't open dos.library!\n";
}
