/* testing AE */

 call open("STDERR","ram:traceAET","W")
trace r 

options results
numeric digits 12 /* allow long numbers for milliseconds */

address command
SoundFile = getclip('Listsound')
if SoundFile~="" then do
    fdrawer = getpath(SoundFile)
    'requestfile >ram:answer2 TITLE "Sound File" DRAWER 'fdrawer
    end
else 'requestfile >ram:answer2 TITLE "Sound File" '
call open("answer2","ram:answer2",'R')
SoundFile = strip(readln("answer2"),'B','"')
call setclip('Listsound',SoundFile)

Ainfo = getAIFFinfo(SoundFile)
playingtime = word(Ainfo, 5)

address AE_AREXX
loadsample filename soundFile

address command
wait 11 /* This wait will give you time to get to the AE screen */

address AE_AREXX
locate msecs("2:12:000")  /* time marker jumps to 2 minutes 12 seconds */

play /* play the sample starting at the new time point */

address command
wait 11 /* play for 11 seconds */

address AE_AREXX
stop  /* stop playing */


exit



/* +++++++++++++++++++++++++++++  +++++++++++++++++++++++++++++++++ */

getpath:
parse arg allname
pos1 = lastpos("/",allname)
if pos1 = 0 then pos1 = lastpos(":",allname)
filepath = left(allname,pos1)
return filepath

/* +++++++++++++++++++++++++++++ +++++++++++++++++++++++++++++++++++ */

msecs: /* Converts formatted time into milliseconds */
parse arg minutes ":" seconds ":" milles

millisecs = 0
OK = "yes"
if ~datatype(minutes, 'N') then OK= "no"
if ~datatype(seconds, 'N') then OK = "no"
if ~datatype(milles, 'N') then OK = "no"

if seconds > 59 then seconds = 59
if milles > 999 then milles = 999

if OK = "yes" then millisecs = (minutes * 60000) + (seconds * 1000) + milles
return millisecs


/* ++++++++++++++++++++++++++ ++++++++++++++++++++++++++++++++++++ */

/* round number to 3 decimal places */
rounded3: procedure
parse arg number
if ~datatype(number, 'N') then return number

nflag = 0
if number <0 then nflag = 1

number = abs(number)
originalNumber = number
number = left(number, pos(".", number)+3)
if (originalNumber-number)>0.0005 then number=number+0.001
if nflag = 1 then number = 0-number
return number


/* +++++++++++++++++++++++++ +++++++++++++++++++++++++++++++++++++ */

/* Get information about the sound file from its header */

getAIFFinfo:
arg SoundFile

if open("aiffinput",SoundFile,"R") then chunks = readch("aiffinput",1000)
call close("aiffinput")
commpos = pos("COMM", chunks)
if commpos = 0 then exit /* not an AIFF file */
numchannels = c2d(substr(chunks, commpos + 8, 2))
numSampleFrames = c2d(substr(chunks, commpos + 10, 4))
sampleSize = c2d(substr(chunks, commpos + 14, 2))

sampleRateKey = c2d(substr(chunks, commpos + 16, 4)) /* This is actually a floating point number. We can assume it is one of a few possible rates and just check the first 4 bytes of the binary code for matches. */

sampleRate = 44100 /* default */
if sampleRateKey = 1074703428 then sampleRate = 44100

playtime = rounded3(numSampleFrames/sampleRate)

results = numchannels" "numSampleFrames" "sampleSize" "sampleRate" "playtime

return results

