require '_h2ph_pre.ph';

unless(defined(&BBSIZE)) {
    sub BBSIZE () {	8192;}
}
unless(defined(&SBSIZE)) {
    sub SBSIZE () {	8192;}
}
unless(defined(&BBOFF)) {
    sub BBOFF () {	((0));}
}
unless(defined(&SBOFF)) {
    sub SBOFF () {	(( &BBOFF +  &BBSIZE));}
}
unless(defined(&BBLOCK)) {
    sub BBLOCK () {	((0));}
}
unless(defined(&SBLOCK)) {
    sub SBLOCK () {	(( &BBLOCK +  &BBSIZE /  &DEV_BSIZE));}
}
unless(defined(&MINBSIZE)) {
    sub MINBSIZE () {	4096;}
}
unless(defined(&MAXMNTLEN)) {
    sub MAXMNTLEN () {	512;}
}
unless(defined(&NOCSPTRS)) {
    sub NOCSPTRS () {	((128/ $sizeof{ &void }) - 3);}
}
unless(defined(&FS_MAXCONTIG)) {
    sub FS_MAXCONTIG () {	16;}
}
unless(defined(&MINFREE)) {
    sub MINFREE () {	5;}
}
unless(defined(&DEFAULTOPT)) {
    sub DEFAULTOPT () {	 &FS_OPTTIME;}
}
unless(defined(&AVFILESIZ)) {
    sub AVFILESIZ () {	16384;}
}
unless(defined(&AFPDIR)) {
    sub AFPDIR () {	64;}
}
unless(defined(&FS_MAGIC)) {
    sub FS_MAGIC () {	0x011954;}
}
unless(defined(&FS_OKAY)) {
    sub FS_OKAY () {	0x7c269d38;}
}
unless(defined(&FS_42INODEFMT)) {
    sub FS_42INODEFMT () {	-1;}
}
unless(defined(&FS_44INODEFMT)) {
    sub FS_44INODEFMT () {	2;}
}
unless(defined(&FS_ISCLEAN)) {
    sub FS_ISCLEAN () {	0x01;}
}
unless(defined(&FS_WASCLEAN)) {
    sub FS_WASCLEAN () {	0x02;}
}
unless(defined(&FS_OPTTIME)) {
    sub FS_OPTTIME () {	0;}
}
unless(defined(&FS_OPTSPACE)) {
    sub FS_OPTSPACE () {	1;}
}
unless(defined(&FS_UNCLEAN)) {
    sub FS_UNCLEAN () {	0x01;}
}
unless(defined(&FS_DOSOFTDEP)) {
    sub FS_DOSOFTDEP () {	0x02;}
}
unless(defined(&FS_42POSTBLFMT)) {
    sub FS_42POSTBLFMT () {	-1;}
}
unless(defined(&FS_DYNAMICPOSTBLFMT)) {
    sub FS_DYNAMICPOSTBLFMT () {	1;}
}
unless(defined(&fs_postbl)) {
    sub fs_postbl {
	local($fs, $cylno) = @_;
	eval q(((-> &fs_postblformat ==  &FS_42POSTBLFMT) ? (-> $fs_opostbl[$cylno]) : ((($fs) + ($fs)-> &fs_postbloff) + ($cylno) * ($fs)-> &fs_nrpos)));
    }
}
unless(defined(&fs_rotbl)) {
    sub fs_rotbl {
	local($fs) = @_;
	eval q(((-> &fs_postblformat ==  &FS_42POSTBLFMT) ? (-> &fs_space) : ((($fs) + ($fs)-> &fs_rotbloff))));
    }
}
unless(defined(&CGSIZE)) {
    sub CGSIZE {
	local($fs) = @_;
	eval q(($sizeof{'struct cg'} + $sizeof{ &int32_t} + ($fs)-> &fs_cpg * $sizeof{ &int32_t} + ($fs)-> &fs_cpg * ($fs)-> &fs_nrpos * $sizeof{ &int16_t} +  &howmany(($fs)-> &fs_ipg,  &NBBY) +  &howmany(($fs)-> &fs_cpg * ($fs)-> &fs_spc /  &NSPF($fs),  &NBBY) + (($fs)-> &fs_contigsumsize <= 0? 0: ($fs)-> &fs_contigsumsize * $sizeof{ &int32_t} +  &howmany(($fs)-> &fs_cpg * ($fs)-> &fs_spc /  &NSPB($fs),  &NBBY))));
    }
}
unless(defined(&fs_cs)) {
    sub fs_cs {
	local($fs, $indx) = @_;
	eval q( $fs_csp[$indx]);
    }
}
unless(defined(&CG_MAGIC)) {
    sub CG_MAGIC () {	0x090255;}
}
unless(defined(&cg_blktot)) {
    sub cg_blktot {
	local($cgp) = @_;
	eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> &cg_btot) : ((($cgp) + ($cgp)-> &cg_btotoff))));
    }
}
unless(defined(&cg_blks)) {
    sub cg_blks {
	local($fs, $cgp, $cylno) = @_;
	eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> $cg_b[$cylno]) : ((($cgp) + ($cgp)-> &cg_boff) + ($cylno) * ($fs)-> &fs_nrpos)));
    }
}
unless(defined(&cg_inosused)) {
    sub cg_inosused {
	local($cgp) = @_;
	eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> &cg_iused) : ((($cgp) + ($cgp)-> &cg_iusedoff))));
    }
}
unless(defined(&cg_blksfree)) {
    sub cg_blksfree {
	local($cgp) = @_;
	eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> &cg_free) : ((($cgp) + ($cgp)-> &cg_freeoff))));
    }
}
unless(defined(&cg_chkmagic)) {
    sub cg_chkmagic {
	local($cgp) = @_;
	eval q((-> &cg_magic ==  &CG_MAGIC || (($cgp))-> &cg_magic ==  &CG_MAGIC));
    }
}
unless(defined(&cg_clustersfree)) {
    sub cg_clustersfree {
	local($cgp) = @_;
	eval q(((($cgp) + ($cgp)-> &cg_clusteroff)));
    }
}
unless(defined(&cg_clustersum)) {
    sub cg_clustersum {
	local($cgp) = @_;
	eval q(((($cgp) + ($cgp)-> &cg_clustersumoff)));
    }
}
unless(defined(&fsbtodb)) {
    sub fsbtodb {
	local($fs, $b) = @_;
	eval q((($b) << ($fs)-> &fs_fsbtodb));
    }
}
unless(defined(&dbtofsb)) {
    sub dbtofsb {
	local($fs, $b) = @_;
	eval q((($b) >> ($fs)-> &fs_fsbtodb));
    }
}
unless(defined(&cgbase)) {
    sub cgbase {
	local($fs, $c) = @_;
	eval q(((($fs)-> &fs_fpg * ($c))));
    }
}
unless(defined(&cgdmin)) {
    sub cgdmin {
	local($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_dblkno));
    }
}
unless(defined(&cgimin)) {
    sub cgimin {
	local($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_iblkno));
    }
}
unless(defined(&cgsblock)) {
    sub cgsblock {
	local($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_sblkno));
    }
}
unless(defined(&cgtod)) {
    sub cgtod {
	local($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_cblkno));
    }
}
unless(defined(&cgstart)) {
    sub cgstart {
	local($fs, $c) = @_;
	eval q(( &cgbase($fs, $c) + ($fs)-> &fs_cgoffset * (($c) & ~(($fs)-> &fs_cgmask))));
    }
}
unless(defined(&ino_to_cg)) {
    sub ino_to_cg {
	local($fs, $x) = @_;
	eval q((($x) / ($fs)-> &fs_ipg));
    }
}
unless(defined(&ino_to_fsba)) {
    sub ino_to_fsba {
	local($fs, $x) = @_;
	eval q((( &cgimin($fs,  &ino_to_cg($fs, $x)) + ( &blkstofrags(($fs), ((($x) % ($fs)-> &fs_ipg) /  &INOPB($fs)))))));
    }
}
unless(defined(&ino_to_fsbo)) {
    sub ino_to_fsbo {
	local($fs, $x) = @_;
	eval q((($x) %  &INOPB($fs)));
    }
}
unless(defined(&dtog)) {
    sub dtog {
	local($fs, $d) = @_;
	eval q((($d) / ($fs)-> &fs_fpg));
    }
}
unless(defined(&dtogd)) {
    sub dtogd {
	local($fs, $d) = @_;
	eval q((($d) % ($fs)-> &fs_fpg));
    }
}
unless(defined(&blkmap)) {
    sub blkmap {
	local($fs, $map, $loc) = @_;
	eval q(((($map)[($loc) /  &NBBY] >> (($loc) %  &NBBY)) & (0xff >> ( &NBBY - ($fs)-> &fs_frag))));
    }
}
unless(defined(&cbtocylno)) {
    sub cbtocylno {
	local($fs, $bno) = @_;
	eval q((($bno) *  &NSPF($fs) / ($fs)-> &fs_spc));
    }
}
unless(defined(&cbtorpos)) {
    sub cbtorpos {
	local($fs, $bno) = @_;
	eval q(((($bno) *  &NSPF($fs) % ($fs)-> &fs_spc / ($fs)-> &fs_nsect * ($fs)-> &fs_trackskew + ($bno) *  &NSPF($fs) % ($fs)-> &fs_spc % ($fs)-> &fs_nsect * ($fs)-> &fs_interleave) % ($fs)-> &fs_nsect * ($fs)-> &fs_nrpos / ($fs)-> &fs_npsect));
    }
}
unless(defined(&blkoff)) {
    sub blkoff {
	local($fs, $loc) = @_;
	eval q((($loc) & ($fs)-> &fs_qbmask));
    }
}
unless(defined(&fragoff)) {
    sub fragoff {
	local($fs, $loc) = @_;
	eval q((($loc) & ($fs)-> &fs_qfmask));
    }
}
unless(defined(&lblktosize)) {
    sub lblktosize {
	local($fs, $blk) = @_;
	eval q((($blk) << ($fs)-> &fs_bshift));
    }
}
unless(defined(&lblkno)) {
    sub lblkno {
	local($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &fs_bshift));
    }
}
unless(defined(&numfrags)) {
    sub numfrags {
	local($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &fs_fshift));
    }
}
unless(defined(&blkroundup)) {
    sub blkroundup {
	local($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &fs_qbmask) & ($fs)-> &fs_bmask));
    }
}
unless(defined(&fragroundup)) {
    sub fragroundup {
	local($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &fs_qfmask) & ($fs)-> &fs_fmask));
    }
}
unless(defined(&fragstoblks)) {
    sub fragstoblks {
	local($fs, $frags) = @_;
	eval q((($frags) >> ($fs)-> &fs_fragshift));
    }
}
unless(defined(&blkstofrags)) {
    sub blkstofrags {
	local($fs, $blks) = @_;
	eval q((($blks) << ($fs)-> &fs_fragshift));
    }
}
unless(defined(&fragnum)) {
    sub fragnum {
	local($fs, $fsb) = @_;
	eval q((($fsb) & (($fs)-> &fs_frag - 1)));
    }
}
unless(defined(&blknum)) {
    sub blknum {
	local($fs, $fsb) = @_;
	eval q((($fsb) &~ (($fs)-> &fs_frag - 1)));
    }
}
unless(defined(&freespace)) {
    sub freespace {
	local($fs, $percentreserved) = @_;
	eval q(( &blkstofrags(($fs), ($fs)-> ($fs_cstotal->{cs_nbfree})) + ($fs)-> ($fs_cstotal->{cs_nffree}) - (($fs)-> &fs_dsize * ($percentreserved) / 100)));
    }
}
unless(defined(&blksize)) {
    sub blksize {
	local($fs, $ip, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR || ($ip)-> &i_ffs_size >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($ip)-> &i_ffs_size)))));
    }
}
unless(defined(&dblksize)) {
    sub dblksize {
	local($fs, $dip, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR || ($dip)-> &di_size >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($dip)-> &di_size)))));
    }
}
unless(defined(&sblksize)) {
    sub sblksize {
	local($fs, $size, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR || ($size) >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($size))))));
    }
}
unless(defined(&NSPB)) {
    sub NSPB {
	local($fs) = @_;
	eval q((($fs)-> &fs_nspf << ($fs)-> &fs_fragshift));
    }
}
unless(defined(&NSPF)) {
    sub NSPF {
	local($fs) = @_;
	eval q((($fs)-> &fs_nspf));
    }
}
unless(defined(&INOPB)) {
    sub INOPB {
	local($fs) = @_;
	eval q((($fs)-> &fs_inopb));
    }
}
unless(defined(&INOPF)) {
    sub INOPF {
	local($fs) = @_;
	eval q((($fs)-> &fs_inopb >> ($fs)-> &fs_fragshift));
    }
}
unless(defined(&NINDIR)) {
    sub NINDIR {
	local($fs) = @_;
	eval q((($fs)-> &fs_nindir));
    }
}
1;
