require '_h2ph_pre.ph';

unless(defined(&_SYS_MALLOC_H_)) {
    require 'sys/malloc.ph';
}
require 'sys/pool.ph';
require 'sys/queue.ph';
unless(defined(&MLEN)) {
    sub MLEN () {	( &MSIZE - $sizeof{'struct m_hdr'});}
}
unless(defined(&MHLEN)) {
    sub MHLEN () {	( &MLEN - $sizeof{'struct pkthdr'});}
}
unless(defined(&MINCLSIZE)) {
    sub MINCLSIZE () {	( &MHLEN + 1);}
}
unless(defined(&M_MAXCOMPRESS)) {
    sub M_MAXCOMPRESS () {	( &MHLEN / 2);}
}
unless(defined(&mtod)) {
    sub mtod {
	local($m,$t) = @_;
	eval q(((($m)-> &m_data)));
    }
}
if(defined(&DEBUG)) {
}
unless(defined(&m_next)) {
    sub m_next () {	 ($m_hdr->{mh_next});}
}
unless(defined(&m_len)) {
    sub m_len () {	 ($m_hdr->{mh_len});}
}
unless(defined(&m_data)) {
    sub m_data () {	 ($m_hdr->{mh_data});}
}
unless(defined(&m_type)) {
    sub m_type () {	 ($m_hdr->{mh_type});}
}
unless(defined(&m_flags)) {
    sub m_flags () {	 ($m_hdr->{mh_flags});}
}
unless(defined(&m_nextpkt)) {
    sub m_nextpkt () {	 ($m_hdr->{mh_nextpkt});}
}
unless(defined(&m_act)) {
    sub m_act () {	 &m_nextpkt;}
}
unless(defined(&m_pkthdr)) {
    sub m_pkthdr () {	 ($M_dat->{MH}->{MH_pkthdr});}
}
unless(defined(&m_ext)) {
    sub m_ext () {	 ($M_dat->{MH}->{MH_dat}->{MH_ext});}
}
unless(defined(&m_pktdat)) {
    sub m_pktdat () {	 ($M_dat->{MH}->{MH_dat}->{MH_databuf});}
}
unless(defined(&m_dat)) {
    sub m_dat () {	 ($M_dat->{M_databuf});}
}
unless(defined(&M_EXT)) {
    sub M_EXT () {	0x0001;}
}
unless(defined(&M_PKTHDR)) {
    sub M_PKTHDR () {	0x0002;}
}
unless(defined(&M_EOR)) {
    sub M_EOR () {	0x0004;}
}
unless(defined(&M_CLUSTER)) {
    sub M_CLUSTER () {	0x0008;}
}
unless(defined(&M_PROTO1)) {
    sub M_PROTO1 () {	0x0010;}
}
unless(defined(&M_BCAST)) {
    sub M_BCAST () {	0x0100;}
}
unless(defined(&M_MCAST)) {
    sub M_MCAST () {	0x0200;}
}
unless(defined(&M_CONF)) {
    sub M_CONF () {	0x0400;}
}
unless(defined(&M_AUTH)) {
    sub M_AUTH () {	0x0800;}
}
unless(defined(&M_COMP)) {
    sub M_COMP () {	0x1000;}
}
unless(defined(&M_AUTH_AH)) {
    sub M_AUTH_AH () {	0x2000;}
}
unless(defined(&M_IPV4_CSUM_OUT)) {
    sub M_IPV4_CSUM_OUT () {	0x0001;}
}
unless(defined(&M_TCPV4_CSUM_OUT)) {
    sub M_TCPV4_CSUM_OUT () {	0x0002;}
}
unless(defined(&M_UDPV4_CSUM_OUT)) {
    sub M_UDPV4_CSUM_OUT () {	0x0004;}
}
unless(defined(&M_IPV4_CSUM_IN_OK)) {
    sub M_IPV4_CSUM_IN_OK () {	0x0008;}
}
unless(defined(&M_IPV4_CSUM_IN_BAD)) {
    sub M_IPV4_CSUM_IN_BAD () {	0x0010;}
}
unless(defined(&M_TCP_CSUM_IN_OK)) {
    sub M_TCP_CSUM_IN_OK () {	0x0020;}
}
unless(defined(&M_TCP_CSUM_IN_BAD)) {
    sub M_TCP_CSUM_IN_BAD () {	0x0040;}
}
unless(defined(&M_UDP_CSUM_IN_OK)) {
    sub M_UDP_CSUM_IN_OK () {	0x0080;}
}
unless(defined(&M_UDP_CSUM_IN_BAD)) {
    sub M_UDP_CSUM_IN_BAD () {	0x0100;}
}
unless(defined(&M_ANYCAST6)) {
    sub M_ANYCAST6 () {	0x4000;}
}
unless(defined(&M_LOOP)) {
    sub M_LOOP () {	0x0040;}
}
unless(defined(&M_COPYFLAGS)) {
    sub M_COPYFLAGS () {	( &M_PKTHDR| &M_EOR| &M_PROTO1| &M_BCAST| &M_MCAST| &M_CONF| &M_AUTH| &M_COMP| &M_ANYCAST6| &M_LOOP);}
}
unless(defined(&MT_FREE)) {
    sub MT_FREE () {	0;}
}
unless(defined(&MT_DATA)) {
    sub MT_DATA () {	1;}
}
unless(defined(&MT_HEADER)) {
    sub MT_HEADER () {	2;}
}
unless(defined(&MT_SONAME)) {
    sub MT_SONAME () {	3;}
}
unless(defined(&MT_SOOPTS)) {
    sub MT_SOOPTS () {	4;}
}
unless(defined(&MT_FTABLE)) {
    sub MT_FTABLE () {	5;}
}
unless(defined(&MT_CONTROL)) {
    sub MT_CONTROL () {	6;}
}
unless(defined(&MT_OOBDATA)) {
    sub MT_OOBDATA () {	7;}
}
unless(defined(&M_DONTWAIT)) {
    sub M_DONTWAIT () {	 &M_NOWAIT;}
}
unless(defined(&M_WAIT)) {
    sub M_WAIT () {	 &M_WAITOK;}
}
unless(defined(&MBUFLOCK)) {
    sub MBUFLOCK {
	local($code) = @_;
	eval q({ 'int'  &ms =  &splimp(); { $code }  &splx( &ms); });
    }
}
unless(defined(&_MGET)) {
    sub _MGET {
	local($m, $how, $type) = @_;
	eval q( &do {  &MBUFLOCK( =  &pool_get( &mbpool, ==  &M_WAIT ?  &PR_WAITOK| &PR_LIMITFAIL : 0); );  &if { -> &m_type = ;  &MBUFLOCK( ($mbstat->{m_mtypes[$type]})++;) -> &m_next =  &NULL; -> &m_nextpkt =  &NULL; ($m)-> &m_data = ($m)-> &m_dat; ($m)-> &m_flags = 0; } }  &while( 0));
    }
}
if(defined(&SMALL_KERNEL)) {
    eval 'sub MGET {
        local($m, $how, $type) = @_;
	    eval q({ $m =  &_sk_mget($how, $type); });
    }' unless defined(&MGET);
} else {
    eval 'sub MGET {
        local($m, $how, $type) = @_;
	    eval q( &_MGET($m, $how, $type));
    }' unless defined(&MGET);
}
unless(defined(&_MGETHDR)) {
    sub _MGETHDR {
	local($m, $how, $type) = @_;
	eval q( &do {  &MBUFLOCK( =  &pool_get( &mbpool, ==  &M_WAIT ?  &PR_WAITOK| &PR_LIMITFAIL : 0); );  &if { -> &m_type = ;  &MBUFLOCK( ($mbstat->{m_mtypes[$type]})++;) -> &m_next =  &NULL; -> &m_nextpkt =  &NULL; ($m)-> &m_data = ($m)-> &m_pktdat; ($m)-> &m_flags =  &M_PKTHDR;  &SLIST_INIT(($m)-> ($m_pkthdr->{tags})); ($m)-> ($m_pkthdr->{csum}) = 0; } }  &while ( 0));
    }
}
if(defined(&SMALL_KERNEL)) {
    eval 'sub MGETHDR {
        local($m, $how, $type) = @_;
	    eval q({ $m =  &_sk_mgethdr($how, $type); });
    }' unless defined(&MGETHDR);
} else {
    eval 'sub MGETHDR {
        local($m, $how, $type) = @_;
	    eval q( &_MGETHDR($m, $how, $type));
    }' unless defined(&MGETHDR);
}
if(defined(&DEBUG)) {
    eval 'sub MCLREFDEBUGN {
        local($m, $file, $line) = @_;
	    eval q( &do { ($m)-> ($m_ext->{ext_nfile}) = ($file); ($m)-> ($m_ext->{ext_nline}) = ($line); }  &while ( 0));
    }' unless defined(&MCLREFDEBUGN);
    eval 'sub MCLREFDEBUGO {
        local($m, $file, $line) = @_;
	    eval q( &do { ($m)-> ($m_ext->{ext_ofile}) = ($file); ($m)-> ($m_ext->{ext_oline}) = ($line); }  &while ( 0));
    }' unless defined(&MCLREFDEBUGO);
} else {
    eval 'sub MCLREFDEBUGN {
        local($m, $file, $line) = @_;
	    eval q();
    }' unless defined(&MCLREFDEBUGN);
    eval 'sub MCLREFDEBUGO {
        local($m, $file, $line) = @_;
	    eval q();
    }' unless defined(&MCLREFDEBUGO);
}
unless(defined(&MCLBUFREF)) {
    sub MCLBUFREF {
	local($p) = @_;
	eval q();
    }
}
unless(defined(&MCLISREFERENCED)) {
    sub MCLISREFERENCED {
	local($m) = @_;
	eval q((($m)-> ($m_ext->{ext_nextref}) != ($m)));
    }
}
unless(defined(&_MCLDEREFERENCE)) {
    sub _MCLDEREFERENCE {
	local($m) = @_;
	eval q( &do { ($m)-> ($m_ext->{ext_nextref}->{m_ext}->{ext_prevref}) = ($m)-> ($m_ext->{ext_prevref}); ($m)-> ($m_ext->{ext_prevref}->{m_ext}->{ext_nextref}) = ($m)-> ($m_ext->{ext_nextref}); }  &while ( 0));
    }
}
unless(defined(&_MCLADDREFERENCE)) {
    sub _MCLADDREFERENCE {
	local($o, $n) = @_;
	eval q( &do { ($n)-> &m_flags |= (($o)-> &m_flags & ( &M_EXT| &M_CLUSTER)); ($n)-> ($m_ext->{ext_nextref}) = ($o)-> ($m_ext->{ext_nextref}); ($n)-> ($m_ext->{ext_prevref}) = ($o); ($o)-> ($m_ext->{ext_nextref}) = ($n); ($n)-> ($m_ext->{ext_nextref}->{m_ext}->{ext_prevref}) = ($n);  &MCLREFDEBUGN(($n),  &__FILE__,  &__LINE__); }  &while ( 0));
    }
}
unless(defined(&MCLINITREFERENCE)) {
    sub MCLINITREFERENCE {
	local($m) = @_;
	eval q( &do { ($m)-> ($m_ext->{ext_prevref}) = ($m); ($m)-> ($m_ext->{ext_nextref}) = ($m);  &MCLREFDEBUGO(($m),  &__FILE__,  &__LINE__);  &MCLREFDEBUGN(($m),  &NULL, 0); }  &while ( 0));
    }
}
unless(defined(&MCLADDREFERENCE)) {
    sub MCLADDREFERENCE {
	local($o, $n) = @_;
	eval q( &MBUFLOCK( &_MCLADDREFERENCE(($o), ($n));));
    }
}
unless(defined(&_MCLGET)) {
    sub _MCLGET {
	local($m, $how) = @_;
	eval q( &do {  &MBUFLOCK( ($m)-> ($m_ext->{ext_buf}) =  &pool_get( &mclpool, ($how) ==  &M_WAIT ? ( &PR_WAITOK| &PR_LIMITFAIL) : 0); );  &if (($m)-> ($m_ext->{ext_buf}) !=  &NULL) { ($m)-> &m_data = ($m)-> ($m_ext->{ext_buf}); ($m)-> &m_flags |=  &M_EXT| &M_CLUSTER; ($m)-> ($m_ext->{ext_size}) =  &MCLBYTES; ($m)-> ($m_ext->{ext_free}) =  &NULL; ($m)-> ($m_ext->{ext_arg}) =  &NULL;  &MCLINITREFERENCE($m); } }  &while ( 0));
    }
}
unless(defined(&MEXTMALLOC)) {
    sub MEXTMALLOC {
	local($m, $size, $how) = @_;
	eval q( &do { -> ($m_ext->{ext_buf}) =  &malloc(($size),  $mbtypes[($m)-> &m_type], ($how));  &if (($m)-> ($m_ext->{ext_buf}) !=  &NULL) { ($m)-> &m_data = ($m)-> ($m_ext->{ext_buf}); ($m)-> &m_flags |=  &M_EXT; ($m)-> &m_flags &= ~ &M_CLUSTER; ($m)-> ($m_ext->{ext_size}) = ($size); ($m)-> ($m_ext->{ext_free}) =  &NULL; ($m)-> ($m_ext->{ext_arg}) =  &NULL; ($m)-> ($m_ext->{ext_type}) =  $mbtypes[($m)-> &m_type];  &MCLINITREFERENCE($m); } }  &while ( 0));
    }
}
unless(defined(&MEXTADD)) {
    sub MEXTADD {
	local($m, $buf, $size, $type, $free, $arg) = @_;
	eval q( &do { -> &m_data = -> ($m_ext->{ext_buf}) = ($buf); ($m)-> &m_flags |=  &M_EXT; ($m)-> &m_flags &= ~ &M_CLUSTER; ($m)-> ($m_ext->{ext_size}) = ($size); ($m)-> ($m_ext->{ext_free}) = ($free); ($m)-> ($m_ext->{ext_arg}) = ($arg); ($m)-> ($m_ext->{ext_type}) = ($type);  &MCLINITREFERENCE($m); }  &while ( 0));
    }
}
unless(defined(&_MEXTREMOVE)) {
    sub _MEXTREMOVE {
	local($m) = @_;
	eval q( &do {  &if ( &MCLISREFERENCED($m)) {  &_MCLDEREFERENCE($m); }  &else  &if (($m)-> &m_flags &  &M_CLUSTER) {  &pool_put( &mclpool, ($m)-> ($m_ext->{ext_buf})); }  &else  &if (($m)-> ($m_ext->{ext_free})) { (*(($m)-> ($m_ext->{ext_free})))(($m)-> ($m_ext->{ext_buf}), ($m)-> ($m_ext->{ext_size}), ($m)-> ($m_ext->{ext_arg})); }  &else {  &free(($m)-> ($m_ext->{ext_buf}),($m)-> ($m_ext->{ext_type})); } ($m)-> &m_flags &= ~( &M_CLUSTER| &M_EXT); ($m)-> ($m_ext->{ext_size}) = 0; }  &while ( 0));
    }
}
unless(defined(&MEXTREMOVE)) {
    sub MEXTREMOVE {
	local($m) = @_;
	eval q( &MBUFLOCK( &_MEXTREMOVE(($m));));
    }
}
unless(defined(&MRESETDATA)) {
    sub MRESETDATA {
	local($m) = @_;
	eval q( &do {  &if (($m)-> &m_flags &  &M_EXT) ($m)-> &m_data = ($m)-> ($m_ext->{ext_buf});  &else  &if (($m)-> &m_flags &  &M_PKTHDR) ($m)-> &m_data = ($m)-> &m_pktdat;  &else ($m)-> &m_data = ($m)-> &m_dat; }  &while ( 0));
    }
}
if(defined(&SMALL_KERNEL)) {
    eval 'sub MCLGET {
        local($m, $how) = @_;
	    eval q( &_sk_mclget($m, $how));
    }' unless defined(&MCLGET);
} else {
    eval 'sub MCLGET {
        local($m, $how) = @_;
	    eval q( &_MCLGET($m, $how));
    }' unless defined(&MCLGET);
}
unless(defined(&MFREE)) {
    sub MFREE {
	local($m, $n) = @_;
	eval q( &MBUFLOCK(  ($mbstat->{m_mtypes[&(m)}->{m_type]})--;  &if (($m)-> &m_flags &  &M_PKTHDR)  &m_tag_delete_chain(($m),  &NULL);  &if (($m)-> &m_flags &  &M_EXT) {  &_MEXTREMOVE(($m)); } ($n) = ($m)-> &m_next;  &pool_put( &mbpool, ($m)); ));
    }
}
unless(defined(&M_MOVE_HDR)) {
    sub M_MOVE_HDR {
	local($to, $from) = @_;
	eval q({ ($to)-> &m_pkthdr = ($from)-> &m_pkthdr; ($from)-> &m_flags &= ~ &M_PKTHDR;  &SLIST_INIT(($from)-> ($m_pkthdr->{tags})); });
    }
}
unless(defined(&M_DUP_HDR)) {
    sub M_DUP_HDR {
	local($to, $from) = @_;
	eval q({ ($to)-> &m_pkthdr = ($from)-> &m_pkthdr;  &SLIST_INIT(($to)-> ($m_pkthdr->{tags}));  &m_tag_copy_chain(($to), ($from)); });
    }
}
unless(defined(&M_DUP_PKTHDR)) {
    sub M_DUP_PKTHDR {
	local($to, $from) = @_;
	eval q({ ($to)-> &m_flags = ($from)-> &m_flags &  &M_COPYFLAGS;  &M_DUP_HDR(($to), ($from)); ($to)-> &m_data = ($to)-> &m_pktdat; });
    }
}
unless(defined(&M_MOVE_PKTHDR)) {
    sub M_MOVE_PKTHDR {
	local($to, $from) = @_;
	eval q({ ($to)-> &m_flags = ($from)-> &m_flags &  &M_COPYFLAGS;  &M_MOVE_HDR(($to), ($from)); ($to)-> &m_data = ($to)-> &m_pktdat; });
    }
}
unless(defined(&M_ALIGN)) {
    sub M_ALIGN {
	local($m, $len) = @_;
	eval q({ ($m)-> &m_data += ( &MLEN - ($len)) &~ ($sizeof{'long'} - 1); });
    }
}
unless(defined(&MH_ALIGN)) {
    sub MH_ALIGN {
	local($m, $len) = @_;
	eval q({ ($m)-> &m_data += ( &MHLEN - ($len)) &~ ($sizeof{'long'} - 1); });
    }
}
unless(defined(&M_READONLY)) {
    sub M_READONLY {
	local($m) = @_;
	eval q(((($m)-> &m_flags &  &M_EXT) != 0 && ((($m)-> &m_flags &  &M_CLUSTER) == 0||  &MCLISREFERENCED($m))));
    }
}
unless(defined(&_M_LEADINGSPACE)) {
    sub _M_LEADINGSPACE {
	local($m) = @_;
	eval q((($m)-> &m_flags &  &M_EXT ? ($m)-> &m_data - ($m)-> ($m_ext->{ext_buf}) : ($m)-> &m_flags &  &M_PKTHDR ? ($m)-> &m_data - ($m)-> &m_pktdat : ($m)-> &m_data - ($m)-> &m_dat));
    }
}
unless(defined(&M_LEADINGSPACE)) {
    sub M_LEADINGSPACE {
	local($m) = @_;
	eval q(( &M_READONLY(($m)) ? 0:  &_M_LEADINGSPACE(($m))));
    }
}
unless(defined(&_M_TRAILINGSPACE)) {
    sub _M_TRAILINGSPACE {
	local($m) = @_;
	eval q((($m)-> &m_flags &  &M_EXT ? ($m)-> ($m_ext->{ext_buf}) + ($m)-> ($m_ext->{ext_size}) - (($m)-> &m_data + ($m)-> &m_len) : ($m)-> $m_dat[ &MLEN] - (($m)-> &m_data + ($m)-> &m_len)));
    }
}
unless(defined(&M_TRAILINGSPACE)) {
    sub M_TRAILINGSPACE {
	local($m) = @_;
	eval q(( &M_READONLY(($m)) ? 0:  &_M_TRAILINGSPACE(($m))));
    }
}
unless(defined(&M_PREPEND)) {
    sub M_PREPEND {
	local($m, $plen, $how) = @_;
	eval q({  &if ( &M_LEADINGSPACE($m) >= ($plen)) { ($m)-> &m_data -= ($plen); ($m)-> &m_len += ($plen); }  &else ($m) =  &m_prepend(($m), ($plen), ($how));  &if (($m)  && ($m)-> &m_flags &  &M_PKTHDR) ($m)-> ($m_pkthdr->{len}) += ($plen); });
    }
}
unless(defined(&MCHTYPE)) {
    sub MCHTYPE {
	local($m, $t) = @_;
	eval q({  &MBUFLOCK( ($mbstat->{m_mtypes[&(m)}->{m_type]})--;  ($mbstat->{m_mtypes[$t]})++;) ($m)-> &m_type = $t;});
    }
}
unless(defined(&M_COPYALL)) {
    sub M_COPYALL () {	1000000000;}
}
unless(defined(&m_copy)) {
    sub m_copy {
	local($m, $o, $l) = @_;
	eval q( &m_copym(($m), ($o), ($l),  &M_DONTWAIT));
    }
}
if(defined(&_KERNEL)) {
    eval 'sub PACKET_TAG_NONE () {0;}' unless defined(&PACKET_TAG_NONE);
    eval 'sub PACKET_TAG_IPSEC_IN_DONE () {1;}' unless defined(&PACKET_TAG_IPSEC_IN_DONE);
    eval 'sub PACKET_TAG_IPSEC_OUT_DONE () {2;}' unless defined(&PACKET_TAG_IPSEC_OUT_DONE);
    eval 'sub PACKET_TAG_IPSEC_IN_CRYPTO_DONE () {3;}' unless defined(&PACKET_TAG_IPSEC_IN_CRYPTO_DONE);
    eval 'sub PACKET_TAG_IPSEC_OUT_CRYPTO_NEEDED () {4;}' unless defined(&PACKET_TAG_IPSEC_OUT_CRYPTO_NEEDED);
    eval 'sub PACKET_TAG_IPSEC_IN_COULD_DO_CRYPTO () {5;}' unless defined(&PACKET_TAG_IPSEC_IN_COULD_DO_CRYPTO);
    eval 'sub PACKET_TAG_IPSEC_PENDING_TDB () {6;}' unless defined(&PACKET_TAG_IPSEC_PENDING_TDB);
    eval 'sub PACKET_TAG_BRIDGE () {7;}' unless defined(&PACKET_TAG_BRIDGE);
    eval 'sub PACKET_TAG_GIF () {8;}' unless defined(&PACKET_TAG_GIF);
    eval 'sub PACKET_TAG_GRE () {9;}' unless defined(&PACKET_TAG_GRE);
    eval 'sub PACKET_TAG_IN_PACKET_CHECKSUM () {10;}' unless defined(&PACKET_TAG_IN_PACKET_CHECKSUM);
    eval 'sub PACKET_TAG_PF_GENERATED () {11;}' unless defined(&PACKET_TAG_PF_GENERATED);
    eval 'sub PACKET_TAG_PF_ROUTED () {12;}' unless defined(&PACKET_TAG_PF_ROUTED);
    eval 'sub PACKET_TAG_PF_FRAGCACHE () {13;}' unless defined(&PACKET_TAG_PF_FRAGCACHE);
    if(defined(&MBTYPES)) {
    }
}
1;
