/* HP11 numeric limits */
#define MAXHP11 9.999999999E99
#define MINHP11 1E-99
#define MAXFACT 69.95757445

/* The different type of sto operations. The order must reflect the ordering of
  instruction codes in code.h */
enum StoTypes {sto, add, sub, mul, divi};

extern BOOL enabled, entering, overflow; /* Various flags related to the instructions */

/* Current entry value, used during number entry */
extern BOOL expo, decpt; /* expo true for an exponent present, decpt true for decimal point */
extern char strx[13], expx[4];

typedef void (*HP11Function)(void);

extern HP11Function insfunc[];

/* Function declarations */
/* ===================== */
double Check(double); /* Check the argument for HP11 limits (1e-99 --> 1e100),
   return adjusted value if out of limits */
void DISABLE(void); /* Disable stack */
void ENABLE(void); /* Enable stack */
void Enter(void); /* Do an "Enter" */
#define NEUTRAL() { entering = FALSE; } /* Neutral operation, simply end
 number entry */

/* Instructions */
void FIX(int); /* set display mode to FIX n */
void SCI(int);
void ENG(int);
void STO(int, enum StoTypes); /* Sto in reg n (0 <= n <= 21, with 20 = I, 21 = (i)),
 with desired operation */
void RCL(int); /* RCl, n same as for sto */
void EnterNum(int); /* Add keycode to current number */
void GTO(int); /* Goto label n (n = 0 to 9, A to E (10 to 14) or I (15) : indirection */
void SF(int), CF(int), Set(int);
void GSB(int); /* Call subprogram n (cf GTO) */
void GTOLine(int); /* Jump to line in prog */

#ifdef ABS
#undef ABS
#endif

void Sqrt(void), Exp(void), Exp10(void), ExpYX(void), Invert(void),
     Divide(void), SIN(void), COS(void), TAN(void), Times(void), Rdn(void),
     ExgXY(void), ENTER(void), Minus(void), SigmaPlus(void), Plus(void),
     Pi(void), ToRect(void), ClearSigma(void), ClearReg(void), Random(void),
     DoPerm(void), ToHMS(void), ToRAD(void), FRAC(void), Fact(void),
     Estimate(void), LinearRegression(void), Sqr(void), LN(void), LOG(void),
     Percent(void), DeltaPercent(void), ABS(void), DEG(void), RAD(void),
     GRAD(void), ArcSIN(void), ArcCOS(void), ArcTAN(void), ToPolar(void),
     Rup(void), CLX(void), LSTX(void), DoComb(void), ToH(void), ToDEG(void),
     INT(void), Mean(void), SDev(void), SigmaSub(void), HypSIN(void),
     HypCOS(void), HypTAN(void), ArcHypSIN(void), ArcHypCOS(void),
     ArcHypTAN(void), ExgXI(void), STORandom(void), RCLSigma(void), USER(void),
     ProgarmEntry(void), RunStart(void), XleY(void), Xlt0(void),
     DSE(void), ISG(void), XgtY(void), Xgt0(void), PSE(void), XneY(void),
     Xne0(void), XeqY(void), Xeq0(void), RTN(void), SST(void), BST(void),
     HP11ColdReset(void), MEM(void), PREFIX(void), RND(void), DoCHS(void),
     DoPoint(void), DoEEX(void), ExgXInd(void), ProgramEntry(void);

