#define MAXPROG 203 /* Max number of instructions */
#define MAXSTACK 4 /* The stack is 4 levels deep */

/* 2 pseudo-keys, which don't exist on the keyboard. They are used to force
  certain actions, and are generated by certain menu functions */
#define BRESET 40 /* Return to main program loop. Generated by New, Quit, Open */
#define BDISPLAY 41 /* Redisplay. Generated by Paste, Radix */

#define NUMKEYS 42

enum KeyTypes {Action, Instruction, Prefix, Invalid};
   /* Keyboard sequence are of 2 types: Actions & Instructions. The other types
     are for internal use in the keyboard routines. Instructions can  be incorporated
     into programs, while actions are immediately acted upon (eg enter program mode). */

struct Regs { /* The status of the HP11. This can be saved */
   double r[20]; /* The 20 storage registers */
   double x,y,z,t,l,i; /* The stack & the indirection register */
   enum {fix, sci, eng} mode; /* display mode */
   double _minfix; /* 10^-Digits in fixed mode to determine smallest displayable value */
   enum {deg, rad, grad} angles; /* Trigonometric mode */
   int digits; /* Number of digits for display mode */
   int user; /* User mode flags */
   WORD prog[MAXPROG + 1]; /* The program */
   int lastins; /* Last instruction used */
};

extern struct Regs hp11r; /* the current internal state */
extern int on, quit, running, fast, error, skip; /* various flags indicating the run mode ... */
extern int PC, retStack[MAXSTACK], retCnt; /* PC & return stack (4 levels) */
extern int Flags; /* the current flags */

/* Defines to easily access components of internal state */
#define X (hp11r.x)
#define Y (hp11r.y)
#define Z (hp11r.z)
#define T (hp11r.t)
#define L (hp11r.l)
#define I (hp11r.i)
#define R (hp11r.r)
#define Mode (hp11r.mode)
#define Angles (hp11r.angles)
#define Digits (hp11r.digits)
#define User (hp11r.user)
#define Prog (hp11r.prog)
#define lastIns (hp11r.lastins)
#define minfix (hp11r._minfix)

extern void ExecIns(int);

