// Was chars.c and chip.c and icon.c and indic.c


#include <exec/types.h>
#include <intuition/intuition.h>
#include <workbench/workbench.h>

UWORD  fData[] = {
   0x2000, 0x4000, 0xE000, 0x4000, 0x4000, 0x4000,
   0xDFFF, 0xBFFF, 0x1FFF, 0xBFFF, 0xBFFF, 0xBFFF
};
/*   X */
/*  X  */
/* XXX */
/*  X  */
/*  X  */
/*  X  */

UWORD  gData[] = {
   0x7000, 0x9000, 0x9000, 0x7000, 0x1000, 0xE000,
   0x8FFF, 0x6FFF, 0x6FFF, 0x8FFF, 0xEFFF, 0x1FFF
};
/*  XXX */
/* X  X */
/* X  X */
/*  XXX */
/*    X */
/* XXX	*/

UWORD  GData[] = {
   0x6000, 0x9000, 0x8000, 0xB000, 0x9000, 0x6000,
   0x9FFF, 0x6FFF, 0x7FFF, 0x4FFF, 0x6FFF, 0x9FFF
};
/*  XX	*/
/* X  X */
/* X	*/
/* X XX */
/* X  X */
/*  XX	*/

UWORD  RADData[] = {
   0xE338, 0x94A4, 0x94A4, 0xE7A4, 0xA4A4, 0x94B8,
   0x1CC7, 0x6B5B, 0x6B5B, 0x185B, 0x5B5B, 0x6B47
};
/* XXX	 XX  XXX  */
/* X  X X  X X	X */
/* X  X X  X X	X */
/* XXX	XXXX X	X */
/* X X	X  X X	X */
/* X  X X  X XXX  */

UWORD  PRGMData[] = {
   0xE719, 0x2000,  0x94A5, 0xE000,  0x94A1, 0x2000,  0xE72D, 0x2000,  0x8525, 0x2000,	0x8499, 0x2000,
   0x18E6, 0xDFFF,  0x6B5A, 0x1FFF,  0x6B5E, 0xDFFF,  0x18D2, 0xDFFF,  0x7ADA, 0xDFFF,	0x7B66, 0xDFFF
};
/* XXX	XXX   XX  X  X */
/* X  X X  X X	X XXXX */
/* X  X X  X X	  X  X */
/* XXX	XXX  X XX X  X */
/* X	X X  X	X X  X */
/* X	X  X  XX  X  X */

UWORD  USERData[] = {
   0x933D, 0xC000,  0x94A1, 0x2000,  0x9239, 0x2000,  0x9121, 0xC000,  0x94A1, 0x4000,	0x633D, 0x2000,
   0x6CC2, 0x3FFF,  0x6B5E, 0xDFFF,  0x6DC6, 0xDFFF,  0x6EDE, 0x3FFF,  0x6B5E, 0xBFFF,	0x9CC2, 0xDFFF
};

/* X  X  XX  XXXX XXX  */
/* X  X X  X X	  X  X */
/* X  X  X   XXX  X  X */
/* X  X   X  X	  XXX  */
/* X  X X  X X	  X X  */
/*  XX	 XX  XXXX X  X */



/* First the shape of the seven segments + point & comma.
  They are defined in a 14x13 box and are drawn by a series of lines.
  The offsets are relative to the top left corner of this box */
static WORD top[] = {
   4,0,
   10,0,
   9,1,
   5,1
};
static WORD ctr[] = {
   4,6,
   10,6,
   10,7,
   4,7,
};
static WORD bottom[] = {
   5,12,
   9,12,
   10,13,
   4,13
};
static WORD tl[] = {
   3,1,
   3,6,
   4,5,
   4,1
};
static WORD tr[] = {
   11,1,
   11,6,
   10,5,
   10,1
};
static WORD bl[] = {
   3,7,
   3,12,
   4,12,
   4,8
};
static WORD br[] = {
   11,7,
   11,12,
   10,12,
   10,8
};
static WORD pt[] = {
   -1,12,
   0,12,
   0,13,
   -1,13
};
static WORD com[] = {
   0,14,
   -1,14,
   -1,15,
   -2,15
};

/* Character definitions, they are composed of the seven segments */
static struct Border zero[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &zero[1] },
{ 0, 0, 1, 2, JAM1, 4, tl, &zero[2] },
{ 0, 0, 1, 2, JAM1, 4, tr, &zero[3] },
{ 0, 0, 1, 2, JAM1, 4, bl, &zero[4] },
{ 0, 0, 1, 2, JAM1, 4, br, &zero[5] },
{ 0, 0, 1, 2, JAM1, 4, bottom, NULL }
};
static struct Border one[] = {
{ 0, 0, 1, 2, JAM1, 4, tr, &one[1] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border two[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &two[1] },
{ 0, 0, 1, 2, JAM1, 4, tr, &two[2] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &two[3] },
{ 0, 0, 1, 2, JAM1, 4, bl, &two[4] },
{ 0, 0, 1, 2, JAM1, 4, bottom, NULL }
};
static struct Border three[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &three[1] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &three[2] },
{ 0, 0, 1, 2, JAM1, 4, bottom, &three[3] },
{ 0, 0, 1, 2, JAM1, 4, tr, &three[4] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border four[] = {
{ 0, 0, 1, 2, JAM1, 4, tr, &four[1] },
{ 0, 0, 1, 2, JAM1, 4, tl, &four[2] },
{ 0, 0, 1, 2, JAM1, 4, br, &four[3] },
{ 0, 0, 1, 2, JAM1, 4, ctr, NULL }
};
static struct Border five[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &five[1] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &five[2] },
{ 0, 0, 1, 2, JAM1, 4, bottom, &five[3] },
{ 0, 0, 1, 2, JAM1, 4, tl, &five[4] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border six[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &six[1] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &six[2] },
{ 0, 0, 1, 2, JAM1, 4, bottom, &six[3] },
{ 0, 0, 1, 2, JAM1, 4, tl, &six[4] },
{ 0, 0, 1, 2, JAM1, 4, bl, &six[5] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border seven[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &seven[1] },
{ 0, 0, 1, 2, JAM1, 4, tr, &seven[2] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border eight[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &eight[1] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &eight[2] },
{ 0, 0, 1, 2, JAM1, 4, bottom, &eight[3] },
{ 0, 0, 1, 2, JAM1, 4, tl, &eight[4] },
{ 0, 0, 1, 2, JAM1, 4, tr, &eight[5] },
{ 0, 0, 1, 2, JAM1, 4, bl, &eight[6] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border nine[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &nine[1] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &nine[2] },
{ 0, 0, 1, 2, JAM1, 4, bottom, &nine[3] },
{ 0, 0, 1, 2, JAM1, 4, tl, &nine[4] },
{ 0, 0, 1, 2, JAM1, 4, tr, &nine[5] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border minus[] = {
{ 0, 0, 1, 2, JAM1, 4, ctr, NULL }
};
static struct Border E[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &E[1] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &E[2] },
{ 0, 0, 1, 2, JAM1, 4, bottom, &E[3] },
{ 0, 0, 1, 2, JAM1, 4, tl, &E[4] },
{ 0, 0, 1, 2, JAM1, 4, bl, NULL }
};
static struct Border r[] = {
{ 0, 0, 1, 2, JAM1, 4, ctr, &r[1] },
{ 0, 0, 1, 2, JAM1, 4, bl, NULL }
};
static struct Border o[] = {
{ 0, 0, 1, 2, JAM1, 4, ctr, &o[1] },
{ 0, 0, 1, 2, JAM1, 4, bottom, &o[2] },
{ 0, 0, 1, 2, JAM1, 4, bl, &o[3] },
{ 0, 0, 1, 2, JAM1, 4, br, NULL }
};
static struct Border R[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &R[1] },
{ 0, 0, 1, 2, JAM1, 4, tl, NULL }
};
static struct Border u[] = {
{ 0, 0, 1, 2, JAM1, 4, tl, &u[1] },
{ 0, 0, 1, 2, JAM1, 4, tr, &u[2] },
{ 0, 0, 1, 2, JAM1, 4, ctr, NULL }
};
static struct Border n[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &n[1] },
{ 0, 0, 1, 2, JAM1, 4, tl, &n[2] },
{ 0, 0, 1, 2, JAM1, 4, tr, NULL },
};
static struct Border i[] = {
{ 0, 0, 1, 2, JAM1, 4, tr, NULL },
};
static struct Border point[] = {
{ 0, 0, 1, 2, JAM1, 4, pt, NULL },
};
static struct Border comma[] = {
{ 0, 0, 1, 2, JAM1, 4, pt, &comma[1] },
{ 0, 0, 1, 2, JAM1, 4, com, NULL }
};
static struct Border P[] = {
{ 0, 0, 1, 2, JAM1, 4, top, &P[1] },
{ 0, 0, 1, 2, JAM1, 4, ctr, &P[2] },
{ 0, 0, 1, 2, JAM1, 4, tr, &P[3] },
{ 0, 0, 1, 2, JAM1, 4, tl, &P[4] },
{ 0, 0, 1, 2, JAM1, 4, bl, NULL }
};

/* The character array, visible to the exterior */
struct Border *hp11char[] = {
  zero, one, two, three, four, five, six, seven, eight, nine,
  minus, E, r, o, R, u, n, i, nine /* g */, point, comma, P };


// These are the structures which define the shape of the indicators. The

struct Image fImage = {
   0, 0, /* Position */
   3, 6, 2, /* width, height, depth */
   fData, /* Shape data */
   0, 0, /* PlanePick, PlaneOnOff, defined by SetCol */
   NULL /* NextImage */
};

struct Image gImage = {
   0, 1,
   4, 6, 2,
   gData,
   0, 0,
   NULL
};

struct Image GImage = {
   0, 0,
   4, 6, 2,
   GData,
   0, 0,
   NULL
};

struct Image RADImage = {
   0, 0,
   14, 6, 2,
   RADData,
   0, 0,
   NULL
};

struct Image PRGMImage = {
   0, 0,
   19, 6, 2,
   PRGMData,
   0, 0,
   NULL
};

struct Image USERImage = {
   0, 0,
   19, 6, 2,
   USERData,
   0, 0,
   NULL
};
