/* Instruction codes */

/* Unshifted codes */
#define KMAIN		(0)
#define KSQRT		(KMAIN + 0)
#define KEXP		(KMAIN + 1)
#define KEXP10		(KMAIN + 2)
#define KEXP_YX 	(KMAIN + 3)
#define KINV		(KMAIN + 4)
#define KCHS		(KMAIN + 5)
#define KDIV		(KMAIN + 6)
#define KTRIG		(KMAIN + 7)
#define KEEX		(KMAIN + 10)
#define KMUL		(KMAIN + 11)
#define KR_S		(KMAIN + 12)
#define KRDN		(KMAIN + 13)
#define KEXG_XY 	(KMAIN + 14)
#define KENTER		(KMAIN + 15)
#define KSUB		(KMAIN + 16)
#define KPOINT		(KMAIN + 17)
#define KSIGMA_PLUS	(KMAIN + 18)
#define KPLUS		(KMAIN + 19)

/* f codes */
#define KF		(KMAIN + 20)
#define KPI		(KF + 0)
#define KX_LE_Y 	(KF + 1)
#define KEXG_X_IND	(KF + 2)
#define KRECT		(KF + 3)
#define KEXG_XI 	(KF + 4)
#define KDSE		(KF + 5)
#define KISG		(KF + 6)
#define KX_GT_Y 	(KF + 7)
#define KPSE		(KF + 8)
#define KCLR_SIGMA	(KF + 9)
#define KCLR_REG	(KF + 10)
#define KRANDOM 	(KF + 11)
#define KPERM		(KF + 12)
#define KHMS		(KF + 13)
#define KTO_RAD 	(KF + 14)
#define KX_NE_Y 	(KF + 15)
#define KFRAC		(KF + 16)
#define KFACT		(KF + 17)
#define KESTIMATE	(KF + 18)
#define KLR		(KF + 19)
#define KX_EQ_Y 	(KF + 20)

/* g codes */
#define KG		(KF + 21)
#define KSQR		(KG + 0)
#define KLN		(KG + 1)
#define KLOG		(KG + 2)
#define KPERC		(KG + 3)
#define KDELTA_PERC	(KG + 4)
#define KABS		(KG + 5)
#define KDEG		(KG + 6)
#define KRAD		(KG + 7)
#define KGRD		(KG + 8)
#define KX_LT_0 	(KG + 9)
#define KARC		(KG + 10)
#define KPOLAR		(KG + 13)
#define KX_GT_0 	(KG + 14)
#define KRTN		(KG + 15)
#define KRUP		(KG + 16)
#define KRND		(KG + 17)
#define KCLX		(KG + 18)
#define KLSTX		(KG + 19)
#define KCOMB		(KG + 20)
#define KHR		(KG + 21)
#define KTO_DEG 	(KG + 22)
#define KX_NE_0 	(KG + 23)
#define KINT		(KG + 24)
#define KMEAN		(KG + 25)
#define KSDEV		(KG + 26)
#define KSIGMA_SUB	(KG + 27)
#define KX_EQ_0 	(KG + 28)

/* Miscellaneous codes */
#define KSTO_RANDOM	(KG + 29)
#define KRCL_SIGMA	(KG + 30)
#define KHYP		(KG + 31)
#define KARCHYP 	(KHYP + 3)

/* Start of complex codes (dealt with differently in execution routine) */
#define KCOMPLEX	(KARCHYP + 3)

/* Flags */
#define KFLAGS		(KCOMPLEX)

/* Numeric codes */
#define KFIG		(KFLAGS + 6)

/* display codes */
#define KFIX		(KFIG + 10)
#define KSCI		(KFIX + 10)
#define KENG		(KSCI + 8)

/* GTO, GSB, LBL codes */
#define KLBL		(KENG + 8)
#define KGTO		(KLBL + 15)
#define KGSB		(KGTO + 16)

/* STO & RCL codes */
#define KSTO		(KGSB + 16)
#define KRCL		(KSTO + 110)


/* Offsets used by various codes */
#define OSIN 0
#define OCOS 1
#define OTAN 2
#define OSF 0
#define OCF 2
#define OSET 4
#define OA 10
#define OB 11
#define OC 12
#define OD 13
#define OE 14
#define OIND_G 15
#define OI 20
#define OIND_R 21
#define OPLUS 22
#define OSUB 44
#define OMUL 66
#define ODIV 88


/* Immediate action codes */
#define ISST		0
#define ICLR_PRGM	1
#define ICLR_PREFIX	2
#define IUSER		3
#define IBST		4
#define IP_R		5
#define IMEM		6
#define ION		7
#define IBACK		8
#define IRESET		9
#define IDISPLAY	10
#define IGTO_LINE	100
