/* These are the computer specific routines which must be rewritten on a
  different computer */
void AmigaCleanUp(void); /* CleanUp before exiting, eg make the hp11 disappear,
  deallocate any memory it took ... This is called by the main CleanUp routine */

BOOL AmigaInit(int, APTR); /* Prepare the HP11 for use (eg display it). This is called
  by the main Init routine */

void Display(char *); /* Display the argument in the display.
  Valid chars are 0..9 . , - E r o R u n i g
  Any other chars are displayed as a space, . & , take no space in the
  display (which is 11 chars long). */

int PollKey(int); /* Read a key from the HP11 keyboard.
  if the argument is TRUE, wait for one to be pressed otherwise return -1 if
  none is yet available.
  The value returned is from 0 to 39 (-1 for no key) */

/* Display the various indicators : TRUE to display, FALSE to erase */
void Dispf(int), Dispg(int), DispUSER(int), DispG(int),
	 DispRAD(int), DispPRGM(int);

BOOL RelKey(void); /* Wait for the latest key (read by PollKey) to be released */

/* Enable/Disable any clipboard style editing facilities (if provided) */
void EditOn(void), EditOff(void);

/* Provide only if you want seomething special to happen while the HP11 is
  off. There is a default version in hp11.c */
void sleep(void);

/* These routines are actually in menus.c */
void MenusOn(void), MenusOff(void);
int MenuHandler(UWORD number);
void Message(STRPTR txt);
void LoadProg(void);
void MenuCleanUp (void);
BOOL MenuInit(void);


