#if defined(__amigaos4__)
#  define __USE_INLINE__  // Convert to OS4 function structure
#  define __NOLIBBASE__
#endif

#include <proto/exec.h>
#include <proto/graphics.h>
#include <proto/intuition.h>
#include <proto/timer.h>
#include <proto/dos.h>
#include <proto/gadtools.h>
#include <proto/wb.h>
#include <proto/icon.h>

#include <string.h>
#include <ctype.h>

#if defined(__AROS__)
#  include <stdio.h>
#  include <workbench/startup.h>
#else
#  include <dos.h>
#endif

#include "hp11.h"
#include "internal.h"
#include "amiga.h"

#define MAXWIDTH 29 /* X distance between 2 keys */
#define MAXHEIGHT 29 /* Y distance bewteen 2 keys */
#define KEYWIDTH 20 /* Width of actual key */
#define KEYHEIGHT 16 /* Height of actual key */
#define TOPKEYHEIGHT 9 /* Height of top of key */
#define KEYX (19 + HP11X) /* Position of first key */
#define KEYY (61 + HP11Y)
#define CHAROFFX -1 /* offset in display for first char */
#define CHAROFFY 3
#define CHARWIDTH 14 /* Size of char */
#define CHARHEIGHT 13
#define SCRX0 (53 + HP11X) /* Limits of display for chars */
#define SCRX1 (208 + HP11X)
#define SCRY0 (11 + HP11Y)
#define SCRY1 (37 + HP11Y)
#define fX (SCRX0 + 3 * CHARWIDTH + 2) /* Position of indicators */
#define gX (SCRX0 + 4 * CHARWIDTH - 1)
#define GX (SCRX0 + (int)(6.5 * CHARWIDTH))
#define RADX (GX + 5)
#define PRGMX (SCRX0 + 10 * CHARWIDTH - 6)
#define USERX (SCRX0 + CHARWIDTH)
#define INDICY (SCRY0 + 19)

#define CR 13
#define BS 8
#define ESC 27

#define COPY 0xc0 /* minterm for straight copy */


struct Library *TimerBase; /* Base for calling timer routines */
struct TimerIFace *ITimer;

extern struct Border *hp11char[]; /* Character descriptions (as connected lines) */
/* Indicator shapes (as bitmaps) */
extern struct Image fImage, gImage, USERImage, GImage, RADImage, PRGMImage;

struct Library *GadToolsBase;
struct GadToolsIFace *IGadTools;

/* Using -lauto to set up main libraries */

struct Window *hp11; /* The window containing the hp11 */
struct BitMap hp11bitmap;  /* The image for the main window*/

BOOL	 icons_on      = TRUE;
static ULONG		clip	      = 0;


/* These informations are for RelKey() */
/* The method by which the latest key was obtained :
  From the menus, from the CLOSE gadget, from the keyboard, or by selecting with the mouse */
static enum {menu, gadget, keyboard, mouse} keytype;
/* The keycode of the last key read */
static short lastkey;
/* The Time at which the last key was read */
static ULONG secs, micros;
/* Path to executable */
char *hp11name;
char hp11path[PATHLEN];

static struct timerequest *timer; /* The timer which is used */

/// mygetpath
// char *mygetpath(char *to, BPTR l)
char *mygetpath(char *to, BPTR l)
{
	BPTR tl;
	int notfirst = FALSE;
	char buf[PATHLEN];
	struct FileInfoBlock *fib = (struct FileInfoBlock *)AllocMem(sizeof(struct FileInfoBlock), 0);

   if (!fib) return(NULL);
   to[0] = '\0';

   do {
	  if (!Examine(l, fib)) return(NULL);

	  if (fib->fib_FileName[0] == '\0')
			strcat(to, "RAM");
	  else
		{
			strcpy(buf,to);
			strcpy(to,fib->fib_FileName);
			if (fib->fib_DirEntryType > 0) strcat(to,"/");
			strcat(to,buf);
		}

	  tl = l;
	  l = ParentDir(l);
	  if (notfirst) UnLock(tl);
	  notfirst = TRUE;
   } while (l);

   *(strchr(to, '/')) = ':';
   FreeMem((char *)fib, sizeof(struct FileInfoBlock));
   return(to);
}
///
///split
void split(char *file, char *path, char **name)
{
   int l = strlen(file);

   *name = file + l;
   while (--l >= 0 && (*--*name != '/' && **name != ':'))
   ;     // do until conditions are satisfied
   if (l < 0)
	  path[0] = '\0';
   else
   {
	  ++*name;
	  strncpy(path, file, l + 1 );
	  path[l+1 ] = '\0';
   }
}
///
/// Delete a timer
static void DeleteTimer(struct timerequest *tr)
{
   TimerBase = (struct Library *)(-1); /* Don't call any more ! */

   if (tr != NULL)
   {
	  /* Remove the port */
	  if (tr->tr_node.io_Message.mn_ReplyPort)
			DeleteMsgPort(tr->tr_node.io_Message.mn_ReplyPort);
#if defined(__amigaos4__)
	  DropInterface((struct Interface *)ITimer);   // OS4
#endif
	  CloseDevice((struct IORequest *)tr); /* Close the device */
	  DeleteIORequest((struct IORequest *)tr); // Free the IO Request
   }
}
///
/// Create a timer of type unit
static
struct timerequest *CreateTimer(ULONG unit)
{
   register long error;

   register struct MsgPort *timerport;
   register struct timerequest *timermsg;

   if ((timerport = CreateMsgPort()) == NULL) /* first get a port */
	  return(NULL); /* failed */

   if ((timermsg = (struct timerequest *) /* Then create an IO request for the timer */
			CreateIORequest(timerport, sizeof(struct timerequest))) == NULL)
	  return(NULL); /* failed */

   if ((error = OpenDevice(TIMERNAME, unit, (struct IORequest *)timermsg, 0)) != 0) /* Finally, open the timer device */
   { /* failed */
	  DeleteTimer(timermsg);
	  return(NULL);
   }

	TimerBase = (struct Library *)timermsg->tr_node.io_Device; /* Allow calls to the time arithmetic routines */
#if defined(__amigaos4__)
	ITimer =  (struct TimerIFace *)GetInterface(TimerBase, "main", 1, NULL);
#endif
   return(timermsg);
}
///
/// Wait for a specified duration
static void WaitFor(struct timeval *tv)
{
   timer->tr_node.io_Command = TR_ADDREQUEST;

   timer->tr_time = *tv;

   DoIO((struct IORequest *)timer); /* Wait for completion of request */
}
///
/// Reverse the key on the keyboard (as if user was holding it down)
static void ReverseKey(int key)
{
   register int kx, ky, h;

   if (key == 30) h = KEYHEIGHT - 1; /* ON, higher than average */
   else if (key == 25) h = MAXHEIGHT + TOPKEYHEIGHT - 1; /* ENTER, even taller */
   else h = TOPKEYHEIGHT - 1;

/* -------------------- */
/* Check for bug when using short int */

   kx = (key % 10) * MAXWIDTH + KEYX; /* Calc. key position */
   ky = (key / 10) * MAXHEIGHT + KEYY;

   SetDrMd(hp11->RPort, COMPLEMENT); /* Draw in reverse */
   RectFill(hp11->RPort, (long)kx, (long)ky, (long)(kx + (KEYWIDTH - 1)), (long)(ky + h));
}
///
/// From positions x & y, deduce which key was pressed
static int DecodeKey(int x, int y)
{
   register int kx, ky, px, py;

   kx = (x - KEYX) / MAXWIDTH; px = (x - KEYX) % MAXWIDTH;
   ky = (y - KEYY) / MAXHEIGHT; py = (y - KEYY) % MAXHEIGHT;

   if (/* first, check if in keyboard. x & y are tested (instead of kx, ky)
	  because kx & ky suffer a roundoff towards zero for negative values */
	   (x >= KEYX && y >= KEYY && kx <= 9 && ky <= 3)
	   &&
	  /* now the condition on width */
	   (px < KEYWIDTH && px >= 0) /* same for all keys */
	   &&
	 /* condition on height, 2 cases for ENTER is different */
	   (
	   (kx == 5 && (ky == 2 || (ky == 3 && py < KEYHEIGHT) && (ky = 2))) /* ENTER, set ky to correct value when ky == 3 */
	   || /* condition on height */
	   (py < KEYHEIGHT && py >= 0)
	   )
	  ) return(ky * 10 + kx);
   else return(-1);
}
///
/// Mouse was pressed at x,y. Is this a key ?
static int GetMouseKey(int x, int y)
{
   int key;

   if ((key = DecodeKey(x, y)) != -1) { /* yes */
	  ReverseKey(key);
	  keytype = mouse; /* info for RelKey() */
   }
   return(key);
}
///
/// Key keycode was pressed by the user
static int GetKeyKey(int _keycode)
{
   register int key = -1, keycode = tolower(_keycode);

   switch (keycode)
   {
	  case ESC: key = 30; break;
	  case '7': case '8': case '9': key = keycode - ('7' - 6); break;
	  case '4': case '5': case '6': key = keycode - ('4' - 16); break;
	  case '1': case '2': case '3': key = keycode - ('1' - 26); break;
	  case '0': key = 36; break;
	  case '.': key = 37; break;
	  case '^': key =  3; break;
	  case '*': key = 19; break;
	  case '-': key = 29; break;
	  case '+': key = 39; break;
	  case '/': key =  9; break;
	  case '_': key =  5; break;
	  case CR : key = 25; break;
	  case 'f': key = 31; break;
	  case 'g': key = 32; break;
	  case BS : key = 24; break;
	  case 's': key = 12; break;
	  case 'c': key = 13; break;
	  case 't': key = 14; break;
   }
   if (key != -1)
   { /* A valid key was given */
	  ReverseKey(key);
	  keytype = keyboard; /* for RelKey() */
   }
   return(key);
}
///
/// Get a key from the keyboard with/without waiting
int PollKey(int wait)
{
   register int key;
   register struct IntuiMessage *msg;
   register ULONG _class;
   register UWORD code;
   register WORD x, y;
   register APTR address;

   key = -1; /* no key yet */
   do {
	  if (wait) WaitPort(hp11->UserPort); /* No active waits in multi-tasking ! */
	  msg = (struct IntuiMessage *)GetMsg(hp11->UserPort); /* Get the message if there is one */
	  if (msg) { /* yes, there is */
	 /* Copy relevant information */
	 _class = msg->Class;
	 code = msg->Code;
//	   address = msg->IAddress;  // NOT USED
	 x = msg->MouseX;
	 y = msg->MouseY;
	 secs = msg->Seconds;
	 micros = msg->Micros;
	 ReplyMsg((struct Message *)msg); /* & reply to it */

	 switch (_class) { /* type of message */
	    case IDCMP_CLOSEWINDOW: /* Window closed = Quit */
	       quit = TRUE;
	       key = BRESET;
	       keytype = gadget;
	       break;
	    case IDCMP_MOUSEBUTTONS: /* A mouse button was pressed */
	       if (code == SELECTDOWN)
		  key = GetMouseKey(x, y);
	       break;
	    case IDCMP_VANILLAKEY: /* a key was pressed */
	       key = GetKeyKey(code);
	       break;
	    case IDCMP_MENUPICK: /* A menu option was chosen */
			key = MenuHandler(code); /* Call menu handler */
			keytype = menu; /* for RelKey() */
	       break;
	 }
	  }
   } while (key == -1 && (msg || wait));
   /* Exit if key read or, if not waiting, no message ready */

   lastkey = key; /* save key for RelKey() */
   return(key);
}
///
/// Wait for latest key to be released, returns true if button released
//  over key (valid only for mouse)
BOOL RelKey(void)
{
   register WORD x, y;
   register BOOL Released;
   register struct IntuiMessage *msg;
   struct timeval event, now, delay;
   register int key = lastkey; /* key last pressed */

   lastkey = -1; /* Only release it once ! */

   if (key != -1)
	  switch (keytype)
	  {

	 case keyboard: /* Key reversed for a max of .08 secs
	    (There is no easy way to wait for its release on the keyboard) */
	    event.tv_secs = secs; event.tv_micro = micros;
	    GetSysTime(&now);
	    SubTime(&now, &event); /* Time elapsed since key pressed */
	    delay.tv_secs = 0; delay.tv_micro = 80000;
		if (CmpTime(&now, &delay) == 1)
		{ /* now < delay */
	       SubTime(&delay, &now);
		   WaitFor(&delay); /* Wait long enough */
	    }
	    ReverseKey(key); /* un-reverse key */
	    return(TRUE);

	 case mouse:
	    Released = FALSE;
		do
		{ /* Wait for mouse button to be released */
	       WaitPort(hp11->UserPort);
	       msg = (struct IntuiMessage *)GetMsg(hp11->UserPort);
	       x = msg->MouseX;
	       y = msg->MouseY;
	       Released = (msg->Class == IDCMP_MOUSEBUTTONS && msg->Code == SELECTUP);
	       ReplyMsg((struct Message *)msg);
	    } while (!Released);
	    ReverseKey(key); /* un-reverse key */

	    return((BOOL)(DecodeKey(x, y) == key)); /* Button released over key? */
	  }
   return(TRUE); /* if already released */
}
///
/// Open Window
BOOL OpenWin (LONG x, LONG y)

{
	  /* Get screeninfo */
	    struct Screen *MyScreen;
		MyScreen=LockPubScreen(0);
		UnlockPubScreen(NULL,MyScreen);

	if (y < MyScreen->BarHeight + MyScreen->BarVBorder)
		y = MyScreen->BarHeight + MyScreen->BarVBorder;


   /* Open the window - now use tags and Activate window on startup */

	if (!(hp11=OpenWindowTags(NULL,
	WA_Title, "HP11C",
	WA_InnerWidth, HP11WIDTH,
	WA_InnerHeight, HP11HEIGHT,
	WA_Top, y,
	WA_Left, x,
	WA_Activate, TRUE,
	WA_NewLookMenus, TRUE,
	WA_DragBar, TRUE,
	WA_CloseGadget, TRUE,
	WA_DepthGadget, TRUE,
	WA_SmartRefresh, TRUE,
	WA_NoCareRefresh, TRUE,
	WA_IDCMP, IDCMP_CLOSEWINDOW | IDCMP_MOUSEBUTTONS |
				IDCMP_VANILLAKEY | IDCMP_MENUPICK,
	TAG_DONE)))
	{
		Message("Can't open window");
		return (FALSE);
	}
   /* Move picture into window */
   BltBitMapRastPort(&hp11bitmap, 0, 0, hp11->RPort, HP11X, HP11Y, HP11WIDTH, HP11HEIGHT, COPY);
   return TRUE;
}

///
/// Amiga specific initialisation
#define argw ((struct WBStartup *)argv)
BOOL AmigaInit(int argc, APTR argv)
{
   BPTR hp11dir, old;

/*  use -lauto flag which sets up most libraries
	except for those below */

  if (!(GadToolsBase = OpenLibrary("gadtools.library", 40)))
	  return(FALSE);
#if defined(__amigaos4__)
   if (!(IGadTools = (struct GadToolsIFace *) GetInterface(GadToolsBase, "main", 1, NULL)))
	  return(FALSE);
#endif

   /* Get path to command from WB */
   if (argc == 0) /* WB */
   {
	  old = CurrentDir(argw->sm_ArgList[0].wa_Lock);
	  split(argw->sm_ArgList[0].wa_Name, hp11path, &hp11name);
	  CurrentDir(old);
   }
   else
   { /* CLI */
	  split(((char **)argv)[0], hp11path, &hp11name);
	}

	/* Find path to Command	 */
	  hp11dir = Lock(hp11path, ACCESS_READ);
	  if (!mygetpath(hp11path, hp11dir)) hp11path[0] = '\0';
	  UnLock(hp11dir);

  InitBitMap(&hp11bitmap, 2, HP11WIDTH, HP11HEIGHT);
  hp11bitmap.Planes[0] = (STRPTR) pic_data;
  hp11bitmap.Planes[1] = (STRPTR) pic_data + hp11bitmap.BytesPerRow *
  			 hp11bitmap.Rows;

	if(!OpenWin(10,10))   // Openwin(x,y)
	return FALSE;


   /* Create timer */ 
	if ((timer = CreateTimer(UNIT_MICROHZ)) == NULL)
		return(FALSE);

  if(!(clip = CBOpen(0)))
	return FALSE;

  sprintf(filename,"Program.HP11"); // Default value for later

  if(argc != 0) /* CLI */
  {
	icons_on = FALSE;     /* by default, no icons from cli */
	if(argc > 1)
	{ /* argument */
	  strcpy(filename, ((char **)argv)[1]);
	  LoadProg();
	}
  }
  else if (((struct WBStartup *)argv)->sm_NumArgs > 1)
  { /* workbench, with argument */
	if(NameFromLock((((struct WBStartup *)argv)->sm_ArgList[1]).wa_Lock,
	filename, FILENAMESIZE))
	{
	  AddPart(filename, (((struct WBStartup *)argv)->sm_ArgList[1]).wa_Name,
	  FILENAMESIZE);
	  LoadProg();
	}
  }


   /* Init menus */    
	return(MenuInit());
}
#undef argw
///
/// Amiga CleanUp
void AmigaCleanUp(void)
{
	if (clip)		CBClose();

	if (hp11)
	{
		MenusOff();
		CloseWindow(hp11);
	}
	MenuCleanUp();
	if(timer)	  DeleteTimer(timer); /* Close timer */
}
///
/// Display s
void Display(s)
register char *s;
{
   register int posx;
   register int chr;
   register struct RastPort *rport = hp11->RPort;

   /* Clear display */
   SetDrMd(rport, JAM1); SetAPen(rport, 2);
   RectFill(rport, SCRX0 + 1, SCRY0, SCRX1 - 1, SCRY1);

   /* Initial position */
   posx = SCRX0 + CHAROFFX;

   while (*s) {
	  switch (*s)
	{ /* Position of char in char array */
	 case '0': case '1': case '2': case '3': case '4': case '5': case '6':
	 case '7': case '8': case '9': chr = *s - '0'; break;
	 case '-': chr = 10; break;
	 case 'E': chr = 11; break;
	 case 'r': chr = 12; break;
	 case 'o': chr = 13; break;
	 case 'R': chr = 14; break;
	 case 'u': chr = 15; break;
	 case 'n': chr = 16; break;
	 case 'i': chr = 17; break;
	 case 'g': chr = 18; break;
	 case '.': chr = 19; break;
	 case ',': chr = 20; break;
	 case 'P': chr = 21; break;
	 default:  chr = -1; break;
	}
	  if (chr != -1)
		DrawBorder(rport, hp11char[chr], (long)posx, SCRY0 + CHAROFFY);

	  if (*s != '.' && *s != ',') posx += CHARWIDTH;

	  s++;
   }
}
///
/// Set image to be drawn/erased according to on
static void SetCol(struct Image *im, int on)
{
   if (on) {
	  im->PlanePick = 3;
	  im->PlaneOnOff = 0;
   }
   else {
	  im->PlanePick = 0;
	  im->PlaneOnOff = 2;
   }
}
///
/// Display the indicators
void Dispf(int on)
{
   SetCol(&fImage, on);
   DrawImage(hp11->RPort, &fImage, fX, INDICY);
}

void Dispg(int on)
{
   SetCol(&gImage, on);
   DrawImage(hp11->RPort, &gImage, gX, INDICY);
}

void DispUSER(int on)
{
   SetCol(&USERImage, on);
   DrawImage(hp11->RPort, &USERImage, USERX, INDICY);
}

void DispG(int on)
{
   SetCol(&GImage, on);
   DrawImage(hp11->RPort, &GImage, GX, INDICY);
}

void DispRAD(int on)
{
   SetCol(&RADImage, on);
   DrawImage(hp11->RPort, &RADImage, RADX, INDICY);
}

void DispPRGM(int on)
{
   SetCol(&PRGMImage, on);
   DrawImage(hp11->RPort, &PRGMImage, PRGMX, INDICY);
}
void beep(void)
{
   DisplayBeep(NULL);
}
///
/// sleep
void sleep(void)
{
  LONG x,y;
  struct DiskObject *ti;

  Forbid();
  x = hp11->LeftEdge;
  y = hp11->TopEdge;
  Permit();
  MenusOff();
  CloseWindow(hp11);
  if(!(ti = GetDiskObject("env:sys/def_HP11Cappicon")))
  if(!(ti = GetDiskObject("env:sys/def_HP11C")))
  if(!(ti = GetDiskObject(hp11name)))
	   ti=GetDefDiskObject(WBTOOL);

  if (ti)
  {
	struct MsgPort *m;
	if((m = CreateMsgPort()))
	{
	  struct AppIcon *a;
	  if((a = AddAppIconA(0,0,hp11name,m,0,ti,0)))
	  {
		WaitPort(m);
		ReplyMsg(GetMsg(m));
		RemoveAppIcon(a);
	  }
	  DeleteMsgPort(m);
	}
	FreeDiskObject(ti);
  }

  /* Open the window */
  if(OpenWin(x, y))
  {
	MenusOn();
	on = TRUE;
  }
}
///

