#ifndef CALC_H
#define CALC_H
#include "ucon.h"

/* Data type for links in the chain of symbols. */
struct symrec
{
	char *name;		/* name of symbol */
	int type;		/* type of symbol */
	int defined;		/* 1 if value is defined */
	union
	{
		double var;			/* VAR or CONST */
		double (*fnctptr)(double a);	/* FNCT or CMD */
	} value;
	struct symrec *next;	/* link field */
};

typedef struct symrec symrec;

/* The symbol table: a chain of `struct symrec'. */
extern symrec *sym_table;

symrec *putsym();
symrec *getsym();

#define	MARK_MESSAGE	0x0001
#define	MARK_RESULT	0x0002

int calc_open(UCON_console *console);
int calc_eval(const char *b);
void calc_close(void);
#endif
