char *rman[11][16] =
{
    {
    "........####....",
    "........####....",
    "................",
    "..########......",
    "..##..####......",
    "..##..##########",
    "......####......",
    "................",
    "......####......",
    "....########....",
    "....##....##....",
    "..####....####..",
    "####........##..",
    "##..........##..",
    "............####",
    "................",
    }, {
    "..........####..",
    "..........####..",
    "................",
    "......######....",
    "....########....",
    "....##..######..",
    "....##..####....",
    "................",
    "....######......",
    "....########....",
    "....##....##....",
    "######....##....",
    "##........##....",
    "##........##....",
    "..........##....",
    "..........####..",
    }, {
    "..........####..",
    "..........####..",
    "................",
    "........####....",
    "......######....",
    "......######....",
    "......########..",
    "......####......",
    "......####......",
    "......####......",
    "......####......",
    "..########......",
    "..##....##......",
    "..##....##......",
    "........##......",
    "........####....",
    }, {
    "........####....",
    "........####....",
    "................",
    "........####....",
    "........####....",
    "........####....",
    "........####....",
    "........######..",
    "........####....",
    "........####....",
    "........####....",
    "....########....",
    "....##..##......",
    "....##..##......",
    "........##......",
    "........####....",
    }, {
    "..........####..",
    "..........####..",
    "................",
    "........####....",
    "......######....",
    "......######....",
    "......########..",
    "......####......",
    "......######....",
    "....##########..",
    "....##......##..",
    "....##..######..",
    "....##..##......",
    "....##..........",
    "....##..........",
    "......##........",
    }, {
    "..........####..",
    "..........####..",
    "................",
    "......######....",
    "....########....",
    "....##..######..",
    "....##..####....",
    "................",
    "......######....",
    "....############",
    "....##........##",
    "....##....######",
    "....##....##....",
    "..##......##....",
    "..##............",
    "..##............",
    }, {
    "........####....",
    "........####....",
    "................",
    "..########......",
    "..##..####......",
    "..##..##########",
    "......####......",
    "................",
    "......####......",
    "....############",
    "....##........##",
    "..####......##..",
    "..##........##..",
    "####............",
    "##..............",
    "##..............",
    }, {
    "........####....",
    "........####....",
    "..######........",
    "..##..####......",
    "..##..##########",
    "......####......",
    "......####......",
    "................",
    "......####......",
    "....############",
    "....##........##",
    "..####........##",
    "..##..........##",
    "####............",
    "##..............",
    "................",
    }, {
    "......####......",
    "......####......",
    "................",
    "....########....",
    "..############..",
    "..##..####..##..",
    "..##..####..##..",
    "................",
    "......####......",
    "......####......",
    "......####......",
    "......####......",
    "......####......",
    "......####......",
    "................",
    "......####......",
    }, {
    "......####......",
    "......####......",
    "................",
    "..##########....",
    "..##########....",
    "..##..####..##..",
    "......####..##..",
    "................",
    "......####..##..",
    "......####......",
    "......####......",
    "......##........",
    "......##........",
    "......##........",
    "................",
    "......##........",
    }, {
    "......####......",
    "......####......",
    "................",
    "....##########..",
    "....##########..",
    "..##..####..##..",
    "..##..####......",
    "................",
    "..##..####......",
    "......####......",
    "......####......",
    "........##......",
    "........##......",
    "........##......",
    "................",
    "........##......"
    }
};


int script[] =
{
     0,  1,  2,  3,  4,  5,  6,  7,
     0,  1,  2,  3,  4,  5,  6,  7,
     0,  1,  2,  3,  4,  5,  6,  7,
     8,  9, 10,
     8,  9, 10,
     8,  9, 10,
    ~0, ~1, ~2, ~3, ~4, ~5, ~6, ~7,
    ~0, ~1, ~2, ~3, ~4, ~5, ~6, ~7,
    ~0, ~1, ~2, ~3, ~4, ~5, ~6, ~7,
     8,  9, 10,
     8,  9, 10,
     8,  9, 10
};

#define LEN (sizeof(script)/sizeof(script[0]))

#include "config.h"
#include "mvi/mvi.h"
#include "gif/gif_enc.h"
#include "gif/lzw_enc.h"


/*
 * ============================================================================
 *  GFX_STIC_PALETTE -- The STIC palette.
 * ============================================================================
 */
uint_8 palette[17][3] =
{
    { 0x00, 0x00, 0x00 },
    { 0x00, 0x2D, 0xFF },
    { 0xFF, 0x3D, 0x10 },
    { 0xC9, 0xCF, 0xAB },
    { 0x38, 0x6B, 0x3F },
    { 0x00, 0xA7, 0x56 },
    { 0xFA, 0xEA, 0x50 },
    { 0xFF, 0xFC, 0xFF },
    { 0xBD, 0xAC, 0xC8 },
    { 0x24, 0xB8, 0xFF },
    { 0xFF, 0xB4, 0x1F },
    { 0x54, 0x6E, 0x00 },
    { 0xFF, 0x4E, 0x57 },
    { 0xA4, 0x96, 0xFF },
    { 0x75, 0xCC, 0x80 },
    { 0xB5, 0x1A, 0x58 },

    /* for debug */
    { 0xFF, 0x80, 0x80 },
};

uint_8 curr[16*16];
uint_8 prev[16*16];

const char * typedesc[6] =
{
    "a. Cropped image, orig palette, no trans pixels",
    "b. Cropped image, orig palette, trans pixels",
    "c. Cropped image, orig palette, \"wildcard\" trans/no-trans",
    "d. Cropped image, new palette, no trans pixels",
    "e. Cropped image, new palette, trans pixels",
    "f. Cropped image, new palette, \"wildcard\" trans/no-trans"
};

int color_histo[65536];
int color_votes[16];
int color_map[16];

uint_8 map_palette[16][3];

int main(int argc, char *argv[])
{
    FILE *fi, *fo;
    uint_8 bbox[8][4];
    int fr, out_fr = 0;
    int flag;
    int i, j;
    gif_t gif;
    int prev_gif_time, curr_gif_time, delay;
    int ret, wrote = 0, skip = 0;
    int early = 0;
    int same = 0;
    int n_cols = 16;
    int mode = 0;

    if (argc == 2 && argv[1][0] == '-' && argv[1][1] == '\0')
    {
        mode = 1;
        argc--;
        argv++;
    }

    if (argc != 1)
    {
        fprintf(stderr, "%s [-]\n", argv[0]);
        exit(1);
    }

    fo = fopen("rman.gif", "wb");
    if (!fo)
    {
        perror("fopen()");
        fprintf(stderr, "Could not open %s for writing\n", argv[2]);
        exit(1);
    }

    ret = gif_start(&gif, fo, 16, 16, palette, 2, 1);
    if (ret < 0)
    {
        fprintf(stderr, "Error starting GIF file %s\n", argv[2]);
        exit(1);
    }
    wrote += ret;


    printf("Image compression...\n"); fflush(stdout);

    for (fr = 0; fr < LEN; fr++)
    {
        int r;

        r = script[fr];
        if (r < 0)
        {
            r = ~r;
            for (i = 0; i < 16; i++)
                for (j = 0; j < 16; j++)
                    prev[i*16 + j] = rman[r][i][15 - j] == '#';
        } else
        {
            for (i = 0; i < 16; i++)
                for (j = 0; j < 16; j++)
                    prev[i*16 + j] = rman[r][i][j] == '#';
        }

        ret = gif_wr_frame_m(&gif, prev, 10, mode);
        if (ret == 0)
        {
            memcpy(prev, curr, 16*16);
            continue;
        }
        if (ret < 0)
        {
            fprintf(stderr, "Error writing frame %d of GIF file %s\n",
                    fr - 1, argv[2]);
            exit(1);
        }
        wrote += ret;

        memcpy(prev, curr, 16*16);
        skip = 0;
        out_fr++;
    }


    ret = gif_finish(&gif);
    if (ret < 0)
    {
        fprintf(stderr, "Error terminating GIF file %s\n", argv[2]);
        exit(1);
    }
    wrote += ret;
    fclose(fo);

    printf("Encoded %d unique frames\n", out_fr);
    printf("Encoded %d bytes (%d bytes/source frame, %d bytes/unique frame)\n",
            wrote, wrote / fr, wrote / out_fr);
    printf("GIF frame type breakdown:\n");
    for (i = 0; i < 6; i++)
        printf("%-65s%10d\n", typedesc[i], gif_best_stat[i]);

    return 0;
}

