// OCR engine (c) Joerg Schulenburg
// first engine: rule based
/*
This is a Optical-Character-Recognition program
Copyright (C) 2000-2003  Joerg Schulenburg

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 see README for email address

 >>>  DO NOT EDIT THIS FILE IF YOU NOT REALLY KNOW WHAT YOU ARE DOING! <<<
  
  I have invested lot of time, to write this part of the program.
  This engine should recognize chars allways right or return UNKNOWN.
  If you change something, test all other example files too, 
  to be sure that all things work better.   (JoergS)


ToDo:
  - if box1->p and b differ, reduce probability
  - probability makes life much easier here
  - use only one box!?, may be bits have usefull infos
  - divide this file, suggestion: classify chars:
      high=ABCDEFGHIJKLMNOPQRSTUVWXYZbdfhklt, low=acegijmnopqrsuvwxyz
      or
      often_used=etianmsurwdkgo     rarely_used=hvjcflpqxyz.,:
      or
      every char (large overhead)
  - two-pass version (first pass without tolerance)
    2nd pass with tolerance (ex: one tiny more in sdata->holes)

  general feature extraction:
   - white holes at middle, upper, lower position (cost much time)
   - test lines and triangles insteat of rectangles
   
   char is removed, wchar_t is used  (better code)
   
   making a static global variable-set x.x0,x.x1, and call test_a,
      test_b ... (faster compilation, but not reentrant!)
      
   - adding slant-angle (if detected) to distinguish between l and / ?
   - ac (alternate chars) as string add_ac(box1,"/") => box1->ac="Il/";
     for better context correction or output: "Ha[lI][lI]o!"

*/

#include <stdlib.h>
#include <stdio.h>
// #include "pgm2asc.h"
#include "ocr0.h"
#include "ocr1.h"
#include "amiga.h"
#include "pnm.h"
#include "gocr.h"

#define MM	{ fprintf(stderr," mark %d\n",__LINE__); }
#define MX      { out_x(box1); out_b(NULL,bp,0,0,dx,dy,cs); MM; }


/* extern "C"{ */

// test for umlauts, if ret>0 and m==1 box1 is changed
// m>0   modify box1->dots
// m==2  modify box1->y0
int testumlaut(struct box *box1, int cs, int m, wchar_t *modifier){
   // pix p=*(box1->p);
   int  r,y,x,x0,x1,y0,y1,dx,dy,m1,m2,m3,
        xl,xr,yu,yl;  // left, right, upper and lower border of dots
   wchar_t mod='\0';	/* (TeX-) modifier ~"'` for compose() */
   r=0;
   x0=box1->x0; x1=box1->x1; dx=x1-x0+1;
   y0=box1->y0; y1=box1->y1; dy=y1-y0+1;
   m1=box1->m1; m2=box1->m2; m3=box1->m3;
   xl=x0; xr=x1; yu=yl=y0;
   if( dy < 5  ||   4*y0 > 3*m2+m3 ) return 0;  // no low chars: .,-=
   /* modifier in box included? */
   if( 2*y1 > m1+m2 ){
    /* modifier in box included? */
    for(y=y0;2*y<y0+y1;y++)if( get_bw(xl,xr,y,y,box1->p,cs,1)==0 ) break;
    if( 2*y<y0+y1 ){ /* yes => extract */
      yl=y;
      while( get_bw(xl,xr,y,y,box1->p,cs,1)==0 && 2*y<=y0+y1) y++;
      if( m&2 ) box1->y0=y;	/* snip */
    } 
   }
   if( yu>=yl ) { if(m) box1->dots=0; return 0; } /* nothing found */

   if ( yl-1>yu ) {  // tall box ij"a"o"u
#if 0
     x=box1->y0;box1->y0=m1; out_x(box1); box1->y0=x;
     fprintf(stderr,"\ntestumlaut y0=%d m1=%d m2=%d",y0,m1,m2);
     fprintf(stderr," yu=%d yl=%d xl=%d xr=%d m1=%d m2=%d",yu,yl,xl,xr,m1,m2);
#define DEBUG 1
#endif
     {
       if(    get_bw(xl-1,xl-1,yu,yl-1,box1->p,cs,1)==1 ) // neighbour overlap?
       while( get_bw(xl  ,xl  ,yu,yl-1,box1->p,cs,1)==1 && 2*xl<x0+x1) xl++;

       x=xl;y=yu;
       if( get_bw(xl,x1+1,yu,yl-1,box1->p,cs,1)==0 ) r=0; // neighbour overlap?
       else
       if( get_bw(xl  ,xl  ,yu,yl-1,box1->p,cs,1)==0
        || get_bw(xl-1,xl-1,yu,yl-1,box1->p,cs,1)==0 ) // be sure there are gap to neighbours
       if( get_bw(xr  ,xr  ,yu,yl-1,box1->p,cs,1)==0
        || get_bw(xr+1,xr+1,yu,yl-1,box1->p,cs,1)==0 )
       { int i,j,x;
         r=1;
         //  ...@@@....  RING_ABOVE //  ..@@@..@@.  TILDE
         //  ..@...@...             //  @@.@@@@@..
         //  ..@...@...             //  @.........
         //  ..@..@@...
         //  ...@@@....
         for (i=yu;i<yl;i++) if (get_bw(xl,xr,i,i,box1->p,cs,1)==1) break;
         for (    ;i<yl;i++) if (get_bw(xl,xr,i,i,box1->p,cs,1)==0) break;
         for (j=xl;j<xr;j++) if (get_bw(j,j,yu,i,box1->p,cs,1)==1) break;
         for (    ;j<xr;j++) if (get_bw(j,j,yu,i,box1->p,cs,1)==0) break;
         for ( x=j;x<xr;x++) if (get_bw(x,x,yu,i,box1->p,cs,1)==1) break;
         // vert. gap detected
         if( j<xr && x<xr && j<x && xr-xl>2
          && num_obj(xl,xr,yu,yl-1,box1->p,cs)>=2  // not best!!!
          && num_cross(xl,xr,yu  +(yl-yu)/4,yu+  (yl-yu)/4,box1->p,cs) == 2 
          && num_cross(xl,xr,yl-1-(yl-yu)/2,yl-1-(yl-yu)/2,box1->p,cs) == 2
            ){    // may be the following lines are not quite ok
           while( get_bw(xl,xr,yl,yl,box1->p,cs,1)==0 && 2*yl<y0+y1) yl++;
           r=2; 
// out_x(box1);printf(" x,y=%d,%d i=%d xl=%d xr=%d yu=%d yl=%d\n",x0,y0,i-x0,xl-x0,xr-x0,yu-y0,yl-y0);
	   mod = DIAERESIS;
         }
         if( m&2 ) box1->y0=yl;
/*         if( m&2 ) box1->y0= ( (r==1) ? yu : yl ); */
         // out_x(box1);
       }
       if(r==0){ // divided fr != fi
         while( get_bw(x0,x1,yu,yu,box1->p,cs,1)==0 && 2*yu<y0+y1) yu++;
         if(m)box1->y0=yu;
       }
       if( r==1 ){ yl--;
//        .@@@.    ..@@.
//        .@@..    .@@..
//        .@...    .@@..
//
//         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
//           > loop(box1->p,xl,yl,xr-xl,cs,0,RI) // +dx/8
//          && loop(box1->p,xr,yu,xr-xl,cs,0,LE)
//           < loop(box1->p,xr,yl,xr-xl,cs,0,LE)) // -dx/8 ) // &eacute; Nov03 
         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
           - loop(box1->p,xr,yu,xr-xl,cs,0,LE)
           > loop(box1->p,xl,yl,xr-xl,cs,0,RI) // +dx/8
           - loop(box1->p,xr,yl,xr-xl,cs,0,LE)+1) // -dx/8 ) // &eacute; Nov03 
	   mod = ACUTE_ACCENT; // '

         if(  xr-xl+1 > 3*(yl-yu+1)
           && get_bw(xl,xr,yu,yl,box1->p,cs,2)==0 )
	   mod = MACRON; // "-" above

         if(    (xr-xl+1) < 2*(yl-yu+1)
           && 2*(xr-xl+1) >   (yl-yu+1) 
           && get_bw(xl,xr,yu,yl,box1->p,cs,2)==0 )
	   mod = DOT_ABOVE; // "." above, ToDo: improve it!

//        .@@@.   .@@..
//        ..@@.   ..@@.
//        ...@.   ..@@.
//
//         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
//           < loop(box1->p,xl,yl,xr-xl,cs,0,RI) // -dx/8
//          && loop(box1->p,xr,yu,xr-xl,cs,0,LE)
//           > loop(box1->p,xr,yl,xr-xl,cs,0,LE) ) // +dx/8 ) &agrave; Nov03
         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
           - loop(box1->p,xr,yu,xr-xl,cs,0,LE)
           < loop(box1->p,xl,yl,xr-xl,cs,0,RI) // -dx/8
           - loop(box1->p,xr,yl,xr-xl,cs,0,LE) -1 ) // +dx/8 ) &agrave; Nov03
	   mod = GRAVE_ACCENT; // ` 

         if( ( loop(box1->p,xl,yu  ,xr-xl,cs,0,RI)
             > loop(box1->p,xl,yl  ,xr-xl,cs,0,RI)-dx/8
            || loop(box1->p,xl,yu  ,xr-xl,cs,0,RI)
             > loop(box1->p,xl,yl-1,xr-xl,cs,0,RI)-dx/8 )
          && ( loop(box1->p,xr,yu  ,xr-xl,cs,0,LE)
             > loop(box1->p,xr,yl  ,xr-xl,cs,0,LE)-dx/8
            || loop(box1->p,xr,yu  ,xr-xl,cs,0,LE)
             > loop(box1->p,xr,yl-1,xr-xl,cs,0,LE)-dx/8 )
         &&   num_cross(xl,xr,yu  ,yu  ,box1->p,cs) == 1 
         && ( num_cross(xl,xr,yl  ,yl  ,box1->p,cs) == 2
           || num_cross(xl,xr,yl-1,yl-1,box1->p,cs) == 2 )) 
	   mod = CIRCUMFLEX_ACCENT; // "^"
         
         if( ( loop(box1->p,xl,yu  ,xr-xl,cs,0,RI)
             < loop(box1->p,xl,yl  ,xr-xl,cs,0,RI)-dx/10
           ||  loop(box1->p,xl,yu+1,xr-xl,cs,0,RI)
             < loop(box1->p,xl,yl  ,xr-xl,cs,0,RI)-dx/10 )
          && ( loop(box1->p,xr,yu  ,xr-xl,cs,0,LE)
             < loop(box1->p,xr,yl  ,xr-xl,cs,0,LE)-dx/10
            || loop(box1->p,xr,yu+1,xr-xl,cs,0,LE)
             < loop(box1->p,xr,yl  ,xr-xl,cs,0,LE)-dx/10 )
         && ( num_cross(xl,xr,yu  ,yu  ,box1->p,cs) == 2
           || num_cross(xl,xr,yu+1,yu+1,box1->p,cs) == 2 )
         &&   num_cross(xl,xr,yl  ,yl  ,box1->p,cs) == 1 ) 
	   mod = CARON;   // "v" above
         
         if(  /* test for bow (new0.3.6) */
                 loop(box1->p,xl,yu       ,xr-xl,cs,0,RI)
             +   loop(box1->p,xl,yl       ,xr-xl,cs,0,RI)
             - 2*loop(box1->p,xl,(yl+yu)/2,xr-xl,cs,0,RI) > dx/16+1
           && xr-xl>10)
         if( ( loop(box1->p,xl,yu  ,xr-xl,cs,0,RI)
             < loop(box1->p,xl,yl  ,xr-xl,cs,0,RI)-dx/10
           ||  loop(box1->p,xl,yu+1,xr-xl,cs,0,RI)
             < loop(box1->p,xl,yl  ,xr-xl,cs,0,RI)-dx/10 )
          && ( loop(box1->p,xr,yu  ,xr-xl,cs,0,LE)
             < loop(box1->p,xr,yl  ,xr-xl,cs,0,LE)-dx/10
            || loop(box1->p,xr,yu+1,xr-xl,cs,0,LE)
             < loop(box1->p,xr,yl  ,xr-xl,cs,0,LE)-dx/10 )
         && ( num_cross(xl,xr,yu  ,yu  ,box1->p,cs) == 2
           || num_cross(xl,xr,yu+1,yu+1,box1->p,cs) == 2 )
         &&   num_cross(xl,xr,yl  ,yl  ,box1->p,cs) == 1 ) 
	   mod = BREVE;   // round "u" above
         
        if( xr-xl>3 && yl-yu>1 )
         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
           > loop(box1->p,xl,yl,xr-xl,cs,0,RI)
          && loop(box1->p,xr,yu,xr-xl,cs,0,LE)
           < loop(box1->p,xr,yl,xr-xl,cs,0,LE)
         && num_cross(xl,xr,yu,yu,box1->p,cs) == 2 
         && num_cross(xl,xr,yl,yl,box1->p,cs) == 2 ) 
	   mod = TILDE;

        if( xr-xl>2 && yl-yu>2)
        if( num_cross(xl,xr,(yu+yl)/2,(yu+yl)/2,box1->p,cs) >1 )
        if( num_cross((xl+xr)/2,(xl+xr)/2,yu,yl,box1->p,cs) >1 )
        if( num_hole(xl,xr,yu,yl,box1->p,cs,NULL) == 1 )
	   mod = RING_ABOVE;

#ifdef DEBUG
	printf("\n# detected mod=%d y=%d..%d r=%d %s",
	  (int)mod,yu-box1->y0,yl-box1->y0,r,((mod==CARON)?"CARON":
	                                     ((mod==ACUTE_ACCENT)?"ACUTE":
	                                     ((mod==TILDE)?"TILDE":"?"))));
	out_x(box1);
#endif

       }
     }
     if(m) box1->dots=r; // set to 0 also possible after division
     if(m) box1->modifier=mod; /* should be resetted after compose ??? */
   }
//   printf(" modifier=%c",mod);
   if( modifier ) *modifier=mod;	/* set modifier */
   return r;
}

 
static wchar_t ocr0_eE(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- most frequent letter e first!!!
   // --- test e ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4 (smallest seen is 5x6)
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      /* ToDo: may be a two pass version intolerant/tolerant is better */
      if( loop(box1->p,x0,y0+dy/2,x1-x0,cs,0,RI)>dx/3 ) break; // rough test
      if( loop(box1->p,x0+dx/2,y0,y1-y0,cs,0,DO)>dy/3 ) break;
      if( loop(box1->p,x0+dx/2,y1,y1-y0,cs,0,UP)>dy/3 ) break;
      if( num_cross(x0,x1,y0+dy/4  ,y0+dy/4  ,box1->p,cs) > 2
       && num_cross(x0,x1,y0+dy/4+1,y0+dy/4+1,box1->p,cs) > 2 ) break; // gt
      i=loop(box1->p,x0,y0+dy/2,x1-x0,cs,0,RI); if( i>dx/2 ) break;
      j=loop(box1->p,x0,y0     ,x1-x0,cs,0,RI); if( j<i    ) break;
      j=loop(box1->p,x0,y1     ,x1-x0,cs,0,RI); if( j<i    ) break;
      i=loop(box1->p,x0+dx/2,y0,y1-y0,cs,0,DO); if( i>dx/2 ) break;
      j=loop(box1->p,x1-dx/3,y0,y1-y0,cs,0,DO); if( j<i ) i=j;
      j=loop(box1->p,x0     ,y0,y1-y0,cs,0,DO); if( j<i    ) break;
      j=loop(box1->p,x1     ,y0,y1-y0,cs,0,DO); if( j<i    ) break;
      i=loop(box1->p,x0+dx/2,y1,y1-y0,cs,0,UP); if( i>dx/2 ) break;
      j=loop(box1->p,x0     ,y1,y1-y0,cs,0,UP); if( j<i    ) break;
      j=loop(box1->p,x1     ,y1,y1-y0,cs,0,UP); if( j<i    ) break;
// MX;
      for(y=1;y<dy/2;y++) if( num_cross(x0,x1,y0+y,y0+y,box1->p,cs) == 2 ) break;
      if( y==dy/2 ) break;  // v0.2.5 ~ bad_t
      for(i=0,j=x0+dx/4;j<=x1-dx/4 && i<=dx/4;j++)
        if( num_cross(j,j,y0,y1,box1->p,cs) == 3 ) i++;
      if( i<dx/4-1 || i==0 ) break;  // v0.2.4a3 more strong! ~g
      // look for horizontal white line (right gap) => set x,y
      for(x=0,y=i=y0+dy/3;i<y1-dy/6;i++){
        j=loop(box1->p,x1,i,y1-y0,cs,0,LE);
        if(j>=x) { x=j;y=i; }
      }
      if (x<dx/2 && dy<12){ // repeat on bad e
       for(x=0,y=i=y0+dy/3;i<y1-dy/6;i++){
        j =loop(box1->p,x1  ,i,  y1-y0,cs,0,LE);
        j+=loop(box1->p,x1-j,i+1,y1-y0,cs,0,LE);
        if(j>=x) { x=j;y=i; }
       } ad=97*ad/100;
      }
      if (x<dx/2) break;
      for(i=1,j=x0+dx/6;j<x1-dx/6 && i;j++)
        if( num_cross(j,j,y0,y,box1->p,cs) > 1 ) i=0;
      if( i ) break;
// ..@@@@...<-
// .@@@@@@;.
// @@,...@@.
// @@.....@,
// @@@@@@@@@
// @@.,;.@,.  <- problem (y)
// @@.....@.
// @@,...@@.
// .@@@,@@@.
// ..@@@@;..<-
      if (dy>11)
      if ( num_cross(x0,x1,y,y,box1->p,cs) != 1 ) break; // except "geschwungenem e"
      if ( num_cross(x0,x1-dx/3,y  ,y  ,box1->p,cs) != 1
        && num_cross(x0,x1-dx/3,y+1,y+1,box1->p,cs) != 1 ) break;
      // if( num_hole(x0, x1, y0 , y  ,box1->p,cs,NULL) <  1 ){
      if( sdata->holes.num == 0 || sdata->holes.hole[0].y1 >= y-y0){
        if( sdata->hchar ) break; // ~ \it t
        // look if thinn font (may be h-line is broken) Mai00
        for(j=0,i=x0+dx/8;i<x1-1;i++)
        if( get_bw(i,i,y0+dy/4,y,box1->p,cs,1) == 1 ) j++;
        if(j<2*dx/4) break;
      }
      // if( num_hole(x0, x1, y+1, y1 ,box1->p,cs,NULL) != 0 ) break;
      if( sdata->holes.num>0 && sdata->holes.hole[0].y0 > y-y0) break;
      if( sdata->holes.num>1 && sdata->holes.hole[1].y0 > y-y0) break;
      // look for horizontal gap
      for(x=0,y=i=y0;i<y1;i++){
        j=loop(box1->p,x0,i,x1-x0,cs,0,RI);
        if(j>=x) { x=j;y=i; }
      }
      if (box1->modifier==0 && y>y0+dy/6 && y<y1-dy/8) break; // &eacute;

      if( num_cross(x0+dx/2,x1  ,y1-dy/4,y1  ,box1->p,cs) == 0
       && num_cross(x0+dx/2,x1-1,y1-dy/4,y1  ,box1->p,cs) == 0
       && num_cross(x0+dx/2,x1  ,y1-dy/4,y1-1,box1->p,cs) == 0 ) {
        if (sdata->gchar) break; // ~p
        ad=99*ad/100;
      }
      /* upper case is for 5x6 box */
      if( sdata->hchar  // broken B ? should also work when linedetection fails
       && loop(box1->p,x1,y1-dy/3,dx,cs,0,LE)<=dx/8 ) {
        x = loop(box1->p,x0,y0+dy/2,dx,cs,0,RI);
        if( loop(box1->p,x0,y0+dy/4,dx,cs,0,RI)<=x
         && loop(box1->p,x0,y0+dy/8,dx,cs,0,RI)<=x ) break;
        if( loop(box1->p,x0,y1-dy/4,dx,cs,0,RI)<=x
         && loop(box1->p,x0,y1-dy/8,dx,cs,0,RI)<=x ) break;
      }
      x = loop(sdata->bp,0,dy-2     ,dx,cs,0,RI);
      if( loop(sdata->bp,0,dy-1-dy/8,dx,cs,0,RI)>x && dy>16) break; // some Q
      if (sdata->gchar) ad=98*ad/100;
      if (sdata->hchar) ad=98*ad/100;

      setac(box1,(wchar_t)'e',ad);
      if (ad>=100) return 'e';
      break;
   }
   // --- test E ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4 ;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      // holes right open?
      for( i=1,y=y0; y<y0+dy/4 && i; y++ ) // long black line
        if( get_bw(x0+dx/3,x1-dx/6,y,y,box1->p,cs,2) == 0 ) i=0;
      if( i ) break;
      for( i=1,y=y1; y>y1-dy/4 && i; y-- ) // long black line
        if( get_bw(x0+dx/6,x1-dx/4,y,y,box1->p,cs,2) == 0 ) i=0;
      if( i ) break;
      for( i=1,y=y0+dy/3; y<y1-dy/3 && i; y++ ){ // black line
        j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>dx/3 ) i=0;
      } if( i ) break;
      x=x1-dx/3; y=y0;		// von oben durchbohren!
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,DO,ST); if( y>y0+dy/4 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,DO); if( y>y0+dy/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,DO); if( x<=x1 || y>y0+dy/2 ) break;
      x=x1-dx/3; y=y1;		// von unten durchbohren!
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,UP,ST); if( y<y1-dy/4 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,UP); if( y<y0-dy/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP); if( x<=x1 || y<y0+dy/2 ) break;
      x=x1-dx/3; y=y0;		// von oben durchbohren!
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,DO,ST); if( y>y0+dy/4 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,DO); if( y>y0+dy/3 ) break;
      y+=dy/15;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST); if( x<x0 ) break;
      if (dx>15 && x==x0) ad=99*ad/100; // to thin
      x+=dx/15+1;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,DO,ST); if( y>y1-dy/3 ) break;
      // if( num_hole(x0, x1, y0 , y1  ,box1->p,cs,NULL) > 0 ) break;
      if (sdata->holes.num > 0) break;
      i=loop(box1->p,x0,y0+dy/4,dx,cs,0,RI); if(i>dx/2) break;
      j=loop(box1->p,x0,y0+dy/2,dx,cs,0,RI); if(j<i-dx/4 || j>i+dx/8) break; i=j;
      j=loop(box1->p,x0,y1-dy/4,dx,cs,0,RI); if(j<i-dx/4 || j>i+dx/8) break;
      for( x=dx,y=y0+dy/6; y<y1-dy/9; y++ ) // left border straight
      { i=loop(box1->p,x0,y,dx,cs,0,RI); if( i>x+dx/9 ) break;
        if(i<x) x=i;
      } if( y<y1-dy/9 ) break;	// t
      if(dy>3*dx)  // ~[
      if( get_bw(x0+dx/2,x0+dx/2,y0+dy/4,y1-dy/4,box1->p,cs,1) == 0 ) break;

      if (!hchar) ad=ad*98/100;
      if (gchar)  ad=ad*98/100;
      setac(box1,(wchar_t)'E',ad);
      if (ad>=100) return 'E';
      break;
   }
   return box1->c;
}

static wchar_t ocr0_n(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   int	i,j,d,x,y,i1,i2,i3,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad;	/* tmp-vars */

   // --- test n ---------------------------------------------------
   // glued rm is very similar to glued nn -> thickness of h-line should grow
   // may02: tested for 8x12 font
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      i= num_cross( 0,dx-1,dy/4,dy/4,sdata->bp,cs);
      j= num_cross( 0,dx-1,dy/2,dy/2,sdata->bp,cs);
      if( (i<2 || i>3) && j!=2 ) break;
      if( loop(sdata->bp,dx/2,0,dy,cs,0,DO) > dy/8 && sdata->hchar ) break;  /* tt */
      y=7*dy/8;
      if( num_cross(   0,dx/2,y  ,y  ,sdata->bp,cs) != 1
       && num_cross(   0,dx/2,y-1,y-1,sdata->bp,cs) != 1
       && num_cross(dx/2,dx-1,y  ,y  ,sdata->bp,cs) <  1 ) break; // n rr
      // ~thick_w
      y=loop(sdata->bp,dx-1-dx/4,0,dy,cs,0,DO); if(y>dy/2) break;
      if(y>1)if( get_bw(dx-1-dx/4,dx-1,0,y-2,sdata->bp,cs,1) == 1 ) break;

      y=3*dy/4;
      if( num_cross(0,dx-1,y  ,y  ,sdata->bp,cs) == 1 ) break; // ~p
      y=dy/2;
      if( num_cross(0,dx-1,y  ,y  ,sdata->bp,cs) != 2
       && num_cross(0,dx-1,y+1,y+1,sdata->bp,cs) != 2 ) break; // n rr
      
      // out_x(box1);printf(" n1\n");
      x =loop(sdata->bp,0,y,dx  ,cs,0,RI); if(x>  dx/4) break; // search 1st v-line
      x+=loop(sdata->bp,x,y,dx-x,cs,1,RI); if(x>  dx/2) break; i1=x; // 1st gap
      x+=loop(sdata->bp,x,y,dx-x,cs,0,RI); if(x<  dx/2) break; i2=x; // 2nd v-line
      x+=loop(sdata->bp,x,y,dx-x,cs,1,RI); if(x<3*dx/4) break; i3=x; // 2nd gap

      i=dy/4; y=13*dy/16;
      if( num_cross(dx/2,dx-1,y,y,sdata->bp,cs)==2 ) i=3*dy/8; // \it n
      if (i<2 && i<dy/2) i++; // correct for small fonts like 8x12
      // the same game for the lower part =>l1 l2 l3 l4 ???
      for(x=i1;x<i2;x++) if( loop(sdata->bp,x,   0,dy,cs,0,DO)>=i ) break;
      if(x <i2) break; // gap detected

      for(x=i1;x<i2;x++) if( loop(sdata->bp,x,dy-1,dy,cs,0,UP) >dy/4 ) break;
      if(x==i2) break; // no gap detected (glued serifs ??? )

      // glued rm as nn ???
      for(y=0,x=(i1+i2)/2;x<i2;x++){
         i=loop(sdata->bp,x,0,dy,cs,0,DO); 
         i=loop(sdata->bp,x,i,dy,cs,1,DO); // measure thickness
         if( i>y ) y=i; if( i<y/2 ) break;
      }
      if(x <i2) break; // unusual property for n

      i= loop(sdata->bp,dx-1  ,dy/2,dx,cs,0,LE); if(i>5)
      if( get_bw(dx-1-i/2,dx-1-i/2,0,dy/2,sdata->bp,cs,1) == 1 ) break; // ~rr
      i+=loop(sdata->bp,dx-1-i,dy/2,dx,cs,1,LE);
      if( get_bw(dx-1-i  ,dx-1-i  ,0,dy/2,sdata->bp,cs,1) == 0 ) break; // ~rv

      if( get_bw(dx/2,dx/2,dy/4,dy/4,sdata->bp,cs,1) == 0
       && get_bw(dx/2,dx/2,dy-2,dy-2,sdata->bp,cs,1) == 0
       && get_bw(dx/2,dx/2,dy/4,dy-2,sdata->bp,cs,1) == 1 ) break; // ~P

      // glued ri ???
      if( box1->dots>0 && box1->m1 )
      if( get_bw((x1+x0)/2,x1,box1->m1,y0-1,box1->p,cs,1) == 1 )
      if( num_cross( 0,dx-1,0  ,0  ,sdata->bp,cs) >2
       || num_cross( 0,dx-1,1  ,1  ,sdata->bp,cs) >2 ) break;

      if( dy>7 )
      if(  loop(sdata->bp,dx-1,dy-1-dy/8,dx,cs,0,LE)
          +loop(sdata->bp,   0,dy-1-dy/8,dx,cs,0,RI)-dx/8-1
         > loop(sdata->bp,dx-1,dy-1-dy/2,dx,cs,0,LE)
          +loop(sdata->bp,   0,dy-1-dy/2,dx,cs,0,RI) ) ad=90*ad/100; // broken o
      if( dy>7 && dx>7 )
      if(  loop(sdata->bp,dx-1,     dy/2,dx,cs,0,LE)==0
        && loop(sdata->bp,dx-1,dy-1-dy/8,dx,cs,0,RI)>dx/8 ) ad=98*ad/100; // broken o

      i=loop(sdata->bp,dx-1,     dy-1,dx,cs,0,LE); if (i>dx/2)
      i=loop(sdata->bp,dx-1,     dy-2,dx,cs,0,LE);
      x=loop(sdata->bp,dx-1,dy-1-dy/4,dx,cs,0,LE);
      if (sdata->hchar && i-x>1) break; // &szlig;
      x=loop(sdata->bp,   0,dy-1,dx,cs,0,LE);  // check for serifs
      i=loop(sdata->bp,   0,dy-2,dx,cs,0,LE); if (i<x) x=i;
      i=loop(sdata->bp,   0,   1,dx,cs,0,LE); if (i<x) x=i;
      i=loop(sdata->bp,   0,   2,dx,cs,0,LE); if (i<x) x=i;
      if (sdata->hchar && x>0) break; // fl

      ac=(wchar_t) 'n';
      if ( num_cross( 0,dx-1,dy/4,dy/4,sdata->bp,cs)>=3 ) ad=98*ad/100; // small M
      if (sdata->hchar || 2*y0<box1->m1+box1->m2) ad=96*ad/100;
      if (sdata->gchar) ad=96*ad/100; // &szlig; fl 
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   return box1->c;
}

static wchar_t ocr0_M(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	d,x,y,i0,i1,i2,i3,t1,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad;	/* tmp-vars */

   // ------------------ test M ---------------------------
   for(ad=d=100;dx>4 && dy>3;){	// dy<=dx nicht perfekt! besser mittleres
				// min-suchen fuer m
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,  dy/2,  dy/2,bp,cs)<3
       && num_cross(0,dx-1,  dy/4,  dy/4,bp,cs)<3
       && num_cross(0,dx-1,5*dy/8,5*dy/8,bp,cs)<3
       && num_cross(0,dx-1,3*dy/4,3*dy/4,bp,cs)<3 ) break;
      if( num_cross(0,dx-1,  dy/4,  dy/4,bp,cs)<2
       && num_cross(0,dx-1,  dy/8,  dy/8,bp,cs)<2 ) break; /* fat M */
      if( num_cross(0,dx-1,3*dy/4,3*dy/4,bp,cs)<2 ) break;
      
      x = loop(bp,dx-1  ,dy-1,dx,cs,0,LE); // ~ melted kl
      x = loop(bp,dx-1-x,dy-1,dx,cs,1,LE); if( x>dx/2 ) break;

      if( loop(bp,   0,7*dy/16,dx,cs,0,RI)
        + loop(bp,dx-1,7*dy/16,dx,cs,0,LE) > dx/2 ) break; // ~K

      if( dy>8 /* following lines should be extend to range check */ 
       && loop(bp,  dx/4,dy-1,      dy,cs,0,UP)<dy/4
       && loop(bp,3*dx/8,dy-1,      dy,cs,0,UP)<dy/4 )
      if( loop(bp,   0,dy-1-dy/ 8,dx,cs,0,RI)
        < loop(bp,   0,dy-1-dy/16,dx,cs,0,RI)-dx/32 ) break; // ~it_u
      if( num_cross(0,dx-1,  dy/2,  dy/2,bp,cs)==2
       && num_cross(0,dx-1,  dy/4,  dy/4,bp,cs)> 2 
       && num_cross(0,dx-1,3*dy/4,3*dy/4,bp,cs)> 2 ) break; // ~it_u
      if( num_cross(0   ,dx-1,3*dy/4,3*dy/4,bp,cs)==2
       && num_cross(dx/2,dx/2,3*dy/4,  dy-1,bp,cs)> 0 ) break; // ~it_v

      if( loop(bp,3*dx/4,   0,dy,cs,0,DO)
        > loop(bp,2*dx/4,   0,dy,cs,0,DO)
       && loop(bp,3*dx/4,dy-1,dy,cs,0,UP)
        < loop(bp,2*dx/4,dy-1,dy,cs,0,UP) ) break; // ~N 
      if( loop(bp,3*dx/4,     dy/8,dy,cs,0,DO)
        > loop(bp,2*dx/4,     dy/8,dy,cs,0,DO)
       && loop(bp,3*dx/4,dy-1-dy/8,dy,cs,0,UP)
        < loop(bp,2*dx/4,dy-1-dy/8,dy,cs,0,UP) ) break; // ~serif_N 

      // i0 is lower end of upper serifen (widest gap? )
      i0=0;
       
      if( num_cross(0,dx-1,dy/2,dy/2,bp,cs)!=4 ){ // Is it a N ?
        if( num_cross(0,dx-1,dy/2,dy/2,bp,cs)==3 ){
          for(y=dy/2+1;y<dy;y++){
            if( num_cross(0,dx-1,y,y,bp,cs)<3 ) break;
          }
          if( num_cross(0,dx-1,y,y,bp,cs)==2 ){
            x =loop(bp,dx-1  ,y-1,dx,cs,0,LE);
            x+=loop(bp,dx-1-x,y-1,dx,cs,1,LE);
            x+=loop(bp,dx-1-x,y-1,dx,cs,0,LE);
            if( loop(bp,dx-x,y-1,dy,cs,0,UP)>dy/4 ) break; // ~N
          }
        }
      }
      // MNWK
      for(i2=0,i1=x=dx/2;x<dx-dx/4;x++){ // lowest pixel
        y=loop(bp,x,0,dy,cs,0,DO); if(y>i2) {i2=y;i1=x;} else break; }
      i3=i2+loop(bp,i1,i2,dy-i2,cs,1,DO);
      if(i2<dy/4) {
        if (!sdata->hchar) break;	// rm
        ad=99*ad/100;
      }

      // if( num_hole(x0, x1, y0 , y1 ,box1->p,cs,NULL) != 0 ) break;  // small A
      if (sdata->holes.num != 0) break;
      t1=loop(bp,0 ,3*dy/4,dx,cs,0,RI);
      t1=loop(bp,t1,3*dy/4,dx,cs,1,RI); // thickness of line?
      if( 7*(t1+1)<dx )
      if( num_cross(i1,dx-1,i2-1,i2-1,bp,cs)!=2
       || num_cross(0 ,i1  ,i2-1,i2-1,bp,cs)!=2 ) break;  // too hard ???

      // ~u_n-pair
      if( num_cross(0,dx-1,0,0,bp,cs)!=2
       && num_cross(0,dx-1,1,1,bp,cs)!=2
       && num_cross(0,dx-1,2,2,bp,cs)!=2 ) break;

      // ~nn v0.2.4a3 
      if( num_cross(0,dx-1,  dy/4,  dy/4,bp,cs)==4
       && num_cross(0,dx-1,3*dy/4,3*dy/4,bp,cs)==4 ){
        i1 =loop(bp, 0,  dy/4,dx,cs,0,RI);
        i1+=loop(bp,i1,  dy/4,dx,cs,1,RI);
        i1+=loop(bp,i1,  dy/4,dx,cs,0,RI);
        i2 =loop(bp, 0,3*dy/4,dx,cs,0,RI);
        i2+=loop(bp,i2,3*dy/4,dx,cs,1,RI);
        i2+=loop(bp,i2,3*dy/4,dx,cs,0,RI);
        if( i1>=i2 ) break; // no good M
        i1+=loop(bp,i1,  dy/4,dx,cs,1,RI);
        i2+=loop(bp,i2,3*dy/4,dx,cs,1,RI);
        if( i1>=i2 ) break; // no good M
        i1+=loop(bp,i1,  dy/4,dx,cs,0,RI);
        i2+=loop(bp,i2,3*dy/4,dx,cs,0,RI);
        if( i1<=i2 ) break; // no good M
      }
      if( num_cross(0,dx-1,dy/2,dy/2,bp,cs)==2
       && num_cross(0,dx-1,dy/4,dy/4,bp,cs)==2 && !hchar ) break; // ~ \it u

      if (dy<17)
      if( num_cross(0,dx-1,     0,     0,bp,cs)<2 ) ad=99*ad/100;
      if( num_cross(0,dx-1,     1,     1,bp,cs)<2 ) ad=96*ad/100; // kt
      if( num_cross(dx/2,dx/2,  0,  dy-1,bp,cs)!=1) ad=98*ad/100; // kt
      
      if( num_cross(0,dx-1,  dy/4,  dy/4,bp,cs)<=2
       && num_cross(0,dx-1,3*dy/4,3*dy/4,bp,cs)<=2 
       && dx>8 && dy>12 ){
        ad=98*ad/100;
        for(y=5*dy/16;y<5*dy/8;y++) // look for H-line
        if( num_cross(0,dx-1,y  ,y  ,bp,cs)==1 ) break;
        if( y<5*dy/8 ) ad=95*ad/100;
        if( y<5*dy/8 )
        if( num_cross(2+dx/6,dx-3-dx/6,y-2,y-2,bp,cs)==0
         || num_cross(2+dx/6,dx-3-dx/6,y-1,y-1,bp,cs)==0 ) break; // ~H bad!
      }

      if(  loop(bp,3*dx/8,   0,dy,cs,0,DO) >dy/2
        && loop(bp,5*dx/8,dy-1,dy,cs,0,UP) >dy/2 ) ad=95*ad/100;

      if(!hchar){
        ad=98*ad/100; /* not sure */
        if(  loop(bp,0,     dy/4,dx,cs,0,RI)
           < loop(bp,0,dy-1-dy/8,dx,cs,0,RI)-dx/16 ) break; // ~wi glued
      }
      if( gchar ) ad=94*ad/100;
      ac=(wchar_t) 'M';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   return box1->c;
}

static wchar_t ocr0_N(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,d,x,y,i1,i2,i3,i4,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad;	/* tmp-vars */

   // --- test N ------- +hchar -gchar
   for(ad=d=100;dx>4 && dy>3;){
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,   0,   0,bp,cs) != 2 
       && num_cross(0,dx-1,   1,   1,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,bp,cs) != 2 
       && num_cross(0,dx-1,dy-2,dy-2,bp,cs) != 2 ) break;
      if( loop(bp,0   ,dy/2,dx,cs,0,RI)
         +loop(bp,dx-1,dy/2,dx,cs,0,LE)>dx/2 ) break; // ~K
  /*
       @@...@@
       @@@..@@
       @@@..@@
       @@@@*@@  <-b
       @@@@@@@ <= only one cross, but we expect three
       @@*@@@@  <-a
       @@..@@@
       @@..@@@
       @@...@@
  */
      if (dx>=4 && dy>=8)
      if( num_cross(0,dx-1,dy/2+dy/8,dy/2-dy/8,bp,cs) <  2 ) break;

      for(i=0,y=3*dy/8;y<dy-1-3*dy/8;y++) // robust! Dec00
        if( num_cross(0,dx-1,y,y,bp,cs) == 1 ) break;
// MX;
      if (y<dy-1-3*dy/8) {  /* check for thick char (see above) */
        if (loop(bp,dx/2-dx/8-1,y,dx,cs,1,UP)<=
            loop(bp,dx/2+dx/8+1,y,dx,cs,1,UP)) break;
        if (loop(bp,dx/2+dx/8+1,y,dx,cs,1,DO)<=
            loop(bp,dx/2-dx/8-1,y,dx,cs,1,DO)) break;
        i1=x0+dx/2-1-dx/8;
        i2=x0+dx/2+1+dx/8;
        i3=y0+y-1;
        i4=y0+y+1;
      } else {  // cross==3 variant
        for(i=0,y=3*dy/8;y<dy-1-3*dy/8;y++) // robust! Dec00
          if( num_cross(0,dx-1,y,y,bp,cs) == 3 ) i+=2; else i--;
        if( i<=0 ) break;
        // go around lower left serif
        for( x=i1=i3=0,y=1;y<5*dy/8;y++ ){ // search first ^ (i1,i3)
          x =loop(bp,0,y,dx,cs,0,RI);
          x+=loop(bp,x,y,dx,cs,1,RI);
          if( x>3*dx/4 ){ y=dy/2;break; } // ?? wont work in cross=1 sample 
          if( get_bw(x  ,x  ,y,dy-1-dy/4,bp,cs,1) == 0
           || get_bw(x+1,x+1,y,dy-1-dy/4,bp,cs,1) == 0 ) break;
        } if( y>=5*dy/8 ) break;
        i1=x0+x;i3=y0+y;
        for( i4=0,i2=x=x0+dx/2;x< x1-dx/5;x++ ){ // look for 2nd "v" (i2,i4)
          i=loop(box1->p,x,y0+dy/8+1,dy,cs,0,DO); if( i>i4 ) { i4=i;i2=x; }
        } i4=y0+dy/8+1+i4-1; if( i4<y0+dy/4 ) break;
      }
      /* (i1,i3) -> (i2,i4) = ^-left to v-right */
      g_debug(fprintf(stderr," debug N: le-^= %d %d - ri-v= %d %d\n",
              i1-x0,i3-y0,i2-x0,i4-y0);)
      /* test if we have two v-legs right of (i1,i3) ^-point */
      if( num_cross(i1,x1,i3,((i3>i2)?i3-dy/8:i3),box1->p,cs) != 2 ) break;
      if( num_cross(x0,i1,i3,i3,box1->p,cs) != 1 ) break; /* left upper end */
      if( num_cross(i2-x0,x1-x0,i4-y0,i4-y0,bp,cs) != 1 ) break; /* bo-ri */
      if( num_cross(    0,i2-x0,i4-y0,i4-y0,bp,cs) != 2 ) break; /* bottom ends */
      // out_x(box1);

      for( i=x=0,y=((i3>i4)?i3:i4); y<y1-dy/4; y++ ){	/* ~hl-duo */
        i =loop(box1->p,x0  ,y,dx,cs,0,RI);
        i+=loop(box1->p,x0+i,y,dx,cs,1,RI);	/* 1st vertical line */
        i =loop(box1->p,x0+i,y,dx,cs,0,RI);	/* growing gap? */
        if ( i+1+dx/16<x && ad>98) ad=ad*99/100; /* be tolerant */
        if ( i+1+dx/8 <x ) break;            /* be tolerant */
        if (i>x) x=i;
      } if ( i+1+dx/8 <x ) break;

      // ~ ru first gap should grow significant
      x =loop(bp,   0,7*dy/8,dx,cs,0,RI);
      x+=loop(bp,   x,7*dy/8,dx,cs,1,RI);
      x+=loop(bp,   x,7*dy/8,dx,cs,0,RI);
      i =loop(bp,dx-1,7*dy/8,dx,cs,0,LE);
      if( x<5*(dx-i)/8 ) break; // Mai00

      if( !hchar )	// outer v-lines should be vertikal ~glued_rv
      if( abs( loop(bp,0   ,  dy/4,dx,cs,0,RI)
              +loop(bp,dx-1,  dy/4,dx,cs,0,LE)
              -loop(bp,0   ,3*dy/4,dx,cs,0,RI)
              -loop(bp,dx-1,3*dy/4,dx,cs,0,LE) ) > 1+dx/32 ) break;

      if (!hchar) ad=99*ad/100;
      if ( gchar) ad=98*ad/100; // \sc N
      ac=(wchar_t) 'N';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   return box1->c;
}

static wchar_t ocr0_h(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test h ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(0        ,dx/2,dy/8     ,dy/8     ,bp,cs,1) != 1 ) break;
      if( get_bw(0        ,dx/2,dy/2     ,dy/2     ,bp,cs,1) != 1 ) break;
      if( get_bw(dx/2     ,dx-1,dy-1-dy/3,dy-1-dy/3,bp,cs,1) != 1 ) break;
      if( get_bw(dx/2     ,dx/2,dy/5     ,dy-1-dy/3,bp,cs,1) != 1 ) break;
      if( get_bw(dx-1-dx/3,dx-1,0        ,1        ,bp,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/3,dx-1,1        ,dy/6     ,bp,cs,1) == 1 ) break;
      if( dy>18 )
      if( get_bw(dx-1-dx/3,dx-1,dy/6     ,dy/5     ,bp,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/3,dx-1,dy-1-dy/4,dy-1     ,bp,cs,1) == 0 ) break; // s-
      for( x=x0+dx/3;x<x1-dx/3;x++)
      if( get_bw(x, x,y1-dy/3, y1,     box1->p,cs,1) == 0 ) break;
      if( x>=x1-dx/3 ) break;
      for(i=dy/4,y=y0+dy/3;y<=y1 && i;y++){
        if( num_cross(x0,x1     ,y,y, box1->p,cs) == 2 ) i--;
      } if( i ) break;
      for(i=dy/4,y=y0;y<=y0+dy/2 && i;y++){
        if( num_cross(x0,x0+dx/2,y,y, box1->p,cs) == 1 ) i--;
      } if( i ) break;
      // if( num_hole(x0, x1, y0      , y1      ,box1->p,cs,NULL)  > 0 ) // could happen
      if (sdata->holes.num > 0)
      if (sdata->holes.hole[0].y0 >      dy/3
       && sdata->holes.hole[0].y1 < dy-1-dy/3) break; 
      // if( num_hole(x0, x1, y0+dy/3 , y1-dy/3 ,box1->p,cs,NULL) != 1 ) break; // mini
      if( loop(bp,dx-1,dy/3,dx,cs,0,LE)+dx/8
        < loop(bp,dx-1,dy/2,dx,cs,0,LE)
       && loop(bp,dx-1,dy-2,dx,cs,0,LE)+dx/8
        < loop(bp,dx-1,dy/2,dx,cs,0,LE)      ) break; // ~k Okt00
      i=loop(bp,0,dy-1-dy/4,dx,cs,0,RI);
      if (i>1 && num_cross(x0,x0,y0+dy/8+2,y0+dy/2, box1->p,cs) == 1 ){  // fi fu
        ad=(99-(1<<i))*ad/100;
        if (num_cross(x0,x0,y0,y0+dy/8+2, box1->p,cs) == 0 ) ad=97*ad/100;
        if (num_cross(x0+dx/2,x0+dx/2,y0,y0+dy/8+2, box1->p,cs) == 1 ) ad=97*ad/100;
        if (ad<1) break;
      }
      i=loop(bp,0,dy/4,dx,cs,0,RI)+1;
      for ( ; i<dx-dx/3; i++ )
        if( loop(bp,i,0,dy,cs,0,DO)>5*dy/8 ) break; // melted hi, li
      if (i<dx-dx/3) break;
      if( num_cross(x0,x1,y1-3*dy/8,y1-3*dy/8,box1->p,cs) > 2 ) ad=96*ad/100; // melted hi
      
      i=loop(bp,dx-1,1+dy/16,dx,cs,0,LE); if (i<dx/4) ad=98*ad/100;
      if( num_cross(dx-i+1+dx/8,dx-i+1+dx/8,0,1+dy/16,bp,cs) > 0 ) ad=95*ad/100; // melted fi
      if (loop(box1->p,x1,y0+1+dy/16,dx,cs,0,LE)<dx/4) ad=98*ad/100; // fi
      if (loop(box1->p,x1,y0  ,dx,cs,0,LE)<dx/4
       || loop(box1->p,x1,y0+1,dx,cs,0,LE)<dx/4) ad=98*ad/100; // li
      
      
      if ( gchar) ad=98*ad/100;
      if (!hchar) ad=97*ad/100;
      setac(box1,(wchar_t)'h',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_H(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,j1,d,x,y,ya,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test H ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,dy/4  ,dy/4  ,bp,cs) != 2
       && num_cross(0,dx-1,dy/4-1,dy/4-1,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,3*dy/4  ,3*dy/4  ,bp,cs) != 2
       && num_cross(0,dx-1,3*dy/4+1,3*dy/4+1,bp,cs) != 2 ) break;
      if( loop(bp,0   ,dy/8,dx,cs,0,RI)
        + loop(bp,dx-1,dy/8,dx,cs,0,LE)>dx/2 ) break; // ~A
      for( j1=0,i=1,y=y0+dy/10; y<y1-dy/10 && i; y++ ) // 2 vertikal lines
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI)
         +loop(box1->p,x1  ,y,dx,cs,0,LE); if( j>dx/2 ) i=0; if(j>j1)j1=j; } 
      if( !i ) break;
      for( i=1,y=dy/4; y<dy-1-dy/4 && i; y++ ) // max - min width
      { j=loop(bp,0   ,y,dx,cs,0,RI)
         +loop(bp,dx-1,y,dx,cs,0,LE); if( j1-j>dx/5 ) i=0; } 
      if( !i ) break;   // ~K Jul00
      for( i=0,ya=y=y0+dy/3; y<y1-dy/3; y++ ) // horizontal line
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>i ) { i=j; ya=y; } } 
      if( i<=dx/2 ) break; ya-=y0;
      if( num_cross(0,dx-1,ya  ,ya  ,bp,cs) != 1
       && num_cross(0,dx-1,ya+1,ya+1,bp,cs) != 1 ) break; /* Dec00 */
      for( y=ya; y<dy-dy/4; y++ ) // ~M Dec00
      if( num_cross(0,dx-1,y  ,y  ,bp,cs) > 2
       && num_cross(0,dx-1,y+1,y+1,bp,cs) > 2 ) break;
      if ( y<dy-dy/4 ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y0     ,y0+dy/4,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( num_cross(x,x,y0+dy/8,y1-dy/8, box1->p,cs) == 1 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/4 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/8, x1     , y0, y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/8, y1-dy/8, y1,box1->p,cs,1) != 1 ) break;
      i1=loop(bp,dx-1,     dy/4,dx,cs,0,LE); if(i1>dx/2) break;
      i2=loop(bp,dx-1,     dy/2,dx,cs,0,LE); if(i2<i1-dx/4 || i2>i1+dx/8) break;
      i3=loop(bp,dx-1,dy-1-dy/4,dx,cs,0,LE); if(i3<i2-dx/4 || i3>i2+dx/8) break;
      if(abs(i1+i3-2*i2)>dx/16+1) break;
      // test for thick tall N looking like a H
      if( num_cross(x0,x1,y0,y1, box1->p,cs) < 2 ) break; // sure N
      i1=loop(bp,    0,     dy/4,dx,cs,0,RI);
      i1=loop(bp,   i1,     dy/4,dx,cs,1,RI);
      i2=loop(bp,    0,dy-1-dy/4,dx,cs,0,RI);
      i2=loop(bp,   i2,dy-1-dy/4,dx,cs,1,RI);
      i3=loop(bp,dx-1   ,dy-1-dy/4,dx,cs,0,LE);
      i3=loop(bp,dx-1-i3,dy-1-dy/4,dx,cs,1,LE);
      i =loop(bp,    0,dy/2+1+dy/8,dx,cs,0,RI);
      i+=loop(bp,    i,dy/2+1+dy/8,dx,cs,1,RI);
      i =loop(bp,    i,dy/2+1+dy/8,dx,cs,0,RI);
      if (i<dx/2-1 && 5*i1>6*i2 && 5*i3>6*i2 && i1>i2 && i3>i2 ) break;
      if( dx>8 )
      if ( loop(bp,dx-1,   3*dy/8,dx,cs,0,LE)
          -loop(bp,dx-1,     dy/8,dx,cs,0,LE)>dx/4
       &&  loop(bp,dx-1,   3*dy/8,dx,cs,0,LE)
          -loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE)>dx/4 ) break; // ~K
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 0 ) break;
      if (sdata->holes.num != 0) break;
      if ( gchar) ad=99*ad/100;
      if (!hchar) ad=98*ad/100;
      setac(box1,'H',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_k(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,x,y,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test k ---------------------------------------------------
   for(ad=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,  dx-1,0,0,bp,cs) != 1
       && num_cross(0,  dx-1,1,1,bp,cs) != 1 ) break;
      if( num_cross(0,3*dx/4,  dy/8 ,  dy/8 ,bp,cs) != 1
       || num_cross(0,3*dx/4,3*dy/16,3*dy/16,bp,cs) != 1 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,bp,cs) != 2
       && num_cross(0,dx-1,dy-2,dy-2,bp,cs) != 2 ) break;
      if( dx<8
       && num_cross(dx-1,dx-1,dy/4,dy-1,bp,cs) != 2
       && num_cross(dx-2,dx-2,dy/4,dy-1,bp,cs) != 2 ) break;
      i1=loop(bp,0,dy/2-dy/4,dx,cs,0,RI);
      i2=loop(bp,0,dy/2     ,dx,cs,0,RI);if(i2>dx/2) break;
      i3=loop(bp,0,dy/2+dy/4,dx,cs,0,RI);
      if(abs(i1+i3-2*i2)>dx/16+1 || i1<i3-1) break; // v-line on left side?
      if( 2*y0>(box1->m1+box1->m2) ) break;
      if( get_bw(x0     ,x0+dx/2,y0     ,y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x1,     y1-dy/3,y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/4,x1,     y0  ,y0+3*dy/16,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/4,x1,     y0+dy/4,y1-dy/4,box1->p,cs,1) != 1 ) break; //~1
      if( get_bw(x1-dx/4,x1,     y1-dy/8,y1     ,box1->p,cs,1) != 1 ) break;
      if (sdata->holes.num > 0)
      if (sdata->holes.hole[0].y0 > dy/4) break;
      // if( num_hole(x0,x1,y0+dy/4,y1,box1->p,cs,NULL) != 0 ) break;
      for(y=y0+1;y<y0+dy/2;y++)		// luecke ???
        if( get_bw(x0,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y<y0+dy/2 ) break;
      for(i=1,x=x0;x<=x0+dx/2 && i;x++) 
        if(get_line(x,y0     ,x ,y1,box1->p,cs,100)>50) i=0;
      if( i ) break;				// no vertikal line!

      /* check for falling line in the lower left corner */
      for (j=x=0,y=5*dy/8;y<7*dy/8;y++) {
        i= loop(bp,dx-1,y,dx,cs,0,LE); if(i>x) { x=i;j=y; }
      } if (x<dx/4) break; if(x<dx/2) ad=98*ad/100; x=dx-1-x; y=j;
      i =loop(bp,dx-1,dy-1,dx,cs,0,LE); if(i>dx/2)
      i =loop(bp,dx-1,dy-2,dx,cs,0,LE); if(i>dx/2) break;
      i+=loop(bp,dx-1-i,dy-1,dx,cs,1,LE)/2;
      if( get_line(x,y,dx-1-i,dy-1,bp,cs,100)<60 ) break; 

      for(i=1,y=dy/2;y<dy-dy/4 && i;y++) 
        if(get_line(dx-1-dx/4,y,dx-1,y ,bp,cs,100)<13) i=0;
      if( i ) break;				// no white range
      for(y=y0+dy/3;y<y1;y++) if( num_cross(x0,x1,y,y,box1->p,cs)==2 ) break;
      if( y==y1 ) break;
      if(
       // num_hole(x0,x1     ,y0     ,y1     ,box1->p,cs,NULL)>0  // ~A happens!
          sdata->holes.num > 0 )
      if (sdata->holes.hole[0].x1>dx-1-dx/4
       || sdata->holes.hole[0].y1>dy-1-dy/4
       || sdata->holes.hole[0].y0<     dy/4) break;
      // if ( num_hole(x0,x1-dx/4,y0+dy/4,y1-dy/4,box1->p,cs,NULL)==0 ) break;
      i=loop(bp,0,dy-1,dx,cs,0,RI);
      i=loop(bp,i,dy-1,dx,cs,1,RI); if (dx>8 && 4*i>3*dx) break; // ~glued_tz
      i =loop(bp,0,dy/4,dx,cs,0,RI);
      if (i>dx/4
       && i+loop(bp,i,dy/4,dx,cs,1,RI)>dx/2
       &&   loop(bp,   0,0,dx,cs,0,RI)<=dx/4
       &&   loop(bp,dx-1,0,dx,cs,0,LE)>=dx/2 ) ad=90*ad/100; // divided Q
      
      if ( gchar) ad=98*ad/100;
      if (!hchar) ad=98*ad/100;
      setac(box1,(wchar_t)'k',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_K(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad,ya,xa,yb,xb,yc,xc,yd,xd,ye,xe,yf,xf;	/* tmp-vars */

   // --- test K ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // updated 29 Mar 2000 perfect???
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      for(y=dy/8;y<dy-dy/8;y++)
        if( !get_bw(0,dx/2,y,y,bp,cs,1) ) break;
      if( y<dy-dy/8 ) break;
      for(j=0,i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        y= loop(box1->p,x,y0,y1-y0,cs,0,DO); if (y>3*dy/4) { i=1;break; }
        if (dy>15 && j>dy/8){
          j =loop(box1->p,x-1,y0+y-1,x1-x0,cs,0,LE)/2;
          y+=loop(box1->p,x-j,y0+y-1,y1-y0,cs,0,DO)-1;
        }
        if(y>=dy/4) i=0; /* ok, found gap */
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/8 && i;x++){
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/4 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( dx<10 ){
        for(i=1,y=y0+dy/3;y<=y1-dy/3 && i;y++){
          if( num_cross(x0,x1,y,y, box1->p,cs) == 1 ) i=0;
        } if( i ) break;
      }
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/3,x1,y0,y0+dy/8,box1->p,cs,1) != 1 ) break; // ~k
      if( dy>16
       &&   loop(bp,0,  dy/4,dx,cs,0,RI)
           +loop(bp,0,3*dy/4,dx,cs,0,RI)
         <2*loop(bp,0,  dy/2,dx,cs,0,RI)-2-dx/32 ) break; // ~X

      i=loop(box1->p,x1,y0+  dy/4,x1-x0+1,cs,0,LE); if(i>dx/2) break;
      j=loop(box1->p,x1,y0+  dy/2,x1-x0+1,cs,0,LE);
      x=loop(box1->p,x1,y0+3*dy/8,x1-x0+1,cs,0,LE); if(x>j) j=x;
      if(j<=i  ) break; i=j;
      j=loop(box1->p,x1,y1-dy/4,x1-x0+1,cs,0,LE); if(j>=i  ) break;
      // out_x(box1); // detailed analysis
      //
      //  a   d   <= that are main points of K
      //  |  /
      //  b/e
      //  |  \    .
      //  c   f
      ya=   dy/4;xa=loop(bp,0,ya,dx,cs,0,RI);xa+=loop(bp,xa,ya,dx,cs,1,RI)/2;
      yc=dy-dy/4;xc=loop(bp,0,yc,dx,cs,0,RI);xc+=loop(bp,xc,yc,dx,cs,1,RI)/2;
      yb=dy/2;   xb=dx-1-loop(bp,dx-1,dy/2,dx,cs,0,LE);
      for(yd=ye=yf=xe=y=i=0,xf=xd=dx;y<dy/4;y++){ // range 0..1/4
        x =loop(bp,dx-1,     y,dx,cs,0,LE); if(x<xd){ xd=x;yd=     y; }
        x =loop(bp,dx-1,dy-1-y,dx,cs,0,LE); if(x<xf){ xf=x;yf=dy-1-y; }
        x =loop(bp,dx-1,dy/2+y,dx,cs,0,LE); if(x>xe){ xe=x;ye=dy/2+y; }
        x =loop(bp,dx-1,dy/2-y,dx,cs,0,LE); if(x>xe){ xe=x;ye=dy/2-y; }
#if 0  // removed v0.2.4a2
        x =loop(bp,0   ,dy/2+y,dx,cs,0,RI); // middle left border
        x+=loop(bp,x   ,dy/2+y,dx,cs,1,RI); // test 2nd cross
        x+=loop(bp,x   ,dy/2+y,dx,cs,0,RI); if(x<xb){ xb=x;yb=dy/2+y; }
#endif
        x =loop(bp,0   ,dy/2-y,dx,cs,0,RI);
        x+=loop(bp,x   ,dy/2-y,dx,cs,1,RI); // test 2nd cross
        x+=loop(bp,x   ,dy/2-y,dx,cs,0,RI); if(x<xb){ xb=x;yb=dy/2-y; }
        x =dx-1-loop(bp,dx-1,dy/2-y,dx,cs,0,LE); if(x<xb){ xb=x;yb=dy/2-y; }
      }
      xd=dx-1-xd;xe=dx-1-xe;xf=dx-1-xf;
      xb+=loop(bp,xb,yb,dx,cs,1,RI)/4; // detect center of line
      xe-=loop(bp,xe,ye,dx,cs,1,LE)/4;
      xd-=loop(bp,xd,yd,dx,cs,1,LE)/4;
      xf-=loop(bp,xf,yf,dx,cs,1,LE)/4;
#if 0
//     printf(" a=%d %d b=%d %d c=%d %d d=%d %d e=%d %d f=%d %d  dxdy %d %d\n",
//       xa,ya,xb,yb,xc,yc,xd,yd,xe,ye,xf,yf,dx,dy);
#endif
      if( get_line2(xa,ya,xc,yc,bp,cs,100)<95 ) break;
      if( dx>8 ){ // example szaka0103
        if( xe>5*dx/8 || xb>5*dx/8 ) break; // ~{\it n}
        i=loop(bp,xb,yb,xb,cs,1,LE); // thick center? see font22
        if( get_line2(xb,yb,xd,yd,bp,cs,100)<95 )  // right up
        if( get_line2(xb-i/2,yb,xd,yd,bp,cs,100)<95 ) break;
        if( get_line2(xe,ye,xf,yf,bp,cs,100)<95 ) break; // right down
        xe+=loop(bp,xe,ye,dx,cs,1,RI); if( xe>=xf ) break; // ~{\it n}
      } else {
        if( dy<16 && !hchar ) break;
        if( loop(bp,0,1,dy,cs,1,DO)<=3*dx/4
         && loop(bp,1,1,dy,cs,1,DO)<=3*dx/4
         && loop(bp,2,1,dy,cs,1,DO)<=3*dx/4 ) break; // ~x
      }
      if (loop(bp,dx-1,dy-1-dy/4,dx,cs,0,LE)<=dx/8){
        ad=99*ad/100; /* broken B ? */
        if (sdata->holes.num > 0)
        if (sdata->holes.hole[0].y1 < dy-1-dy/3) break;
        // if( num_hole(x0,x1,y0,(y0+2*y1)/3,box1->p,cs,NULL)>0) break; // broken B
      }
      if(box1->m3 && !hchar) ad=96*ad/100;
      if(box1->m3 &&  gchar) ad=96*ad/100;
      // printf(" ok xe=%d",xe);
      setac(box1,(wchar_t)'K',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_f(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test f like t ---------------------------------------------------
   if( (!box1->dots) )  // Bold-face is gchar
   for(ad=d=100;dx>2 && dy>box1->m3-box1->m2+1 && dy>5;){     // sometimes no hchar!
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      for(x=0,j=y=2+(3*dy+8)/32;y<=4*dy/8;y++){ // upper cross line
        i=loop(bp,0,y,dx,cs,0,RI); if( y>dy/4 && i>5*dx/8 ) break;
        i=loop(bp,i,y,dx,cs,1,RI); if( i>x ) { x=i;j=y; }
        if( y<3*dy/4 && y>dy/4
         && num_cross(0,dx-1,y  ,y  ,bp,cs) != 1
         && num_cross(0,dx-1,y+1,y+1,bp,cs) != 1  // against noise
          ) break;
      } if( y<=4*dy/8 ) break; y=j;// if( y>dy/2 || y<dy/8 ) break;
      // x is thickest width of vertical line here

      if (loop(bp,3*dx/4,0,dy,cs,0,DO)>dy/8) break; // upper bow
      i=3*dy/4; if (box1->m3 && i>=box1->m3) i=box1->m3-1;
      if (num_cross(0,dx-1,i,i,bp,cs)!=1) break; 
       
      // the middle bar appear in a wide vertical range, get part below
      for (i1=dx,i2=y,j=y+1;j<dy-dy/4;j++){
        i=loop(bp,0,j,dx,cs,0,RI);
        i=loop(bp,i,j,dx,cs,1,RI); // thickness vert. line
        if (i<i1) { i1=i; i2=j; if (2*i<=x) break; }
      } i=i1; j=i2;
// MX;printf(" j=%d i=%d y=%d x=%d\n",j,i,y,x);
      if (x<2*i) break; // bar should have twice of the thickness of v-line
      j=loop(bp,0,dy/8,dx,cs,0,RI); // if j>dx/2 we have italic f
      if ((2*x<dx && j<=dx/2) || 3*x<dx) break; // bar should be not to small
      for(i=dy/8;i<dy;i++)
      if (loop(bp,0,i,dx,cs,0,RI)>(j+dx/8)) break;
      if (i<dy) break;   // check for v-line

      if( loop(bp,dx-1,dy/2,dx,cs,0,LE)<dx/2 )
      if( loop(bp,dx-1,dy/2,dx,cs,0,LE)-1
        <=loop(bp,dx-1, y  ,dx,cs,0,LE) )
      if( loop(bp,dx-1, y-1,dx,cs,0,LE)
        <=loop(bp,dx-1, y  ,dx,cs,0,LE) ) break; // ~1

      if( loop(bp,0,dy/2,dx,cs,0,RI)-1
         >loop(bp,0,   1,dx,cs,0,RI) ) break; // ~X

      i=y;j=1;  // j used as flag
      if( num_cross(0,dx-1,0,0,bp,cs)==1 && hchar) //~r
      if( num_cross(0,dx-1,dy-1,dy-1,bp,cs)!=1
       && num_cross(0,dx-1,dy-2,dy-2,bp,cs)!=1 ) break; // ~* etc.
      // check for upper bow to right
      for(y=1;j && y<i;   y++)  // no @@ pattern
       if( num_cross(0,dx-1,y  ,y  ,bp,cs) ==2 ) j=0;
      if (j==1) { ad=98*ad/100; j=1; }
      for(y=1;j && y<i;   y++)  // no @@ pattern, try to detect it
      for(x=0;j && x<dx  ;x++){ //    ..
        if(  (pixel(bp,x  ,y  )>=cs || dx<7) && pixel(bp,x+1,y  )>=cs
          &&  pixel(bp,x  ,y-1)< cs          && pixel(bp,x+1,y-1)< cs )
        { j=0;break; }
      }  if(j) ad=98*ad/100;  // not detected

      // if( num_hole (x0  , x1  , y0, y1,box1->p,cs,NULL) != 0 ) break; // ~e 
      if (sdata->holes.num != 0) break; // ~e
      for(i1=i2=dx,y=7*dy/8;y<dy;y++){
         x=loop(bp,0   ,y,dx,cs,0,RI);if(x<i1)i1=x;
         x=loop(bp,dx-1,y,dx,cs,0,LE);if(x<i2)i2=x;
      } if(i1>i2+1) break; // ~t ~e
      if( loop(bp,0,3*dy/4,dx,cs,0,RI)<i1 ) break;
      if( dx>5 && !hchar)
      if( loop(bp,dx-1,dy/2,dx,cs,0,LE)>3*dx/4 )
      if( loop(bp,dx-1,dy-1,dy,cs,0,UP)<dx/2 ) break; // ~c
      if( dx>8 )
      if( loop(bp,   0,2*dy/3  ,dx,cs,0,RI)>2*dx/3
       || loop(bp,   0,2*dy/3-1,dx,cs,0,RI)>2*dx/3 )
      if( loop(bp,dx-1,  dy/4  ,dx,cs,0,LE)>2*dx/3 ) break; // ~5 ~S

      if (!hchar)
      if ( get_bw(x0+dx/8,x0+dx/8,y0+dy/4,y1-dy/16,box1->p,cs,2) == 0
        && num_cross(x1-dx/4,x1-dx/4,y0,y1,box1->p,cs)!=2
        && num_cross(x1-dx/8,x1-dx/8,y0,y1,box1->p,cs)!=2 ) break; // ~r

      if (dy>15)
      if(  num_cross(x0,x1,y1-dy/4,y1-dy/4,box1->p,cs)>1
        && num_cross(x0,x1,y0+dy/4,y0+dy/4,box1->p,cs)>1 ) break; // ~H
      
      if( dx>4 )
      if( loop(bp,dx-1     ,3*dy/4,dx,cs,0,LE)>dx/2
       && loop(bp,dx-1-dx/8,dy-1  ,dy,cs,0,UP)<dy/4 ) break; // ~E

      if( loop(bp,0,dy/4,dx  ,cs,0,RI)>1
       && loop(bp,0,   0,dy/4,cs,0,DO)<dy/4 ) ad=95*ad/100; // ~I

      if (get_bw(x0,x1,y0,y0,box1->p,cs,2) == 0) {
        ad=98*ad/100; // F
      }
      
      if(!hchar) ad=ad*8/10; // d*=100;d/=128 // not 100% !
      if(gchar && ad<99)  ad++;
      setac(box1,(wchar_t)'f',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_bB(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test B ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4
      if (sdata->holes.num < 2) break; /* tolerant against a tiny hole */
      for(i=1,y=y0;y<y1-dy/2 && i;y++)
      if( get_bw(x0,x0+dx/2, y      , y      ,box1->p,cs,1) != 1 ) i=0;
      if( !i ) break;
      for(i=1,y=y1-dy/2;y<y1 && i;y++)
      if( get_bw(x0,x0+dx/3, y      , y      ,box1->p,cs,1) != 1 ) i=0;
      if( !i ) break;
      if( get_bw(x1,x1     , y0     , y0     ,box1->p,cs,1) == 1 ) break;
      if( num_cross(x0+dx/2, x0+dx/2,y0,y1  ,box1->p,cs) != 3 )
      if( num_cross(x1-dx/3, x1-dx/3,y0,y1  ,box1->p,cs) != 3 ) break;
      /* --- detect center of lower hole --- */
      y = loop(box1->p,x0+dx/2,y1  ,dy,cs,0,UP);   if (y>1+dy/8) break;
      y+= loop(box1->p,x0+dx/2,y1-y,dy,cs,1,UP);   if (y>dy/3) break;
      y=y1-y-loop(box1->p,x0+dx/2,y1-y,dy,cs,0,UP)/2; if (y<y0+3*dy/8) break;
      if (y<y0+dy/2) ad=96*ad/100;
      if( num_cross(0,dx-1,y-y0  ,y-y0  ,bp,cs) != 2 )
      if( num_cross(0,dx-1,y-y0+1,y-y0+1,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,  dy/4  ,  dy/4  ,bp,cs) != 2 )
      if( num_cross(0,dx-1,  dy/4+1,  dy/4+1,bp,cs) != 2 )
      if( num_cross(0,dx-1,  dy/4-1,  dy/4-1,bp,cs) != 2 ) break;
      for( y=dy/4;y<3*dy/4;y++ ) if( num_cross(0,dx-1,y,y,bp,cs)==1 ) break;
      if( y==3*dy/4 ) break;

      if( loop(box1->p,x0,y0+ y  ,dx,cs,0,RI)
        > loop(box1->p,x0,y0+dy/4,dx,cs,0,RI)+dx/32 )
      if( get_bw(x0,x0,y0,y0,box1->p,cs,1) == 0 )
      if( get_bw(x0,x0,y1,y1,box1->p,cs,1) == 0 ) break;  // ~8
      i1=loop(box1->p,x0,y0+dy/4,dx,cs,0,RI);
      i2=loop(box1->p,x0,y0+dy/2,dx,cs,0,RI);
      i3=loop(box1->p,x0,y1-dy/4,dx,cs,0,RI);
      if(dy>16 && i3<i2 && i1+i3<2*i2){
        if( loop(box1->p,x0,y0+ 1  ,dx,cs,0,RI)
         >= loop(box1->p,x0,y0+ 3  ,dx,cs,0,RI)+dx/32 )
        if( loop(box1->p,x0,y0+ 0  ,dx,cs,0,RI)
          > loop(box1->p,x0,y0+ 3  ,dx,cs,0,RI)+dx/32 )
        if( loop(box1->p,x0,y1- 0  ,dx,cs,0,RI)
          > loop(box1->p,x0,y1- 3  ,dx,cs,0,RI)+dx/32 )
        if( loop(box1->p,x0,y1- 1  ,dx,cs,0,RI)
          > loop(box1->p,x0,y1- 3  ,dx,cs,0,RI)+dx/32 ) break; // ~8 Aug00
      }

      if (sdata->holes.num != 2) break;
      if (sdata->holes.hole[0].y0 < y-1
       && sdata->holes.hole[1].y0 < y-1 ) break;
      if (sdata->holes.hole[0].y1 > y+1
       && sdata->holes.hole[1].y1 > y+1 ) break;
      // if( num_hole(0,dx-1,0  ,y+1 ,bp,cs,NULL) != 1 ) break;
      // if( num_hole(0,dx-1,y-1,dy-1,bp,cs,NULL) != 1 ) break;
      // out_x(box1);

      for( x=dx,y=dy/6; y<dy-dy/8; y++ ) // left border straight
      { i=loop(box1->p,x0,y0+y,dx,cs,0,RI); if( i>x+dx/9 ) break;
        if(i<x) x=i;
      } if( y<dy-dy/8 ) break;	// ~8 bad_a

      for( x=dx,y=1;y<dy/4;y++ ) // right border straight
      { i=loop(bp,dx-1,dy-y,dx,cs,0,LE);
        if( i<x ) x=i; else if( i>x )break;
      } if( y<dy/4 ) break;	// ~ff (serifen?)

      x=loop(bp,0,dy/2  ,dx,cs,0,RI);
      i=loop(bp,0,dy/2-1,dx,cs,0,RI); if (i>x) x=i; // allow dust
      i=loop(bp,0,dy/2+1,dx,cs,0,RI); if (i>x) x=i;
      if ( loop(bp,0,  dy/8,dx,cs,0,RI)
          +loop(bp,0,7*dy/8,dx,cs,0,RI) > 2*x+1 ) break; // not konvex!

      if(!hchar){  // ~ fat_a
        ad=99*ad/100;
        x =loop(bp,0,dy/4,dx,cs,0,RI);
        if(loop(bp,0,dy/2,dx,cs,0,RI)>x+dx/8) ad=97*ad/100;
      }

      if ( (!hchar) && (dx<=10 || dy<=10) ) ad=96*ad/100; // hchar or good_quality
      if (gchar) ad=98*ad/100;
      if (gchar && dx<16) ad=98*ad/100;
      setac(box1,(wchar_t)'B',ad);
      break;
   }
   // --- test b ---------------------------------------------------
   for(ad=d=100;dx>3 && dy>4;){     // min 3x4
      if (sdata->holes.num < 1) break; /* tolerant against a tiny hole */
      for(y=y0;y<y1;y++)
      if( get_bw(x0       , x0+dx/2, y      , y      ,box1->p,cs,1) != 1 ) break;
      if(y<y1-dy/32-1) break;
      if( get_bw(x0+  dx/2, x0+dx/2, y1-dy/3, y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-  dx/2, x1     , y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-  dx/3, x1     , y0     , y0+dy/5,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-4*dx/9, x1     , y0+dy/5, y0+dy/5,box1->p,cs,1) == 1 ) break;
      if( num_cross(x0,x1,y0+dy/4  ,y0+dy/4  ,box1->p,cs) > 1 ) // &
      if( num_cross(x0,x1,y0+dy/4-1,y0+dy/4-1,box1->p,cs) > 1 )
      if( dy<16 ||
          num_cross(x0,x1,y0+dy/5  ,y0+dy/5  ,box1->p,cs) > 1 ) break; // fat b
      for(i=j=0,y=dy/2;y<dy-dy/8;y++)
      if( num_cross(0,dx-1,y,y,bp,cs) == 2 ) i++; else j++;
      if( i<2*j ) break; // v024a4
      if (sdata->holes.num != 1) break;
      if (sdata->holes.hole[0].y0 < dy/4) break;
      // if( num_hole( x0, x1 , y0+dy/4, y1,box1->p,cs,NULL) != 1 ) break;
      i=loop(bp,dx-1,dy-1     ,dx,cs,0,LE);
      j=loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE); if(j>i) break;
      if (!hchar) ad=98*ad/100;
      if ( gchar) ad=99*ad/100;
      setac(box1,(wchar_t)'b',ad);
      if (ad>=100) return 'b';
      break;
   }
   return box1->c;
}

static wchar_t ocr0_dD(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,d,x,y,ya,yb,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test D ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num < 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0     ,x0+dx/3,y0+dy/2,y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3,x1     ,y0+dy/2,y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1     ,x1     ,y0     ,y0+dy/16,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/2,x1     ,y0+dy/4,y0+dy/4 ,box1->p,cs,1) != 1 ) break;
      if( num_cross(x0+dx/2,x0+dx/2,y0     ,y1     ,box1->p,cs) != 2 )
      if( num_cross(x1-dx/3,x1-dx/3,y0     ,y1     ,box1->p,cs) != 2 ) break;
      if( num_cross(x0     ,x1     ,y0+dy/3,y0+dy/3,box1->p,cs) != 2 ) break;
      if( num_cross(x0     ,x1     ,y1-dy/3,y1-dy/3,box1->p,cs) != 2 ) break;
      if (sdata->holes.num != 1) break;
      if (sdata->holes.hole[0].y0 >      dy/3) break;
      if (sdata->holes.hole[0].y1 < dy-1-dy/3) break;
      // if( num_hole (x0     ,x1     ,y0     ,y1     ,box1->p,cs,NULL) != 1 ) break;
      // test if left edge is straight
      for(x=0,y=bp->y-1-dy/8;y>=dy/5;y--){ // rechts abfallende Kante/Knick?
        i=loop(bp,0,y,x1-x0,cs,0,RI);
        if( i+2+dx/16<=x ) break;
        if( i>x ) x=i;
      }
      if (y>=dy/5 ) break; 
      /* test if right edge is falling */
      for(x=dx,y=0;y<dy/3;y++){ // rechts abfallende Kante/Knick?
        i=loop(bp,bp->x-1,y,x1-x0,cs,0,LE);
        if( i>x+dx/16 ) break;
        if( i<x ) x=i;
      }
      if (y<dy/3 ) break; 
      /* test if right edge is raising */
      for(x=dx,y=bp->y-1;y>2*dy/3;y--){
        i=loop(bp,bp->x-1,y,x1-x0,cs,0,LE);
        if( i>x+dx/16 ) break;
        if( i<x ) x=i;
      }
      if (y>2*dy/3 ) break; 
      if( loop(bp,dx-1,dy-1      ,dx,cs,0,LE) <=
          loop(bp,dx-1,dy-2-dy/16,dx,cs,0,LE)   ) break;  // P

      y=loop(bp,dx/2,dy-1,dy,cs,0,UP)-1; if (dy>16) y/=2;
      if ( y>=dy/16 ) { y-=dy/16;
        if (get_bw(dx/2,dx-1,dy-1-y,dy-1-y,bp,cs,1)==1) break; // ~A
      }

      ya=loop(bp,      0,dy-1,dy,cs,0,UP);
      yb=loop(bp,dx/16+1,dy-1,dy,cs,0,UP);
      if( ya<dy/2 && ya>dy/16 && ya>yb ) break; // ~O
      
      if (loop(bp,   0,   0,dx,cs,0,RI)>=dx/2
       && loop(bp,dx-1,dy-1,dx,cs,0,LE)>=dx/2
       && loop(bp,   0,dy/2,dx,cs,0,RI)< 2   ) ad=96*ad/100; // thin O 

      if(box1->dots) ad=ad*94/100;
      if (gchar) ad=99*ad/100;
      if (!hchar) ad=99*ad/100;
      setac(box1,(wchar_t)'D',ad);
      break;
   }
   // --- test d ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      ad=100;
      if (sdata->holes.num < 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0     , x0+dx/2, y1-dy/6, y1-dy/9,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/2, y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x1     , y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/4, x1     , y0+dy/8, y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2, y1-dy/4, y1     ,box1->p,cs,1) != 1 ) break;
      if(dy>19)
      if( get_bw(x0     , x0+dx/3, y0     , y0+dy/5,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0     , x0+dx/3, y0     , y0+dy/6,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0     , x0+dx/4, y1-dy/8, y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2-1,x0+dx/2,y1-dy/8, y1     ,box1->p,cs,1) != 1 ) break; // ~"A
      if( loop(bp,bp->x-1,  bp->y/4,x1-x0,cs,0,LE) >
          loop(bp,bp->x-1,3*bp->y/4,x1-x0,cs,0,LE)+1 ) break;
      for(i=dx/8+1,x=0;x<dx && i;x++){
        if( num_cross(x ,x   ,0  ,dy-1, bp,cs) == 2 ) i--;
      } if( i ) break;
      for(i=dy/6+1,y=dy/4;y<dy && i;y++){
        if( num_cross(0 ,dx-1,y  ,y   , bp,cs) == 2 ) i--;
        if( num_cross(0 ,dx-1,y  ,y   , bp,cs) >  2 ) i++; // ~al
      } if( i ) break;
      for(i=dy/8+1,y=0;y<dy/2 && i;y++){
        if( num_cross(0   ,dx-1,y ,y  , bp,cs) == 1 )
        if( num_cross(dx/2,dx-1,y ,y  , bp,cs) == 1 ) i--;
      } if( i ) break;
      if (sdata->holes.num<1) break;
      if (sdata->holes.hole[0].y0 < dy/4) break;
      // if( num_hole(x0 , x1 , y0+dy/4 , y1 ,box1->p,cs,NULL) !=1 ) break;
      if( num_cross(0   ,dx-1,dy-1-dy/4,dy-1-dy/4,bp,cs) != 2 ) { // glued al
        if (dy>15) break; else ad=96*ad/100;
      }
      if (!hchar) ad=98*ad/100;
      if ( gchar) ad=99*ad/100;
      setac(box1,(wchar_t)'d',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_F(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test F ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // dx>1 dy>2*dx 
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0+dx/2,x0+dx/2,y0,y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0,x0+dx/4,y1-dy/4,y1-dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0,x0+dx/2,y0+dy/4,y0+dy/4,box1->p,cs,1) != 1 ) break;

      for (x=0,y=0;y<dy/4;y++) {
        j=loop(bp,dx-1,dy-1-y,dx,cs,0,LE); if(j<3 || 3*j<dx) break; // ~f Jun00
        if (j>x) x=j;
      } if (y<dy/4 || x<dx/2) break;

      for( i=1,y=0; y<dy/4 && i; y++ ){ // long black line
        j=loop(bp,0,y,dx,cs,0,RI);
        j=loop(bp,j,y,dx,cs,1,RI); if( j>dx/2 ) i=0; } 
      if( i ) break;

      x=loop(bp,0,dy-1-dy/4,dx,cs,0,RI);
      x=loop(bp,x,dy-1-dy/4,dx,cs,1,RI); // strichdicke
      for( i=1,y=dy/3; y<dy-1-dy/3 && i; y++ ) // black line
      { j=loop(bp,0,y,dx,cs,0,RI);
        j=loop(bp,j,y,dx,cs,1,RI); if( j>dx/3 && ((j>2*x && dx>8) || j>x+1)) i=0; } 
      if( i ) break;

      y=dy/8; if (y<1) y=1;
      for( i=1; y<dy-1-dy/2; y++ ){ // search horizontal white gap
        x =loop(bp,dx-1,y,dx,cs,0,LE);  if(x<2) continue; // skip serifs
        j =loop(bp,dx-x,y,dy/4,cs,0,UP);
        x+=loop(bp,dx-x,y-j+1,dx,cs,0,LE); if (x>=dx/3) { i=0; break; }
      }
      if( i ) break;

      // check for vertical line on left side
      for(i=1,y=1;y<=dy/2 && i;y++)
      if( get_bw(0,dx/2,y,y,bp,cs,1) != 1 ) i=0;
      if( !i ) break;

      for(i=1,y=dy/2;y<dy && i;y++)
      if( get_bw(0,dx/3,y,y,bp,cs,1) != 1 ) i=0;
      if( !i ) break;

      i=loop(bp,dx-1,dy-1,dx,cs,0,LE); // serif or E ?
      if (i<=dx/3) {
        if (loop(bp,dx-1,(dy+4)/8,dx,cs,0,LE)>dx/8  // no serif
         || loop(bp,   0,    dy-3,dx,cs,0,RI)<1) break;
        ad=99*ad/100;
      }
      if( get_bw(dx-1-dx/4,dx-1,dy-1-dy/4,dy-1,bp,cs,1) == 1 ) break; // ~E
      if( get_bw(dx-1     ,dx-1,0        ,dy/3,bp,cs,1) != 1 ) break;

      if( loop(bp,0,  bp->y/4,dx,cs,0,RI) <
          loop(bp,0,3*bp->y/4,dx,cs,0,RI)-1 ) break;
      // if( num_hole(x0 , x1 , y0 , y1 ,box1->p,cs,NULL) >0 ) break;
      if (sdata->holes.num > 0) break;
      for(i=0,x=dx/4;x<dx-1;x++)
      if( num_cross(x,x,0,dy-2,bp,cs) == 2 ) i++;
      if ( i<1 ) break; // 0.2.4a4

      if(dy<20) /* special case of small fi, not very elegant */
      if( get_bw(   1,   1,1,1,bp,cs,1) == 1
       && get_bw(   0,   0,2,2,bp,cs,1) == 1
       && get_bw(dx-2,dx-1,0,0,bp,cs,1) == 0
       && get_bw(   0,   1,0,0,bp,cs,1) == 0
       && get_bw(   0,   0,0,1,bp,cs,1) == 0 ) break;

      // check for screen font f
      i= loop(bp,0,3*bp->y/4,dx,cs,0,RI)-1;
      if (i>=0 && loop(bp,dy-1,i,dy,cs,0,UP)<=3*dy/4 ) ad=ad*98/100;

      // check for screen font P
      i= loop(bp,bp->x-1,bp->y/4,dx,cs,0,LE);
      if (i<1) {
        j=i+loop(bp,bp->x-1-i,bp->y/4,  dx  ,cs,1,LE);
        j=  loop(bp,bp->x-1-j,bp->y/4,3*dy/4,cs,0,DO);
        if (j<=dy/2) {
          i=loop(bp,bp->x-1,0,dx,cs,0,LE);
          ad=ad*98/100;
          if (i>dx/8) break;
          if (i) ad=98*ad/100;
        }
      }

      if (!hchar) if ((box1->m2-box1->y0)*8>=dy) {  // ignore bad m1..4
       if ( num_cross(2*dx/3,2*dx/3,0,dy-1,bp,cs) < 2 ) ad=90*ad/100; // ~r
      }
      if (gchar) ad=99*ad/100;
      setac(box1,'F',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_uU(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test uU ---------------------------------------------------
   //  in Mitte so breit wie oben (bei V kontinuierlich schmaler)
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      for(y=y0+dy/8;y<y1-dy/4;y++)
        if( num_cross(x0,x1,y,y,box1->p,cs) < 2 ) break;
      if( y<y1-dy/4 ) break;
      if( get_bw(dx/2,dx/2,dy/2,dy-1,bp,cs,1)==0 ) break;
      if( get_bw(dx/2,dx-1,dy/2,dy/2,bp,cs,1)==0 ) break;
      for(i=0,x=3*dx/8;x<dx-dx/4;x++){
        y=loop(bp,x,0,dy,cs,0,DO); if(y>i)i=y; if(y<i && i>1) break;
      } if( i<dy/4 ) break; x--;
      if( get_bw(0,x   ,i-1,i-1,bp,cs,1)==0 ) break;
      if( get_bw(x,dx-1,i-1,i-1,bp,cs,1)==0 ) break;

      for(i=dy/8+2,y=dy/8;y<dy-(dy+2)/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(0,dx/2-((y>dy/2)?dx/8:0),y,y,bp,cs);
        if( y<dy/2 && num_cross(dx/2,dx-1,y,y,bp,cs)>1 ) i--; // ~{\it v}
        if( y<dy/2 && (j<1 && j>2) ) { i--; ad=90*ad/100; }
        if( y>dy/2 && j!=1 ) { i--; ad=95*ad/100; }
      } if( !i ) break;
      for(i=dy/16+1,y=dy/8;y<dy-dy/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(dx-dx/2,dx-1,y,y,bp,cs);
        if( y>dy/2 && (j<1 && j>2) ) i--;
        if( y<dy/2 && j!=1 ) i--;
      } if( !i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x, y0,    y0+dy/3,box1->p,cs,1) != 1 ) i=0;
      } if( i ) break;
      for(i=dx/4+1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x,y0+dy/3,y1-dy/3,box1->p,cs,3) != 2 ) i--;
      } if( !i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x,y1-dy/2,y1,box1->p,cs,3) == 2 ) i=0;
        if( get_bw( x, x,y1-dy/3,y1,box1->p,cs,3) == 2 ) ad=98*ad/100;
      } if( !i ) break;
      if( num_cross(0      ,dx/2,   dy/4,   dy/4,bp,cs)==2
       && num_cross(dx-dx/2,dx-1,dy-dy/4,dy-dy/4,bp,cs)==1 ) break; // ~{\it v}

      i=loop(bp,0,dy-1-dy/16,dx,cs,0,RI);
      j=loop(bp,0,dy-1-dy/8 ,dx,cs,0,RI);
      if( i<j ) break; // ~ll v0.2.4a3
      if(dy>15)
      if( loop(bp,dx-1,dy/16,dx,cs,0,LE)
        > loop(bp,dx-1,dy/8 ,dx,cs,0,LE)+1+dx/32 ) break; // ~bad 0 (thinn)
      if( hchar && dy>7)
      if(  loop(bp,   0,  dy-1,dx,cs,1,RI)==dx
        && loop(bp,dx-1,3*dy/4,dx,cs,0,LE)>dx/16
        && loop(bp,   0,3*dy/4,dx,cs,0,RI)>dx/16
        && loop(bp,dx-1,  dy/2,dx,cs,0,LE)>dx/16
        && loop(bp,   0,  dy/2,dx,cs,0,RI)>dx/16
       ) break; // melted ll

      i=loop(bp,   0,dy-2-dy/8,dx,cs,0,RI);
      j=loop(bp,dx-1,dy-2-dy/8,dx,cs,0,LE);
      if ( i>dx/4 && j>dx/4 && i+j>=dx/2) break; // v
      if (i+j>=dx/2) ad=97*ad/100;

      if ( num_cross(0,dx-1,dy/2,dy/2,bp,cs)!=2 ) ad=96*ad/100; // w
      if ( loop(bp,dx/2,dy-1,dy,cs,0,UP)>0 ) ad=98*ad/100; // w

      bc='u';
      if (gchar) ad=98*ad/100;
      if (hchar) bc='U';
      if (box1->dots>0) ad=99*ad/100;
      setac(box1,bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_micro(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i2,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test \mu &micro; MICRO_SIGN --------------------------------------
   //  in Mitte so breit wie oben (bei V kontinuierlich schmaler)
   if( gchar && !hchar )
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      for(y=y0+dy/8;y<box1->m3-dy/4;y++)
        if( num_cross(x0,x1,y,y,box1->p,cs) < 2 ) break;
      if( y<box1->m3-dy/4 ) break;
      if( get_bw(dx/2,dx/2,3*dy/8,7*dy/8,bp,cs,1)==0 ) break;
      if( get_bw(dx/2,dx-1,3*dy/8,7*dy/8,bp,cs,1)==0 ) break;
      for(y=dy/2;y<dy;y++){
        x=loop(bp,dx-1,y,dx,cs,0,LE); if(8*x>5*dx) break;
      } if( y>=dy || 2*y>box1->m3+box1->m4) break; i2=y;
      for(i=0,x=2*dx/8;x<dx-1-dx/4;x++){
        y=loop(bp,x,0,dy,cs,0,DO); if(y>i)i=y; if(y<i && i>1) break;
      } if( i<dy/4 ) break; x--;
// MX;MM;
      if( get_bw(0,x   ,i-1,i-1,bp,cs,1)==0 ) break;
      if( get_bw(x,dx-1,i-1,i-1,bp,cs,1)==0 ) break;
      for(i=dy/16+1,y=dy/8;y<dy-(box1->m4-box1->m3)-dy/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(0,dx/2,y,y,bp,cs);
        if( y<dy/2 && num_cross(dx/2,dx-1,y,y,bp,cs)>1 ) i--; // ~{\it v}
        if( y<dy/2 && (j<1 && j>2) ) i--;
        if( y>dy/2 && j!=1 ) i--;
      } if( !i ) break;
      for(i=dy/16+1,y=dy/8;y<dy-(box1->m4-box1->m3)-dy/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(dx-dx/2,dx-1,y,y,bp,cs);
        if( y>dy/2 && (j<1 && j>2) ) i--;
        if( y<dy/2 && j!=1 ) i--;
      } if( !i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x, y0,    y0+dy/4,box1->p,cs,1) != 1 ) i=0;
      } if( i ) break;
      for(i=dx/4+1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x,y0+dy/4,y1-dy/2,box1->p,cs,3) != 2 ) i--;
      } if( !i ) break;
      if( num_cross(0      ,dx/2,   dy/4,   dy/4,bp,cs)!=1 ) break;
      if( num_cross(dx-dx/2,dx-1,dy-dy/2,dy-dy/2,bp,cs)!=1 ) break;
      if( get_bw( (dx+2)/4,dx-1,dy-2-3*dy/16,dy-1,bp,cs,1) == 1 ) break;
      if( num_cross(0,dx/4,dy-1,dy-1,bp,cs)!=1 ) break;

      setac(box1,MICRO_SIGN,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_vV(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test v -------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      x=loop(bp,dx/2,0,dx,cs,1,RI)+dx/2; // be sure in the upper gap
      y=loop(bp,   x,0,(dy+1)/2,cs,0,DO)-1; // (x,y) should be in the gap
      if (x>3*dx/4 || y<dy/4) break;
      if( get_bw(x0,x0+x,y0+y,y0+y,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+x,x1,y0+y,y0+y,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+x,x0+x,y1-dy/2,y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+x,  x0+x  ,y0, y0+dy/3,box1->p,cs,1) == 1 ) // it v?
      if( get_bw(x0+x+1,x0+x+1,y0, y0+dy/3,box1->p,cs,1) == 1 ) break;

      // UVW
      if(((num_cross(     0,dx/2+1,dy/ 8,dy/ 8,bp,cs)!=1)
       && (num_cross(     0,dx/2+1,dy/16,dy/16,bp,cs)!=1) // it v
       && (num_cross(dx/2+1,dx  -1,dy/ 8,dy/ 8,bp,cs)!=1)) /* () added on Sep00 */  
      || ((num_cross(   0,dx-1,dy-1-dy/8,dy-1-dy/8,bp,cs)> 1) 
       && (num_cross(   0,dx-1,dy-1     ,dy-1     ,bp,cs)> 1)) ) break;
      // UV
      if( get_bw(0        ,dx/8,dy-1-dy/6,dy-1,bp,cs,1)==1 ) break;
      if( get_bw(dx-1-dx/8,dx-1,dy-1-dy/6,dy-1,bp,cs,1)==1 ) break;
      if( loop(bp,0   ,dy/6     ,dx,cs,0,RI)
        >=loop(bp,0   ,dy-1-dy/3,dx,cs,0,RI) ) break;
      if( loop(bp,0   ,dy-1-dy/3,dx,cs,0,RI)
         >loop(bp,0   ,dy-1-dy/8,dx,cs,0,RI)
       && loop(bp,dx-1,dy-1-dy/3,dx,cs,0,LE)
         >loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE) ) break; // better OR ?
      if( loop(bp,0   ,dy-1-dy/3,dx,cs,0,RI)
        >=loop(bp,0   ,dy-1-dy/8,dx,cs,0,RI)
       && loop(bp,dx-1,dy-1-dy/3,dx,cs,0,LE)
        >=loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE) ) ad=99*ad/100; // font21
      if( loop(bp,dx-1,dy/6     ,dx,cs,0,LE)
        >=loop(bp,dx-1,dy-1-dy/3,dx,cs,0,LE) ) break;
      x=loop(bp,0,dy-1,dx,cs,0,RI); // 3*x>dx changed to 2*x>dx May2001 JS
      x=loop(bp,x,dy-1,dx,cs,1,RI); if ( dx>14 && 2*x>dx ) break; // U
      if( num_cross(0      ,dx/2,   dy/4,   dy/4,bp,cs)==2
       && num_cross(dx-dx/2,dx-1,dy-dy/4,dy-dy/4,bp,cs)==2 ) break; // ~{\it u}
      
#if 0
      // measure thickness of lower v 
      i=loop(bp,   0,dy-1-dy/16,dx,cs,0,RI)
       +loop(bp,dx-1,dy-1-dy/16,dx,cs,0,LE);
      j=loop(bp,   0,dy-1-dy/4 ,dx,cs,0,RI)
       +loop(bp,dx-1,dy-1-dy/4 ,dx,cs,0,LE);
      if( box1->m1 && hchar && dy>15 && j>=i-dx/32 ) break;	// ~Y
#endif
      /* V has serifs only on upper site! Y also on bottom, check it. Okt00 */
      i=loop(bp,  0,   0,dx,cs,0,RI);
      i=loop(bp,  i,   0,dx,cs,1,RI); i1=i; // thickness	
      i=loop(bp,  0,   1,dx,cs,0,RI);
      i=loop(bp,  i,   1,dx,cs,1,RI); if(i>i1) i1=i; // thiggest
      i=loop(bp,  0,dy/4,dx,cs,0,RI);
      i=loop(bp,  i,dy/4,dx,cs,1,RI); i2=i;
      i=loop(bp,  0,dy  ,dx,cs,0,RI);
      i=loop(bp,  i,dy  ,dx,cs,1,RI); i3=i; // thickness	
      i=loop(bp,  0,dy-1,dx,cs,0,RI);
      i=loop(bp,  i,dy-1,dx,cs,1,RI); if(i>i3) i3=i; // thiggest
      if( y0 < box1->m2 )
      if( i1-i2 > dx/32+2 
       && i3-i2 > dx/32+2 ) break; // ~serif_Y 
      
      if( y0 < box1->m2 )   // uppercase V ?
      if( i1-i2 < dx/32+2 ) 	/* no serif detected */
      if( num_cross(0,dx-1,dy-1-dy/4,dy-1-dy/4,bp,cs)==1 ){
        j=loop(bp,   0,dy-1-dy/4 ,dx,cs,0,RI);
        j=loop(bp,   j,dy-1-dy/4 ,dx,cs,1,RI);
        if (j<i2+1) break; // ~Y
        if (j<=i2+1) ad=99*ad/100; // ~Y
      }

      ad=99*ad/100; // be carefull (remove later)
      
      if( loop(bp,0   ,dy-1-dy/4,dx,cs,0,RI)
         >loop(bp,0   ,dy-1     ,dx,cs,0,RI) ) ad=96*ad/100;

      if (gchar) ad=99*ad/100;
      bc='v';
      if( hchar ) bc='V';
      setac(box1,(wchar_t)bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_rR(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test r -------
   for(ad=d=100;dy>4 && dx>2;){     // dy>dx
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( 2*dy<box1->m3-box1->m1) break;

      if( loop(bp,dx-1,dy/2,dx,cs,0,LE)<=dx/8+1 ) break;
      if( dx>4 )
      if( loop(bp,dx-1,dy/2,dx,cs,0,LE)<=dx/8+2 ) break; // ~v Jun00

      i=dy-(dy+20)/32;	// ignore dust on the ground

      for( y=4*dy/8; y<i; y++ ){  // center down v-line
        if( y<dy-2*dy/8 && num_cross(0,dx-1,y,y,bp,cs) !=1 ) break;
        i1= loop(bp,0   ,y,dx,cs,0,RI); if(i1>3*dx/8) break;
        i2= loop(bp,dx-1,y,dx,cs,0,LE); if(i1>i2) break;
        if( (i1+(dx-i2-1))/2 >= 4*dx/8 ) break; // mass middle should be left
      }
      if (y<i) break;

      for( x=4*dx/8; x<dx; x++ ){  // right upper h-line
        if( get_bw(x,x,0,dy/4,bp,cs,1) !=1 ) break; }
      if (x<dx) break;

      if( loop(bp,dx-1,dy-1-dy/4,dx,cs,0,LE)>5*dx/8          // not a C
      && get_bw(dx-1-dx/8,dx-1,dy-1-dy/4,dy-1,bp,cs,1) ==1 ) break;

      if(  loop(bp,   0,5*dy/8,dx,cs,0,RI)<=dx/8
        && loop(bp,dx-1,5*dy/8,dx,cs,0,LE)>=5*dy/8
        && loop(bp,dx/2,  dy-1,dy,cs,0,UP)<=dy/8 ) break; // ~c

      if(  loop(bp,   0,3*dy/8,dx,cs,0,RI)
         > loop(bp,dx-1,3*dy/8,dx,cs,0,LE)+dx/8 ) {
        if( loop(bp,   0,  dy/8,dx,cs,0,RI)<dx/8 ) break; // ~z (broken)
        ad=98*ad/100;
      }

      if( loop(bp,0,dy/4,dx,cs,0,RI)>3*dx/8          // not a I
      && get_bw(0,dx/8,0,dy/4,bp,cs,1) ==1 ) break;
      // if( num_hole(x0, x1, y0 , y1 ,box1->p,cs,NULL) != 0 ) break; // not \sc P
      if (sdata->holes.num != 0) break;
      if( num_cross(0,dx-1,dy/2,  dy/2  ,bp,cs)!=1
       && num_cross(0,dx-1,dy/2+1,dy/2+1,bp,cs)!=1 ) break; // ~n 024a3

      // itallic t is sometimes not high enough, look for v-like shape
      for(y=3*dy/4;y<dy-1;y++)
      if( num_cross(0,dx-1,y,        y        ,bp,cs)==2
       && num_cross(0,dx-1,y+1+dy/32,y+1+dy/32,bp,cs)==2 ) break; // ~t
      if(y<dy-1) break;

      if( box1->dots )ad=98*ad/100; /* could be modified latin2-r */
      if (hchar) ad=96*ad/100;
      if (gchar) ad=97*ad/100;
      setac(box1,'r',ad);
      break; // not 100% sure!
   }
   // --- test R ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( num_cross(x0,x1,y1-dy/8,y1-dy/8, box1->p,cs) < 2 ) break; // ~P
      if  (loop(bp,  dx/2,    0,dy,cs,0,DO)>dy/8
        && loop(bp,  dx/2,dy/16,dx,cs,0,RI)<dx/2
        && dy>=16 ) break;
      for(i=1,y=y0+dy/8;y<=y1-dy/8 && i;y++){  // left v-line
        if( get_bw(x0     , x0+dx/2,y, y,box1->p,cs,1) != 1 ) i=0;
      } if( !i ) break;
      for(i=1,x=x0+3*dx/8;x<=x1-dx/4 && i;x++){  // upper h-line
        if( get_bw( x, x, y0,    y0+dy/4,box1->p,cs,1) != 1 ) i=0;
      } if( !i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){  // lower h-gap
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/8 && i;x++){  // vert crossed 2 ???
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+3*dy/8 && i;y++){  // upper 2 vert lines
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0+dy/3;y<=y1-dy/3 && i;y++){ // midle h line
        if( num_cross(x0,x1,y,y, box1->p,cs) == 1 ) i=0;
      } if( i ) ad=95*ad/100;  /* sometimes there is a small gap */
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){   // lower 2 vert lies
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/3,x1,y0,y0+dy/4,box1->p,cs,1) != 1 ) break; // pixel ru
      x=loop(bp,dx-1,     dy/4,dx,cs,0,LE); if(x>dx/2) break; i=x; // ru
      x=loop(bp,dx-1,     dy/2,dx,cs,0,LE); if(x<=i  ) break; i=x; // rc
      x=loop(bp,dx-1,   5*dy/8,dx,cs,0,LE); if(x>i  ) i=x;
      x=loop(bp,dx-1,   6*dy/8,dx,cs,0,LE); if(x>i  ) i=x;
      x=loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE); if(x>=i  ) break;      // rd

      i1=loop(bp,0,     dy/4,dx,cs,0,RI); // straight
      i2=loop(bp,0,     dy/2,dx,cs,0,RI);
      i3=loop(bp,0,dy-1-dy/4,dx,cs,0,RI); if( abs(i1+i3-2*i2)>1+dx/16 ) break;
      if (dy>15)
      if (loop(bp,dx-1,   dy/2,dx,cs,0,LE)>=loop(bp,dx-1, dy-1,dx,cs,0,LE)
       && loop(bp,dx-1,3*dy/16,dx,cs,0,LE)>=loop(bp,dx-1,dy/16,dx,cs,0,LE)+dx/8 ) break; // ~ff
      if (dy>7)
      if (loop(bp,dx-1,dy-2     ,dx,cs,0,LE)
         >loop(bp,dx-1,dy-2-dy/8,dx,cs,0,LE)) {
        ad=98*ad/100; 
        if (loop(bp,dx-1,dy-1-dy/4,dx,cs,0,LE)==0
         && loop(bp,dx-1,dy-2-dy/8,dx,cs,0,LE)>0 ) break; // broken B ??
      }
      j=sdata->holes.num;
      if (j != 1) {
        i=num_hole (x0,x1,y0,y1-dy/3,box1->p,cs,NULL);
        // j=num_hole (x0,x1,y0,y1     ,box1->p,cs,NULL);
        if (i==0) ad=90*ad/100; /* some times there is a small gap */ 
        if (j>1 || j>i) break;
      }
      if (sdata->holes.num < 1) ad=90*ad/100;

      if (!hchar) ad=98*ad/100;
      if ( gchar) ad=98*ad/100;
      setac(box1,'R',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_m(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,d,x,y,i1,i2,i3,i4,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test m -------
   for(ad=d=100;dx>4 && dy>3;){
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      y=dy/2;
      if( num_cross(0,dx-1,y  ,y  ,bp,cs) != 3
       && num_cross(0,dx-1,y+1,y+1,bp,cs) != 3 ) break; // m ru rn
      x =loop(bp,0,y,dx  ,cs,0,RI); if(x>  dx/4) break; // search 1st v-line
      x+=loop(bp,x,y,dx-x,cs,1,RI); if(x>  dx/2) break; i1=x; // first gap
      x+=loop(bp,x,y,dx-x,cs,0,RI); if(x>3*dx/4) break; i2=x; // 2nd v-line
      x+=loop(bp,x,y,dx-x,cs,1,RI); if(x>6*dx/8) break; i3=x; // 2nd gap
      x+=loop(bp,x,y,dx-x,cs,0,RI); if(x<5*dx/8) break; i4=x; // 3th v-line
      if( abs((i2-i1)-(i4-i3)) > 2+((i2-i1)+(i4-i3))/16 ) break; // same gap width? rn
      // the same game for the lower part =>l1 l2 l3 l4 ???
      i =loop(bp,0,5*dy/8,dx,cs,0,RI);
      i =loop(bp,i,5*dy/8,dx,cs,1,RI);
      x =loop(bp,0,dy-dy/32-1,dx,cs,0,RI);
      x =loop(bp,x,dy-dy/32-1,dx,cs,1,RI);
      if( x > i+1 ) i=1; else i=0; /* looks like serif m, Okt00 */
      for(x=i1;x<i2;x++) if( loop(bp,x,dy-1-i,dy,cs,0,UP)>dy/4 ) break;
      if(x==i2) break; // no gap detected
      for(x=i3;x<i4;x++) if( loop(bp,x,dy-1-i,dy,cs,0,UP)>dy/4 ) break;
      if(x==i4) break; // no gap detected
      for(x=i1;x<i3;x++) if( loop(bp,x,dy-2,dy,cs,1,UP)>dy/4 ) break;
      if(x==i3) break; // no middle line detected
      for(x=i1;x<i4;x++) if( loop(bp,x,0,dy,cs,0,DO)>=dy/2 ) break;
      if(x<i4) break; // gap detected
      // glued rn as m ??? hmm seems a ballance act
      if(i2-i1>i4-i3+dx/16){
       for(y=0,x=(i1+i2)/2;x<i2;x++){
         i=loop(bp,x,0,dy,cs,0,DO); 
         i=loop(bp,x,i,dy,cs,1,DO); // measure thickness
         if( i>y ) y=i; if( 2*i<y ) break;
       }
       if(x <i2) break; // unusual property for m (see n)
      }
      if(gchar) ad=90*ad/100;
      if(hchar) ad=95*ad/100;

      // {\it m}
      if( loop(bp,1,  dy/4,dx,cs,0,RI)
         >loop(bp,0,7*dy/8,dx,cs,0,RI) )
      setac(box1,'m',90*ad/100);
      
      x =loop(bp,0,dy/4,dx,cs,0,RI);
      x+=loop(bp,x,dy/4,dx,cs,1,RI);
      for( ;x<i4;x++){  // x=i1 ?
        i=loop(bp,x,0,dy,cs,0,DO);
        if (i>=dy/4)    ad=99*ad/100;
        if (i>(dy+2)/4) ad=95*ad/100;
        if (3*i>dy) break;
      }
      if(x<i4) break; // gap detected

      if (box1->dots) ad=99*ad/100;
      setac(box1,'m',ad);
      if (ad>=100) return 'm';
      break;

   }
   return box1->c;
}

static wchar_t ocr0_tT(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,yb,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test T ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // dx>1 dy>2*dx 
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      for( i=1,y=y0;y<y0+dy/6 && i;y++)		// oberer Balken?
      if( get_bw(x0+dx/4,x1-dx/8,y,y,box1->p,cs,2) == 0 ) i=0;
      if( i ) break;
      if( get_bw(        0,dx-1,     dy/2,     dy/2,bp,cs,1) != 1 ) break;
      if( get_bw(        0,dx/3,        0,     dy/8,bp,cs,1) != 1 ) break;
      if( get_bw(        0,dx/8,     dy/2,dy-1-dy/8,bp,cs,1) == 1 ) break;
      if( get_bw(        0,3*dx/16,  dy/2,dy-1-dy/4,bp,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/4,dx-1,     dy/2,dy-1-dy/4,bp,cs,1) == 1 ) break;
      // top max width x
      for( x=0,y=0;y<dy/4;y++){		// oberer Balken?
        i=loop(bp,0,y,dx,cs,0,RI);
        i=loop(bp,i,y,dx,cs,1,RI);if(i>x) x=i; // max. width
      } if( x<=dx/2 ) break;
      // center width
      for( y=dy/4;y<3*dy/4;y++){		// oberer Balken?
        i=dx/4+loop(bp,dx/4,y,dx,cs,0,RI);if(i==3*dx/16) break; // ~r
        i=     loop(bp,   i,y,dx,cs,1,RI);if(2*i>x) break;
      } if( y<3*dy/4 ) break;
      // down width
      for( y=3*dy/4;y<dy;y++){
        i=     loop(bp,dx/4,y,dx,cs,0,RI);
        i=     loop(bp,   i,y,dx,cs,1,RI);if(4*i>3*x) break; //~I
      } if( y<dy ) break;

      i =dx/2+loop(bp,dx/2,dy/4,dx,cs,0,RI);if(i>3*dx/4) break; // ~7
      i+=     loop(bp,i   ,dy/4,dx,cs,1,RI);if(i>3*dx/4) break;

      if( num_cross(0,dx-1,  dy-1,  dy-1,bp,cs) != 1
       && num_cross(0,dx-1,  dy-2,  dy-2,bp,cs) != 1 ) break;
      if( num_cross(0,dx-1,2*dy/3,2*dy/3,bp,cs) != 1
       && num_cross(0,dx-1,2*dy/3,2*dy/3,bp,cs) != 1 ) break;
      if (box1->m3 && 2*y1>box1->m3+box1->m4
        && loop(bp,0,0,dy/4,cs,0,DO)>=dy/4) break; // ~J
      if (gchar) ad=95*ad/100;
      if( loop(bp,0,dy-1,dx,cs,0,RI)<=dx/8) ad=99*ad/100; // ~J
      i= loop(bp,0,dy/2,dx,cs,0,RI);
      if( loop(bp,i,dy/2,dx,cs,1,RI)>=i ) ad=95*ad/100; // ~J
       
      setac(box1,'T',ad);
      if (ad>=100) return 'T';
      break;
   }
   // --- test t ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>=box1->m3-box1->m2-1;){     // sometimes no hchar!
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if (dy<=box1->m3-box1->m2+1) ad=96*ad/100; // bad line detection?
      for(x=0,j=y=dy/32+3*dy/16;y<4*dy/8;y++)if(y>0){ // upper cross line
        i=loop(bp,0,y,dx,cs,0,RI); if( y>dy/4 && i>dx/2 ) break;
        i=loop(bp,i,y,dx,cs,1,RI); if( i>x ) { x=i;j=y; }
        if( y<11*dy/16
         &&   num_cross(0,dx-1,y  ,y  ,bp,cs) != 1
         && ( num_cross(0,dx-1,y+1,y+1,bp,cs) != 1 || dy<13) // against noise
          ) break;
      } if( y<4*dy/8 ) break;
      yb=j; // position of hor. line
      if (dy>12 && x>4 && x>dx/2 && yb<=(dy+4)/8)
      if ( loop(bp,dx-1-3*x/4,yb,dy,cs,1,UP)
         <=loop(bp,dx-1-1*x/4,yb,dy,cs,1,UP)+1 )
      if ( loop(bp,0       ,dy/2,dy,cs,1,UP)>dx/8 ) break; // ~C

      if (x<dx/2) ad=95*ad/100; // unusual small ?
      if (x>=dx && 9*dx>=8*dy) { ad=99*ad/100; } // +

      i=loop(bp,dx-1,0,dx,cs,0,LE);
      for(y=0;y<dy/4;y++){
        if( num_cross(0,dx-1,y  ,y  ,bp,cs) == 2
         && num_cross(0,dx-1,y+1,y+1,bp,cs) == 2 ) break;
        j=loop(bp,dx-1,y,dx,cs,0,LE); if(j-i>1) break; i=j;
      }
      if( y<dy/4 ) break;  // ~f

      i=loop(bp,dx-1,yb,dx,cs,0,LE);
      for(y=dy/8;y<yb;y++)
      if( loop(bp,dx-1,y,dx,cs,0,LE)>i ) break;
      if( y==yb ) break;

      i=loop(bp,0,dy/2,dx,cs,0,RI);
      i=loop(bp,i,dy/2,dx,cs,1,RI); // thickness
      if( 2*x<3*i ) break;

      if( loop(bp,dx-1,dy/2,dx,cs,0,LE)-dx/8
        <=loop(bp,dx-1, yb ,dx,cs,0,LE) )
      if( loop(bp,dx-1, yb ,dx,cs,0,LE)-dx/8
        >=loop(bp,dx-1,yb/2,dx,cs,0,LE) ) break; // ~1 ???

      j=1;
      for(y=1;j && y<yb;  y++)  // no @@ pattern
      for(x=0;j && x<dx-2;x++){ //    ..
        if(  pixel(bp,x  ,y  )>=cs && pixel(bp,x+1,y  )>=cs
          && pixel(bp,x  ,y-1)< cs && pixel(bp,x+1,y-1)< cs ) { j=0;break; }
      } if(!j) break;

      if( num_cross(0,dx-1,dy-2,dy-2,bp,cs) == 2
       && num_cross(0,dx-1,dy-1,dy-1,bp,cs) == 2 ) break; // ~* (5er)

      if( dy>= 16
       && loop(bp,   0, 3*dy/4,dx,cs,0,RI)
        >=loop(bp,   0,   dy-2,dx,cs,0,RI)
       && loop(bp,dx-1, 3*dy/4,dx,cs,0,LE)
        <=loop(bp,dx-1,   dy-2,dx,cs,0,LE)
       && loop(bp,dx-1,      1,dx,cs,0,LE)
         <loop(bp,dx-1,3*dy/16,dx,cs,0,LE)
       && ( loop(bp,   0,      1,dx,cs,0,RI)
           >loop(bp,   0,3*dy/16,dx,cs,0,RI)
         || loop(bp,dx-1,      0,dx,cs,0,LE)==0
         || loop(bp,dx-1,      1,dx,cs,0,LE)==0) ) break; // ~f Jan02
      if(dx<8 && dy>12){ // thin f's could easily confound with t
        x=loop(bp,dx-1,3*dy/16,dx,cs,0,LE);
        if (x)
        if (loop(bp,dx-x,0,dy,cs,0,DO)<3*dy/16
         && loop(bp,   0, 3*dy/4,dx,cs,0,RI)+1
          >=loop(bp,   0,   dy-2,dx,cs,0,RI)
         && loop(bp,dx-1, 3*dy/4,dx,cs,0,LE)
          <=loop(bp,dx-1,   dy-2,dx,cs,0,LE) ) break;
      }
      if (dx>7)
      if( num_cross(   0,dx-1,2*dy/3,2*dy/3,bp,cs) >  1 
       && num_cross(   0,dx/2,2*dy/3,2*dy/3,bp,cs) >  0
       && num_cross(dx/2,dx-1,2*dy/3,2*dy/3,bp,cs) >  0 )
      if (sdata->holes.num > 0)
      if (sdata->holes.hole[0].y0 > dy/4) break; // ~6
      // if ( num_hole( x0, x1, y0+dy/4, y1, box1->p,cs,NULL) > 0 ) break; // ~6
      
     if( num_cross(0,dx-1,3*dy/4,  3*dy/4,  bp,cs) >= 2
      && num_cross(0,dx-1,3*dy/4-1,3*dy/4-1,bp,cs) >= 2 ){
        ad=99*ad/100; /* italic t ? */
        if (loop(bp,dx/2  ,dy-1,dy,cs,0,UP)>dy/4) break; // ~h
        if (loop(bp,dx/2+1,dy-1,dy,cs,0,UP)>dy/4) break; // ~h
      }

      x= loop(bp,dx-1,dy/2,dx,cs,0,LE);
      i= loop(bp,dx-1,dy/8,dx,cs,0,LE);
      if (i>x && loop(bp,dx-x,0,dy,cs,0,DO)>=dy/2) ad=90*ad/100; /* ~\ */

      x= loop(bp,0,   0,dx,cs,0,RI);
      i= loop(bp,0,   1,dx,cs,0,RI); if (i<x) x=i;
      i= loop(bp,0,dy/4,dx,cs,0,RI);
      if (i-x>1) break; // l 

      // this happens quite often, do not be to strong
      if (!hchar) ad=98*ad/100;  /* some times t is not long enough */
      if( y0>=box1->m2-(box1->m2-box1->m1)/4 ) ad=98*ad/100; /* to short */
      if( y0>=box1->m2 ) ad=98*ad/100; /* to short */
      
      if (sdata->holes.num > 0) ad=95*ad/100;
      if (gchar)      ad=98*ad/100;
      if (box1->dots) ad=90*ad/100;
      setac(box1,'t',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_sS(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	d,x,y,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad;	/* tmp-vars */

   // --- test sS near 5 ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(  dx/2,  dx/2,0,dy-1,bp,cs)!=3
       && num_cross(5*dx/8,3*dx/8,0,dy-1,bp,cs)!=3 ) break;
      if( num_cross(0,dx-1,dy/2  ,dy/2  ,bp,cs)!=1
       && num_cross(0,dx-1,dy/2-1,dy/2-1,bp,cs)!=1 ) break;
      // get the upper and lower hole koords
      y=dy/4;
      x  =loop(bp,0,y,dx,cs,0,RI); if(x>3*dx/8) break; /* slanted too */
      x +=loop(bp,x,y,dx,cs,1,RI); if(x>  dx/2) break;
      i1 =loop(bp,x,y,dx,cs,0,RI); i1=(i1+2*x)/2; // upper center x
      y=11*dy/16;
      x  =loop(bp,dx-1  ,y,dx,cs,0,LE); if(x>dx/4) break;
      x +=loop(bp,dx-1-x,y,dx,cs,1,LE); if(x>dx/2) break;
      i2 =loop(bp,dx-1-x,y,dx,cs,0,LE); i2=dx-1-(i2+2*x)/2; // upper center x
      for( y=dy/4;y<dy/2;y++ )  // Mai00 ~3
      if( get_bw(0,i1,y,y,bp,cs,1) != 1 ) break;
      if( y<dy/2 ) break;

      y=dy/2-loop(bp,dx-1,dy/2,dy/2,cs,1,UP);
//      if( !joined(bp,i1,dy/4,dx-1,y,cs) ){
        // break;  // sometimes thick small fonts have no gap
//      }
      for(y=dy/4;y<dy/2;y++){
        x=loop(bp,dx-1,y,dx,cs,0,LE);if(x>dx/8) break;
      }
      if(y==dy/2) break;  // Mai00

      y=dy/2+loop(bp,0,dy/2,dy/2,cs,1,DO);
      if( !joined(bp,0,y,i2,11*dy/16,cs) ) break;

      if (sdata->holes.num > 0)
      if (sdata->holes.hole[0].y0 > dy/4) break; // ???
      // if( num_hole( x0, x1, y0+dy/4, y1, box1->p,cs,NULL) > 0 ) break;

      // sS5 \sl z  left upper v-bow ?

      i1=loop(bp,0,  dy/16,dx,cs,0,RI);
      i2=loop(bp,0,4*dy/16,dx,cs,0,RI);
      i3=loop(bp,0,7*dy/16,dx,cs,0,RI);
      if( 2*i2+dx/32 >= i1+i3 ){
        if( 2*i2+dx/32 > i1+i3  || dx>9 ) break;
        // very small s?
        i1+=loop(bp,i1,  dy/16,dx,cs,1,RI);
        i2+=loop(bp,i2,4*dy/16,dx,cs,1,RI);
        i3+=loop(bp,i3,7*dy/16,dx,cs,1,RI);
        if( 2*i2+dx/32 >= i1+i3 ) break;
      }
      
      for(y=7*dy/16;y<5*dy/8;y++){
        if( num_cross( 0,dx-1,y  ,y  ,bp,cs)==2 )
        if( num_cross( 0,dx-1,y+1,y+1,bp,cs)==1 )
        if( num_cross( 0,dx/4,y,y,bp,cs)==1 ) break; // ~5
      } if(y<5*dy/8) break; // v0.2.4a5
      if (  loop(bp, dx-1,dy-2-dy/32,dx,cs,0,LE) 
          > loop(bp,    0,   1+dy/32,dx,cs,0,RI) + dx/4 ) break; // ~5 Dec00
      ac='s';
      if (gchar) ad=98*ad/100;
      if( hchar ){ // S but 5 is very similar! check it
        ac='S';
        y =loop(bp,dx/2,0,dy,cs,0,DO);
        y+=loop(bp,dx/2,y,dy,cs,1,DO) + dy/32;
        if( get_bw(dx/2,dx-1,y,y,bp,cs,1) != 1 ) ad=90*ad/100; // be more sure
        y+=loop(bp,dx/2,y,dy,cs,0,DO);
        y+=loop(bp,dx/2,y,dy,cs,1,DO) + dy/32;
        if( get_bw(   0,dx/2,y,y,bp,cs,1) == 1 ) ad=95*ad/100; // 5
        if( dy>=30 && dx>15 ) /* large S */
        if(   loop(bp,dx/4,3*dy/10,dy,cs,1,DO)>0 ) // check start
        if(   loop(bp,dx-2,3*dy/4 ,dy,cs,1,UP)>0 ) // check end
        if( num_cross(dx/4,dx-2,3*dy/10,3*dy/4,bp,cs)!=1 ) ad=90*ad/100; // connected?
      }
      setac(box1,ac,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_gG(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test g ---------------------------------------------------
   /* some g's have crotchet at upper right end, so hchar can be set */
   if(4*y0>=(3*box1->m1+box1->m2) )  // ~italic g
   for(ad=d=100;dx>2 && dy>4;){     // min 3x5
      if (sdata->holes.num > 3) break; /* tolerant against a tiny hole */
      if( get_bw(x0+dx/2, x0+dx/2, y1-dy/2, y1,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/4, x1     , y1-dy/4, y1,box1->p,cs,1) != 1 ) break; // ~p
      if( get_bw(x0+dx/2, x0+dx/2, y0, y0+dy/2,box1->p,cs,1) != 1 ) break;

      if( num_cross(x0+dx/2, x0+dx/2, y0, y1, box1->p,cs) < 3 )
      if( num_cross(x1-dx/2, x1-dx/2, y0, y1, box1->p,cs) < 3 ) break;
      if (sdata->holes.num < 1) break;
      for (i=0;i<sdata->holes.num;i++){
        if (sdata->holes.hole[i].y1 < 5*dy/8) break;
      } if (i==sdata->holes.num) break; // no upper hole found
      // if( num_hole ( x0, x1, y0, y0+5*dy/8, box1->p,cs,NULL) != 1 ) break;
      for(y=dy/4;y<dy;y++) if( num_cross(0,dx-1,y,y,bp,cs)==2 ) break;
      if( y==dy ) break; // ~q
      if( get_bw(0,dx/2,7*dy/8,7*dy/8,bp,cs,1) != 1 ) break; // ~q
      y =loop(bp,dx/16,0,dy,cs,0,DO); if(y<=dy/8)
      y+=loop(bp,dx/16,y,dy,cs,1,DO); if(16*y>=15*dy) break; // ~B
      
      if (num_cross(x1, x1, (y0+y1)/2, y1, box1->p,cs)>1) {
        ad=98*ad/100; // ~&
        if (num_cross(x1  , x1  , y0, (y0+y1)/2, box1->p,cs)<1 ) ad=96*ad/100;
        if (num_cross(x1-1, x1-1, y0, (y0+y1)/2, box1->p,cs)<1 ) ad=95*ad/100;
      }
      // looking for a gap 
      for (x=0,y=dy/4;y<dy-dy/4;y++){
         i=loop(bp,dx-1,y,dy,cs,0,LE); if (i>x) x=i;
      }  // in a good font x is greater dx/2
      
      if (x<dx/2) { // bad font? or %
       if( num_cross(x0,x1     ,y0+dy/4,y0+dy/4,box1->p,cs) > 2
        || num_cross(x0,x1     ,y0+dy/8,y0+dy/8,box1->p,cs) > 2) ad=90*ad/100;
       if( num_cross(x0,x1+dx/4,y1-dy/4,y1-dy/4,box1->p,cs) > 2
        || num_cross(x0,x1+dx/4,y1-dy/8,y1-dy/8,box1->p,cs) > 2) ad=90*ad/100;
      }
      if( num_cross(0,dx-1,dy/2,dy/2,bp,cs) >2 ) ad=99*ad/100; // ~/o
      
      if (box1->m4==0) ad=98*ad/100;
      if ( hchar) ad=96*ad/100;
      if (!gchar) ad=96*ad/100;
      ad=98*ad/100;
      setac(box1,'g',ad);
      break;
   }
   // --- test rundes G ---------------------------------------------
   for(ad=d=100;dx>3 && dy>4;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0     ,x0+dx/2,y0+dy/3,y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x1-dx/4,y0     ,y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y1-dy/4,y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     ,x0+dx/2,y1-dy/3,y1-dy/3,box1->p,cs,1) != 1 ) break; // ~S
      for( y=y0+dy/4;y<y1-dy/3;y++ ) 
        if( get_bw(x1-dx/2,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y==y1-dy/3 ) break;  // no gap

      if( num_cross(x0+dx/2  , x0+dx/2  , y0, y, box1->p,cs) != 1
       || num_cross(x0+dx/2+1, x0+dx/2+1, y0, y, box1->p,cs) != 1 ) break; // ~e

      x=x0; y=y1;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,UP,ST);	// left bow?
      if( y<y0+dy/4 ) break;	// filter W

      x=x1; y=y1-dy/3;		// upper right offen bow
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST);
      if( x<x1-3*dx/8 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE);
      if( x<x0+dx/2 ){	// not sure, try again (not best)
        x=x1; y=y1-dy/4;
        turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST);
        turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE);
        if( x<x0+dx/2 ) break;
      }
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP);	// upper end right midle
      if( x<=x1     ) break;
      if( y<y0+3*dy/8 ) break;
      if( y>y1-dy/4 ) break;

//    MX;
      x=x1-dx/3;y=y1;     // follow C-bow, filter S
      turmite(box1->p,&x,&y,x0,x1,y0+dy/4,y1,cs,LE,UP); // w=LE b=UP
      if( x>x0+dx/4+1 ) break; x++;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP);
      if( y>=y0 ) break;
      if (sdata->holes.num > 0) break;
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) > 0 ) break;
      if( dx>4 && dy>6){		// no (<[
        for(i=1,y=0;i && y<dy/3;y++)
          if( num_cross(0,dx-1,y,y,bp,cs) == 2 ) i=0;
        if( i ) ad=98*ad/100;
        for(i=1,y=0;i && y<dy/3;y++)
          if( num_cross(0,dx-1,dy-1-y,dy-1-y,bp,cs) == 2 ) i=0;
        if( i ) break;
      }
      for(i=1,y=dy/2;i && y<dy;y++)
      if( num_cross(0,dx-1,y,y,bp,cs) == 2 ) i=0;
      if( i ) break;
      for(i=0,y=3*dy/4;y<dy;y++){
        x=loop(bp,0,y,dx,cs,0,RI);	// Kante abfallend <=> Z
        if( x<i-dx/20 ) break;
        if( x>i ) i=x;
      } if( y<dy ) break;

      // only check the middle!
      for(i=0,i1=y=dy/4;y<dy-dy/4;y++){ // look for horizontal line
        x=loop(bp,dx-1  ,y,dx/4,cs,0,LE);
        x=loop(bp,dx-1-x,y,dx/2,cs,1,LE); if(x>i){ i=x;i1=y; }
      } if( i1<=dy/4 || i1>=dy-dy/4 ) break; // around the middle ?

      i=1;
      for(x=dx/2;x<dx-2 && i;x++)  // look for  @@ (instead +1 use +delta?) 
      for(y=dy/2;y<dy-3 && i;y++){ //           .@
        if( pixel(bp,x  ,y  )>=cs
        &&  pixel(bp,x+1,y  )< cs
        &&  pixel(bp,x+1,y-1)< cs
        &&  pixel(bp,x  ,y-1)< cs ) { i=0;break; }
      }
      if(i) ad=95*ad/100;		// ~C
      if(!hchar) ad=90*ad/100;
      if( gchar) ad=90*ad/100;

      setac(box1,(wchar_t)'G',ad);
      break;
   }
   // --- test \it g ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // dx>1 dy>2*dx 
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( num_cross(x0+dx/2,x0+dx/2,y0,y1,box1->p,cs) != 3 // pre select
       && num_cross(x0+dx/4,x1-dx/4,y0,y1,box1->p,cs) != 3 ) break;
      for( x=0,i=y=y0+dy/2;y<=y1-3*dy/16;y++){	// suche kerbe
	j=loop(box1->p,x0,y,dx,cs,0,RI);
	if( j>2 && j>dx/4 && y<y1-3 && j<dx/2 )    // long bow
	j+=loop(box1->p,x0+j-2,y+1,dx,cs,0,RI)-2;
        if( j>x ) { x=j; i=y; }
      }
      if( x<4*dx/8 ) break;
      if( num_cross(x0+dx/2,x1,i  ,y1,box1->p,cs) != 1
       && num_cross(x0+dx/2,x1,i+1,y1,box1->p,cs) != 1 ) break;
      if( num_hole(x0,x1,y0,i+1,box1->p,cs,NULL)!=1 ) break;
      if( num_hole(x0,x1,i-1,y1,box1->p,cs,NULL)!=0 ) break;
      if( loop(box1->p,x0,y1  ,dy,cs,0,RI)>dx/3 &&
          loop(box1->p,x0,y1-1,dy,cs,0,RI)>dx/3) break; // no q
      for( x=0,i=y=y0+dy/3;y<=y1-dy/3;y++){	// suche kerbe
	j=loop(box1->p,x1,y,dx,cs,0,LE); 
        if( j>x ) { x=j; i=y; }
      } if( x>dx/2 ) break;		// no g
      i1=loop(bp,dx-1,dy/8     ,dx,cs,0,LE); if(i1>dx/2) break;
      i3=loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE);
      i2=loop(bp,dx-1,dy/2     ,dx,cs,0,LE); if(i1+i3-2*i2<0) break; // konvex 
      i1=loop(bp,dx-1,dy/4     ,dx,cs,0,LE); if(i1>dx/2) break;
      i3=loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE);
      for(y=dy/4;y<dy-1-dy/4;y++){
        i2=loop(bp,dx-1,y,dx,cs,0,LE);
        if(i1+i3-2*i2<-1-dx/16) break;  // konvex from right ~g ~3
      } if(y<dy-1-dy/4) break;
      x=loop(bp,dx  -1,6*dy/8,dx,cs,0,LE); if(x>0){ x--; // robust
        y=loop(bp,dx-x-1,  dy-1,dy,cs,0,UP);
        if(y<dy/8) break; // ~q (serif!)
      }
      // %
      if( num_cross(x0,x1     ,y0+dy/4,y0+dy/4,box1->p,cs) > 2) ad=90*ad/100;
      if( num_cross(x0,x1+dx/4,y1-dy/4,y1-dy/4,box1->p,cs) > 2
       || num_cross(x0,x1+dx/4,y1-dy/8,y1-dy/8,box1->p,cs) > 2) ad=90*ad/100;
      
      if (box1->m4==0) ad=98*ad/100;
      if ( hchar) ad=96*ad/100;
      if (!gchar) ad=96*ad/100;
      setac(box1,'g',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_xX(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test xX ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(x0,x1,y0+dy/8,y0+dy/8, box1->p,cs) < 2 ) break;
      if( num_cross(x0,x1,y1-dy/8,y1-dy/8, box1->p,cs) < 2 ) break;
      if( num_cross(0,dx-1,dy-1-dy/8,dy-1-dy/8, bp,cs) < 2 ) break; // it "YX"
      for(i=1,y=y0+dy/8;y<=y1-dy/8 && i;y++){
        if( get_bw(x0     , x1-dx/4,y, y,box1->p,cs,1) != 1 ) i=0;
      } if( !i ) break;
      for(j=y=0,x=x0+dx/4;x<=x1-dx/4;x++){
        i=loop(box1->p,x,y0,y1-y0+1,cs,0,DO);
        if (i>y) { y=i; j=loop(box1->p,x,y0+y,y1-y0+1,cs,1,DO); } 
      } if( y<dy/4 || (y<dy/5 && y+j<dy/2 && dy>15) ) break;
      for(y=0,x=x0+dx/4;x<=x1-dx/4;x++){
        i=loop(box1->p,x,y1,y1-y0+1,cs,0,UP);
        if (i>y) { y=i; j=loop(box1->p,x,y1-y,y1-y0+1,cs,1,UP); } 
      } if( y<dy/4 || (y<dy/5 && y+j<dy/2 && dy>15) ) break;
      for(i=1,x=x0;x<=x0+dx/3 && i;x++){
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,x=x1-dx/3;x<=x1 && i;x++){
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/3 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0+dy/3;y<=y1-dy/3 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 1 ) i=0;
      } if( i ) break;
      for(i=1,y=y1-dy/3;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/4, x1     , y0, y0+dy/6,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/4, y1-dy/6, y1,box1->p,cs,1) != 1 ) break;
      i=loop(box1->p,x1,y0+dy/6,x1-x0+1,cs,0,LE); if(i>dx/2) break;
      j=loop(box1->p,x1,y1-dy/2,x1-x0+1,cs,0,LE); if(j<=i  ) break; i=j;
      j=loop(box1->p,x1,y1-dy/6,x1-x0+1,cs,0,LE); if(j>=i  ) break;
      i=loop(box1->p,x0,y0+dy/6,x1-x0+1,cs,0,RI); if(i>dx/2) break;
      j=loop(box1->p,x0,y0+dy/2,x1-x0+1,cs,0,RI); if(j<=i  ) break; i=j;
      j=loop(box1->p,x0,y1-dy/6,x1-x0+1,cs,0,RI); if(j>=i  ) break;
      for(i=1,x=dx-1-dx/4;x<dx && i;x++){
        if( num_cross(x,x,dy/8,dy/2,bp,cs) == 2 ) i=0;
      } if( !i ) break; // ~ glued be (b divided)
      if( dx>dy )	/* Jan00 */
      if( num_cross(dx/4,dx/8,0,dy-1,bp,cs) > 2
       && num_cross(dx/4,dx/4,0,dy-1,bp,cs) > 2 )
      if( loop(bp,0,dy/4,dx,cs,0,RI)<dx/8 ) break; // ~glued_sc
      // check %
      if( num_cross(x0,x1     ,y0+dy/4,y0+dy/4,box1->p,cs) > 2
       || num_cross(x0,x1     ,y0+dy/8,y0+dy/8,box1->p,cs) > 2) ad=90*ad/100;
      if( num_cross(x0,x1+dx/4,y1-dy/4,y1-dy/4,box1->p,cs) > 2
       || num_cross(x0,x1+dx/4,y1-dy/8,y1-dy/8,box1->p,cs) > 2) ad=90*ad/100;
      bc='x'; if(hchar) bc='X';
      setac(box1,bc,ad);
      break;
   }
   // --- test \it x ---------------------------------------------------
   for(ad=d=99;dx>4 && dy>4;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0,x0+dx/4,y0+dy/2,y0+dy/2,box1->p,cs,1) != 0 ) break;
      if( get_bw(x1-dx/4,x1,y0+dy/2,y0+dy/2,box1->p,cs,1) != 0 ) break;
      if( num_cross(x0+dx/4,x1-dx/4,y0+dy/2,y0+dy/2, box1->p,cs) != 1 ) break;
      if( num_cross(x0,x1,y0+dy/4,y0+dy/4, box1->p,cs) != 3 
       && num_cross(x0,x1,y0+dy/8,y0+dy/8, box1->p,cs) <  3 ) break;
      if( num_cross(x0,x1,y1-dy/4,y1-dy/4, box1->p,cs) != 3
       && num_cross(x0,x1,y1-dy/8,y1-dy/8, box1->p,cs) <  3 ) break;
      if( gchar ) ad=97*ad/100;
      if( hchar ) ad=96*ad/100;
      bc='x';
      setac(box1,(wchar_t)bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_yY(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad,xa,ya,xb,yb,xc,yc,xd,yd;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test italic yY --------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,dy/8,dy/8,bp,cs) < 2 
       && num_cross(0,dx-1,   1,   1,bp,cs) < 2 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,bp,cs) != 1 
       && num_cross(0,dx-1,dy-2,dy-2,bp,cs) != 1 ) break;
      if( num_cross(dx-1,dx-1,0,dy-1,bp,cs) != 1 
       && num_cross(dx-2,dx-2,0,dy-1,bp,cs) != 1 ) break;
      if( num_cross(dx/3,dx/3,dy/4,dy-1,bp,cs) != 2 
       && num_cross(dx/2,dx/2,dy/4,dy-1,bp,cs) != 2 ) break;
      for(yc=y=0,xc=x=dx/4;x<dx-dx/4;x++){  // search deepest point
        i=loop(bp,x,0,dy,cs,0,DO); if(i>y){ yc=y=i;xc=x; }
      } if( y>12*dy/16 || y<3*dy/8 ) break;
      ya=dy/8; xa=xc-loop(bp,xc,ya,dx,cs,0,LE); if(xa<  0) break;
      yb=dy/8; xb=xc+loop(bp,xc,yb,dx,cs,0,RI); if(xb>=dx) break;
      for(y=dy/8;y<yc-dy/8;y++){
       if( num_cross(xc,dx-1,y,y,bp,cs) != 1 ) break;
       if( num_cross(0 ,xc  ,y,y,bp,cs) <  1 ) break;
      } if(y<yc-dy/8) break;
      yd=dy-1-dy/8;xd=dx-1-loop(bp,dx-1,yd,dx,cs,0,LE);
      g_debug(fprintf(stderr," debug_yY: \n"
      "  /a   b \n"
      "   |  |  \n"
      "    -c/  \n"
      "  \e-d   \n");)
      g_debug(fprintf(stderr," a-e: %d %d  %d %d  %d %d  %d %d\n",
             xa,ya,xb,yb,xc,yc,xd,yd);)
      if(xd>6*dx/8) ad=99*ad/100; // why this???
      if (loop(bp,dx-1,dy-1,dx,cs,0,LE)<1) break;
      // printf(" abcd=%d %d %d %d %d %d %d %d -",xa,ya,xb,yb,xc,yc,xd,yd);
      if( get_line2(xb,yb,xd,yd,bp,cs,100)<95 ) break;
      // if( get_line2(xc,yc,xd,yd,bp,cs,100)<95 ) break;
      // printf("ok");
      bc='y';
      if(gchar && !hchar) bc='y'; else 
      if(hchar && (!gchar || dy<14)) bc='Y'; else ad=98*ad/100; // SMALL-CAPS ???
      setac(box1,bc,ad);
      break;
   }
   // --- test yY ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0,x0+3*dx/8,y0+dy/8,y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( num_cross(0,dx-1,dy/8,dy/8,bp,cs) != 2 
       && num_cross(0,dx-1,   1,   1,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,bp,cs) != 1 
       && num_cross(0,dx-1,dy-2,dy-2,bp,cs) != 1 ) break;
      if( num_cross(dx-1,dx-1,0,dy-1,bp,cs) != 1 
       && num_cross(dx-2,dx-2,0,dy-1,bp,cs) != 1 ) break;
      if( loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE)+dx/8+1  // Jul00
        < loop(bp,   0,dy-1-dy/8,dx,cs,0,RI) ) break;
      for(y=0,x=dx/4;x<dx-dx/4;x++){  // search deepest point
        i=loop(bp,x,0,dy,cs,0,DO); if(i>y) y=i;
      } if( y>10*dy/16 || y<2*dy/8 ) break;
      for(xc=xb=xa=dx,yc=yb=ya=y=0;y<dy/4;y++){
        x =loop(bp,   0  ,       y,dx,cs,0,RI); if(x<xa){ xa=x;ya=y; }
        x =loop(bp,dx-1  ,       y,dx,cs,0,LE); if(x<xb){ xb=x;yb=y; }
      }
      if(yb>dy/8) break;
      for(xc=dx,yc=y=dy/4;y<3*dy/4;y++){
        if( num_cross(0,dx-1,y,y,bp,cs) < 2 ) break;
        x =loop(bp,dx-1  ,y,dx,cs,0,LE);
        x+=loop(bp,dx-1-x,y,dx,cs,1,LE);
        x =loop(bp,dx-1-x,y,dx,cs,0,LE); if(x<=xc){ xc=x;yc=y; }
      } yc+=dy/16+1;
      xa+=    loop(bp,xa  ,ya,dx,cs,1,RI)/2;
      xb=dx-1-loop(bp,dx-1,yb,dx,cs,1,LE)/2;
      x =     loop(bp,dx-1  ,yc,dx,cs,0,LE);
      i =     loop(bp,dx-1-x,yc,dx,cs,1,LE);
      xc=dx-1-x-((i>dx/4)?i/4:i/2);    /* Feb04 */
      yd=dy-1-dy/8;xd=dx-1-loop(bp,dx-1,yd,dx,cs,0,LE); if(xd>6*dx/8) break;
      g_debug(MX;fprintf(stderr," debug_yY: \n"
      "  a   b \n"
      "   \\ /  \n"
      "    c   \n"
      "   ed     ");)
      g_debug(fprintf(stderr," a-e: %d %d  %d %d  %d %d  %d %d\n",
             xa,ya,xb,yb,xc,yc,xd,yd);)
      // check upper left line
      if( get_line2(xa,ya,xc  ,yc,bp,cs,100)<95
       && get_line2(xa,ya,xc-1,yc,bp,cs,100)<95 ) break;
      // check upper right line
      if( get_line2(xb,yb,xc  ,yc,bp,cs,100)<95
       && get_line2(xb,yb,xc-1,yc,bp,cs,100)<95 ) {
        // Times-Italic y ???
        xb+=loop(bp,xb,yb,dx/4,cs,1,RI)-1;
        yb+=loop(bp,xb,yb,dy/8,cs,1,DO)-1;
        if( get_line2(xb,yb,xc  ,yc,bp,cs,100)<95 ) break;
      }
      if( get_line2(xc,yc,xd,yd,bp,cs,100)<95 ) break;

      // decission between V and Y is sometimes very difficult
      // hope that the following code is the ultimate solution
      if( yc>=5*dy/8 && !gchar)
      if( get_line2(xa,ya,xd  ,yd,bp,cs,100)>95 )
      if( get_line2(xb,yb,xd  ,yd,bp,cs,100)>95 )
      break; // ~V
      xa=loop(bp,0,   1,dx,cs,0,RI);
      xb=loop(bp,0,dy/2,dx,cs,0,RI);
      xc=loop(bp,0,dy-1,dx,cs,0,RI);
      if( 2*xb< xa+xc   ) break; // ~V
      if( 2*xb<=xa+xc   ) ad=98*ad/100;
      if( 2*xb<=xa+xc+1 ) ad=98*ad/100;

      bc='y';
      if ((!gchar) && (!hchar)) ad=98*ad/100; 
      if(y0<box1->m2-(box1->m2-box1->m1)/4) 
        { bc='Y'; if(gchar) ad=98*ad/100; }
      // SMALL-CAPS ???
      setac(box1,(wchar_t)bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_zZ(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test zZ -------
   for(ad=d=100;dx>3 && dy>3;){     // dy>dx
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(0        ,dx/8,dy/2,dy/2,bp,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/8,dx-1,dy/2,dy/2,bp,cs,1) == 1 ) break;
      if( get_bw(0        ,dx/4,0   ,dy/4,bp,cs,1) != 1 ) break;
      if( get_bw(dx-1-dx/4,dx-1,0   ,dy/4,bp,cs,1) != 1 ) break;
      if( get_bw(0        ,dx/4,dy-1-dy/4,dy-1,bp,cs,1) != 1 ) break;
      if( get_bw(dx-1-dx/4,dx-1,dy-1-dy/4,dy-1,bp,cs,1) != 1 ) break;
      if( get_bw(dx/3,dx-1-dx/3,     dy/2,dy/2,bp,cs,1) != 1 ) break;
      if( dx<5 && num_cross(1   ,   1,0,dy-1,bp,cs) != 2 ) break;
      if( dx>8 && num_cross(dx/2,  dx/2,0,dy-1,bp,cs) != 3
               && num_cross(dx/3,2*dx/3,0,dy-1,bp,cs) != 3 ) break;
      if(  num_cross(0   ,dx-1,dy/2+1,dy/2-1,bp,cs) != 1 ) break;
      for( i=1,x=0;x<=dx/2 && i;x++ ){
        if( get_bw(x0+dx/3+x,x0+dx/3+x,y0     ,y0+dy/5,box1->p,cs,1) == 0 ) i=0;
        if( get_bw(x0+dx/8+x,x0+dx/8+x,y1-dy/5,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( !i ) break;
      // --- line from left down to right up,
      // ToDo: measure max. distance line from ideal line
      j=dx/8; if (j<2) j++; // max. distance
      for(y=dy/8;y<dy-dy/8;y++){ x=dx-1-dx*y/dy;  // straight line ? 
        if( get_bw(x-j,x+j,y,y,bp,cs,1)!=1 ) break; // pixel around ?
      } if(y<dy-dy/8) break;
      if(  loop(bp,bp->x-2,0,dx,cs,1,LE)<dx/2    // bp->x-1-dx/8 ???
       &&  loop(bp,bp->x-2,1,dx,cs,1,LE)<dx/2 )
      if(  loop(bp,bp->x-1,dy/16,dx,cs,0,LE)
         > loop(bp,bp->x-1,dy/ 8,dx,cs,0,LE)+(dx+16)/32 ) break; // ~2
      x=x0,y=y1; /* left bottom corner */
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,UP,ST); if( y<y1-dy/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP);	//
      if( x<x0+dx/2 || y>y0 ) break;		// upper right edge?
      // --- vertikal line at right end
      x=x1,y=y0+dy/4;	// horizontal line can be very thick on tt-font
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST); if( x<x1-  dx/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE); if( x<x1-5*dx/8 ) break;
      // --- vertikal line at left end
      x=x0,y=y1-dy/4;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,UP); y-=dy/16; /* fat fonts */
      // printf(" %d %d\n",x-x0,y-y0);
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,ST); if( x>x0+  dx/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,RI); if( x>x0+5*dx/8 ) break;

      // test if right edge is raising 
      for(x=dx,y=bp->y-1-dy/2;y>=dy/4;y--){ // rechts abfallende Kante/Knick?
        i=loop(bp,bp->x-1,y,x1-x0,cs,0,LE);
        if( i-2>=x ) break; if( i<x ) x=i;
      } if (y>=dy/4 ) break;
      if (sdata->holes.num != 0) break;
      // if( num_hole (x0  , x1  , y0, y1,box1->p,cs,NULL) != 0 ) break; 

      if( loop(bp,dx-1,  dy/ 8,dx,cs,0,LE)
        > loop(bp,dx-1,5*dy/16,dx,cs,0,LE) ) ad=96*ad/100; /* ~2 */
      if( loop(bp,dx-1,  dy/16,dx,cs,0,LE)
        > loop(bp,dx-1,4*dy/16,dx,cs,0,LE) ) ad=98*ad/100; /* ~2 */
      if( loop(bp,0   ,  dy/ 4,dx,cs,0,RI)<dx/2
       && loop(bp,dx-1,3*dy/ 4,dx,cs,0,LE)>dx/4 ) ad=96*ad/100; /* ~2 */

      if (gchar)  ad=96*ad/100;
      if (dx<6){  ad=99*ad/100;  // ~ italic i
        if (dy>9) ad=98*ad/100;
      }

      bc='z';
      if( hchar ) bc='Z';
      setac(box1,(wchar_t)bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_wW(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad,ya,yb,xa,xb,xc,xd,xe,t1;	/* tmp-vars */

   // ------- test w ~{\it w} ---------------
   for(ad=d=100;dx>4 && dy>3;){     // dy<=dx
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      //   xa      xe
      //    \  xc  /  <=ya  connected xa-xb-xc-xd-xe
      //     xb  xd   <=yb
      // get two lowest points  i3,i4,ya
      // out_x(box1);
      // ~ul ~uf
      // out_x(box1);
      for(y=dy/8;y<  dy/2;y++) if( num_cross(0,dx-1,y,y,bp,cs)< 2 ) break;
      if(y<dy/2) break;
      for(y=dy-1-dy/16;y>3*dy/4;y--) if( num_cross(0,dx-1,y,y,bp,cs)==2 ) break;
      if(y==3*dy/4) break; yb=y;
      t1=loop(bp,0 ,dy/4,dx,cs,0,RI);
      t1=loop(bp,t1,dy/4,dx,cs,1,RI); // thickness of line?
      for(i=j=0 ;y>  dy/4;y--) if( num_cross(0,dx-1,y,y,bp,cs)==4 ) i++;
                          else if( num_cross(0,dx-1,y,y,bp,cs)>=3 ) j++;
      if(i+5<dy/4 && 7*t1<dy) break;  // only for large letters
      if(i+j==0) break;
      if( num_cross(0,dx-1,    1,    1,bp,cs)< 2
       && num_cross(0,dx-1,dy/16,dy/16,bp,cs)< 2 ) break;
      x =loop(bp,0     ,yb,dx,cs,0,RI);
      xb=loop(bp,x     ,yb,dx,cs,1,RI);xb=x+xb/2;     if(xb>dx/2) break;
      x =loop(bp,dx-1  ,yb,dx,cs,0,LE);
      xd=loop(bp,dx-1-x,yb,dx,cs,1,LE);xd=dx-1-x-xd/2;if(xd<3*dx/8) break;
      for(y=0,xc=x=xb+1;x<xd;x++)if((i=loop(bp,x,dy-1,dy,cs,0,UP))>y){xc=x;y=i;}
      if(!y) break; ya=dy-1-y; // flat
      y=loop(bp,xc,ya,dy,cs,1,UP);if(y)y--;
      if( num_cross(0 ,xc  ,ya-y  ,ya-y  ,bp,cs)!= 2 
       && num_cross(0 ,xc  ,ya-y/2,ya-y/2,bp,cs)!= 2 ) break;
      if( num_cross(xc,dx-1,ya-y  ,ya-y  ,bp,cs)!= 2 
       && num_cross(xc,dx-1,ya-y/2,ya-y/2,bp,cs)!= 2 ) break;
      ya-=y/2;
      x =loop(bp,0     ,1 ,dx,cs,0,RI);
      xa=loop(bp,x     ,1 ,dx,cs,1,RI);
      if( x+xa>xb ){ // may be, here is a small but thick letter
         // later add some proofs
         xa=x+xa/4; 
      } else {
         xa=x+xa/2;
      }
      x =loop(bp,dx-1  ,1 ,dx,cs,0,LE);
      xe=loop(bp,dx-1-x,1 ,dx,cs,1,LE);xe=dx-1-x-xe/2;
      
//     printf(" %d %d %d %d %d %d %d %d %d %d\n",xa,1,xb,yb,xc,ya,xd,yb,xe,1);
      if( get_line2(xa   ,   1,xb,  yb,bp,cs,100)<95 
       && get_line2(xa+dx/32,1,xb,  yb,bp,cs,100)<95 ) break;
      if( get_line2(xb,yb-1,xc,ya      ,bp,cs,100)<95
       && get_line2(xb,yb-1,xc,ya+dy/32,bp,cs,100)<95
       && get_line2(xb,yb-1,xc,ya+dy/16,bp,cs,100)<95 ) break;
      if( get_line2(xc,  ya,xd,  yb,bp,cs,100)<95 
       && get_line2(xc+1,ya,xd,  yb,bp,cs,100)<95 ) break;
      if( get_line2(xd,yb,xe      ,1+dy/16,bp,cs,100)<95 
       && get_line2(xd,yb,dx-1    ,1+dy/8 ,bp,cs,100)<95  // round w
       && get_line2(xd,yb,xe+dx/20,1+dy/16,bp,cs,100)<95 ) break;
      // if( num_hole(0,dx-1,0,dy-1,bp,cs,NULL) != 0 ) break;
      // ~ur
      for(i=0,y=5*dy/8;y<dy;y++){
        x=loop(bp,dx-1,y,dx,cs,0,LE); if( x>i ) i=x; if( x<i-2 ) break;
        if (x<i) ad=98*ad/100;
      } if( y<dy ) break;
      ac=((hchar)?'W':'w');
      if (gchar) ad=98*ad/100;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test ~w {\it w} ohmega? -------
   // italic
   for(ad=d=100;dx>4 && dy>3;){     // dy<=dx
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      // ~ul ~uf
      for(y=dy/8;y<dy/2;y++) if( num_cross(0,dx-1,y,y,bp,cs)<2 ) break;
      if(y<dy/2) break;
      if( num_cross(0,dx-1,dy/2,dy/2,bp,cs)!=3 ) break;
      for(i=0,y=0;y<dy;y++)if( num_cross(0,dx-1,y,y,bp,cs)==3 ) i++; else i--;
      if(i<=0) break;  // three legs
      // out_x(box1);
      yb=dy/2;
      x =loop(bp,0     ,yb,dx,cs,0,RI);
      x+=loop(bp,x     ,yb,dx,cs,1,RI);  if(x>dx/2) break;
      xb=loop(bp,x     ,yb,dx,cs,0,RI);xb=x+xb/2;  if(xb>dx/2) break;
      x =loop(bp,dx-1  ,yb,dx,cs,0,LE);
      x+=loop(bp,dx-1-x,yb,dx,cs,1,LE);
      xd=loop(bp,dx-1-x,yb,dx,cs,0,LE);xd=dx-1-x-xd/2;if(xd<3*dx/8) break;
      if( num_cross(xb,xd,yb,yb  ,bp,cs)!= 1 ) break;
      if( num_cross(xb,xb,yb,dy-1,bp,cs)!= 1 ) break;
      if( num_cross(xd,xd,yb,dy-1,bp,cs)!= 1 ) break;
      if( num_cross(xb,xb, 0,yb  ,bp,cs)!= 0 ) break;
      if( num_cross(xd,xd, 0,yb  ,bp,cs)!= 0 ) break;
      // if( num_hole(0,dx-1,0,dy-1,bp,cs,NULL) != 0 ) break; 
      if (sdata->holes.num != 0) break;
      // ~ur
      for(i=0,y=3*dy/4;y<dy;y++){
        x=loop(bp,dx-1,y,dx,cs,0,LE); if( x>i ) i=x; if( x<i-2 ) break;
      } if( y<dy ) break;
      ac=((hchar)?'W':'w');
      if (gchar) ad=98*ad/100;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   return box1->c;
}

static wchar_t ocr0_aA(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,d,x,y,i1,i2,i3,i4,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test A ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      // first selection (grobes Sieb)
      if( get_bw(dx/2,dx/2,dy-1-dy/8,dy-1,bp,cs,1) == 1 ) break; // ~B
      if( num_cross(0,dx-1,     1  ,     1  ,bp,cs)!=1	// 600dpi
       && num_cross(0,dx-1,  dy/8  ,  dy/8  ,bp,cs)!=1
       && num_cross(0,dx-1,  dy/16 ,  dy/16 ,bp,cs)!=1
       && num_cross(0,dx-1,  dy/8+1,  dy/8+1,bp,cs)!=1 ) break;
      if( num_cross(0,dx-1,7*dy/8  ,7*dy/8  ,bp,cs)!=2
       && num_cross(0,dx-1,7*dy/8-1,7*dy/8-1,bp,cs)!=2 ) break;
      if ( num_cross(        0,dx/8,dy/8,   0,bp,cs)>0 ) break; // ~R
      for(y=dy/8;y<dy/2;y++) if( num_cross(0,dx-1,y,y,bp,cs) > 1 ) break;
      if( y==dy/2 ) break; i1=y;
      if (dy>20) i1++; /* get arround some noise fat font */

      x =loop(bp,0,i1,dx,cs,0,RI); if(x>3*dx/4) break;
      x+=loop(bp,x,i1,dx,cs,1,RI); if(x>3*dx/4) break; i2=x;
      x+=loop(bp,x,i1,dx,cs,0,RI); if(x<3*dx/8) break; i2=(x+i2)/2;
      // hole (i2,i1)
      y+=loop(bp,i2,y,dy,cs,1,DO);
      y+=loop(bp,i2,y,dy,cs,0,DO); if(y>3*dy/4) ad=ad*99/100;
      if (y>5*dy/6) break;
      
      if( sdata->holes.num != 1 || sdata->holes.hole[0].y1 >= dy-1-dy/4) break;
      // if( num_hole ( x0, x1, y0, y1-dy/4 ,box1->p,cs,NULL) != 1 ) break;
      // out_x(box1);
      i3=0;i4=0;
      for(x=dx/3;x<2*dx/3;x++){
       i4=num_cross(i2,x,y      ,dy-1,bp,cs);if(i4<1 || i4>2)
       i4=num_cross(i2,x,y+dy/16,dy-1,bp,cs);if(i4<1 || i4>2) break;
       if(i4==1) i3=x;
      } if(i4<1 || i4>2 || i3==0){
// ToDo: g_debug_A(printf(" A: x,y,i4,i3= %d %d %d %d\n",x,y,i4,i3);)
        break;
      }
      if( get_bw(dx-1-dx/4, dx-1, dy-1-dy/4, dy-1, bp,cs,1) != 1 ) break;
      /* dy/4 changed to dy/6 because of screenfonts */
      /* there are strange fonts, one has a serif on the upper end of A */
      if ( num_cross(        0,dx/8,dy/6,   0,bp,cs)>0 ) break;
      if ( num_cross(dx-1-dx/4,dx-1,   0,dy/6,bp,cs)>0 ) break;

      i1=loop(bp,dx-1,     dy/4,dx,cs,0,LE);
      i2=loop(bp,dx-1,     dy/2,dx,cs,0,LE);
      i3=loop(bp,dx-1,dy-1-dy/4,dx,cs,0,LE);
      if( 2*i2+dx/4<i1+i3 || 2*i2-dx/8>i1+i3 ) break;

      i1=loop(bp,0   ,     dy/4,dx,cs,0,RI);	// linke senkr. linie
      i2=loop(bp,0   ,     dy/2,dx,cs,0,RI);
      i3=loop(bp,0   ,dy-1-dy/4,dx,cs,0,RI);
      if( 2*i2+dx/4<i1+i3 || 2*i2-dx/8>i1+i3 || i1<i3) break;

      // lower ends could be round on thick fonts
      for(i3=dx,y=dy/4;y<7*dy/8;y++){ // increasing width
        i1=loop(bp,   0, y,dx,cs,0,RI);
        i2=loop(bp,dx-1, y,dx,cs,0,LE);
        if(i1+i2>i3+dx/16) break; if( i1+12<i3 ) i3=i1+i2;
      } if(y<7*dy/8) break;
      
      setac(box1,(wchar_t)'A',ad);
      if (ad>=100) return 'A';
      break;
   }
   // --- test a ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( get_bw(x0     , x0+dx/2, y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3, x1     , y0+dy/3, y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3, x1     , y0+dy/4, y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2, y1-dy/3, y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2, y0     , y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/3, x1-dx/3, y0     , y0     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/4, x1-dx/2, y1     , y1     ,box1->p,cs,1) != 1 )
      if( get_bw(x0+dx/4, x1-dx/3, y1-1   , y1-1   ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0     , y0+dy/2, y1     ,box1->p,cs,1) != 1 )
      if( get_bw(x0+dx/8, x0+dx/8, y0+dy/2, y1     ,box1->p,cs,1) != 1 ) break;
      if( loop(bp,3*dx/8,0,dy,cs,0,DO) > 3*dy/16 ) break; // ~d
      if( num_cross(0,dx-1,dy/4  ,dy/4  , bp,cs) >2   // ~glued am != an
       && num_cross(0,dx-1,dy/4+1,dy/4+1, bp,cs) >2 ) break;

      for( x=dx/4;x<dx-dx/4;x++ ){  // ar
        i=loop(bp,x,   0,y1-y0,cs,0,DO); if (i>dy/2) break;
        i=loop(bp,x,dy-1,y1-y0,cs,0,UP); if (i>dy/2) break;
      } if( x<dx-dx/4 ) break;

      for(i=dx/8+1,x=dx/4;x<=dx-1-dx/4 && i;x++){
        if( num_cross(x,x,0,bp->y-1, bp,cs) == 3 ) i--;
      } if( i ) break;

      i1=loop(bp,0,  dy/8,dx,cs,0,RI);
      i3=loop(bp,0,3*dy/4,dx,cs,0,RI);
      for(y=dy/8+1;y<3*dy/4;y++){
        i2=loop(bp,0,y,dx,cs,0,RI);if(2*i2>i1+i3+1) break;
      } if(y==3*dy/4) break; // ~6
      // ~ s (small thick s), look for vertikal line piece
      for(x=3*dx/4;x<dx;x++)
      if( loop(bp,x,dy/4,dy/2,cs,1,DO)>dy/4 ) break; 
      if( x==dx ) break;

      if (sdata->holes.num != 1) ad=96*ad/100;
      if( num_hole (x0     , x1     , y0+dy/3, y1 ,box1->p,cs,NULL) != 1 ) break;
      // if( num_hole (x0     , x1     , y0     , y1 ,box1->p,cs,NULL) != 1 ) break;
      if( num_hole (x0     , x1     , y0, y1-dy/3 ,box1->p,cs,NULL) != 0 ){
        i =loop(bp,0,dy/4,dx,cs,0,RI);
        i =loop(bp,i,dy/4,dx,cs,1,RI);
        if(i<dx/4+1) break;        // fat a
        i =loop(bp,0,dy/4,dx,cs,0,RI);
        i+=loop(bp,i,dy/4,dx,cs,1,RI);
        for(y=dy/4;y<dy/2;y++)
        if( num_cross(0,dx-1,y,y, bp,cs) !=2 ) break;
        x =loop(bp,0,y-1,dx,cs,0,RI);
        x+=loop(bp,x,y-1,dx,cs,1,RI);
        if(x>i) break;        // ~ 8
      }
      
      if (hchar) ad=96*ad/100;
      if (gchar) ad=96*ad/100;
      setac(box1,(wchar_t)'a',ad);
      break;
   }
   // --- test hand written a ---------------------------------------------------
   // rarely char
   for(ad=d=100;dx>3 && dy>4;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( get_bw(x0      , x0+dx/2,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/2 , x1     ,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y1-dy/2 , y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0      , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/3 , x0+dx/3,y0      , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0+dy/2 , y1-dy/3,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0      , x0     ,y1      , y1     ,box1->p,cs,1) == 1 ) break;

      if( num_cross(x0+dx/2,x0+dx/2,y0      , y1     ,box1->p,cs)  != 2 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y0      , y0     ,box1->p,cs)  != 1 ) // AND
      if( num_cross(x0+dx/3,x1-dx/3,y0+1    , y0+1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0,x1,y1      , y1     ,box1->p,cs)  != 2 )
      if( num_cross(x0,x1,y1-1    , y1-1   ,box1->p,cs)  != 2 ) break;
      if( num_cross(x0,x1,y0+dy/2 , y0+dy/2,box1->p,cs)  != 2 
       || num_cross(x0,x1,y0+dy/4 , y0+dy/4,box1->p,cs)  != 2 ) break; // Jun00

      if( num_cross(x0     ,x0     ,y0+dy/3 , y1-dy/4,box1->p,cs)  != 1 )
      if( num_cross(x0+1   ,x0+1   ,y0+dy/3 , y1-dy/4,box1->p,cs)  != 1 ) break;
      if (sdata->holes.num != 1)
      if( num_hole(x0,x1-2,y0     ,y1     ,box1->p,cs,NULL) != 1 )
      // if( num_hole(x0,x1  ,y0     ,y1     ,box1->p,cs,NULL) != 1 )
      break;
      if( num_hole(x0,x1  ,y0+dy/4,y1-1   ,box1->p,cs,NULL) != 0 ) break;
      if( num_hole(x0,x1  ,y0     ,y1-dy/5,box1->p,cs,NULL) != 0 ) break; // Q

      if( loop(bp,0   ,0   ,x1-x0,cs,0,RI)<=
          loop(bp,0   ,2   ,x1-x0,cs,0,RI)  ) break;

      if( loop(bp,dx-1,dy-1,x1-x0,cs,0,LE)>  dx/4 
       && loop(bp,dx-1,dy-2,x1-x0,cs,0,LE)> (dx+4)/8 ) break;

      x=loop(bp,dx-1,dy-1-dy/2,dx,cs,0,LE);	// should be minimum
      for( y=dy-1-dy/2;y<dy;y++ ){
        i=loop(bp,dx-1,y,x1-x0,cs,0,LE);
        if( i<x ) break; x=i;
      }
      if( y>=dy ) break;

      for( x=dx/4;x<dx-dx/4;x++ ){  // ar
        i=loop(bp,x,   0,y1-y0,cs,0,DO); if (i>dy/2) break;
        i=loop(bp,x,dy-1,y1-y0,cs,0,UP); if (i>dy/2) break;
      } if( x<dx-dx/4 ) break;

      if( num_cross(x0 , x1, y1, y1,box1->p,cs) == 1 )
      if( num_cross(x0 , x1, y0, y0,box1->p,cs) == 1 )
      if( loop(bp,dx-1,   0,y1-y0,cs,0,DO)> dy/4 
       && loop(bp,dx-1,dy-1,y1-y0,cs,0,UP)> dy/4 ) break; // ~o

      if (hchar) ad=96*ad/100;
      if (gchar) ad=96*ad/100;
      // handwritten-a (alpha)
      setac(box1,(wchar_t)'a',98);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_cC(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,i4,i5,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad,t1;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test c,C ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>2;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0     , x0+dx/3,y0+dy/2, y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2,y1-dy/3, y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2,y0     , y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( num_cross(x0,(x0+x1)/2,(y0+y1)/2,(y0+y1)/2,box1->p,cs) > 1 ) break; // ~ocr-a-[

      for(y=y0+dy/4;y<y0+3*dy/4;y++)
        if( get_bw(x0+dx/2,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y==y0+3*dy/4 ) break; i1=y;   // i1: upper end of right gap

      // measure thickness of line!
      t1=loop(bp, 0,dy/2,dx,cs,0,RI);
      t1=loop(bp,t1,dy/2,dx,cs,1,RI);
      if (t1>dx/2) break;

      for(y=i1,i2=0,x=x0+dx/2;x<x0+6*dx/8;x++){
        i=y-1+loop(box1->p,x0+dx/2,i1,dy,cs,0,DO);
        if( i>i2 ) { i2=i; }
      } if(i2<y0+5*dy/8-t1/2) break; // i2: lowest white point above lower bow

      i3=y+1-loop(box1->p,x0+5*dx/8,i1,dy,cs,0,UP);
      i =y+1-loop(box1->p,x0+4*dx/8,i1,dy,cs,0,UP); if(i<i3) i3=i;
      if(i3>y0+  dy/4+t1/2) break; // highest

      for(y=i1;y<y1-dy/8;y++)
        if( get_bw(x0+dx/2,x1,y,y,box1->p,cs,1) == 1 ) break;
      if( y-i1<dy/6 ) break; i2=y-1;   // lower end of right gap
      if( num_cross(x0+dx/2,x1,i2,y0,box1->p,cs) < 1 ) break; // ~L
      if (loop(box1->p,x0,y0+3*dy/4,dx,cs,0,RI)>dx/16)
      if( num_cross(x0+dx/2,x1,i3     ,y1,box1->p,cs) < 1
       && num_cross(x0+dx/2,x1,y1-dy/4,y1,box1->p,cs) < 1 ) break; // ~r
      
      i=1;
      for(x=dx/2;x<dx-1 && i;x++)  // look for  @@ (instead +1 use +delta?) 
      for(y=dy/2;y<dy-3 && i;y++){ //           .@
        if( pixel(bp,x  ,y  )>=cs
        &&  pixel(bp,x+1,y  )< cs
        &&  pixel(bp,x+1,y-1)< cs
        &&  pixel(bp,x  ,y-1)< cs ) { i=0;break; }
      }
      if(!i) break;		// ~G

      i=loop(bp,0,dy/2,dx,cs,0,RI);
      for(y=0;y<dy;y++)if( loop(bp,0,y,dx,cs,0,RI)<i-1-dx/32 ) break;
      if( y<dy ) break; // ~r
      // out_x(box1);
      for(i5=0,i4=dx,y=dy/2;y>=dy/4;y--){
        x =loop(bp,0,y,dx,cs,0,RI);
        x+=loop(bp,x,y,dx,cs,1,RI); if(x>i5) i5=x;
        i =loop(bp,x,y,dx,cs,0,RI); if(i<i4) i4=i;
        if( i5<x-dx/32 && i>i4+dx/32 ) break; // unusual for c, more a bad e?
      } if( y>=dy/4 ) break;
      
      if( !hchar ){ // test for e where the middle line is partly removed
        x=     loop(bp,0,dy/2,dx,cs,0,RI);
        x=x   +loop(bp,x,dy/2,dx,cs,1,RI);
        y=dy/2-loop(bp,x,dy/2,dy,cs,0,UP)-1;
        i=x   +loop(bp,x,y,dx,cs,1,RI);
        i=i   +loop(bp,i,y,dx,cs,0,RI);
        if( num_cross(x  ,x  ,1,dy/2,bp,cs) > 1
         || num_cross(x+1,x+1,1,dy/2,bp,cs) > 1 )
        if( num_cross(i-1,i-1,1,dy/2,bp,cs) > 1
         || num_cross(i  ,i  ,1,dy/2,bp,cs) > 1 ) break; // ~bad e
      }
      if( dy>16 && dy>3*dx && hchar ){	// ~[
        x= loop(bp,0,     dy/16,dx,cs,0,RI);
        x=+loop(bp,0,dy-1-dy/16,dx,cs,0,RI);
        i= loop(bp,0,     dy/2 ,dx,cs,0,RI)*2;
        if( i>=x )
        if( num_cross(0,dx-1,dy/4,dy/4,bp,cs) < 2 ) break;
       
      }
      if( get_bw(x0,x0,y0  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y0  ,y0  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y1  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x1,x1,y0+1,y1-1,box1->p,cs,1) != 1 ) break; /* ~[ */

      x =loop(bp,   0,dy/2,dx,cs,0,RI);
      i =loop(bp,dx-1,dy/2,dx,cs,0,LE);
      if( (i<dx/2 || i<3) && hchar && dy>7 )
      if( loop(bp,   0,7*dy/8,dx,cs,0,RI) > x+dx/8
       && loop(bp,   0,  dy/8,dx,cs,0,RI) > x+dx/8
       && loop(bp,dx-1,dy-1-dy/ 8,dx,cs,0,LE)
        > loop(bp,dx-1,dy-1-dy/16,dx,cs,0,LE)
       && loop(bp,dx-1,     dy/ 8,dx,cs,0,LE)
        > loop(bp,dx-1,     dy/16,dx,cs,0,LE) ) break; // ~(
        
// MX; printf(" hchar=%d i1=%d i2=%d %d\n",hchar,i1-y0,i2-y0,9*dy/16);
      // ~G without characteristic crotchet
      if (hchar && dy>15 && dx>7 && i2-y0<9*dy/16 && i1-y0<=dy/4)
      if ( loop(bp,5*dx/8,i2-y0,dy,cs,0,DO) > 2*dy/8 ){
        setac(box1,(wchar_t)'G',90);
        break;
      }

      if (hchar){
        i=1;
        for(x=dx/2;x<dx-1 && i;x++)  // look for  @@ (instead +1 use +delta?) 
        for(y=   1;y<dy/4 && i;y++){ //           .@
          if( pixel(bp,x  ,y  )>=cs
          &&  pixel(bp,x+1,y  )< cs
          &&  pixel(bp,x+1,y-1)< cs
          &&  pixel(bp,x  ,y-1)< cs ) { i=0;break; }
        }
        if (i) ad=98*ad/100;		// ~(
        if (dy>2*dx) ad=99*ad/100;
      }
      if( loop(bp,dx-1,dy/2,dx,cs,0,LE) < 6*dx/8 ) ad=98*ad/100;
      
      i= loop(bp,dx-1,dy/16,dx,cs,0,LE);
      j= loop(bp,dx/2,0    ,dy,cs,0,DO);
      if (i>=dx/2 && j>dy/8 && j>2 && j<dy/2) break; // t

      if (dy>=3*dx && dy>12) ad=99*ad/100; // (
      i= loop(bp,dx-1,dy-1,dy,cs,0,UP);
      j= loop(bp,dx/2,dy-1,dy,cs,0,UP);
      if (i==0 && j>dy/8) ad=95*ad/100; // <
      i= loop(bp,dx-1,   0,dy,cs,0,DO);
      j= loop(bp,dx/2,   0,dy,cs,0,DO);
      if (i==0 && j>dy/8) ad=95*ad/100; // <
      if (loop(bp,0,dy-1-dy/8,dx,cs,0,RI)>=dx/2) ad=95*ad/100; // <
      if (loop(bp,0,     dy/8,dx,cs,0,RI)>=dx/2) ad=98*ad/100; // <

      if (gchar) ad=96*ad/100; // could happen for 5x7 font
      bc=((hchar)?'C':'c');
      setac(box1,(wchar_t)bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_lL(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */

   // --- test L ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      i=loop(bp,dx-1,dy/2,dx,cs,0,LE); if(i<3 && dy>8) break;
      for( i=i1=0,y=y1-dy/4;y<=y1;y++){      // check bottom line (i1)
        j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>i ){ i=j;i1=y; }
      } if( i<3*dx/4 ) break; i1=i; // length of horizontal line
      // line thickness (i2)
      i=loop(box1->p,x0  ,y0+dy/2,dx,cs,0,RI); if( i>dx/2   ) break;
      j=loop(box1->p,x0+i,y0+dy/2,dx,cs,1,RI); if( i+j>dx/2 ) break; i2=j;
      if (loop(bp,dx-1,     0,dx,cs,0,LE)<dx/8
       && loop(bp,dx-1,  dy/4,dx,cs,0,LE)>dx/2
       && loop(bp,   0,5*dy/8,dx,cs,0,RI)<dx/4
       && loop(bp,dx-1,3*dy/4,dx,cs,0,LE)<dx/4) break; // ~G
      for( i=1,y=y0;y<=y1-dy/4 && i;y++){ 	// check vertical line
        j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        if ( j>(dx+2)/4+(y1-dy/4-y)*dx/2/dy ) { i=0; break; }
        x=loop(box1->p,x0+j,y,dx,cs,1,RI); 
        if( ((x>i2+1 || 4*x<3*i2) && y>y0+dy/8) || 4*x>3*i1 ) i=0;
      } if( !i ) break;
      if( num_cross(0, dx-1-dx/8, dy-1-dy/2, dy-1-dy/2,bp,cs) != 1 ) break;
      if( num_cross(0, dx-1     , dy/3     ,      dy/3,bp,cs) != 1 ) break;
      if( num_cross(0, dx-1     , dy/8     ,      dy/8,bp,cs) != 1 ) break;
      if (loop(bp,0,dy-1,dx,cs,0,RI)
         -loop(bp,0,dy-3,dx,cs,0,RI)>1+dx/16) ad=96*ad/100; // ~c

      if (gchar) ad=80*ad/100;
      if (!hchar) ad=99*ad/100;
      if (5*dx<2*dy && loop(box1->p,x0,y1,dx,cs,0,RI)>dx/4) ad=99*ad/100; // ~l
      setac(box1,(wchar_t)'L',ad);
      break;
   }
   // --- test l ---------------------------------------------------
   //  'l' see ocr1.c
   return box1->c;
}

static wchar_t ocr0_oO(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test o,O ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( get_bw(x0      , x0+dx/2,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/2 , x1     ,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y1-dy/2 , y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0      , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0+dy/3 , y1-dy/3,box1->p,cs,1) != 0 ) break;

      if( num_cross(x0+dx/2,x0+dx/2,y0      , y1     ,box1->p,cs)  != 2 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y0      , y0     ,box1->p,cs)  != 1 ) // AND
      if( num_cross(x0+dx/3,x1-dx/3,y0+1    , y0+1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y1      , y1     ,box1->p,cs)  != 1 ) // against "rauschen"
      if( num_cross(x0+dx/3,x1-dx/3,y1-1    , y1-1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0     ,x0     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x0+1   ,x0+1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      if( num_cross(x1     ,x1     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x1-1   ,x1-1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 1 ) break;
      if (sdata->holes.num != 1) break;
      
      if( loop(bp,0   ,0   ,x1-x0,cs,0,RI)<=
          loop(bp,0   ,2   ,x1-x0,cs,0,RI)  ) break;

      x=loop(bp,dx-1,dy-1-dy/3,x1-x0,cs,0,LE);	// should be minimum
      for( y=dy-1-dy/3;y<dy;y++ ){
        i=loop(bp,dx-1,y,x1-x0,cs,0,LE);
        if( i<x ) break; x=i;
      }
      if( y<dy ) break;

      // ~D
      if(     loop(bp,0,     dy/16,dx,cs,0,RI)
         +    loop(bp,0,dy-1-dy/16,dx,cs,0,RI)
         <= 2*loop(bp,0,     dy/2 ,dx,cs,0,RI)+dx/8 ) break; // not konvex
      if(   loop(bp,0   , 1+dy/16,dx,cs,0,RI) + dx/4
         <= loop(bp,dx-1, 1+dy/16,dx,cs,0,LE) ) break; // Dec00

      if( loop(bp,dx-1,     dy/16,dx,cs,0,LE)>dx/8 )
      if( loop(bp,0   ,     dy/16,dx,cs,0,RI)<dx/16 ) break;
      if( loop(bp,dx-1,dy-1-dy/16,dx,cs,0,LE)>dx/8 )
      if( loop(bp,0   ,dy-1-dy/16,dx,cs,0,RI)<dx/16 ) break;
      if( get_bw(x1-dx/32,x1,y0,y0+dy/32,box1->p,cs,1) == 0
       && get_bw(x1-dx/32,x1,y1-dy/32,y1,box1->p,cs,1) == 0
//     && ( get_bw(x0,x0+dx/32,y0,y0+dy/32,box1->p,cs,1) == 1
       && ( get_bw(0,dx/32,0,dy/32,bp,cs,1) == 1
         || get_bw(x0,x0+dx/32,y1-dy/32,y1,box1->p,cs,1) == 1 ) ) break; // ~D

       // italic a
      for(i=0,y=6*dy/8;y<dy;y++)
      if( num_cross(0,dx-1,y,y,bp,cs) > 2 ) i++; else i--; if(i>0) break; // ~a \it a
      if( hchar && 2*y0<box1->m1+box1->m2 ) i=1; else i=0;
      if (gchar) ad=99*ad/100;
      bc='o';  
      if( i ){ bc='O'; }
      if ( bc=='O' && ad>99) ad=99; /* we can never 100% sure, 0O */
      setac(box1,(wchar_t)bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_pP(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,i4,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test pP ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( get_bw(0   , dx/2,3*dy/4,3*dy/4,bp,cs,1) != 1 ) break;
      if( get_bw(0   , dx/2,  dy/2,  dy/2,bp,cs,1) <  1 ) break;
      if( get_bw(dx/4, dx-1,  dy/4,  dy/4,bp,cs,1) != 1 ) break;
      i= loop(bp,dx-1,3*dy/4,dx,cs,0,LE); if (i<dx/4) break;
      if( num_cross(x1-3*i/4,x1-3*i/4, y0, y1-3*dy/16,box1->p,cs) != 2 )
      if( num_cross(x0+dx/2  ,x0+dx/2  , y0, y1-3*dy/16,box1->p,cs) != 2 )
      if( num_cross(x0+dx/2+1,x0+dx/2+1, y0, y1-3*dy/16,box1->p,cs) != 2 ) break;
      if( num_cross(0,dx-1,7*dy/8  ,7*dy/8  ,bp,cs) != 1 )
      if( num_cross(0,dx-1,7*dy/8-1,7*dy/8-1,bp,cs) != 1 ) break;
      if( num_cross(0,dx-1,  dy/4  ,  dy/4  ,bp,cs) != 2 )
      if( num_cross(0,dx-1,  dy/4-1,  dy/4-1,bp,cs) != 3 ) // \it p with nice kurve
      if( num_cross(0,dx-1,  dy/4  ,  dy/4  ,bp,cs) != 2 )
      if( num_cross(0,dx-1,  dy/4+1,  dy/4+1,bp,cs) != 2 ) break;

      i= loop(bp,0,dy/2,dx,cs,0,RI); if(i<1) i++;
      if( num_cross(i-1,dx-1,  dy/4  ,  dy/4  ,bp,cs) != 2 )
      if( num_cross(i-1,dx-1,  dy/4+1,  dy/4+1,bp,cs) != 2 ) break;

      i1=   loop(bp, 0,3*dy/8,dx,cs,0,RI); if (i1>=dx/2) ad=90*ad/100;
      i2=i1+loop(bp,i1,3*dy/8,dx,cs,1,RI); // upper x-position of v line
      i3=   loop(bp, 0,7*dy/8,dx,cs,0,RI);
      i4=i3+loop(bp,i3,7*dy/8,dx,cs,1,RI); // lower x-position of v line
      // out_x(box1);printf(" p:");
      for ( y=dy/8; y<7*dy/8; y++ ){
        x=i2+  (8*y-3*dy)*(i4-i2)/(4*dy); // right limit of line
        i=  loop(bp,0,y,dx,cs,0,RI); if(i>x+dx/16) break;
      } if ( y<7*dy/8 ) break;
      for ( x=0,j=y=dy/3; y<7*dy/8; y++ ){ // suche unterkante
        i=loop(bp,dx-1,y,dx,cs,0,LE);
        if ( i>x ) { x=i; j=y; } if(x>dx/2) break;
      } if ( x<dx/2 || x>=dx) break;
      if( get_bw(3*dx/4,dx-1, y      , dy-1,bp,cs,1) == 1 ) break;

      i=num_hole (x0,x1,y0,y1-dy/5,box1->p,cs,NULL);
      // j=num_hole (x0,x1,y0,y1     ,box1->p,cs,NULL);
      j=sdata->holes.num;
      if (i==0 && j==0) ad=90*ad/100; /* some times there is a small gap */ 
      if (i>1 || j>1 || j>i) break;

      // check for serif F
      i=  loop(bp,bp->x-1,  bp->y/4,  dx  ,cs,0,LE);
      i=i+loop(bp,bp->x-1-i,bp->y/4,  dx  ,cs,1,LE);
      j=  loop(bp,bp->x-1-i,bp->y/4,3*dy/4,cs,0,DO);
      if (j>dy/2) ad=80*ad/100; // its an serif-F

      if( ((!hchar) && (!gchar)) || (hchar && gchar)) ad=95*ad/100;
      bc='p';
      if( hchar && ((!gchar) || dy<14)) bc='P';
      if (  hchar  &&  gchar) ad=98*ad/100; // \ss sz
      if ((!hchar) && !gchar) ad=98*ad/100;
      
      setac(box1,(wchar_t)bc,ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_qQ(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad;	/* tmp-vars */

   // --- test Q ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( get_bw(x0     ,x0+dx/3,y0+dy/3,y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3,x1     ,y0+dy/3,y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y1-dy/3,y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y0     ,y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y0+dy/3,y1-dy/2,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1     ,x1     ,y0     ,y0     ,box1->p,cs,1) == 1 ) break; //alpha
      if( num_cross(x0+dx/2,x0+dx/2,y0      , y1     ,box1->p,cs)  <  2 ) break;
      if( num_cross(x0+dx/5,x1-dx/5,y0      , y0     ,box1->p,cs)  != 1 ) // AND
      if( num_cross(x0+dx/5,x1-dx/5,y0+1    , y0+1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0     ,x0     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x0+1   ,x0+1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      if(    get_bw(x1     ,x1     ,y1-dy/8 , y1     ,box1->p,cs,1) == 0 )
      if( num_cross(x1     ,x1     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x1-1   ,x1-1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      // i=num_hole(x0,x1,y0,y1,box1->p,cs,NULL);
      i=sdata->holes.num;
      if(!i) break;
      if( i!=1 && (i!=2 || num_hole(x0,x1,y0+dy/2,y1,box1->p,cs,NULL)!=1) ) break;
      x=x1;y=y1;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST); if( x<x1-dx/2 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE);
      if( x<x1-dx/2 ) { if (gchar) ad=98*ad/100; else ad=90*ad/100; }
      if( loop(bp,0   ,0   ,dx,cs,0,RI)
        < loop(bp,0   ,2   ,dx,cs,0,RI)       ) break;
      if( loop(bp,0   ,dy/8+2,dx,cs,0,RI)
         +loop(bp,dx-1,dy/8+2,dx,cs,0,LE) > 5*dx/8 ) break; // ~4 Okt00

      x=  loop(bp,dx-1,3*dy/8,dy,cs,0,LE); if( x>dx/4 ) break;
      if( loop(bp,dx-1-x,0   ,dy,cs,0,DO)
       <= loop(bp,dx-2-x,0   ,dy,cs,0,DO)       ) break;	// 4

      if( loop(bp,dx-1,dy-2,dx,cs,0,LE)
       <= loop(bp,dx-1,dy/2,dx,cs,0,LE) )
      if( loop(bp,   1,dy-1,dy,cs,0,UP)
       <= loop(bp,dx/2,dy-1,dy,cs,0,UP) )
      if( loop(bp,   0,dy-2,dx,cs,0,RI)>dx/2 )
      if( loop(bp,   0,   0,dx,cs,0,RI)>dx/2 ) break;	// 4

      if( loop(bp,dx-1,dy/3,dx,cs,0,LE)> dx/4 ) break;
      j=loop(bp,dx/2,dy-1,dy,cs,0,UP);
      if (j>1 && j>dy/8) {
        if( get_bw(0,dx/2,dy-1-j/2,dy-1-j/2,bp,cs,1) == 1 ) {  // ~RA
           if (j<5) ad=95*ad/100;
               else break;
        }
      }

      // ~o look at the lower right side for falling line
      for(j=x=0,y=dy/2;y<dy;y++){
        i=loop(bp,dx-1,y,dx,cs,0,LE);if(i>x){ x=i; }
        if (x-i>j) j=x-i;
        if( j>dx/16 ) break;	// falling line detected
      }
      if (j==0) break; // no falling line => no Q
      if (j<=dx/16) ad=98*ad/100;
      if(y1<=box1->m3) ad=98*ad/100; // ~q no underlength! rare
      if(!hchar) ad=96*ad/100;
      ac=(wchar_t) 'Q';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test q ---------------------------------------------------
   for(ad=d=100;dx>2 && dy>3;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      for ( x=0,j=y=y0+dy/3; y<=y1-dy/8; y++ ){ // suche unterkante
        i=loop(box1->p,x0,y,dx,cs,0,RI);
        if ( i>x ) { x=i; j=y; }
      } if ( x<dx/2 || x>=dx) break;
      if( loop(box1->p,x0,j,dy,cs,0,UP)<2 ){
        ad=97*ad/100;
        if (hchar || !gchar) break; // 4 
      }
      if( get_bw(x1-dx/3, x1     , y0+dy/3, y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/3, y0+dy/3, y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/4, y1-dy/5, y1-dy/9,box1->p,cs,1) == 1 ) break;
      if( num_cross(x0+dx/2,x0+dx/2, y0, j      ,box1->p,cs) != 2 ) break;
      // if( num_hole (x0     ,x1     , y0, y1     ,box1->p,cs,NULL) != 1 ) 
      if (sdata->holes.num != 1)
        { if (dx<16) ad=98*ad/100; else break; }
      if( num_hole (x0     ,x1     , y0, j      ,box1->p,cs,NULL) != 1 )
        { if (dx<16) ad=98*ad/100; else break; }
      // ~\it g
      if( loop(bp,0,dy-1-dy/4,dx,cs,0,RI)>5*dx/8
       && get_bw(dx/4,dx/4,dy-1-dy/4,dy-1,bp,cs,1)==1 ) break; // ~\it g
      
      if(!gchar){ ad=ad*90/100; } // ~4
      if( hchar){ ad=ad*90/100; } // ~49
      setac(box1,(wchar_t)'q',ad);
      break;
   }
   return box1->c;
}

static wchar_t ocr0_iIjJ(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,i4,i5,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad,ya,yb,yc,yd,ye,yf,xa,xb;	/* tmp-vars */

   // --- test i ---------------------------------------------------
   //   if(box1->dots==1) // what about \it neighbouring ij
   for(ad=d=100;dy>4 && dx>0;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      ya=y0;
      if (box1->dots!=1) ad=98*ad/100;
      while(dy>3*dx && box1->m2){  // test for vertical i without detected dot
        i= loop(bp,dx/2,dy-1  ,dy,cs,0,UP);
        if (dy-1-i<box1->m3-2) break;
        i+=loop(bp,dx/2,dy-1-i,dy,cs,1,UP);
        if (3*abs(dy-1-i-box1->m2)>box1->m2-box1->m1) break;
        if( get_bw(x0,x1,y0,(box1->m1+box1->m2)/2,box1->p,cs,1) == 1 )
        if( get_bw(x0,x1,y1-i  ,y1-i  ,box1->p,cs,1) == 0
         || get_bw(x0,x1,y1-i-1,y1-i-1,box1->p,cs,1) == 0
         || get_bw(x0,x1,y1-i-2,y1-i-2,box1->p,cs,1) == 0 )
        {
          setac(box1,(wchar_t)'i',ad);
          return 'i'; /* beleave me, thats an "i"! */
        } break;
      }
//    if( box1->dots!=1 ) break;
      if( box1->m2 && 2*y0>=box1->m2+box1->m1 ) ya=box1->m1;

//      out_x(box1);
      for(y=ya;2*y<ya+y1;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) == 1 ) break;
      if(2*y>=ya+y1) break;		// hmm only gap
      ya=y;
      if( box1->m2 && ya>box1->m2+2 ) break;
      for(   ;2*y<y1+ya;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) != 1 ) break;
      if(2*y>=ya+y1) break;		// hmm no gap
      for(   ;2*y<y1+ya;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) == 1 ) break;
      if(2*y>=ya+y1) break;		// hmm very large gap
      yb=y;
      if( loop(bp,dx-1,y+(y1-ya+1)/32,dx,cs,0,LE)>dx/2 ) break; // unusual (right part of ouml)

      // printf(" num_cross dy/2=%d %d\n",dy/2, num_cross(0,dx-1,dy/2,dy/2,bp,cs));
      // printf(" dots=%d\n",box1->dots); out_x(box1);
      // \sl ~f. !
      for(y=(ya+y1)/2;y<=y1;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) != 1 ) break;
      if(y<=y1) break;

      y=(y1-yb+1)/2+yb-y0;  /* only one vertical line, italic i is more an tall S */
      if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break;
      for(;y<=y1-y0;y++){ if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break; } yc=y;
      for(;y<=y1-y0;y++){ if( num_cross(0,dx-1,y,y,bp,cs) != 2 ) break; } yd=y;
      if( yd<3*(y1-yb+1)/4+yb-y0 ) break;
      y=(y1-yb+1)/2+yb-y0;
      for(;y>0;y--){ if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break; } ye=y;
      for(;y>0;y--){ if( num_cross(0,dx-1,y,y,bp,cs) != 2 ) break; } yf=y;
      if( yf>(y1-yb+1)/4+yb-y0 ) break;
      if(yd>yc+2){
        xa=loop(bp,   0,yc-1,dx,cs,0,RI);
        xb=loop(bp,dx-1,yc-1,dx,cs,0,LE);
        if(
            xb-loop(bp,dx-1,yc,dx,cs,0,LE) /* Dec00 */
          > xa-loop(bp,   0,yc,dx,cs,0,RI) ){ 
          y= loop(bp,dx-xb,yc-1,dy,cs,0,DO);
          if(y>0){
            i=loop(bp,dx-xb-1,yc-1+y-1,dy,cs,0,DO);
            if( i>0 ) y+=i-1;
          }
          if( yc-1+y < yd-1 ) break;
        } else { 
          y= loop(bp,11*xa/16,yc-1,dy,cs,0,DO);
          if( yc-1+y < yd-2 ) break;
        }
      }
      if(yf<ye-2){
        x=loop(bp,0  ,ye+1,dx,cs,0,RI);
        y=loop(bp,x-1,ye+1,dy,cs,0,UP);
        i=loop(bp,x  ,ye+2-y,dy,cs,0,UP);
        if( i>0 ) y+=i-1;
        if( ye+1-y > yf+1 ) break;
      }
      if( 2*y0 <= box1->m1+box1->m2
       && loop(bp,0,   0,dx,cs,0,RI)+1
        < loop(bp,0,dx/2,dx,cs,0,RI)   ) ad=97*ad/100; // {

      if( gchar )  // i is more often than j, be sure that realy correct Mai00
      if( loop(bp,   0,2*dy/4,dx,cs,0,RI)
         -loop(bp,dx-1,2*dy/4,dx,cs,0,LE)>dx/8 ) break;
      // could be a broken + or similar thing?
      if( 3 * ya > box1->m1 + 2*box1->m2 ) ad=80*ad/100;

      if( loop(bp,dx-1,3*dy/4,dx,cs,0,LE)>dx/2
       && loop(bp,dx-1,  dy-1,dx,cs,0,LE)<dx/4 ) break; // ~d=cl

      // test for &eacute;
      if( dx>5 && num_cross(x0+dx/2,x0+dx/2, ya, y1 ,box1->p,cs) >= 3 )
        ad=95*ad/100;

      setac(box1,'i',ad);
      // if (ad>=100) return ac; // not sure that this is a good idea
      break;
   }
   // --- test j ---------------------------------------------------
   //   if(box1->dots==1) // what about \it neighbouring ij
   for(ad=d=100;dy>4 && dx>0;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      ya=y0;
      if( box1->m2 && 2*y0>=box1->m2+box1->m1 ) ya=box1->m1;

      for(y=ya;2*y<ya+y1;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) == 1 ) break;
      if(2*y>=ya+y1) break;		// hmm only gap
      ya=y;
      if( box1->m2 && ya>box1->m2+2 ) break;
      for(   ;2*y<y1+ya;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) != 1 ) break;
      if(2*y>=ya+y1) break;		// hmm no gap
      for(   ;2*y<y1+ya;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) == 1 ) break;
      if(2*y>=ya+y1) break;		// hmm very large gap
      yb=y;
      if( loop(bp,dx-1,y+(y1-ya+1)/32,dx,cs,0,LE)>dx/2 ) break; // unusual (right part of ouml)

      // printf(" num_cross dy/2=%d %d\n",dy/2, num_cross(0,dx-1,dy/2,dy/2,bp,cs));
      // printf(" dots=%d\n",box1->dots); out_x(box1);
      // \sl ~f. !
      for(y=(ya+y1)/2;y<=y1;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) != 1 ) break;
      if(y<=y1) break;

      y=(y1-yb+1)/2+yb-y0;  /* only one vertical line, italic i is more an tall S */
      if( num_cross(0,dx-1,y,y,bp,cs) >2 ) break;
      for(;y<=y1-y0;y++){ if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break; } yc=y;
      for(;y<=y1-y0;y++){ if( num_cross(0,dx-1,y,y,bp,cs) != 2 ) break; } yd=y;
      if( yd<3*(y1-yb+1)/4+yb-y0 ) break;
      y=(y1-yb+1)/2+yb-y0;
      for(;y>0;y--){ if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break; } ye=y;
      for(;y>0;y--){ if( num_cross(0,dx-1,y,y,bp,cs) != 2 ) break; } yf=y;
      if( yf>(y1-yb+1)/4+yb-y0 ) break;
      if(yd>yc+2){
        xa=loop(bp,   0,yc-1,dx,cs,0,RI);
        xb=loop(bp,dx-1,yc-1,dx,cs,0,LE);
        if(
            xb-loop(bp,dx-1,yc,dx,cs,0,LE) /* Dec00 */
          > xa-loop(bp,   0,yc,dx,cs,0,RI) ){ 
          y= loop(bp,dx-xb,yc-1,dy,cs,0,DO);
          if(y>0){
            i=loop(bp,dx-xb-1,yc-1+y-1,dy,cs,0,DO);
            if( i>0 ) y+=i-1;
          }
          if( yc-1+y < yd-1 ) break;
        } else { 
          y= loop(bp,11*xa/16,yc-1,dy,cs,0,DO);
          if( yc-1+y < yd-2 ) break;
        }
      }
      if(yf<ye-2){
        x=loop(bp,0  ,ye+1,dx,cs,0,RI);
        y=loop(bp,x-1,ye+1,dy,cs,0,UP);
        i=loop(bp,x  ,ye+2-y,dy,cs,0,UP);
        if( i>0 ) y+=i-1;
        if( ye+1-y > yf+1 ) break;
      }
      if( 2*y0 <= box1->m1+box1->m2
       && loop(bp,0,   0,dx,cs,0,RI)+1
        < loop(bp,0,dx/2,dx,cs,0,RI)   ) ad=97*ad/100; // {
      if (loop(bp,0,dy-1,dx,cs,0,RI)
         -loop(bp,0,dy-3,dx,cs,0,RI)>1+dx/16) ad=96*ad/100; // ~c

      if( gchar )  // i is more often than j, be sure that realy correct Mai00
      if( loop(bp,   0,2*dy/4,dx,cs,0,RI)
         -loop(bp,dx-1,2*dy/4,dx,cs,0,LE)<=dx/8 ) break;
      // could be a broken + or similar thing?
      if( 3 * ya > box1->m1 + 2*box1->m2 ) ad=80*ad/100;
      if (!gchar) ad=96*ad/100;
      if( box1->dots!=1 ) ad=98*ad/100;

      setac(box1,'j',ad);

      break;
   }
   // --- test I ---------------------------------------------------
   for(ad=d=100;dy>4 && dy>dx && 5*dy>4*(box1->m3-box1->m2);){     // min 3x4
      if( box1->dots==1 ) break;
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */

      x =loop(bp,0,  dy/2,dx,cs,0,RI);	// konvex? divided Q
      if(loop(bp,0,7*dy/8,dx,cs,0,RI) > x+dx/8) break;
      for( y=dy/16;y<dy-1-dy/16;y++ )
      if( num_cross(0, dx-1, y       , y       ,bp,cs) != 1 )
      if( num_cross(0, dx-1, y+dy/16 , y+dy/16 ,bp,cs) != 1 ) break;
      if( y<dy-1-dy/16 ) break;
      x =loop(bp,0,  dy/2,dx,cs,0,RI);
      i5=loop(bp,x,  dy/2,dx,cs,1,RI); // center width
      for(y=dy/4;y<3*dy/4;y++ ){ // same width ?
        x =loop(bp,0,  y,dx,cs,0,RI);
        x =loop(bp,x,  y,dx,cs,1,RI); // width
        if( abs(x-i5)>1+dx/8 ) break;
      } if( y<3*dy/4 ) break;
      // out_x(box1);

      // upper max width
      for(i2=i1=0,y=0;y<dy/4;y++ ){
        x =loop(bp,0,  y,dx,cs,0,RI);
        x =loop(bp,x,  y,dx,cs,1,RI); if(x>i1){ i1=x;i2=y; }
      }
      for(i4=i3=0,y=3*dy/4;y<dy;y++ ){
        x =loop(bp,0,  y,dx,cs,0,RI);
        x =loop(bp,x,  y,dx,cs,1,RI); if(x>i3){ i3=x;i4=y; }
      }
      if( abs(i3-i1)>1+dx/8 ) break;  // if i3>>i5 more sure!
      if( i1>i5 ){ // look for edges else *80%
      } 
      if(i1+1<i5 && !hchar) break; // Jun00

      // calculate upper and lower mass center
      x =loop(bp,0,     dy/8,dx,cs,0,RI); i1=x;
      x+=loop(bp,x,     dy/8,dx,cs,1,RI); i1=(i1+x-1)/2;

      x =loop(bp,0,dy-1-dy/8,dx,cs,0,RI); i2=x;
      x+=loop(bp,x,dy-1-dy/8,dx,cs,1,RI); i2=(i2+x-1)/2;
      x =loop(bp,0,dy-2-dy/8,dx,cs,0,RI); i=x;
      x+=loop(bp,x,dy-2-dy/8,dx,cs,1,RI); i=(i+x-1)/2; if( i>i2 ) i2=i;

      // MX;
      // printf(" get_line(%d,%d) %d\n",i1,i2,
      //    get_line2(i1,dy/8,i2,dy-1-dy/8,bp,cs,100));
      if( get_line2(i1,dy/8,i2,dy-1-dy/8,bp,cs,100)<95 ) break;
      x =(i1-i2+4)/8; i1+=x; i2-=x;

      // upper and lower width (what about serifs?)
      y=dy/8;
      x =loop(bp,i1,   y+0,dx,cs,1,LE); i=x;
      x =loop(bp,i1,   y+1,dx,cs,1,LE); if(x>i)i=x;
      x =loop(bp,i1,   y+0,dx,cs,1,RI); j=x;
      x =loop(bp,i1,   y+1,dx,cs,1,RI); if(x>j)j=x; if(abs(i-j)>1+dx/8)break;
      x =loop(bp,i2,dy-y-1,dx,cs,1,LE); j=x;
      x =loop(bp,i2,dy-y-2,dx,cs,1,LE); if(x>j)j=x; if(abs(i-j)>1+dx/8)break;
      x =loop(bp,i2,dy-y-1,dx,cs,1,RI); j=x;
      x =loop(bp,i2,dy-y-2,dx,cs,1,RI); if(x>j)j=x; if(abs(i-j)>1+dx/8)break;

      if(dy>15)  // v024a4
      if( loop(bp,dx-1,dy/16 ,dx,cs,0,LE)
        > loop(bp,dx-1,dy/4  ,dx,cs,0,LE)+1+dx/32 ) break; // ~bad ) (thinn)

      for(i=0,y=dy/16;y<15*dy/16 && i<2;y++)
      if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) i++;
      if( i>1 ) break;

      if(!hchar){	// right part (bow) of h is never a l
        if( get_bw(dx/4,dx/4,   0,dy/4,bp,cs,1) == 1
         && get_bw(dx/4,dx/4,dy/2,dy-1,bp,cs,1) == 0 ) break;
        if( loop(bp,   0,dy/4,dx,cs,0,RI)> dx/4
         && loop(bp,dx-1,dy/4,dx,cs,0,LE)<=dx/4
         && loop(bp,   1,   0,dy,cs,0,DO)<=dy/4 ) break; // ~z
      }

      if( get_bw(x1,x1,y0  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y0  ,y0  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y1  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x0,x0,y0+1,y1-1,box1->p,cs,1) != 1 ) break; /* ~] */

      x =loop(bp,   0,dy/2,dx,cs,0,RI);	// konvex/konkav? ~()
      i =loop(bp,dx-1,dy/2,dx,cs,0,LE);
      if( loop(bp,   0,7*dy/8,dx,cs,0,RI) > x+dx/8
       && loop(bp,   0,  dy/8,dx,cs,0,RI) > x+dx/8
       && loop(bp,dx-1,7*dy/8,dx,cs,0,LE) < i-dx/8
       && loop(bp,dx-1,  dy/8,dx,cs,0,LE) < i-dx/8 ) break; // ~(
      if( loop(bp,   0,7*dy/8,dx,cs,0,RI) < x-dx/8
       && loop(bp,   0,  dy/8,dx,cs,0,RI) < x-dx/8
       && loop(bp,dx-1,7*dy/8,dx,cs,0,LE) > i+dx/8
       && loop(bp,dx-1,  dy/8,dx,cs,0,LE) > i+dx/8 ) break; // ~)
      if(   loop(bp,   0,  dy/8,dx,cs,0,RI)
       -(dx-loop(bp,dx-1,7*dy/8,dx,cs,0,LE)) > dx/4 ) break; // ~/
      if(   loop(bp,   0,    0,dx,cs,0,RI) > dx/2  // ToDo: check for serifs
        &&  loop(bp,   0, dy/8,dx,cs,0,RI) > dx/2 
        &&  loop(bp,dx-1,dy-1     ,dx,cs,0,LE) > dx/2
        &&  loop(bp,dx-1,dy-1-dy/8,dx,cs,0,LE) > dx/2 ) ad=98*ad/100; // ~/
                               
      if (box1->m2 && 3*y0>box1->m1+2*box1->m2) 
      if( get_bw(x0+dx/8,x1-dx/8,box1->m1,(box1->m1+box1->m2)/2,box1->p,cs,1) == 1 )
      break; // ~i

      if(i1+1<i5 && !hchar){ ad=65*ad/100; } // ~ slanted I

      // be sure only for serif
      i3=loop(bp,dx-1,     dy/4,dx,cs,0,LE);
      i4=loop(bp,   0,dy-1-dy/4,dx,cs,0,RI);
      if (i3<2 || i4<2 
        || get_bw(x1-i3/4,x1-i3/4,y0,y0+dy/4,box1->p,cs,1) != 1
        || get_bw(x0+i4/4,x0+i4/4,y1-dy/4,y1,box1->p,cs,1) != 1 )
         ad=99*ad/100;  // ToDo: improve this     
      if(!hchar){ ad=70; } // ~bad_small_r
      if (box1->m4 && y1<box1->m4) { // probably lower dot?
        if ((dx>2 && get_bw(x0+1,x1-1,y1+1,box1->m4,box1->p,cs,1) == 1)
         || (dx<3 && get_bw(x0  ,x1  ,y1+1,box1->m4,box1->p,cs,1) == 1)) {
          ad=96*ad/100;
        }
      }  // ~!

      if( get_bw(x0,x1,y0,y1,box1->p,cs,2) == 0 ) ad=99*ad/100;
      if (gchar) ad=96*ad/100; // J
      if (box1->m3 && 2*y1<=box1->m2+box1->m3) ad=96*ad/100; // '

      setac(box1,(wchar_t)'I',ad);
      break;
   }
   // --- test J --------------------------------------------------- 28Jun00
   for(ad=d=100;dy>4 && dy>=dx && dx>2;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( get_bw(x0+dx/4,x0+dx/4,y1-dy/4,y1,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y0+dy/4,y0+dy/4,box1->p,cs,1) == 0
       && get_bw(x0+dx/2,x0+dx/2,y1-dy/4,y1-dy/4,box1->p,cs,1) == 0
       && get_bw(x0+dx/2,x0+dx/2,y0+dy/4,y1-dy/4,box1->p,cs,1) == 1 ) break; // ~d
      if( get_bw(dx/2,dx/2,   0,dy/8,bp,cs,1) == 0
       && get_bw(dx/2,dx/2,dy/8,dy/2,bp,cs,1) == 1
       && num_hole(x0,x1,y0+dy/8,y1,box1->p,cs,NULL) > 0 ) break; // ~d Jul00
       
      if (box1->m3>0 && 2*y0>box1->m2+box1->m3 && y1>box1->m3 ) break; // ~,
      if (box1->m3>0 && y0<box1->m2 && 3*y1<box1->m2+2*box1->m3 ) break; // ~'
      if (box1->m3>0 && 3*y0>=2*box1->m1+box1->m2
                     && 3*y1>=box1->m3+2*box1->m4 ) break; // ~pg

      if( loop(bp,dx/2,   0,dy/4,cs,0,DO)>=dy/4
       && loop(bp,   0,dy/4,dx  ,cs,0,RI)< dx/2-1
       && loop(bp,dx-1,dy/4,dx  ,cs,0,LE)< dx/2-1 ) break; // ~Y
      if( loop(bp,5*dx/8, 0,dy/4,cs,0,DO)>=dy/4
       && loop(bp,   0,dy/4,dx  ,cs,0,RI)< 5*dx/8-1
       && loop(bp,dx-1,dy/4,dx  ,cs,0,LE)< 3*dx/8-1 ) break; // ~Y

      if( loop(bp,0   ,dy-1,dy/4,cs,0,UP)>=dy/4
       || loop(bp,dx-1,dy-1,dx  ,cs,0,LE)< dx/4 ){
       if( loop(bp,0   ,3*dy/8,dx,cs,0,RI)
         <=loop(bp,dx-1,3*dy/8,dx,cs,0,LE)+dx/6 ) break;
       if( loop(bp,0   ,  dy/6,dx,cs,0,RI)
         <=loop(bp,dx-1,  dy/6,dx,cs,0,LE)+dx/6 ) break;
      }
      if( loop(bp,dx/5,5*dy/8,dx,cs,0,RI)+dx/5
        <=loop(bp,dx-1,5*dy/8,dx,cs,0,LE)      
      &&  loop(bp,0   ,4*dy/8,dx,cs,0,RI)+dx/5
        <=loop(bp,dx-1,4*dy/8,dx,cs,0,LE)      ) break;
      // MX;
      // test ob rechte Kante gerade
      for(x=0,y=dy/32;y<dy;y++){ // rechts abfallende Kante/Knick?
        i=loop(bp,dx-1,y,dx,cs,0,LE);
        if( i+1<x ) break;
        if( i>x ) x=i;
      } if (y<dy ) break; 

      if( get_bw(x0     ,x0+dx/4,y0+dy/8,5*dy/8,box1->p,cs,1) == 1 ) break;
      if( get_bw(dx-1   ,dx-1   ,dy-1   ,dy-1  ,bp,cs,1) == 1 ) break;
      if( get_bw(x0     ,x0+dx/2,y1-dy/5,y1    ,box1->p,cs,1) != 1 ) break;
      if( box1->dots==1 ) { setac(box1,(wchar_t)'j',99*ad/100); break; }
      if( box1->dots!=0 ) break;
      if(dy>3*dx){
       if( get_bw(0,dx-1,dy-1,dy-1,bp,cs,2) == 0
        || get_bw(0,dx-1,dy-2,dy-2,bp,cs,2) == 0 ) break; // ~]
       if( get_bw(0,   0,   0,   1,bp,cs,1) == 1
        && loop(bp,dx-1,dy-1,dx,cs,0,LE) < 2 ) break;  // ~]
      }
      if( loop(bp,dx-1,dy-1,dx,cs,0,LE) > 3*dx/4  // ~)
       && loop(bp,dx-1,0   ,dx,cs,0,LE)
        > loop(bp,dx-1,dy/4,dx,cs,0,LE) ) break; // ~)
        
      if( num_cross(0,dx-1,dy/2,dy/2,bp,cs) != 1
       || num_cross(0,dx-1,dy/4,dy/4,bp,cs) != 1 ) break; //~P

      if (!gchar) {
        if( get_bw(0,0,dy/2,dy-1,bp,cs,1) == 0 ) { ad=98*ad/100; } // l
        if( loop(bp,   0,dy/2,dx,cs,0,RI) <=
            loop(bp,dx-1,dy/2,dx,cs,0,LE)+2 ) ad=99*ad/100;
        if( loop(bp,dx-1,dy-2,dx,cs,0,LE) >
            loop(bp,dx-1,dy-1,dx,cs,0,LE) ) ad=97*ad/100; /* I serif ? */
        if( loop(bp,dx-1,dy-2,dx,cs,0,LE) > dx/2 ) ad=97*ad/100; /* I slanted ? */
      }


      if(!hchar){ ad=90*ad/100; } // ~bad_small_r
      ac=(wchar_t) 'J';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   return box1->c;
}

static wchar_t ocr0_brackets(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i1,i2,i3,i4,i5,i6,hchar=sdata->hchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ad,r1,r2;	/* tmp-vars */
   wchar_t bc=UNKNOWN;

   // --- test ()<> ------------------------------------------------
//   if(bc==UNKNOWN)
//   if(!box1->dots)
   for(ad=d=100;dx>2 && dy>4;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
#if 1
      for(i=y=0;y<dy;y++){
        if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) i++;
        if( loop(bp,   0,y,dx,cs,0,RI)
          + loop(bp,dx-1,y,dx,cs,0,LE)<3*dx/8 ) break;
      }
      if( y<dy ) break;
      if ( i>2 || (i>0 && dy<16)) break;
#endif
      /* look for the extrema => r1..r2 */
      for(i=dx,r1=r2=y=dy/2-dy/8;y<=dy/2+dy/8;y++){
        j=loop(bp,   0,y,dx,cs,0,RI); if(j==i) r2=y; if(j<i){ r2=r1=y; i=j; } 
        j=loop(bp,dx-1,y,dx,cs,0,LE); if(j==i) r2=y; if(j<i){ r2=r1=y; i=j; } 
      } y=(r1+r2)/2;
      i1=loop(bp,dx-1,     dy/16,dx,cs,0,LE);
      i2=loop(bp,dx-1,y         ,dx,cs,0,LE);
      i3=loop(bp,dx-1,dy-1-dy/16,dx,cs,0,LE);
      i4=loop(bp,   0,dy/16     ,dx,cs,0,RI);
      i5=loop(bp,   0,y         ,dx,cs,0,RI);
      i6=loop(bp,   0,dy-1-dy/16,dx,cs,0,RI);
      if(dx>dy){
        if(i2==0 && 3*i5>dx && i4<=dx/8 && i6<=dx/8) { setac(box1,(bc='>'),98);break; }
        if(i5==0 && 3*i2>dx && i1<=dx/8 && i3<=dx/8) { setac(box1,(bc='<'),98);break; }
      }
      if( dx > 4 && 2*dx>=dy ){  // 5x10 screen-font
       ad=98;
       if (dx<8) ad=99*ad/100;
       if (dx<6) ad=96*ad/100;
       if( 2*dx > JOB->res.avX && 4*dx>dy ) ad=98;
// printf(" %d %d %d %d %d %d\n",i5,i1,i3,i2,i4,i6);
       if( i5==0     && i1<=dx/8+1 && i3<=dx/8+1 && i1+i3<=dx/8+1
        && i2>=dx/2  && i4>=3*dx/4 && i6>=3*dx/4 ) {
         if (2*loop(bp,   0,     y/2,dx,cs,0,RI)+1+dx/16<i4+i5) ad=95*ad/100;
         if (2*loop(bp,   0,dy-1-y/2,dx,cs,0,RI)+1+dx/16<i6+i5) ad=95*ad/100;
         setac(box1,(bc='<'),ad);break; 
       }
       if( i2==0     && i4<=dx/8   && i6<=dx/8
        && i5>=dx/2  && i1>=3*dx/4 && i3>=3*dx/4 ) {
         if (2*loop(bp,dx-1,     y/2,dx,cs,0,LE)+1+dx/16<i1+i2) ad=95*ad/100;
         if (2*loop(bp,dx-1,dy-1-y/2,dx,cs,0,LE)+1+dx/16<i3+i2) ad=95*ad/100;
         setac(box1,(bc='>'),ad);break; 
       }
      }
      
      i1=loop(bp,dx-1,dy/16,dx,cs,0,LE);
      i2=loop(bp,dx-1,dy/2 ,dx,cs,0,LE);
      i3=loop(bp,dx-1,dy-1 ,dx,cs,0,LE);
      i4=loop(bp,   0,0   ,dx,cs,0,RI);
      i5=loop(bp,   0,dy/2,dx,cs,0,RI);
      i6=loop(bp,   0,dy-1,dx,cs,0,RI);
      i=(box1->m4+box1->m3)/2-box1->m2;
      //  
      //  out_x(box1);printf("() %d %d %d %d %d %d %d\n",i,i1,i2,i3,i4,i5,i6);
      if(2*i2<i1+i3 && 2*i5>i4+i6 && 2*dx<dy && dy>=i)  { setac(box1,(bc=')'),98);break; }
      if(2*i2>i1+i3 && 2*i5<i4+i6 && 2*dx<dy && dy>=i){
        for(x=y=0;y<dy/4;y++){
          i=loop(bp,0,y,dx,cs,0,RI);if( i>x ) x=i;
        }
        for(y=0;y<dy/4;y++){
          i=loop(bp,0,y+dy/8,dx,cs,0,RI);if( i<x ) break;
        }
        if( y==dy/4 ) break; // ~l (left upper side must be convex) Jul00
         { setac(box1,(bc='('),98);break; }
      }

      // ~lI      
      for(i=i4,y=0;y<dy;y++){
        x=loop(bp,0   ,y,dx,cs,0,RI);if(abs(x-i)>dx/6+1 ) break; i=x;
      } if( y<dy ) break;
      for(i=i1,y=0;y<dy;y++){
        x=loop(bp,dx-1,y,dx,cs,0,LE);if(abs(x-i)>dx/6+1 ) break; i=x;
      } if( y<dy ) break;

      if(i1<=dx/8 && i2>=dx/4 && i5>=dx/4 && i6<=dx/8 && i4-(dx-i3)>dx/4 ) { setac(box1,(bc='/'),96); }
      if(i4<=dx/8 && i2>=dx/4 && i5>=dx/4 && i3<=dx/8 && i6-(dx-i1)>dx/4 ) { setac(box1,(bc='\\'),96); }
      if(i1<=dx/10 && i2>dx/4 && i5>dx/4 && i6<=dx/10 && i4-(dx-i3)>dx/4 ) { setac(box1,(bc='/'),99);break; }
      if(i4<=dx/10 && i2>dx/4 && i5>dx/4 && i3<=dx/10 && i6-(dx-i1)>dx/4 ) { setac(box1,(bc='\\'),99);break; }
      break;
   }
   //  --------- test [] --------------------------------
   if(bc==UNKNOWN)
   for(ad=d=98;dx>3 && dy>4 && dy>2*dx;){ // only for accurate font at the moment
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if (!hchar) ad=97*ad/100; 
      for(y=0;y<dy;y++){
        if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break;
      } if (y<dy) break;
      if( get_bw(x0,x1,y0  ,y0  ,box1->p,cs,2) == 2 
       && get_bw(x0,x1,y0+1,y0+1,box1->p,cs,2) == 2 ) break;
      if( get_bw(x0,x1,y1  ,y1  ,box1->p,cs,2) == 2
       && get_bw(x0,x1,y1-1,y1-1,box1->p,cs,2) == 2 ) break;
      if( get_bw(x0     ,x0,y0     ,y1     ,box1->p,cs,2) == 0
       || get_bw(x0+1 ,x0+1,y0     ,y1     ,box1->p,cs,2) == 0 )
      if( get_bw(x0+dx/2,x1,y0+dy/4,y1-dy/4,box1->p,cs,1) == 0 ) { setac(box1,(bc='['),ad);break; }
      if( get_bw(x1     ,x1,y0     ,y1     ,box1->p,cs,2) == 0
       || get_bw(x1-1 ,x1-1,y0     ,y1     ,box1->p,cs,2) == 0 )
      if( get_bw(x0,x1-dx/2,y0+dy/4,y1-dy/4,box1->p,cs,1) == 0 ) { setac(box1,(bc=']'),ad);break; }
      break;
   }
   //  --------- test ocr-a-[] --------------------------------
   if(bc==UNKNOWN)
   for(ad=d=98;dx>5 && dy>7 && 2*dy>3*dx;){ // only for accurate font at the moment
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if (!hchar) ad=97*ad/100; 
      if( num_cross(0,dx-1,   0,   0,bp,cs) != 1 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,bp,cs) != 1 ) break;
      if ( loop(bp,dx-1,dy/2,dx,cs,0,LE)
          +loop(bp,   0,dy/2,dx,cs,0,RI) <= dx/4 ) break; // O
      for(y=dy/8;y<dy-dy/8;y++){
        if( num_cross(0,dx,y,y,bp,cs) != 2 ) break;
      } if (y<dy-dy/8) break;
      if( get_bw((x0+x1+1)/2,x1,y0+dy/8,y1-dy/8,box1->p,cs,1) == 1)
         { setac(box1,(bc='['),ad);break; }
      if( get_bw(x0,(x0+x1  )/2,y0+dy/8,y1-dy/8,box1->p,cs,1) == 1)
         { setac(box1,(bc=']'),ad);break; }
      break;
   }
   //  --------- test {} --------------------------------
   for(ad=d=99;dx>4 && dy>5 && 2*dy>3*dx;){
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if (!hchar) ad=97*ad/100; 
      for(y=0;y<dy;y++){
        if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break;
      } if (y<dy) break;
      for(x=0;x<dx/2;x++){
        if( num_cross(dx-1-x,dx-1-x,0,dy-1,bp,cs) != 2 ) break;
      } if (y<dx/2) break;
      if ( num_cross(dx-2,dx-2,dy/4,dy-1-dy/4,bp,cs) != 0 ) break;
      if ( num_cross(   0,   0,dy/4,dy-1-dy/4,bp,cs) != 1 ) break;
      if ( loop(bp,0,dy-1,dx,cs,0,RI)>3*dx/4 ) ad=99*ad/100;
      if ( loop(bp,0,   0,dx,cs,0,RI)>3*dx/4 ) ad=99*ad/100; // <
      if ( loop(bp,1,   0,dy,cs,0,DO)<dy/2-1 ) ad=98*ad/100;
      if ( loop(bp,1,dy-1,dy,cs,0,UP)<dy/2-2 ) ad=98*ad/100; // (
      if ( loop(bp,dx-2,dy-1,dy,cs,0,UP)>dy/4 ) break; // f
      if ( get_bw(x0,x0,y0,y0+dy/4,box1->p,cs,1) == 1 
        || get_bw(x0,x0,y1-dy/4,y1,box1->p,cs,1) == 1 ) break;
      setac(box1,(bc='{'),ad);break;
   }
   for(ad=d=99;dx>4 && dy>5 && 2*dy>3*dx;){
      if (!hchar) ad=97*ad/100; 
      for(y=0;y<dy;y++){
        if( num_cross(0,dx-1,y,y,bp,cs) != 1 ) break;
      } if (y<dy) break;
      for(x=0;x<dx/2;x++){
        if( num_cross(x,x,0,dy-1,bp,cs) != 2 ) break;
      } if (y<dx/2) break;
      if ( num_cross(   1,   1,dy/4,dy-1-dy/4,bp,cs) != 0 ) break;
      if ( num_cross(dx-1,dx-1,dy/4,dy-1-dy/4,bp,cs) != 1 ) break;
      if ( loop(bp,dx-1,dy-1,dx,cs,0,LE)>3*dx/4 ) ad=99*ad/100;
      if ( loop(bp,dx-1,   0,dx,cs,0,LE)>3*dx/4 ) ad=99*ad/100; // >
      if ( loop(bp,dx-2,   0,dy,cs,0,DO)<dy/2-1 ) ad=98*ad/100;
      if ( loop(bp,dx-2,dy-1,dy,cs,0,UP)<dy/2-2 ) ad=98*ad/100; // )
      if ( loop(bp,1,dy-1,dy,cs,0,UP)>dy/4 ) break; // ???
      if ( get_bw(x1,x1,y0,y0+dy/4,box1->p,cs,1) == 1 
        || get_bw(x1,x1,y1-dy/4,y1,box1->p,cs,1) == 1 ) break;
      setac(box1,(bc='}'),ad);break;
   }
   return box1->c;
}

#if 0
/* ---------- empty prototype function for copy and expand ---------- */
static wchar_t ocr0_XXX(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,i0,i1,i2,i3,hchar=sdata->hchar,gchar=sdata->gchar,
        x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1,cs=sdata->cs;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
        ac,ad;	/* tmp-vars */

   // --- test XXX ---------------------------------------------------
   return box1->c;
}
#endif


/* ----------------------- part9 -------------------------------- */
static wchar_t ocr0p9(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
       i1,i2,i3;	/* tmp-vars */
   int xa,xb,	/* used for store significant points of char */
       ya,ad,cs=sdata->cs;
   wchar_t ac,bc=UNKNOWN;			      // bestletter
   int hchar;		// char is higher than e
   int gchar;		// char has ink lower than m3
   // --- hchar --- gchar -------------------------
   hchar=0;if( 2*y0<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   gchar=0;if( 2*y1>=2*box1->m3+(box1->m4-box1->m3) ) gchar=1;
   // if the char is slightly moved down correction can be done
   if ( y0<box1->m2 && y1>box1->m3 && 2*y1<box1->m3+box1->m4) // moved
   if( 2*(y0-(y1-box1->m3))<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   
   /* reserved for the future */
   // --- test beta,\3,sz,"s ---------------------------------------------
   if(bc==UNKNOWN && hchar)
   for(ad=d=100;dx>3 && dy>6;){     // min 4x7
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      /*         this part is provisorium, should be changed!
	     a-\
             |  d
	    b| /
             | \
            -c /
       */
      if( num_cross(x0 ,x1 ,y0+dy/4  ,y0+dy/4  ,box1->p,cs) != 2
       && num_cross(x0 ,x1 ,y0+dy/4+1,y0+dy/4+1,box1->p,cs) != 2 ) break;
      for(i=1+dy/16,y=y0+dy/8;y<y1-dy/4 && i>0;y++){
        if( y<y1-6*dy/16 ){ if( num_cross(x0 ,x1 ,y,y,box1->p,cs) != 2 ) i--;}
        else              { if( num_cross(x0 ,x1 ,y,y,box1->p,cs) <  2 ) i--;}
        if( get_bw(x0,x0+dx/2,y,y,box1->p,cs,1) == 0 ) i--;
        if( y<y1-5*dy/16 ) 
        if( get_bw(x1-dx/2,x1,y,y,box1->p,cs,1) == 0 ) i--;
      } if( i<=0 ) break;
      // out_x(box1);

      for(y=y0+dy/3;y<y1-dy/3;y++){
        i =loop(box1->p,x1,y,dx,cs,0,LE);
        if( i>=dx/8 ) break;
        i+=loop(box1->p,x1-i,y,dx,cs,1,LE);
        if( i>=dx/2 ) break;
      } if( y>=y1-dy/3 ) break;

      for(y=y0+dy/5;y<y0+dy/3;y++)
        if( get_bw(x1-dx/6,x1,y,y,box1->p,cs,1) == 1 ) break;
      if( y>=y0+dy/3 ) break;

      for(y=y0+dy/2;y<y1;y++)
        if( get_bw(x1-dx/6,x1,y,y,box1->p,cs,1) == 1 ) break;
      if( y>=y1 ) break;

      for(y=y1-dy/3;y<y1-dy/8;y++){
        i=loop(box1->p,x1,y,dx,cs,0,LE);
        if( i>dx/4
         && get_bw(x1-dx/8,x1-dx/8,y,y1,box1->p,cs,1) == 1 ) break;
      } if( y<y1-dy/8 ) break;  // ~Q

      if( box1->m3==0 || 2*y1<box1->m3+box1->m4 )
      if(  loop(box1->p,x1,y1,     dx,cs,0,LE)==0
        && loop(box1->p,x1,y1-dy/4,dx,cs,0,LE)>dx/8 ) break; // ~R


      for(x=x0+dx/4;x<x1-dx/4;x++)
        if( num_cross(x,x,y0,y1,box1->p,cs) == 3 ) break;
      if( x>=x1-dx/4 ) break;

      i=loop(bp,dx/2,dy-1,dy,cs,0,UP)+dy/64; 	// Jul00
      for(x=dx/5;x<dx/2;x++)
        if( loop(bp,x,dy-1,dy,cs,0,UP) > i ) break; 
      if( x==dx/2 ) break;

      x=x0+loop(bp,0,dy/4,dx,cs,0,RI);
      for(;x<x1-dx/3;x++)
        if( get_bw(x,x,y0,y0+dy/4,box1->p,cs,1) == 0 ) break;
      if( x<x1-dx/3 ) break;

      if( !gchar )
      // if( num_hole( x0, x1, y0, y1,box1->p,cs,NULL) != 0 ) break;
      if (sdata->holes.num != 0) break;

      bc=LATIN_SMALL_LETTER_SHARP_S;
      setac(box1,(wchar_t)bc,98);
      break;
   }
   // --- test + ------------------------------------------------
   if(bc==UNKNOWN)
   for(ad=d=100;dx>4 && dy>4;){     // min 5x5
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      xa=(dx+1)/3-1; ya=(dy+1)/3-1;
      xb=(dx+1)/4;
      if( get_bw(x0,x0+xa,y0,y0+ya,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0,x0+xa,y1-ya,y1,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-xb,x1,y0,y0+ya,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-xa,x1,y1-ya,y1,box1->p,cs,1) == 1 ) break;
      for(i=0,y=y0+ya;y<=y1-ya;y++){ // horizontal line
        if( get_bw(x0+dx/9,x1-dx/9,y,y,box1->p,cs,2) == 0 ) { i=y; break; }
      }
      if( !i ) break;
      ac=(wchar_t) '+';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test $ ------------------------------------------------
   if(bc==UNKNOWN)
   for(ad=d=100;dx>3 && dy>5;){     // min 3x4
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL)!=2 ) break;
      if (sdata->holes.num != 2) break;
      
      if( get_bw(x0,x0+dx/5,y0      ,y0+dy/18,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0,x0+dx/9,y1-dy/23,y1      ,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/9,x1,y0      ,y0+dy/18,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/5,x1,y1-dy/23,y1      ,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0,x0+dx/3,y0+dy/3 ,y0+dy/2 ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3,x1,y1-dy/2 ,y1-dy/3 ,box1->p,cs,1) != 1 ) break;
      i1=x0+loop(box1->p,x0,y0,dx,cs,0,RI); if( i1<x0+dx/3 || i1>x1-dx/5 ) break;
      i2=x0+loop(box1->p,x0,y1,dx,cs,0,RI); if( i2<x0+dx/5 || i2>i1      ) break;
      for(i=1,y=y0;y<=y1 && i;y++) // vertikaler strich?
        if( get_bw(i2,i1+2,y,y,box1->p,cs,1) != 1 ) i=0;
      if( !i ) break;
      ac=(wchar_t) '$';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test & ------------------------------------------------
   for(ad=d=99;dx>4 && dy>6;){
      if (sdata->holes.num > 3) break; /* tolerant against a tiny hole */
      if( get_bw(x1-dx/9,x1,y0,y0+dy/4,box1->p,cs,1) == 1 ) break; // g
      if( loop(bp,dx/2,0,dy,cs,0,DO)>dy/2) break;
      i1=loop(bp,0,dy/8     ,dx,cs,0,RI); if (i1>dx/2) break;
      i =loop(bp,0,dy/4     ,dx,cs,0,RI); if (i1>dx/2) break; if (i<i1) i1=i;
      i3=loop(bp,0,dy-dy/4  ,dx,cs,0,RI); if (i3>dx/2) break;
      i =loop(bp,0,dy-dy/4-1,dx,cs,0,RI); if (i3>dx/2) break; if (i<i3) i3=i;
      if (i3>i1) break;
      for( i2=0, y=dy/4; y<=dy/2+1; y++ ){
        i =loop(bp,0,y,dx,cs,0,RI); if( i>i2 ) i2=i;
      }
      if(2*i2-i1-i3<1) break;
      // if( num_hole(x0,x1     ,y0,y1,box1->p,cs,NULL)!=2 ) break;
      if (sdata->holes.num != 2) break;
      if( num_hole(x0,x1-dx/4,y0,y1,box1->p,cs,NULL)!=2 ) break;
      if( num_cross(dx-1,dx-1,dy/4,dy-1,bp,cs) < 1 ) break;
      for( x=dx-1; x>=dx/2; x-- ){
        if( num_cross(x,x,dy/4,dy-1,bp,cs) > 1 ) break;
      } if( x<=3*dx/4 ) break; 
      if( num_cross(0,dx-1,dy-1-dy/4,dy-1-dy/4,bp,cs) > 3 ) { // glued ah
        if (dy>15) break; else ad=96*ad/100;
      }
      if (!hchar) ad=98*ad/100;
      bc=(wchar_t) '&';
      setac(box1,bc,ad);
      if (ad>=100) return bc;
      break;
   }
   // --- test \it & like \epsilon\tau ------------------------------
   if(bc==UNKNOWN)
   for(ad=d=100;dx>7 && dy>7;){
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,  dy/4,  dy/4,bp,cs) != 3 ) break;
      if( num_cross(0,dx-1,  dy/2,  dy/2,bp,cs) != 4 ) break;
      if( num_cross(dx/2,dx-1,dy/2, dy/2,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,3*dy/4,3*dy/4,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,  dy-1,  dy-1,bp,cs) != 1 ) break;
      if( num_cross(     0,     0,0,dy-1,bp,cs) != 1 ) break;
      if( num_cross(  dx/3,  dx/3,0,dy-1,bp,cs) != 4 ) break;
      if( num_cross(13*dx/16,13*dx/16,0,dy/8,bp,cs) != 0 ) break;
      if( num_cross(4*dx/8,4*dx/8,dy-dy/4,dy-1,bp,cs) != 1 ) break;
      if( num_cross(3*dx/8,3*dx/8,dy-dy/4,dy-1,bp,cs) != 1 ) break;
      if( num_cross(5*dx/8,5*dx/8,dy-dy/4,dy-1,bp,cs) != 1 ) break;
      if( num_hole(x0   ,(x0+x1)/2,y0,     y1,box1->p,cs,NULL) != 1 ) break;
      if( num_hole(x0+dx/8,x1-dx/4,y0,y1-dy/4,box1->p,cs,NULL) != 1 ) break;
      ac=(wchar_t) '&';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test ? ---------------------------------------------------
   if(bc==UNKNOWN)
   for(ad=d=98;dx>3 && dy>5;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      for(y=y0;y<y1;y++)	// new y1
        if( get_bw(x0, x1, y, y,box1->p,cs,1) != 1 ) break; // lower end
      if (2*y<y0+y1) break;
      i1=y1;
      if (y==y1 && box1->m4) { // probably lower dot not catched in box?
        if (get_bw(x0+1,x1-1,y1+1,box1->m4,box1->p,cs,1) != 1 ) break;
        i1=box1->m4;
        for(;i1>y1;i1--)	// new y1
          if( get_bw(x0, x1,i1,i1,box1->p,cs,1) == 1 ) break; // lower dot
      }
      y--; i=y-y0+1;	// new dy
      if( num_cross(x0 , x1 , y0 , y0+dy/2 , box1->p,cs) < 2 ) break;
      // if( num_hole( x0, x1, y0, y1, box1->p,cs,NULL) > 0 ) break;
      if (sdata->holes.num > 0) break;
      for(y=y0+dy/2;y<=i1;y++)
        if( get_bw(x0,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y==i1 ) break;
      for(      ;y<=i1;y++)
        if( get_bw(x0,x1,y,y,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0,x1,y,y,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+7*dx/8,x1,y,i1,box1->p,cs,1) == 1 ) break; // broken thin 2
      bc='?';
      setac(box1,(wchar_t)bc,98);
      return bc;
   }
   // --- test !| ---------------------------------------------------
   for(ad=d=99; dy>4 && dy>2*dx;){     // min 3x4
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
	// measure thickness
     if (num_cross(x0,x1,y0     ,y0     ,box1->p,cs)!=1) break;
     if (num_cross(x0,x1,y0+dy/2,y0+dy/2,box1->p,cs)!=1) break;
     for(y=y0;y<y1;y++)	// new y1
       if( get_bw(x0, x1, y, y,box1->p,cs,1) != 1 ) break; // lower end
     if (2*y<y0+y1) break;
     if (y==y1 && y>box1->m3-dy/8) ad=ad*97/100; /* missing dot? */
     i1=y1;
     if (y==y1 && box1->m4) { // probably lower dot not catched in box?
       if ((dx>2 && get_bw(x0+1,x1-1,y1+1,box1->m4,box1->p,cs,1) == 1)
        || (dx<3 && get_bw(x0  ,x1  ,y1+1,box1->m4,box1->p,cs,1) == 1 ))  {
         i1=box1->m4;
         for(;i1>y1;i1--)	// new y1
           if( get_bw(x0, x1,i1,i1,box1->p,cs,1) == 1 ) break; // lower dot
       }
     } i2=i1;
     for( i1=0,y=y0;y<=i2;y++){
       i=num_cross(x0,x1,y,y,box1->p,cs); if(i>1) break;
       if(i==0 && i1==0) i1=y;
     } if(y<=i2 || i1==0 || i1<y0+dy/2) break;
     
     if( loop(bp,dx-1,dy/8,dx,cs,0,LE)
        -loop(bp,dx-1,   0,dx,cs,0,LE)>dx/4+1 ) break; // f
     
     if (!hchar) ad=96*ad/100;
     setac(box1,(wchar_t)'!',ad);
     break; 
   }
   // --- test * five egdes (jagges? beames?) what is the right english word? ----
   if(bc==UNKNOWN)
   for(ad=d=100;dx>4 && dy>4;){
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,   0,dy-1,bp,cs) != 1
       && num_cross(0,dx-1,   1,dy-2,bp,cs) != 1 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,bp,cs) != 2
       && num_cross(0,dx-1,dy-2,dy-2,bp,cs) != 2 ) break;
      x=dx/2;y=(6*dy+8)/16; // center point 6/8=6/2^3 rounded 
      i=get_line2(x,y,x   ,0,bp,cs,100); if(i<95) break; // black upwarts beam
      i=get_line2(0,y,dx-1,y,bp,cs,100); if(i<95) break; // horizontal line
      i=get_line2(x,y,(5*dx+4)/8,dy-1,bp,cs,100);
      j=get_line2(x,y,(6*dx+4)/8,dy-1,bp,cs,100); if(j>i) i=j;
      if(i<95) break; // straight down
      i=get_line2(x,y,(2*dx+4)/8,dy-1,bp,cs,100); if(i<95) break; // straight up
      i=get_line2(     x,dy-dy/8,x,dy-1,bp,cs,101); if(i<95) break; // lower gap
      i=get_line2(     dx/4,dy/4,   0,0,bp,cs,101); if(i<95) break; // upper left gap
      i=get_line2(dx-1-dx/4,dy/4,dx-1,0,bp,cs,101); if(i<95) break; // upper right gap
      setac(box1,(wchar_t)'*',96);
      break;
   }
   // --- test * six egdes (jagges? beames?) what is the right english word? ----
   if(bc==UNKNOWN)
   for(ad=d=100;dx>4 && dy>4;){
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,     dy/8,     dy/8,bp,cs) != 3
       && num_cross(0,dx-1,   1+dy/8,   1+dy/8,bp,cs) != 3) break;
      if( num_cross(0,dx-1,dy-2-dy/8,dy-2-dy/8,bp,cs) != 3) break;
      if( num_cross(0   ,   0,   0,dy-1,bp,cs) != 2) break;
      if( num_cross(dx-1,dx-1,   0,dy-1,bp,cs) != 2) break;
      if( num_cross(0,dx-1,dy/2,dy/2,bp,cs) != 1) break;
      if( num_cross(   0     ,dx/8,dy/2,dy/2,bp,cs) != 0) break;
      if( num_cross(dx-1-dx/8,dx-1,dy/2,dy/2,bp,cs) != 0) break;
      if (dx>5) {
        i=get_line2(0,dy-2-dy/8,dx-1,dy/8,bp,cs,100); if(i<95) break; // black upwarts beam
        i=get_line2(0,dy/8,dx-1,dy-2-dy/8,bp,cs,100); if(i<95) break; // black downwards beam
        i=get_line2(dx/2,0,dx/2,dy-1,bp,cs,100); if(i<95) break; // vertical line
      }
      setac(box1,(wchar_t)'*',98);
      break;
   }
   // --- test @ - a popular char should be detectable! added in version v0.2.4a5
   if(bc==UNKNOWN)
   for(ad=d=99;dx>5 && dy>7;){
      if (sdata->holes.num > 3) break; /* tolerant against a tiny hole */
      if (loop(bp,   0,dy/2,dx,cs,0,RI)>dx/4) break;
      if (loop(bp,dx-1,dy/2,dx,cs,0,LE)>dx/4) break;
      if (loop(bp,dx/2,dy-1,dy,cs,0,UP)>dx/8) break;
      if (loop(bp,dx/2,   0,dy,cs,0,DO)>dx/8) break;
      x=6*dx/16;
      y=dy/2;
      i=num_cross(0,dx-1,y,y,bp,cs); if( i != 4 ) ad=98*ad/100;
      if (i<3 || i>4) break;
      i=num_cross(x,x,0,dy-1,bp,cs); if (i<2) break;
      if (i!=4) i=num_cross(x+1,x+1,0,dy-1,bp,cs);
      if (i<3 || i>4) break;
      if (i!=4) ad=97*ad/100;
      if( num_cross(0,   x,y,y,bp,cs) != 2 ) break;
      if( num_cross(x,dx-1,y,y,bp,cs) != 2 ) break;
      if( num_cross(x,x,0,   y,bp,cs) != 2 ) break;
      if( num_cross(x,x,y,dy-1,bp,cs) != 2 ) break;
      if (dx>7) {
        // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 1 ) break;
        if (sdata->holes.num != 1) break;
        if( num_hole(x0+dx/8,x1-3*dx/16,y0+dy/8,y1-dy/8,box1->p,cs,NULL) != 1 ) break;
      }
      setac(box1,(wchar_t)'@',ad);
      break;
   }
   // --- test paragraph v0.2.6
   if(bc==UNKNOWN && hchar)
   for(ad=d=100;dx>4 && dy>15;){
      if (sdata->holes.num > 3) break; /* tolerant against a tiny hole */
      if( get_bw(     0,dx/2,3*dy/4,3*dy/4,bp,cs,1) == 1 ) break;
      if( get_bw(3*dx/4,dx-1,3*dy/4,3*dy/4,bp,cs,1) == 0 ) break;
      if( get_bw(     0,dx/4,  dy/4,  dy/4,bp,cs,1) == 0 ) break;
      if( get_bw(  dx/2,dx-1,  dy/4,  dy/4,bp,cs,1) == 1 ) break;
      if( get_bw(dx/2,dx/2,        0, dy/4,bp,cs,1) == 0 ) break;
      if( get_bw(dx/2,dx/2,dy-1-dy/4, dy-1,bp,cs,1) == 0 ) break;
      if( num_cross(dx/2,dx/2,0,dy-1,bp,cs) != 4 ) break;
      if( num_cross(x0,x1,y0+dy/2,y0+dy/2,box1->p,cs) != 2 ) break;
      if( num_hole( x0,x1,y0+dy/4,y1-dy/4,box1->p,cs,NULL) != 1 ) break;
      setac(box1,SECTION_SIGN,96);
      break;	// paragraph=0xA7=167 
   }

   return bc;
}

/* ----------------------- partx -------------------------------- */
static wchar_t ocr0px(ocr0_shared_t *sdata){
   struct box *box1=sdata->box1;
   pix *bp=sdata->bp;
   int	i,j,d,x,y,x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
       i1,i2,i3,i4,j1,cs=sdata->cs;	/* tmp-vars */
   int ya,ad;	/* used for store significant points of char */
   wchar_t ac,bc=UNKNOWN;			      // bestletter
   int hchar;		// char is higher than e
   int gchar;		// char has ink lower than m3
   // --- hchar --- gchar -------------------------
   hchar=0;if( 2*y0<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   gchar=0;if( 2*y1>=2*box1->m3+(box1->m4-box1->m3) ) gchar=1;
   // if the char is slightly moved down correction can be done
   if ( y0<box1->m2 && y1>box1->m3 && 2*y1<box1->m3+box1->m4) // moved
   if( 2*(y0-(y1-box1->m3))<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   
   /* reserved for special chars, to test at the end  */
   // --- test 'ff' ---------------------------------------------------
   // ToDo: better check and call test 'f' and 'f' with subboxes
   if( bc==UNKNOWN )
   for(ad=98;dx>4 && dy>6;){     // Dec00 body copied from H
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,  dy/4 ,  dy/4 ,bp,cs) != 2
       && num_cross(0,dx-1,3*dy/16,3*dy/16,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,3*dy/4  ,3*dy/4  ,bp,cs) != 2
       && num_cross(0,dx-1,3*dy/4+1,3*dy/4+1,bp,cs) != 2 ) break;
      if( loop(bp,0   ,dy/8,dx,cs,0,RI)
        + loop(bp,dx-1,dy/8,dx,cs,0,LE)>dx/2 ) break; // ~A
      for( j1=0,i=1,y=y0+dy/10; y<y1-dy/10 && i; y++ ) // 2 vertikal lines
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI)
         +loop(box1->p,x1  ,y,dx,cs,0,LE);
        if( j>10*dx/16 ) i=0; if ( j>j1 ) j1=j; } 
      if( !i ) break;
      for( x=dx/4; x<dx/2; x++ ){  // lower gap
        y=loop(bp,x  ,dy-1,dy,cs,0,UP);
        if ( y > 3*dy/8 ) break;
        if ( 10*y > dy ){	/* italic */
          i=loop(bp,x  ,dy-y,dx,cs,0,RI);
          if( i>1 && y+loop(bp,x+i-1,dy-y,dy,cs,0,UP)>3*dy/8 ) break;
        }
      } if( x>=dx/2 ) break;
      x=loop(box1->p,x0  ,y1-dy/8,dx,cs,0,RI)
       +loop(box1->p,x1  ,y1-dy/8,dx,cs,0,LE);
      for( i=1,y=dy/4; y<dy-1-dy/4 && i; y++ ) // max - min width
      { j=loop(bp,0   ,y,dx,cs,0,RI)
         +loop(bp,dx-1,y,dx,cs,0,LE); if( j-x>dx/5 ) i=0; } 
      if( !i ) break;   // ~K Jul00
      for( i=0,ya=y=y0+dy/4; y<y1-dy/3; y++ ) // horizontal line
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>i ) { i=j; ya=y; } } 
      if( i<=dx/2 ) break; ya-=y0;
      if( num_cross(0,dx-1,ya  ,ya  ,bp,cs) != 1
       && num_cross(0,dx-1,ya+1,ya+1,bp,cs) != 1 ) break; /* Dec00 */
      for( y=ya; y<dy-dy/4; y++ ) // ~M Dec00
      if( num_cross(0,dx-1,y  ,y  ,bp,cs) > 2
       && num_cross(0,dx-1,y+1,y+1,bp,cs) > 2 ) break;
      if ( y<dy-dy/4 ) break;
      for(i=1,x=x0+dx/2;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y0     ,y0+dy/4,box1->p,cs,1) == 0 ) i=0;
      } if( !i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( num_cross(x,x,y0+dy/8,y1-dy/8, box1->p,cs) == 1 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/4 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( num_cross(x0 ,x0+dx/8 ,y0+dy/8  ,y0 ,box1->p,cs) != 0 ) ad=96*ad/100;
      if( get_bw(x1-dx/8, x1     , y0, y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/8, y1-dy/8, y1,box1->p,cs,1) != 1 ) break;
      i1=loop(bp,dx-1,     dy/4,dx,cs,0,LE); if(i1>dx/2) break;
      i2=loop(bp,dx-1,     dy/2,dx,cs,0,LE); if(i2<i1-dx/4 || i2>i1+dx/8) break;
      i3=loop(bp,dx-1,dy-1-dy/4,dx,cs,0,LE); if(i3<i2-dx/4 || i3>i2+dx/8) break;
      if(abs(i1+i3-2*i2)>dx/16+1) break;
      if( num_hole(x0,x1,y0+dy/4,y1,box1->p,cs,NULL) != 0 ) break;
      if (!hchar) ad=96*ad/100;
      if (!gchar) ad=99*ad/100;
      ac=LATIN_SMALL_LIGATURE_FF;
      setac(box1,ac,ad);
      break;
   }
   // --- test ae  ---------------------------------------------------
   if( bc==UNKNOWN )
   for(ad=98;dx>4 && dy>6;){     // provisorium
      if (sdata->holes.num > 4) break; /* tolerant against a tiny hole */
      if( num_cross(     dx/4,dx-1,3*dy/16,3*dy/16,bp,cs) != 2
       && num_cross(dx-1-dx/4,dx-1,3*dy/16,3*dy/16,bp,cs) != 1 ) break;
// out_x(box1);MM;       
      if( num_cross(0,dx-1,3*dy/ 4,3*dy/ 4,bp,cs) <  2 ) break;
      if( num_cross(0,dx-1,      0,   dy-1,bp,cs) <  3 ) break;
      if( num_cross(dx-1,0,      0,   dy-1,bp,cs) <  3 ) break;
      if( num_cross(0,dx-1,  dy/16,  dy/16,bp,cs) <  2 )
      if( num_cross(0,dx-1,1+dy/16,1+dy/16,bp,cs) <  2 ) break;
      if( num_cross(0,dx-1,dy-1-dy/16,dy-1-dy/16,bp,cs) <  2 ) break;
      for( x=0,i2=y=dy/4; y<3*dy/4; y++ ){
        j=loop(bp,0,y,dx,cs,0,RI); if(j>x) { i2=y; x=j; }
      } if( x<dx/4 || x>3*dx/4 ) break;
      for( x=0,i4=y=dy/4; y<3*dy/4; y++ ){
        j=loop(bp,dx-1,y,dx,cs,0,LE); if(j>x) { i4=y; x=j; }
      } if( x<dx/4 || x>3*dx/4 ) break;
      for( x=0,i4=y=dy/8; y<3*dy/4; y++ ){
        j=loop(bp,dx-1  ,y,dx,cs,0,LE);
        j=loop(bp,dx-1-j,y,dx,cs,1,LE);
        if(j>x) { i4=y; x=j; }
      } if( x<dx/4 ) break;
      if( num_hole(x0,x0+3*dx/4,y0+dy/4,y1,box1->p,cs,NULL) != 1 ) break;
      if( num_hole(x0+dx/2-1,x1,y0,y1-dy/4,box1->p,cs,NULL) != 1 ) break;
      ac=LATIN_SMALL_LETTER_AE;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;

   }
   // --- test AE  ---------------------------------------------------
   if( bc==UNKNOWN )
   for(ad=98;dx>5 && dy>6;){     // provisorium
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,3*dy/16,3*dy/16,bp,cs) <  2 ) break;
      if( num_cross(0,dx-1,3*dy/ 4,3*dy/ 4,bp,cs) <  2 ) break;
      if( num_cross(0,dx-1,      0,   dy-1,bp,cs) <  3 ) break;
      if( num_cross(0,dx-1,  dy/16,  dy/16,bp,cs) != 1 
       && num_cross(0,dx-1,  dy/32,  dy/32,bp,cs) != 1
       && num_cross(0,dx-1,      0,      0,bp,cs) != 1 ) break;
      j=loop(bp,dx-1,0,dx,cs,0,LE);
      i=loop(bp,dx-1,1,dx,cs,0,LE); if(i<j) j=i;
      if (j>dx/8) break; x=j;
      j=loop(bp,dx-1-x,0,dx,cs,1,LE);
      i=loop(bp,dx-1-x,1,dx,cs,1,LE); if(i>j) j=i;
      if (j<dx/4) break;
      for( x=dx,i1=i3=0,i2=y=dy/4; y<3*dy/4; y++ ){
        j=loop(bp,     0,y,dx,cs,0,RI); if(j>x) break; x=j;
        j=loop(bp,     j,y,dx,cs,1,RI); if(j>i1) { i1=j; i2=y; }
        j=loop(bp,dx-1  ,y,dx,cs,0,LE);
        j=loop(bp,dx-1-j,y,dx,cs,1,LE); if(j>i3) { i3=j; i4=y; }
      } if( y<3*dy/4 || i1<dx/4-1 || i3<dx/4-1) break;
      for( i1=i3=0,y=0; y<dy/8; y++ ){
        j=loop(bp,dx-1  ,     y,dx,cs,0,LE);
        j=loop(bp,dx-1-j,     y,dx,cs,1,LE); if(j>i1) { i1=j; }
        j=loop(bp,dx-1  ,dy-1-y,dx,cs,0,LE);
        j=loop(bp,dx-1-j,dy-1-y,dx,cs,1,LE); if(j>i3) { i3=j; }
      } if( i1<=dx/4 || i3<=dx/4 ) break;
      for( x=dx-1-dx/8; x>dx/2; x-- ){  // look for right the E
        if( num_cross(x,x,     0,dy-1,bp,cs) == 3 )
        if( num_cross(x,x,     0,dy/4,bp,cs) == 1 )
        if( num_cross(x-1,dx-1-dx/8,3*dy/4,3*dy/4,bp,cs) == 0 )
        if( num_cross(x,x,3*dy/4,dy-1,bp,cs) == 1 ) break;
      } if (x<=dx/2) break; // not found
      if (sdata->holes.num != 1) break;
      if( num_hole(x0,x0+3*dx/4,y0,y1-dy/4,box1->p,cs,NULL) != 1 ) break;
      // if( num_hole(x0,       x1,y0,y1     ,box1->p,cs,NULL) != 1 ) break;
      ac=LATIN_CAPITAL_LETTER_AE;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;

   }
   // --- test /0 /o /O O_WITH_STROKE -----------------------------------------
   for(ad=99;dx>4 && dy>4;){     // provisorium
      if (sdata->holes.num > 3) break; /* tolerant against a tiny hole */
      if( num_cross(   0,dx-1,dy/2,dy/2,bp,cs) != 3 ) break;
      if( num_cross(dx/2,dx/2,   0,dy-1,bp,cs) != 3 ) break;
      if (loop(bp,dx-1,3*dy/8,dx,cs,0,RI)>dx/8) break;
      if (loop(bp,   0,5*dy/8,dx,cs,0,RI)>dx/8) break;
      if( num_cross(   0,dx-1,   0,   0,bp,cs) > 2 ) break;
      if( num_cross(dx/4,dx-1,   0,   0,bp,cs) > 2 ) break;
      if( num_cross(   0,dx-1,dy-1,dy-1,bp,cs) > 2 ) break;
      if( num_cross( 0,3*dx/4,dy-1,dy-1,bp,cs) > 2 ) break;
      if( num_cross(   0,   0,   0,dy-1,bp,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1,   0,dy-1,bp,cs) > 2 ) break;
      if( num_cross(   0,   0,dy/4,dy-1,bp,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1, 0,3*dy/4,bp,cs) > 2 ) break;
      i1 =loop(bp,dx-1   ,   0,dx,cs,0,LE); if( i1>dx/8 ) break;
      i1+=loop(bp,dx-1-i1,   0,dx,cs,1,LE); if( i1>dx/3 ) break; i1=dx-1-i1;
      i2 =loop(bp,      0,dy-1,dx,cs,0,RI); if( i2>dx/8 ) break;
      for(y=1;y<dy-1;y++){
        x=i1+y*(i2-i1)/dy-dx/8; if(x<0)x=0;
        j=loop(bp,x,y,dx,cs,0,RI); if( j>3*dx/16 ) break;
      } if( y<dy-1 ) break;
      if( num_cross(       0 ,dx/4,dy/2,dy/2,bp,cs) != 1 ) break;
      if( num_cross(dx-1-dx/4,dx-1,dy/2,dy/2,bp,cs) != 1 ) break;
      if( num_cross(dx/4,dx-1-dx/4,dy/2,dy/2,bp,cs) != 1 ) break;
      if (sdata->holes.num != 2) break;
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 2 ) break;

      if ( hchar && 2*y0<box1->m1+box1->m2 )
           ac=LATIN_CAPITAL_LETTER_O_WITH_STROKE;
      else ac=LATIN_SMALL_LETTER_O_WITH_STROKE;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;

   }
   // --- test /c /C C_WITH_STROKE -----------------------------------------
   // here only the version with a continuously vertical line (not broken variant)
   if( bc==UNKNOWN )
   for(ad=98;dx>4 && dy>4;){     // provisorium
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( num_cross(     0,dx-1,dy/2,dy/2,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1-dx/4,dy/2,dy/2,bp,cs) != 2 ) break;
      if( num_cross(dx/2,dx/2,   0,dy-1,bp,cs) != 3 ) break;
      if( num_cross(   0,dx-1,   0,   0,bp,cs) > 2 ) break;
      if( num_cross(dx/4,dx-1,   0,   0,bp,cs) > 2 ) break;
      if( num_cross(   0,dx-1,dy-1,dy-1,bp,cs) > 2 ) break;
      if( num_cross( 0,3*dx/4,dy-1,dy-1,bp,cs) > 2 ) break;
      if( num_cross(   0,   0,   0,dy-1,bp,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1,   0,dy-1,bp,cs) > 3 ) break;
      if( num_cross(   0,   0,dy/4,dy-1,bp,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1, 0,3*dy/4,bp,cs) > 3 ) break;
      i1 =loop(bp,dx-1   ,   0,dx,cs,0,LE); if( i1>dx/4 ) break;
      i1+=loop(bp,dx-1-i1,   0,dx,cs,1,LE); if( i1>dx/4 ) break; i1=dx-1-i1;
      i2 =loop(bp,      0,dy-1,dx,cs,0,RI); if( i2>dx/4 ) break;
// MX;
      for(y=0;y<dy;y++){
        x=i1+y*(i2-i1)/dy; if(x>dx/16+1) x-=dx/16+1;
        j=loop(bp,x,y,dx,cs,0,RI); // fprintf(stderr,"\n x=%d j=%d",x,j);
        if( j>(dx+4)/8 ) ad=96*ad/100;
        if( j>(dx+2)/4 ) break;
      } if( y<dy ) break;
      if( num_cross(       0 ,dx/4,dy/2,dy/2,bp,cs) != 1 ) break;
      if( num_cross(dx-1-dx/4,dx-1,dy/2,dy/2,bp,cs) != 0 ) break;
      if( num_cross(dx/4,dx-1-dx/4,dy/2,dy/2,bp,cs) != 1 ) break;
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 1 ) break;
      if (sdata->holes.num != 1) break;

      ac=CENT_SIGN;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;

   }
   // --- test EURO_CURRENCY_SIGN -----------------------------------------
   if( bc==UNKNOWN )
   for(ad=98;dx>4 && dy>6;){     // provisorium
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(dx/2,dx/2,   0,dy-1,bp,cs) != 4 ) break;
      if( num_cross(   0,dx-1,   0,   0,bp,cs) != 1 ) break;
      if( num_cross(   0,dx-1,dy-1,dy-1,bp,cs) != 1 ) break;
      if( num_cross(   0,dx-1,dy/2,dy/2,bp,cs) != 1 ) break;
      for(i=0,y=dy/4;y<dy-dy/4-1;y++){ // check if no gap on left side
        x=loop(bp,0,y,dx,cs,0,RI); if( x>dx/4 ) break;
        j=loop(bp,x,y,dx,cs,1,RI); if( j>i ) i=j;
      } if( y<dy-dy/4-1 || i<dx/2 ) break;
      for(y=dy/4;y<dy-dy/4-1;y++){ // check for right horizontal gap
        x=loop(bp,dx-1,y,dx,cs,0,LE); if( x>dx/2 ) break;
      } if( y>=dy-dy/4-1 ) break;
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 0 ) break;
      if (sdata->holes.num != 0) break;
      ac=EURO_CURRENCY_SIGN;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test LETTER_C_WITH_CEDILLA  ---------------------------------------------------
   if( bc==UNKNOWN )
   if( gchar )
   for(ad=98;dx>3 && dy>6;){     // provisorium
      if (sdata->holes.num > 1) break; /* tolerant against a tiny hole */
      if( num_cross(0,dx-1,3*dy/16,3*dy/16,bp,cs) > 2 ) break;
      if( num_cross(0,dx-1,      0,   dy-1,bp,cs) < 2 ) break;
      if( num_cross(0,dx-1,  dy/16,  dy/16,bp,cs) > 2 ) break;
// out_x(box1);MM;
      for( x=dx,i2=y=dy/4; y<3*dy/4; y++ ){
        j=loop(bp,0,y,dx,cs,0,RI); if(j<x) { i2=y; x=j; }
      } if( x>0 ) break; i1=x;
      for( x=0,i4=y=dy/4; y<5*dy/8; y++ ){
        j=loop(bp,dx-1,y,dx,cs,0,LE); if(j>x) { i4=y; x=j; }
      } if( x<dx/2 ) break; i3=x;
      j =loop(bp,dx/2,0,dy,cs,0,DO);
      j+=loop(bp,dx/2,j,dy,cs,1,DO); if(j>dy/4) break;
      j =loop(bp,dx/2,j,dy,cs,0,DO); if(j<dy/2) break;
      j =loop(bp,dx-1    ,dy-1-dy/8,dx,cs,0,LE); if(j<dx/4 || 4*j>3*dx) break;
      j =loop(bp,dx-1-j/2,dy-1-dy/8,dy,cs,0,UP); if(j>dy/2) break; // ~()
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 0 ) break;
      if (sdata->holes.num) break;
      if( hchar ) ac= LATIN_CAPITAL_LETTER_C_WITH_CEDILLA;
      else        ac= LATIN_SMALL_LETTER_C_WITH_CEDILLA;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;

   }
   // --- test #  ---------------------------------------------------
   for(ad=99;dx>4 && dy>4;){     // provisorium
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if (sdata->holes.num < 1) break;
      if( num_cross(0,dx-1,     dy/8,     dy/8,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,dy-1-dy/8,dy-1-dy/8,bp,cs) != 2 ) break;
      if( num_cross(0,dx-1,     dy/2,     dy/2,bp,cs) != 2 ) break;
      if( num_cross(0,dx/2,     dy/2,     dy/2,bp,cs) != 1 ) break;
      /* fat "#" have only small ends on left and right side, we tolerate this */
      j=loop(bp,   0,dy/8,dx,cs,0,RI); if(j<1 || j<dx/16) break; if (j<dx/8) ad=ad*96/100;
      j=loop(bp,   0,dy/2,dx,cs,0,RI); if(j<1 || j<dx/16 || j>=dx/2) break; if (j<dx/8) ad=ad*96/100;
      j=loop(bp,dx-1,dy/2,dx,cs,0,LE); if(j<1 || j<dx/16 || j>=dx/2) break; if (j<dx/8) ad=ad*96/100;
      j=loop(bp,dx-1,dy-1,dx,cs,0,LE); if(j<1 || j<dx/16) break; if (j<dx/8) ad=ad*96/100;
      for( i1=i3=0,y=dy/4; y<dy/2; y++ ){
        j=loop(bp,0,y,dx,cs,0,RI); if(j>3*dx/4) { i1=0; break; }
        j=loop(bp,j,y,dx,cs,1,RI); if(j>i1) { i1=j; }
        j=loop(bp,0,y,dx,cs,0,RI); if(j>3*dx/4) { i1=0; break; }
        j=loop(bp,j,y,dx,cs,1,RI); if(j>i3) { i3=j; }
      } if( i1<dx-dx/8 || i3<dx-dx/8 ) break;
      if (sdata->holes.num != 1) ad=95*ad/100;
      if( num_hole(x0+dx/8,x1-dx/8,y0+dy/8,y1-dy/8,box1->p,cs,NULL) != 1 ) break;
      // if( num_hole(x0     ,x1     ,y0     ,y1     ,box1->p,cs,NULL) != 1 ) break;

      ac=(wchar_t) '#';
      if( gchar ) ad=97*ad/100;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test bullet, full_box, grabbed cursor, ZapfDingBats_156
   if (bc==UNKNOWN)
   for(ad=96;dx>4 && dy>4 && 2*dx>dy;){     // provisorium
      if( get_bw(x0,x1,y0,y1,box1->p,cs,2) != 0 ) break;
      ac=BULLET;
      if (gchar && !hchar) ad=80*ad/100;
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test |
   if (hchar)
   for(ad=90;dy>4 && 4*dx<dy;){     // provisorium
      if( get_bw(x0,x1,y0,y1,box1->p,cs,2) != 0 ) break;
      ac='|';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test %  ---------------------------------------------------
   for(ad=100;dx>5 && dy>7;){     // provisorium
      if (sdata->holes.num > 2) break; /* tolerant against a tiny hole */
      if( num_cross(x0,x1     ,y0+dy/4,y0+dy/4,box1->p,cs) != 3
       && num_cross(x0,x1     ,y0+dy/8,y0+dy/8,box1->p,cs) != 3 ) break;
      if( num_cross(x0,x1+dx/4,y1-dy/4,y1-dy/4,box1->p,cs) != 3
       && num_cross(x0,x1+dx/4,y1-dy/8,y1-dy/8,box1->p,cs) != 3 ) break;
      if( num_cross(x0,x1,       y0, y1,box1->p,cs) < 4
       && num_cross(x0+dx/8,x1,  y0, y1,box1->p,cs) < 4
       && num_cross(x0,x1+dx/4,  y0, y1,box1->p,cs) < 4 
       && dx>7 && dy>15) break;
      if( num_cross(x0,x1,       y0, y1,box1->p,cs) !=5 ) ad=99*ad/100;

      if (dx>7 && dy>12) {
        if( num_hole(x0     ,x1     ,y0,y1-dy/4,box1->p,cs,NULL) != 1 ) break;
        if( num_hole(x0+dx/4,x1+dx/4,y0+dy/4,y1,box1->p,cs,NULL) != 1 ) break;
        if( num_hole(x0     ,x1+dx/4,y0,y1     ,box1->p,cs,NULL) != 2 ) break;
      } else ad=98*ad/100;
      // use box1->p instead of b, because % is a sum of 3 objects
      if (  loop(box1->p,x0,y0        ,dx,cs,0,RI)
         <= loop(box1->p,x0,y0+dy/16+1,dx,cs,0,RI) ) ad=96*ad/100; // X
      if (  loop(box1->p,x1,y1        ,dx,cs,0,LE)
         <= loop(box1->p,x1,y1-1-dy/16,dx,cs,0,LE) ) ad=96*ad/100; // X
      if (gchar) ad=98*ad/100;
      ac=(wchar_t) '%';
      setac(box1,ac,ad);
      if (ad>=100) return ac;
      break;
   }
   // --- test Omega ---------------------------------------------------
   for(ad=d=99;dx>7 && dy>7;){     // min 3x4
      if( get_bw(x0      , x0+dx/2,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/2 , x1     ,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0      , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0+dy/3 , y1-dy/3,box1->p,cs,1) != 0 ) break;

      if( num_cross(x0+dx/2,x0+dx/2,y0      , y1-dy/3,box1->p,cs)  != 1 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y0      , y0     ,box1->p,cs)  != 1 ) // AND
      if( num_cross(x0+dx/3,x1-dx/3,y0+1    , y0+1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y1      , y1     ,box1->p,cs)  != 2 ) // against "rauschen"
      if( num_cross(x0+dx/3,x1-dx/3,y1-1    , y1-1   ,box1->p,cs)  != 2 ) break;
      if( num_cross(x0     ,x0     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x0+1   ,x0+1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      if( num_cross(x1     ,x1     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x1-1   ,x1-1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      if (sdata->holes.num) break;
      // if( num_hole(x0,x1,y0,y1,box1->p,cs,NULL) != 0 ) break;
      
      if( loop(bp,0   ,0   ,x1-x0,cs,0,RI)<=
          loop(bp,0   ,2   ,x1-x0,cs,0,RI)  ) break;
      if( loop(bp,dx/2,dy-dy/4,x1-x0,cs,0,RI)>dx/4
       || loop(bp,dx/2,dy-dy/4,x1-x0,cs,0,LE)>dx/4 ) break;
      if( loop(bp,dx/2,3*dy/8,x1-x0,cs,0,RI)<dx/4
       || loop(bp,dx/2,3*dy/8,x1-x0,cs,0,LE)<dx/4 ) break;

      i=loop(bp,0,dy-1-dy/16,x1-x0,cs,0,RI); if(i>dx/8) break;
      x=loop(bp,i,dy-1-dy/16,x1-x0,cs,1,RI); i+=x; if(i<3*dx/8 || i>dx/2) break;
      x=loop(bp,i,dy-1-dy/16,x1-x0,cs,0,RI); i+=x; if(i<dx/2 || i>5*dx/8) break;
      x=loop(bp,i,dy-1-dy/16,x1-x0,cs,1,RI); i+=x; if(i<7*dx/8) break;

      /* look for a vertikal gap at lower end */
      for( x=dx/4;x<3*dx/4;x++ ){
        i=loop(bp,x,dy-1,y1-y0,cs,0,UP);
        if( i>3*dy/4 ) break;
      }
      if( x>=3*dx/4 ) break;

      if( !hchar ) ad=60*ad/100;
      bc=GREEK_CAPITAL_LETTER_OMEGA;
      setac(box1,bc,ad);
      break;
   }

   return bc;
}

// -------------------- OCR engine ;) ----------------------------
wchar_t ocr0(struct box *box1, pix *bp, int cs){
   // pix  p=*(box1->p);
   int	i,d,x,y,x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
       rx,ry,r1,r2,i1,i2,ad;	/* tmp-vars */
   // ad,ac will be used in future
   wchar_t bc = UNKNOWN;			// bestletter
   wchar_t um = SPACE;				// modifier '"
   int hchar;		// char is higher than e
   int gchar;		// char has ink lower than m3
   ocr0_shared_t sdata; // data used in all subfunctions
   
   sdata.box1=box1;
   sdata.bp=bp;
   sdata.cs=cs;
   // --- hchar --- gchar -------------------------
   hchar=0;if( 2*y0<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   gchar=0;if( 2*y1>=2*box1->m3+(box1->m4-box1->m3) ) gchar=1;
   // if the char is slightly moved down correction can be done
   if ( y0<box1->m2 && y1>box1->m3 && 2*y1<box1->m3+box1->m4) // moved
   if( 2*(y0-(y1-box1->m3))<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;

   sdata.hchar=hchar;
   sdata.gchar=gchar;

   /* extract number position and size of holes and store in a table
    *   - hole coordinates are relative to box (x-x0,y-y0)
    */
   num_hole(x0,x1,y0,y1,box1->p,cs,&sdata.holes); // call once 
   // printf(" num_holes=%d\n",sdata.holes.num);

   /*
      after division of two glued chars, boundaries could be wrong,
      check this first (ToDo: only if a flag set?)
   */
   if (2*y0 < box1->m2+box1->m3)
   if (box1->m4>box1->m3 && 2*box1->y1>box1->m4+box1->m3){
      /* could be a "I" from divided "Ij" or "Ig" */
      for(y=(box1->m3+box1->m2)/2;2*y<box1->m3+box1->m4;y++)
        if( get_bw(x0,x1,y,y,box1->p,cs,1)==0 ) break;
      if(2*y<box1->m3+box1->m4)
        if( get_bw((x0+x1)/2,(x0+x1)/2,y,box1->m4,box1->p,cs,1)==0 ){
        /* be sure, ~_ */
        if (y>y0) y1=box1->y1=y;
      }
   }

   // --- test thin lines - ---------------------------------
   for( ad=100; 2*dy<box1->m3-box1->m2 && 3*dx>=4*dy && dx>4; ){ // max 3x3 (small font)
      if( get_bw(x0+dx/8+1,x1-dx/8-1,y0+dy/8+((dy>2)?1:0),
                                     y1-dy/8-((dy>2)?1:0),box1->p,cs,2)==2 ) break;
      if( box1->dots ) { setac(box1,'=',97);break; }
      if (dx<=2*dy) ad=98*ad/100;
      if (dx<=3*dy) ad=99*ad/100;
      if (!box1->m4) ad=96*ad/100;
      else {
       if (y1>=box1->m3) {
         if (  dx<2*dy) ad=98*ad/100;
         if (2*dx<3*dy) ad=98*ad/100;
         setac(box1,'_',ad);
         break;
       }
      }
      setac(box1,'-',ad); if (ad>=100) return '-';
      break;
   }
   // --- test thin lines = ---------------------------------
   for( ; dy>2 && dx>4; ){     // max 3x3 (small font)
      for( y=y0;y<y1;y++)      // remove upper empty space
      if( get_bw(x0+dx/10,x1-dx/10,y      ,y      ,box1->p,cs,1)==1 ) break;
      if( get_bw(x0+dx/10,x1-dx/10,y      ,y      ,box1->p,cs,2)==2 ) break;
      if( get_bw(x0      ,x1    ,(y+y1)/2,(y+y1)/2,box1->p,cs,1)==1 ) break;
      if( get_bw(x0+dx/10,x1-dx/10,y1     ,y1     ,box1->p,cs,2)==2 ) break;
      setac(box1,'=',100);
      return '=';
   }
   // --- test dots : ---------------------------------
   if( 2*y0> box1->m2+box1->m1 ) // ~i
   if(   y1<=box1->m3+1 )      	// ~: 
   for( ad=100; dy>5 && dy>=2*dx; ){     // max 3x3 (small font)
      
      // check high of upper and lower dot
      for( i1=0;i1<dy/2;i1++)
        if( get_bw(x0,x1,y0+i1,y0+i1,box1->p,cs,1)==0 ) break;
      if (i1>=dy/2) break;
      for( i2=0;i2<dy/2;i2++)
        if( get_bw(x0,x1,y1-i2,y1-i2,box1->p,cs,1)==0 ) break;
      
      if (i2==3 && y1>box1->m3) ad=99*ad/100;
      if (gchar) ad=99*ad/100;
      ad=ad-abs(i1-i2)/dy*20; 
      if (box1->dots!=1) ad=96*ad/100;
      setac(box1,':',ad); // dx<=3  ad--
      if (ad>=100) return ':';
      break;
   }
   // --- test dots ; ---------------------------------
   if( 2*y0>   box1->m2+box1->m1 )	// ~i
   if( 4*y1>=3*box1->m3+box1->m2 )      // ~:
   for( ad=100; dy>5 && dx>1 && dy>2*dx; ){     // max 3x3 (small font)
      // better would it be to detect round pixelcluster on top
      // check high of upper and lower dot
      for( i1=0;i1<dy/2;i1++)
        if( get_bw(x0,x1,y0+i1,y0+i1,box1->p,cs,1)==0 ) break;
      if (i1>=dy/2) break;
      for( i2=0;i2<dy/2;i2++)
        if( get_bw(x0,x1,y1-i2,y1-i2,box1->p,cs,1)==0 ) break;
      
      if (i2<i1) break;
      if (i2==i1 && y1<=box1->m3) ad=97*ad/100;
      if (i2-i1<dy/8) ad=99*ad/100;
      setac(box1,';',ad); // dx<=3  ad--
      if (ad>=100) return ';';
      break;
   }
   // --- first test small dots . ---------------------------------
   if( 3*dy<box1->m4-box1->m1 && abs(dx-dy)<(dx+dy)/4+2
    && 3*y1>=(2*box1->m3+  box1->m2)	// dot near baseline?
    && 5*y0>=(3*box1->m3+2*box1->m2) ){ // Jul00
     d=0; r1=600;r2=1400; ad=99;
     for(x=x0;x<=x1;x++)for(y=y0;y<=y1;y++){ /* circle equation */
       rx=1000*(2*x-(x0+x1))/dx;	// normiert auf 1000
       ry=1000*(2*y-(y0+y1))/dy;
       if( rx*rx + ry*ry < r1*r1 ) if( pixel(box1->p,x,y)>=cs ){ d++;x=x1+1;y=y1+1; }
       if( rx*rx + ry*ry > r2*r2 ) if( pixel(box1->p,x,y)< cs ){ d++;x=x1+1;y=y1+1; }
     }
     if(d==0)
     if(  loop(box1->p,x0,y0,x1-x0,cs,0,RI)
       <= loop(box1->p,x0,y1,x1-x0,cs,0,RI)
      ||  loop(box1->p,x1,y0,x1-x0,cs,0,LE)
       >= loop(box1->p,x1,y1,x1-x0,cs,0,LE) )
     {
      bc='.'; if (box1->dots) { setac(box1,':',ad); ad=98*ad/100; }
      setac(box1,bc,ad);
     }
   }
   // --- first test small dots , ---------------------------------
   if( 3*dy<2*(box1->m4-box1->m1)
    && 2*y0>   box1->m2+box1->m3
    && (2*dx<3*dy 
     || get_bw(0,dx/2,dy/2,dy-1,bp,cs,1)==0) ){  // ocr-a-,
      ad=100; bc=',';
      if( 2*dy >= box1->m4-box1->m1) ad=98*ad/100;
      if(  loop(box1->p,x0,y0,x1-x0,cs,0,RI)  /* simple line */
         > loop(box1->p,x0,y1,x1-x0,cs,0,RI)
       &&  loop(box1->p,x1,y0,x1-x0,cs,0,LE)
         < loop(box1->p,x1,y1,x1-x0,cs,0,LE) ) { ad=99*ad/100; }
      else { /* with upper circle */
        if( loop(box1->p,x0,(y0+y1+1)/2,x1-x0,cs,0,RI)<dx/2 ) ad=98*ad/100;
        if( loop(box1->p,x1,    y1     ,x1-x0,cs,0,LE)<dx/2 ) ad=98*ad/100;
        if( loop(box1->p,x0,y1-((dy>5)?1:0),x1-x0,cs,0,LE)>(dx+1)/2 )
        if( loop(box1->p,x0,    y1         ,x1-x0,cs,0,LE)>(dx+1)/2 ) ad=96*ad/100;
      }
      if(box1->dots==1) { setac(box1,';',ad); ad=99*ad/100; }
      setac(box1,bc,ad);
   }
   // --- first test small dots ' ---------------------------------
   if( 2*dy < box1->m4  -box1->m1
    && 2*y0 < box1->m1  +box1->m2
    && 3*y1 < box1->m2+2*box1->m3 ){
      ad=100; bc='\'';
      if (2*y1 >= box1->m2+box1->m3 ) ad=96*ad/100; // ~!
      if (3*y1>=2*box1->m2+box1->m3) ad=96*ad/100;
      if (get_bw(x0,x1,(box1->m2+box1->m3)/2,box1->m4,box1->p,cs,1)!=0) ad=98*ad/100;
      if (dx>4 
       && num_cross(x0,x1,y1,y1,box1->p,cs) == 2) { // " "
        bc='"';
        // ocr-a-" has no gap!
        if (get_bw((x0+x1)/2,(x0+x1)/2,y0,y1,box1->p,cs,1)!=0 ) ad=96*ad/100;
      } else {
        if ( num_cross(x0,x1, y0      , y0      ,box1->p,cs)!=1) ad=96*ad/100;
        if ( num_cross(x0,x1,(y0+y1)/2,(y0+y1)/2,box1->p,cs)!=1) ad=98*ad/100;
        if (dx>dy) ad=96*ad/100;
      }
      setac(box1,bc,ad);
      if (ad>=100) return bc;
   }
   // --- TILDE ~ ---------------------------------
   if( 2*dy<box1->m4-box1->m1 && dx>=dy && dx>3 && dy>1
    && 2*y0<  box1->m1+box1->m2
    && 3*y1<2*box1->m2+box1->m3 ){
     if( loop(box1->p,x0,y0,dx,cs,0,RI)
       > loop(box1->p,x0,y1,dx,cs,0,RI)
      && loop(box1->p,x1,y0,dx,cs,0,LE)
       < loop(box1->p,x1,y1,dx,cs,0,LE)
      && num_cross(x0,x1,y0,y0,box1->p,cs) == 2 
      && num_cross(x0,x1,y1,y1,box1->p,cs) == 2 ) {
        bc=TILDE;
        setac(box1,bc,99);
      }
    }
   // --- CIRCUMFLEX, hat ^ ---------------------------------
   if( 2*dy<box1->m4-box1->m1 && dx>=dy && dx>2 && dy>1
    && 2*y0<  box1->m1+box1->m2
    && 3*y1<2*box1->m2+box1->m3 ){
     if( ( loop(box1->p,x0,y0  ,dx,cs,0,RI)
         > loop(box1->p,x0,y1  ,dx,cs,0,RI)-dx/8
        || loop(box1->p,x0,y0  ,dx,cs,0,RI)
         > loop(box1->p,x0,y1-1,dx,cs,0,RI)-dx/8 )
      && ( loop(box1->p,x1,y0  ,dx,cs,0,LE)
         > loop(box1->p,x1,y1  ,dx,cs,0,LE)-dx/8
        || loop(box1->p,x1,y0  ,dx,cs,0,LE)
         > loop(box1->p,x1,y1-1,dx,cs,0,LE)-dx/8 )
     &&   num_cross(x0,x1,y0  ,y0  ,box1->p,cs) == 1 
     && ( num_cross(x0,x1,y1  ,y1  ,box1->p,cs) == 2
       || num_cross(x0,x1,y1-1,y1-1,box1->p,cs) == 2 )) {
        bc='^';
        setac(box1,bc,99);
      }
    }
   // ------------------------------------------------------
//   if( dots==1 ){ um='\''; }
#if 1
   if( box1->dots==0 ){ // i-dots ??? (if dots==0 is wrong)
      y=box1->m1;
      for(;y<y0+dy/2;y++)if( get_bw(x0+dx/4,x1,y,y,box1->p,cs,1)==1) break;
      { i1=y;
        if( y<y0+dy/4 )
        for(;y<y0+dy/2;y++)if( get_bw(x0,x1,y,y,box1->p,cs,1)==0) break;
        if( y<y0+dy/2 && 5*(y-i1+1)>box1->m2-box1->m1){
          testumlaut(box1,cs,2,&um);

        }
      }
   }
#endif
   if( /* um==ACUTE_ACCENT || */ um==DIAERESIS){
      for(y=y1;y>y0;y--)
      if( get_bw(x0,x1,y,y,box1->p,cs,1)==0) { y0=y; dy=y1-y0+1; break; } // scan "a "o "u
   }

   // --- test numbers 0..9 --- separated for faster compilation
   if( JOB->cfg.only_numbers ) return ocr0n(&sdata);

   bc=ocr1(box1,bp,cs);
   if(bc!=UNKNOWN)
     return bc; // for fast compilable tests

   // ------ separated for faster compilation
   // ToDo: inser ocr0_shared_t here and split into a,b,cC,d,e,f,g9,...
#define IF_NOT_SURE if(bc==UNKNOWN || box1->num_ac==0 || box1->wac[0]<100)

   IF_NOT_SURE  bc=ocr0_eE(&sdata);
   IF_NOT_SURE  bc=ocr0_f(&sdata);
   IF_NOT_SURE  bc=ocr0_bB(&sdata);
   IF_NOT_SURE  bc=ocr0_dD(&sdata);
   IF_NOT_SURE  bc=ocr0_F(&sdata);
   IF_NOT_SURE  bc=ocr0_uU(&sdata);
   IF_NOT_SURE  bc=ocr0_micro(&sdata);
   IF_NOT_SURE  bc=ocr0_vV(&sdata);
   IF_NOT_SURE  bc=ocr0_rR(&sdata);
   IF_NOT_SURE  bc=ocr0_m(&sdata);
   IF_NOT_SURE  bc=ocr0_tT(&sdata);
   IF_NOT_SURE  bc=ocr0_sS(&sdata);
   IF_NOT_SURE  bc=ocr0_gG(&sdata);
   IF_NOT_SURE  bc=ocr0_xX(&sdata);
   IF_NOT_SURE  bc=ocr0_yY(&sdata);
   IF_NOT_SURE  bc=ocr0_zZ(&sdata);
   IF_NOT_SURE  bc=ocr0_wW(&sdata);
   IF_NOT_SURE  bc=ocr0_aA(&sdata);
   IF_NOT_SURE  bc=ocr0_cC(&sdata);
   IF_NOT_SURE  bc=ocr0_lL(&sdata);
   IF_NOT_SURE  bc=ocr0_oO(&sdata);
   IF_NOT_SURE  bc=ocr0_pP(&sdata);
   IF_NOT_SURE  bc=ocr0_qQ(&sdata);
   IF_NOT_SURE  bc=ocr0_iIjJ(&sdata);
   IF_NOT_SURE  bc=ocr0_n(&sdata);
   IF_NOT_SURE  bc=ocr0_M(&sdata);
   IF_NOT_SURE  bc=ocr0_N(&sdata);
   IF_NOT_SURE  bc=ocr0_h(&sdata);
   IF_NOT_SURE  bc=ocr0_H(&sdata);
   IF_NOT_SURE  bc=ocr0_k(&sdata);
   IF_NOT_SURE  bc=ocr0_K(&sdata);
   IF_NOT_SURE  bc=ocr0n(&sdata);
   IF_NOT_SURE  bc=ocr0_brackets(&sdata);
   IF_NOT_SURE  bc=ocr0p9(&sdata);
   IF_NOT_SURE  bc=ocr0px(&sdata);

   if(box1->num_ac==0 && bc!=UNKNOWN) fprintf(stderr,"<!--ERROR 576-->");
   if(box1->num_ac>0 && box1->wac[0]>95) box1->c=bc=box1->tac[0];
   /* will be removed later, only fix old things */
   for (i=0;i<box1->num_ac;i++) if (box1->tac[i]==bc) { bc=box1->tac[0]; }
   
   return bc;
}


