// jpg support added by christoph johann szczecina
// kyynel<at>freenet.de
// Uses The Independent JPEG Group's JPEG library

#include <stdio.h>
#include <stdlib.h>
#include <jpeglib.h>
#include <jerror.h>
#include <setjmp.h> 

#include "jpg.h"

#ifdef ZUNEGOCR	
#include "zune-gocr.h"
#endif


#include "config.h"

//=========================================================================================================

// DEFINITIOS AND MACROS

//=========================================================================================================


#define ERR(x) { fprintf(stderr,"ERROR "__FILE__" L%d: " x "\n",__LINE__);exit(1);}
typedef unsigned char byte;


//---------------------------------------------------------------------------------------------------------


struct my_error_mgr 
{
  struct jpeg_error_mgr pub;	/* "public" fields */
  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;



METHODDEF(void)
my_error_exit (j_common_ptr cinfo)
{
  /* cinfo->err really points to a my_error_mgr struct, so coerce pointer */
  my_error_ptr myerr = (my_error_ptr) cinfo->err;


  /* Always display the message. */
  /* We could postpone this until after returning, if we chose. */
  (*cinfo->err->output_message) (cinfo);

  /* Return control to the setjmp point */
  longjmp(myerr->setjmp_buffer, 1);
}


// jpeg decompression
int read_JPEG_file (char * filename, tDIB *a)
{

  struct jpeg_decompress_struct cinfo;

  // set error handling
  struct my_error_mgr jerr;


  FILE * infile;		/* source file */
  JSAMPARRAY buffer;	/* Output row buffer */
  int row_stride;		/* physical row width in output buffer */



  // open input file
  if ((infile = fopen(filename, "rb")) == NULL) 
  {
          
   #ifndef ZUNEGOCR	
    fprintf(stderr, "can't open %s\n", filename);
   #else
    set(status, MUIA_Text_Contents, (IPTR)"\33cError opening jpeg file!"); 
   #endif
  
    return 0;
  }



  // allocate and initialize JPEG decompression object
  cinfo.err = jpeg_std_error(&jerr.pub);
  jerr.pub.error_exit = my_error_exit;


  // Establish the setjmp return context for my_error_exit to use. 
  if (setjmp(jerr.setjmp_buffer)) 
  {
    jpeg_destroy_decompress(&cinfo);
    fclose(infile);
    return 0;
  }



  // Now we can initialize the JPEG decompression object. 
  jpeg_create_decompress(&cinfo);

  // specify data source (eg, a file)  
  jpeg_stdio_src(&cinfo, infile);


  // read file parameters with jpeg_read_header() 
  (void) jpeg_read_header(&cinfo, TRUE);

  (void) jpeg_start_decompress(&cinfo);

  row_stride = cinfo.output_width * cinfo.output_components;

  // Make a one-row-high sample array that will go away when done with image 
  buffer = (*cinfo.mem->alloc_sarray) ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);

  // allocate buffer and set buffer info 
  //a->b=Alloc( (cinfo.output_width*cinfo.output_height*cinfo.output_components) ,BYTE);	// components: 3 bei 24bit (also 3byte; 3*8bit)
  a->b=(unsigned char *)malloc( (cinfo.output_width*cinfo.output_height*cinfo.output_components) );
  a->y=cinfo.output_height;
  a->x=cinfo.output_width;	


  int i;
  long n = 0;

  // decompress data and copy to work buffer
  while (cinfo.output_scanline < cinfo.output_height) 
  {
    (void) jpeg_read_scanlines(&cinfo, buffer, 1);

	for(i = 0; i < row_stride; i++)
	{
		*(a->b + n++ )  = *(buffer[0] + i);
	}

  }


  (void) jpeg_finish_decompress(&cinfo);

  jpeg_destroy_decompress(&cinfo);


  fclose(infile);


  //a->l=3*(a->x+1)&(~3);
  a->l= 3*a->x;

  // check if image is allready greyscale
  if (cinfo.output_components == 1)
  {
	return 2;
  }

  return 1;

}

//---------------------------------------------------------------------------------------------------------

int readjpg(char *name,pix *p,int vvv)
{
	//Heap=GetProcessHeap();

	unsigned char *pic;
	int jpgret = 0;


	//--- init ---------------------------------------------------


	// allocate memory for bitmaps
	tDIB a;							// device independent bitmap structure


	// load jpeg
	jpgret = (read_JPEG_file (name, &a));

	// check if data rgb, grey of false!!
	if( jpgret == 1) // rgb
	{
		// mem for grayscale bitmap
		pic=(unsigned char *)malloc( a.x*a.y );	// alloc mem for x*y pixels



		if(pic==NULL)
		{

           #ifndef ZUNEGOCR	
            ERR("no memory");			// no memory
           #else
            set(status, MUIA_Text_Contents, (IPTR)"\33cJpeg memory error!"); 
           #endif
   		
			return 0; //false;
		}



		// "convert" file to "grayscale"  :))
		int x,y;

		double luminance;


		for (y = 0; y < a.y; y++) 
		{

			for (x = 0; x < a.x; x++) 
			{

				// get the rgb-values of the two pixels (bitmap a & b) at position x,y

				byte *pixel_a=a.b+y*a.l+(x<<1)+x;
				// get luminance
				luminance = (0.3*(pixel_a[0])) + (0.59*(pixel_a[1])) + (0.11*(pixel_a[2]));
				// save (rgb)r-channel as grayscale to pic buffer
				pic[x+a.x*y] = (byte) luminance;
			}
		}



		// set bitmap values for gocr
		p->p=pic;  p->x=a.x;  p->y=a.y; p->bpp=1; 

		// free memory
		free (a.b);						// destroys device independent bitmap - deallocating bitmap data is enough

	}
	else if(jpgret == 2) // grey
	{
		// set bitmap values for gocr
		p->p=a.b;  p->x=a.x;  p->y=a.y; p->bpp=1; 
	}
	else // wrong or no data
	{

           #ifndef ZUNEGOCR	
            printf("\nERROR: Could not load .jpg file!! Check file and path!\n\n");
           #else
            set(status, MUIA_Text_Contents, (IPTR)"\33cCould not load jpeg file!! Check file and path!"); 
           #endif
           
        return 0; //false;
	}

	return 1; //true;

}



//---------------------------------------------------------------------------------------------------------

