/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.QTDecompressor;
import com.twelvemonkeys.imageio.plugins.pict.QuickTime;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOException;

final class QTRAWDecompressor
extends QTDecompressor {
    QTRAWDecompressor() {
    }

    @Override
    public boolean canDecompress(QuickTime.ImageDesc imageDesc) {
        return "appl".equals(imageDesc.compressorVendor) && "raw ".equals(imageDesc.compressorIdentifer) && (imageDesc.depth == 24 || imageDesc.depth == 32 || imageDesc.depth == 40);
    }

    @Override
    public BufferedImage decompress(QuickTime.ImageDesc imageDesc, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[imageDesc.dataSize];
        Object object = new DataInputStream(inputStream);
        Object object2 = null;
        try {
            ((DataInputStream)object).readFully(byArray, 0, imageDesc.dataSize);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((FilterInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((FilterInputStream)object).close();
                }
            }
        }
        object = new DataBufferByte(byArray, byArray.length);
        switch (imageDesc.depth) {
            case 40: {
                object2 = Raster.createInterleavedRaster((DataBuffer)object, imageDesc.width, imageDesc.height, imageDesc.width, 1, new int[]{0}, null);
                break;
            }
            case 24: {
                object2 = Raster.createInterleavedRaster((DataBuffer)object, imageDesc.width, imageDesc.height, imageDesc.width * 3, 3, new int[]{0, 1, 2}, null);
                break;
            }
            case 32: {
                for (int i = 0; i < imageDesc.height; ++i) {
                    for (int j = 0; j < imageDesc.width; ++j) {
                        int n = 4 * i * imageDesc.width + j * 4;
                        byte by = byArray[n + 1];
                        byArray[n + 1] = byArray[n + 3];
                        byArray[n + 3] = by;
                    }
                }
                object2 = Raster.createInterleavedRaster((DataBuffer)object, imageDesc.width, imageDesc.height, imageDesc.width * 4, 4, new int[]{3, 2, 1, 0}, null);
                break;
            }
            default: {
                throw new IIOException("Unsupported QuickTime RAW depth: " + imageDesc.depth);
            }
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(imageDesc.depth <= 32 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003), imageDesc.depth == 32, false, imageDesc.depth == 32 ? 3 : 1, 0);
        return new BufferedImage(componentColorModel, (WritableRaster)object2, componentColorModel.isAlphaPremultiplied(), null);
    }
}

