/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

public class QuadraticProbingHashTable<K, V> {
    private static final int DEFAULT_TABLE_SIZE = 11;
    private HashEntry<K, V>[] array;
    private int currentSize;

    public QuadraticProbingHashTable() {
        this(11);
    }

    public QuadraticProbingHashTable(int n) {
        this.array = new HashEntry[n];
        this.makeEmpty();
    }

    public void put(K k, V v) {
        int n = this.locate(k);
        if (this.isActive(n)) {
            return;
        }
        this.array[n] = new HashEntry<K, V>(k, v, true);
        if (++this.currentSize > this.array.length / 2) {
            this.rehash();
        }
    }

    private void rehash() {
        HashEntry<K, V>[] hashEntryArray = this.array;
        this.array = new HashEntry[QuadraticProbingHashTable.nextPrime(2 * hashEntryArray.length)];
        this.currentSize = 0;
        for (int i = 0; i < hashEntryArray.length; ++i) {
            if (hashEntryArray[i] == null || !hashEntryArray[i].isActive) continue;
            this.put(hashEntryArray[i].key, hashEntryArray[i].value);
        }
    }

    private int locate(K k) {
        int n = 0;
        int n2 = k.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % this.array.length;
        while (this.array[n3] != null && !this.array[n3].key.equals(k)) {
            if ((n3 += 2 * ++n - 1) < this.array.length) continue;
            n3 -= this.array.length;
        }
        return n3;
    }

    public void remove(K k) {
        int n = this.locate(k);
        if (this.isActive(n)) {
            this.array[n].isActive = false;
            --this.currentSize;
        }
    }

    public boolean contains(K k) {
        return this.isActive(this.locate(k));
    }

    public V get(K k) {
        int n = this.locate(k);
        return this.isActive(n) ? (V)this.array[n].value : null;
    }

    private boolean isActive(int n) {
        return this.array[n] != null && this.array[n].isActive;
    }

    public void makeEmpty() {
        this.currentSize = 0;
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
    }

    public static int hashString(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = 37 * n2 + string.charAt(i);
        }
        if ((n2 %= n) < 0) {
            n2 += n;
        }
        return n2;
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!QuadraticProbingHashTable.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int n2 = 3;
        while (n2 * n2 <= n) {
            if (n % n2 == 0) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        QuadraticProbingHashTable<Integer, Integer> quadraticProbingHashTable = new QuadraticProbingHashTable<Integer, Integer>();
        System.out.println("Checking... (no more output means success)");
        int n = 37;
        while (n != 0) {
            quadraticProbingHashTable.put(n, n);
            n = (n + 37) % 4000;
        }
        for (n = 1; n < 4000; n += 2) {
            quadraticProbingHashTable.remove(n);
        }
        for (n = 2; n < 4000; n += 2) {
            if ((Integer)quadraticProbingHashTable.get(n) == n) continue;
            System.out.println("Find fails " + n);
        }
        for (n = 1; n < 4000; n += 2) {
            if (quadraticProbingHashTable.get(n) == null) continue;
            System.out.println("OOPS!!! " + n);
        }
    }

    private static class HashEntry<K, V> {
        K key;
        V value;
        boolean isActive;

        HashEntry(K k, V v, boolean bl) {
            this.key = k;
            this.value = v;
            this.isActive = bl;
        }
    }
}

