/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import com.icafe4j.util.LinkedListItr;
import com.icafe4j.util.ListNode;

public class LinkedList<E> {
    private ListNode<E> header = new ListNode<Object>(null);

    public boolean isEmpty() {
        return this.header.next == null;
    }

    public void makeEmpty() {
        this.header.next = null;
    }

    public LinkedListItr<E> zeroth() {
        return new LinkedListItr<E>(this.header);
    }

    public LinkedListItr<E> first() {
        return new LinkedListItr(this.header.next);
    }

    public void insert(E e, LinkedListItr<E> linkedListItr) {
        if (linkedListItr != null && linkedListItr.current != null) {
            linkedListItr.current.next = new ListNode<E>(e, linkedListItr.current.next);
        }
    }

    public LinkedListItr<E> find(E e) {
        ListNode listNode = this.header.next;
        while (listNode != null && !listNode.element.equals(e)) {
            listNode = listNode.next;
        }
        return new LinkedListItr(listNode);
    }

    public LinkedListItr<E> findPrevious(E e) {
        ListNode<E> listNode = this.header;
        while (listNode.next != null && !listNode.next.element.equals(e)) {
            listNode = listNode.next;
        }
        return new LinkedListItr<E>(listNode);
    }

    public void remove(E e) {
        LinkedListItr<E> linkedListItr = this.findPrevious(e);
        if (linkedListItr.current.next != null) {
            linkedListItr.current.next = linkedListItr.current.next.next;
        }
    }

    private static <T> void printList(LinkedList<T> linkedList) {
        if (linkedList.isEmpty()) {
            System.out.print("Empty list");
        } else {
            LinkedListItr<T> linkedListItr = linkedList.first();
            while (!linkedListItr.isPastEnd()) {
                System.out.print(linkedListItr.retrieve() + " ");
                linkedListItr.advance();
            }
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        int n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedListItr linkedListItr = linkedList.zeroth();
        LinkedList.printList(linkedList);
        for (n = 0; n < 10; ++n) {
            linkedList.insert(n, linkedListItr);
            LinkedList.printList(linkedList);
            linkedListItr.advance();
        }
        for (n = 0; n < 10; n += 2) {
            linkedList.remove(n);
        }
        for (n = 0; n < 10; ++n) {
            if (n % 2 == 0 == linkedList.find(n).isPastEnd()) continue;
            System.out.println("Find fails!");
        }
        System.out.println("Finished deletions");
        LinkedList.printList(linkedList);
    }
}

