/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import com.icafe4j.util.BinaryTreeNode;

public class BinarySearchTree<E extends Comparable<? super E>> {
    private BinaryTreeNode<E> root = null;

    public void insert(E e) {
        this.root = this.insert(e, this.root);
    }

    public void remove(E e) {
        this.root = this.remove(e, this.root);
    }

    public void removeMinItem() {
        this.root = this.removeMinItem(this.root);
    }

    public E findMinItem() {
        return this.valueOf(this.findMinItem(this.root));
    }

    public E findMaxItem() {
        return this.valueOf(this.findMaxItem(this.root));
    }

    public E find(E e) {
        return this.valueOf(this.find(e, this.root));
    }

    public void makeEmpty() {
        this.root = null;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    E valueOf(BinaryTreeNode<E> binaryTreeNode) {
        return (E)(binaryTreeNode == null ? null : (Comparable)binaryTreeNode.val);
    }

    BinaryTreeNode<E> insert(E e, BinaryTreeNode<E> binaryTreeNode) {
        if (binaryTreeNode == null) {
            binaryTreeNode = new BinaryTreeNode<E>(e);
        } else {
            BinaryTreeNode<E> binaryTreeNode2 = null;
            BinaryTreeNode<E> binaryTreeNode3 = binaryTreeNode;
            while (binaryTreeNode3 != null && e.compareTo(binaryTreeNode3.val) != 0) {
                binaryTreeNode2 = binaryTreeNode3;
                binaryTreeNode3 = e.compareTo(binaryTreeNode3.val) < 0 ? binaryTreeNode3.left : binaryTreeNode3.right;
            }
            if (binaryTreeNode3 != null) {
                ++binaryTreeNode3.freq;
            } else if (e.compareTo(binaryTreeNode2.val) < 0) {
                binaryTreeNode2.left = new BinaryTreeNode<E>(e);
            } else {
                binaryTreeNode2.right = new BinaryTreeNode<E>(e);
            }
        }
        return binaryTreeNode;
    }

    BinaryTreeNode<E> remove(E e, BinaryTreeNode<E> binaryTreeNode) {
        BinaryTreeNode<E> binaryTreeNode2 = null;
        BinaryTreeNode<E> binaryTreeNode3 = binaryTreeNode;
        while (binaryTreeNode3 != null && e.compareTo(binaryTreeNode3.val) != 0) {
            binaryTreeNode2 = binaryTreeNode3;
            binaryTreeNode3 = e.compareTo(binaryTreeNode3.val) < 0 ? binaryTreeNode3.left : binaryTreeNode3.right;
        }
        if (binaryTreeNode3 != null) {
            if (binaryTreeNode3.left != null && binaryTreeNode3.right != null) {
                BinaryTreeNode binaryTreeNode4 = null;
                BinaryTreeNode binaryTreeNode5 = binaryTreeNode3.right;
                while (binaryTreeNode5.left != null) {
                    binaryTreeNode4 = binaryTreeNode5;
                    binaryTreeNode5 = binaryTreeNode5.left;
                }
                if (binaryTreeNode4 == null) {
                    binaryTreeNode3.val = binaryTreeNode3.right.val;
                    binaryTreeNode3.right = binaryTreeNode3.right.right;
                } else {
                    binaryTreeNode3.val = binaryTreeNode4.left.val;
                    binaryTreeNode4.left = binaryTreeNode4.left.right;
                }
            } else if (binaryTreeNode2 != null) {
                if (((Comparable)binaryTreeNode3.val).compareTo(binaryTreeNode2.val) < 0) {
                    binaryTreeNode2.left = binaryTreeNode3.left != null ? binaryTreeNode3.left : binaryTreeNode3.right;
                } else {
                    binaryTreeNode2.right = binaryTreeNode3.left != null ? binaryTreeNode3.left : binaryTreeNode3.right;
                }
            } else {
                return binaryTreeNode3.left != null ? binaryTreeNode3.left : binaryTreeNode3.right;
            }
        }
        return binaryTreeNode;
    }

    BinaryTreeNode<E> removeMinItem(BinaryTreeNode<E> binaryTreeNode) {
        if (binaryTreeNode == null) {
            return null;
        }
        BinaryTreeNode<E> binaryTreeNode2 = null;
        BinaryTreeNode<E> binaryTreeNode3 = binaryTreeNode;
        while (binaryTreeNode3.left != null) {
            binaryTreeNode2 = binaryTreeNode3;
            binaryTreeNode3 = binaryTreeNode3.left;
        }
        if (binaryTreeNode2 != null) {
            binaryTreeNode2.left = binaryTreeNode2.left.right;
            return binaryTreeNode;
        }
        return binaryTreeNode.right;
    }

    BinaryTreeNode<E> findMinItem(BinaryTreeNode<E> binaryTreeNode) {
        if (binaryTreeNode != null) {
            while (binaryTreeNode.left != null) {
                binaryTreeNode = binaryTreeNode.left;
            }
        }
        return binaryTreeNode;
    }

    BinaryTreeNode<E> findMaxItem(BinaryTreeNode<E> binaryTreeNode) {
        if (binaryTreeNode != null) {
            while (binaryTreeNode.right != null) {
                binaryTreeNode = binaryTreeNode.right;
            }
        }
        return binaryTreeNode;
    }

    BinaryTreeNode<E> find(E e, BinaryTreeNode<E> binaryTreeNode) {
        while (binaryTreeNode != null && e.compareTo(binaryTreeNode.val) != 0) {
            binaryTreeNode = e.compareTo(binaryTreeNode.val) < 0 ? binaryTreeNode.left : binaryTreeNode.right;
        }
        return binaryTreeNode;
    }

    public static void main(String[] stringArray) {
        BinarySearchTree<Integer> binarySearchTree = new BinarySearchTree<Integer>();
        System.out.println("Checking... (no more output means success)");
        int n = 37;
        while (n != 0) {
            binarySearchTree.insert(new Integer(n));
            n = (n + 37) % 4000;
        }
        for (n = 1; n < 4000; n += 2) {
            binarySearchTree.remove(new Integer(n));
        }
        if ((Integer)binarySearchTree.findMinItem() != 2 || (Integer)binarySearchTree.findMaxItem() != 3998) {
            System.out.println("FindMin or FindMax error!");
        }
        for (n = 2; n < 4000; n += 2) {
            if (binarySearchTree.find(new Integer(n)) == n) continue;
            System.out.println("Find error1!");
        }
        for (n = 1; n < 4000; n += 2) {
            if (binarySearchTree.find(new Integer(n)) == null) continue;
            System.out.println("Find error2!");
        }
    }
}

