/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.test;

import com.icafe4j.image.ImageColorType;
import com.icafe4j.image.ImageFrame;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.meta.exif.Exif;
import com.icafe4j.image.meta.exif.ExifTag;
import com.icafe4j.image.meta.tiff.TiffExif;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.options.TIFFOptions;
import com.icafe4j.image.quant.DitherMethod;
import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.image.writer.TIFFWriter;
import com.icafe4j.io.ByteOrder;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.FileCacheRandomAccessOutputStream;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.RandomAccessOutputStream;
import com.icafe4j.io.WriteStrategyII;
import com.icafe4j.test.TestBase;
import com.icafe4j.util.FileUtils;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.imageio.ImageIO;

public class TestTIFFTweaker
extends TestBase {
    public static void main(String[] stringArray) throws Exception {
        new TestTIFFTweaker().test(stringArray);
    }

    @Override
    public void test(String ... stringArray) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(fileInputStream);
        FileOutputStream fileOutputStream = null;
        FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = null;
        if (stringArray.length > 1) {
            if (stringArray[1].equalsIgnoreCase("copycat")) {
                fileOutputStream = new FileOutputStream("NEW.tif");
                fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(fileOutputStream);
                TIFFTweaker.copyCat(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream);
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                fileOutputStream.close();
            } else if (stringArray[1].equalsIgnoreCase("snoop")) {
                TIFFTweaker.readMetadata(fileCacheRandomAccessInputStream);
            } else if (stringArray[1].equalsIgnoreCase("extractThumbnail")) {
                TIFFTweaker.extractThumbnail(fileCacheRandomAccessInputStream, "thumbnail");
            } else if (stringArray[1].equalsIgnoreCase("extractICCProfile")) {
                byte[] byArray = TIFFTweaker.extractICCProfile(fileCacheRandomAccessInputStream);
                if (byArray != null) {
                    FileOutputStream fileOutputStream2 = new FileOutputStream(new File("ICCProfile.icc"));
                    ((OutputStream)fileOutputStream2).write(byArray);
                    ((OutputStream)fileOutputStream2).close();
                }
            } else if (stringArray[1].equalsIgnoreCase("retainpage")) {
                int n = TIFFTweaker.getPageCount(fileCacheRandomAccessInputStream);
                fileOutputStream = new FileOutputStream("NEW.tif");
                fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(fileOutputStream);
                if (n > 1) {
                    TIFFTweaker.retainPages(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, n - 1);
                } else {
                    TIFFTweaker.copyCat(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream);
                }
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                fileOutputStream.close();
            } else if (stringArray[1].equalsIgnoreCase("writemultipage") || stringArray[1].equalsIgnoreCase("insertpage")) {
                Object object;
                File[] fileArray = FileUtils.listFilesMatching(new File(stringArray[2]), stringArray[3]);
                ImageFrame[] imageFrameArray = new ImageFrame[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    object = ImageIO.read(fileInputStream);
                    imageFrameArray[i] = new ImageFrame((BufferedImage)object);
                    fileInputStream.close();
                }
                ImageParam.ImageParamBuilder imageParamBuilder = ImageParam.getBuilder();
                object = new TIFFOptions();
                ((TIFFOptions)object).setTiffCompression(TiffFieldEnum.Compression.LZW);
                ((TIFFOptions)object).setApplyPredictor(true);
                ((TIFFOptions)object).setDeflateCompressionLevel(6);
                imageParamBuilder.imageOptions((ImageOptions)object);
                imageFrameArray[0].setFrameParam(imageParamBuilder.colorType(ImageColorType.GRAY_SCALE).hasAlpha(true).build());
                object = new TIFFOptions((TIFFOptions)object);
                ((TIFFOptions)object).setTiffCompression(TiffFieldEnum.Compression.DEFLATE);
                imageFrameArray[1].setFrameParam(imageParamBuilder.imageOptions((ImageOptions)object).build());
                object = new TIFFOptions((TIFFOptions)object);
                ((TIFFOptions)object).setTiffCompression(TiffFieldEnum.Compression.CCITTFAX4);
                ImageParam imageParam = imageParamBuilder.colorType(ImageColorType.BILEVEL).applyDither(true).ditherMethod(DitherMethod.BAYER).imageOptions((ImageOptions)object).build();
                for (int i = 2; i < imageFrameArray.length; ++i) {
                    imageFrameArray[i].setFrameParam(imageParam);
                }
                fileOutputStream = new FileOutputStream("NEW.tif");
                fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(fileOutputStream);
                fileCacheRandomAccessOutputStream.setWriteStrategy(WriteStrategyII.getInstance());
                if (stringArray[1].equalsIgnoreCase("writemultipage")) {
                    TIFFWriter tIFFWriter = new TIFFWriter();
                    ArrayList<IFD> arrayList = new ArrayList<IFD>();
                    int n = TIFFTweaker.prepareForWrite(fileCacheRandomAccessOutputStream, ByteOrder.LITTLE_ENDIAN);
                    for (int i = 0; i < imageFrameArray.length; ++i) {
                        n = TIFFTweaker.writePage(imageFrameArray[i], (RandomAccessOutputStream)fileCacheRandomAccessOutputStream, arrayList, n, tIFFWriter);
                    }
                    TIFFTweaker.finishWrite(fileCacheRandomAccessOutputStream, arrayList);
                } else {
                    int n;
                    long l = System.currentTimeMillis();
                    ArrayList<IFD> arrayList = new ArrayList<IFD>();
                    int n2 = TIFFTweaker.prepareForInsert(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, arrayList);
                    int n3 = 3;
                    TIFFWriter tIFFWriter = new TIFFWriter();
                    tIFFWriter.setImageParam(imageFrameArray[0].getFrameParam());
                    for (n = 0; n < imageFrameArray.length; ++n) {
                        n2 = TIFFTweaker.insertPage(imageFrameArray[n].getFrame(), n3 += 2, (RandomAccessOutputStream)fileCacheRandomAccessOutputStream, arrayList, n2, tIFFWriter);
                    }
                    n = 2;
                    byte[] byArray = new byte[]{0, -1};
                    byte[] byArray2 = new byte[]{0, -1};
                    byte[] byArray3 = new byte[]{0, -1};
                    int n4 = 400;
                    int n5 = 400;
                    IndexColorModel indexColorModel = new IndexColorModel(1, n, byArray, byArray2, byArray3);
                    BufferedImage bufferedImage = new BufferedImage(n4, n5, 12, indexColorModel);
                    WritableRaster writableRaster = bufferedImage.getRaster();
                    for (int i = 0; i < n5; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            if ((i / 50 + j / 50) % 2 == 0) {
                                writableRaster.setSample(j, i, 0, 0);
                                continue;
                            }
                            writableRaster.setSample(j, i, 0, 1);
                        }
                    }
                    tIFFWriter.setImageParam(imageFrameArray[2].getFrameParam());
                    TIFFTweaker.insertPage(bufferedImage, 0, (RandomAccessOutputStream)fileCacheRandomAccessOutputStream, arrayList, n2, tIFFWriter);
                    TIFFTweaker.finishInsert(fileCacheRandomAccessOutputStream, arrayList);
                    long l2 = System.currentTimeMillis();
                    this.logger.info("time used: {}ms", (Object)(l2 - l));
                }
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                fileOutputStream.close();
            } else if (stringArray[1].equalsIgnoreCase("splitpage")) {
                TIFFTweaker.splitPages((RandomAccessInputStream)fileCacheRandomAccessInputStream, FileUtils.getNameWithoutExtension(new File(stringArray[0])));
            } else if (stringArray[1].equalsIgnoreCase("splitpagebytes")) {
                TIFFTweaker.splitPages((RandomAccessInputStream)fileCacheRandomAccessInputStream, new ArrayList<byte[]>());
            } else if (stringArray[1].equalsIgnoreCase("insertexif")) {
                fileOutputStream = new FileOutputStream("EXIF.tif");
                fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(fileOutputStream);
                TIFFTweaker.insertExif(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, TestTIFFTweaker.populateExif(), true);
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                fileOutputStream.close();
            } else if (stringArray[1].equalsIgnoreCase("insertcomments")) {
                fileOutputStream = new FileOutputStream("comments-inserted.tif");
                fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(fileOutputStream);
                TIFFTweaker.insertComments(Arrays.asList("Comment1", "Comment2"), fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream);
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                fileOutputStream.close();
            } else if (stringArray[1].equalsIgnoreCase("removepage")) {
                int n = TIFFTweaker.getPageCount(fileCacheRandomAccessInputStream);
                fileOutputStream = new FileOutputStream("NEW.tif");
                fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(fileOutputStream);
                if (n > 1) {
                    TIFFTweaker.removePages(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, 0, 1, 1, 1, 5, 5, 4, 100, -100);
                } else {
                    TIFFTweaker.copyCat(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream);
                }
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                fileOutputStream.close();
            }
        }
        ((InputStream)fileCacheRandomAccessInputStream).close();
    }

    private static Exif populateExif() throws Exception {
        TiffExif tiffExif = new TiffExif();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        tiffExif.addExifField(ExifTag.EXPOSURE_TIME, FieldType.RATIONAL, new int[]{10, 600});
        tiffExif.addExifField(ExifTag.FNUMBER, FieldType.RATIONAL, new int[]{49, 10});
        tiffExif.addExifField(ExifTag.ISO_SPEED_RATINGS, FieldType.SHORT, new short[]{273});
        tiffExif.addExifField(ExifTag.EXIF_VERSION, FieldType.UNDEFINED, new byte[]{48, 50, 50, 48});
        tiffExif.addExifField(ExifTag.DATE_TIME_ORIGINAL, FieldType.ASCII, simpleDateFormat.format(new Date()));
        tiffExif.addExifField(ExifTag.DATE_TIME_DIGITIZED, FieldType.ASCII, simpleDateFormat.format(new Date()));
        tiffExif.addExifField(ExifTag.FOCAL_LENGTH, FieldType.RATIONAL, new int[]{240, 10});
        return tiffExif;
    }
}

