/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.bmp.BmpCompression;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMPReader
extends ImageReader {
    private static final int END_OF_LINE = 0;
    private static final int END_OF_BITMAP = 1;
    private static final int DELTA = 2;
    private int bytePerScanLine;
    private int alignment = 0;
    private int compression = 0;
    BitmapHeader bitmapHeader;
    private static final Logger LOGGER = LoggerFactory.getLogger(BMPReader.class);

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        this.bitmapHeader = new BitmapHeader();
        this.bitmapHeader.readHeader(inputStream);
        this.width = this.bitmapHeader.imageWidth;
        this.height = this.bitmapHeader.imageHeight;
        this.compression = this.bitmapHeader.compression;
        if (this.height < 0) {
            this.alignment = 1;
            this.height = -this.height;
        }
        LOGGER.info("Scanline alignment: {}", (Object)(this.alignment == 0 ? "BOTTOM_UP" : "TOP_DOWN"));
        this.bitsPerPixel = this.bitmapHeader.bitCount;
        int n = this.width * this.bitsPerPixel;
        this.bytePerScanLine = n % 32 == 0 ? n >>> 3 : (n >>> 3) + (4 - (n >>> 3) % 4);
        switch (this.bitmapHeader.bitCount) {
            case 1: {
                return this.readIndexColorBitmap(inputStream);
            }
            case 4: 
            case 8: {
                if (this.compression == BmpCompression.BI_RLE4.getValue() || this.compression == BmpCompression.BI_RLE8.getValue()) {
                    return this.readCompressedIndexColorBitmap(inputStream);
                }
                return this.readIndexColorBitmap(inputStream);
            }
            case 16: {
                LOGGER.error("16 bit BMP, decoding not implemented!");
                return null;
            }
            case 24: {
                return this.read24bitTrueColorBitmap(inputStream);
            }
            case 32: {
                return this.read32bitTrueColorBitmap(inputStream);
            }
        }
        LOGGER.error("Unsupported bitmap format!");
        return null;
    }

    private void readPalette(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = this.bitmapHeader.colorsUsed == 0 ? 1 << this.bitsPerPixel : this.bitmapHeader.colorsUsed;
        byte[] byArray = new byte[n3 * 4];
        this.rgbColorPalette = new int[n3];
        IOUtils.readFully(inputStream, byArray, 0, n3 * 4);
        for (int i = 0; i < n3; ++i) {
            this.rgbColorPalette[n++] = 0xFF000000 | byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16;
            n2 += 4;
        }
        IOUtils.skipFully(inputStream, this.bitmapHeader.dataOffSet - n3 * 4 - this.bitmapHeader.infoHeaderLen - 14);
    }

    private BufferedImage read24bitTrueColorBitmap(InputStream inputStream) throws Exception {
        int n;
        int n2;
        LOGGER.info("24 bits bitmap color image!");
        int n3 = this.bytePerScanLine - 3 * this.width;
        if (n3 == 4) {
            n3 = 0;
        }
        IOUtils.skipFully(inputStream, this.bitmapHeader.dataOffSet - 54);
        int n4 = this.bytePerScanLine - n3;
        byte[] byArray = new byte[this.bytePerScanLine];
        byte[] byArray2 = new byte[n4 * this.height];
        LOGGER.info("Scanline padding: {}", (Object)n3);
        if (this.alignment == 0) {
            n2 = 0;
            n = (this.height - 1) * n4;
            while (n2 < this.height) {
                IOUtils.readFully(inputStream, byArray);
                System.arraycopy(byArray, 0, byArray2, n, n4);
                ++n2;
                n -= n4;
            }
        } else {
            n2 = 0;
            n = 0;
            while (n2 < this.height) {
                IOUtils.readFully(inputStream, byArray);
                System.arraycopy(byArray, 0, byArray2, n, n4);
                ++n2;
                n += n4;
            }
        }
        inputStream.close();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        int[] nArray = new int[]{2, 1, 0};
        int n5 = 3;
        int n6 = 1;
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.width, this.height, n4, n5, nArray, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, n6, 0);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private BufferedImage read32bitTrueColorBitmap(InputStream inputStream) throws Exception {
        int n;
        int n2;
        int n3;
        LOGGER.info("32 bits bitmap color image!");
        byte[] byArray = new byte[this.bytePerScanLine];
        int[] nArray = new int[this.width * this.height];
        IOUtils.skipFully(inputStream, this.bitmapHeader.dataOffSet - 54);
        if (this.alignment == 0) {
            n3 = 0;
            for (n2 = 1; n2 <= this.height; ++n2) {
                IOUtils.readFully(inputStream, byArray, 0, this.bytePerScanLine);
                n3 = this.width * (this.height - n2);
                int n4 = 0;
                for (n = 0; n < this.width; ++n) {
                    nArray[n3++] = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | 0xFF000000;
                    ++n4;
                }
            }
        } else {
            n3 = 0;
            for (n2 = 0; n2 < this.height; ++n2) {
                IOUtils.readFully(inputStream, byArray, 0, this.bytePerScanLine);
                int n5 = 0;
                for (n = 0; n < this.width; ++n) {
                    nArray[n3++] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | 0xFF000000;
                    ++n5;
                }
            }
        }
        inputStream.close();
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, this.width, this.height, this.width, new int[]{0xFF0000, 65280, 255}, null);
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    private BufferedImage read32bitTrueColorBitmap2(InputStream inputStream) throws Exception {
        int n;
        int n2;
        int n3;
        LOGGER.info("32 bits bitmap color image!");
        IOUtils.skipFully(inputStream, this.bitmapHeader.dataOffSet - 54);
        int n4 = this.bytePerScanLine;
        byte[] byArray = new byte[this.bytePerScanLine];
        byte[] byArray2 = new byte[n4 * this.height];
        Arrays.fill(byArray2, (byte)-1);
        if (this.alignment == 0) {
            n3 = 0;
            for (n2 = 1; n2 <= this.height; ++n2) {
                IOUtils.readFully(inputStream, byArray);
                n3 = n4 * (this.height - n2);
                n = 0;
                while (n < n4) {
                    byArray2[n3++] = byArray[n++];
                    byArray2[n3++] = byArray[n++];
                    byArray2[n3++] = byArray[n++];
                    ++n;
                    ++n3;
                }
            }
        } else {
            n3 = 0;
            for (n2 = 0; n2 < this.height; ++n2) {
                IOUtils.readFully(inputStream, byArray);
                n = 0;
                while (n < n4) {
                    byArray2[n3++] = byArray[n++];
                    byArray2[n3++] = byArray[n++];
                    byArray2[n3++] = byArray[n++];
                    ++n;
                    ++n3;
                }
            }
        }
        inputStream.close();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        int[] nArray = new int[]{2, 1, 0, 3};
        n = 4;
        int n5 = 1;
        int[] nArray2 = new int[]{8, 8, 8, 8};
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.width, this.height, this.bytePerScanLine, n, nArray, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray2, true, false, n5, 0);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private BufferedImage readCompressedIndexColorBitmap(InputStream inputStream) throws Exception {
        Object object;
        byte[] byArray = null;
        if (this.bitsPerPixel == 8) {
            byArray = this.read256ColorCompressedBitmap(inputStream);
        } else if (this.bitsPerPixel == 4) {
            byArray = this.read16ColorCompressedBitmap(inputStream);
        } else {
            throw new IllegalArgumentException("Invalid bitsPerPixel: " + this.bitsPerPixel);
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = null;
        if (this.bitsPerPixel != 8) {
            writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, this.bitsPerPixel, null);
        } else {
            object = new int[]{0};
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.width, this.height, this.width, 1, object, null);
        }
        object = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage((ColorModel)object, writableRaster, false, null);
    }

    private BufferedImage readIndexColorBitmap(InputStream inputStream) throws Exception {
        Object object;
        int n;
        int n2;
        LOGGER.info("{} color bitmap color image!", (Object)(1 << this.bitsPerPixel));
        this.readPalette(inputStream);
        int n3 = 0;
        switch (this.bitsPerPixel) {
            case 1: {
                n3 = (32 - this.width % 32) / 8;
                break;
            }
            case 4: {
                n3 = (32 - this.width * 4 % 32) / 8;
                break;
            }
            case 8: {
                n3 = this.bytePerScanLine - this.width;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bitsPerPixel: " + this.bitsPerPixel + " for BMP indexColor image!");
            }
        }
        if (n3 == 4) {
            n3 = 0;
        }
        int n4 = this.bytePerScanLine - n3;
        byte[] byArray = new byte[this.bytePerScanLine];
        byte[] byArray2 = new byte[n4 * this.height];
        LOGGER.info("Scanline padding: {}", (Object)n3);
        if (this.alignment == 0) {
            n2 = 0;
            n = (this.height - 1) * n4;
            while (n2 < this.height) {
                IOUtils.readFully(inputStream, byArray);
                System.arraycopy(byArray, 0, byArray2, n, n4);
                ++n2;
                n -= n4;
            }
        } else {
            n2 = 0;
            n = 0;
            while (n2 < this.height) {
                IOUtils.readFully(inputStream, byArray);
                System.arraycopy(byArray, 0, byArray2, n, n4);
                ++n2;
                n += n4;
            }
        }
        inputStream.close();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        WritableRaster writableRaster = null;
        if (this.bitsPerPixel != 8) {
            writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, this.bitsPerPixel, null);
        } else {
            object = new int[]{0};
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.width, this.height, this.width, 1, object, null);
        }
        object = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage((ColorModel)object, writableRaster, false, null);
    }

    private byte[] read256ColorCompressedBitmap(InputStream inputStream) throws Exception {
        LOGGER.info("256 color bitmap color image!");
        LOGGER.info("compressed format!");
        this.readPalette(inputStream);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.height - 1;
        int n10 = 2048;
        boolean bl = false;
        byte[] byArray = new byte[n10];
        int n11 = inputStream.read(byArray, 0, n10);
        byte[] byArray2 = new byte[this.width * this.height];
        n = this.width * n9 + n8;
        do {
            int n12;
            if (n2 >= n11) {
                n11 = inputStream.read(byArray, 0, n10);
                n2 = 0;
            }
            n3 = byArray[n2++] & 0xFF;
            if (n2 >= n11) {
                n11 = inputStream.read(byArray, 0, n10);
                n2 = 0;
            }
            if (n3 == 0) {
                n4 = byArray[n2++] & 0xFF;
                if (n2 >= n11) {
                    n11 = inputStream.read(byArray, 0, n10);
                    n2 = 0;
                }
                if (n4 > 2) {
                    n5 = 0;
                    for (n12 = 1; n12 <= n4; ++n12) {
                        byArray2[n++] = byArray[n2++];
                        if (n2 >= n11) {
                            n11 = inputStream.read(byArray, 0, n10);
                            n2 = 0;
                        }
                        ++n5;
                        if (++n8 >= this.width) break;
                    }
                    if (n5 % 2 != 0) {
                        ++n2;
                    }
                }
                if (n4 == 2) {
                    LOGGER.info("found delta");
                    n7 = byArray[n2++] & 0xFF;
                    if (n2 >= n11) {
                        n11 = inputStream.read(byArray, 0, n10);
                        n2 = 0;
                    }
                    n6 = byArray[n2++] & 0xFF;
                    if (n2 >= n11) {
                        n11 = inputStream.read(byArray, 0, n10);
                        n2 = 0;
                    }
                    n = this.width * (n9 -= n6) + (n8 += n7);
                }
                if (n4 == 0) {
                    n8 = 0;
                    n = this.width * --n9 + n8;
                }
                if (n4 == 1) {
                    bl = true;
                }
            } else {
                n12 = byArray[n2++];
                if (n2 >= n11) {
                    n11 = inputStream.read(byArray, 0, n10);
                    n2 = 0;
                }
                for (int i = 0; i < n3; ++i) {
                    byArray2[n++] = n12;
                    if (++n8 >= this.width) break;
                }
            }
            if (n9 >= 0) continue;
            bl = true;
        } while (!bl);
        inputStream.close();
        return byArray2;
    }

    private byte[] read16ColorCompressedBitmap(InputStream inputStream) throws Exception {
        LOGGER.info("16 color bitmap color image!");
        LOGGER.info("compressed format!");
        this.readPalette(inputStream);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.height - 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 2048;
        boolean bl = false;
        byte[] byArray = new byte[n11];
        int n12 = inputStream.read(byArray, 0, n11);
        byte[] byArray2 = new byte[this.width * this.height];
        n2 = this.width * n4 + n3;
        do {
            int n13;
            if (n >= n12) {
                n12 = inputStream.read(byArray, 0, n11);
                n = 0;
            }
            n9 = byArray[n++] & 0xFF;
            if (n >= n12) {
                n12 = inputStream.read(byArray, 0, n11);
                n = 0;
            }
            if (n9 == 0) {
                n10 = byArray[n++] & 0xFF;
                if (n >= n12) {
                    n12 = inputStream.read(byArray, 0, n11);
                    n = 0;
                }
                if (n10 == 1) {
                    bl = true;
                }
                if (n10 == 2) {
                    LOGGER.info("found delta");
                    n5 = byArray[n++] & 0xFF;
                    if (n >= n12) {
                        n12 = inputStream.read(byArray, 0, n11);
                        n = 0;
                    }
                    n6 = byArray[n++] & 0xFF;
                    if (n >= n12) {
                        n12 = inputStream.read(byArray, 0, n11);
                        n = 0;
                    }
                    n2 = this.width * (n4 -= n6) + (n3 += n5);
                }
                if (n10 == 0) {
                    n3 = 0;
                    n2 = this.width * --n4 + n3;
                }
                if (n10 > 2) {
                    n7 = 0;
                    do {
                        n13 = byArray[n++] & 0xFF;
                        if (n >= n12) {
                            n12 = inputStream.read(byArray, 0, n11);
                            n = 0;
                        }
                        ++n7;
                        byArray2[n2++] = (byte)(n13 >>> 4 & 0xF);
                        ++n8;
                        if (++n3 >= this.width) break;
                        if (n8 >= n10) continue;
                        byArray2[n2++] = (byte)(n13 & 0xF);
                        ++n8;
                        ++n3;
                    } while (n3 < this.width && n8 < n10);
                    n8 = 0;
                    if (n7 % 2 != 0) {
                        ++n;
                    }
                }
            } else {
                n13 = byArray[n++] & 0xFF;
                if (n >= n12) {
                    n12 = inputStream.read(byArray, 0, n11);
                    n = 0;
                }
                do {
                    byArray2[n2++] = (byte)(n13 >>> 4 & 0xF);
                    ++n8;
                    if (++n3 >= this.width) break;
                    if (n8 >= n9) continue;
                    byArray2[n2++] = (byte)(n13 & 0xF);
                    ++n8;
                    if (++n3 >= this.width) break;
                } while (n8 < n9);
                n8 = 0;
            }
            if (n4 >= 0) continue;
            bl = true;
        } while (!bl);
        inputStream.close();
        return ArrayUtils.packByteArray(byArray2, this.width, 0, this.bitsPerPixel, byArray2.length);
    }

    private static class BitmapHeader {
        short signiture;
        int fileSize;
        short reserved1;
        short reserved2;
        int dataOffSet;
        int infoHeaderLen;
        int imageWidth;
        int imageHeight;
        short planes;
        short bitCount;
        int compression;
        int imageSize;
        int xResolution;
        int yResolution;
        int colorsUsed;
        int colorsImportant;

        private BitmapHeader() {
        }

        void readHeader(InputStream inputStream) throws Exception {
            int n = 0;
            byte[] byArray = new byte[18];
            IOUtils.readFully(inputStream, byArray, 0, 18);
            this.signiture = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.fileSize = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.reserved1 = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.reserved2 = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.dataOffSet = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.infoHeaderLen = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            byArray = new byte[this.infoHeaderLen - 4];
            IOUtils.readFully(inputStream, byArray, 0, this.infoHeaderLen - 4);
            n = 0;
            this.imageWidth = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.imageHeight = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.planes = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.bitCount = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.compression = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.imageSize = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.xResolution = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.yResolution = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.colorsUsed = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            this.colorsImportant = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        }
    }
}

